/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/

#include "REAL.H"
#include "CONSTANTS.H"
#include "GRID_F.H"
#include "BCTypes.H"

#define DIMS lo_1,lo_2,hi_1,hi_2

c *************************************************************************
c ** MKSCAFLUX **
c ** Create the time-centered edge states for scalars
c ***************************************************************

      subroutine FORT_MKSCAFLUX(s,sedgex,sedgey,slopex,slopey,
     $                          uadv,vadv,utrans,vtrans,
     $                          u,diff,force,s_l,s_r,s_b,s_t,DIMS,
     $                          dx,dt,bcx_lo,bcx_hi,bcy_lo,bcy_hi,numqty)

      implicit none

      integer DIMS
      integer numqty
      REAL_T       s(lo_1-1:hi_1+1,lo_2-1:hi_2+1,numqty)
      REAL_T  sedgex(lo_1-1:hi_1+1,lo_2-1:hi_2+1,numqty)
      REAL_T  sedgey(lo_1-1:hi_1+1,lo_2-1:hi_2+1,numqty)
      REAL_T  slopex(lo_1-1:hi_1+1,lo_2-1:hi_2+1,numqty)
      REAL_T  slopey(lo_1-1:hi_1+1,lo_2-1:hi_2+1,numqty)
      REAL_T    uadv(lo_1:hi_1+1,lo_2:hi_2  )
      REAL_T    vadv(lo_1:hi_1  ,lo_2:hi_2+1)
      REAL_T  utrans(lo_1:hi_1+1,lo_2:hi_2  )
      REAL_T  vtrans(lo_1:hi_1  ,lo_2:hi_2+1)
      REAL_T       u(lo_1-1:hi_1+1,lo_2-1:hi_2+1,2)
      REAL_T    diff(lo_1-1:hi_1+1,lo_2-1:hi_2+1,numqty)
      REAL_T   force(lo_1-1:hi_1+1,lo_2-1:hi_2+1,numqty)
      REAL_T     s_l(lo_1:hi_1+1)
      REAL_T     s_r(lo_1:hi_1+1)
      REAL_T     s_b(lo_2:hi_2+1)
      REAL_T     s_t(lo_2:hi_2+1)
      REAL_T dx(2)
      REAL_T dt
      integer bcx_lo, bcx_hi
      integer bcy_lo, bcy_hi

c     Local variables
      REAL_T savg
      REAL_T sUp1
      REAL_T sUp2
      REAL_T hx
      REAL_T hy
      integer i,j,n, is, ie, js, je

      REAL_T eps
      eps = 1.0e-8

      hx = dx(1)
      hy = dx(2)
      is = lo_1
      ie = hi_1
      js = lo_2
      je = hi_2

c ::: First do s^(n+1/2) on the (i+1/2) boundaries.

      do n = 1, numqty
      do j = js,je 
        do i = is,ie 

          sUp1 = cvmgp(  s(i,j,n) , s(i,j+1,n), vtrans(i,j+1))
          savg = half * (s(i,j,n) + s(i,j+1,n))
          sUp1 = cvmgt(sUp1, savg, abs(vtrans(i,j+1)) .gt. eps)

          sUp2 = cvmgp(  s(i,j-1,n) , s(i,j,n), vtrans(i,j  ))
          savg = half * (s(i,j-1,n) + s(i,j,n))
          sUp2 = cvmgt(sUp2, savg, abs(vtrans(i,j)) .gt. eps)

          s_l(i+1) = s(i,j,n) + 
     $      half*(one - u(i,j,1)*dt/hx)*slopex(i,j,n) - 
     $      half*dt*u(i,j,2)*(sUp1 - sUp2)/hy +
     $      half*dt*(diff(i,j,n) + force(i,j,n))

          s_r(i  ) = s(i,j,n) - 
     $      half*(one + u(i,j,1)*dt/hx)*slopex(i,j,n) -
     $      half*dt*u(i,j,2)*(sUp1 - sUp2)/hy +
     $      half*dt*(diff(i,j,n)+force(i,j,n))

        enddo

        if (bcx_lo .eq. PERIODIC) then
          s_l(is  ) = s_l(ie+1)
        elseif (bcx_lo .eq. WALL) then
          s_l(is  ) = s_r(is  )
        elseif (bcx_lo .eq. INLET ) then
          s_l(is  ) = s(is-1,j,n)
        elseif (bcx_lo .eq. OUTLET ) then
          s_l(is  ) = s_r(is  )
        endif

        if (bcx_hi .eq. PERIODIC) then
          s_r(ie+1) = s_r(is  )
        elseif (bcx_hi .eq. WALL) then
          s_r(ie+1) = s_l(ie+1)
        elseif (bcx_hi .eq. INLET ) then
          s_r(ie+1) = s(ie+1,j,n)
        elseif (bcx_hi .eq. OUTLET ) then
          s_r(ie+1) = s_l(ie+1)
        endif

        do i = is,ie+1 

          sedgex(i,j,n)= cvmgp(s_l(i),s_r(i),uadv(i,j))
          savg = half*(s_l(i) + s_r(i))
          sedgex(i,j,n) = cvmgp(savg,sedgex(i,j,n),eps-abs(uadv(i,j)))

        enddo
      enddo

c ::: Now do s^(n+1/2) on the (j+1/2) boundaries.

      do i = is,ie 
        do j = js,je 

          sUp1 = cvmgp(  s(i,j,n) , s(i+1,j,n),utrans(i+1,j))
          savg = half * (s(i,j,n) + s(i+1,j,n))
          sUp1 = cvmgt(sUp1, savg, abs(utrans(i+1,j)) .gt. eps)

          sUp2 = cvmgp(  s(i-1,j,n) , s(i,j,n),utrans(i  ,j))
          savg = half * (s(i-1,j,n) + s(i,j,n))
          sUp2 = cvmgt(sUp2, savg, abs(utrans(i,j)) .gt. eps)

          s_b(j+1) = s(i,j,n) + 
     $       half*(one - u(i,j,2)*dt/hy)*slopey(i,j,n) - 
     $       half*dt*u(i,j,1)*(sUp1 - sUp2)/hx +
     $       half*dt*(diff(i,j,n)+force(i,j,n))

          s_t(j  ) = s(i,j,n) - 
     $       half*(one + u(i,j,2)*dt/hy)*slopey(i,j,n) -
     $       half*dt*u(i,j,1)*(sUp1 - sUp2)/hx +
     $       half*dt*(diff(i,j,n)+force(i,j,n))

        enddo

        if (bcy_lo .eq. PERIODIC) then
          s_b(js  ) = s_b(je+1)
        elseif (bcy_lo .eq. WALL ) then
          s_b(js  ) = s_t(js  )
        elseif (bcy_lo .eq. INLET ) then
          s_b(js  ) = s(i,js-1,n)
        elseif (bcy_lo .eq. OUTLET ) then
          s_b(js  ) = s_t(js  )
        endif

        if (bcy_hi .eq. PERIODIC) then
          s_t(je+1) = s_t(js  )
        elseif (bcy_hi .eq. WALL ) then
          s_t(je+1) = s_b(je+1)
        elseif (bcy_hi .eq. INLET ) then
          s_t(je+1) = s(i,je+1,n)
        elseif (bcy_hi .eq. OUTLET ) then
          s_t(je+1) = s_b(je+1)
        endif

        do j = js, je+1 

          sedgey(i,j,n) = cvmgp(s_b(j),s_t(j),vadv(i,j))
          savg = half*(s_b(j) + s_t(j))
          sedgey(i,j,n) = cvmgp(savg,sedgey(i,j,n),eps-abs(vadv(i,j)))

        enddo
      enddo

      enddo

      return
      end
