//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Mask/PolygonPointView.h
//! @brief     Defines PolygonPointView class
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_MASK_POLYGONPOINTVIEW_H
#define BORNAGAIN_GUI_VIEW_MASK_POLYGONPOINTVIEW_H

#include "GUI/View/Mask/IShape2DView.h"

class PolygonPointItem;

//! This is a View of polygon point for PolygonMaskItem

class PolygonPointView : public IShape2DView {
    Q_OBJECT

public:
    int type() const override { return MaskEditorHelper::POLYGONPOINT; }

    explicit PolygonPointView(PolygonPointItem* item);

    QRectF boundingRect() const override;

    MaskItemObject* parameterizedItem() const override;

    void updateParameterizedItem(const QPointF& pos);

signals:
    void closePolygonRequest(bool);
    void propertyChanged();

protected slots:
    void update_view() override;
    void onPropertyChange() override;

protected:
    void paint(QPainter* painter, const QStyleOptionGraphicsItem*, QWidget*) override;
    void mouseMoveEvent(QGraphicsSceneMouseEvent* event) override;
    void hoverEnterEvent(QGraphicsSceneHoverEvent* event) override;
    void hoverLeaveEvent(QGraphicsSceneHoverEvent* event) override;

private:
    PolygonPointItem* m_item;
    bool m_on_hover;
};

#endif // BORNAGAIN_GUI_VIEW_MASK_POLYGONPOINTVIEW_H
