// $Id:
// FORESTER -- software libraries and applications
// for evolutionary biology research and applications.
//
// Copyright (C) 2008-2009 Christian M. Zmasek
// Copyright (C) 2008-2009 Burnham Institute for Medical Research
// All rights reserved
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
//
// Contact: phylosoft @ gmail . com
// WWW: https://sites.google.com/site/cmzmasek/home/software/forester

package org.forester.io.parsers.nexus;

public final class NexusConstants {

    public final static String NEXUS            = "#NEXUS";
    public final static String BEGIN_TAXA       = "Begin Taxa;";
    public final static String BEGIN_TREES      = "Begin Trees;";
    public final static String TREE             = "Tree";
    public final static String DIMENSIONS       = "Dimensions";
    public final static String NTAX             = "NTax";
    public final static String NCHAR            = "NChar";
    public final static String TAXLABELS        = "TaxLabels";
    public final static String CHARSTATELABELS  = "CharStateLabels";
    public final static String END              = "End;";
    public final static String MATRIX           = "Matrix";
    public final static String BEGIN_CHARACTERS = "Begin Characters;";
    public final static String BEGIN_DATA       = "Begin Data;";
    public final static String FORMAT           = "Format";
    public final static String DATATYPE         = "DataType";
    public final static String STANDARD         = "Standard";
    public final static String SYMBOLS          = "Symbols";
    public static final String TRANSLATE        = "Translate";
    public static final String UTREE            = "UTREE";
}
