/* errno.h - error code decls for libpiw
 *
 * author(s): Tom Lord
 ****************************************************************
 * Copyright (C) 1998 UUNET Technologies, Inc.
 *
 * See the file "COPYING.PIW" for further information
 * about the copyright status of this work.
 */

#ifndef INCLUDE__PIW__ERRNO_H
#define INCLUDE__PIW__ERRNO_H



#include "hackerlab/machine/types.h"



extern t_uchar *piw_error_msg[];

#define PIW_ERRNO_LIST \
  PIW_ERRNO(piw_enoerror, "no error") \
  PIW_ERRNO(piw_etoolate, "parameter change too late") \
  PIW_ERRNO(piw_espace, "out of memory") \
  PIW_ERRNO(piw_esize, "absurd allocation size") \
  PIW_ERRNO(piw_emalloc_header, "corrupted malloc header or not a malloced region")


enum piw_errno
{
#undef PIW_ERRNO
#define PIW_ERRNO(A,B)	A,
  PIW_ERRNO_LIST
};



/* automatically generated __STDC__ prototypes */
#endif  /* INCLUDE__PIW__ERRNO_H */
