<?php
// This file was auto-generated from sdk-root/src/data/acm/2015-12-08/api-2.json
return [ 'version' => '2.0', 'metadata' => [ 'apiVersion' => '2015-12-08', 'endpointPrefix' => 'acm', 'jsonVersion' => '1.1', 'serviceAbbreviation' => 'ACM', 'serviceFullName' => 'AWS Certificate Manager', 'signatureVersion' => 'v4', 'targetPrefix' => 'CertificateManager', 'protocol' => 'json', ], 'operations' => [ 'DeleteCertificate' => [ 'name' => 'DeleteCertificate', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DeleteCertificateRequest', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', 'exception' => true, ], [ 'shape' => 'ResourceInUseException', 'exception' => true, ], [ 'shape' => 'InvalidArnException', 'exception' => true, ], ], ], 'DescribeCertificate' => [ 'name' => 'DescribeCertificate', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DescribeCertificateRequest', ], 'output' => [ 'shape' => 'DescribeCertificateResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', 'exception' => true, ], [ 'shape' => 'InvalidArnException', 'exception' => true, ], ], ], 'GetCertificate' => [ 'name' => 'GetCertificate', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'GetCertificateRequest', ], 'output' => [ 'shape' => 'GetCertificateResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', 'exception' => true, ], [ 'shape' => 'RequestInProgressException', 'exception' => true, ], [ 'shape' => 'InvalidArnException', 'exception' => true, ], ], ], 'ListCertificates' => [ 'name' => 'ListCertificates', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListCertificatesRequest', ], 'output' => [ 'shape' => 'ListCertificatesResponse', ], ], 'RequestCertificate' => [ 'name' => 'RequestCertificate', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'RequestCertificateRequest', ], 'output' => [ 'shape' => 'RequestCertificateResponse', ], 'errors' => [ [ 'shape' => 'LimitExceededException', 'exception' => true, ], [ 'shape' => 'InvalidDomainValidationOptionsException', 'exception' => true, ], ], ], 'ResendValidationEmail' => [ 'name' => 'ResendValidationEmail', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ResendValidationEmailRequest', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', 'exception' => true, ], [ 'shape' => 'InvalidStateException', 'exception' => true, ], [ 'shape' => 'InvalidArnException', 'exception' => true, ], [ 'shape' => 'InvalidDomainValidationOptionsException', 'exception' => true, ], ], ], ], 'shapes' => [ 'Arn' => [ 'type' => 'string', 'min' => 20, 'max' => 2048, 'pattern' => 'arn:[\\w+=/,.@-]+:[\\w+=/,.@-]+:[\\w+=/,.@-]*:[0-9]+:[\\w+=,.@-]+(/[\\w+=/,.@-]+)*', ], 'CertificateBody' => [ 'type' => 'string', 'min' => 1, 'max' => 524288, 'pattern' => '-{5}BEGIN CERTIFICATE-{5}\\u000D?\\u000A([A-Za-z0-9/+]{64}\\u000D?\\u000A)*[A-Za-z0-9/+]{1,64}={0,2}\\u000D?\\u000A-{5}END CERTIFICATE-{5}(\\u000D?\\u000A)?', ], 'CertificateChain' => [ 'type' => 'string', 'min' => 1, 'max' => 2097152, 'pattern' => '(-{5}BEGIN CERTIFICATE-{5}\\u000D?\\u000A([A-Za-z0-9/+]{64}\\u000D?\\u000A)*[A-Za-z0-9/+]{1,64}={0,2}\\u000D?\\u000A-{5}END CERTIFICATE-{5}\\u000D?\\u000A)*-{5}BEGIN CERTIFICATE-{5}\\u000D?\\u000A([A-Za-z0-9/+]{64}\\u000D?\\u000A)*[A-Za-z0-9/+]{1,64}={0,2}\\u000D?\\u000A-{5}END CERTIFICATE-{5}(\\u000D?\\u000A)?', ], 'CertificateDetail' => [ 'type' => 'structure', 'members' => [ 'CertificateArn' => [ 'shape' => 'Arn', ], 'DomainName' => [ 'shape' => 'DomainNameString', ], 'SubjectAlternativeNames' => [ 'shape' => 'DomainList', ], 'DomainValidationOptions' => [ 'shape' => 'DomainValidationList', ], 'Serial' => [ 'shape' => 'String', ], 'Subject' => [ 'shape' => 'String', ], 'Issuer' => [ 'shape' => 'String', ], 'CreatedAt' => [ 'shape' => 'TStamp', ], 'IssuedAt' => [ 'shape' => 'TStamp', ], 'Status' => [ 'shape' => 'CertificateStatus', ], 'RevokedAt' => [ 'shape' => 'TStamp', ], 'RevocationReason' => [ 'shape' => 'RevocationReason', ], 'NotBefore' => [ 'shape' => 'TStamp', ], 'NotAfter' => [ 'shape' => 'TStamp', ], 'KeyAlgorithm' => [ 'shape' => 'KeyAlgorithm', ], 'SignatureAlgorithm' => [ 'shape' => 'String', ], 'InUseBy' => [ 'shape' => 'InUseList', ], ], ], 'CertificateStatus' => [ 'type' => 'string', 'enum' => [ 'PENDING_VALIDATION', 'ISSUED', 'INACTIVE', 'EXPIRED', 'VALIDATION_TIMED_OUT', 'REVOKED', 'FAILED', ], ], 'CertificateStatuses' => [ 'type' => 'list', 'member' => [ 'shape' => 'CertificateStatus', ], ], 'CertificateSummary' => [ 'type' => 'structure', 'members' => [ 'CertificateArn' => [ 'shape' => 'Arn', ], 'DomainName' => [ 'shape' => 'DomainNameString', ], ], ], 'CertificateSummaryList' => [ 'type' => 'list', 'member' => [ 'shape' => 'CertificateSummary', ], ], 'DeleteCertificateRequest' => [ 'type' => 'structure', 'required' => [ 'CertificateArn', ], 'members' => [ 'CertificateArn' => [ 'shape' => 'Arn', ], ], ], 'DescribeCertificateRequest' => [ 'type' => 'structure', 'required' => [ 'CertificateArn', ], 'members' => [ 'CertificateArn' => [ 'shape' => 'Arn', ], ], ], 'DescribeCertificateResponse' => [ 'type' => 'structure', 'members' => [ 'Certificate' => [ 'shape' => 'CertificateDetail', ], ], ], 'DomainList' => [ 'type' => 'list', 'member' => [ 'shape' => 'DomainNameString', ], 'min' => 1, 'max' => 1000, ], 'DomainNameString' => [ 'type' => 'string', 'min' => 1, 'max' => 253, 'pattern' => '^(\\*\\.)?(((?!-)[A-Za-z0-9-]{0,62}[A-Za-z0-9])\\.)+((?!-)[A-Za-z0-9-]{1,62}[A-Za-z0-9])$', ], 'DomainValidation' => [ 'type' => 'structure', 'required' => [ 'DomainName', ], 'members' => [ 'DomainName' => [ 'shape' => 'DomainNameString', ], 'ValidationEmails' => [ 'shape' => 'ValidationEmailList', ], 'ValidationDomain' => [ 'shape' => 'DomainNameString', ], ], ], 'DomainValidationList' => [ 'type' => 'list', 'member' => [ 'shape' => 'DomainValidation', ], 'min' => 1, 'max' => 1000, ], 'DomainValidationOption' => [ 'type' => 'structure', 'required' => [ 'DomainName', 'ValidationDomain', ], 'members' => [ 'DomainName' => [ 'shape' => 'DomainNameString', ], 'ValidationDomain' => [ 'shape' => 'DomainNameString', ], ], ], 'DomainValidationOptionList' => [ 'type' => 'list', 'member' => [ 'shape' => 'DomainValidationOption', ], 'min' => 1, 'max' => 1000, ], 'GetCertificateRequest' => [ 'type' => 'structure', 'required' => [ 'CertificateArn', ], 'members' => [ 'CertificateArn' => [ 'shape' => 'Arn', ], ], ], 'GetCertificateResponse' => [ 'type' => 'structure', 'members' => [ 'Certificate' => [ 'shape' => 'CertificateBody', ], 'CertificateChain' => [ 'shape' => 'CertificateChain', ], ], ], 'IdempotencyToken' => [ 'type' => 'string', 'min' => 1, 'max' => 32, 'pattern' => '\\w+', ], 'InUseList' => [ 'type' => 'list', 'member' => [ 'shape' => 'String', ], ], 'InvalidArnException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'exception' => true, ], 'InvalidDomainValidationOptionsException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'exception' => true, ], 'InvalidStateException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'exception' => true, ], 'KeyAlgorithm' => [ 'type' => 'string', 'enum' => [ 'RSA_2048', 'EC_prime256v1', ], ], 'LimitExceededException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'exception' => true, ], 'ListCertificatesRequest' => [ 'type' => 'structure', 'members' => [ 'CertificateStatuses' => [ 'shape' => 'CertificateStatuses', ], 'NextToken' => [ 'shape' => 'NextToken', ], 'MaxItems' => [ 'shape' => 'MaxItems', ], ], ], 'ListCertificatesResponse' => [ 'type' => 'structure', 'members' => [ 'NextToken' => [ 'shape' => 'NextToken', ], 'CertificateSummaryList' => [ 'shape' => 'CertificateSummaryList', ], ], ], 'MaxItems' => [ 'type' => 'integer', 'min' => 1, 'max' => 1000, ], 'NextToken' => [ 'type' => 'string', 'min' => 1, 'max' => 320, 'pattern' => '[\\u0009\\u000A\\u000D\\u0020-\\u00FF]*', ], 'RequestCertificateRequest' => [ 'type' => 'structure', 'required' => [ 'DomainName', ], 'members' => [ 'DomainName' => [ 'shape' => 'DomainNameString', ], 'SubjectAlternativeNames' => [ 'shape' => 'DomainList', ], 'IdempotencyToken' => [ 'shape' => 'IdempotencyToken', ], 'DomainValidationOptions' => [ 'shape' => 'DomainValidationOptionList', ], ], ], 'RequestCertificateResponse' => [ 'type' => 'structure', 'members' => [ 'CertificateArn' => [ 'shape' => 'Arn', ], ], ], 'RequestInProgressException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'exception' => true, ], 'ResendValidationEmailRequest' => [ 'type' => 'structure', 'required' => [ 'CertificateArn', 'Domain', 'ValidationDomain', ], 'members' => [ 'CertificateArn' => [ 'shape' => 'Arn', ], 'Domain' => [ 'shape' => 'DomainNameString', ], 'ValidationDomain' => [ 'shape' => 'DomainNameString', ], ], ], 'ResourceInUseException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'exception' => true, ], 'ResourceNotFoundException' => [ 'type' => 'structure', 'members' => [ 'message' => [ 'shape' => 'String', ], ], 'exception' => true, ], 'RevocationReason' => [ 'type' => 'string', 'enum' => [ 'UNSPECIFIED', 'KEY_COMPROMISE', 'CA_COMPROMISE', 'AFFILIATION_CHANGED', 'SUPERCEDED', 'CESSATION_OF_OPERATION', 'CERTIFICATE_HOLD', 'REMOVE_FROM_CRL', 'PRIVILEGE_WITHDRAWN', 'A_A_COMPROMISE', ], ], 'String' => [ 'type' => 'string', ], 'TStamp' => [ 'type' => 'timestamp', ], 'ValidationEmailList' => [ 'type' => 'list', 'member' => [ 'shape' => 'String', ], ], ],];
