function nopara(opt, te, statut, ipar)
    implicit none
    character(len=8) :: nopara
!
! ======================================================================
! COPYRIGHT (C) 1991 - 2012  EDF R&D                  WWW.CODE-ASTER.ORG
! THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
! IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
! THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
! (AT YOUR OPTION) ANY LATER VERSION.
!
! THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
! WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
! MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
! GENERAL PUBLIC LICENSE FOR MORE DETAILS.
!
! YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
! ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
!    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
! ======================================================================
! person_in_charge: jacques.pellet at edf.fr
!     ARGUMENTS:
!     ----------
#include "jeveux.h"
#include "asterfort/assert.h"
    integer :: opt, te, ipar
    character(len=3) :: statut
! ----------------------------------------------------------------------
!     ENTREES:
!     OPT    : OPTION
!     TE     : TYPE_ELEMENT
!     STATUT : IN/OUT
!     IPAR   : NUMERO DU CHAMP PARAMETRE DANS L'OPTION
!
!     SORTIES:
!     NOPARA : NOM DU PARAMETRE DANS L'OPTION
!
! ----------------------------------------------------------------------
    common /caii02/iaoptt,lgco,iaopmo,ilopmo,iaopno,ilopno,iaopds,&
     &       iaoppa,npario,nparin,iamloc,ilmloc,iadsgd
!
!
!     VARIABLES LOCALES:
!     ------------------
    integer :: nbin, optmod, optnom
    integer :: iadsgd, iamloc, iaopds, iaopmo, iaopno, iaoppa, iaoptt, ilmloc
    integer :: ilopmo, ilopno, jj, lgco, nparin, npario
!
! DEB-------------------------------------------------------------------
!
!
!     JJ = IOPTTE(OPT,TE)
    jj = zi(iaoptt-1+ (te-1)*lgco+opt)
    optmod = iaopmo + zi(ilopmo-1+jj) - 1
    optnom = iaopno + zi(ilopno-1+jj) - 1
    if (statut .eq. 'IN ') then
        nopara = zk8(optnom-1+ipar)
    else
        call assert(statut.eq.'OUT')
        nbin = zi(optmod-1+2)
        nopara = zk8(optnom-1+nbin+ipar)
    endif
end function
