#
# The Genstory script from the AOLserver Tcl
# Documentation
#
# Example 3a: Form generation and handling
#
# Two functions are registered. One generates and
# returns an HTML form, and the other processes
# the data in the form.
#
# Things to notice:
#
# * Different functions are registered to the same
#   URL with different methods.  Note that some browsers
#   do not cache results properly when you do this.
#
# * The genstory function returns an error status
#   (500) if the client doesn't pass in any form data.
#
# * Form data is stored in an ns_set, and accessed
#   like any other set (e.g., header data).
#
# * A counter is used to loop through all the key
#   value pairs in the form.
    
ns_register_proc GET /genstory genstoryform
ns_register_proc POST /genstory genstory
   
proc genstoryform {conn context} {
   	ns_return $conn 200 text/html \
    	"<HTML>
    	<HEAD>
	<TITLE>Automatic Story Generator</TITLE>
	</HEAD>
	<BODY>
    	<H1>
	Automatic Story Generator
    	</H1>
	<FORM ACTION=http://localhost/genstory
		METHOD=POST>
    	Noun: <INPUT TYPE=text NAME=noun1><BR>
    	Noun: <INPUT TYPE=text NAME=noun2><BR>
	Name: <INPUT TYPE=text NAME=name1><BR>
	Name: <INPUT TYPE=text NAME=name2><BR>
	Adjective: <INPUT TYPE=text NAME=adjective1><BR>
	Adjective: <INPUT TYPE=text NAME=adjective2><BR>
	Verb: <INPUT TYPE=text NAME=verb1><BR>
	Verb: <INPUT TYPE=text NAME=verb2><BR>
	<P><INPUT TYPE=submit VALUE=\"Generate\">
	<P><P>Note:  The form you are filling out was generated
	dynamically.  No cgi-bin was used for this, and no separate
	process was started.  All of this is happening within a thread
	of the AOLserver process.
    	</FORM>
	<P>
    	</BODY></HTML>"
}
    
proc genstory {conn ignore}  {
	set formdata [ns_conn form $conn]
 
    	if {$formdata == ""}  {
		ns_return $conn 200 text/plain "Need form data!"
		return
	}

	# Build up a human-readable representation of the form data.
	set hrformdata "<dl>"
	set size [ns_set size $formdata]
	for {set i 0} {$i < $size} {incr i}  {
		append hrformdata "<dt>[ns_set key $formdata $i]</dt>\
			<dd>[ns_set value $formdata $i]</dd>"
	}
	append hrformdata "</dl>"

    	ns_return $conn 200 text/html \
	"<HTML>
	<HEAD>
	<TITLE>The story of [ns_set get $formdata name1] and
	[ns_set get $formdata name2]</TITLE>
	</HEAD>
	<BODY>
	<H1>
	The story of [ns_set get $formdata name1] and
	[ns_set get $formdata name2]
	</H1>
	<P>Once upon a time [ns_set get $formdata name1] and
	[ns_set get $formdata name2] went for a 
	walk in the woods looking for a [ns_set get $formdata noun1].
	[ns_set get $formdata name1] was 
	feeling [ns_set get $formdata adjective1] because
	[ns_set get $formdata name2] was so
	[ns_set get $formdata adjective2].  So
	[ns_set get $formdata name1] decided to
	[ns_set get $formdata verb1] [ns_set get $formdata name2]
	with a [ns_set get $formdata noun2].  This made
	[ns_set get $formdata name2] [ns_set get $formdata verb2]
	[ns_set get $formdata name1].
	<P><CENTER>The End</CENTER>
	The form data that made this possible:<BR>
	$hrformdata
	</BODY></HTML>"
}
