/* Generated By:JavaCC: Do not edit this line. NexusParser.java */
package es.uvigo.ei.sing.alter.parser;

import es.uvigo.ei.sing.alter.types.Nexus;
import es.uvigo.ei.sing.alter.types.NexusSequence;
import java.io.StringReader;
import java.util.Vector;

/**
* NEXUS format parser.
* @author Daniel Gomez Blanco
* @version 1.3
*/
public class NexusParser implements NexusParserConstants {
  /**
  * Static method that parses an input string and returns a MSA in NEXUS format.
  * @param in Input string.
  * @return MSA in NEXUS format.
  */
  public static Nexus parseMSA (String in) throws ParseException
    {
        //Parse string and return MSA
        NexusParser parser = new NexusParser(new StringReader(in));
        return parser.Nexus();
    }

/**
* Grammar's root production. Structure:<br>
* &nbsp;&nbsp;1. Any combination of spaces, tabs and new lines until "#NEXUS".<br>
* &nbsp;&nbsp;2. "#NEXUS".<br>
* &nbsp;&nbsp;3. Any combination of characters until "BEGIN DATA;".<br>
* &nbsp;&nbsp;4. "BEGIN DATA;"<br>
* &nbsp;&nbsp;5. Any combination of characters until "ntax=".<br>
* &nbsp;&nbsp;6. "ntax=" followed by the taxa number (number of sequences in the MSA),
* "nchar=" followed by the sequences length and ";".<br>
* &nbsp;&nbsp;7. Any character until "datatype=".<br>
* &nbsp;&nbsp;8. "datatype=" followed by the MSA type.<br>
* &nbsp;&nbsp;9. Any character until "matrix".<br>
* &nbsp;&nbsp;10. Sequences in NEXUS format:<br>
* &nbsp;&nbsp;&nbsp;&nbsp;10a. Sequence identifier.<br>
* &nbsp;&nbsp;&nbsp;&nbsp;10a. Data line.<br>
* &nbsp;&nbsp;11. ";".<br>
* &nbsp;&nbsp;12. "end;".<br>
* &nbsp;&nbsp;13. Any combination of characters until the end of file.<br>
* @return MSA in NEXUS format.
*/
  final public Nexus Nexus() throws ParseException {
    Vector<NexusSequence> seqs = new Vector<NexusSequence>();
    int taxa = 0,length = 0;
    String id, data;
    String type = "";
    int cont = 0;
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EOL:
      case BLANK:
        ;
        break;
      default:
        jj_la1[0] = jj_gen;
        break label_1;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EOL:
        jj_consume_token(EOL);
        break;
      case BLANK:
        jj_consume_token(BLANK);
        break;
      default:
        jj_la1[1] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(10);
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EOL:
      case BLANK:
      case UPPER_CASE:
      case LOWER_CASE:
      case NUMBER:
      case ANY:
      case 10:
      case 11:
      case 12:
      case 13:
      case 14:
      case 15:
      case 16:
      case 17:
      case 18:
      case 19:
      case 20:
      case 21:
      case 22:
        ;
        break;
      default:
        jj_la1[2] = jj_gen;
        break label_2;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UPPER_CASE:
        jj_consume_token(UPPER_CASE);
        break;
      case LOWER_CASE:
        jj_consume_token(LOWER_CASE);
        break;
      case NUMBER:
        jj_consume_token(NUMBER);
        break;
      case ANY:
        jj_consume_token(ANY);
        break;
      case 11:
        jj_consume_token(11);
        break;
      case 12:
        jj_consume_token(12);
        break;
      case 13:
        jj_consume_token(13);
        break;
      case 14:
        jj_consume_token(14);
        break;
      case BLANK:
        jj_consume_token(BLANK);
        break;
      case EOL:
        jj_consume_token(EOL);
        break;
      case 10:
        jj_consume_token(10);
        break;
      case 15:
        jj_consume_token(15);
        break;
      case 16:
        jj_consume_token(16);
        break;
      case 17:
        jj_consume_token(17);
        break;
      case 18:
        jj_consume_token(18);
        break;
      case 19:
        jj_consume_token(19);
        break;
      case 20:
        jj_consume_token(20);
        break;
      case 21:
        jj_consume_token(21);
        break;
      case 22:
        jj_consume_token(22);
        break;
      default:
        jj_la1[3] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 23:
      jj_consume_token(23);
      jj_consume_token(11);
      label_3:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case EOL:
        case BLANK:
        case UPPER_CASE:
        case LOWER_CASE:
        case NUMBER:
        case ANY:
        case 11:
        case 12:
        case 13:
        case 14:
        case 20:
        case 21:
        case 22:
          ;
          break;
        default:
          jj_la1[4] = jj_gen;
          break label_3;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case UPPER_CASE:
          jj_consume_token(UPPER_CASE);
          break;
        case LOWER_CASE:
          jj_consume_token(LOWER_CASE);
          break;
        case NUMBER:
          jj_consume_token(NUMBER);
          break;
        case ANY:
          jj_consume_token(ANY);
          break;
        case 11:
          jj_consume_token(11);
          break;
        case 12:
          jj_consume_token(12);
          break;
        case 13:
          jj_consume_token(13);
          break;
        case 14:
          jj_consume_token(14);
          break;
        case BLANK:
          jj_consume_token(BLANK);
          break;
        case EOL:
          jj_consume_token(EOL);
          break;
        case 20:
          jj_consume_token(20);
          break;
        case 21:
          jj_consume_token(21);
          break;
        case 22:
          jj_consume_token(22);
          break;
        default:
          jj_la1[5] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      label_4:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case 15:
          jj_consume_token(15);
          label_5:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case BLANK:
              ;
              break;
            default:
              jj_la1[6] = jj_gen;
              break label_5;
            }
            jj_consume_token(BLANK);
          }
          jj_consume_token(20);
          label_6:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case BLANK:
              ;
              break;
            default:
              jj_la1[7] = jj_gen;
              break label_6;
            }
            jj_consume_token(BLANK);
          }
          taxa = Number();
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case EOL:
            jj_consume_token(EOL);
            break;
          case BLANK:
            jj_consume_token(BLANK);
            break;
          case 11:
            jj_consume_token(11);
            break;
          default:
            jj_la1[8] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
        case 16:
          jj_consume_token(16);
          label_7:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case BLANK:
              ;
              break;
            default:
              jj_la1[9] = jj_gen;
              break label_7;
            }
            jj_consume_token(BLANK);
          }
          jj_consume_token(20);
          label_8:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case BLANK:
              ;
              break;
            default:
              jj_la1[10] = jj_gen;
              break label_8;
            }
            jj_consume_token(BLANK);
          }
          length = Number();
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case EOL:
            jj_consume_token(EOL);
            break;
          case BLANK:
            jj_consume_token(BLANK);
            break;
          case 11:
            jj_consume_token(11);
            break;
          default:
            jj_la1[11] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
        case 17:
          jj_consume_token(17);
          label_9:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case BLANK:
              ;
              break;
            default:
              jj_la1[12] = jj_gen;
              break label_9;
            }
            jj_consume_token(BLANK);
          }
          jj_consume_token(20);
          label_10:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case BLANK:
              ;
              break;
            default:
              jj_la1[13] = jj_gen;
              break label_10;
            }
            jj_consume_token(BLANK);
          }
          type = Type();
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case EOL:
            jj_consume_token(EOL);
            break;
          case BLANK:
            jj_consume_token(BLANK);
            break;
          case 11:
            jj_consume_token(11);
            break;
          default:
            jj_la1[14] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
        default:
          jj_la1[15] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        label_11:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case EOL:
          case BLANK:
          case UPPER_CASE:
          case LOWER_CASE:
          case NUMBER:
          case ANY:
          case 11:
          case 12:
          case 13:
          case 14:
          case 20:
          case 21:
          case 22:
            ;
            break;
          default:
            jj_la1[16] = jj_gen;
            break label_11;
          }
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case UPPER_CASE:
            jj_consume_token(UPPER_CASE);
            break;
          case LOWER_CASE:
            jj_consume_token(LOWER_CASE);
            break;
          case NUMBER:
            jj_consume_token(NUMBER);
            break;
          case ANY:
            jj_consume_token(ANY);
            break;
          case 11:
            jj_consume_token(11);
            break;
          case 12:
            jj_consume_token(12);
            break;
          case 13:
            jj_consume_token(13);
            break;
          case 14:
            jj_consume_token(14);
            break;
          case BLANK:
            jj_consume_token(BLANK);
            break;
          case EOL:
            jj_consume_token(EOL);
            break;
          case 20:
            jj_consume_token(20);
            break;
          case 21:
            jj_consume_token(21);
            break;
          case 22:
            jj_consume_token(22);
            break;
          default:
            jj_la1[17] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case 15:
        case 16:
        case 17:
          ;
          break;
        default:
          jj_la1[18] = jj_gen;
          break label_4;
        }
      }
                if (taxa == 0)
                    {if (true) throw new ParseException("Number of sequences (ntax) missing in NEXUS header.");}
                if (length == 0)
                    {if (true) throw new ParseException("Sequences length (nchar) missing in NEXUS header.");}
                if (type.isEmpty())
                    {if (true) throw new ParseException("MSA type (datatype) missing in NEXUS header.");}
      break;
    case 24:
      jj_consume_token(24);
      jj_consume_token(11);
      label_12:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case EOL:
        case BLANK:
        case UPPER_CASE:
        case LOWER_CASE:
        case NUMBER:
        case ANY:
        case 11:
        case 12:
        case 13:
        case 14:
        case 20:
        case 21:
        case 22:
          ;
          break;
        default:
          jj_la1[19] = jj_gen;
          break label_12;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case UPPER_CASE:
          jj_consume_token(UPPER_CASE);
          break;
        case LOWER_CASE:
          jj_consume_token(LOWER_CASE);
          break;
        case NUMBER:
          jj_consume_token(NUMBER);
          break;
        case ANY:
          jj_consume_token(ANY);
          break;
        case 11:
          jj_consume_token(11);
          break;
        case 12:
          jj_consume_token(12);
          break;
        case 13:
          jj_consume_token(13);
          break;
        case 14:
          jj_consume_token(14);
          break;
        case BLANK:
          jj_consume_token(BLANK);
          break;
        case EOL:
          jj_consume_token(EOL);
          break;
        case 20:
          jj_consume_token(20);
          break;
        case 21:
          jj_consume_token(21);
          break;
        case 22:
          jj_consume_token(22);
          break;
        default:
          jj_la1[20] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      jj_consume_token(15);
      label_13:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case BLANK:
          ;
          break;
        default:
          jj_la1[21] = jj_gen;
          break label_13;
        }
        jj_consume_token(BLANK);
      }
      jj_consume_token(20);
      label_14:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case BLANK:
          ;
          break;
        default:
          jj_la1[22] = jj_gen;
          break label_14;
        }
        jj_consume_token(BLANK);
      }
      taxa = Number();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EOL:
        jj_consume_token(EOL);
        break;
      case BLANK:
        jj_consume_token(BLANK);
        break;
      case 11:
        jj_consume_token(11);
        break;
      default:
        jj_la1[23] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_15:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case EOL:
        case BLANK:
        case UPPER_CASE:
        case LOWER_CASE:
        case NUMBER:
        case ANY:
        case 11:
        case 12:
        case 13:
        case 14:
        case 20:
        case 21:
        case 22:
          ;
          break;
        default:
          jj_la1[24] = jj_gen;
          break label_15;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case UPPER_CASE:
          jj_consume_token(UPPER_CASE);
          break;
        case LOWER_CASE:
          jj_consume_token(LOWER_CASE);
          break;
        case NUMBER:
          jj_consume_token(NUMBER);
          break;
        case ANY:
          jj_consume_token(ANY);
          break;
        case 11:
          jj_consume_token(11);
          break;
        case 12:
          jj_consume_token(12);
          break;
        case 13:
          jj_consume_token(13);
          break;
        case 14:
          jj_consume_token(14);
          break;
        case BLANK:
          jj_consume_token(BLANK);
          break;
        case EOL:
          jj_consume_token(EOL);
          break;
        case 20:
          jj_consume_token(20);
          break;
        case 21:
          jj_consume_token(21);
          break;
        case 22:
          jj_consume_token(22);
          break;
        default:
          jj_la1[25] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      jj_consume_token(19);
                if (taxa == 0)
                    {if (true) throw new ParseException("Number of sequences (ntax) missing in NEXUS header.");}
      label_16:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case EOL:
        case BLANK:
        case UPPER_CASE:
        case LOWER_CASE:
        case NUMBER:
        case ANY:
        case 11:
        case 12:
        case 13:
        case 14:
        case 20:
        case 21:
        case 22:
          ;
          break;
        default:
          jj_la1[26] = jj_gen;
          break label_16;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case UPPER_CASE:
          jj_consume_token(UPPER_CASE);
          break;
        case LOWER_CASE:
          jj_consume_token(LOWER_CASE);
          break;
        case NUMBER:
          jj_consume_token(NUMBER);
          break;
        case ANY:
          jj_consume_token(ANY);
          break;
        case 11:
          jj_consume_token(11);
          break;
        case 12:
          jj_consume_token(12);
          break;
        case 13:
          jj_consume_token(13);
          break;
        case 14:
          jj_consume_token(14);
          break;
        case BLANK:
          jj_consume_token(BLANK);
          break;
        case EOL:
          jj_consume_token(EOL);
          break;
        case 20:
          jj_consume_token(20);
          break;
        case 21:
          jj_consume_token(21);
          break;
        case 22:
          jj_consume_token(22);
          break;
        default:
          jj_la1[27] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      jj_consume_token(25);
      jj_consume_token(11);
      label_17:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case EOL:
        case BLANK:
        case UPPER_CASE:
        case LOWER_CASE:
        case NUMBER:
        case ANY:
        case 11:
        case 12:
        case 13:
        case 14:
        case 20:
        case 21:
        case 22:
          ;
          break;
        default:
          jj_la1[28] = jj_gen;
          break label_17;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case UPPER_CASE:
          jj_consume_token(UPPER_CASE);
          break;
        case LOWER_CASE:
          jj_consume_token(LOWER_CASE);
          break;
        case NUMBER:
          jj_consume_token(NUMBER);
          break;
        case ANY:
          jj_consume_token(ANY);
          break;
        case 11:
          jj_consume_token(11);
          break;
        case 12:
          jj_consume_token(12);
          break;
        case 13:
          jj_consume_token(13);
          break;
        case 14:
          jj_consume_token(14);
          break;
        case BLANK:
          jj_consume_token(BLANK);
          break;
        case EOL:
          jj_consume_token(EOL);
          break;
        case 20:
          jj_consume_token(20);
          break;
        case 21:
          jj_consume_token(21);
          break;
        case 22:
          jj_consume_token(22);
          break;
        default:
          jj_la1[29] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      label_18:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case 16:
          jj_consume_token(16);
          label_19:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case BLANK:
              ;
              break;
            default:
              jj_la1[30] = jj_gen;
              break label_19;
            }
            jj_consume_token(BLANK);
          }
          jj_consume_token(20);
          label_20:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case BLANK:
              ;
              break;
            default:
              jj_la1[31] = jj_gen;
              break label_20;
            }
            jj_consume_token(BLANK);
          }
          length = Number();
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case EOL:
            jj_consume_token(EOL);
            break;
          case BLANK:
            jj_consume_token(BLANK);
            break;
          case 11:
            jj_consume_token(11);
            break;
          default:
            jj_la1[32] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
        case 17:
          jj_consume_token(17);
          label_21:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case BLANK:
              ;
              break;
            default:
              jj_la1[33] = jj_gen;
              break label_21;
            }
            jj_consume_token(BLANK);
          }
          jj_consume_token(20);
          label_22:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case BLANK:
              ;
              break;
            default:
              jj_la1[34] = jj_gen;
              break label_22;
            }
            jj_consume_token(BLANK);
          }
          type = Type();
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case EOL:
            jj_consume_token(EOL);
            break;
          case BLANK:
            jj_consume_token(BLANK);
            break;
          case 11:
            jj_consume_token(11);
            break;
          default:
            jj_la1[35] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
        default:
          jj_la1[36] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        label_23:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case EOL:
          case BLANK:
          case UPPER_CASE:
          case LOWER_CASE:
          case NUMBER:
          case ANY:
          case 11:
          case 12:
          case 13:
          case 14:
          case 20:
          case 21:
          case 22:
            ;
            break;
          default:
            jj_la1[37] = jj_gen;
            break label_23;
          }
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case UPPER_CASE:
            jj_consume_token(UPPER_CASE);
            break;
          case LOWER_CASE:
            jj_consume_token(LOWER_CASE);
            break;
          case NUMBER:
            jj_consume_token(NUMBER);
            break;
          case ANY:
            jj_consume_token(ANY);
            break;
          case 11:
            jj_consume_token(11);
            break;
          case 12:
            jj_consume_token(12);
            break;
          case 13:
            jj_consume_token(13);
            break;
          case 14:
            jj_consume_token(14);
            break;
          case BLANK:
            jj_consume_token(BLANK);
            break;
          case EOL:
            jj_consume_token(EOL);
            break;
          case 20:
            jj_consume_token(20);
            break;
          case 21:
            jj_consume_token(21);
            break;
          case 22:
            jj_consume_token(22);
            break;
          default:
            jj_la1[38] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case 16:
        case 17:
          ;
          break;
        default:
          jj_la1[39] = jj_gen;
          break label_18;
        }
      }
                if (length == 0)
                    {if (true) throw new ParseException("Sequences length (nchar) missing in NEXUS header.");}
                if (type.isEmpty())
                    {if (true) throw new ParseException("MSA type (datatype) missing in NEXUS header.");}
      break;
    default:
      jj_la1[40] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(18);
    label_24:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BLANK:
        ;
        break;
      default:
        jj_la1[41] = jj_gen;
        break label_24;
      }
      jj_consume_token(BLANK);
    }
    label_25:
    while (true) {
      jj_consume_token(EOL);
      label_26:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case BLANK:
          ;
          break;
        default:
          jj_la1[42] = jj_gen;
          break label_26;
        }
        jj_consume_token(BLANK);
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EOL:
        ;
        break;
      default:
        jj_la1[43] = jj_gen;
        break label_25;
      }
    }
    label_27:
    while (true) {
      id = Id();
      jj_consume_token(BLANK);
      data = DataLine();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 11:
        jj_consume_token(11);
        label_28:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case BLANK:
            ;
            break;
          default:
            jj_la1[44] = jj_gen;
            break label_28;
          }
          jj_consume_token(BLANK);
        }
        break;
      default:
        jj_la1[45] = jj_gen;
        ;
      }
      label_29:
      while (true) {
        jj_consume_token(EOL);
        label_30:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case BLANK:
            ;
            break;
          default:
            jj_la1[46] = jj_gen;
            break label_30;
          }
          jj_consume_token(BLANK);
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case EOL:
          ;
          break;
        default:
          jj_la1[47] = jj_gen;
          break label_29;
        }
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 11:
        jj_consume_token(11);
        label_31:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case BLANK:
            ;
            break;
          default:
            jj_la1[48] = jj_gen;
            break label_31;
          }
          jj_consume_token(BLANK);
        }
        label_32:
        while (true) {
          jj_consume_token(EOL);
          label_33:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case BLANK:
              ;
              break;
            default:
              jj_la1[49] = jj_gen;
              break label_33;
            }
            jj_consume_token(BLANK);
          }
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case EOL:
            ;
            break;
          default:
            jj_la1[50] = jj_gen;
            break label_32;
          }
        }
        break;
      default:
        jj_la1[51] = jj_gen;
        ;
      }
            seqs.add(new NexusSequence(id, data));
            cont++;
            if (cont == taxa)
            {
                cont = 0;
                break;
            }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UPPER_CASE:
      case LOWER_CASE:
      case NUMBER:
      case ANY:
      case 10:
      case 12:
      case 13:
      case 14:
      case 15:
      case 16:
      case 17:
      case 18:
      case 20:
      case 21:
      case 22:
      case 23:
        ;
        break;
      default:
        jj_la1[52] = jj_gen;
        break label_27;
      }
    }
    label_34:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UPPER_CASE:
      case LOWER_CASE:
      case NUMBER:
      case ANY:
      case 10:
      case 12:
      case 13:
      case 14:
      case 15:
      case 16:
      case 17:
      case 18:
      case 20:
      case 21:
      case 22:
      case 23:
        ;
        break;
      default:
        jj_la1[53] = jj_gen;
        break label_34;
      }
      IdSeq(seqs.elementAt(cont).getId());
      jj_consume_token(BLANK);
      data = DataLine();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 11:
        jj_consume_token(11);
        label_35:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case BLANK:
            ;
            break;
          default:
            jj_la1[54] = jj_gen;
            break label_35;
          }
          jj_consume_token(BLANK);
        }
        break;
      default:
        jj_la1[55] = jj_gen;
        ;
      }
      label_36:
      while (true) {
        jj_consume_token(EOL);
        label_37:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case BLANK:
            ;
            break;
          default:
            jj_la1[56] = jj_gen;
            break label_37;
          }
          jj_consume_token(BLANK);
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case EOL:
          ;
          break;
        default:
          jj_la1[57] = jj_gen;
          break label_36;
        }
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 11:
        jj_consume_token(11);
        label_38:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case BLANK:
            ;
            break;
          default:
            jj_la1[58] = jj_gen;
            break label_38;
          }
          jj_consume_token(BLANK);
        }
        label_39:
        while (true) {
          jj_consume_token(EOL);
          label_40:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case BLANK:
              ;
              break;
            default:
              jj_la1[59] = jj_gen;
              break label_40;
            }
            jj_consume_token(BLANK);
          }
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case EOL:
            ;
            break;
          default:
            jj_la1[60] = jj_gen;
            break label_39;
          }
        }
        break;
      default:
        jj_la1[61] = jj_gen;
        ;
      }
            seqs.elementAt(cont).concat(data);
            cont++;
            if (cont == seqs.size())
                cont = 0;
    }
    jj_consume_token(19);
    label_41:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EOL:
      case BLANK:
      case UPPER_CASE:
      case LOWER_CASE:
      case NUMBER:
      case ANY:
      case 10:
      case 11:
      case 12:
      case 13:
      case 14:
      case 15:
      case 16:
      case 17:
      case 18:
      case 19:
      case 20:
      case 21:
      case 22:
      case 23:
      case 24:
      case 25:
        ;
        break;
      default:
        jj_la1[62] = jj_gen;
        break label_41;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UPPER_CASE:
        jj_consume_token(UPPER_CASE);
        break;
      case LOWER_CASE:
        jj_consume_token(LOWER_CASE);
        break;
      case NUMBER:
        jj_consume_token(NUMBER);
        break;
      case ANY:
        jj_consume_token(ANY);
        break;
      case 11:
        jj_consume_token(11);
        break;
      case 12:
        jj_consume_token(12);
        break;
      case 13:
        jj_consume_token(13);
        break;
      case 14:
        jj_consume_token(14);
        break;
      case BLANK:
        jj_consume_token(BLANK);
        break;
      case EOL:
        jj_consume_token(EOL);
        break;
      case 10:
        jj_consume_token(10);
        break;
      case 15:
        jj_consume_token(15);
        break;
      case 16:
        jj_consume_token(16);
        break;
      case 17:
        jj_consume_token(17);
        break;
      case 18:
        jj_consume_token(18);
        break;
      case 19:
        jj_consume_token(19);
        break;
      case 23:
        jj_consume_token(23);
        break;
      case 24:
        jj_consume_token(24);
        break;
      case 25:
        jj_consume_token(25);
        break;
      case 20:
        jj_consume_token(20);
        break;
      case 21:
        jj_consume_token(21);
        break;
      case 22:
        jj_consume_token(22);
        break;
      default:
        jj_la1[63] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(0);
        {if (true) return new Nexus(taxa, length, type, seqs);}
    throw new Error("Missing return statement in function");
  }

/**
* Parses a number.
* @return Parsed number.
*/
  final public int Number() throws ParseException {
    String s = "";
    Token t;
    label_42:
    while (true) {
      t = jj_consume_token(NUMBER);
            s = s.concat(t.image);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NUMBER:
        ;
        break;
      default:
        jj_la1[64] = jj_gen;
        break label_42;
      }
    }
        {if (true) return Integer.parseInt(s);}
    throw new Error("Missing return statement in function");
  }

/**
* Parses a NEXUS style type.
* @return String with the type.
*/
  final public String Type() throws ParseException {
    String s = "";
    Token t;
    label_43:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UPPER_CASE:
        t = jj_consume_token(UPPER_CASE);
        break;
      case LOWER_CASE:
        t = jj_consume_token(LOWER_CASE);
        break;
      default:
        jj_la1[65] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
            s = s.concat(t.image);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UPPER_CASE:
      case LOWER_CASE:
        ;
        break;
      default:
        jj_la1[66] = jj_gen;
        break label_43;
      }
    }
        {if (true) return s.toUpperCase();}
    throw new Error("Missing return statement in function");
  }

/**
* Parses a sequence identifier. An identifier cannot contain spaces or start with ";".
* @return Sequence identifier.
*/
  final public String Id() throws ParseException {
    StringBuffer s = new StringBuffer();
    Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 21:
    case 22:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 21:
        jj_consume_token(21);
        break;
      case 22:
        jj_consume_token(22);
        break;
      default:
        jj_la1[67] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_44:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case UPPER_CASE:
          t = jj_consume_token(UPPER_CASE);
          break;
        case LOWER_CASE:
          t = jj_consume_token(LOWER_CASE);
          break;
        case NUMBER:
          t = jj_consume_token(NUMBER);
          break;
        case ANY:
          t = jj_consume_token(ANY);
          break;
        case 12:
          t = jj_consume_token(12);
          break;
        case 13:
          t = jj_consume_token(13);
          break;
        case 14:
          t = jj_consume_token(14);
          break;
        case 18:
          t = jj_consume_token(18);
          break;
        case 16:
          t = jj_consume_token(16);
          break;
        case 15:
          t = jj_consume_token(15);
          break;
        case 17:
          t = jj_consume_token(17);
          break;
        case 10:
          t = jj_consume_token(10);
          break;
        case 23:
          t = jj_consume_token(23);
          break;
        case 19:
          t = jj_consume_token(19);
          break;
        case 20:
          t = jj_consume_token(20);
          break;
        default:
          jj_la1[68] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
                    s.append(t.image);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case UPPER_CASE:
        case LOWER_CASE:
        case NUMBER:
        case ANY:
        case 10:
        case 12:
        case 13:
        case 14:
        case 15:
        case 16:
        case 17:
        case 18:
        case 19:
        case 20:
        case 23:
          ;
          break;
        default:
          jj_la1[69] = jj_gen;
          break label_44;
        }
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 21:
        jj_consume_token(21);
        break;
      case 22:
        jj_consume_token(22);
        break;
      default:
        jj_la1[70] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    case UPPER_CASE:
    case LOWER_CASE:
    case NUMBER:
    case ANY:
    case 10:
    case 12:
    case 13:
    case 14:
    case 15:
    case 16:
    case 17:
    case 18:
    case 20:
    case 23:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UPPER_CASE:
        t = jj_consume_token(UPPER_CASE);
        break;
      case LOWER_CASE:
        t = jj_consume_token(LOWER_CASE);
        break;
      case NUMBER:
        t = jj_consume_token(NUMBER);
        break;
      case ANY:
        t = jj_consume_token(ANY);
        break;
      case 12:
        t = jj_consume_token(12);
        break;
      case 13:
        t = jj_consume_token(13);
        break;
      case 14:
        t = jj_consume_token(14);
        break;
      case 18:
        t = jj_consume_token(18);
        break;
      case 16:
        t = jj_consume_token(16);
        break;
      case 15:
        t = jj_consume_token(15);
        break;
      case 17:
        t = jj_consume_token(17);
        break;
      case 10:
        t = jj_consume_token(10);
        break;
      case 23:
        t = jj_consume_token(23);
        break;
      case 20:
        t = jj_consume_token(20);
        break;
      default:
        jj_la1[71] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                    s.append(t.image);
      label_45:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case UPPER_CASE:
        case LOWER_CASE:
        case NUMBER:
        case ANY:
        case 10:
        case 11:
        case 12:
        case 13:
        case 14:
        case 15:
        case 16:
        case 17:
        case 18:
        case 19:
        case 20:
        case 21:
        case 22:
        case 23:
          ;
          break;
        default:
          jj_la1[72] = jj_gen;
          break label_45;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case UPPER_CASE:
          t = jj_consume_token(UPPER_CASE);
          break;
        case LOWER_CASE:
          t = jj_consume_token(LOWER_CASE);
          break;
        case NUMBER:
          t = jj_consume_token(NUMBER);
          break;
        case ANY:
          t = jj_consume_token(ANY);
          break;
        case 11:
          t = jj_consume_token(11);
          break;
        case 12:
          t = jj_consume_token(12);
          break;
        case 13:
          t = jj_consume_token(13);
          break;
        case 14:
          t = jj_consume_token(14);
          break;
        case 18:
          t = jj_consume_token(18);
          break;
        case 16:
          t = jj_consume_token(16);
          break;
        case 15:
          t = jj_consume_token(15);
          break;
        case 17:
          t = jj_consume_token(17);
          break;
        case 10:
          t = jj_consume_token(10);
          break;
        case 23:
          t = jj_consume_token(23);
          break;
        case 19:
          t = jj_consume_token(19);
          break;
        case 20:
          t = jj_consume_token(20);
          break;
        case 21:
          t = jj_consume_token(21);
          break;
        case 22:
          t = jj_consume_token(22);
          break;
        default:
          jj_la1[73] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
                    s.append(t.image);
      }
      break;
    default:
      jj_la1[74] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return s.toString();}
    throw new Error("Missing return statement in function");
  }

/**
* Same behaviour as Id(), but in this case equality between the already read
* identifier and the current one is checked.
* @param id Identifier to parse.
*/
  final public void IdSeq(String id) throws ParseException {
    StringBuffer s = new StringBuffer();
    Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 21:
    case 22:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 21:
        jj_consume_token(21);
        break;
      case 22:
        jj_consume_token(22);
        break;
      default:
        jj_la1[75] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_46:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case UPPER_CASE:
          t = jj_consume_token(UPPER_CASE);
          break;
        case LOWER_CASE:
          t = jj_consume_token(LOWER_CASE);
          break;
        case NUMBER:
          t = jj_consume_token(NUMBER);
          break;
        case ANY:
          t = jj_consume_token(ANY);
          break;
        case 12:
          t = jj_consume_token(12);
          break;
        case 13:
          t = jj_consume_token(13);
          break;
        case 14:
          t = jj_consume_token(14);
          break;
        case 18:
          t = jj_consume_token(18);
          break;
        case 16:
          t = jj_consume_token(16);
          break;
        case 15:
          t = jj_consume_token(15);
          break;
        case 17:
          t = jj_consume_token(17);
          break;
        case 10:
          t = jj_consume_token(10);
          break;
        case 23:
          t = jj_consume_token(23);
          break;
        case 19:
          t = jj_consume_token(19);
          break;
        case 20:
          t = jj_consume_token(20);
          break;
        default:
          jj_la1[76] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
                    s.append(t.image);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case UPPER_CASE:
        case LOWER_CASE:
        case NUMBER:
        case ANY:
        case 10:
        case 12:
        case 13:
        case 14:
        case 15:
        case 16:
        case 17:
        case 18:
        case 19:
        case 20:
        case 23:
          ;
          break;
        default:
          jj_la1[77] = jj_gen;
          break label_46;
        }
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 21:
        jj_consume_token(21);
        break;
      case 22:
        jj_consume_token(22);
        break;
      default:
        jj_la1[78] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    case UPPER_CASE:
    case LOWER_CASE:
    case NUMBER:
    case ANY:
    case 10:
    case 12:
    case 13:
    case 14:
    case 15:
    case 16:
    case 17:
    case 18:
    case 20:
    case 23:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UPPER_CASE:
        t = jj_consume_token(UPPER_CASE);
        break;
      case LOWER_CASE:
        t = jj_consume_token(LOWER_CASE);
        break;
      case NUMBER:
        t = jj_consume_token(NUMBER);
        break;
      case ANY:
        t = jj_consume_token(ANY);
        break;
      case 12:
        t = jj_consume_token(12);
        break;
      case 13:
        t = jj_consume_token(13);
        break;
      case 14:
        t = jj_consume_token(14);
        break;
      case 18:
        t = jj_consume_token(18);
        break;
      case 16:
        t = jj_consume_token(16);
        break;
      case 15:
        t = jj_consume_token(15);
        break;
      case 17:
        t = jj_consume_token(17);
        break;
      case 10:
        t = jj_consume_token(10);
        break;
      case 23:
        t = jj_consume_token(23);
        break;
      case 20:
        t = jj_consume_token(20);
        break;
      default:
        jj_la1[79] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                    s.append(t.image);
      label_47:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case UPPER_CASE:
        case LOWER_CASE:
        case NUMBER:
        case ANY:
        case 10:
        case 11:
        case 12:
        case 13:
        case 14:
        case 15:
        case 16:
        case 17:
        case 18:
        case 19:
        case 20:
        case 21:
        case 22:
        case 23:
          ;
          break;
        default:
          jj_la1[80] = jj_gen;
          break label_47;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case UPPER_CASE:
          t = jj_consume_token(UPPER_CASE);
          break;
        case LOWER_CASE:
          t = jj_consume_token(LOWER_CASE);
          break;
        case NUMBER:
          t = jj_consume_token(NUMBER);
          break;
        case ANY:
          t = jj_consume_token(ANY);
          break;
        case 11:
          t = jj_consume_token(11);
          break;
        case 12:
          t = jj_consume_token(12);
          break;
        case 13:
          t = jj_consume_token(13);
          break;
        case 14:
          t = jj_consume_token(14);
          break;
        case 18:
          t = jj_consume_token(18);
          break;
        case 16:
          t = jj_consume_token(16);
          break;
        case 15:
          t = jj_consume_token(15);
          break;
        case 17:
          t = jj_consume_token(17);
          break;
        case 10:
          t = jj_consume_token(10);
          break;
        case 23:
          t = jj_consume_token(23);
          break;
        case 19:
          t = jj_consume_token(19);
          break;
        case 20:
          t = jj_consume_token(20);
          break;
        case 21:
          t = jj_consume_token(21);
          break;
        case 22:
          t = jj_consume_token(22);
          break;
        default:
          jj_la1[81] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
                    s.append(t.image);
      }
      break;
    default:
      jj_la1[82] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        if (!id.equals(s.toString()))
            {if (true) throw new ParseException("ID for sequence \u005c"" + id
                            + "\u005c"does not match with ID in line " + t.beginLine);}
  }

/**
* Parses a data line. A data line can be made up of characters from "A" to "Z"
* (lowercase and uppercase), "-", "." or "?". Spaces and tabs are omitted.
* @return String with the data line (always uppercase).
*/
  final public String DataLine() throws ParseException {
    StringBuffer s = new StringBuffer();
    Token t;
    label_48:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BLANK:
        t = jj_consume_token(BLANK);
        break;
      case UPPER_CASE:
      case LOWER_CASE:
      case 12:
      case 13:
      case 14:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case UPPER_CASE:
          t = jj_consume_token(UPPER_CASE);
          break;
        case LOWER_CASE:
          t = jj_consume_token(LOWER_CASE);
          break;
        case 12:
          t = jj_consume_token(12);
          break;
        case 13:
          t = jj_consume_token(13);
          break;
        case 14:
          t = jj_consume_token(14);
          break;
        default:
          jj_la1[83] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
                s.append(t.image);
        break;
      default:
        jj_la1[84] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BLANK:
      case UPPER_CASE:
      case LOWER_CASE:
      case 12:
      case 13:
      case 14:
        ;
        break;
      default:
        jj_la1[85] = jj_gen;
        break label_48;
      }
    }
        {if (true) return s.toString().toUpperCase();}
    throw new Error("Missing return statement in function");
  }

  /** Generated Token Manager. */
  public NexusParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private int jj_gen;
  final private int[] jj_la1 = new int[86];
  static private int[] jj_la1_0;
  static {
      jj_la1_init_0();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x6,0x6,0x7ffc7e,0x7ffc7e,0x70787e,0x70787e,0x4,0x4,0x806,0x4,0x4,0x806,0x4,0x4,0x806,0x38000,0x70787e,0x70787e,0x38000,0x70787e,0x70787e,0x4,0x4,0x806,0x70787e,0x70787e,0x70787e,0x70787e,0x70787e,0x70787e,0x4,0x4,0x806,0x4,0x4,0x806,0x30000,0x70787e,0x70787e,0x30000,0x1800000,0x4,0x4,0x2,0x4,0x800,0x4,0x2,0x4,0x4,0x2,0x800,0xf7f478,0xf7f478,0x4,0x800,0x4,0x2,0x4,0x4,0x2,0x800,0x3fffc7e,0x3fffc7e,0x20,0x18,0x18,0x600000,0x9ff478,0x9ff478,0x600000,0x97f478,0xfffc78,0xfffc78,0xf7f478,0x600000,0x9ff478,0x9ff478,0x600000,0x97f478,0xfffc78,0xfffc78,0xf7f478,0x7018,0x701c,0x701c,};
   }

  /** Constructor with InputStream. */
  public NexusParser(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public NexusParser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new NexusParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 86; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 86; i++) jj_la1[i] = -1;
  }

  /** Constructor. */
  public NexusParser(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new NexusParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 86; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 86; i++) jj_la1[i] = -1;
  }

  /** Constructor with generated Token Manager. */
  public NexusParser(NexusParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 86; i++) jj_la1[i] = -1;
  }

  /** Reinitialise. */
  public void ReInit(NexusParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 86; i++) jj_la1[i] = -1;
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[26];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 86; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 26; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

}
