!{\src2tex{textfont=tt}}
!!****f* ABINIT/vlocal1
!! NAME
!! vlocal1
!!
!! FUNCTION
!!  (to be completed)
!!
!! COPYRIGHT
!! Copyright (C) 2005-2007 ABINIT group (JJ)
!!
!! INPUTS
!!  (to be completed)
!!
!! OUTPUT
!!  (to be completed)
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine vlocal1( zval, nrval, a, rofi, drdi, s, rgauss, vlocal,     &
&                   nchloc, chlocal)

 use defs_basis
! This routine generates a smooth local pseudopotential.
! Written by D. Sanchez-Portal, Aug. 1998

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_13psp, except_this_one => vlocal1
#endif
!End of the abilint section

 implicit none

!Arguments --------------------------
!!???
!scalars
 integer,intent(in) :: nrval
 integer,intent(out) :: nchloc
 real(dp),intent(in) :: a,zval
 real(dp),intent(inout) :: rgauss
!arrays
 real(dp),intent(in) :: drdi(:),rofi(:),s(:)
 real(dp),intent(out) :: chlocal(:),vlocal(:)

!Local variables ------------------------------
!**   Usual local potential
!     (generated with an optimum Vandebilt function)**
!scalars
 integer :: ir
 real(dp),parameter :: eps=1.0d-4
 real(dp) :: Rchloc,alp,chc,cutoff1,cutoff2,factor,qtot,r,rhor,rhor1,van
 character(len=3) :: loctype

! *************************************************************************
!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifndef HAVE_FORTRAN_INTERFACES
 real(dp) :: vander
#endif
!End of the abilint section

 loctype = 'new'

!***  The very first local potential used by SIESTA was
!     the electrostatic potential generated by a gaussian
!     distribution ===> loctype='old'
!     loctype='old'
!***

!     Local-potential size parameter 'rgauss'
!     We choose as a smooth pseudopotential the one generated
!     by a 'Vanderbilt-function' charge distribution. We have to select
!     the size of this distribution somehow.
!     'Vanderbilt-functions' are of the form :
!     p(r)=N*exp(-(sinh(van*r)/sinh(van))**2)
!     when van---> 0 we will obtain a 'gaussian'
!     when van---> Inf. we will obtain a step function
!     Some test has revealed that the best election to achieve
!     a good convergence in real and reciprocal space is b in the
!     range 0.5-1.0 .
!     *

!     So, the 'gaussian' charge distribution
!     must go to zero at a distance 'rgauss'.

 if( loctype .eq. 'new' ) then
!     We take a 'Vanderbilt-function' as local potential
!     van=1.0_dp all the parameter have optimized for this value
   van     = 1.0d0
   cutoff1 = 3.63d0
   cutoff2 = 5.48d0
!**   99% of charge inside Rgauss**
!   factor=1.627_dp
!**   99.9% of charge inside Rgauss
   factor = 1.815d0
!     * Scaling factor for local-pseudopot. charge**
   alp = factor / rgauss
!   write(6,'(/,a,f10.3,a)')                          &
!&    'VLOCAL1: 99.0% of the norm of Vloc inside ',   &
!&    (alp*cutoff1)**2,' Ry'
!   write(6,'(a,f10.3,a)')                            &
!&    'VLOCAL1: 99.9% of the norm of Vloc inside ',   &
!&    (alp*cutoff2)**2,' Ry'
 else
!     This is just a gaussian !!!!!!!!!!!!!!!!!
   van    = 0.00001d0
   rgauss = 0.80d0
   factor = 2.0d0
!     * Scaling factor for local-pseudopot. charge**
   alp    = factor / rgauss
 end if

 qtot = 0.0d0
 rhor1 = vander( van, alp * rofi(1) )     ! This is 1...
 do ir = 1, nrval
   r           = rofi(ir)
   rhor        = vander( van, alp * r)
   chlocal(ir) = (-4.0d0) * pi * rhor * r * r
   qtot        = qtot + rhor * drdi(ir) * r * r
 end do

 qtot   = 4.0d0 * pi * qtot
 nchloc = 0
 do ir = nrval, 1, -1
   chc         = zval * chlocal(ir) / qtot
   chlocal(ir) = chc
   if( ( abs(chc) .gt. eps ) .and. ( nchloc .eq. 0 ) ) then
      nchloc = ir + 1
   end if
 end do
 Rchloc = rofi(nchloc)
!
!     Note that the above cutoff is for 4*pi*r*r*rho_local(r)...
!
 call vhrtre( chlocal, vlocal, rofi, drdi, s, nrval, a )

 do ir = 2, nrval
   r = rofi(ir)
   chlocal(ir) = chlocal(ir) / ( 4.0d0 * pi * r * r )
!
!     Poor man's cutoff!! Largely irrelevant?
!
   if ( r .gt. 1.1d0 * Rchloc ) then
     vlocal(ir) = (-2.0d0) * zval / rofi(ir)
   end if
 end do
 chlocal(1) = -rhor1 * zval / qtot

end subroutine vlocal1
! ---
!!***
