#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Book of Hours
###

script_version=20231211.1

PLAYIT_COMPATIBILITY_LEVEL='2.27'

GAME_ID='book-of-hours'
GAME_NAME='Book of Hours'

ARCHIVE_BASE_7_NAME='book_of_hours_2023_12_d_12_69519.sh'
ARCHIVE_BASE_7_MD5='f99ac227e448683eb9cb9586e0d43cc8'
ARCHIVE_BASE_7_SIZE='1938644'
ARCHIVE_BASE_7_VERSION='2023.12.d.12-gog69519'
ARCHIVE_BASE_7_URL='https://www.gog.com/game/book_of_hours'

ARCHIVE_BASE_6_NAME='book_of_hours_2023_12_d_9_69348.sh'
ARCHIVE_BASE_6_MD5='0134334eccc16c6f956f8889347c79e7'
ARCHIVE_BASE_6_SIZE='1938312'
ARCHIVE_BASE_6_VERSION='2023.12.d.9-gog69348'

ARCHIVE_BASE_5_NAME='book_of_hours_2023_12_d_8_69334.sh'
ARCHIVE_BASE_5_MD5='13af4a42136e9fa4de6130df9b9c7034'
ARCHIVE_BASE_5_SIZE='1938304'
ARCHIVE_BASE_5_VERSION='2023.12.d.8-gog69334'

ARCHIVE_BASE_4_NAME='book_of_hours_2023_11_d_4_69228.sh'
ARCHIVE_BASE_4_MD5='f0dfed821caeb83d795a176dd9571281'
ARCHIVE_BASE_4_SIZE='1934820'
ARCHIVE_BASE_4_VERSION='2023.11.d.4-gog69228'

ARCHIVE_BASE_3_NAME='book_of_hours_2023_10_c_11_68174.sh'
ARCHIVE_BASE_3_MD5='958bd653dd8a2453c9920ab60fc96e29'
ARCHIVE_BASE_3_SIZE='1932668'
ARCHIVE_BASE_3_VERSION='2023.10.c.11-gog68174'

ARCHIVE_BASE_2_NAME='book_of_hours_2023_9_b_12_67790.sh'
ARCHIVE_BASE_2_MD5='2875c037ee2ff44b41191471449248a1'
ARCHIVE_BASE_2_SIZE='1930344'
ARCHIVE_BASE_2_VERSION='2023.09.b.12-gog67790'

ARCHIVE_BASE_1_NAME='book_of_hours_2023_8_g_2_67165.sh'
ARCHIVE_BASE_1_MD5='4d6c689f68c4debb4ad68a3dc1c018b5'
ARCHIVE_BASE_1_SIZE='1927812'
ARCHIVE_BASE_1_VERSION='2023.08.g.2-gog67165'

ARCHIVE_BASE_0_NAME='book_of_hours_2023_8_a_7_2_66829.sh'
ARCHIVE_BASE_0_MD5='7e8083b57019140127cb7bcffbccb737'
ARCHIVE_BASE_0_SIZE='2900000'
ARCHIVE_BASE_0_VERSION='2023.08.a.7.2-gog66829'

UNITY3D_NAME='bh'

CONTENT_PATH_DEFAULT='data/noarch/game'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libm.so.6
libpthread.so.0
librt.so.1
libz.so.1'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

set_current_package 'PKG_DATA'
icons_inclusion
content_inclusion_default

# Write launchers

set_current_package 'PKG_BIN'
launchers_write

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
