#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2019 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# The Pillars of the Earth
# send your bug reports to contact@dotslashplay.it
###

script_version=20231017.1

PLAYIT_COMPATIBILITY_LEVEL='2.27'

GAME_ID='the-pillars-of-the-earth'
GAME_NAME='The Pillars of the Earth'

ARCHIVE_BASE_0_NAME='the_pillars_of_the_earth_en_1_1_703_19574.sh'
ARCHIVE_BASE_0_MD5='1976e6d4476e3d9867aef13176581f58'
ARCHIVE_BASE_0_SIZE='12000000'
ARCHIVE_BASE_0_VERSION='1.1.703-gog19574'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/ken_folletts_the_pillars_of_the_earth_season_pass'

VISIONAIRE_NAME='pillars'

CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_LIBS0_BIN_PATH="${CONTENT_PATH_DEFAULT}/configtool/lib"
# TODO - Some shipped libraries could probably be dropped in favour of system ones.
CONTENT_LIBS0_BIN_FILES='
libicudata.so.56
libicui18n.so.56
libicuuc.so.56
libQt5Core.so.5
libQt5DBus.so.5
libQt5Gui.so.5
libQt5Widgets.so.5
libQt5XcbQpa.so.5'
CONTENT_GAME_BIN_FILES="
$VISIONAIRE_NAME
config.ini
configtool"
CONTENT_GAME_DATA_SCENES_FILES='
scenes'

APP_MAIN_ICON='../support/icon.png'

APP_CONFIG_ID="${GAME_ID}-config"
APP_CONFIG_NAME="$GAME_NAME - configuration"
APP_CONFIG_CAT='Settings'
APP_CONFIG_EXE='configtool/visconfig'
APP_CONFIG_ICON='../support/icon.png'

PACKAGES_LIST='
PKG_BIN
PKG_DATA_SCENES
PKG_DATA'

PKG_DATA_SCENES_ID="${GAME_ID}-data-scenes"
PKG_DATA_SCENES_DESCRIPTION="$GAME_NAME - data - scenes"
PKG_DATA_DEPS="${PKG_DATA_DEPS:-} $PKG_DATA_SCENES_ID"

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdbus-1.so.3
libdl.so.2
libfontconfig.so.1
libfreetype.so.6
libgcc_s.so.1
libglib-2.0.so.0
libGL.so.1
libgthread-2.0.so.0
libICE.so.6
libm.so.6
libopenal.so.1
libpng12.so.0
libpthread.so.0
librt.so.1
libSM.so.6
libstdc++.so.6
libX11.so.6
libX11-xcb.so.1
libxcb.so.1
libXi.so.6'

## Ensure smooth upgrades from packages generated by game scripts pre-20231005.1
PKG_DATA_PROVIDES='
the-pillars-of-the-earth-videos'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

set_current_package 'PKG_DATA'
icons_inclusion
content_inclusion_default

# Write launchers

set_current_package 'PKG_BIN'
launchers_write

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
