#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 macaron
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Call of Cthulhu: Prisoner of Ice
# send your bug reports to contact@dotslashplay.it
###

script_version=20221211.1

GAME_ID='call-of-cthulhu-prisoner-of-ice'
GAME_NAME='Call of Cthulhu: Prisoner of Ice'

ARCHIVE_BASE_EN_0='call_of_cthulhu_prisoner_of_ice_en_gog_5_17654.sh'
ARCHIVE_BASE_EN_0_MD5='c3f64c02981cfacefd3b3f8d0d504ac3'
ARCHIVE_BASE_EN_0_TYPE='mojosetup'
ARCHIVE_BASE_EN_0_SIZE='310000'
ARCHIVE_BASE_EN_0_VERSION='1.0-gog17654'
ARCHIVE_BASE_EN_0_URL='https://www.gog.com/game/call_of_cthulhu_prisoner_of_ice'

ARCHIVE_BASE_FR_0='call_of_cthulhu_prisoner_of_ice_fr_gog_5_17654.sh'
ARCHIVE_BASE_FR_0_MD5='da1f4dad3ee3817a026390fa28320284'
ARCHIVE_BASE_FR_0_TYPE='mojosetup'
ARCHIVE_BASE_FR_0_SIZE='350000'
ARCHIVE_BASE_FR_0_VERSION='1.0-gog17654'
ARCHIVE_BASE_FR_0_URL='https://www.gog.com/game/call_of_cthulhu_prisoner_of_ice'

CONTENT_PATH_DEFAULT='data/noarch/data'
CONTENT_GAME_MAIN_FILES='
ICE
CD'
CONTENT_DOC_MAIN_FILES='
*.TXT'
CONTENT_DOC0_MAIN_PATH='data/noarch/docs'
CONTENT_DOC0_MAIN_FILES='
*.pdf
*.txt'
CONTENT_DOC1_MAIN_PATH_EN='data/noarch/docs/english'
CONTENT_DOC1_MAIN_PATH_FR='data/noarch/docs/french'
CONTENT_DOC1_MAIN_FILES='
*.pdf
*.txt'

GAME_IMAGE='CD'
GAME_IMAGE_TYPE='cdrom'

APP_MAIN_EXE='ICE640.EXE'
APP_MAIN_PRERUN='d:'
APP_MAIN_ICON='../support/icon.png'

USER_PERSISTENT_FILES='
ICE/*.CFG
ICE/*.ICE
ICE/*.PCK'

PACKAGES_LIST='PKG_MAIN'

PKG_MAIN_ID="$GAME_ID"
PKG_MAIN_ID_EN="${PKG_MAIN_ID}-en"
PKG_MAIN_ID_FR="${PKG_MAIN_ID}-fr"
PKG_MAIN_PROVIDE="$PKG_MAIN_ID"
PKG_MAIN_DEPS='dosbox'

# Load common functions

target_version='2.19'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'
(
	cd "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)"

	toupper .
)

# Include game icons

icons_inclusion

# Include game data

content_inclusion_default

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

launchers_write

# Build package

write_metadata
build_pkg

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
