 --[[ Copyright (c) 2024 by Yurii (JurecStrongman)

Permission is hereby granted, free of charge, to any person obtaining a copy of
this software and associated documentation files (the "Software"), to deal in
the Software without restriction, including without limitation the rights to
use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
of the Software, and to permit persons to whom the Software is furnished to do
so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE. --]]

Font("unicode")
Language("Українська", "Ukrainian", "uk", "ukr")
Inherit("english")
Encoding(utf8)
IsArabicNumerals(true)

main_menu = {
  new_game = "Нова гра",
  custom_campaign = "Користувацька гра",
  custom_level = "Користувацький рівень",
  continue = "Продовжити гру",
  load_game = "Завантажити гру",
  options = "Налаштування",
  map_edit = "Редактор рівнів",
  savegame_version = "Версія збереження: ",
  updates_off = "Не перевіряти оновлення",
  version = "Версія: ",
  exit = "Вихід",
}
new_game_window = {
  caption = "Нова гра",
  player_name = "Ім'я гравця",
  option_on = "Увімк",
  option_off = "Вимк",
  difficulty = "Складність",
  easy = "Інтерн (Легкий)",
  medium = "Лікар (Середній)",
  hard = "Спеціаліст (Складний)",
  tutorial = "Навчання",
  start = "Почати",
  cancel = "Відмінити",
}
menu_options_warmth_colors = {
  choice_1 = "    ЧЕРВОНИЙ  ",
  choice_2 = "    СИНІЙ ЗЕЛЕНИЙ ЧЕРВОНИЙ  ",
  choice_3 = "    ЖОВТИЙ ПОМАРАНЧЕВИЙ ЧЕРВОНИЙ  ",
}
date_format = {
  daymonth = "%1% %2:months%",
}
custom_game_window = {
  caption = "Користувацький рівень",
  free_build = "Вільне будівництво",
  load_selected_level = "Почати",
}
load_game_window = {
  caption = "Завантажити гру (%1%)",
  load_button = "Завантажити",
}
save_game_window = {
  caption = "Зберегти гру (%1%)",
  new_save_game = "Нове збереження",
  missing_filename = "Введіть нове ім'я для збереження або виберіть для перезапису",
  save_button = "Зберегти",
}
folders_window = {
  caption = "Місцезнаходження папок",
  data_label = "Дані гри TH",
  font_label = "Шрифт",
  music_label = "Музика",
  savegames_label = "Збереження",
  screenshots_label = "Скріншоти",
  -- next four are the captions for the browser window, which are called from the folder setting menu
  new_th_location = "Тут ви можете вибрати папку де зберігається встановлена гра Theme Hospital чи ISO файл. Коли ви виберете нову папку гра буде перезавантажена. Примітка: Типи файлів не відображаються.",
  savegames_location = "Виберіть папку розташування збережень гри",
  music_location = "Виберіть папку для додавання своєї музики у гру",
  screenshots_location = "Виберіть папку для збереження своїх Скріншотів",
  back  = "Назад",
}
customise_window = {
  caption = "Користувацькі налаштування",
  option_on = "Увімк",
  option_off = "Вимк",
  back = "Назад",
  movies = "Загальне керування відеорядом",
  intro = "Програвати Інтро",
  paused = "Будувати у паузі",
  volume = "Зменш. гучності Хоткей",
  aliens = "Пацієнти з Інопланетною ДНК",
  fractured_bones = "Зламані кістки",
  average_contents = "Зберігати предмети кімнат",
  remove_destroyed_rooms = "Видаляти знищені кабінети",
}
options_window = {
  caption = "Налаштування",
  option_on = "Увімк",
  option_off = "Вимк",
  option_enabled = "Задіяно",
  option_disabled = "Не задіяно",
  fullscreen = "Повний екран",
  resolution = "Роздільна здатність",
  capture_mouse = "Захопити мишу",
  right_mouse_scrolling = "Гортання мишею",
  right_mouse_scrolling_option_middle = "Середня кнопка",
  right_mouse_scrolling_option_right = "Права кнопка",
  custom_resolution = "Користувацька...",
  width = "Ширина",
  height = "Висота",
  audio = "Загальні аудіо",
  customise = "Більше налаштувань",
  folder = "Папки",
  language = "Мова гри",
  apply = "Застосувати",
  cancel = "Відмінити",
  back = "Назад",
  scrollspeed = "Швидкість гортання",
  shift_scrollspeed = "Пришвидшене гортанння",
  zoom_speed = "Швидкість наближення",
  hotkey = "Гарячі клавіші",
  check_for_updates = "Перевірити оновлення",
  jukebox = "Програвач",
  change_resolution = "Змінити розд. здат.",
}
menu_list_window = {
  name = "Ім'я",
  back = "Назад",
  save_date = "Змінено",
  ok = "Добре",
}
update_window = {
  caption = "Є свіже оновлення!",
  new_version = "Нова Версія:",
  current_version = "Поточна Версія: ",
  download = "Перейти на сторінку завантаження",
  ignore = "Пропустити і повернутись у Головне меню",
}
save_map_window = {
  caption = "Збережені мапи (%1%)",
  new_map = "Нова мапа",
  missing_filename = "Будь ласка введіть назву нового файлу мапи чи виберіть файл мапи для перезапису.",
  save_button = "Зберегти",
}
hotkey_window = {
  caption_main = "Назначити гарячі клавіші",
  caption_panels = "Клавіші панелі",
  button_accept = "Прийняти",
  button_defaults = "Скинути до початкових",
  button_cancel = "Відмінити",
  button_back = "Назад",
  button_toggleKeys = "Клавіші перемикання",
  button_gameSpeedKeys = "Клавіші швидкості гри",
  button_recallPosKeys = "Клавіші відновлення позиції",
  panel_globalKeys = "Загальні клавіші",
  panel_generalInGameKeys = "Основні внутрішньоігрові клавіші",
  panel_scrollKeys = "Клавіші гортання",
  panel_zoomKeys = "Клавіші збільшення",
  panel_gameSpeedKeys = "Клавіші швидкості гри",
  panel_toggleKeys = "Клавіші перемикання",
  panel_debugKeys = "Debug клавіші",
  panel_storePosKeys = "Клавіші збереження позиції",
  panel_recallPosKeys = "Клавіші відновлення позиції",
  panel_altPanelKeys = "Клавіші додаткової панелі",
  global_confirm = "Підтвердити",
  global_confirm_alt = "Підтвердити Дод.",
  global_cancel = "Відмінити",
  global_cancel_alt = "Відмінити Дод.",
  global_fullscreen_toggle = "Повний екран",
  global_exitApp = "Вийти з додатка",
  global_resetApp = "Скинути додаток",
  global_releaseMouse = "Звільнити мишу",
  global_connectDebugger = "Debugger",
  global_showLuaConsole = "Lua Консоль",
  global_runDebugScript = "Debug Script",
  global_screenshot = "Скріншот",
  global_stop_movie_alt = "Зупинити Відеоряд",
  global_window_close_alt = "Закрити вікно",
  ingame_scroll_up = "Гортати вверх",
  ingame_scroll_down = "Гортати вниз",
  ingame_scroll_left = "Гортати вліво",
  ingame_scroll_right = "Гортати вправо",
  ingame_scroll_shift = "Пришвидшене гортання",
  ingame_zoom_in = "Збільшити",
  ingame_zoom_in_more = "Збільшити Ще",
  ingame_zoom_out = "Зменшити",
  ingame_zoom_out_more = "Зменшити Ще",
  ingame_reset_zoom = "Скинути збільшення",
  ingame_showmenubar = "Відобразити рядок меню",
  ingame_showCheatWindow = "Меню Чітів",
  ingame_loadMenu = "Завантажити гру",
  ingame_saveMenu = "Зберегти гру",
  ingame_jukebox = "Програвач",
  ingame_openFirstMessage = "Повідомлення рівня",
  ingame_pause = "Пауза",
  ingame_gamespeed_slowest = "Найповільніша",
  ingame_gamespeed_slower = "Повільна",
  ingame_gamespeed_normal = "Нормальна",
  ingame_gamespeed_max = "Швидка",
  ingame_gamespeed_thensome = "Ще трохи",
  ingame_gamespeed_speedup = "Прискорена",
  ingame_panel_bankManager = "Менеджер банку",
  ingame_panel_bankStats = "Показники банку",
  ingame_panel_staffManage = "Керування персоналом",
  ingame_panel_townMap = "Мапа містечка",
  ingame_panel_casebook = "Книга захворювань",
  ingame_panel_research = "Дослідження",
  ingame_panel_status = "Статус",
  ingame_panel_charts = "Графіки",
  ingame_panel_policy = "Політика",
  ingame_panel_map_alt = "Мапа містечка 2",
  ingame_panel_research_alt = "Дослідження 2",
  ingame_panel_casebook_alt = "Книга захворювань 2",
  ingame_panel_casebook_alt02 = "Книга захворювань 3",
  ingame_panel_buildRoom = "Будувати кімнату",
  ingame_panel_furnishCorridor = "Оздобити коридор",
  ingame_panel_editRoom = "Змінити кімнату",
  ingame_panel_hireStaff = "Найняти персонал",
  ingame_rotateobject = "Обертати об'єкт",
  ingame_quickSave = "Швидке збереження",
  ingame_quickLoad = "Швидке завантаження",
  ingame_restartLevel = "Перезапустити рівень",
  ingame_quitLevel = "Покинути рівень",
  ingame_setTransparent = "Прозорий",
  ingame_toggleAnnouncements = "Анонси",
  ingame_toggleSounds = "Звуки",
  ingame_toggleMusic = "Музика",
  ingame_toggleAdvisor = "Радник",
  ingame_toggleInfo = "Інформація",
  ingame_poopLog = "Dump Log",
  ingame_poopStrings = "Dump Strings",
  ingame_patient_gohome = "Відправити додому",
  ingame_storePosition_1 = "1",
  ingame_storePosition_2 = "2",
  ingame_storePosition_3 = "3",
  ingame_storePosition_4 = "4",
  ingame_storePosition_5 = "5",
  ingame_storePosition_6 = "6",
  ingame_storePosition_7 = "7",
  ingame_storePosition_8 = "8",
  ingame_storePosition_9 = "9",
  ingame_storePosition_0 = "10",
  ingame_recallPosition_1 = "1",
  ingame_recallPosition_2 = "2",
  ingame_recallPosition_3 = "3",
  ingame_recallPosition_4 = "4",
  ingame_recallPosition_5 = "5",
  ingame_recallPosition_6 = "6",
  ingame_recallPosition_7 = "7",
  ingame_recallPosition_8 = "8",
  ingame_recallPosition_9 = "9",
  ingame_recallPosition_0 = "10",
}
tooltip = {
  main_menu = {
    new_game = "Почніть перший рівень кампанії",
    custom_campaign = "Зіграйте кампанію створену спільнотою",
    custom_level = "Збудуйте вашу лікарню на користувацькій мапі",
    continue = "Продовжіть свою останню збережену гру",
    load_game = "Завантажте збережену гру",
    options = "Налаштуйте різні аспекти гри",
    map_edit = "Створіть користувацьку мапу",
    exit = "Ой ні, ні! Будь ласка не йдіть!",
    quit = "Ви майже вийшли з CorsixTH. Ви цілком впевнені, що хочете так вчинити?",
  },
  new_game_window = {
    player_name = "Введіть ім'я яким би хотіли назватись у грі",
    difficulty = "Вибертіть складність гри з якою ви б хотіли грати",
    easy = "Якщо Ви новачок у економічних симуляторах, ця опція саме для Вас",
    medium = "Це найоптимальніший вибір, якщо Ви не можете визначитись",
    hard = "Якщо Ви сильні у цьому типі гри і хочете справжнього виклику, обирайте цей варіант",
    tutorial = "Натисніть тут, щоб увімкнути невеличку допомогу на початку гри",
    start = "Почати гру з вибраними налаштуваннями",
    cancel = "ОЙ, Я і не думав починати нову гру!",
  },
  totd_window = {
    previous = "Показати попередню підказку",
    next = "Показати наступну підказку",
  },
  options_window = {
    fullscreen = "Запускати гру на весь екран чи у вікні?",
    fullscreen_button = "Натисніть щоб змінити режим вікна",
    resolution = "Роздільна здатність з якою повинна запускатись гра",
    select_resolution = "Вибрати нову роздільну здатність",
    capture_mouse = "Натисніть, чи захоплювати курсор мищі у вікні гри",
    right_mouse_scrolling = "Перемкнути клавішу миші яка використовується для гортанння",
    width = "Введіть бажану ширинку вікна",
    height = "Введіть бажану висоту вікна",
    apply = "Застосувати введену роздільну здатність",
    cancel = "Не застосовувати зміну роздільної здатності",
    audio_button = "Ввімкнути або вимкнути все ігрове аудіо",
    audio_toggle = "Ввімкнути або вимкнути",
    customise_button = "Більше налаштувань, щоб персоналізувати свій ігровий досвід",
    folder_button = "Налаштування папки",
    language = "Мова, яка використовуватиметься у грі",
    select_language = "Виберіть мову гри",
    language_dropdown_item = "%s буде мовою гри",
    language_dropdown_no_font = "Виберіть шрифт у налаштованій папці, щоб задіяти цю мову",
    back = "Закрити вікно налаштувань",
    scrollspeed = "Виберіть швидкість гортання від 1 (найповільніша) до 10 (найшвидша). За замовчуванням - 2.",
    shift_scrollspeed = "Виберіть швидкість гортання коли клавіша Shift затиснута. 1 (найповільніша) до 10 (найшвидша). За замовчуванням - 4.",
    zoom_speed = "Виберіть швидкість приближення камери від 10 (найповільніша) до 1000 (найшвидша). За замовчуванням - 80.",
    apply_scrollspeed = "Задіяти введену швидкість гортання.",
    cancel_scrollspeed = "Повернутись без зміни швидкості гортання.",
    apply_shift_scrollspeed = "Задіяти введену пришвидшену швидкість гортанння.",
    cancel_shift_scrollspeed = "Повернутись без зміни пришвидшеної швидкості гортанння.",
    apply_zoomspeed = "Задіяти швидкість приближення.",
    cancel_zoomspeed = "Повернутись без зміни швидкості приближення.",
    hotkey = "Змінити гарячі клавіші.",
    check_for_updates = "Чи повинна гра перевіряти оновлення після запуску?",
    jukebox = "Відкрити програвач, щоб налаштувати музику",
    change_resolution = "Змінити роздільну здатність на розміри, що вказані зліва",
  },
  save_game_window = {
    save_game = "Перезаписати гру «%s»",
    new_save_game = "Введіть ім'я нової гри",
  },
  load_game_window = {
    load_game = "Завантажити гру %s",
    load_game_number = "Завантажити гру %d",
    load_autosave = "Завантажити автозбереження",
  },
  hotkey_window = {
    button_accept = "Задіяти та зберегти задані гарячі клавіші",
    button_defaults = "Скинути всі гарячі клавіші до стандартних",
    button_cancel = "Відмінити задання клавіш і повернутись у вікно налаштувань",
    caption_panels = "Відкрити вікно для задання гарячих клавіш панелі",
    button_gameSpeedKeys = "Відкрити вікно для задання клавіш керування швидкістю гри",
    button_recallPosKeys = "Відкрити вікно для задання клавіш зберігання і відновлення позиції камери",
    button_back_02 = "Повернутись до основного меню гарячих клавіш. Зміни із цього вікна застосуютьс там",
  },
  custom_campaign_window = {
    choose_campaign = "Виберіть кампанію, щоб дізнатись про неї більше",
    start_selected_campaign = "Почати перший рівень цієї кампанії.",
  },
}

load_map_window = {
  caption = "Завантажити мапу (%1%)",
  load_button = "Завантажити",
}

menu = {
  file =    "  ГРА  ",
  player_count = "  КІЛЬКІСТЬ ГРАВЦІВ  ",
  options = "  НАЛАШТУВАННЯ  ",
  charts =  "  ГРАФІКИ  ",
  display = "  ДИСПЛЕЙ  ",
  debug = "  ДЕБАГ  ",
}
menu_file = {
  load =    "  (%1%) ЗАВАНТАЖИТИ ",
  save =    "  (%1%) ЗБЕРЕГТИ ",
  restart = "  (%1%) ПЕРЕЗАПУСТИТИ ",
  quit =    "  (%1%) У ГОЛОВНЕ МЕНЮ ",
}
menu_options = {
  game_speed =        "    ШВИДКІСТЬ ГРИ ",
  sound_vol =         "    ГУЧНІСТЬ ЗВУКІВ ",
  music_vol =         "    ГУЧНІСТЬ МУЗИКИ ",
  edge_scrolling =    "    ГОРТАННЯ МИШЕЮ ",
  announcements =     "    (%1%) ПОВІДОМЛЕННЯ ",
  lock_windows =      "    ЗАФІКСУВАТИ ВІКНА ",
  sound =             "    (%1%) ЗВУКИ ",
  announcements_vol = "    ГУЧНІСТЬ ПОВІДОМЛЕНЬ ",
  music =             "    (%1%) МУЗИКА ",
  autosave =          "    АВТОЗБЕРЕЖЕННЯ ",
  jukebox =           "    (%1%) ПРОГРАВАЧ ",
  twentyfour_hour_clock = "    24-Х ГОДИННИЙ ФОРМАТ ЧАСУ ",
  wage_increase = "    ЗАПИТИ НАДБАВКИ ",
  warmth_colors = "    КОЛЬОРИ ОПАЛЕННЯ ",
  adviser_disabled = "    (%1%) РАДНИК  ",
  capture_mouse = "  ЗАХОПЛЕННЯ МИШІ  ",
}
menu_options_game_speed = {
  pause =              "    (%1%) ПАУЗА ",
  slowest =            "    (%1%) НАЙПОВІЛЬНІША ",
  slower =             "    (%1%) ПОВІЛЬНА ",
  normal =             "    (%1%) ЗВИЧАЙНА ",
  max_speed =          "    (%1%) ШВИДКА ",
  and_then_some_more = "    (%1%) І ЩЕ ТРОШКИ ",
}
menu_options_wage_increase = {
  grant = "    ДОЗВОЛИТИ ",
  deny = "    ЗАБОРОНИТИ ",
}
menu_charts = {
  bank_manager  = "  (%1%) МЕНЕДЖЕР БАНКУ  ",
  statement     = "  (%1%) ПОКАЗНИКИ БАНКУ  ",
  staff_listing = "  (%1%) СПИСОК ПЕРСОНАЛУ  ",
  town_map      = "  (%1%) МАПА МІСТЕЧКА  ",
  casebook      = "  (%1%) КНИГА ЗАХВОРЮВАНЬ  ",
  research      = "  (%1%) ДОСЛІДЖЕННЯ  ",
  status        = "  (%1%) СТАТУС  ",
  graphs        = "  (%1%) ГРАІФКИ  ",
  policy        = "  (%1%) ПОЛІТИКА  ",
  briefing =      "  ІНСТРУКЦІЇ",
}
menu_file_load = {
  [1] = "  ГРА 1  ",
  [2] = "  ГРА 2  ",
  [3] = "  ГРА 3  ",
  [4] = "  ГРА 4  ",
  [5] = "  ГРА 5  ",
  [6] = "  ГРА 6  ",
  [7] = "  ГРА 7  ",
  [8] = "  ГРА 8  ",
}
menu_debug_overlay = {
  heat = "  ТЕМПЕРАТУРА  ",
  byte_0_1 = "  БАЙТ 0 & 1  ",
  byte_6 = "  БАЙТ 6  ",
  flags = "  АТРИБУТИ  ",
  byte_7 = "  БАЙТ 7  ",
  byte_5 = "  БАЙТ 5  ",
  byte_floor = "  БАЙТ ФЛУР  ",
  positions = "  КООРДИНАТИ  ",
  byte_w_wall = "  БАЙТ ЗАХ. СТІН  ",
  parcel = "  ДІЛЯНКИ  ",
  byte_n_wall = "  БАЙТ ПІВН. СТІН  ",
  none = "  ПРИБРАТИ ОВЕРЛЕЙ  ",
  object_cells = "  КЛІТИНИ ОБ'ЄКТІВ         ",
  display_big_cells = "  ВІДОБРАЗИТИ ВЕЛИКІ КЛІТИНИ    ",
  entry_cells = "  КЛІТИНИ ВХОДІВ          ",
  enter_nav_debug = "  УВІЙТИ НАВ. ДЕБАГ      ",
  allow_falling = "  ДОЗВОЛИТИ ПАДАТИ  ",
  plant_pagers = "  ПЕЙДЖЕРИ РОСЛИН         ",
  show_help_hotspot = "  SHOW HELP HOTSPOTS   ",
  pixbuf_cells = "  PIXBUF CELLS         ",
  keep_clear_cells = "  КЛІТИНИ ТРИМАТИ ЧИСТИМИ     ",
  win_level_anim = "  ВИГРАТИ ГРУ АНІМ       ",
  show_nav_cells = "  ПОКАЗАТИ НАВ. КЛІТИНИ       ",
  lose_game_anim = {
    [1] = "  ПРОГРАТИ ГРУ 1 АНІМ     ",
    [2] = "  ПРОГРАТИ ГРУ 2 АНІМ     ",
    [3] = "  ПРОГРАТИ ГРУ 3 АНІМ     ",
    [4] = "  ПРОГРАТИ ГРУ 4 АНІМ     ",
    [5] = "  ПРОГРАТИ ГРУ 5 АНІМ     ",
    [6] = "  ПРОГРАТИ ГРУ 6 АНІМ     ",
    [7] = "  ПРОГРАТИ ГРУ 7 АНІМ     ",
  },
  porter_pagers = "  ПЕЙДЖЕРИ ПЕРЕНЕСЕННЯ        ",
  machine_pagers = "  ПЕЙДЖЕРИ АПАРАТІВ       ",
  nav_bits = "  НАВ. БІТИ             ",
  display_room_status = "  ВІДОБРАЗИТИ СТАТУС КІМНАТИ  ",
  mapwho_checking = "  MAPWHO CHECKING      ",
}
menu_file_save = {
  [1] = "  ГРА 1  ",
  [2] = "  ГРА 2  ",
  [3] = "  ГРА 3  ",
  [4] = "  ГРА 4  ",
  [5] = "  ГРА 5  ",
  [6] = "  ГРА 6  ",
  [7] = "  ГРА 7  ",
  [8] = "  ГРА 8  ",
}
menu_display = {
  shadows = "  ТІНІ  ",
  mcga_lo_res = "  MCGA НИЗЬКА РОЗД. ЗДАТ.  ",
  high_res = "  ВИСОКА РОЗД. ЗДАТ.  ",
}
menu_player_count = {
  players_1 = "  1 Гравець  ",
  players_2 = "  2 Гравці  ",
  players_3 = "  3 Гравці  ",
  players_4 = "  4 Гравці  ",
}

install = {
  title = "--------------------------------- Встановлення CorsixTH ---------------------------------",
  th_directory = "Для CorsixTH потрібні оригінальні файли Theme Hospital (Або її Демо версії). Вкажить шлях до даних гри нижче.",
  exit = "Вихід",
  ok = "OK",
  cancel = "Відмінити",
}
dynamic_info = {
  patient = {
    emergency = "Надзвичайна ситуація: %s",
    guessed_diagnosis = "Діагноз навмання: %s ",
    diagnosis_progress = "Прогрес діагностування",
    actions = {
      sent_to_other_hospital = "Відправлений у іншу лікарню",
      prices_too_high = "Ваші ціни занадто високі, - я йду додому",
      no_gp_available = "Чекає, коли ж ви збудуєте кабінет терапевта",
      waiting_for_treatment_rooms = "Очікує появи кабінету для лікування",
      dying = "Помирає...",
      no_diagnoses_available = "У вас немає нормального діагностування! Я йду.",
      epidemic_sent_home = "Відправлений додому сан. інспектором",
      cured = "Вилікуваний!",
      waiting_for_diagnosis_rooms = "Очікує, найскорішої появи кабінету для діагностуання",
      epidemic_contagious = "Заразливий!",
      awaiting_decision = "Очікує вашого рішення",
      sent_home = "Відправлений додому",
      fed_up = "Дістало все!",
      no_treatment_available = "У вас немає належного ліківання. Бувайте!",
      on_my_way_to = "Йде до кабінету: %s",
      queueing_for = "У черзі в кабінет: %s",
      epidemic_vaccinated = "Вакцинований!",
    },
    diagnosed = "Визначено захворювання: %s ",
  },
  health_inspector = "Сан. Інспектор",
  vip = "ВІП",
  object = {
    times_used = "Використано разів: %d",
    queue_size = "Довжина черги: %d",
    strength = "Міцність: %d",
    queue_expected = "Очікувана черга: %d",
    strength_extra_info = "Міцність %d (Покращується до %d)"
  },
  staff = {
    actions = {
      going_to_repair = "Йде ремонтувати %s",
      fired = "Звільнений",
      waiting_for_patient = "Очікує пацієнта",
      wandering = "Безцільно блукає",
      heading_for = "Йде в кабінет: %s",
      vaccine = "Вакцинування",
    },
    tiredness = "Втома",
    psychiatrist_abbrev = "Псих.",
    ability = "Здібності:",
  },
}
handyman_window = {
  all_parcels = "Всі ділянки",
  parcel = "Ділянка",
}
font_location_window = {
  caption = "Виберіть шрифт (%1%)",
}
staff_title = {
  junior = "Інтерн",
  doctor = "Лікар",
  consultant = "Спеціаліст",
  psychiatrist = "Психіатр",
  surgeon = "Хірург",
  researcher = "Дослідник",
  nurse = "Медсестра",
  receptionist = "Рецепціоністка",
  general = "Загальна",
}
tooltip = {
  toolbar = {
    bank_button = "Ліва кнопка - Менеджер банку, права - Показники банку",
    balance = "Баланс лікарні",
    reputation = "Репутація лікарні",
    date = "Дата",
    rooms = "Кабінети для будування",
    objects = "Об'єкти для оздоблення коридору",
    edit = "Змінити кабінет або облаштування",
    hire = "Найняти новий персонал",
    staff_list = "Керувати найнятими працівниками",
    town_map = "Мапа",
    casebook = "Книга захворювань",
    research = "Дослідження",
    status = "Статус",
    charts = "Графіки",
    policy = "Політика",
  },
  menu_list_window = {
    name = "Натисніть тут, щоб сортувати список за ім'ям",
    save_date = "Натисніть тут, щоб сортувати список за датою зміни файлу",
    ok = "Підтвердити вибір",
    back = "Закрити це вікно",
  },
  custom_game_window = {
    choose_game = "Виберіть рівень, щоб прочитати про нього більше",
    free_build = "Клікніть тут, якщо Ви хочете пограти не задумуючись про гроші чи цілі",
    load_selected_level = "Завантажити та запустити вибраний рівень",
  },
  casebook = {
    cure_type = {
      drug = "Для лікування будуть використані такі ліки:",
      unknown = "Ви ще не знаєте як вилікувати цю заразу",
    },
    cure_requirement = {
      hire_staff = "Вам потрібно найняти працівника, щоб почати лікування",
      hire_surgeon = "Найміть другого Хірурга для проведення операцій",
      not_possible = "Зараз Ви неспроможні вилікувати цю хворобу",
      hire_staff_old = "%s потрібен для проведення лікування",
      hire_surgeons = "Для проведення операцій найміть ДВОХ Хірургів",
      build_ward = "Вам необхідно побудувати Палату для проведення цього лікування",
      ward_hire_nurse = "Потрібно найняти Медсестру для роботи у Палаті і проведення цього лікування",
    },
  },
  main_menu = {
    load_menu = {
      load_slot = "ЗАВАНТАЖИТИ ГРУ",
      empty_slot = "ПОРОЖНЬО",
      network = "ЗАПУСТИТИ МЕРЕЖЕВУ ГРУ",
    },
  },
  update_window = {
    download = "Перейти на сторінку завантаження актуальної версії CorsixTH",
    ignore = "Ігнорувати це оновлення поки. Вам нагадають про нього після наступного запуску CorsixTH",
  },
  save_map_window = {
    map = "Перезаписати мапу %s",
    new_map = "Введіть ім'я для збереженої мапи",
  },
  folders_window = {
    browse_font = "Вибрати інший файл шрифта ( Поточне розташування: %1% )",
    screenshots_location = "За замовчуванням, Скріншоти зберігаються у папці, котра поряд із файлом конфігурації. Натомість Ви можете вибрати власну папку вибравши директорію, яку ви хочете використовувати.",
    reset_to_default = "Встановити папку за замовчуванням",
    back = "Закрити це меню і повернутись до Меню налаштувань",
    music_location = "Виберіть розташування власної музики вибравши директорію, яку ви збираєтесь використовувати (Директорія вже має бути створеною).",
    font_location = "Виберіть розташування файлу шрифта, який підтримує Unicode символи, якщо цього потребує вибрана Вами мова. Якщо його не вказати, Ви не зможете вибрати мову, символів якої не було у оригінаьній грі.",
    savegames_location = "За замовчуванням, Файли збережень зберігаються у папці, котра поряд із файлом конфігурації. Натомість Ви можете вибрати власну папку вибравши директорію, яку ви хочете використовувати.",
    browse_data = "Виберіть інше розташування файлів гри встановленої Theme Hospital ( Поточне розташування: %1% ) ",
    browse = "Перегляд папок",
    browse_screenshots = "Виберіть інше розташування папки Скріншоти ( Поточне розташування: %1% ) ",
    browse_music = "Виберіть інше розташування папки Музика ( Поточне розташування: %1% ) ",
    no_font_specified = "Розташування файлу Шрифта поки не вказане!",
    not_specified = "Розташування папки поки не вказане!",
    browse_saves = "Виберіть інше розташування папки для Файлів збережень ( Поточне розташування: %1% ) ",
    default = "Місцезнаходження за замовчуванням",
    data_location = "Папка, де зберігається встановлена гра Theme Hospital чи ISO файл, вона необхідна для запуску CorsixTH",
  },
  customise_window = {
    movies = "Загальне управління відеорядом, це дозволить Вам відключити весь відеоряд.",
    intro = "Увімкнути або вимкнути вступний ролик. Загальний відеоряд має бути ввімкненим, якщо Ви хочете бачити вступний ролик кожного разу, як запускаєте CorsixTH.",
    paused = "У Theme Hospital гравець міг використовувати тільки меню у верхньому краю екрана, коли гра була на паузі. У CorsixTH так само за замовчуванням, але увімкнувши цю опцію можна робити все що завгодно, коли гра на паузі.",
    volume = "Якщо клавіша зниження гучності також відкриває Книгу захворювань, увімкніть цю опцію, щоб змінити гарячу клавішу Книги захворювань на Shift+C.",
    aliens = "Через відсутність коректних анімацій, за замовчуванням пацієнти з Інопланетною ДНК будуть приходити лише  під час Надзвичайної ситуації. Вимкніть цю опцію, щоб пацієнти з Інопланетною ДНК відвідували лікарню, як і звичайні пацієнти.",
    fractured_bones = "Через погані анімації з оригінальної гри, не буде Пацієнток зі Зламаними кістками. Щоб дозволити Пацієнткам зі Зламаними кістками відвідувати Вашу лікарню, вимкніть цю опцію.",
    average_contents = "Якщо Ви хочете щоб гра запам'ятовувала додаткові об'єкти, які ви використовуєте при облаштуванні кімнат, увімкніть цю опцію.",
    remove_destroyed_rooms = "Якщо хочете мати змогу видаляти знищені кабінети, за певну платню, увімкніть цю опцію.",
    back = "Закрити це меню і повернутись до Головного меню",
  },
  handyman_window = {
    happiness = "Задовільність",
    salary = "Зарплатня",
    parcel_select = "Ділянка де Різноробочий виконує свою роботу, натисніть щоб змінити",
    tiredness = "Втома",
    sack = "Звільнити",
    close = "Закрити",
    face = "Фото працівника",
    pick_up = "Підняти",
    center_view = "Центрувати екран на працівнику",
    name = "Ім'я працівнка",
    ability = "Здібності",
  },
  debug_patient_window = {
    item = "Створити тестового пацієнта з хворобою: %s",
  },
  research_policy = {
    no_research = "У цей момент досліджень цієї категорії не виконується",
    research_progress = "Прогрес до наступного відкриття у цій категорії: %1%/%2%",
  },
  objects = {
    lamp = "Лампа: випромінює світло і дозволяє бачити хоч щось.",
    op_sink1 = "33 РАКОВИНА",
    litter_bomb = "Сміттєва бомба: саботує роботу лікарні конкурента",
    x_ray = "27 РЕНТГЕН",
    projector = "37 ПРОЕКТОР",
    radiation_shield = "28 ПРОТИРАДІАЦІЙНИЙ ЩИТ",
    entrance_left = "58 ЛІВІ ВХІДНІ ДВЕРІ",
    table2 = "12 СТІЛ",
    bed2 = "невикористовувалась",
    console = "15 КОНСОЛЬ КЕРУВАННЯ",
    operating_table = "30 ОПЕРАЦІЙНИЙ СТІЛ",
    x_ray_viewer = "29 РЕНТГЕН ЕКРАН",
    crash_trolley = "20 АВАРІЙНИЙ ВІЗОК",
    shower = "54 ЗНЕЗАРАЖУЮЧИЙ ДУШ",
    electrolyser = "46 ЭЛЕКТРОЛІЗАТОР",
    hair_restorer = "25 ВІДНОВЛЮВАЧ ВОЛОССЯ",
    jelly_moulder = "47 ЗНЕЖЕЛЕЮВАЧ",
    couch = "18 КУШЕТКА",
    surgeon_screen = "35 ОПЕРАЦІЙНА ШИРМА",
    bed3 = "невикористовувалась",
    dna_fixer = "23 ВІДНОВЛЮВАЧ ДНК",
    chair = "Стілець: пацієнти на ньому сидять і обговорюють свої захворювання.",
    cast_remover = "24 ГІПСОВИДАЛЯТОР",
    entrance_right = "59 ПРАВІ ВХІДНІ ДВЕРІ",
    cardio = "13 КАРДІОГРАФ",
    slicer = "26 РІЗАК",
    table1 = "Стіл (ВИДАЛЕНИЙ): у ньому є журнали, щоб пацієнти трохи відволіклись.",
    ultrascanner = "22 АПАРАТ КТ",
    scanner = "14 АПАРАТ МРТ",
    op_sink2 = "34 РАКОВИНА",
    door = "Двері: люди можуть відчиняти і зачиняти ї безліч разів.",
    swing_door2 = "53 РОЗПАШНІ ДВЕРІ",
    screen = "16 ШИРМА",
    gates_of_hell = "48 ВОРОТА ДО ПЕКЛА",
    blood_machine = "42 КРОВОЗБИРАЧ",
    comfortable_chair = "61 КОМФОРТНЕ КРІСЛО",
    swing_door1 = "52 РОЗПАШНІ ДВЕРІ",
    rathole = "Дім сім'ї пацючат, для яких Ваша лікарня досить брудна, щоб вважати її затишним домом.",
  },
}
misc = {
  hospital_open = "Відкрити лікарню",
  save_success = "Гру збережено",
  save_failed = "Помилка: не вдалося зберегти гру",
  low_res = "Низька роздільна здатність",
  no_heliport = "Або не досліджено жодного захворювання, або ж на мапі немає посадкової площадки для гелікоптера. Можливо Вам потрібно поставити Рецепція та найняти Рецепціоністку",
  grade_adverb = {
    extremely = "экстремально",
    mildly = "посереднє",
    moderately = "помірно",
  },
  not_yet_implemented = "(ще не реалізовано)",
  send_message = "Відправити повідомлення гравцю %d",
  out_of_sync = "Розсинхронізація гри",
  balance = "Файл балансу:",
  load_failed = "Збереження не завантажено",
  mouse = "Миша",
  done = "Зроблено",
  force = "Прискорення",
  pause = "Пауза",
  send_message_all = "Відправити повідомлення всім гравцям",
  cant_treat_emergency = "Ваша лікарня не зможе впоратись з цією Надзвичайною ситуацією, бо це захворювання ще недосліджене. Можете спробувати ще раз",
  epidemic_no_diseases = "Неможливо створити епідемію - немає інфекційних захворювань",
  earthquakes_on = "Землетруси реактивовані",
  earthquakes_off = "Землетруси деактивовані",
  epidemics_off = "Епідемії деактивовані",
  epidemics_on = "Епідемії реактивовані",
  epidemic_no_receptionist = "Неможливо створити епідемію - у вас немає рецепції",
  epidemic_no_icon_to_toggle = "Неможливо відобразити/приховати іконки інфікованих - немає активних, невиявлених епідемій",
}
errors = {
  unavailable_screen_size = "Встановлений розмір екрану не підтримується у повноекранному режимі.",
  dialog_missing_graphics = "Вибачте, у файлах демо версії немає цих діалогів.",
  load_prefix = "Помилка під час запуску гри: ",
  no_games_to_contine = "Немає збережених ігор",
  save_prefix = "Помилка при збереженні гри: ",
  map_file_missing = "Незнайдено файл мапи %s для цього рівня!",
  minimum_screen_size = "Будь ласка введіть роздільну здатність хоча б 640x480.",
  alien_dna = "Примітка: У грі немає анімацій сидіння, відкриття чи стукання у двері і т.п., для пацієнтів з Інопланетною ДНК. Так само як і в Theme Hospital, коли відбуватимуться ці дії пацієнти зміняться на нормальних, а потім знов на прибульців. Пацієнти з Інопланетною ДНК з'являтимуться тільки якщо вони прописані у файлі цього рівня.",
  fractured_bones = "Примітка: Анімації пацієнток зі Зламаними кістками неідеальні.",
  load_quick_save = "Помилка, не вдалось завантажити Швидке збереження, бо його немає, не хвилюйтесь, тепер ми створили його для вас!",
  could_not_find_first_campaign_level = "Не вдалось знайти перший рівень цієї кампанії: %s",
  save_to_tmp = "Файл у %s не може бути використаним. Гра була збережена у %s. Помилка: %s",
  could_not_load_campaign = "Неможливо завантажити кампанію: %s",
  compatibility_error = {
    new_in_old = "Вибачте, це збереження створено більш новою версією CorsixTH, тому немає сумісності. Будь ласка оновіть до більш актуальної версії.",
    demo_in_full = "Вибачте, ви не можете завантажити збережену гру із демо версії, коли ви запустили повну версію гри. Будь ласка змініть розташування Дані гри TH у налаштуваннях.",
    full_in_demo = "Вибачте, ви не можете завантажити збережену гру з повної версії, коли ви запустили демо версію гри. Будь ласка змініть розташування Дані гри TH у налаштуваннях.",
  },
  dialog_empty_queue = "Вибачте, гуманоїд має порожню чергу дій, тому вони не знають, що їм робити далі. Будьласка перегляньте командне вікно, щоб дізнатись детальніше про це. Діалог з неправильним гуманоїдом відкритий. Хочете, щоб він покинув лікарню?",
  load_map_prefix = "Помилка під час завантаження мапи: ",
  music = "Є проблема із програванням одного чи більше аудіодоріжок у вашій папці з музикою. Проблемні файли будуть недоступні у програвачі. Перегляньте консоль для отримання детальної інформації.",
  load_level_prefix = "Помилка під час завантаження рівня: ",
}
hotkeys_file_err = {
  file_err_01 = "Не вдалось завантажити hotkeys.txt. Будь ласка впевніться, що у CorsixTH є дозволи на читання/запис. ",
  file_err_02 = ", або використайте параметр командної строки --hotkeys-file=filename, щоб вказали файл, що доступний для запису. До відома, файл, що не завантажився був тут: ",
}

staff_list = {
  morale = "Задовільність",
  tiredness = "Бадьорість",
  skill = "Навички",
  total_wages = "УСЬОГО ЗАРПЛАТНІ",
}
bank_manager = {
  current_loan = "Поточна позика",
  balance = "Баланс",
  interest_payment = "Відсоткова плата",
  hospital_value = "Ціна лікарні",
  interest_rate = "Відсоткова ставка",
  inflation_rate = "Рівень інфляції",
  insurance_owed = "Страховий борг",
  statistics_page = {
    balance = "Баланс",
    details = "Детально",
    date = "Дата",
    current_balance = "Поточний баланс",
    money_in = "Заробіток",
    money_out = "Розтрати",
  },
}
transactions = {
  severance = "Вихідна допомога",
  research = "Фінансування досліджень",
  eoy_trophy_bonus = "Нагороди за підсумками року",
  buy_object = "Купівля",
  cure_colon = "Лікування:",
  wages = "Виплата зарплат",
  personal_bonus = "Виплата премії",
  drug_cost = "Ціна ліків",
  heating = "Рахунок за тепло",
  treat_colon = "Обстеження:",
  hire_staff = "Найняти на роботу",
  bank_loan = "Заборгованість у банку",
  insurance_colon = "Страхування:",
  sell_object = "Продаж",
  loan_interest = "Виплата відсотку за позику",
  loan_repayment = "Погашення позики",
  buy_land = "Купівля ділянки",
  machine_replacement = "Заміна апарату",
  build_room = "Будівництво",
  drinks = "Продаж напоїв",
  cure = "Вилікувано",
  eoy_bonus_penalty = "Нагороди/Штрафи за підсумками року",
  cheat = "Чіт на гроші",
  general_bonus = "Загальна нагорода",
  emergency_bonus = "Нагорода за Надзвичайні ситуації",
  epidemy_coverup_fine = "Штраф за Покриття епідемій",
  research_bonus = "Нагорода за Дослідження",
  final_treat_colon = "Остаточне лікування: ",
  jukebox = "Вхідне: програвач",
  vaccination = "Вакцинація",
  vip_award = "Нагорода від ВІП",
  epidemy_fine = "Штраф за епідемію",
  compensation = "Компенсація від Уряду",
  deposit = "Депозит на лікування",
  advance_colon = "Додатково: ",
  overdraft = "Овердрафт",
  remove_room = "Видаліть знищений кабінет",
}
town_map = {
  number = "Номер ділянки",
  not_for_sale = "Не продається",
  price = "Ціна ділянки",
  for_sale = "Продається",
  owner = "Власник ділянки",
  area = "Площа ділянки",
  chat = "Інформація про місто",
}
high_score = {
  categories = {
    deaths = "Кількість померлих",
    total_value = "Загальна вартість",
    money = "Найбагатший",
    cures = "Кількість вилікуваних",
    visitors = "Кількість відвідувачів",
    salary = "Розмір зарплати",
    clean = "Чистота",
    patient_happiness = "Задовільність пацієнтів",
    cure_death_ratio = "Співвідношення вилікуваних/померлих",
    staff_happiness = "Задовільність працівників",
    staff_number = "Найнято працівників",
  },
  player = "ГРАВЕЦЬ",
  pos = "ПОЗ",
  best_scores = "ЗАЛА ПОШАНИ",
  killed = "ПОМЕРЛО",
  worst_scores = "ЗАЛА ГАНЬБИ",
  score = "РАХУНОК",
}
research = {
  allocated_amount = "Розподілена кількість",
  funds_allocation = "Розподіл фінансування",
  categories = {
    improvements = "Покращення",
    drugs = "Дослідження ліків",
    diagnosis = "Діагностичне обладнання",
    cure = "Обладнання для лікуванння",
    specialisation = "Спеціфлізація",
  },
}
policy = {
  header = "Політика лікарні",
  diag_termination = "Припинення обстеження",
  sliders = {
    guess = "Діагноз навмання",
    send_home = "Відправити додому",
    stop = "Зупинити",
    staff_room = "Відправити на відпочинок",
  },
  diag_procedure = "Процедура обстеження",
  staff_rest = "Відправляти працівників на відпочинок",
  staff_leave_rooms = "Лишати кабінети",
}
casebook = {
  sent_home = "Відправлено додому",
  deaths = "Померлих",
  treatment_charge = "Плата за лікування",
  reputation = "Репутація",
  research = "Зосередити дослідження",
  cure = "Ліки",
  cured = "Вилікувано",
  earned_money = "Грошей зароблено",
  cure_desc = {
    hire_surgeons = "Вам необхідно найняти Хірургів.",
    improve_cure = "Покращити лікування.",
    no_cure_known = "Немає відомого лікування.",
    build_room = "Рекомендую вам збудувати %s",
    hire_psychiatrists = "Вам потрібно найняти Психіатра.",
    build_ward = "Вам потрібна Палата.",
    hire_nurses = "Найміть медсестер.",
    cure_known = "Вилікуваний.",
    hire_doctors = "Візьміть на роботу Лікарів.",
  },
}
progress_report = {
  quite_unhappy = "Відвідувачам не подобається у Вашій лікарні",
  header = "Звіти про прогрес",
  very_unhappy = "Відвідувачі дуже незадоволені обслуговуванням у Вашій лікарні!",
  more_drinks_machines = "Поставте Автомати з напоями. Люди хочуть пити.",
  too_cold = "У лікарні занадто холодно, додайте ще Батарей",
  too_hot = "Налаштуйте систему опалення, у вас заспекотно",
  percentage_pop = "Доля відвідувачів",
  win_criteria = "Умови для перемоги",
  free_build = "Вільне будування",
}
tooltip = {
  staff_list = {
    prev_person = "Попередня сторінка",
    next_person = "Наступна сторінка",
    detail = "Увага до деталей",
    happiness = "Наскільки ваші працівники задоволені своєю роботою",
    tiredness = "Відображає скільки ще зможе працівники працювати без відпочинку",
    ability = "Середні здібності працівників по всій лікарні",
    happiness_2 = "Задовільність працівника",
    ability_2 = "Здібності працівника",
    tiredness_2 = "Запас сил працівника",
    researcher_train = "На %d%% готовий отримати диплом Дослідника",
    surgeon_train = "На %d%% готовий отримати диплом Хірурга",
    psychiatrist_train = "На %d%% готовий отримати диплом Психіатра",
    researcher = "Дипломований дослідник",
    psychiatrist = "Дипломований психіатр",
    surgeon = "Дипломований хірург",
    handymen = "Показати список всіх Різноробочий вашої лікарні",
    nurses = "Показати список всіх Медсестер вашої лікарні",
    doctors = "Показати список всіх Лікарів вашої лікарні",
    receptionists = "Показати список всіх Рецепціоністок вашої лікарні",
    pay_rise = "Підняти зарплату на 10%",
    bonus = "Виплатити премію у 10% від зарплати",
    salary = "Поточна зарплата",
    close = "Повернутись до гри",
    sack = "Звільнити працівника",
    doctor_seniority = "Ступінь доктора",
    view_staff = "Спостерігати за працівником",
    skills = "Додаткові навички",
  },
  town_map = {
    close = "Закрити",
    plants = "Відобразити рослини",
    fire_extinguishers = "Відобразити вогнегасники",
    people = "Відобразити людей",
    balance = "Баланс",
    heat_dec = "Зменшити температуру",
    heating_bill = "Рахунок за опалення",
    radiators = "Відобразити батареїм",
    objects = "Відобразити меблі",
    heat_level = "Температура",
    heat_inc = "Збільшити температуру",
  },
  policy = {
    diag_termination = "Обстеження буде продовжуватись допоки лікарі не будуть в певнені на стільки відсотків у діагнозі або поки не закінчаться усі наявні методи обстеження.",
    close = "Закрити вікно політики",
    staff_leave = "Натисніть тут, щоб дозволити працівникам лишати свої кабінети і йти на поміч своїм колегам.",
    diag_procedure = "Якщо лікар впевнений у діагнозі менше за значення «Відправити додому», пацієнта відпраілять додому. Якщо впевненість вища за «Діагноз навмання», він буде відправлений на лікування. У інших випадках вирішуєте особисто Ви!",
    staff_rest = "Стомленість працівника, коли він може піти на відпочинок.",
    staff_stay = "Натисніть тут, щоб лікарі не могли лишати кабінети, у які Ви їх назначили.",
  },
  bank_manager = {
    graph = "Графік очікуваних виплат від %s",
    close = "Закрити вікно Банку",
    hospital_value = "Поточна вартість лікарні з усім обладнанням",
    graph_return = "Повернутись назад",
    current_loan = "Розмір поточної позики",
    borrow_5000 = "Позика у банку 5000$",
    balance = "Ваш баланс",
    interest_payment = "Щомісячна виплата за позику",
    inflation_rate = "Розмір річної інфляція",
    interest_rate = "Річний відсоток за позикою",
    repay_5000 = "Погасити позику 5000$",
    show_graph = "Відобразити графік очікуваних виплат від %s",
    insurance_owed = "Скільки грошей Вам повинні віддати %s",
  },
  casebook = {
    sent_home = "Кількість пацієнтів відправлених додому",
    increase = "Підняти вартість",
    decrease = "Знизити вартість",
    up = "Уверх",
    down = "Униз",
    reputation = "Репутація за лікування",
    research = "Натисніть, щоб зосередити спеціальний бюджет досліджень на цій пробемі",
    close = "Закрити",
    earned_money = "Всього зароблено грошей",
    deaths = "Кількість померлих",
    cured = "Кількість вилікуваних",
    treatment_charge = "Вартість лікування",
    cure_type = {
      psychiatrist = "Цим займається Психіатр",
      drug_percentage = "У Вас є ліки від цього і вони ефективні на %d%",
      machine = "Для цього потрібен спеціальний апарат",
      surgery = "Потребує Хірургічного втручання",
    },
    cure_requirement = {
      possible = "Ви здатні це вилікувати",
      build_room = "Вам необхідно побудувати відповідний кабінет для лікування",
      research_machine = "Для лікування потрібно дослідити новий апарат",
      hire_staff = "Вам потрібен лікар з відповідними навичками",
    },
  },
  status = {
    population_chart = "Відображає співвідношення кількості відвідувачів різних лікарень",
    percentage_cured = "Вам потрібно вилікувати принаймні %d% відвідувачів Вашої лікарні. Наразі Ви вилікували %d%",
    num_cured = "У цьому рівні Вам потрібно вилікувати %d пацієнтів. Назараз Вам вдалось вилікувати %d",
    thirst = "Середній рівень спраги відвідувачів Вашої лікарні",
    close = "Закрити вікно Статистики",
    win_progress_own = "Показати прогрес на шляху до Вашої перемоги",
    reputation = "Рівень Вашої репутації має бути хоча б %d. Поточна репутація %d",
    population = "Вам потрібно, щоб у Вашій лікарні обслуговувались хоча б %d%% від усього населення",
    warmth = "Средня температура по всій лікарні",
    percentage_killed = "У цій місії важливо не допустити більше %d%% померлих від всіх відвідувачів. Назараз - %d%%",
    balance = "Сума на рахунку лікарні має бути %d$. Зараз у Вас %d$",
    value = "Вартість Вашої лікарні має бути %d$. Поточна вартість %d$",
    win_progress_other = "Відобразити прогрес %s",
    happiness = "Загальна задовільність обслуговуванням у Вашій лікарні",
  },
}

build_room_window = {
  pick_room_type = "Виберіть тип кабінету",
  pick_department = "Виберіть кабінет",
  cost = "Вартість: ",
}
room_classes = {
  diagnosis =  "Обстеження",
  treatment =  "Терапія",
  clinics =    "Лікування",
  facilities = "Службові",
}
rooms_short = {
  gps_office =        "Кабінет терапевта",
  general_diag =      "Загальне обстеження",
  ultrascan =         "Кабінет КТ",
  research_room =     "Кабінет дослідництва",
  fracture_clinic =   "Лікування переломів",
  destroyed =         "Знищено",
  staffroom =         "Кімната відпочинку",
  jelly_vat =         "Лікування ожелеювання",
  scanner =           "Кабінет МРТ",
  decontamination =   "Знезаражування",
  pharmacy =          "Фармакологія",
  cardiogram =        "Кардіографія",
  reception =         "Рецепція",
  training_room =     "Лекційна кімната",
  corridor_objects =  "Облаштування коридору",
  operating_theatre = "Операційна",
  dna_fixer =         "Виправлення ДНК",
  ward =              "Палата",
  psychiatric =       "Психіатрія",
  hair_restoration =  "Відновлення волосся",
  inflation =         "Кабінет надування",
  tongue_clinic =     "Лікування язика",
  toilets =           "Туалет",
  electrolysis =      "Електроліз",
  x_ray =             "Рентген",
  blood_machine =     "Лабораторія крові",
}
rooms_long = {
  ultrascan = "Кабінет комп'ютерної томографії",
  research_room = "Дослідницький відділ",
  general = "Загальні",
  gps_office = "Кабінет терапевта",
  inflation = "Кабінет надування",
  staffroom = "Кімната відпочинку",
  jelly_vat = "Кабінет лікування ожелеювання",
  scanner = "Кабінет магнітно-резонансної томографії",
  emergency = "Реанімація",
  decontamination = "Кабінет знезаражування",
  corridors = "Коридори",
  cardiogram = "Кабінет кардіографії",
  ward = "Палата",
  training_room = "Лекційна кімната",
  psychiatric = "Кабінет психіатра",
  operating_theatre = "Операційна",
  dna_fixer = "Кабінет виправлення ДНК",
  tongue_clinic = "Кабінет обрізання довгого язика",
  hair_restoration = "Кабінет відновлення волосся",
  general_diag = "Кабінет загального обстеження",
  pharmacy = "Фармакологічний кабінет",
  fracture_clinic = "Кабінет лікування переломів",
  toilets = "Туалет",
  electrolysis = "Кабінет електролізу",
  x_ray = "Рентген-кабінет",
  blood_machine = "Лабораторія крові",
}
buy_objects_window = {
  price = "Вартість: ",
  choose_items = "Виберіть предмети",
  total = "Загалом: ",
}
object = {
  chair = "Стілець",
  litter = "Сміття",
  sofa = "Диван",
  operating_table = "Операційний стіл",
  bench = "Лавка",
  scanner = "Апарат МРТ",
  couch = "Кушетка",
  blood_machine = "Аналізатор крові",
  video_game = "Відеогра",
  op_sink2 = "Раковина",
  door = "Двері",
  auto_autopsy = "Авторозтинач",
  reception_desk = "Рецепція",
  hair_restorer = "Волосовідновлювач",
  projector = "Проектор",
  crash_trolley = "Аварійний візок",
  tv = "Телевізор",
  ultrascanner = "Апарат КТ",
  surgeon_screen = "Хірургічна ширма",
  litter_bomb = "Сміттєва бомба",
  inflator = "Надувач",
  desk = "Письмовий стіл",
  pool_table = "Більярд",
  x_ray_viewer = "Негатоскоп",
  radiation_shield = "Протирадіаційний щит",
  bed = "Ліжко",
  swing_door2 = "Розпашні двері",
  console = "Консоль",
  op_sink1 = "Раковина",
  bookcase = "Книжкова шафа",
  drinks_machine = "Автомат з напоями",
  comfortable_chair = "Комфортне крісло",
  skeleton = "Скелет",
  computer = "Комп'ютер",
  bin = "Відро для сміття",
  pharmacy_cabinet = "Фармацептична шафа",
  radiator = "Батарея",
  cast_remover = "Гіпсовидалятор",
  atom_analyser = "Атомний аналізатор",
  plant = "Рослина",
  jelly_moulder = "Формувач желе",
  cardio = "Кардіо доріжка",
  toilet = "Туалет",
  electrolyser = "Электролізер",
  fire_extinguisher = "Вогнегасник",
  swing_door1 = "Розпашні двері",
  lecture_chair = "Лекційний стілець",
  screen = "Ширма",
  toilet_sink = "Раковина",
  shower = "Душ",
  gates_of_hell = "Ворота до пекла",
  slicer = "Різак",
  dna_fixer = "Чистоген 2000",
  x_ray = "Рентген",
  cabinet = "Картотека",
  lamp = "Лампа",
  entrance_left = "Ліві вхідні двері",
  table2 = "Стіл",
  bed2 = "Ліжко",
  bed3 = "Ліжко",
  entrance_right = "Праві вхідні двері",
  table1 = "Стіл",
  rathole = "Пацюча нірка",
}
room_descriptions = {
  gp = {
    [1] = "Кабінет терапевта//",
    [2] = "Це найважливіший кабінет Вашої лікарні. Всі відвідувачі першочергово приходять сюди, щоб дізнатись, що з ними. Звідси їх направляють на подальше обстеження або одразу на лікування. Якщо пацієнтів буде забагато, можливо Вам знадобляться декілька таких кабінетів. Повністю обставлений і просторний кабінет відображає престиж лікаря, що у ньому працює. Також це стосується і інших кімнат.//",
    [3] = "У кабінеті терапевта може працювати будь-який лікар.",
  },
  general_diag = {
    [1] = "Загальне обстеження//",
    [2] = "Сюди приходять пацієнти, котрі потребують додаткового обстеження. В цьому кабінеті лікар має ширші можливості для обстеження пацієнта, ніж у кабінеті терапевта. Пацієнт повернеться до терапевта з результатами обстеження для визначення діагнозу.//",
    [3] = "У кабінеті загального обстеження може працювати будь-який лікар.",
  },
  ultrascan = {
    [1] = "Кабінет КТ//",
    [2] = "Комп'ютерна томографія - один з кращих інстурментів для обстеження. Якщо Ви хочете забезпечити пацієнтам найкращі умови обстеження, купуйте його. Він вартий кожної копійки!//",
    [3] = "Із КТ може працювати будь-який лікар. А також він потребує обслуговування.",
  },
  fracture_clinic = {
    [1] = "Лікування переломів//",
    [2] = "Гіпсовидалятор використовує потужний промисловий лазер, щоб прорізати затверділий гіпс, а пацієнт тим часом відчуває незначний біль.//",
    [3] = "Для роботи цього кабінету необхідна медсестра. Апарат також вимагає частого обслуговування.",
  },
  inflation = {
    [1] = "Кабінет надування//",
    [2] = "Пацієнти з хворобливою, але веселою Надутою головою отримують направлення у кабінет надування, де надута голова проколюється, з характерним звуком луснутої кульки, а потім надувається до звичайного розміру.//",
    [3] = "Для експлуатації апарату потрібен лікар. Вона також повинна перебувати під постійним наглядом Різноробочого.",
  },
  jelly_vat = {
    [1] = "Лікування ожелеювання//",
    [2] = "Пацієнти, які страждають на кумедну хворобу Ожелеювання, повинні дотрястися до цього кабінету, де їх поміщають у Формувач желе. Такими не зовсім зрозумілими для медицини процесами вони виліковуються.//",
    [3] = "Цьому апарату потрібен лікар, а також Різноробочий, для його обслуговування",
  },
  scanner = {
    [1] = "Кабінет МРТ//",
    [2] = "Пацієнтів діагностують за допомогою цього модного сканера, а потім відправляють до кабінету терапевта для подальшого лікування.//",
    [3] = "З МРТ може працювати будь-який лікар. Апарат потребує регулярного обслуговування.",
  },
  blood_machine = {
    [1] = "Лабораторія крові//",
    [2] = "Ця апаратура є частиною діагностичного обладнання, яка перевіряє колір клітин крові пацієнта та визначає їх стан.//",
    [3] = "З Лабораторією крові може впоратись будь-який лікар. Вона потребує регулярного обслуговування.",
  },
  pharmacy = {
    [1] = "Фармакологія//",
    [2] = "Пацієнти, яким встановлено діагноз, котрий можна вилікувати за допомогою ліків, повинні звернутись у Фармакологічний кабінет. Оскільки будуть винайдені нові ліки, кількість відвідувачів кратно зросте і стане дуже тісно, тож можливо знадобиться ще одна Фармакологія.//",
    [3] = "На роботу в аптеку потрібна медсестра.",
  },
  cardiogram = {
    [1] = "Кардіографія//",
    [2] = "Тут пацієнти, що ніколи не займаються спортом, піддаються ненависному бігу, який люто підвищує артеріальний тиск. Ці показники допомагають лікарю поставити діагноз.//",
    [3] = "У Кардіографії може працювати будь який лікар. Біговій доріжці потрібне обслуговування.",
  },
  ward = {
    [1] = "Палата//",
    [2] = "Під час обстеження, паієнти лежать тут під наглядом медсестри. Також вони приходять сюди, щоб підготуватися до операції. Для деяких лікування - це полежати із чаєм з лимоном.//",
    [3] = "В палаті наглядає медсестра.",
  },
  psych = {
    [1] = "Психіатрія//",
    [2] = "Пацієнти з психічним захворюванням повинні відвідувати кабінет психіатра, де їх чекає лікар у зручному кріслі. Потім вони лягають на диван, їм ставлять належний діагноз і, зрештою, лікують за допомогою магії та хабарів.//",
    [3] = "Для цього кабінету потрібен лікар, який має навички Психіатра.",
  },
  staff_room = {
    [1] = "Кімната відпочинку//",
    [2] = "Ваші працівники втомлюються, виконуючи свою роботу. Їм ця кімната потрібна для відпочинку та відновлення своїх сил. Втомлені працівники повільні, починають вимагати більше грошей і врешті-решт можуть звільнитись. Вони також роблять більше помилок. Облаштування кімнати для теревень, перегляду ТБ і можливість захоплення відеоіграми позбавить їх втоми. Переконайтеся, що є місце для кількох працівників одночасно.",
  },
  operating_theatre = {
    [1] = "Операційна//",
    [2] = "Це важливе приміщення, де лікують різні хвороби, що потребують втручання скальпеля, а деколи й бензопили. Приміщення повинно мати велику площу і в ньому повинно бути відповідне обладнання.//",
    [3] = "В операційну потрібні два лікарі з навичками Хірурга. Операційний стіл потрібно рівняти час від часу після вибриків пацієнтів",
  },
  training = {
    [1] = "Лекційна кімната//",
    [2] = "Ваші Інтерни та Лікарі можуть отримати цінні додаткові навички, навчаючись у цій кімнаті. Спеціаліст з навичками хірурга, дослідника або психіатра передасть їх будь-якому лікарю, який навчається тут. Лікарі, які вже мають ці навички, раптом виявлять, що можуть використовувати їх більш ефективно.//",
    [3] = "Проводити навчання може тільки Спеціаліст.",
  },
  dna_fixer = {
    [1] = "Виправлення ДНК//",
    [2] = "Пацієнтам, чия ДНК містить, серед іншого, гени інопланетян, необхідно виділити ДНК з тіла, ретельно очистити та повернути в усі клітини назад у пацієнта. Чистоген 2000 є дуже складним обладнанням, тому про всяк випадок слід мати поряд вогнегасник.//",
    [3] = "Чистоген 2000 потребує регулярного технічного обслуговування Різноробочим. Крім того, для роботи з ним потрібен лікар з навичкою Дослідника.",
  },
  research = {
    [1] = "Кабінет дослідництва//",
    [2] = "Найрозумніші лікарі цього кабінету винаходять і вдосконалюють ліки та обладнання. Це важлива частина Вашої лікарні, яка робить неймовірне для того, щоб Ваш відсоток вилікуваних тільки зростав!.//",
    [3] = "У кабінеті дослідництва можуть працювати тільки лікарі з навичкою Дослідника.",
  },
  hair_restoration = {
    [1] = "Відновлення волосся//",
    [2] = "Пацієнти, які страждають на Екстремальне облисіння, направляються в цей кабінет для трансплантації волосся. Лікар керує апаратом, який швидко висаджує нові волосяні цибулини на лисину пацієнта.//",
    [3] = "З Волосовідновлювачем може працювати будь-який лікар. Інколи потребує обслуговування.",
  },
  electrolysis = {
    [1] = "Кабінет електролізу//",
    [2] = "Пацієнтів із Заволошенням відправляють у цю кімнату, де спеціальна машина під назвою Електролізер електрично висмикує волосся та закриває пори за допомогою суміші, схожої на в'язкий розчин.//",
    [3] = "Електролізеру потрібен будь-який лікар. Він також потребує обслуговування з боку Різноробочого.",
  },
  slack_tongue = {
    [1] = "Лікування язика//",
    [2] = "У цю клініку направляють на лікування пацієнтів з діагнозом «Заплетений язик». Лікар за допомогою дуже сучасного та точного апарату розтягуватиме та зрізатиме язик, повертаючи йому належну форму.//",
    [3] = "Тут може працювати будь-який лікар. Апарат також вимагає частого обслуговування.",
  },
  toilets = {
    [1] = "Туалет//",
    [2] = "Пацієнти, які відчувають поклик природи, повинні закривати свої потреби в зручному туалеті. Ви можете побудувати додаткові кабінки та раковини, якщо очікуєте багато відвідувачів. Можливо Вам слід розглянути ідею будівництва додаткових туалетів в інших частинах лікарні.",
  },
  no_room = {
    [1] = "",
  },
  x_ray = {
    [1] = "Рентген//",
    [2] = "Рентген робить знімки внутрішнього світу пацієнтів за допомогою рентгенівських променів, даючи персоналу гарне уявлення про те, що там в них відбувається.//",
    [3] = "Із Рентгеном може працювати будь-який лікар. А також він потребує обслуговування.",
  },
  decontamination = {
    [1] = "Знезаражування//",
    [2] = "Пацієнтів, які зазнали Надмірної радіоактивності, негайно направляють до кабінету знезаражування. У цій кімнаті є душ, який очищає їх від жахливої ​​радіації та бруду, після якого пацієнта ще й причешуть.//",
    [3] = "Знезаражуючий душ вимагає участі будь-якого лікаря. Також він потребує перевірок технічного обслуговування Різноробочим.",
  },
  tv_room = {
    [1] = "Телевізійна кімната невикористовувалась",
  },
}
place_objects_window = {
  place_objects_in_corridor = "Розставте ці предмети у коридорах.",
  place_windows = "Додайте вікон, якщо хочете і натисніть «Підтвердити».",
  confirm_or_buy_objects = "Ви можете додати, прибрати або пересунути предмети.",
  drag_blueprint = "Розтягуєте кімнату до бажаного розміру.",
  place_door = "Поставте двері.",
  place_objects = "Виберіть об'єкт та поставте його у потрібне місце, потім підтвердіть.",
  pick_up_object = "Натисніть на об'єкт щоб підняти його або виберіть іншу опцію.",
}
staff_class = {
  doctor = "Лікар",
  handyman = "Різноробочий",
  receptionist = "Рецепціоністка",
  nurse = "Медсестра",
  surgeon = "Хірург",
}
staff_descriptions = {
  good = {
    [1] = "Дуже швидкий та старанний працівник. ",
    [2] = "Сумлінно працює. Уважний до деталей. ",
    [3] = "Може буквально все. ",
    [4] = "Неймовірно доброзичливий і любить посміятися. ",
    [5] = "Дивовижна витривалість. Працює без упину. ",
    [6] = "Надзвичайно ввічливий і завжди привітний. ",
    [7] = "Неймовірно талановитий і здібний. ",
    [8] = "Дуже відповідальний відносно своєї роботи. ",
    [9] = "Ніколи не здається і прагне досконалості. ",
    [10] = "Допомагає людям з посмішкою. ",
    [11] = "Чарівний, ввічливий і завжди допоможе. ",
    [12] = "Загалом добре мотивований і відданий справі. ",
    [13] = "Добрий і дуже працьовитий. ",
    [14] = "Відданий і дружній. ",
    [15] = "Обережний та надійний в надзвичайних ситуаціях. ",
  },
  misc = {
    [1] = "Збирає фігурки слонів. ",
    [2] = "Любить дайвінг. ",
    [3] = "Робить скульптури з льоду. ",
    [4] = "З'явився в одному епізоді «Не вагайся, обертайся!» ",
    [5] = "Власник суперкарів. ",
    [6] = "Любить банджі-джампінг. ",
    [7] = "Збирає підставки під бокали пива. ",
    [8] = "Він любить стрибати зі сцени. ",
    [9] = "Він любить серфінг із пукальним прискоренням. ",
    [10] = "Розширює русла річок. ",
    [11] = "Переганяє віскі. ",
    [12] = "Досвідчений майстер. ",
    [13] = "Любить фільми французьких режисерів. ",
    [14] = "Часто грає у Theme Park. ",
    [15] = "Має посвідчення водія вантажівки. ",
    [16] = "Бере участь у перегонах на мотоциклах. ",
    [17] = "Грає на скрипці та віолончелі. ",
    [18] = "Завзятий диверсант залізничних колій. ",
    [19] = "Обожнює собак. ",
    [20] = "Співає у душі. ",
    [21] = "Він часто купається у фонтанах. ",
    [22] = "Інструктор з плетіння кошиків. ",
    [23] = "Перетворює свіжі овочі на мильниці. ",
    [24] = "Комісар поліції за сумісництвом. ",
    [25] = "Колишній ведучий вікторини. ",
    [26] = "Збирає уламки снарядіа Другої світової війни. ",
    [27] = "Любить переміщувати меблі. ",
    [28] = "Слухає рейв і тріп-хоп. ",
    [29] = "Він дратує комах спреєм-дезодорантом. ",
    [30] = "Перекрикує коміків на їх виступах. ",
    [31] = "Нишпорить по кабінетах. ",
    [32] = "Він садівник, але скриває це. ",
    [33] = "Торгує контрабандою підроблених годинників. ",
    [34] = "Співає в рок-н-рол гурті. ",
    [35] = "Обожнює денне телебачення. ",
    [36] = "Лоскоче форель. ",
    [37] = "Заманює туристів у музеї. ",
  },
  bad = {
    [1] = "Повільний і дріб'язковий. ",
    [2] = "Лінивий і немотивований. ",
    [3] = "Погано навчений і некомпетентний. ",
    [4] = "Нахабний і грубий. Діє людям на нерви. ",
    [5] = "Жахлива витривалість та безвідповідальність. ",
    [6] = "Глухий, як колода. Тхне капустою. ",
    [7] = "Безкорисний тягар на роботі. ",
    [8] = "Імпульсивний і легко відволікається. ",
    [9] = "Дуже хвилюється тому схильний до помилок. ",
    [10] = "Збочений і злий - палає ненавистю до люду. ",
    [11] = "Необережний, підвищує ризик нещасних випадків. ",
    [12] = "Він не зацікавлений у роботі. Вкрай ледачий. ",
    [13] = "Безглуздо ризикує і йому все одно. ",
    [14] = "Хитрий, підступний, диверсант. ",
    [15] = "Зарозумілий і самовпевнений. ",
  },
}
tooltip = {
  build_room_window = {
    cost = "Ціна обраного кабінета",
    room_classes = {
      treatment = "Відобразити терапевтичні кабінети",
      diagnosis = "Відобразити кабінети обстеження",
      facilities = "Відобразити службові приміщення",
      clinic = "Відобразити кабінети лікування",
    },
    close = "Повернутись до гри",
  },
  hire_staff_window = {
    prev_person = "Попередній кандидат",
    cancel = "Відмінити",
    psychiatrist = "Психіатр",
    surgeon = "Хірург",
    researcher = "Дослідник",
    salary = "Зарплатня",
    next_person = "Наступний кандидат",
    nurses = "Переглянути медсестер",
    handymen = "Переглянути різноробочих",
    doctors = "Переглянути лікарів",
    receptionists = "Переглянути рецепціоністок",
    doctor_seniority = "Ступінь (Інтерн, Лікар, Спеціаліст)",
    hire = "Найняти",
    qualifications = "Додаткові навички лікаря",
    staff_ability = "Здібності",
  },
  place_objects_window = {
    confirm = "Підтвердити",
    cancel = "Відмінити",
    pick_up = "Підняти об'єкт",
    buy_sell = "Купити/Продати",
  },
  rooms = {
    ultrascan = "Лікар оперує Комп'ютерною томографією для обстеження пацієнтів",
    research_room = "Лікарі з навичкою Дослідника винаходять нові ліки та апарати у Кабінеті дослідництва",
    fracture_clinic = "Медсестра використовує кабінет Лікування переломів, щоб повторно зібрати Зламані кістки",
    gps_office = "Пацієнти отримують первинну консультацію та результати обстеження у Кабінеті терапевта",
    inflation = "Лікар, за допомогою Надувача, лікує пацієнтів з хворобою Надута голова",
    staffroom = "Лікарі та медсестри відпочивають і відновлюють сили в Кімнаті відпочинку",
    jelly_vat = "За допомогою спеціального апарату лікар виліковує Ожелеювання",
    scanner = "Лікар використовує МРТ для діагностики пацієнтів",
    decontamination = "Лікар використовує Знезаражуючий душ, щоб вилікувати Надмірну радіоактивність",
    pharmacy = "В аптеці медсестра роздає ліки своїм пацієнтам",
    cardiogram = "Лікар використовує Кабінет кардіографії для обстеження пацієнтів",
    ward = "Палата корисна як для обстеження, так і для лікування. Хворих направляють сюди для спостереження за ними, а також для відновлення сил перед операцією",
    training_room = "У лекційній Спеціаліст може навчати інших лікарів",
    operating_theatre = "В операційну потрібні два лікаря з навичками Хірурга, щоб розважатись з нутрощами пацієнта",
    psychiatry = "Психіатрія лікує психічно хворих пацієнтів і допомагає обстежити інших пацієнтів, але вимагає лікаря з навичками Психіатра",
    hair_restoration = "За допомогою Волосовідновлювача лікар виліковує Екстремальне облисіння",
    tongue_clinic = "Лікар, оперуючи Різаком підрізатиме язик, повертаючи йому належну форму",
    dna_fixer = "Тут лікуються пацієнти з Інопланетною ДНК",
    general_diag = "Для загального обстеження пацієнтів лікар використовує цей кабінет. Дешево і часто дуже ефективно",
    toilets = "Будуйте туалети, щоб пацієнти не перетворили на них Вашу лікарню!",
    electrolysis = "Лікар використовує Електролізер для лікування Заволошення",
    x_ray = "Лікар використовує Рентген для обстеження пацієнтів",
    blood_machine = "Лікар використовує Лабораторію крові для обстеження пацієнтів",
  },
  objects = {
    litter = "Сміття: якийсь пацієнт залишив його на підлозі, тому що не зміг знайти відро для сміття, щоб його викинути",
    sofa = "Диван: працівники, які відпочивають у Кімнаті відпочинку, тихо сидітимуть на дивані, якщо немає кращого способу розвіятись",
    bench = "Лавка: забезпечує сидяче місце для одного пацієнта, що робить очікування болісних процедур більш комфортним",
    video_game = "Відеогра: дозвольте своїм співробітникам відпочити в Petris",
    auto_autopsy = "Авторозтинач: дуже корисний у дослідженні нового",
    reception_desk = "Рецепція: тут весь час стоїть Рецепціоністка, яка направляє пацієнтів до свого першого лікаря",
    tv = "Телевізор: подбайте про те, щоб співробітники не пропускали свої улюблені мильні опери",
    inflator = "Надувач: надуває людей з Надутою головою",
    desk = "Стіл: важливо, щоб лікар поставив на нього свій ПК",
    pool_table = "Більярдний стіл: співробітники можуть вдавати, що вміють грати в більярд",
    bed = "Ліжко: на них лежать вже занадто хворі люди",
    bookcase = "Книжкова шафа: зібрання нерозкритих книг, завдяки яким лікарі виглядають розумнішими",
    drinks_machine = "Автомат з напоями: знижує середню спрагу пацієнтів і забезпечує невеликий дохід лікарні",
    skeleton = "Скелет: використовується як посібник з анатомії і на Хелловін",
    computer = "Комп’ютер: невід'ємна частина процесу обстеження",
    bin = "Відро для сміття: пацієнти викидають сміття сюди",
    pharmacy_cabinet = "Фармацептична шафа: місце зберігання всіх ліків",
    radiator = "Батарея: захищає лікарню від утворення ожеледі",
    atom_analyser = "Атомний аналізатор: цей апарат, розташований у Кабінеті дослідника, прискорює всі процеси дослідження",
    plant = "Рослина: робить пацієнтів щасливими та очищає повітря",
    toilet = "Туалет: пацієнти, е-ем, тогой, користуються ним",
    fire_extinguisher = "Вогнегасник: зменшує небезпеку від несправних апаратів",
    lecture_chair = "Лекційний стілець: ваші лікарі-інтерни сидять тут, роблять нотатки, нудьгують і просто малюють. Чим більше ви розставите стільців, тим більшим лікарів зможе навчатись",
    toilet_sink = "Раковина: Ваші пацієнти, які все ж дотримуються гігієни, можуть мити в ній свої брудні руки. Якщо раковин недостатньо, пацієнти будуть незадоволені",
    cabinet = "Картотека: містить картки пацієнтів, нотатки та результати обстежень",
  },
}

queue_window = {
  num_in_queue = "Довжина черги",
  num_entered = "Усього відвідувань",
  max_queue_size = "Макс. довжина",
  num_expected = "Очікується",
}
tooltip = {
  handyman_window = {
    prio_machines = "Збільшити пріоритет Ремонту",
    prio_litter = "Збільшити пріоритет Прибирання",
    prio_plants = "Збільшити пріоритет Поливу",
  },
  machine_window = {
    repair = "Викликати Різноробочого для ремонту",
    name = "Назва",
    close = "Закрити",
    times_used = "Кількість використань",
    status = "Стан",
    replace = "Замінити апарат",
  },
  patient_window = {
    graph = "Натисніть, щоб переключитися між графіком самопочуття пацієнта та історією його обстежень",
    casebook = "Переглянути деталі хвороби пацієнта",
    close = "Закрити",
    queue = "Показати чергу кабінета, де чекає пацієнт",
    happiness = "Задовільність пацієнта",
    warmth = "Відчуття тепла пацієнта",
    center_view = "Зконцентруватись на пацієнті",
    thirst = "Рівень спраги пацієнта",
    send_home = "Відправити пацієнта додому",
    abort_diagnosis = "Направте пацієнта на лікування прямо зараз і не чекайте завершення обстеження",
  },
  staff_window = {
    doctor_seniority = "Ступінь (Інтерн, Лікар, Спеціаліст)",
    psychiatrist = "Психіатр",
    close = "Закрити вікно",
    ability = "Здібності",
    pick_up = "Підняти",
    sack = "Звільнити",
    surgeon = "Хірург",
    happiness = "Задовільність",
    salary = "Щомісячна зарплатня",
    name = "Ім'я",
    tiredness = "Втома",
    center_view = "Ліва клавіша - центрувати екран, права - вибрати наступного працівника",
    skills = "Додаткові навички",
    researcher = "Дослідник",
    face = "Фото працівника - натисніть, щоб перейти до екрану керування працівниками",
  },
}

confirmation = {
  abort_edit_room = "Ви зараз будуєте або редагуєте кімнату. Якщо всі необхідні об'єкти розміщені, вона буде завершена, інакше вона буде видалена. Продовжити?",
  return_to_blueprint = "Ви впевнені, що хочете повернутися до режиму креслення?",
  delete_room = "Ви впевнені, що хочете видалити цю кімнату?",
  quit = "Ви вирішили вийти з гри. Ви в цьому впевнені?",
  needs_restart = "Зміна цього параметра вимагає перезапуску CorsixTH. Будь-який незбережений прогрес буде втрачено. Ви впевнені, що хочете це зробити?",
  overwrite_save = "Гра вже була збережена з цим ім'ям. Ви впевнені, що хочете її перезаписати?",
  sack_staff = "Ви впевнені, що хочете звільнити цього працівника?",
  replace_machine = "Ви впевнені, що бажаєте замінити %s за %d$?",
  restart_level = "Ви впевнені, що хочете перезапустити рівень?",
  maximum_screen_size = "Роздільна здатність екрана, яку ви ввели, перевищує 3000 x 2000. Цю роздільну здатність можна змінити за умови, що у вас є апаратне забезпечення, здатне опрацьовувати гру з плавною частотою кадрів. Ви впевнені, що бажаєте продовжити?",
  remove_destroyed_room = "Ви впевнені, що хочете зруйнувати кімнату? Це буде коштувати %d$.?",
  replace_machine_extra_info = "Новий апарат буде мати стан %d (зараз %d).",
  quit_mapeditor = "Ви впевнені, що хочете вийти з редактора мап?",
  restart_mapeditor = "Ви впевнені, що хочете перезапустити редактор мап?",
}
pay_rise = {
  definite_quit = "Ви не переконаєте мене залишитись, що б не робили. Нудить вже від цього місця!",
  regular = {
    [1] = "Я повністю виснажений. Мені потрібно багато часу на відпочинок, до того ж я хочу підвищення. %d - і не менше, якщо Ви звісно не хочете, щоб я залишив цю дурну роботу.",
    [2] = "Я дуже втомився. Мені потрібно дати відпочинок і підвищення зарплатні на %d, що загалом становитиме %d. Зроби це зараз, деспоте!",
    [3] = "Значить так. Я тут працюю, як віл. Дай мені %d бонусу, і нехай, я залишусь у твоїй лікарні.",
    [4] = "Я дуже незадоволений. Я прошу %d підвищення, це зробить мою зарплату %d, інакше я піду від Вас.",
    [5] = "Мої батьки сказали мені, що медична професія добре оплачується. Тож підвищте мою зарплату на %d, або я піду працювати розробником комп’ютерних ігор.",
    [6] = "Досить вже з мене. Ви повинні платити мені пристойну зарплату! Я думаю, %d підвищення має бути достатньо.",
  },
  poached = "%s запропонував мені %d. Якщо ви не заплатите мені стільки ж, я піду до нього.",
}

diseases = {
  general_practice = {
    name = "Обстеження: терапевт",
  },
  diag_ward = {
    name = "Обстеження: палата",
  },
  diag_ultrascan = {
    name = "Обстеження: КТ",
  },
  diag_blood_machine = {
    name = "Обстеження: лабораторія крові",
  },
  diag_x_ray = {
    name = "Обстеження: рентген",
  },
  diag_psych = {
    name = "Обстеження: психіатр",
  },
  diag_general_diag = {
    name = "Обстеження: загальгне обстеження",
  },
  diag_cardiogram = {
    name = "Обстеження: кардіограма",
  },
  diag_scanner = {
    name = "Обстеження: МРТ",
  },
  autopsy = {
    name = "Розтин",
  },
  third_degree_sideburns = {
    cause = "Причина - журба за 70-ми.",
    cure = "Лікування - за допомогою новітніх методів психіатр повинен переконати пацієнта, що блиск і туфлі на платформі не такі вже й зручні.",
    name = "Бакенбарди третього ступеня",
    symptoms = "Симптоми - довге волосся, штани кльош, взуття на платформі та сяючий макіяж.",
  },
  discrete_itching = {
    cause = "Причина - маленька комаха з гострими зубками.",
    cure = "Лікування - пацієнт п'є аптечний липкий сироп, що виділяється з потом. Це не дає комасі насолодитись кусями і вона йде.",
    name = "Надзвичайний свербіж",
    symptoms = "Симптоми - пацієнт завжди роздряпаний.",
  },
  the_squits = {
    cause = "Причина - пацієнт з'їв піцу, знайдену за плитою.",
    cure = "Лікування - липка суміш в'язких фармакологічних хімікатів заспокоїть неспокійний травний тракт.",
    name = "Діарея",
    symptoms = "Симптоми - Гм... Ви, мабуть і самі знаєте.",
  },
  spare_ribs = {
    cause = "Причина - ковтання таблеток, не запиваючи їх.",
    cure = "Лікування - ребра повинні бути видалені двома хірургами та віддані пацієнту в поліетиленовому пакеті з логотипом лікарні.",
    name = "Зайві ребра",
    symptoms = "Симптоми - неприємні відчуття в області грудної клітини.",
  },
  king_complex = {
    cause = "Причина - дух короля проникає в підсвідомість пацієнта, повністю захоплюючи його розум.",
    cure = "Лікування - психіатр розповідає пацієнту, наскільки сміховинно він виглядає.",
    name = "Синдром Короля",
    symptoms = "Симптоми - носіння різнокольорових замшевих туфель і вживання черезмірної кількості чізбургерів.",
  },
  fake_blood = {
    cause = "Причина - пацієнт часто стає жертвою всіляких розіграшів",
    cure = "Лікування - посиденьки у психіатра в заспокійливому середовищі є єдиним способом боротьби з цим розладом.",
    name = "Фальшива кров",
    symptoms = "Симптоми - такого неприємного крикуна неможливо прогледіти в натовпі.",
  },
  invisibility = {
    cause = "Причина - укус радіоактивного (і звісно ж невидимого) мурахи.",
    cure = "Лікування - кольорова рідина, випита в аптеці, незабаром поверне пацієнту повну палітру кольорів його зовнішнього вигляду.",
    name = "Невидимість",
    symptoms = "Симптоми - Пацієнти жодним чином не страждають. Навпаки, деякі зловживають цією хворобою, щоб влаштовувати розіграші над друзями.",
  },
  golf_stones = {
    cause = "Причина - вплив на пацієнта отруйного газу, що міститься у м'ячиках для гольфу.",
    cure = "Лікування - камінчики видаляються за допомогою операції, яка вимагає двох хірургів.",
    name = "Гольфові камінчики",
    symptoms = "Симптоми - стан сплутаності свідомості і підвищене відчуття сорому.",
  },
  infectious_laughter = {
    cause = "Причина - частий перегляд класичних комедій.",
    cure = "Лікування - кваліфікований психіатр повинен нагадати пацієнту про тяжкість його хвороби і самого життя.",
    name = "Заразливий сміх",
    symptoms = "Симптоми - безнадійні спроби стримування сміху та повторення одних і тих же жартів.",
  },
  baldness = {
    cause = "Причина - брехня та вигадування історій для підвищення популярності.",
    cure = "Лікування - штучне волосся з непридатних для продажу перук повертається на голову пацієнта.",
    name = "Екстремальне облисіння",
    symptoms = "Симптоми - сяйво поверхні голови, що засліплює всіх навколо.",
  },
  heaped_piles = {
    cause = "Причина - сидіння на холодних кам'яних сходах.",
    cure = "Лікування - смачний, хоча і сильнокислий напій розчиняє геморой зсередини.",
    name = "Затягнутий геморой",
    symptoms = "Симптоми - пацієнт відчуває себе так ніби сидить на мішку з кульками для настільного тенісу.",
  },
  unexpected_swelling = {
    cause = "Причина - щось несподіване.",
    cure = "Лікування - набряк можна зменшити за допомогою набору акупунктурних голок під час операції, що потребує двох хірургів.",
    name = "Неочікуваний набряк",
    symptoms = "Симптом - набряк.",
  },
  jellyitis = {
    cause = "Причина - дієта, багата на желатин, і надмірні фізичні вправи.",
    cure = "Лікування - пацієнта тимчасово кладуть у Формувач желе в спеціальній кімнаті.",
    name = "Ожелеювання",
    symptoms = "Симптоми - надмірне тремтіння, часті падіння та дивна консистенція.",
  },
  hairyitis = {
    cause = "Причина - тривале перебування під повним місяцем.",
    cure = "Лікування - електроліз видаляє волосся та закриває пори.",
    name = "Заволошення",
    symptoms = "Симптоми - у пацієнта значно розвинений нюх.",
  },
  alien_dna = {
    cause = "Причина - стрибаючі в обличчя мікроорганізми з кров'ю інопланетян.",
    cure = "Лікування - за допомогою спеціального апарату необхідно виділити ДНК з тіла, ретельно очистити та повернути в усі клітини назад у пацієнта",
    name = "Інопланетна ДНК",
    symptoms = "Симптоми - поступове перетворення на інопланетян і бажання знищити земні поселення.",
  },
  bloaty_head = {
    cause = "Причина - нюхання сиру та вживання неочищеної дощової води.",
    cure = "Лікування - надута голова дуже обережно здувається, а потім обережно й дуже точно надувається до потрібного тиску за допомогою розумного апарату.",
    name = "Надута голова",
    symptoms = "Симптоми - пацієнт відчуває себе дуже некомфортно.",
  },
  gastric_ejections = {
    cause = "Причина - гостра мексиканська або індійська їжа.",
    cure = "Лікування - вживання спеціального клею запобігає виходу будь-чого зсередини пацієнта.",
    name = "Кишечні виверження",
    symptoms = "Симптоми - напівперетравлена ​​їжа виходить з пацієнта в невеликих кількостях і в непередбачений час.",
  },
  uncommon_cold = {
    cause = "Причина - кашель з соплями, які розносить сусід.",
    cure = "Лікування - великий ковток надзвичайного лікувального зілля зі спеціальних інгредієнтів, виготовлених у Фармакології.",
    name = "Незвичайна застуда",
    symptoms = "Симптоми - сопливий ніс, чхання та зміна кольору легенів.",
  },
  corrugated_ankles = {
    cause = "Причина - роки за кермом без перерви.",
    cure = "Лікування - спазм, викликаний злегка отруйною сумішшю трав, поверне щиколоткам первісну форму.",
    name = "Зкручені щиколотки",
    symptoms = "Симптоми - улюблене взуття пацієнта не підходить.",
  },
  sleeping_illness = {
    cause = "Причина - гіперактивна сонна залоза на піднебінні.",
    cure = "Лікування - медсестра зробить дуже міцної кави у маленькій філіжанці.",
    name = "Сонна хвороба",
    symptoms = "Симптоми - непереборне бажання спати всюди.",
  },
  sweaty_palms = {
    cause = "Причина - страх перед співбесідами.",
    cure = "Лікування - психіатр повинен буквально відговорити пацієнта від цієї хвороби.",
    name = "Пітніючі долоні",
    symptoms = "Симптоми - рукостискання пацієнта все одно, що стискати щойно зібраний гриб.",
  },
  serious_radiation = {
    cause = "Причина - помилкове прийняття ізотопів плутонію за жувальну гумку.",
    cure = "Лікування - пацієнта необхідно помістити в знезаражуючий душ і ретельно вимити.",
    name = "Надмірна радіоактивність",
    symptoms = "Симптоми - пацієнти почуваються дуже, дуже погано.",
  },
  gut_rot = {
    cause = "Причина - сироп від кашлю «Віскі старих добрих часів тітоньки О'Мейлі».",
    cure = "Лікування - медсестра може зробити мікстуру з розчинених хімічних речовин, щоб покрити шлунок.",
    name = "Прогнивщі кишки",
    symptoms = "Симптоми - немає кашлю, але і слизової оболонки шлунка теж нема.",
  },
  iron_lungs = {
    cause = "Причина - міський смог, змішаний з крихтами шашлику.",
    cure = "Лікування - два хірурги виконують операцію з видалення залізних легень і встановлення нових зі складу.",
    name = "Залізні легені",
    symptoms = "Симптоми - здатність дихати вогнем і голосно кричати під водою.",
  },
  broken_wind = {
    cause = "Причина - вправи на біговій доріжці одразу після вживання їжі.",
    cure = "Лікування - пацієнту дають ліки з ароматом фіалки.",
    name = "Отруйні вітри",
    symptoms = "Симптоми - прищіпки на носах людей, що знаходяться позаду пацієнта.",
  },
  kidney_beans = {
    cause = "Причина - вживання кубиків льоду в напоях.",
    cure = "Лікування - два хірурги повинні видалити боби, не торкаючись нирок.",
    name = "Боби в нирках",
    symptoms = "Симптоми - біль і часті походи в туалет.",
  },
  transparency = {
    cause = "Причина - злизування залишків йогурту з кришечки.",
    cure = "Лікування - дорогі ліки, виготовлені з підфарбованої води, вилікують цю хворобу.",
    name = "Прозорість",
    symptoms = "Симптоми - тіло пацієнта виглядає як товсте скло",
  },
  broken_heart = {
    cause = "Причина - хтось багатший, молодший і стрункіший за пацієнта.",
    cure = "Лікування - два хірурги розкривають грудну клітку і, затримуючи дихання, обережно заклеюють серце клейкою стрічкою.",
    name = "Розбите серце",
    symptoms = "Симптоми - безперервний плач і руки, повні фотографій із відпустки з другою половинкою.",
  },
  slack_tongue = {
    cause = "Причина - вічне обговорення серіалів.",
    cure = "Лікування - язик поміщається в різак і швидко, філігранно та безболісно видаляється.",
    name = "Заплетений язик",
    symptoms = "Симптоми - п'ятикратно збільшений, звисаючий язик.",
  },
  tv_personalities = {
    cause = "Причина - перегляд телевізора щодня.",
    cure = "Лікування - кваліфікований психіатр повинен переконати пацієнта продати свій телевізор і купити радіо.",
    name = "Медійна особистість",
    symptoms = "Симптоми - ілюзія того, що ви можете вести телепрограму Шеф-кухар.",
  },
  ruptured_nodules = {
    cause = "Причина - банджі-джампінг у холодну погоду.",
    cure = "Лікування - два кваліфіковані хірурги повинні видалити грижі, використовуючи свої міцні руки.",
    name = "Грижі",
    symptoms = "Симптоми - неможливість зручно сидіти.",
  },
  fractured_bones = {
    cause = "Причина - падіння з висоти его до рівня IQ пацієнта",
    cure = "Лікування - пацієнта муміфікують у гіпсі. Потім надлишки гіпсу потрібно зрізати.",
    name = "Зламані кістки",
    symptoms = "Симптоми - гучний хрускіт і неможливість використовувати уражені кінцівки.",
  },
  chronic_nosehair = {
    cause = "Причина - піднесення себе над іншими.",
    cure = "Лікування - пацієнт отримує ліки такої ж якості, як і всі інші в аптеці.",
    name = "Хронічне носоволоссіння",
    symptoms = "Симптоми - вуса з волосся в носі, в яких навіть борсук міг би зробити собі барліг.",
  },
  pregnancy = {
    cure = "Лікування - дитину дістають в операційній, миють і знайомлять з пацієнтом.",
    cause = "Причина - відключення електроенергії в містах.",
    name = "Вагітність",
    symptoms = "Симптоми - безперервна тяга до їжі та відчуття похмілля.",
  },
}

fax = {
  epidemic = {
    cover_up_explanation_1 = "З іншого боку, якщо Ви спробуєте це приховати, у Вас буде обмежений час, щоб вилікувати всіх інфікованих пацієнтів до того, як про це дізнаються у міністерстві охорони здоров'я.",
    cover_up_explanation_2 = "Якщо сан. інспектор відвідає лікарню та виявить, що епідемію все ще приховують, він може вжити рішучих заходів проти Вас.",
    choices = {
      cover_up = "Спробуйте вилікувати всіх інфікованих пацієнтів за встановлений час і до того, як хтось з них покине лікарню.",
      declare = "Оголосити епідемію. Сплатити штраф підмочивши репутацію лікарні.",
    },
    disease_name = "Ваші лікарі виявили заразний штам %s.",
    declare_explanation_fine = "Якщо ви оголосите про епідемію, Ви сплатите %d штрафу, отримаєте удар по репутації, а всі Ваші пацієнти будуть автоматично вакциновані.",
  },
  epidemic_result = {
    fine_amount = "Уряд оголосив надзвичайний стан і штрафує Вас на %d$.",
    close_text = "Ура!",
    hospital_evacuated = "Міністерство охорони здоров'я не мало вибору, окрім як евакуювати всю лікарню.",
    succeeded = {
      part_1_name = "До сан. інспектора дійшли чутки, що ваш заклад має справу з важким випадком %s.",
      part_2 = "Однак він не зміг знайти доказів для підтвердження цих чуток.",
    },
    compensation_amount = "Уряд вирішив нагородити вас %d$ як компенсацію за шкоду, завдану цією маленькою брехнею доброму імені вашої лікарні.",
    failed = {
      part_1_name = "Намагаючись приховати той факт, що попереду спалах %s,",
      part_2 = "персонал Вашої лікарні спричинив поширення хвороби по всьому району лікарні.",
    },
    rep_loss_fine_amount = "Ця новина буде в усіх газетах! Ваша репутація буде серйозно заплямована. А також  Вас очікує штраф у розмірі %d$.",
  },
  vip_visit_query = {
    choices = {
      invite = "Видати офіційне запрошення для ВІП",
      refuse = "Відхилити візит ВІП з найщирішими вибаченнями",
    },
    vip_name = "%s висловив бажання відвідати вашу лікарню",
  },
  vip_visit_result = {
    telegram = "Телеграма!",
    remarks = {
      [1] = "Це дивовижна лікарня! Коли я знову підхоплю якусь заразу, везіть мене одразу сюди.",
      [2] = "Оце я називаю Лікарнею!",
      [3] = "У вас чудова лікарня. І я знаю про що кажу, відвідав я їх не мало.",
      [4] = "Яка файно організована лікарня. Дякую за запрошення.",
      [5] = "Хм. А й справді, гарний медичний заклад",
      [6] = "Мені сподобалася ваша чарівна лікарня. Ну, гаразд, хтось хоче перекусити тайським каррі?",
      [7] = "Я... бачив і гірше. Незважаючи на це, є аспекти, які можна було б покращити.",
      [8] = "О боже. Я б не хотів опинитися тут, якби я був хворий.",
      [9] = "Що можу сказати, досить звичайна лікарня. Чесно кажучи, я очікував більшого.",
      [10] = "Чому я взагалі тут швендявся? Це було гірше, ніж чотиригодинна опера!",
      [11] = "Мені огидно від того, що я у Вас побачив. Ви називаєте це лікарнею? Скоріше смітником!",
      [12] = "Мені набридло бути на очах громадськості та відвідувати такі діри, як Ваша! Я подаю у відставку!",
      [13] = "Хіба це не міське звалище? Я зроблю все, що в моїх силах, щоб закрити цей заклад!",
      [14] = "Я ніколи раніше не бачив такої жахливої ​​лікарні. Яка ганьба!",
      [15] = "Я в шоці. Це не можна назвати лікарнею! Я йду пити пиво...",
      free_build = {
        [1] = "У вас дуже мила лікарня. Не складно буде запустити її без обмежень щодо грошей, правда?",
        [2] = "Я не економіст, але я думаю, що я теж зможу керувати цією лікарнею. Якщо розумієте про що це я...",
        [3] = "Файно працююча лікарня. Стережіться криз! Хоча ... вам тут нема про що турбуватися.",
      },
    },
    rep_boost = "Ваша репутація зросла.",
    vip_remarked_name = "Після візиту до Вашої лікарні %s зазначив:",
    cash_grant = "Ви отримали грошову підтримку у розмірі %d$.",
    rep_loss = "Ваша репутація постраждала.",
    close_text = "Дякуємо, що відвідали лікарню.",
  },
  disease_discovered = {
    discovered_name = "Ваша команда виявила нову хворобу. Це %s",
    can_cure = "Ви можете вилікувати цю хворобу.",
    close_text = "Було виявлено нову хворобу.",
    need_to_build = "Вам потрібно побудувати %s для лікування.",
    need_to_build_and_employ = "Якщо ви побудуєте %s і наймете %s, ви зможете вилікувати цю хворобу.",
    need_to_employ = "Найміть %s для вирішення цієї проблеми.",
  },
  disease_discovered_patient_choice = {
    need_to_build = "Вам потрібно збудувати %s, щоб мати змогу лікувати людей з такою хворобою.",
    need_to_employ = "Найміть %s для вирішення цієї проблеми.",
    what_to_do_question = "Що робити з пацієнтом?",
    guessed_percentage_name = "Ваша команда, провівши обстеження всіма наявними методами, висунула теорію, що це %s з імовірністю в %d%",
    choices = {
      send_home = "Відправити пацієнта додому.",
      research = "Відправити пацієнта у Кабінет дослідництва.",
      wait = "Хай пацієнт почекає деякий час у лікарні.",
    },
    disease_name = "Ваша команда виявила нову хворобу. Це %s",
    need_to_build_and_employ = "Якщо ви збудуєте %s і наймете %s, ви зможете досягти успіху у лікуванні.",
    can_not_cure = "Ви не можете вилікувати цю хворобу.",
  },
  diagnosis_failed = {
    choices = {
      send_home = "Відправити пацієнта додому.",
      take_chance = "Спробувати вилікувати за наявними результатами обстеження.",
      wait = "Нехай пацієнт чекає, доки не буде побудовано більше кабінетів для обстеження.",
    },
    situation = "Ми вичерпали всі наявні методи обстеження для цього пацієнта, і  все ще не впевнені, що з ним не так.",
    what_to_do_question = "Що нам робити з пацієнтом?",
    partial_diagnosis_percentage_name = "Можливо ми визначили, що з пацієнтом. Існує ймовірність у %d відсотків, що у нього %s.",
  },
  emergency = {
    locations = {
      [1] = "Липецький хімічний завод",
      [2] = "Липовий Університет",
      [3] = "Садовий центр вибіркового озеленення",
      [4] = "Інститут дослідження небезпечних речовин",
      [5] = "З'їзд танцюристів випуску Поплавського",
      [6] = "Паб «Bullfrog»",
      [7] = "Похоронний салон «Насолода і Монополія»",
      [8] = "Магазин тайського каррі",
      [9] = "Імперія оброблених нафтохімікатів Барта",
    },
    num_disease = "До нас прямують %d людей з хворобою %s, і вони потребують негайної допомоги.",
    cure_possible_drug_name_efficiency = "У вас вже є необхідне обладнання та навички. У вас є препарат, який їм потрібен. Це %s, і ліки ефективні на %d відсотків.",
    cure_not_possible_employ = "Вам потрібно найняти %s",
    cure_not_possible = "Зараз ви не можете вилікувати хворобу.",
    cure_possible = "У вас є відповідне обладнання та навички, тому ви зможете впоратися з цією НС.",
    choices = {
      accept = "Так. Я готовий впоратись з цією надзвичайною ситуацією.",
      refuse = "Ні. Я відмовляюся займатись цією надзвичайною ситуацією.",
    },
    location = "Сталася аварія у місці під назвою %s",
    cure_not_possible_build = "Вам потрібно побудувати %s",
    cure_not_possible_build_and_employ = "Вам потрібно побудувати %s та найняти %s",
    bonus = "За вирішення цієї НС Ви можете отримати як максимум %d$ бонусу. Але якщо ви не впораєтесь, ваша репутація буде сильно заплямована.",
    free_build = "Якщо Ви впораєтесь, Ваша репутація підвищиться, але якщо ви зазнаєте невдачі, це матиме сильний негативний вплив на вашу репутацію.",
    num_disease_singular = "Є 1 особа з %s і вона потребує невідкладної допомоги.",
  },
  emergency_result = {
    earned_money = "Ви могли отримати %d$, а вдалось заробити %d$.",
    close_text = "Натисніть, щоб закрити.",
    saved_people = "Ви врятували %d людей із %d усього.",
  },
  choices = {
    return_to_main_menu = "Повернутися до головного меню",
    accept_new_level = "Перейти до наступного рівня",
    decline_new_level = "Пограти ще трохи",
  },
  debug_fax  = {
    text2 = "ВСЬОГО %d ЛЮДЕЙ В ЛІКАРНІ ЗАРЕЄСТРОВАНО, ПЕРЕВІРЕНО %d",
    text7 = "РЕПУТАЦІЯ %d ОЧІКУВАНО %d ЗНИЖЕННЯ %d",
    text9 = "КАТАСТРОФИ %d ДОЗВОЛЕНО (MTHS) %d (%d)ЗМЕНШЕННЯ %d",
    text4 = "ФАКТОРИ: ЛІКАРІ %d МЕДСЕСТРИ %d ПЛОЩА %d КІМНАТИ %d ЦІНА %d",
    text1 = "КРАЩИЙ РАХУНОК %d",
    text6 = "ТАКОЖ УВІМКНЕНІ НАСТУПНІ ФАКТОРИ",
    close_text = "Так, так, так!",
    text3 = "КІЛЬКОСТІ: ДОКТОР %d МЕДСЕСТРИ %d ПЛОЩА %d КІМНАТИ %d ЦІНА %d",
    text5 = "УЧАСНИКИ: ЛІКАР %d МЕДСЕСТРИ %d ПЛОЩА %d кімнати %d ЦІНА %d ВІДСОТОК",
    text8 = "ЗРУЧНІСТЬ %d ЛЮДЕЙ ОПРАЦЬОВАНО %d АБО ЗМЕНШЕННЯ %d",
    text10 = "СМЕРТЬ %d ДОЗВОЛЕНО (MTHS) %d (%d) ЗМЕНШЕННЯ %d",
    text11 = "ЛЮДЕЙ ЦЬОГО МІСЯЦЯ %d",
  },
}

adviser = {
  tutorial = {
    build_reception = "Вітаю. Спочатку вашій лікарні потрібна Рецепція. Виберіть її в меню облаштування коридорів.",
    order_one_reception = "Щоб замовити одну Рецепцію, клацніть один раз лівою кнопкою миші на блимаючому рядку.",
    accept_purchase = "Клацніть лівою кнопкою миші на блимаючу кнопку, щоб купити.",
    reception_invalid_position = "Рецепція сірого кольору, тому що вона знаходиться в неправильному місці. Спробуйте перемістити або повернути її.",
    rotate_and_place_reception = "Клацніть правою кнопкою миші, щоб повернути Рецепцію та розмістіть її у вашій лікарні лівою кнопкою миші.",
    hire_receptionist = "Вам також знадобиться Рецепціоністка для першого прийому пацієнтів.",
    select_receptionists = "Клацніть лівою кнопкою миші на блимаючу кнопку, щоб побачити, які секретарі в даний момент доступні для найму. Число на піктограмі вказує, з якої кількості ви можете вибрати.",
    next_receptionist = "Це перша Рецепціоністка зі списку потенційних працівників. Клацніть лівою кнопкою миші блимаючий значок, щоб побачити наступну.",
    prev_receptionist = "Клацніть лівою кнопкою миші на блимаючий значок, щоб переглянути попередню доступну Рецепціоністку.",
    choose_receptionist = "Вирішіть, яка Рецепціоністка має хороші навички та співвідносну зарплату, а потім клацніть лівою кнопкою миші блимаючий значок, щоб найняти її.",
    receptionist_invalid_position = "Ви не можете поставити тут Рецепціоністку.",
    place_receptionist = "Винайміть Рецепціоністку і розмістіть її де завгодно. Вона знайте своє робоче місце власноруч.",
    build_gps_office = "Для того, щоб розпочати обстеження нових пацієнтів, вам потрібно побудувати Кабінет терапевта.",
    select_diagnosis_rooms = "Клацніть лівою кнопкою миші блимаючий значок, щоб відобразити список доступних кабінетів обстеження.",
    click_gps_office = "Клацніть лівою кнопкою миші на рядку, щоб вибрати Кабінет терапевта.",
    click_and_drag_to_build = "Щоб побудувати Кабінет терапевта, ви повинні спочатку визначитись з його розміром. Натисніть і утримуйте ліву кнопку, розтягніть креслення до потрібного розміру.",
    room_too_small = "Креслення цієї кімнати червоне, тому що вона занадто мала. Розтягніть її побільше.",
    room_in_invalid_position = "На жаль! Так не можна вчинити - червоні області вказують на те, що креслення пересікається з іншою кімнатою або стінами лікарні.",
    room_big_enough = "Креслення тепер достатньо великого розміру. Коли ви відпустите кнопку миші, воно буде розміщене. Ви все ще зможете пересувати його або змінювати розмір.",
    place_door = "Переміщайте мишу по стінам креслення кабінету, щоб розташувати двері там, де Вам потрібно.",
    door_in_invalid_position = "Ах! Ви намагалися розташувати двері в неправильному місці. Спробуйте поставити її в іншому.",
    place_windows = "Розташуйте вікна так само, як і двері. Вам не обов'язково розташовувати вікна, але ваші співробітники щасливіші, коли їм є куди погледіти. (Деякі навіть оцінять, якщо зазирне незнайомець.)",
    window_in_invalid_position = "Це вікно знаходиться в неправильному місці. Спробуйте розмістити його в іншому, будьте люб'язні.",
    place_objects = "Клацніть правою кнопкою миші, щоб обертати елементи кімнати, і клацніть лівою кнопкою миші, щоб поставити їх.",
    object_in_invalid_position = "Цей об'єкт знаходиться в неправильному місці. Будь ласка, розмістіть його в іншому місці або повертіть його.",
    confirm_room = "Клацніть лівою кнопкою миші блимаючий значок, щоб завершити ваш кабінет, або натисніть хрестик, щоб повернутися до попереднього кроку будівництва.",
    information_window = "Вікно довідки розповість вам усе про той гарний кабінет, який ви щойно побудували.",
    hire_doctor = "Вам потрібен Лікар для обстеження та лікування хворих людей.",
    select_doctors = "Клацніть лівою кнопкою миші на блимаючу кнопку, щоб переглянути доступних для найму лікарів.",
    choose_doctor = "Уважно подивіться на навички кожного Лікаря, перш ніж вибрати.",
    place_doctor = "Розташуйте Лікаря в будь-якому місці в середині лікарні. Як тільки у черзі до кабінеті буде хтось, кого потрібно обстежити, він піде туди.",
    doctor_in_invalid_position = "Гей! Ви не можете поставити Лікаря тут.",
    start_tutorial = "Прочитайте вступ до місії, потім клацніть лівою кнопкою миші, щоб почати навчання.",
    room_too_small_and_invalid = "Кімната занадто мала і знаходиться в неприпустимому місці. Так не годиться.",
    build_pharmacy = "Вітаємо! Тепер побудуйте Фармакологічний кабінет та найміть Медсестру, щоб у результаті отримати функціонуючу лікарню.",
  },
  epidemic = {
    hurry_up = "Якщо найближчим часом хоч щось не буде зроблено з цією епідемією, у вас буде набагато більше проблем. Тож рухайтеся!",
    serious_warning = "Ця зараза стає серйозною. Вам потрібно щось зробити із цим і якнайшвидше!",
    multiple_epidemies = "Схоже, що у вас більше ніж одна епідемія одночасно. Це може стати величезною катастрофою, тому негайно зробіть щось із цим.",
  },
  staff_advice = {
    need_handyman_machines = "Якщо ви хочете обслуговувати апарати у вашій лікарні, вам потрібно найняти Різноробочого.",
    need_doctors = "Вам потрібно більше лікарів. Спробуйте розмістити ваших найспритніших лікарів у кімнатах із довгими чергами.",
    need_handyman_plants = "Вам потрібно найняти Різноробочого для поливу рослин.",
    need_handyman_litter = "Люди почали влаштовувати безлад у вашій лікарні. Найміть Різноробочого, щоб він прибирав за ними.",
    need_nurses = "Вам потрібно найняти більше медсестер. Палати та аптеки потребують медсестер.",
    too_many_doctors = "У вас забагато лікарів. Деяким зараз нічим зайнятися.",
    too_many_nurses = "Я думаю, що зараз у вас занадто багато медсестер.",
  },
  earthquake = {
    damage = "Цей землетрус пошкодив %d обладнання та постраждали %d людей у ​​лікарні.",
    alert = "Надійшло попередження про землетрус. Під час землетрусу ваші пристрої будуть пошкоджені. Якщо ви не подбаєте про них зараз, вас чекає феєрверк.",
    ended = "Фух. Думаю, що це був сильний землетрус - це було %d за шкалою Ріхтера.",
  },
  surgery_requirements = {
    need_surgeons_ward_op = "Вам потрібно найняти двох хірургів і побудувати палату, а також операційну, щоб виконати операцію.",
    need_surgeon_ward = "Вам все ще потрібно найняти іншого хірурга та побудувати Палату для виконання операцій.",
  },
  vomit_wave = {
    started = "У нас тут щось погане... Блювотна епідемія. Можливо допоможе, якщо ви наймете більше Різноробочих, тож лікарня після цього не буде так сильно смердіти.",
    ended = "Фух! Схоже, ви тут все вичистили. Люди більше не блюють. Підтримуюте чистоту в лікарні і надалі.",
  },
  level_progress = {
    halfway_lost = "Ви на півдорозі до програшу у цьому рівні.",
    dont_kill_more_patients = "Ви лікарня, а не кладовище! Намагайтеся більше не вбивати пацієнтів.",
    another_patient_killed = "О ні! Ще один пацієнт помер на ваших руках. Загалом %d смертей зараз.",
    halfway_won = "Ви на півдорозі до перемоги!",
    close_to_win_increase_value = "Ви дуже близькі до перемоги. Збільшіть вартість вашої лікарні на %d.",
    financial_criteria_met = "Ви виконали фінансові критерії для цього рівня. Тепер утримуйте свій баланс вище %d, одночасно переконавшись, що ваша лікарня функціонує добре.",
    nearly_won = "Виграш у цьому рівні вже у ваших руках.",
    hospital_value_enough = "Тримайте вартість лікарні вище %d і займайтеся іншими проблемами, щоб виграти рівень.",
    another_patient_cured = "Чудово - ще один пацієнт вилікуваний! Назараз %d.",
    three_quarters_lost = "Ви на три чверті шляху до програшу цього рівня.",
    reputation_good_enough = "Чудово, ваша репутація достатньо висока, щоб виграти цей рівень. Тримайте її вище %d і вирішіть інші проблеми, щоб пройти його.",
    nearly_lost = "Ви дуже близькі до програшу цього рівня.",
    improve_reputation = "Вам потрібно покращити свою репутацію на %d, щоб наблизитись до перемогу на цьому рівні.",
    three_quarters_won = "Ви пройшли три чверті шляху до перемоги на цьому рівні.",
    cured_enough_patients = "Ви вилікували достатньо пацієнтів, але вам потрібно буде привести свою лікарню до ладу, щоб виграти рівень.",
  },
  staff_place_advice = {
    receptionists_only_at_desk = "Рецепціоністки можуть працювати лише на Рецепції.",
    only_psychiatrists = "Лікарі можуть працювати в психіатрії, якщо вони мають навичку Психіатра.",
    only_surgeons = "Лікарі можуть оперувати в операційній, лише якщо вони мають навичку Хірург.",
    only_doctors_in_room = "Тільки лікарі можуть працювати в %s.",
    only_nurses_in_room = "Тільки медсестри можуть працювати в %s.",
    nurses_cannot_work_in_room = "Медсестри не можуть працювати в %s.",
    only_researchers = "Лікарі можуть досліджувати в Кабінеті дослідництва, лише якщо вони мають навичку Дослідника.",
    doctors_cannot_work_in_room = "Лікарі не можуть працювати в %s.",
    not_enough_lecture_chairs = "Кожному лікарю, що навчається треба треба лекційний стілець, щоб бути присутнім тут!",
  },
  room_forbidden_non_reachable_parts = "Якщо ви розмістите приміщення тут, частина лікарні буде недоступною.",
  research = {
    machine_improved = "%s було покращено вашою командою дослідників.",
    drug_fully_researched = "Ви дослідили %s на всі 100%",
    new_machine_researched = "Новий %s щойно був успішно винайдений.",
    drug_improved = "Ліки від %s були вдосконалені Вашою командою дослідників",
    drug_improved_1 = "Ліки %s були вдосконалені Вашими дослідниками.",
    new_available = "Новий %s доступний.",
    new_drug_researched = "Було винайдено новий препарат для лікування %s.",
    autopsy_discovered_rep_loss = "Ваш Авторозтинач побачили в дії! Дуже необачно з Вашої сторони. Громадськість засудить Вас за це!",
  },
  boiler_issue = {
    minimum_heat = "О, а ось і ви! Котел у підвалі зламався. Схоже, у відвідувачів вашої лікарні скоро зацокочуть зуби.",
    maximum_heat = "Котел у підвалі перегрівається. Радіатори віддають максимум свого тепла. Люди стікають від перегріву! Поліпшити ситуацію допомогли б більше автоматів з напоями.",
    resolved = "Маю гарні новини. Тепер котел і радіатори знову працюють належним чином. Через деякий час люди в лікарні знову будуть у комфортних умовах.",
  },
  room_requirements = {
    research_room_need_researcher = "Для використання Кабінета дослідництва вам потрібно найняти лікаря з досвідом досліджень.",
    op_need_another_surgeon = "Вам все ще потрібно найняти ще одного хірурга, щоб операційна нарешті запрацювала.",
    op_need_ward = "Вам потрібно побудувати Палату для передопераційного огляду пацієнтів, перш ніж вони зможуть піти на процедуру.",
    reception_need_receptionist = "Вам потрібно найняти Рецепціоністку, інакше ніхто і ніколи ніколи до вас не прийдуть.",
    psychiatry_need_psychiatrist = "Тепер, коли ви побудували Кабінет психіатра, вам також потрібно найняти лікаря з навичкою Психіатр.",
    pharmacy_need_nurse = "Вам потрібно найняти медсестру для Фармакології.",
    ward_need_nurse = "Вам потрібно найняти медсестру для палати.",
    op_need_two_surgeons = "Найміть двох хірургів для виконання операцій в операційній.",
    training_room_need_consultant = "Вам потрібно найняти Спеціаліста для навчання в Лекційній кімнаті.",
    gps_office_need_doctor = "Вам потрібно найняти лікаря для роботи в цьому кабінеті.",
  },
  goals = {
    win = {
      money = "Вам потрібно ще %d$, щоб відповідати грошовому критерію на цьому рівні.",
      cure = "Вилікуйте ще %d пацієнтів, і у вас буде достатньо, щоб виграти цей рівень.",
      reputation = "Збільште свою репутацію до %d, щоб відповідати критерію для перемоги на рівні",
      value = "Вам потрібно збільшити вартість лікарні до %d$",
    },
    lose = {
      kill = "Вбийте ще %d пацієнтів і ви програєте рівень!",
    },
  },
  warnings = {
    charges_too_low = "Ціна за ваші послуги занадто мала. Це приведе більше людей до лікарні, але ви не заробите багато грошей з кожного.",
    charges_too_high = "Ваші ціни зависокі. Хоча ви матимете високий дохід у короткостроковій перспективі, пізніше люди віддадуть перевагу більш дешевій лікарні.",
    staff_overworked = "Ваші співробітники страшенно перевтомлені. Вони стають некомпетентними і починають робити катастрофічні помилки.",
    doctors_tired = "Ваші лікарі майже засинають на роботі. Дайте їм відпочити врешті-решт.",
    people_did_it_on_the_floor = "Деякі пацієнти вже не могли більше терпіти. Для когось прибирання стане великим викликом.",
    queues_too_long = "Черги тягнуться аж на вулицю. Як щодо того, щоб побудувати більше кабінетів?",
    money_very_low_take_loan = "Ваш рахунок як Маріанська впадина. Ви могли б взяти позику, знаєте?",
    patients_very_thirsty = "Відвідувачів мучить спрага. Якщо ви найближчим часом не встановите Автомати з напоями, ви зіткнетеся з великим відтоком пацієнтів у сусідній паб.",
    machinery_very_damaged = "Терміново! Скажіть своєму Різноробочому негайно відремонтувати ваші апарати! Вони ось-ось вибухнуть!",
    handymen_tired2 = "Ваші Різноробочі повністю виснажені. Дайте їм перерву, інакше вони попадають з ніг… а ваші апарати не буде кому ремонтувати.",
    desperate_need_for_watering = "Вам конче потрібно найняти Різноробочого, щоб доглядати за вашими рослинами.",
    nurses_tired = "Ваші медсестри втомилися. Дайте їм відпочити.",
    too_much_litter = "У вас проблема зі сміттям. Різноробочий повинен мати можливість його прибрати.",
    reception_bottleneck = "Рецепція не може впоратись з напливом людей, поставте ще одну та найміть додатково Рецепціоністку.",
    place_plants4 = "Потіште пацієнтів більшою кількістю зелені в навколишньому середовищі.",
    change_priorities_to_plants = "Ви повинні збільшити пріоритети своїх Різноробочих на полив рослин, інакше вони зав'януть.",
    staff_too_hot = "Ваші співробітники перегріваються. Знизьте температуру в лікарні або приберіть зайві радіатори з кабінетів.",
    finanical_trouble2 = "Заробляйте більші гроші, або ви повністю розоритесь. Ви програєте рівень, якщо втратите ще %d$.",
    plants_thirsty = "Подбайте про свої рослини. Вони не штучні, їм потрібна вода.",
    litter_everywhere = "Всюди сміття. Надішліть побільше Різноробочих для вирішення цієї проблеми.",
    nurses_tired2 = "Ваші сестри вже засинають на робочому місці. Відправте їх відпочивати.",
    plants_dying = "Ваші рослини гинуть. Вода для них, мабуть, чуже слово. Відвідувачі не оцінять вигляду сухого листя замість квітучих рослин.",
    reduce_staff_rest_threshold = "Спробуйте знизити порогове значення для відпочинку співробітників на екрані Політики, щоб ваші співробітники відпочивали частіше. Просто пропоную.",
    more_toilets = "Вам потрібно більше туалетів. Інакше незабаром вам доведеться замовляти підгузки.",
    hospital_is_rubbish = "Люди відкрито говорять, що ваша лікарня жахлива. Перш ніж ви це усвідомите, вони почнуть лікувати свої хвороби в іншому місці.",
    pay_back_loan = "У вас багато грошей. Як щодо того, щоб подумати про виплату позики?",
    financial_trouble3 = "Ваш банківський баланс виглядає дещо тривожним. Подумайте, як можна підзаробити. Втратите ще %d$ і буде катастрофа.",
    bankruptcy_imminent = "Гей! Ще мить, і ви будете банкрутом! Не хочете щось змінити, а?",
    build_toilet_now = "Побудуйте туалет зараз же, інакше люди більше не витримають. Не смійтеся - бо потім буде не до жартів.",
    patient_stuck = "Хтось заблукав, йому навіть рецепціоністка не допомогла. Намагайтеся не будувати лабіринти.",
    no_patients_last_month = "Минулого місяця до вашої лікарні не приходили нові пацієнти. Я вважаю, що без них лікарня зовсім втрачає сенс.",
    more_benches = "Розгляньте можливість розміщення більшої кількості Лавок. Хворі люди ненавидять стояти.",
    many_epidemics = "Схоже, що у вас більше ніж одна епідемія одночасно. Це може стати величезною катастрофою, тому негайно зробіть щось із цим.",
    place_plants_to_keep_people = "Люди йдуть. Розмістіть більше квітів, може ви переконаєте їх залишитися.",
    patients_thirsty2 = "У лікарні люди, а не кактуси. Варто поставити більше автоматів з напоями або перенести наявні ближче до людей.",
    money_low = "Грошики капають не так, як слід, тому можуть закінчитись!",
    staff_unhappy = "Ваші працівники незадоволені. Спробуйте дати їм премію, а ще краще – побудуйте для них Кімнату відпочинку. Ви також можете змінити правила відпочинку своїх співробітників на екрані «Політика».",
    people_freezing = "Неймовірно, незважаючи на винахід під назвою Котел, деякі з ваших пацієнтів замерзають до смерті. Поставте радіатори, щоб їм було тепліше або підвищте тепло.",
    need_toilets = "Пацієнтам потрібні туалети. Побудуйте їх у легкодоступному місці.",
    nobody_cured_last_month = "Минулого місяця взагалі ніхто не вилікувався. Це справді лікарня?",
    patients_very_cold = "Хворі вже як крижані скульптури. Спробуйте збільшити температуру опалення або розмістити більше радіаторів у вашій лікарні.",
    build_toilets = "Побудуйте туалет зараз, інакше ви побачите щось дуже відразне. І уявіть, як пахнутиме ваша лікарня.",
    many_killed = "Назараз ви вбили %d людей. Ви знаєте, що ви лікарня, а не бійня?",
    place_plants2 = "Люди йдуть. Трохи більше рослин допоможе затримати їх надовше.",
    staff_tired = "Ваші співробітники дуже втомлюються. Якщо ви не дасте їм трохи розвіятись в Кімнаті відпочинку, деякі з них можуть збожеволіти під тиском.",
    machines_falling_apart = "Ваші апарати починають розвалюватися. Негайно надішліть до них Різноробочого з клейкою стрічкою!",
    patients_unhappy = "Пацієнтам не подобається ваша лікарня. Ви повинні зробити щось, щоб покращити їхнє середовище.",
    place_plants3 = "Пацієнти стають нещасними. Розмістіть більше рослин, щоб заспокоїти їх.",
    staff_unhappy2 = "Ваші співробітники, як правило, незадоволені. Це поведе за собою певні витрати.",
    cash_low_consider_loan = "Ваш рахунок близький до абсолютного нуля. Ви думали про позику?",
    queue_too_long_at_reception = "У вас занадто багато пацієнтів, які чекають своєї черги на Рецепції. Розмістіть іншу рецепцію та найміть ще одну Рецепціоністку.",
    queue_too_long_send_doctor = "Ваші черги у %s довші за банани. Переконайтеся, що в кімнаті є лікар.",
    financial_trouble = "У вас серйозні фінансові проблеми. Організуйте використання своїх грошей! Якщо ви втратите ще %d$, ви програєте цей рівень!",
    doctors_tired2 = "Ваші лікарі неймовірно втомлені. Їм потрібен негайний відпочинок, інакше навіть поцілунок їх не розбудить.",
    handymen_tired = "Ваші різноробочі втомилися. Залиште їх на деякий час на дивані.",
    patient_leaving = "Хворий йде. Причина? Ваша погано керована, погано укомплектована та погано обладнана лікарня!",
    machinery_damaged2 = "Вам потрібно найближчим часом найняти Різноробочого для ремонту ваших апаратів.",
    patients_leaving = "Пацієнти втікають. Покращуйте лікарню для своїх відвідувачів, розмістивши рослини, лавки, автомати з напоями тощо.",
    epidemic_getting_serious = "Ця епідемія стрімко стає серйозною. Треба швидше щось робити!",
    machinery_damaged = "Відремонтуйте свої апарати як можна скоріше, інакше незабаром вам не буде чим лікувати.",
    people_have_to_stand = "Люди, які страждають від хвороб, повинні ще й стояти? Придумайте чарівний засіб від стояння.",
    build_staffroom = "Негайно побудуйте кімнату відпочинку. Ваші співробітники працюють занадто багато і знаходяться на межі зриву. Давайте - будьте розсудливим!",
    machinery_slightly_damaged = "Ваше обладнання в лікарні незначно пошкоджено. Тримайте його у належному стані, інакше щось зламається.",
    need_staffroom = "Побудуйте кімнату відпочинку, щоб вони могли відволіктись від рутини.",
    patients_getting_hot = "Деяккі пацієнти починають буквально випаровуватися. Спробуйте зменшити опалення або видалити деякі радіатори",
    machinery_deteriorating = "Ваші апарати почали зношуватись через надмірне використання. Слідкуйте за ними, інакше ви будете збирати їх по частинах.",
    patients_too_hot = "Пацієнтам стає дуже жарко. Рекомендую: приберіть кілька радіаторів, знизите температуру або встановіть більше автоматів з напоями.",
    patients_thirsty = "Люди починають зсихатись як родзинки. Можливо, ви могли б напоїти їх за допомогою торгових автоматів.",
    machine_severely_damaged = "%s от-от вибухне!",
    litter_catastrophy = "Ситуація зі сміттям безрадісна. Нехай команда різноробочих негайно почне працювати над цим!",
    staff_very_cold = "Працівники скаржаться на холод. Збільште температуру опалення або поставте більше радіаторів.",
    deal_with_epidemic_now = "Якщо з цією епідемією найближчим часом нічого не зробити, то матимете бід до лоба. Тож рухайтеся!",
    too_many_plants = "У вас занадто багато квітів. Ми ж у лікарні, а не в джунглях.",
    patients_really_thirsty = "Ваша лікарня нагадує Сахару. Розмістіть більше автоматів з напоями або перенесіть існуючі ближче до скупчення людей.",
    some_litter = "Більше різноробочих могли б позбутися сміття швидше, перш ніж все це перетвориться на звалище.",
    patients_annoyed = "Люди страшенно незадоволені тим, як ви керуєте лікарнею. І це не дивно. Лікуйте краще або зіткнетеся з наслідками!",
    doctor_crazy_overwork = "О ні! Один із ваших лікарів збожеволів від перевтоми. Якщо ви негайно відправите його на відпочинок, він видужає. Мабуть.",
    no_desk_7 = "Ви побудували рецепцію, тепер вам залишилося найняти Рецепціоністку. Навіть ви не знаєте куди треба відправляти пацієнтів, тільки вона!",
    researcher_needs_desk_1 = "Досліднику для роботи потрібен його стіл.",
    no_desk_3 = "Вам подобається тиша? Майже рік пройшов, а у вас немає рецепції! Як ви думаєте, чи будуть сюди приходити ваші пацієнти? Виправте це зараз і припиніть тинятися!",
    no_desk_6 = "У вас є рецепціоністка, то як щодо того, щоб побудувати для неї Рецепцію, де вона зможе почати працювати?",
    no_desk_1 = "Якщо ви хочете, щоб люди приходили до вашої лікарні, вам потрібно буде найняти Рецепціоністку і побудувати для неї Рецепцію, де вона зможе працювати.",
    falling_5 = "Це місце не для того, щоб виштурхувати людей, ти ж знаєш, що вони хворі!",
    no_desk = "Все ж ви повинні побудувати Рецепцію і найняти Рецепціоністку!",
    no_desk_2 = "Ви молодець, це, мабуть, світовий рекорд: майже рік і жодного хворого! Якщо ви хочете продовжувати працювати адміністратором цієї лікарні, вам потрібно найняти Рецепціоністку та побудувати рецепцію, де вона зможе працювати!",
    cannot_afford = "Ваша банківський рахунок не переконає цю людину працювати на вас!",
    research_screen_open_1 = "Ви повинні побудувати Кабінет Дослідника, перш ніж ви зможете відкрити Екран дослідження.",
    nurse_needs_desk_1 = "Кожній медсестрі для роботи потрібен власний стіл.",
    researcher_needs_desk_2 = "Ваш дослідник задоволений вашою щедрістю, яка дозволила йому відпочити від роботи. Якщо ви плануєте, щоб кілька дослідників працювали одночасно, вам потрібно створити для кожного з них окремий стіл.",
    research_screen_open_2 = "Наразі дослідження недоступні.",
    falling_1 = "Гей! Це не жарти, дивись, куди клацаєш цією своєю мишкою, ти можеш когось ранити!",
    receptionists_tired2 = "Ваші рецепціоністки дуже виснажені. Нехай тепер відпочинуть.",
    falling_3 = "Аай, боляче, хто-небудь покличте лікаря!",
    no_desk_5 = "Що ж, пора. Скоріше починайте приймати пацієнтів!",
    no_desk_4 = "Рецепціоністці потрібне власне робоче місце, щоб зустрічати пацієнтів, коли вони прибувають.",
    falling_2 = "Припиніть вошкатись! Вам це справді подобається?",
    researcher_needs_desk_3 = "Кожен дослідник повинен мати власний стіл.",
    cannot_afford_2 = "Ні, це не дорого, ти просто недостатньо багатий!",
    falling_6 = "Це не боулінг, не можна так поводитися з хворими!",
    nurse_needs_desk_2 = "Ваша медсестра в захваті від кількості вільного часу, який ви їй надаєте. Якщо ви маєте намір включити її в робочого процесу, можливо, буде гарною ідеєю дати кожній стіл, за яким всі зможуть працювати.",
    receptionists_tired = "Ваші рецепціоністки серйозно втомилися. Дозволяйте їм іноді вислизнути з-за стійки реєстрації.",
    falling_4 = "Це лікарня, а не Theme Park!",
    another_desk = "Ви повинні побудувати рецепцію для своєї рецепціоністки.",
    fair_prices = "Ваша ціна за %s виглядає прийнятною та збалансованою.",
    high_prices = "Ви берете занадто багато за %s. Хоч з пацієнтів ви більше здерете, та вони швидше підуть до конкурентів ніж ви заробите статок.",
    low_prices = "Ви берете дуже мало за %s. Це залучить до лікарні більше пацієнтів, але багато на них не заробиш.",
    patient_not_paying = "Пацієнт пішов не сплативши за %s, тому що це занадто дорого!",
    cannot_afford_machine = "Вам потрібно хоча б %1%$ у банку, щоб купити нову %2%!",
  },
  placement_info = {
    door_cannot_place = "Вибачте, але ви не можете зробити тут двері.",
    staff_cannot_place = "Ви не можете поставити тут свого працівника. Вибачте.",
    object_cannot_place = "Гей, ви не можете розмістити цей об'єкт тут!",
    room_cannot_place = "Ви не можете розмістити цю кімнату тут.",
    room_cannot_place_2 = "Цю кімнату не можна тут розмістити.",
    window_cannot_place = "Нажаль... Ви практично не можете зробити тут вікно.",
    reception_cannot_place = "Ви не можете розмістити тут рецепцію.",
    reception_can_place = "Ви можете розмістити рецепцію прямо тут.",
    window_can_place = "Ви можете зробити це вікно тут. Воно стане як рідне.",
    door_can_place = "Ви можете розмістити ці двері тут, якщо хочете.",
    object_can_place = "Ви можете розмістити тут цей об'єкт.",
    staff_can_place = "Тут можна поставити вашого робітника.",
  },
  information = {
    larger_rooms = "Більші кімнати допомагають співробітникам відчувати себе важливими та покращують їх продуктивність.",
    extra_items = "Додаткові предмети в кімнатах заспокоюють ваших співробітників і покращують їх продуктивність.",
    epidemic = "Вашою лікарнею шириться інфекційна хвороба. Ви повинні негайно щось з цим зробити!",
    promotion_to_doctor = "Один із ваших Інтернів став Лікарем.",
    emergency = "Увага! Надзвичайна ситуація! Рухайтесь! Рухайтесь! РУХАЙТЕСЬ!",
    patient_abducted = "Одного з ваших пацієнтів викрадають прибульці!",
    first_cure = "Чудово! Ви щойно вилікували свого першого пацієнта!",
    promotion_to_consultant = "Один із ваших лікарів став Спеціалістом.",
    handyman_adjust = "Різноробочі можуть прибирати ефективніше, якщи ви надасте їм відповідні пріоритети.",
    promotion_to_specialist = "Один з ваших лікарів отримав навичку %s.",
    initial_general_advice = {
      rats_have_arrived = "У вашій лікарні більше щурів, ніж пацієнтів. Спробуйте постріляти в щурів своїм курсором миші.",
      first_patients_thirsty = "Люди відчувають спрагу у вашій лікарні. Торговий автомат може сильно допомогти.",
      research_now_available = "Ви створили свій перший Кабінет дослідництва. Тепер ви можете перейти на Екран дослідження.",
      decrease_heating = "Люди тануть у вашій лікарні! Можливо, настав час зменшити температуру опалення в Екрані містечка.",
      first_emergency = "Пацієнти з надзвичайної ситуації мають синю миготілку над їхніми головами. Вилікуйте їх, перш ніж вони помруть або час закінчиться.",
      first_epidemic = "У вашій лікарні епідемія! Вирішіть, чи хочете ви це приховати, чи визнати її наявність.",
      taking_your_staff = "Хтось переманює вашого працівника. Вам доведеться поборотися, щоб утримати його тут.",
      place_radiators = "Людям у вашій лікарні холодно - ви можете розмістити більше радіаторів, вибравши їх у меню Оздоблення коридору.",
      epidemic_spreading = "У вашій лікарні панує епідемія. Спробуйте вилікувати інфікованих людей, перш ніж вони підуть від вас.",
      machine_needs_repair = "У вас є апарат, який потребує ремонту. Знайдіть його - він буде диміти - і натисніть на нього. Потім натисніть кнопку ремонтника.",
      increase_heating = "У людей з носа звисають бурульки! Можливо, вам варто підвищити температуру нагріву на Екрані містечка.",
      first_VIP = "Ви збираєтеся прийняти свій перший ВІП-візит. Спробуйте зробити так щоб ВІП не помітив нічого антисанітарного або ваших незадоволених пацієнтів.",
      psychiatric_symbol = "Лікарі, які мають додаткову навичку психіатра, мають символ: |",
      research_symbol = "Лікарі, здатні проводити дослідження, мають символ: }",
      surgeon_symbol = "Лікарі, які можуть виконувати операції, мають символ: {",
      autopsy_available = "Було винайдено машину для автоматичного розтину. За допомогою неї ви можете позбутися проблемних і небажаних пацієнтів і провести дослідження їхніх решток. Майте на увазі, що використання цієї машини є дуже неприйнятним у цивілізованому світі.",
    },
    patient_leaving_too_expensive = "Пацієнт йде, не заплативши за %s. Для нього це занадто дорого.",
    vip_arrived = "Увага! ВІП - %s, щойно прибув для огляду вашої лікарні! Переконайтеся, що все йде гладко, аби порадувати його.",
    epidemic_health_inspector = "Новини про вашу епідемію дійшли до Міністерства охорони здоров'я. Приготуйтеся до візиту сан. інспектора.",
    first_death = "Ви щойно вбили свого першого пацієнта. І що, які відчуття?",
    pay_rise = "Один із ваших працівників погрожує звільнитися. Виберіть погодитися з їхніми вимогами або вигнати їх. Натисніть на піктограму ліворуч, щоб побачити, який свме працівник погрожує піти.",
    place_windows = "Розміщення вікон зробить кімнату світлішою та покращить настрій ваших працівників.",
    fax_received = "Піктограма, яка з'явилася в нижній лівій частині екрана, сповіщає вас про важливу інформацію або рішення, яке вам потрібно прийняти.",
  },
  competitors = {
    staff_poached = "Один із ваших працівників був перехоплений іншою лікарнею.",
    land_purchased = "%s щойно придбав ділянку.",
    hospital_opened = "%s відкрив конкуруючу лікарню в цьому районі.",
  },
  praise = {
    many_benches = "Пацієнти тепер можуть посидіти всюди! Плюс один бал вам.",
    few_have_to_stand = "Мало людей можуть постояти у вашій лікарні. Багато сидячих пацієнтів неймовірно щасливі.",
    plenty_of_benches = "В лікарні багато де можна присісти. Дуже добре.",
    plants_thriving = "Чудово. Ваші рослини зеленіють. Продовжуйте, і ви можете виграти за них медаль.",
    plants_are_well = "Краса змінюється ще більшою красою. Продовжуйте дбати про свої квіти.",
    many_plants = "Як добре. У вас багато рослин! Ваші пацієнти це точно оцінять.",
    patients_cured = "%d пацієнтів вилікувано."
  },
  build_advice = {
    placing_object_blocks_door = "Якщо розмістити цей об'єкт тут, люди не зможуть дістатися до дверей.",
    door_not_reachable = "Люди не зможуть дістатися до дверей. У чому ж проблема, мм?",
    blueprint_would_block = "Це креслення блокуватиме інші кімнати. Спробуйте змінити його розмір або перемістити в інше місце.",
    blueprint_invalid = "Це креслення не відповідає вимогам.",
  },
  multiplayer = {
    poaching = {
      not_interested = "Ха! Вони не зацікавлені працювати на вас - вони щасливі там, де вони є.",
      already_poached_by_someone = "Це неможливо! Хтось уже намагається переманити цю людину.",
      in_progress = "Я дам вам знати, якщо ця людина захоче працювати на вас.",
    },
    objective_failed = "Ви не впоралися з ціллю. Жодних оплесків.",
    objective_completed = "Ви досягли цілі. Ми аплодуємо вам стоячи!",
    players_failed = "Наступні гравці не змогли виконати останнє завдання: ",
    everyone_failed = "Ніхто не зміг виконати останнє завдання. Тож усі продовжують грати!",
  },
  cheats = {
    th_cheat = "Вітаємо, ви розблокували чіти!",
    roujin_off_cheat = "Змагання Roujin'а деактивовано.",
    roujin_on_cheat = "Змагання Roujin'а активовано! Удачі...",
    norest_off_cheat = "Фух! Схоже ефект кавуськи закінчився. Тепер ваш персонал може спокійно відпочивати.",
    norest_on_cheat = "О ні! Виявляється ваш персонал перепив кохфе і їм тепер зовсім не потрібен відпочинок.",
  },
}

introduction_texts = {
  demo =
    "Ласкаво просимо у демо версію лікарні//" ..
    "На жаль, демоверсія містить лише цей рівень. Однак його більш ніж достатньо, щоб розважити вас деякий час! " ..
    "Ви зіткнетеся з різними захворюваннями, для лікування яких потрібні різні кімнати. Час від часу ви можете зіткнутися з надзвичайними ситуаціями. І вам потрібно буде досліджувати додаткові кімнати за допомогою Кабинета дослідництва. " ..
    "Ваше завдання — заробити 100,000$, мати вартість лікарні 70,000$ і репутацію 700, при цьому ви повинні вилікувати щонайменше 75% своїх пацієнтів. " ..
    "Переконайтеся, що ваша репутація не впаде на 300 і ви не вб’єте більше 40% своїх пацієнтів, інакше ви програєте.//" ..
    "Удачі!",
  level1 =
    "Ласкаво просимо до вашої першої лікарні!//" ..
    "Ви можете розміщуватись тут. Поставте рецепцію, побудуйте Кабінет терапевта та найміть рецепціоністку і лікаря. " ..
    "Тоді зачекайте, поки прийде якийсь відвідувач. " ..
    "Також не зайвим буде створити Кабінет психиатра та найняти лікаря з відповідною додатковою навичкою. " ..
    "Фармакологія і медсестра також необхідні для лікування ваших пацієнтів. " ..
    "Стережіться випадків дивної хвороби «Надута голова» — їх вилікує лікар зі спеціальним апаратом. " ..
    "Вам потрібно вилікувати принаймні 10 людей і стежити, щоб ваша репутація не впала нижче 200. ",
  level2 =
    "У цьому районі більший спектр захворювань. " ..
    "Будуйте свою лікарню, для обслуговування великої кількості пацієнтів і готуйтеся побудувати Кабінет дослідництва. " ..
    "Не забувайте підтримувати чистоту і намагайтеся підняти свою репутацію якомога вище — ви зіткнетеся з такими хворобами, як «Заплетений язик», тому вам потрібен відповідний апарат. " ..
    "Ви також можете побудувати Кабінет кардіографії, це допоможе вам діагностувати нові захворювання. " ..
    "Обидві ці кімнати потрібно дослідити, перш ніж ви зможете їх побудувати. Ви також можете придбати додаткові ділянки землі, щоб розширити свою лікарню — скористайтеся для цього Екраном містечка. " ..
    "Досягніть репутації 300, 10,000$ на банківському рахунку та 40 вилікуваних відвідувачів. ",
  level3 =
    "Цього разу ви будуватимете лікарню в заможному районі. " ..
    "Міністерство охорони здоров’я очікує, що ви забезпечите тут великий приток грошей. " ..
    "По-перше, вам доведеться заробити хорошу репутацію, а коли вона буде працювати на лікарню, зосередьтеся якомога більше на тому, щоб заробляти гроші. " ..
    "Також існує ймовірність виникнення надзвичайних ситуацій. " ..
    "Це означає, що відразу прийде велика кількість людей з однаковою хворобою. " ..
    "Вилікуйте всіх за відведений час і це покращить вашу репутацію та додасть великий грошовий бонус. " ..
    "Можуть з’явитися такі хвороби, як «Синдром Короля». Також варто закладати в кошторис будівництво Операційної та Палати поруч. " ..
    "Заробіть 20,000$, щоб перейти на наступний рівень. ",
  level4 =
    "Слідкуйте за тим щоб всі люди були щасливими, поводьтеся з ними якомога краще і зведіть до мінімуму кількість смертей. " ..
    "Репутація лікарні під загрозою, тому постарайтесь підняти і утримувати її якомога вище. " ..
    "Не надто хвилюйтеся про гроші - вони прийдуть разом зі зростанням вашої репутації. " ..
    "У вас також буде можливість навчати лікарів і підвищувати їх додаткову навичку. " ..
    "Добре навчений персонал зможе краще оглядати пацієнтів, які здаються більш серйозним викликом, ніж інші. " ..
    "Досягніть 500 репутації і тримайте її вище. ",
  level5 =
    "Цей район насичений різноманітними захворюваннями, тож очікується вражаючий наплив відвідувачів. " ..
    "У вас є лише інтерни, котрі щойно закінчили навчання, тому для них потрібно побудувати навчальний кабінет, щоб отримати необхідну вам додаткову навичку. " ..
    "У вашому розпорядженні три консультанти, які можуть навчати ваш персонал. Тож заохочуєте їх, щоб вони й не думали піти. " ..
    "Також слід зазначити, що лікарня розташована якраз на тектонічному розломі Сан Андроїд. " ..
    "Завжди існує можливість невеличкого землетрусу. " ..
    "Він може пошкодити ваше обладнання та порушити налагоджену роботу вашої лікарні. " ..
    "Підвищте свою репутацію до 400 і заробіть на баланс лікарні 50,000$, щоб досягти успіху. Також вилікуйте 200 пацієнтів. ",
  level6 =
    "Використайте всі свої знання, щоб створити стабільну, добре працюючу лікарню, яка матиме файний прибуток і здатна впоратися з усім, що може їй підкинути хворе суспільство. " ..
    "Варто прийняти той факт, що тут особливо сприятлива атмосфера для розмноження мікробів та інфекцій. " ..
    "Якщо ви не будете підтримувати свою лікарню в чистоті, ви абсолютно точно зіткнетесь з епідемією серед відвідувачів. " ..
    "Заробіть 150000$ і підніміть вартість вашої лікарні вище 140,000$.",
  level7 =
    "Тут ви будете під пильним наглядом Міністерства охорони здоров’я, тому переконайтеся, що ваш баланс відобразить величезні прибутки і що ваша репутація буде висоті. " ..
    "Смерті, в даному, випадку - неприпустимі! Вони погано впливають на бізнес. " ..
    "Переконайтеся, що ваші співробітники відмінно навчені, і що у вас є все необхідне обладнання. " ..
    "Отримайте 600 репутації плюс заробіть 200,000$ на рахунок у банку.",
  level8 =
    "Створіть максимально ефективну та прибуткову лікарню. " ..
    "Люди тут зовсім непогано живуть, тож вичавіть з них якомога більше грошенят. " ..
    "Пам’ятайте, лікувати людей – це добре, але вам дійсно ПОТРІБНІ їх гроші. " ..
    "Звільніть цих хворих людей від їхніх грошей по повній. " ..
    "Накопичте астрономічні 300,000$ для Міністерства охорони здоров’я, щоб пройти цей рівень.",
  level9 =
    "Тепер, коли ви переказали гроші до міністерства та оплатили цим новий лімузин для самого міністра, ви зможете повернутися до створення дбайливої, охайної лікарні для хворих і нужденних. " ..
    "Тут ви зіткнетесь з великою кількістю різноманітних труднощів. " ..
    "Але якщо у вас є достатньо добре навчений персонал і необхідна апаратура, це не повинно стати проблемою. " ..
    "Ваша лікарня має коштувати 200,000$, а на рахунку лікарні вам необхідно накопичити 400,000$. " ..
    "Доларом менше, і ви не зможете завершити рівень.",
  level10 =
    "Міністерство просить, щоб, окрім лікування хвороб, характерних для цих країв, ви приділили час підвищенню ефективності ліків. " ..
    "Їм надходять скарги від журналу Здоров'я та Життя без Ліків. Тому, щоб не заплямити репутацію, ви повинні переконатися, у надзвичайній ефективності ваших ліків. " ..
    "Також дивіться, щоб вашій лікарні не докоряли. Нехай смертність не буде занадто високою. " ..
    "Маленька підказка: можливо, вам варто відвести вільне місце для Кабінету лікування ожелеювання. " ..
    "Щоб виграти, покращте всі ліки до 80% ефективності, здобудьте репутацію 650 і заробіть 500,000$ у банку. ",
  level11 =
    "Вам була надана унікальна можливість побудувати найдосконалішу лікарню з усіх. " ..
    "Міністерство хотіло б мати найкращу лікарню в цьому надзвичайно відомому районі. " ..
    "Ми очікуємо, що ви заробите купу грошей, створите чудову репутацію та зможете впоратися з усіма спіткаючими негараздами. " ..
    "Це дуже важлива робота. " ..
    "Вам доведеться справді перевершити себе. " ..
    "Також вам слід знати, що в цьому районі було помічено НЛО. Переконайтеся, що ваш персонал готовий до несподіваних відвідувачів. " ..
    "Умови виграшу: вартість лікарні 240,000$, 500,000$ на рахунку та репутація не менше 700. ",
  level12 =
    "Тепер перед вами виклик усіх викликів. " ..
    "Міністерство вражене вашим успіхом та дає вам найвищу посаду! Вони хочуть, щоб хтось побудував найкращу лікарню, заробив величезні гроші та мав неймовірну репутацію. " ..
    "Від вас також очікується, що ви купите всю землю містечка, вилікуєте всіх (і ми дійсно маємо на увазі всіх), тоді всі нагороди ваші. " ..
    "То як? Ви готові взятись за це? " ..
    "Заробіть 650,000$, вилікуйте 750 людей і досягніть репутації 800, щоб виграти. ",
  level13 =
    "Чутки про ваші неймовірні навички як керівника лікарні не пройшли повз Служби безпеки та розвідки. " ..
    "У них є спеціальна задача для вас; є лікарня, захоплена щурами, якій потрібен ефективний Винищувач! " ..
    "Ви повинні знищити якомога більше пацючат, перш ніж різноробочі приберуть весь безлад. " ..
    "Думаєте впораєтесь? ",
  level14 =
    "Є ще один виклик — абсолютно непередбачувана лікарня-сюрприз. " ..
    "Якщо ви досягнете успіху і тут, ви станете переможцем з переможців. " ..
    "Але не чекайте, що це буде легко, тому що це найскладніше завдання, яке ви коли-небудь бачили. " ..
    "Удачі!",
  level15 =
    "Це основи роботи будь-якої лікарні.//" ..
    "Вашим лікарям знадобиться вся допомога, яку вони можуть отримати, щоб обстежити пацієнтів. Ви можете допомогти їм " ..
    "збудувавши якийсь кабінет діагностики, наприклад Кабінет загального обстеження.",
  level16 =
    "Після діагностування пацієнтів, вам потрібно буде побудувати кабінети для лікування хвороб. " ..
    "Гарною ідеєю буде почати з будівництва Фармакології. Вам знадобиться медсестра, щоб видавати там ліки. ",
  level17 =
    "Попереджаю! Настав час серйозно стежити за своєю репутацією — саме вона приваблює пацієнтів звідусіль у ваш заклад. " ..
    "Поки ви не вбиватимете багато людей і вони будуть йти від вас щасливими, у вас не повинно виникнути проблем на цьому рівні!//" ..
    "Тепер ти один на один із цим всім. Успіхів і бла бла бла.",
  level18 = "",
}
letter = {
  [1] = {
    [1] = "Шановний %s//",
    [2] = "Чудово! Ви вправно виконали свою роботу, керуючи цією лікарнею. Ми, ВІПи з Міністерства охорони здоров’я, хочемо знати, чи зацікавить вас більший проект. У нас є робота, для якої ви, як нам здається, готові. Заробітна плата становитиме %d$. Будь ласка, розгляньте нашу пропозицію.//",
    [3] = "Ви зацікавлені перейти працювати в лікарню «%s»?",
  },
  [2] = {
    [1] = "Шановний %s//",
    [2] = "Дуже добре! Ви досягли чудових успіхів у своїй лікарні. Ми знайшли для вас дещо інше, якщо ви хочете змінити обстановку та отримати нові цілі. Вам не обов'язково погоджуватися одразу, але якщо так, то нова зарплата буде %d$//",
    [3] = "Ви хочете отримати роботу в лікарні «%s»?",
  },
  [3] = {
    [1] = "Шановний %s//",
    [2] = "Ви досягли надзвичайного успіху під час роботи в цій лікарні. Ми очікуємо від вас великих звершень і надалі, тому хотіли б запропонувати вам посаду в іншому місці. Зарплата становитиме %d$, і ми думаємо, що вам сподобаються нові виклики, які постануть перед вами на новому місці.//",
    [3] = "Ви бажаєте отримати посаду в лікарні «%s»?",
  },
  [4] = {
    [1] = "Шановний %s//",
    [2] = "Вітаємо! Ми в Міністерстві дуже вражені вашою здатністю керувати лікарнею. Ви, безперечно, працівник року Департаменту охорони здоров’я. Але ми хочему, щоб ви віддали перевагу трохи важчій роботі. Вам платили б %d$, але все ж рішення за вами.//",
    [3] = "Ви зацікавлені у роботі в лікарні «%s»?",
  },
  [5] = {
    [1] = "Шановний %s//",
    [2] = "Вітаю, ще раз. Ми цінуємо ваше бажання не залишати цю чарівну лікарню, але ми закликаємо вас ще раз подумати. Ми запропонуємо вам кращу зарплату, у розмірі %d$, якщо ви готові перейти до іншої лікарні та зробити її такою ж досконалою, як і ця.//",
    [3] = "Ви згодні зараз же переїхати до лікарні «%s»?",
  },
  [6] = {
    [1] = "Шановний %s//",
    [2] = "Вітаємо. Ми знаємо, що ви щасливі в цьому чудовому та налагодженому під вас закладі, але ми вважаємо, що вам вже варто подумати про кар’єрний зріст. Звичайно, вам піднімуть платню до %d$, якщо ви вирішите переїхати. Є над чим задуматись, чи не так?//",
    [3] = "Ви б хотіли зайняти місце в лікарні «%s»?",
  },
  [7] = {
    [1] = "Шановний %s//",
    [2] = "Вітаємо! Міністерство охорони здоров’я хотіло б знати, чи бажаєте ви переглянути своє рішення залишитися в цій лікарні. Ми визнаємо, що у вас чудова лікарня, але ми також вважаємо, що вам було б добре прийняти місце з більш складним завданням і більшою зарплатою у %d$.//",
    [3] = "Чи бажаєте ви прийняти посаду в лікарні «%s»?",
  },
  [8] = {
    [1] = "Шановний %s//,",
    [2] = "Вітаю, ще раз. Ви негативно відповіли на наш останній лист із пропозицією про першокласну посаду в новій лікарні та підвищення зарплати до %d$. Проте наша думка незмінна, вам слід переглянути це рішення. Ми пропонуємо ідеальну роботу для вас!//",
    [3] = "Ви займете місце в лікарні «%s». Будь ласка?",
  },
  [9] = {
    [1] = "Шановний %s//,",
    [2] = "Ви продемонстрували, що є найкращим керівником лікарні за довгу та різноманітну історію медицини. Таке значне досягнення не може залишитися без винагороди, тому ми хотіли б запропонувати вам посаду керівника всіх лікарень. Це почесна робота тому буде і відопівдна зарплата у %d$ . Для вас буде парад, і люди виявлятимуть вам свою вдячність, куди б ви не пішли!//",
    [3] = "Дякуємо за все, що ви зробили. Насолоджуйтесь довгою напівпенсією.//",
    [4] = "",
  },
  [10] = {
    [1] = "Шановний %s//,",
    [2] = "Вітаємо з успішно виконаною роботою в усіх лікарнях, до яких ми вас призначили. Такі видатні результати дають вам право на свободу в усіх містах світу. Вам дають %d$ пенсії, плюс лімузин і все, що ми прошу від вас їздити з міста в місто, зустрічати людей, які вас обожнюють, і рекламувати роботу всіх лікарень усюди.//",
    [3] = "Ми всі пишаємося вами. Серед нас немає нікого, хто б не відчував вдячності за вашу наполегливу працю, рятуючи життя!//",
    [4] = "",
  },
  [11] = {
    [1] = "Шановний %s//,",
    [2] = "Ваша кар’єра була взірцевою, і ви надихаєте всіх нас! Дякуємо, що керували багатьма лікарнями та добре виконуєвали свою роботу. Ми б хотіли присвоїти вам довічну зарплату в розмірі %d$, і можливість їздити у міністерському кабріолеті із міста в місто, щоб читати лекції про те, як ви цього всього досягли.//",
    [3] = "Ви є прикладом для кожної адекватно мислячої людини, усі без винятку у світі вважають вас неперевершеним.//",
    [4] = "",
  },
  [12] = {
    [1] = "Шановний %s//,",
    [2] = "Ваша успішна кар’єра найкращого керівника лікарні з часів Мойсея добігає кінця. Проте ваш вплив на вразливий світ медицини був настільки значним, що Міністерство з радістю пропонує вам зарплату %d$ лише для того, щоб ви виступали як наш представник, відвідувати відкриття свят, спускати на воду кораблі та вести телевізійну розважальну програму. Весь світ кличе вас і це буде гарною рекламою для всіх нас!//",
    [3] = "Будь ласка, прийміть цю посаду. Це не буде важкою роботою, а ми надамо вам автомобіль і поліцейський супровід, куди б ви не пішли.//",
    [4] = "",
  },
  custom_level_completed = "Чудова робота! Ви виконали всі завдання на цьому спец рівні.",
  dear_player = "Шановний %s",
  return_to_main_menu = "Ви хочете повернутися до головного меню чи продовжити гру?",
  campaign_level_missing = "Вибачте, але наступного рівня цієї кампанії, схоже, немає. (Назва: %s)",
  campaign_level_completed = "Гарна робота! Ви пройшли рівень, але ще є чим зайнятись! Ви б хотіли прийняти посаду в лікарні %s?",
  campaign_completed = "Неймовірно! Вам вдалося пройти всі рівні. Тепер ви можете розслабитися і почати прославляти себе на всіх форумах в Інтернеті. Успіхів!"
}

months = {
  [1] = "Січ",
  [2] = "Лют",
  [3] = "Бер",
  [4] = "Кві",
  [5] = "Тра",
  [6] = "Чер",
  [7] = "Лип",
  [8] = "Сер",
  [9] = "Вер",
  [10] = "Жов",
  [11] = "Лис",
  [12] = "Гру",
}
humanoid_name_starts = {
  [1] = "КЛИМ",
  [2] = "ЛУКЯН",
  [3] = "БАКАЛ",
  [4] = "ГАЙДАН",
  [5] = "БАБАЧ",
  [6] = "РЕД",
  [7] = "ТКАЧ",
  [8] = "ЗОЛОЧ",
  [9] = "ТАРАС",
  [10] = "ТКАЧ",
  [11] = "БАБ",
  [12] = "ВЕРЕC",
  [13] = "ДІД",
  [14] = "ФЕДОР",
  [15] = "СКРИП",
  [16] = "ЖДАН",
  [17] = "ФЕДИШ",
  [18] = "НАСТЬОШ",
  [19] = "ВОЛОШ",
  [20] = "ПЕРЕДЕР",
  [21] = "НЕЧ",
  [22] = "БУС",
  [23] = "БАНД",
  [24] = "ГОРЖ",
  [25] = "КОЛОМ",
  [26] = "КУЗЬМ",
  [27] = "КОЛ",
  [28] = "ХОЛ",
  [29] = "СІЧ",
  [30] = "БОЛЮБ",
  [31] = "КАЙД",
  [32] = "ШМИГ",
  [33] = "НЕЩАД",
}
humanoid_name_ends = {
  [1] = "ЕНКО",
  [2] = "ЧУК",
  [3] = "А",
  [4] = "КО",
  [5] = "ЮК",
  [6] = "ИК",
  [7] = "ІВ",
  [8] = "ІЧ",
  [9] = "НИК",
  [10] = "ОК",
  [11] = "ИН",
  [12] = "ІЙ",
  [13] = "ЕРА",
  [14] = "УЙ",
  [15] = "ИЯ",
  [16] = "АШ",
  [17] = "ИМ",
  [18] = "ЮК",
  [19] = "НИК",
  [20] = "ІЙ",
  [21] = "ЕНКО",
  [22] = "ІВ",
  [23] = "ІЧ",
  [24] = "КО",
  [25] = "ИН",
  [26] = "КО",
}
vip_names = {
  [1] = "Мер Великого Житомира",
  [2] = "Валерій Хмельницький",
  [3] = "Сагайдачний, владика Запорізький",
  [4] = "Саша, спонсор демократії",
  [5] = "Міністр ВС Литвиненко",
  [6] = "Пан Ю. Попович",
  [7] = "Радник президента Демченко",
  [8] = "Депутат III скликання Рибачок",
  [9] = "Футболіст А. Шевченко",
  [10] = "Л. Ф. Кучма III",
  health_minister = "Міністр охорони здоров'я",
}

menu_options_volume = {
  [50] = "    50%  ",
  [100] = "    100%  ",
  [30] = "    30%  ",
  [60] = "    60%  ",
  [90] = "    90%  ",
  [10] = "    10%  ",
  [20] = "    20%  ",
  [40] = "    40%  ",
  [80] = "    80%  ",
  [70] = "    70%  ",
}
cheats_window = {
  cheats = {
    end_month = "Закінчити місяць",
    emergency = "Створити Надзвичайну ситуацію",
    win_level = "Виграти рівень",
    create_patient = "Створити Пацієнта",
    money = "Чіт на Гроші",
    lose_level = "Програти рівень",
    all_research = "Чіт на Всі дослідження",
    end_year = "Закінчити Рік",
    earthquake = "Викликати землетрус",
    vip = "Викликати ВІП",
    toggle_infected = "Перемкнути іконки інфікованих",
    decrease_prices = "Знизити ціни",
    epidemic = "Створити заразного пацієнта",
    increase_prices = "Підвищити ціни",
    toggle_earthquake = "Перемкнути землетрус",
    show_infected = "Показати/Скрити іконки інфікованих",
    max_reputation = "Макс. репутація",
    reset_death_count = "Скинути к-ть смертей",
    toggle_epidemic = "Перемкнути епідемії",
  },
  close = "Закрити",
  caption = "Чіти",
  cheated = {
    no = "Використання чітів: Ні",
    yes = "Використання чітів: Так",
  },
  warning = "Увага: Ви не отримаєте додаткових очок в кінці рівня, якщо використовуватимете чіти!",
}
original_credits = {
  [1] = " ",
  [2] = " ",
  [3] = " ",
  [4] = " ",
  [5] = " ",
  [6] = " ",
  [7] = " ",
  [8] = " ",
  [9] = " ",
  [10] = " ",
  [11] = " ",
  [12] = ":Designed and Created by",
  [13] = ":Bullfrog Productions",
  [14] = " ",
  [15] = ":Pluto Development Team",
  [16] = ",",
  [17] = "Mark Webley",
  [18] = "Gary Carr",
  [19] = "Matt Chilton",
  [20] = "Matt Sullivan",
  [21] = "Jo Rider",
  [22] = "Rajan Tande",
  [23] = "Wayne Imlach",
  [24] = "Andy Bass",
  [25] = "Jon Rennie",
  [26] = "Adam Coglan",
  [27] = "Natalie White",
  [28] = " ",
  [29] = " ",
  [30] = " ",
  [31] = ":Programming",
  [32] = ",",
  [33] = "Mark Webley",
  [34] = "Matt Chilton",
  [35] = "Matt Sullivan",
  [36] = "Rajan Tande",
  [37] = " ",
  [38] = " ",
  [39] = " ",
  [40] = ":Art",
  [41] = ",",
  [42] = "Gary Carr",
  [43] = "Jo Rider",
  [44] = "Andy Bass",
  [45] = "Adam Coglan",
  [46] = " ",
  [47] = " ",
  [48] = " ",
  [49] = ":Additional Programming",
  [50] = ",",
  [51] = "Ben Deane",
  [52] = "Gary Morgan",
  [53] = "Jonty Barnes",
  [54] = " ",
  [55] = " ",
  [56] = " ",
  [57] = ":Additional Art",
  [58] = ",",
  [59] = "Eoin Rogan",
  [60] = "George Svarovsky",
  [61] = "Saurev Sarkar",
  [62] = "Jason Brown",
  [63] = "John Kershaw",
  [64] = "Dee Lee",
  [65] = " ",
  [66] = " ",
  [67] = " ",
  [68] = ":Intro Sequence",
  [69] = ",",
  [70] = "Stuart Black",
  [71] = " ",
  [72] = " ",
  [73] = " ",
  [74] = ":Music and Sound Effects",
  [75] = ",",
  [76] = "Russell Shaw",
  [77] = "Adrian Moore",
  [78] = " ",
  [79] = " ",
  [80] = " ",
  [81] = ":Additional Music",
  [82] = ",",
  [83] = "Jeremy Longley",
  [84] = "Andy Wood",
  [85] = " ",
  [86] = " ",
  [87] = " ",
  [88] = ":Announcer Voiceover",
  [89] = ",",
  [90] = "Rebecca Green",
  [91] = " ",
  [92] = " ",
  [93] = " ",
  [94] = ":Level Design",
  [95] = ",",
  [96] = "Wayne Imlach",
  [97] = "Natalie White",
  [98] = "Steven Jarrett",
  [99] = "Shin Kanaoya",
  [100] = " ",
  [101] = " ",
  [102] = " ",
  [103] = ":Scripting",
  [104] = ",",
  [105] = "James Leach",
  [106] = "Sean Masterson",
  [107] = "Neil Cook",
  [108] = " ",
  [109] = " ",
  [110] = " ",
  [111] = ":R&D",
  [112] = " ",
  [113] = ":Graphics Engine",
  [114] = ",",
  [115] = "Andy Cakebread",
  [116] = "Richard Reed",
  [117] = " ",
  [118] = " ",
  [119] = " ",
  [120] = ":R&D Support",
  [121] = ",",
  [122] = "Glenn Corpes",
  [123] = "Martin Bell",
  [124] = "Ian Shaw",
  [125] = "Jan Svarovsky",
  [126] = " ",
  [127] = " ",
  [128] = " ",
  [129] = ":Library and Tools",
  [130] = " ",
  [131] = "Dos and Win 95 Library",
  [132] = ",",
  [133] = "Mark Huntley",
  [134] = "Alex Peters",
  [135] = "Rik Heywood",
  [136] = " ",
  [137] = " ",
  [138] = " ",
  [139] = ":Network Library",
  [140] = ",",
  [141] = "Ian Shippen",
  [142] = "Mark Lamport",
  [143] = " ",
  [144] = " ",
  [145] = " ",
  [146] = ":Sound Library",
  [147] = ",",
  [148] = "Russell Shaw",
  [149] = "Tony Cox",
  [150] = " ",
  [151] = " ",
  [152] = " ",
  [153] = ":Installer Programming",
  [154] = ",",
  [155] = "Andy Nuttall",
  [156] = "Tony Cox",
  [157] = "Andy Cakebread",
  [158] = " ",
  [159] = " ",
  [160] = " ",
  [161] = ":Moral Support",
  [162] = ",",
  [163] = "Peter Molyneux",
  [164] = " ",
  [165] = " ",
  [166] = " ",
  [167] = ":Testing Manager",
  [168] = ",",
  [169] = "Andy Robson",
  [170] = " ",
  [171] = " ",
  [172] = " ",
  [173] = ":Lead Testers",
  [174] = ",",
  [175] = "Wayne Imlach",
  [176] = "Jon Rennie",
  [177] = " ",
  [178] = " ",
  [179] = " ",
  [180] = ":Play Testers",
  [181] = ",",
  [182] = "Jeff Brutus",
  [183] = "Wayne Frost",
  [184] = "Steven Lawrie",
  [185] = "Tristan Paramor",
  [186] = "Nathan Smethurst",
  [187] = " ",
  [188] = "Ryan Corkery",
  [189] = "Simon Doherty",
  [190] = "James Dormer",
  [191] = "Martin Gregory",
  [192] = "Ben Lawley",
  [193] = "Joel Lewis",
  [194] = "David Lowe",
  [195] = "Robert Monczak",
  [196] = "Dominic Mortoza",
  [197] = "Karl O'Keeffe",
  [198] = "Michael Singletary",
  [199] = "Andrew Skipper",
  [200] = "Stuart Stephen",
  [201] = "David Wallington",
  [202] = " ",
  [203] = "And all our other Work Experience Play Testers",
  [204] = " ",
  [205] = " ",
  [206] = " ",
  [207] = ":Technical Support",
  [208] = ",",
  [209] = "Kevin Donkin",
  [210] = "Mike Burnham",
  [211] = "Simon Handby",
  [212] = " ",
  [213] = " ",
  [214] = " ",
  [215] = ":Marketing",
  [216] = ",",
  [217] = "Pete Murphy",
  [218] = "Sean Ratcliffe",
  [219] = " ",
  [220] = " ",
  [221] = " ",
  [222] = ":With thanks to:",
  [223] = ",",
  [224] = "Tamara Burke",
  [225] = "Annabel Roose",
  [226] = "Chris Morgan",
  [227] = "Pete Larsen",
  [228] = " ",
  [229] = " ",
  [230] = " ",
  [231] = ":PR",
  [232] = ",",
  [233] = "Cathy Campos",
  [234] = " ",
  [235] = " ",
  [236] = " ",
  [237] = ":Documentation",
  [238] = ",",
  [239] = "Mark Casey",
  [240] = "Richard Johnston",
  [241] = "James Lenoel",
  [242] = "Jon Rennie",
  [243] = " ",
  [244] = " ",
  [245] = " ",
  [246] = ":Documentation & Packaging Design",
  [247] = ",",
  [248] = "Caroline Arthur",
  [249] = "James Nolan",
  [250] = " ",
  [251] = " ",
  [252] = " ",
  [253] = ":Localisation Project Manager",
  [254] = ",",
  [255] = "Carol Aggett",
  [256] = " ",
  [257] = " ",
  [258] = " ",
  [259] = ":Localisation",
  [260] = ",",
  [261] = "Sandra Picaper",
  [262] = "Sonia 'Sam' Yazmadjian",
  [263] = " ",
  [264] = "Bettina Klos",
  [265] = "Alexa Kortsch",
  [266] = "Bianca Normann",
  [267] = " ",
  [268] = "C.T.O. S.p.A. Zola Predosa (BO)",
  [269] = "Gian Maria Battistini",
  [270] = "Maria Ziino",
  [271] = "Gabriele Vegetti",
  [272] = " ",
  [273] = "Elena Ruiz de Velasco",
  [274] = "Julio Valladares",
  [275] = "Ricardo Mart®ez",
  [276] = " ",
  [277] = "Kia Collin",
  [278] = "CBG Consult",
  [279] = "Ulf Thor",
  [280] = " ",
  [281] = " ",
  [282] = " ",
  [283] = ":Production",
  [284] = ",",
  [285] = "Rachel Holman",
  [286] = " ",
  [287] = " ",
  [288] = " ",
  [289] = ":Producer",
  [290] = ",",
  [291] = "Mark Webley",
  [292] = " ",
  [293] = " ",
  [294] = " ",
  [295] = ":Associate Producer",
  [296] = ",",
  [297] = "Andy Nuttall",
  [298] = " ",
  [299] = " ",
  [300] = " ",
  [301] = ":Operations",
  [302] = ",",
  [303] = "Steve Fitton",
  [304] = " ",
  [305] = " ",
  [306] = " ",
  [307] = ":Company Administration",
  [308] = ",",
  [309] = "Audrey Adams",
  [310] = "Annette Dabb",
  [311] = "Emma Gibbs",
  [312] = "Lucia Gobbo",
  [313] = "Jo Goodwin",
  [314] = "Sian Jones",
  [315] = "Kathy McEntee",
  [316] = "Louise Ratcliffe",
  [317] = " ",
  [318] = " ",
  [319] = " ",
  [320] = ":Company Management",
  [321] = ",",
  [322] = "Les Edgar",
  [323] = "Peter Molyneux",
  [324] = "David Byrne",
  [325] = " ",
  [326] = " ",
  [327] = ":All at Bullfrog Productions",
  [328] = " ",
  [329] = " ",
  [330] = " ",
  [331] = ":Special Thanks to",
  [332] = ",",
  [333] = "Everyone at Frimley Park Hospital",
  [334] = " ",
  [335] = ":Especially",
  [336] = ",",
  [337] = "Beverley Cannell",
  [338] = "Doug Carlisle",
  [339] = " ",
  [340] = " ",
  [341] = " ",
  [342] = ":Keep On Thinking",
  [343] = " ",
  [344] = " ",
  [345] = " ",
  [346] = " ",
  [347] = " ",
  [348] = " ",
  [349] = " ",
  [350] = " ",
  [351] = " ",
  [352] = " ",
  [353] = " ",
  [354] = " ",
  [355] = " ",
  [356] = " ",
  [357] = " ",
  [358] = " ",
  [359] = " ",
  [360] = " ",
  [361] = ".",
}

tooltip = {
  queue_window = {
    end_of_queue = "Перетягніть пацієнта до цієї іконки, щоб відправити його в кінець черги",
    num_entered = "Кількість пацієнтів, що відвідали кабінет",
    close = "Закрити",
    num_in_queue = "Кількість пацієнтів у черзі",
    num_expected = "Кількість пацієнтів, які скоро приєднаються до черги",
    front_of_queue = "Перетягніть пацієнта до цієї іконки, щоб відправити його на початок черги",
    dec_queue_size = "Зменшити максимальний розмір черги",
    max_queue_size = "Максимальний розмір черги рецепції",
    inc_queue_size = "Збільшити максимальний розмір черги",
    patient = "Перетягніть пацієнта, щоб перемістити його у черзі. Клацніть правою кнопкою миші на пацієнті, щоб відправити його додому або направити до конкуруючої лікарні",
    patient_dropdown = {
      send_home = "Відправити пацієнта додому",
      hospital_2 = "Направити пацієнта до іншої лікарні",
      reception = "Відправити на рецепцію",
      hospital_1 = "Відправити пацієнта лікуватись деінде",
      hospital_3 = "Віддати пацієнта до лап конкурентів",
    },
  },
  jukebox = {
    rewind = "Попередня доріжка",
    loop = "Повторювати поточну доріжку",
    stop = "Зупинити",
    close = "Закрити програвач",
    current_title = "Поточна доріжка",
    play = "Грати",
    fast_forward = "Наступна доріжка",
  },
  graphs = {
    deaths = "Відобразити/Приховати померлих",
    close = "Закрити вікно",
    scale = "Масштаб графіку",
    money_out = "Відобразити/Приховати витрати",
    visitors = "Відобразити/Приховати відвідувачів",
    wages = "Відобразити/Приховати зарплати",
    balance = "Відобразити/Приховати баланс",
    money_in = "Відобразити/Приховати дохід",
    cures = "Відобразити/Приховати вилікуваних",
    reputation = "Відобразити/Приховати репутацію",
  },
  message = {
    button = "Клікніть, щоб відкрити повідомлення",
    button_dismiss = "Клікніть лівою клавішою миші, щоб переглянути повідомлення, правою - щоб його відхилити",
  },
  pay_rise_window = {
    accept = "Підвищити зарплату",
    decline = "Відмовити у підвищенні зарплати",
  },
  cheats_window = {
    close = "Закрити вікно з чітами",
    cheats = {
      end_month = "Пропускає цілий місяць.",
      emergency = "Створює надзвичайну ситуацію.",
      win_level = "Виграє рівень.",
      create_patient = "Створює нового відвідувача.",
      money = "Додає 10.000 на ваш баланс.",
      lose_level = "Програти рівень.",
      all_research = "Відкриває всі досідження.",
      end_year = "Пропускає цілий рік!",
      toggle_infected = "Відобразити/Приховати іконки інфікованих для активної, виявленої епідемії",
      decrease_prices = "Зменшити всі ціни на 50% (мін. 50%)",
      epidemic = "Створює інфікованого пацієнта, котрий може викликати епідемію",
      increase_prices = "Збільшити всі ціни на 50% (макс. 200%)",
      earthquake = "Викликати землетрус.",
      vip = "Запросити ВІП.",
      toggle_earthquake = "Перемкнути стан землетрусу",
      show_infected = "Відобразити/Приховати іконки інфікованих для активної, виявленої епідемії",
      max_reputation = "Зробити репутацію лікарні максимальною",
      reset_death_count = "Скинути кількість смертей до нуля",
      toggle_epidemic = "Перемкнути, чи можливі епідемії",
    },
  },
  menu_list_window = {
    back = "Закрити вікно",
    save_date = "Змінювалось",
    name = "Ім'я",
  },
  watch = {
    emergency = "Надзвичайна ситуація: час, що залишився на лікування термінових пацієнтів.",
    hospital_opening = "Час на будування: коли час закінчиться - лікарня відкриється. Якщо ви хочете відкрити лікарню зараз, натисніть на зелену кнопку.",
    epidemic = "Епідемія: час відведений на зупинку епідемії. Коли час закінчиться або інфікований пацієнт покине лікарню, приїде інспектор. Кнопка включає/відключає режим вакцинації. Клікніть на пацієнта і медсестра вакцинує його.",
  },
  calls_dispatcher = {
    assigned = "Це поле позначено, коли комусь призначено завдання.",
    task = "Список завдань - клацніть завдання, щоб відкрити вікно призначеного працівника та перейти до завдання",
    close = "Закрити вікно диспетчера",
  },
  information = {
    close = "Закрити вікно інформації",
  },
  lua_console = {
    textbox = "Введіть тут Lua код для запуску",
    execute_code = "Запустити введенний Вами код",
    close = "Закрити консоль",
  },
  staff_window = {
    doctor_seniority = "Ступінь (Інтерн, Лікар, Спеціаліст)",
    psychiatrist = "Психіатр",
    close = "Закрити вікно",
    ability = "Здібності",
    pick_up = "Підняти",
    sack = "Звільнити",
    surgeon = "Хірург",
    happiness = "Задовільність",
    salary = "Щомісячна зарплатня",
    name = "Ім'я",
    tiredness = "Втома",
    center_view = "Ліва клавіша - центрувати екран, права - вибрати наступного працівника",
    skills = "Додаткові навички",
    researcher = "Дослідник",
    face = "Фото працівника - натисніть, щоб перейти до екрану керування працівниками",
  },
  research = {
    cure_inc = "Підвищити пріоритет дослідження нових захворювань",
    close = "Закрити вікно досліджень",
    specialisation_dec = "Знизити пріоритет спеціальних досліджень",
    diagnosis_dec = "Знизити пріоритет досліджень діагностичного обладнання",
    allocated_amount = "Виділені ресурси",
    improvements_inc = "Підвищити пріоритет дослідження покращень",
    drugs_dec = "Знизити пріоритет дослідження ліків",
    drugs_inc = "Підвищити пріоритет дослідження ліків",
    cure_dec = "Знизити пріоритет дослідження нових захворювань",
    specialisation_inc = "Підвищити пріоритет спеціальних досліджень",
    improvements_dec = "Знизити пріоритет дослідження покращень",
    diagnosis_inc = "Підвищити пріоритет досліджень діагностичного обладнання",
  },
  statement = {
    close = "Закрити вікно балансу",
  },
  buy_objects_window = {
    confirm = "Купити предмет(и)",
    cancel = "Відмінити",
    increase = "Купити на один предмет більше",
    total_value = "Загальна сума",
    price = "Вартість предмета",
    decrease = "Купити на один предмет меньше",
  },
  fax = {
    close = "Закрити вікно, не видаляючи повідомлення",
  },
  window_general = {
    confirm = "Підтвердити",
    cancel = "Відмінити",
  },
}

totd_window = {
  previous = "Попередня підказка",
  tips = {
    [1] = "Кожна лікарня, для базового функціонування, потребує Рецепції та Кабінету терапевта. Коли вони є, все залежить від того, які пацієнти відвідують вашу лікарню. Але Фармакологічний кабінет завжди є хорошим вибором.",
    [2] = "Такі апарати, як наприклад Надувач, потребують технічного обслуговування. Наймайте Різноробочих для їх ремонту, інакше ви ризикуєте травмувати пацієнтів і свій персонал.",
    [3] = "Через деякий час кропітливої роботи ваші співробітники втомляться. Обов’язково побудуйте для них Кімнату відпочинку.",
    [4] = "Розміщуйте достатньо радіаторів, щоб зігріти ваших пацієнтів і персонал, інакше вони не будуть раді, що прийшли до вас. Використовуйте Мапу містечка, щоб визначити місця у вашій лікарні, які недостатньо опалюються.",
    [5] = "Рівень здібностей лікаря значною мірою впливає на якість і швидкість діагностики його пацієнта. Поставте у свій кабінет досвідченого лікаря, і вам не знадобиться стільки додаткових діагностичних кабінетів.",
    [6] = "Інтерни та Лікарі можуть покращити свої навички, навчаючись у Спеціаліста у Лекційній. Якщо спеціаліст має додаткову навичку (хірург, психіатр або дослідник), він також передаватиме ці знання своїм студентам.",
    [7] = "Ви пробували ввести європейський номер служби екстреної допомоги (112) у факс? Перед цим, не забудьте увімкнути звук!",
    [8] = "Певні налаштування, такі як роздільна здатність екрана та мова, можна змінити у вікні налаштувань, яке можна знайти як у головному меню, так і під час грі.",
    [9] = "Ви вибрали мову, відмінну від англійської, але скрізь є англійський текст? Допоможіть нам перекласти відсутні строки вашою мовою!",
    [10] = "Команда CorsixTH шукає помічників! Ви зацікавлені в програмуванні, перекладі або створенні графіки для CorsixTH? Зв’яжіться з нами на нашому Discord або відвідайте наш веб-сайт (CorsixTH.com)",
    [11] = "Якщо ви знайшли помилку, будь ласка, повідомте про це у наш багтрекер: th-issues.corsix.org",
    [12] = "Кожний рівень має певні цілі, які ви повинні виконати, перш ніж перейти до наступного. Перейдіть у вікно статусу, щоб побачити свій прогрес у виконанні цілей цього рівня.",
    [13] = "Якщо ви хочете відредагувати або видалити наявну кімнату, ви можете зробити це за допомогою кнопки Змінити кімнату внизу панелі інструментів.",
    [14] = "У натовпі пацієнтів, які очікують, ви можете швидко знайти тих, хто очікує на певну кімнату, навівши курсор на двері цієї кімнати.",
    [15] = "Натисніть на двері кімнати, щоб побачити її чергу. Тут ви можете внести незначні зміни, наприклад змінити порядок черги або відправити пацієнта в іншу кімнату.",
    [16] = "Незадоволені працівники частіше вимагатимуть підвищення. Переконайтеся, що ваші співробітники працюють у комфортних умовах, щоб запобігти цьому.",
    [17] = "Пацієнти будуть відчувати спрагу, поки вони чекатимуть у вашій лікарні, і якщо ви підвищите температуру, вона буде ще більше! Розмістіть Автомат з напоями у стратегічних місцях для додаткового прибутку.",
    [18] = "Ви можете передчасно завершити процес обстеження і вгадати лікування, якщо ви вже стикалися з хворобою. Але майте на увазі, що це може збільшити ризик неправильного лікування, яке спричинить смерть пацієнта.",
    [19] = "Надзвичайні ситуації можуть бути гарним джерелом додаткового доходу, якщо у вас є достатньо можливостей для своєчасної допомоги невідкладним пацієнтам.",
    [20] = "Чи знали ви, що можна призначити Різноробочим чим саме їм займатись? Просто натискайте на одну із задач у їх профілі щоб задати пріоритет!"
  },
  next = "Наступна підказка",
}
trophy_room = {
  reputation = "РЕПУТАЦІЯ",
  gen_repairs = {
    penalty = {
      [1] = "Ваші різноробочі не дуже добре обслуговувують ваші апарати. Вам слід ретельніше наглядати за ними або найняти їх більше, щоб вони могли впоратися з обсягом роботи.",
      [2] = "Технічне обслуговування - це жах. Ваші працівники повинні піклуватися про апарати, як про свої власні.",
    },
    awards = {
      [1] = "Ви отримали особливу нагороду за спритність ваших різноробочих, які підтримують ваші апарати в хорошому стані. Чудово. Ви можете дати їм відпустку.",
      [2] = "Ваші різноробочі працювали краще, ніж працівники інших лікарень. Це величезне досягнення, за яке вас слід привітати.",
      [3] = "Ваші апарати добре обслуговуються. Відданість ваших різноробочих виняткова. Ви всі заслуговуєте на цю престижну нагороду. Неперевершено.",
    },
  },
  pop_percentage = {
    awards = {
      [1] = "Зверніть увагу, що минулого року у вашій лікарні була доволі висока частка жителів міста. Вітаю.",
      [2] = "Вітаємо. Ваша лікарня приймає більшу частку місцевого населення, ніж будь-яка інша.",
      [3] = "Дивовижно. Ви залучили до вашої лікарні більше пацієнтів, ніж всі лікарні разом узяті.",
    },
    penalty = {
      [1] = "Минулого року зовсім невелика частка жителів відвідала вашу лікарню. Щоб заробляти гроші вам потрібно залучити більше платоспроможних хворих.",
      [2] = "У будь-яку лікарню в цій місцині ходить більше людей, ніж до вас. Сором вам, сором.",
    },
  },
  happy_vips = {
    trophies = {
      [1] = "Клуб відомих людей хоче вручити вам кубок Популярності за приділену увагу всім VIP-персонам, що відвідали вас минулого року. Тепер ви можете вважати себе більш відомим.",
      [2] = "Клуб відомих людей хоче вручити вам кубок Знаменитості за те, що ви радуєте відвідувачів вашого закладу. Вважайте себе відомим і майже одним із нас.",
      [3] = "Вітаємо з отриманням ВІП Путівки за полегшення життя звичайних працівників в очах громадськості, задовольняючи тих, хто відвідав вашу лікарню. Це чудово.",
    },
  },
  happy_patients = {
    awards = {
      [1] = "Ви можете пишатися тим, що минулого року люди були дуже щасливі у вашій лікарні.",
      [2] = "Люди, які відвідували вашу лікарню, були в задоволеними обслуговуванням більше, ніж у будь-якій іншій лікарні в грі.",
    },
    penalty = {
      [1] = "Люди, які приходять до лікарні, переживають просто жахливий досвід. Якщо ви хочете заслужити повагу Міністерства, вам доведеться постаратися набагато більше.",
      [2] = "Люди, які проходять лікування у вашій лікарні, дуже незадоволені її станом. Ви повинні приділяти більше уваги благоустрою пацієнтів.",
    },
  },
  rats_killed = {
    awards = {
    },
    trophies = {
      [1] = "Вас було нагороджено Кубком винищувача шкідників за відстріл %d пацюків у вашій лікарні протягом минулого року.",
      [2] = "Вашими винятковими навичками стрільби по щурах ви вибороли цей трофей від Федерації боротьби з щурами та мишами, убивши %d гризунів.",
      [3] = "Ви пройшли кваліфікацію на Кубок Rat Sniper Cup за виняткову майстерність у позбавленні своєї лікарні від %d пацюків за минулий рік.",
    },
  },
  happy_staff = {
    awards = {
      [1] = "Ваші співробітники присудили Вам цю нагороду. Вони кажуть, що хоча є можливості для покращень, ваше ставлення до них досить хороше.",
      [2] = "Вашим співробітникам так подобається працювати на вас, що вони не можуть перестати посміхатися. Ви чудовий керівник.",
    },
    trophies = {
      [1] = "Ви отримуєте Кубок сміху за те, що підтримуєте настрій своїх працівників, що вони не можуть припинити посміхатись.",
      [2] = "Інститут радості вдячний вам за відсутність незадоволених працівників у вашій лікарні минулого року, і нагороджує вас цим кубком.",
      [3] = "Ця нагорода, «Кубок «Більше посмішок», вручається вам за те, що протягом минулого року ваші співробітники залишалися щасливими виконуючи свої обов’язки. Посмішки всюди!",
    },
    regional_bad = {
      [1] = "Минулого року всі ваші працівники були дуже незадоволені. Ви повинні були це помітити. А от у всіх інших лікарнях працюють щасливіші працівники.",
    },
    regional_good = {
      [1] = "Ваші працівники щасливіші, ніж в інших лікарнях. Задоволені працівники приносять більше прибутку і менше смертей. Міністерство задоволене цим.",
    },
    penalty = {
      [1] = "Ваші співробітники хочуть, щоб ви їх помітили, вони дуже нещасні. Щасливі співробітники - це цінність. Зробіть їх щасливішими або в один момент можете тратити їх.",
    },
  },
  rats_accuracy = {
    awards = {
    },
    trophies = {
      [1] = "Ви отримуєте приз «Кубок «Пацючий снайпер» за %d%% точність під час стрільби по пацюкам.",
      [2] = "Цей кубок вшановує вашу неймовірну точність у винищенні %d%% пацюків, і яких ви поцілили у своїй лікарні минулого року.",
      [3] = "Щоб відсвяткувати подію, коли ви вбили %d%% усіх пацюків у вашій лікарні, ви отримуєте «Кубок «Винищувач ніркових пацюків». Вітаємо!",
    },
  },
  all_cured = {
    awards = {
      [1] = "Вітаємо з отриманням нагороди Марії Кюрі за успішне лікування всіх пацієнтів у вашій лікарні за минулий рік.",
    },
    trophies = {
      [1] = "Міжнародний фонд зцілення бажає визнати той факт, що ви зцілили всіх протягом останнього року, нагородивши вас «Кубком «Неймовірні зцілення».",
      [2] = "Вас було нагороджено «Кубком «Поціновувач здорових дупок» за успішне лікування всіх пацієнтів у вашій лікарні минулого року.",
    },
  },
  no_deaths = {
    awards = {
      [1] = "Ви отримали нагороду «Жодносмертя» за збереження життя 100 відсотків пацієнтів за останній рік.",
      [2] = "Ми даруємо вам цю нагороду на згадку про низьку кількість смертей у вашій лікарні цього року. Це неможе не радувати.",
    },
    trophies = {
      [1] = "Комітет «Життя продовжується!» нагороджує вас цим кубком за запобігання смертей за останній рік.",
      [2] = "Вас було нагороджено кубком «Залишитися в живих» за те, що ви уникли всіх можливих смертей у вашій лікарні минулого року. Чудово.",
      [3] = "Ви нагороджені кубком «Життя» за те, що взагалі не було смертей у вашій лікарні минулого року. Неймовірно!",
    },
    penalty = {
       [1] = "Кількість смертей у вашій лікарні минулого року була неприйнятно висока. Приділіть більше уваги своїй роботі. У майбутньому переконайтеся, що виживає більше людей.",
       [2] = "У вашій лікарні пацієнти ризикують більше втратити своє здоров'я, ніж вилікуватися. Від вас очікується, що ви зцілите багато людей, а не вбиватимете їх.",
    },
    regional = {
      [1] = "Кількість смертей у вашій лікарні минулого року була нижчою, ніж в інших лікарнях. Будь ласка, прийміть цю нагороду.",
    },
  },
  many_cured = {
    awards = {
      [1] = "Вітаємо з одужанням багатьох пацієнтів за минулий рік. Завдяки вашій роботі багато людей почуваються добре.",
      [2] = "Будь ласка, прийміть цю нагороду за лікування більшої кількості пацієнтів, ніж будь-яка інша лікарня. Справжнє досягнення.",
    },
    trophies = {
      [1] = "Міжнародний фонд одужання бажає визнати той факт, що ви вилікували величезну кількість людей у ​​вашій лікарні минулого року, нагородивши вас кубком «Багацько здоровецьких».",
      [2] = "Вас було нагороджено кубком «Капітан оздоровлення» за успішне лікування високого відсотка пацієнтів у вашій лікарні минулого року.",
      [3] = "Вітаємо з отриманням нагороди Марії Кюрі за успішне лікування майже всіх пацієнтів вашої лікарні минулого року",
    },
    penalty = {
      [1] = "Ваша лікарня не може забезпечити ефективне лікування пацієнтів, які його потребують. Зосередьтеся на своїх методах лікування, щоб зробити їх ефективнішими.",
      [2] = "Ваша лікарня менш ефективна в лікуванні пацієнтів, ніж будь-яка інша. Ви підвели Міністерство і ви підвели себе. Це все, що ми хотіли сказати.",
    },
    regional = {
       [1] = "Ми урочисто вручаємо вам нагороду «Всемогутня медицина» за те, що ви вилікували більше людей, ніж усі інші лікарні разом узяті.",
    },
  },
  curesvdeaths = {
    awards = {
      [1] = "Щирі вітання з досягненням дивовижного співвідношення вилікуваних до померлих у вашій лікарні минулого року.",
    },
    penalty = {
      [1] = "Ваше співвідношення одужаних до померлих дуже погане. Ви повинні переконатися, що ви виліковуєте набагато більше людей, ніж доводите їх до смерті. Не нервуйте нас.",
    },
  },
  emergencies = {
    award = {
      [1] = "Вітаємо: ваше ефективне та дієве вирішення надзвичайних ситуацій принесло вам цю особливу нагороду. Молодці!",
      [2] = "Ваше вийняткові дії під час надзвичайних ситуацій - неймовірні. Ця нагорода присуджена за те, що ви найкраще справляєтеся з великим потоком хворих і страждаючих.",
    },
    regional_good = {
      [1] = "Міністерство визнає, що минулого року ваша лікарня впоралася з надзвичайними ситуаціями краще, ніж будь-яка інша лікарня, і присуджує вам цю нагороду.",
    },
    penalty = {
      [1] = "Ви погано справляєтеся з надзвичайними ситуаціями. Пацієнти невідкладної допомоги потребують швидкої та належної уваги, яку ви не надали.",
    },
    regional_bad = {
      [1] = "Ваша лікарня є найгіршою в регіоні, що відгукаються на надзвичайні ситуації. Саме Ви винні в тому, що опинилися в кінці місцевої ліги невідкладної допомоги.",
    },
  },
  high_rep = {
    awards = {
      [1] = "Чудово. Ви отримуєте невелику нагороду за досягнення дуже поважної репутації за останній рік.",
      [2] = "Чудово! Ваша лікарня отримала нагороду за найкращу репутацію за останній рік.",
    },
    penalty = {
      [1] = "Ви будете покарані за створення дуже поганої репутації лікарні в минулому році. Вам краще переконатися, що вона покращиться в майбутньому.",
      [2] = "Репутація вашої лікарні найгірша в регіоні. Яка ганьба! Покращіть її або доведеться шукати іншу роботу!",
    },
    regional = {
      [1] = "Будь ласка, прийміть нагороду Bullfrog за найвищу репутацію з усіх лікарень цього року. Насолоджуйтесь - ви цього заслуговуєте.",
      [2] = "Цього року репутація вашої лікарні перевершила репутацію всіх інших лікарні разом узяті. Це значне досягнення.",
    }
  },
  consistant_rep = {
    trophies = {
      [1] = "Прямо зараз ви отримуєте нагороду Кабінету міністрів за досконалі стандарти та найвищу можливу репутацію цього року! Оплески для вас!",
      [2] = "Вітаємо з отриманням нагороди «Кришталева лілія» для лікарні з найкращою репутацією за минулий рік. Зайве говорити, що ви на це заслуговуєте.",
    },
  },
  sold_drinks = {
    awards = {
    },
    trophies = {
      [1] = "Всесвітня стоматологічна асоціація з гордістю відзначає вас цією нагородою та табличкою за продаж великої кількості газованих напоїв у вашій лікарні.",
      [2] = "Ваша лікарня була нагороджена «Кубком підтримки бізнесу з продажів безалкогольних напоїв» на знак визнання вражаючої кількості проданих напоїві за минулий рік.",
      [3] = "Від імені стомат кабінету «32 пломби» ви нагороджені цією чашкою в шоколаді, щоб відзначити надзвичайну кількість безалкогольних напоїв, проданих у вашій лікарні цього року.",
    },
  },
  wait_times = {
    award = {
      [1] = "Вітаємо! У вашій лікарні немає довгих черг. Це важлива нагорода.",
    },
    penalty = {
      [1] = "Людям у вашій лікарні доводиться чекати занадто довго. Черги тут довші, ніж у магазинах з акціями. Якби ви старалися більше, ваших пацієнтів можна було б лікувати ефективніше.",
    },
  },
  healthy_plants = {
    awards = {
      [1] = "Вітаємо з отриманням нагороди «Збагачена земля» за належний долгял та збереження ваших рослин протягом минулого року.",
    },
    trophies = {
      [1] = "Друзі кімнатних рослин хочуть нагородити вас «Зеленою чашкою здоров’я» за те, що ви підтримували всі ваші квіти в хорошому стані протягом останніх дванадцяти місяців.",
      [2] = "Спільнота захисників довкілля хоче нагородити вас кубком «Зелена долонька» за те, що ви підтримували ваші рослини в лікарні в найкращому стані протягом минулого року.",
    },
  },
  cleanliness = {
    regional_good = {
      [1] = "Ваша лікарня була визнана однією з найчистіших у всьому світі. Ваші різноробочі заслуговують на підвищення. Ви також заслуговуєте на їх повагу.",
    },
    award = {
      [1] = "Інспектори відзначили, що ваша лікарня дуже чиста. Чисті лікарні — безпечні лікарні. Так тримати.",
    },
    regional_bad = {
      [1] = "Ваша лікарня найбрудніша в районі. Іншим керівникам вдалося зберегти свої коридори чистішими. Ви ганьба для медичної професії.",
    },
  },
  hosp_value = {
    awards = {
      [1] = "Міністерство охорони здоров'я хотіло б скористатися цією можливістю, щоб привітати вас із вражаючою загальною вартістю вашої лікарні.",
    },
    penalty = {
      [1] = "Ваша лікарня не досягла гідної вартості. Ви прийняли неправильні рішення щодо розтрати грошей. Пам'ятайте, що хороша лікарня також є дорогою лікарнею.",
    },
    regional = {
      [1] = "Ви фінансовий вундеркінд. Ваша лікарня коштує більше, ніж усі інші лікарні в регіоні разом узяті.",
    },
  },
  best_value_hosp = {
    regional = {
      [1] = "Вітаємо з найціннішою лікарнею в грі. Гарна робота. Будь ласка, намагайтеся і далі підтримувати цю планку.",
    },
    penalty = {
      [1] = "Кожна лікарня в цьому районі коштує більше, ніж ваша. Виправте цю ганебну ситуацію. Вкладіть більше грошей у лікарню!",
    },
    trophies = {
      [1] = "Вітаємо з отриманням нагороди «Золота скриня» для лікарні, яка отримала найвищу цінність за минулий рік. Це, безсумнівно, заслужено.",
    },
  },
  research = {
    regional_good = {
      [1] = "Дослідження вашої лікарні відповідають новітнім знанням. Ваші дослідники заслуговують цієї нагороди. Чудово!",
    },
    regional_bad = {
      [1] = "У всіх найближчих лікарнях є кращі дослідження, але не у вас. Міністерство засмучено, оскільки дослідження повинні мати найвищий пріоритет у вашій лікарні.",
    },
    penalty = {
      [1] = "Ви відстали в дослідженні нових методів лікування, обладнання та ліків. Це дуже погано, тому що технологічний прогрес є важливим.",
    },
    awards = {
      [1] = "Дослідження вашої лікарні відповідають новітнім знанням. Ваші дослідники заслужили цю нагороду.",
      [2] = "За минулий рік ви дослідили більше ліків і апаратів, ніж будь-хто міг сподіватися. Будь ласка, прийміть цю нагороду від усіх нас у Міністерстві.",
    },
  },
  cash = "ГРОШІ",
}
drug_companies = {
  [1] = "Марія-Фарм",
  [2] = "Славія 2000",
  [3] = "ПАТ Вітаміни",
  [4] = "ТОВ НВФ Мікрохім",
  [5] = "ТОВ Натур",
}
insurance_companies = {
  [1] = "КНЯЖА",
  [2] = "ДЕРЖСТРАХУВАННЯ",
  [3] = "АРХ СТРАХУВАННЯ",
  [4] = "ВУСА",
  [5] = "ЮНІВЕРСАЛ",
  [6] = "АРСЕНАЛ",
  [7] = "АЛЬЯНС УЛЬТА",
  [8] = "БОРАНТА",
  [9] = "ТАК Страхування",
  [10] = "ЮНІКА",
  [11] = "МАКССТРАХ",
  out_of_business = "ПОЗА БІЗНЕСОМ",
}
competitor_names = {
  [1] = "ПРОФІТ",
  [2] = "МАРВІН",
  [3] = "ДРАКУЛА",
  [4] = "ЛУГОВИНА",
  [5] = "ТОНУС",
  [6] = "ЛІЩИНА",
  [7] = "ДЗЕН",
  [8] = "САЛІВАН",
  [9] = "АКУРА",
  [10] = "ПУЛЬТМАН",
  [11] = "ЧАРЛІ",
  [12] = "ШЕДОУ",
  [13] = "ГОРГОНА",
  [14] = "ОЛАФ",
  [15] = "КАЛИНА",
  [16] = "НОРМАЛ",
  [17] = "ВІНСЕНТ",
  [18] = "МОЗЕС",
  [19] = "СКАТ",
  [20] = "ГОРА",
  [21] = "МАРКСВЕЛ",
  [22] = "ДАНІЄЛЬ",
  [23] = "ОЛИВА",
  [24] = "НІК",
}
level_names = {
[1] = "Хімісто",
[2] = "Сонна Лощина",
[3] = "Великомістя",
[4] = "Свобода-бережна",
[5] = "Звичайнецьк",
[6] = "Затх-на-Донцю",
[7] = "Зеленопіль",
[8] = "Мужчинкокрай",
[9] = "Східнецьк",
[10] = "Яйцевина",
[11] = "Каркарине",
[12] = "Дупцекрай",
[13] = "Чумнокрай",
[14] = "Нечеканськ",
[15] = "Цвинтарськ",
}
graphs = {
  deaths = "Померло",
  money_in = "Дохід",
  money_out = "Витрати",
  visitors = "Відвідувачі",
  wages = "Зарплата",
  balance = "Баланс",
  time_spans = {
    [1] = "1 рік",
    [2] = "12 років",
    [3] = "48 років",
  },
  cures = "Вилікувано",
  reputation = "Репутація",
}
newspaper = {
  [1] = {
    [1] = "ШОКУЮЧИЙ ЛІКАРНЯНИЙ ЖАХ",
    [2] = "ДИВАКУВАТИЙ ТЕРАПЕВТ ДУМАЄ ЩО ВІН БОГ",
    [3] = "НІБИ З ФІЛЬМУ ПИЛА",
    [4] = "ЩО БУЛО НА ЛАБОРАТОРНОМУ СТОЛІ?",
    [5] = "РЕЙД ЗУПИНИВ РИЗИКОВАНІ ДОСЛІДИ",
  },
  [2] = {
    [1] = "ЛІКАР З ПОХМІЛЛЯМ",
    [2] = "П'ЯНИЙ ХІРУРГ",
    [3] = "СПЕЦІАЛІСТ-ДУШОГУБ",
    [4] = "НАРКО-ХІРУРГІЯ",
    [5] = "ХІРУРГ ПІД АНЕСТЕЗІЄЮ",
    [6] = "ПЕРЕГАР ВСЮДИ",
  },
  [3] = {
    [1] = "ЖАДІБНИЙ ХІРУРГ",
    [2] = "ШИРОКІ КАРМАНИ ЛІКАРІВ",
    [3] = "ЛІКАР НЕ ВПОРАВСЯ",
    [4] = "ХІРУРГУ ВСЕ МАЛО",
  },
  [4] = {
    [1] = "ЛІКАР ПІДКОРЕГОВУЄ ЦИФРИ",
    [2] = "ОРГАНІЗОВАНИЙ ЗЛОЧИН",
    [3] = "ОПЕРАЦІЇ З ПЕРЕКАЗАМИ",
    [4] = "КОШТАМИ ЙДУТЬ ЧЕРЕЗ ЛІКАРЯ",
  },
  [5] = {
    [1] = "ОЗДОРОВЧЕ ВСКРИТТЯ МОГИЛ",
    [2] = "ЛІКАР СПОРОЖНЯЄ МОГИЛИ",
    [3] = "СПІЙМАНИЙ З ТРУПОМ",
    [4] = "ДЕНЬ ВИКРИТТЯ СМЕРТІ ДОКТОРА",
    [5] = "ФАТАЛЬНА НЕДБАЛІСТЬ",
    [6] = "РОЗКОПКИ МОГИЛЬНИКА ЗАВЕРШЕНІ",
  },
  [6] = {
    [1] = "ЛІКАРСЬКА ТАЄМНА ЗМОВА!",
    [2] = "НЕУВАЖНА МЕДСЕСТРА",
    [3] = "ДІАГНОЗ НАВМАННЯ",
    [4] = "НЕСПЕЦІАЛЬНИЙ СПЕЦІАЛІСТ",
  },
  [7] = {
    [1] = "ПСИХІАТР ГАНЯЄ СОБАК",
    [2] = "ХІРУРГ ОПЕРУЄ САМ СЕБЕ",
    [3] = "МАСТУРБАЦІЯ НА РЕЦЕПЦІЇ",
    [4] = "МЕДСЕСТРА - ЗІРКА СКАНДАЛУ",
    [5] = "В КАБІНЕТІ ЛІКАРЯ БОРДЕЛЬ",
  },
}

debug_patient_window = {
  caption = "Тестовий пацієнт",
}
menu_debug = {
  allow_blocking_off_areas = "  ДОЗВОЛИТИ БЛОКУВАННЯ ОБЛАСТЕЙ  ",
  connect_debugger = "  (%1%) З'ЄДНАННЯ З LUA DBGp СЕРВЕРОМ  ",
  debug_script = "  (%1%) ЗАПУСК ДЕБАГУ СКРИПТА  ",
  transparent_walls = "  (%1%) ПРОЗОРІ СТІНИ  ",
  make_debug_fax = "  СТВОРИТИ ТЕСТОВИЙ ФАКС  ",
  display_pager = "  DISPLAY PAGER        ",
  cheats = "  (%1%) ЧІТИ  ",
  remove_objects = "  ВИДАЛИТИ ОБ'ЄКТИ       ",
  remove_walls = "  ВИДАЛИТИ СТІНИ         ",
  sprite_viewer = "  ПЕРЕГЛЯД СПРАЙТІВ  ",
  map_overlay = "  ОВЕРЛЕЙ  ",
  disable_salary_raise = "  ВИМКНУТИ ПІДНЯТТЯ ЗАРПЛАТИ  ",
  limit_camera = "  ОБМЕЖЕННЯ КАМЕРИ  ",
  calls_dispatcher = "  СПИСОК СПРАВ РІЗНОРОБОЧИХ ",
  jump_to_level = "  ПЕРЕЙТИ НА РІВЕНЬ  ",
  dump_gamelog = "  (%1%) СТВОРИТИ ДАМП   ",
  dump_strings = "  (%1%) СТВОРИТИ ДАМП СТРОК  ",
  win_game_anim = "  АНІМАЦІЯ ПЕРЕМОГИ        ",
  make_debug_patient = "  СТВОРИТИ ТЕСТОВОГО ПАЦІЄНТА  ",
  lua_console = "  (%1%) КОНСОЛЬ LUA  "
}
lua_console = {
  execute_code = "Виконати",
  close = "Закрити",
}
calls_dispatcher = {
  repair = "Відремонтувати %s",
  summary = "%d виклик; %d призначено",
  close = "Закрити",
  watering = "Полити @ %d,%d",
  staff = "%s - %s",
}
information = {
  level_lost = {
    [1] = "Ця тактика не зовсім спрацювала. Удачі наступного разу!",
    [2] = "Причина програшу:",
    reputation = "Ваша репутація кудись випарилась, впала нижче %d.",
    balance = "Ваш баланс впав нижче мінімального, зокрема нижче %d.",
    percentage_killed = "Ми лікарня, а не бійня. Ви вбили понад %d відсотків пацієнтів.",
    cheat = "Це те, що ти хотів, чи, може, ти вибрав не ту кнопку? Ти навіть не вмієш обманювати? Сміх та й годі.",
  },
  cannot_restart = "На жаль, ця гра була збережена до того, як була реалізована функція перезапуску.",
  custom_game = "Ласкаво просимо до CorsixTH. Насолоджуйтесь цією користувацькою мапою!",
  very_old_save = "Вийшло багато оновлень з моменту останнього запуску цього рівня. Щоб переконатися, що всі функції працюють належним чином, почніть цей рівень наново.",
  cheat_not_possible = "Ви не можете використовувати цей чит на цьому рівні. Ви навіть більше не можете чітерити, таке собі життя, га?",
  no_custom_game_in_demo = "Нам дуже шкода, але ви не можете грати користувацькі мапи у демонстраційній версії.",
}
map_editor_window = {
  pages = {
    heliport_2 = "Гелік. майданчик 2",
    pond = "Ставок",
    foliage = "Рослинність",
    road = "Дорога",
    heliport_4 = "Гелік. майданчик 4",
    heliport_1 = "Гелік. майданчик 1",
    delete_wall = "Видалення стін",
    west_wall = "Західні стіни",
    heliport_3 = "Гелік. майданчик 3",
    inside = "Підлога",
    helipad = "Гелік. майданчик",
    camera_2 = "Камера 2",
    camera_1 = "Камера 1",
    hedgerow = "Огорожа",
    outside = "Стежки",
    camera_3 = "Камера 3",
    paste = "Розмістити об'єкти",
    camera_4 = "Камера 4",
    north_wall = "Північні стіни",
    parcel = "Ділянка %d",
    set_parcel = "Задати номер ділянки",
    set_parcel_tooltip = "Виберіть номер і натисніть Еnter.",
  },
  checks = {
    spawn_points_and_path = "Попередження: Пацієнти не можуть потрапити у лікарню. Їм потрібні 'Дорожні' плити або сірі плити 'Подвір'я' на краю мапи і шлях має бути прокладеним до входу у лікарню.",
  },
}
custom_campaign_window = {
  caption = "Додаткові кампанії",
  start_selected_campaign = "Почати кампанію",
}
level_progress = {
  hospital_value_enough = "Не знижуйте вартість вашої лікарні нижче %d, і вам потрібно буде вирішити лише ті проблеми, що залишилися, щоб виграти.",
  cured_enough_patients = "Ви вилікували достатньо своїх пацієнтів, але щоб перемогти, вам потрібно привести лікарню в кращий стан.",
}
disease_discovered_patient_choice.need_to_employ = "Використовуйте %s щоб впоратися з цією ситуацією."
multiplayer = {
  players_failed = "Ці гравці не змогли виконати останнє завдання:",
  everyone_failed = "Ніхто не виконав останню ціль. Тож усі до роботи і далі!",
}
warnings = {
  newersave = "Увага! Ви завантажили збережену гру з новішої версії. Ми не рекомендуємо продовжувати через можливі збої в грі. Можете продовжити на свій страх і ризик.",
  levelfile_variable_is_deprecated = "Попередження: Рівень «%s» містить у своєму файлі визначення змінної, яке не підтримується. «%LevelFile» було перейменовано на «%MapFile». Будь ласка, використовуйте редактор мап, щоб оновити рівень.",
}
