#
# src/test/testconfig.py -- configuration for local and remote unit tests
#

config = {
    #
    # 1) *** LOCAL CONFIGURATION ***
    #
    # The first part of the file tells the test framework
    # which file system locations are to be used for local testing.
    #
    #
    # Set logging level. Possible values:
    # 0 - silent (only error messages)
    # 1 - normal (above + SETUP + START + DONE + PASS + SKIP messages)
    # 2 - verbose (above + stdout from test binaries)
    #

    'unittest_log_level': 1,

    #
    # For tests that require true persistent memory, set the path to
    # a directory on a PMEM-aware file system here.
    # Uncomment this line if there's an actual persistent memory
    # available on your system.
    #

    'pmem_fs_dir': '/tmp',

    #
    # For tests that require true a non-persitent memory aware file system
    # (i.e. to verify something works on traditional page-cache based
    # memory-mapped files) set the path to a directory
    # on a normal file system here.
    #

    # 'non_pmem_fs_dir': '/tmp',

    #
    # To display execution time of each test
    #

    'tm': True,

    #
    # Overwrite default test type:
    # check, short, medium, long, all
    # where: check = short + medium; all = short + medium + long
    #

    'test_type': 'check',

    #
    # Set build type to be run:
    # debug, release, static-debug, static-release, all
    #

    'build': ['debug', 'release'],

    #
    # Set filesystem type to be run:
    # pmem, non-pmem, any, none, all (default)
    #

    'fs': 'all',

    #
    # If keep_going is set to True, execution continues despite test failures.
    #

    'keep_going': False,

    #
    # Set timeout
    # (floating point number with an optional suffix: 's' for seconds,
    # 'm' for minutes, 'h' for hours or 'd' for days)
    #

    'timeout': '30m',

    #
    # If you don't have real PMEM or PMEM emulation set up and/or the
    # filesystem does not support MAP_SYNC flag, but still want to test PMEM
    # codepaths set fs_dir_force_pmem to 1 or 2. It will set PMEM_IS_PMEM_FORCE
    # to 1 for tests that require pmem.
    #
    # Setting this flag to 1, if the PMEM_FS_DIR filesystem supports MAP_SYNC
    # will cause an error. This flag cannot be used with filesystems which
    # support MAP_SYNC because it would prevent from testing the target
    # PMEM codepaths. If you want to ignore this error set the value to 2.
    #
    'fs_dir_force_pmem': 1,

    #
    # In case of test fail all log files will be written. You can specify how
    # many lines should be written by setting this variable. If 'dump_lines' is
    # not set default value is 30.
    #
    'dump_lines': 30,

    # Forcibly run tests with selected Valgrind tool, unless the test
    # explicitly disables it.
    # Possible values: None (do not force), 'memcheck',
    # 'pmemcheck', 'drd', 'helgrind'
    #
    'force_enable': None,

    # For tests that require raw dax devices without a file system, add paths to
    # those devices to the list 'device_dax_path'. For most tests one device
    # is enough, but some might require more
    #
    'device_dax_path' : [],
}
