/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.type;

import java.util.regex.Pattern;
import org.odftoolkit.odfdom.type.Length;

public class PositiveLength
extends Length {
    private static final Pattern positiveLengthPattern = Pattern.compile("^([0-9]*[1-9][0-9]*(\\.[0-9]*)?|0+\\.[0-9]*[1-9][0-9]*|\\.[0-9]*[1-9][0-9]*)((cm)|(mm)|(in)|(pt)|(pc)|(px))$");

    public PositiveLength(String length) throws NumberFormatException {
        super(length);
        if (!PositiveLength.isValid(length)) {
            throw new NumberFormatException("parameter is invalid for datatype PositiveLength");
        }
    }

    public static PositiveLength valueOf(String stringValue) throws NumberFormatException {
        return new PositiveLength(stringValue);
    }

    public static boolean isValid(String stringValue) {
        return stringValue != null && positiveLengthPattern.matcher(stringValue).matches();
    }
}

