package grpcsql_test

import (
	"crypto/tls"
	"fmt"
)

func init() {
	cert, err := tls.X509KeyPair(certPEMBlock, keyPEMBlock)
	if err != nil {
		panic(fmt.Sprintf("invalid test X509 key pair: %v", err))
	}

	tlsConfig.Certificates = []tls.Certificate{cert}
}

var tlsConfig = &tls.Config{
	InsecureSkipVerify: true,
}

var certPEMBlock = []byte(`
-----BEGIN CERTIFICATE-----
MIIDpTCCAo2gAwIBAgIJAPDHg2Jq7+LZMA0GCSqGSIb3DQEBCwUAMGkxCzAJBgNV
BAYTAklUMQ4wDAYDVQQIDAVJdGFseTEQMA4GA1UEBwwHQm9sb2duYTEWMBQGA1UE
CgwNQ2Fub25pY2FsIEx0ZDEMMAoGA1UECwwDTFhEMRIwEAYDVQQDDAlsb2NhbGhv
c3QwHhcNMTcwOTE4MDUzNDI5WhcNMTgwOTE4MDUzNDI5WjBpMQswCQYDVQQGEwJJ
VDEOMAwGA1UECAwFSXRhbHkxEDAOBgNVBAcMB0JvbG9nbmExFjAUBgNVBAoMDUNh
bm9uaWNhbCBMdGQxDDAKBgNVBAsMA0xYRDESMBAGA1UEAwwJbG9jYWxob3N0MIIB
IjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAwcUWD3qG8GqkhjhNrcKrygGi
zE4CW+NBRpAIKgb/YDj6S9hM1VcXgXQYN3XgL7H+7STyYNO4wzvCDGOO4Lmzm4s9
8YrjEOM/5DuhZuzB+V94w4Sp/JKWGPL8TBt6uatClpxZl0U/7rGyfxeyWXXwmbvS
Cw4zQ9s/NzrjPS7Qsq2J1PQSVZJz6odrk5vfxX8q89aOKTXSV2A6wlQK78FoMkqY
jZYO5zcT0LiyALMaGOy9aQgRcdejyz5YEqxkSiR22gVqbXCuhR2SDR2rL4DktUvV
2SvmhhWD3VEuUjMc/AVDyKk/eCFocE8cxHMUp/ez665Cs2AN6U79if2FX1YArQID
AQABo1AwTjAdBgNVHQ4EFgQUUI+3haC04it9J5T1kdwPqvb8xPMwHwYDVR0jBBgw
FoAUUI+3haC04it9J5T1kdwPqvb8xPMwDAYDVR0TBAUwAwEB/zANBgkqhkiG9w0B
AQsFAAOCAQEAvnjKFtVjPaD9X3ToVYGW9Ltl3MP1nbopImehIwLJSH8yGxUzC1Bj
VI6qJJEGqx0UEwZU95TTV3D+5XhgI6o4sopf+fSx9sdIsAaQkMR3fSmq5pxLoGMp
8/gTGudIl5VU6tI0MqXqTOnQ8Fz3hhr6hWlaLMfAJCvwjS6YrRngYCM18oqoF+5r
XFHpNXIfDV2w88NKwzaGqQCh1c/PPokiJpCq06gd9wuz3T9nvQhdNnTXv/MT5oYi
udDUr8WsG/GXQnCAmxBTCd9px3TRj5DV7hHX8uZVwHEQsMA4+dES8thhtCG/hodr
qwU8YxLgSiCYDyqir3nA7/3RdIKg7TF0SQ==
-----END CERTIFICATE-----
`)

var keyPEMBlock = []byte(`
-----BEGIN PRIVATE KEY-----
MIIEvwIBADANBgkqhkiG9w0BAQEFAASCBKkwggSlAgEAAoIBAQDBxRYPeobwaqSG
OE2twqvKAaLMTgJb40FGkAgqBv9gOPpL2EzVVxeBdBg3deAvsf7tJPJg07jDO8IM
Y47gubObiz3xiuMQ4z/kO6Fm7MH5X3jDhKn8kpYY8vxMG3q5q0KWnFmXRT/usbJ/
F7JZdfCZu9ILDjND2z83OuM9LtCyrYnU9BJVknPqh2uTm9/Ffyrz1o4pNdJXYDrC
VArvwWgySpiNlg7nNxPQuLIAsxoY7L1pCBFx16PLPlgSrGRKJHbaBWptcK6FHZIN
HasvgOS1S9XZK+aGFYPdUS5SMxz8BUPIqT94IWhwTxzEcxSn97PrrkKzYA3pTv2J
/YVfVgCtAgMBAAECggEBALBmSXUB6IJJs0l1TFIZXObjol83zTH1quEgEi6gfDAO
7t3JJfk59e4l0D39E4CYHCmrbvPzCsrBRiCdKd8vb3D0zAlulNQ07V9LYd4fP19U
KM5loZKLqBVCb6ihg5IvdMlDwNPTeSZFoufMnNKQad6qe8cQwF7P47bV5zU1v0xI
1J9pbZVCNO92QbjUXvwQNY7EZMHpJIYFZEaAzf0SalzWXiUxHSlGW+ChiV8gpOFr
ZvzmvrNJKt+q3Y2bJq3lyIPXMIXRd3huTr6sznMgefDwVqhBuL9/PMFq2JlfnkF2
+GlFgoCldgytlHVQQYhxaF49ppKosQE/w2dB699mxYkCgYEA8s9NS1HBZfxt1b+K
cWVHJS7S+vDVE4IU6MW40jWFKjsGSZ5HdvQO2od4mRcg3aZ/+YOjcIIMHrcSHNC0
C5/C5Ncl4WHKkLllU9AGJ9fFtDhLpi9L4BWKTbfo0Rbw1LC6qZpIRc5M5b961brv
c6qJDHDNDTpQ4tJVC1PGMcSALE8CgYEAzEvMQgWPQgOBkHozS5V4uuG2F9lGtO76
w0Ye9PD8FEvlbNOgLZQKNW3AMiyK5hSpBiUy8UUHXiYTRU4IbVwsoNMm2PZbmJ3/
Wrvyt/UOHAya9V2d3480yMuruMEODk/Ib5kMpOJkYRwroCDYPZXdUe5HBuhKHgdY
h9Q1KvBtGEMCgYA+pYfO0BgzBQ8doB7LJRNXH56lyi9fqidU63bFHbPu8m2r3t+X
bF7MuTk/Xn1HUucf7Hvl0lfoMNnGf36EpUK2omAOp5mI/5yKJFkCPKSw2/mAtiFA
fq5BYRr7n4yhg7uVeM3+3LxwZpf9vw567FwRzqTJLeuiqhvxITs4qfdb9wKBgQCG
1lRXEwJNiLDgIbdvYJURi126+d4QF1cMwWA3PEK0Rq+DF142Fupx/yEGPJ3kY6h3
dN/dnDjTq/+2E12+iEKwVwzh0B/+Z/Gc+kWloqkQXEV+Qq6rWgJ1sO+C/nB/g6r/
9R0CSqYD7irhAiyW4S31IHZimbgpf6Gv7KC22X63rwKBgQCH8PaUwDP6faiwWWZ+
WREwYUXz2L+RfYro1FxGZLnI+qjvftpwOJO5TfLIoTZl+iVNNTleq9bFA000UpnM
oS7boRbu9L+CdMgRLFT4YFveB2leA5nKNc7QAHVIC7zjU6FqU1eSU6PaMC3nm+V0
wDrq6ufUpf4HyBQ5TT6y95QljA==
-----END PRIVATE KEY-----
`)
