; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+v -riscv-v-vector-bits-min=128 -riscv-v-fixed-length-vector-lmul-max=2 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=LMULMAX2-RV32
; RUN: llc -mtriple=riscv64 -mattr=+v -riscv-v-vector-bits-min=128 -riscv-v-fixed-length-vector-lmul-max=2 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=LMULMAX2-RV64
; RUN: llc -mtriple=riscv32 -mattr=+v -riscv-v-vector-bits-min=128 -riscv-v-fixed-length-vector-lmul-max=1 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=LMULMAX1-RV32
; RUN: llc -mtriple=riscv64 -mattr=+v -riscv-v-vector-bits-min=128 -riscv-v-fixed-length-vector-lmul-max=1 -verify-machineinstrs < %s | FileCheck %s --check-prefixes=LMULMAX1-RV64

define void @bitreverse_v8i16(<8 x i16>* %x, <8 x i16>* %y) {
; LMULMAX2-RV32-LABEL: bitreverse_v8i16:
; LMULMAX2-RV32:       # %bb.0:
; LMULMAX2-RV32-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; LMULMAX2-RV32-NEXT:    vle16.v v8, (a0)
; LMULMAX2-RV32-NEXT:    vsrl.vi v9, v8, 8
; LMULMAX2-RV32-NEXT:    vsll.vi v8, v8, 8
; LMULMAX2-RV32-NEXT:    vor.vv v8, v8, v9
; LMULMAX2-RV32-NEXT:    vsrl.vi v9, v8, 4
; LMULMAX2-RV32-NEXT:    lui a1, 1
; LMULMAX2-RV32-NEXT:    addi a1, a1, -241
; LMULMAX2-RV32-NEXT:    vand.vx v9, v9, a1
; LMULMAX2-RV32-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV32-NEXT:    vsll.vi v8, v8, 4
; LMULMAX2-RV32-NEXT:    vor.vv v8, v9, v8
; LMULMAX2-RV32-NEXT:    vsrl.vi v9, v8, 2
; LMULMAX2-RV32-NEXT:    lui a1, 3
; LMULMAX2-RV32-NEXT:    addi a1, a1, 819
; LMULMAX2-RV32-NEXT:    vand.vx v9, v9, a1
; LMULMAX2-RV32-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV32-NEXT:    vsll.vi v8, v8, 2
; LMULMAX2-RV32-NEXT:    vor.vv v8, v9, v8
; LMULMAX2-RV32-NEXT:    vsrl.vi v9, v8, 1
; LMULMAX2-RV32-NEXT:    lui a1, 5
; LMULMAX2-RV32-NEXT:    addi a1, a1, 1365
; LMULMAX2-RV32-NEXT:    vand.vx v9, v9, a1
; LMULMAX2-RV32-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV32-NEXT:    vadd.vv v8, v8, v8
; LMULMAX2-RV32-NEXT:    vor.vv v8, v9, v8
; LMULMAX2-RV32-NEXT:    vse16.v v8, (a0)
; LMULMAX2-RV32-NEXT:    ret
;
; LMULMAX2-RV64-LABEL: bitreverse_v8i16:
; LMULMAX2-RV64:       # %bb.0:
; LMULMAX2-RV64-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; LMULMAX2-RV64-NEXT:    vle16.v v8, (a0)
; LMULMAX2-RV64-NEXT:    vsrl.vi v9, v8, 8
; LMULMAX2-RV64-NEXT:    vsll.vi v8, v8, 8
; LMULMAX2-RV64-NEXT:    vor.vv v8, v8, v9
; LMULMAX2-RV64-NEXT:    vsrl.vi v9, v8, 4
; LMULMAX2-RV64-NEXT:    lui a1, 1
; LMULMAX2-RV64-NEXT:    addiw a1, a1, -241
; LMULMAX2-RV64-NEXT:    vand.vx v9, v9, a1
; LMULMAX2-RV64-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV64-NEXT:    vsll.vi v8, v8, 4
; LMULMAX2-RV64-NEXT:    vor.vv v8, v9, v8
; LMULMAX2-RV64-NEXT:    vsrl.vi v9, v8, 2
; LMULMAX2-RV64-NEXT:    lui a1, 3
; LMULMAX2-RV64-NEXT:    addiw a1, a1, 819
; LMULMAX2-RV64-NEXT:    vand.vx v9, v9, a1
; LMULMAX2-RV64-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV64-NEXT:    vsll.vi v8, v8, 2
; LMULMAX2-RV64-NEXT:    vor.vv v8, v9, v8
; LMULMAX2-RV64-NEXT:    vsrl.vi v9, v8, 1
; LMULMAX2-RV64-NEXT:    lui a1, 5
; LMULMAX2-RV64-NEXT:    addiw a1, a1, 1365
; LMULMAX2-RV64-NEXT:    vand.vx v9, v9, a1
; LMULMAX2-RV64-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV64-NEXT:    vadd.vv v8, v8, v8
; LMULMAX2-RV64-NEXT:    vor.vv v8, v9, v8
; LMULMAX2-RV64-NEXT:    vse16.v v8, (a0)
; LMULMAX2-RV64-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: bitreverse_v8i16:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; LMULMAX1-RV32-NEXT:    vle16.v v8, (a0)
; LMULMAX1-RV32-NEXT:    vsrl.vi v9, v8, 8
; LMULMAX1-RV32-NEXT:    vsll.vi v8, v8, 8
; LMULMAX1-RV32-NEXT:    vor.vv v8, v8, v9
; LMULMAX1-RV32-NEXT:    vsrl.vi v9, v8, 4
; LMULMAX1-RV32-NEXT:    lui a1, 1
; LMULMAX1-RV32-NEXT:    addi a1, a1, -241
; LMULMAX1-RV32-NEXT:    vand.vx v9, v9, a1
; LMULMAX1-RV32-NEXT:    vand.vx v8, v8, a1
; LMULMAX1-RV32-NEXT:    vsll.vi v8, v8, 4
; LMULMAX1-RV32-NEXT:    vor.vv v8, v9, v8
; LMULMAX1-RV32-NEXT:    vsrl.vi v9, v8, 2
; LMULMAX1-RV32-NEXT:    lui a1, 3
; LMULMAX1-RV32-NEXT:    addi a1, a1, 819
; LMULMAX1-RV32-NEXT:    vand.vx v9, v9, a1
; LMULMAX1-RV32-NEXT:    vand.vx v8, v8, a1
; LMULMAX1-RV32-NEXT:    vsll.vi v8, v8, 2
; LMULMAX1-RV32-NEXT:    vor.vv v8, v9, v8
; LMULMAX1-RV32-NEXT:    vsrl.vi v9, v8, 1
; LMULMAX1-RV32-NEXT:    lui a1, 5
; LMULMAX1-RV32-NEXT:    addi a1, a1, 1365
; LMULMAX1-RV32-NEXT:    vand.vx v9, v9, a1
; LMULMAX1-RV32-NEXT:    vand.vx v8, v8, a1
; LMULMAX1-RV32-NEXT:    vadd.vv v8, v8, v8
; LMULMAX1-RV32-NEXT:    vor.vv v8, v9, v8
; LMULMAX1-RV32-NEXT:    vse16.v v8, (a0)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: bitreverse_v8i16:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; LMULMAX1-RV64-NEXT:    vle16.v v8, (a0)
; LMULMAX1-RV64-NEXT:    vsrl.vi v9, v8, 8
; LMULMAX1-RV64-NEXT:    vsll.vi v8, v8, 8
; LMULMAX1-RV64-NEXT:    vor.vv v8, v8, v9
; LMULMAX1-RV64-NEXT:    vsrl.vi v9, v8, 4
; LMULMAX1-RV64-NEXT:    lui a1, 1
; LMULMAX1-RV64-NEXT:    addiw a1, a1, -241
; LMULMAX1-RV64-NEXT:    vand.vx v9, v9, a1
; LMULMAX1-RV64-NEXT:    vand.vx v8, v8, a1
; LMULMAX1-RV64-NEXT:    vsll.vi v8, v8, 4
; LMULMAX1-RV64-NEXT:    vor.vv v8, v9, v8
; LMULMAX1-RV64-NEXT:    vsrl.vi v9, v8, 2
; LMULMAX1-RV64-NEXT:    lui a1, 3
; LMULMAX1-RV64-NEXT:    addiw a1, a1, 819
; LMULMAX1-RV64-NEXT:    vand.vx v9, v9, a1
; LMULMAX1-RV64-NEXT:    vand.vx v8, v8, a1
; LMULMAX1-RV64-NEXT:    vsll.vi v8, v8, 2
; LMULMAX1-RV64-NEXT:    vor.vv v8, v9, v8
; LMULMAX1-RV64-NEXT:    vsrl.vi v9, v8, 1
; LMULMAX1-RV64-NEXT:    lui a1, 5
; LMULMAX1-RV64-NEXT:    addiw a1, a1, 1365
; LMULMAX1-RV64-NEXT:    vand.vx v9, v9, a1
; LMULMAX1-RV64-NEXT:    vand.vx v8, v8, a1
; LMULMAX1-RV64-NEXT:    vadd.vv v8, v8, v8
; LMULMAX1-RV64-NEXT:    vor.vv v8, v9, v8
; LMULMAX1-RV64-NEXT:    vse16.v v8, (a0)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <8 x i16>, <8 x i16>* %x
  %b = load <8 x i16>, <8 x i16>* %y
  %c = call <8 x i16> @llvm.bitreverse.v8i16(<8 x i16> %a)
  store <8 x i16> %c, <8 x i16>* %x
  ret void
}
declare <8 x i16> @llvm.bitreverse.v8i16(<8 x i16>)

define void @bitreverse_v4i32(<4 x i32>* %x, <4 x i32>* %y) {
; LMULMAX2-RV32-LABEL: bitreverse_v4i32:
; LMULMAX2-RV32:       # %bb.0:
; LMULMAX2-RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; LMULMAX2-RV32-NEXT:    vle32.v v8, (a0)
; LMULMAX2-RV32-NEXT:    vsrl.vi v9, v8, 8
; LMULMAX2-RV32-NEXT:    lui a1, 16
; LMULMAX2-RV32-NEXT:    addi a1, a1, -256
; LMULMAX2-RV32-NEXT:    vand.vx v9, v9, a1
; LMULMAX2-RV32-NEXT:    vsrl.vi v10, v8, 24
; LMULMAX2-RV32-NEXT:    vor.vv v9, v9, v10
; LMULMAX2-RV32-NEXT:    vsll.vi v10, v8, 8
; LMULMAX2-RV32-NEXT:    lui a1, 4080
; LMULMAX2-RV32-NEXT:    vand.vx v10, v10, a1
; LMULMAX2-RV32-NEXT:    vsll.vi v8, v8, 24
; LMULMAX2-RV32-NEXT:    vor.vv v8, v8, v10
; LMULMAX2-RV32-NEXT:    vor.vv v8, v8, v9
; LMULMAX2-RV32-NEXT:    vsrl.vi v9, v8, 4
; LMULMAX2-RV32-NEXT:    lui a1, 61681
; LMULMAX2-RV32-NEXT:    addi a1, a1, -241
; LMULMAX2-RV32-NEXT:    vand.vx v9, v9, a1
; LMULMAX2-RV32-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV32-NEXT:    vsll.vi v8, v8, 4
; LMULMAX2-RV32-NEXT:    vor.vv v8, v9, v8
; LMULMAX2-RV32-NEXT:    vsrl.vi v9, v8, 2
; LMULMAX2-RV32-NEXT:    lui a1, 209715
; LMULMAX2-RV32-NEXT:    addi a1, a1, 819
; LMULMAX2-RV32-NEXT:    vand.vx v9, v9, a1
; LMULMAX2-RV32-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV32-NEXT:    vsll.vi v8, v8, 2
; LMULMAX2-RV32-NEXT:    vor.vv v8, v9, v8
; LMULMAX2-RV32-NEXT:    vsrl.vi v9, v8, 1
; LMULMAX2-RV32-NEXT:    lui a1, 349525
; LMULMAX2-RV32-NEXT:    addi a1, a1, 1365
; LMULMAX2-RV32-NEXT:    vand.vx v9, v9, a1
; LMULMAX2-RV32-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV32-NEXT:    vadd.vv v8, v8, v8
; LMULMAX2-RV32-NEXT:    vor.vv v8, v9, v8
; LMULMAX2-RV32-NEXT:    vse32.v v8, (a0)
; LMULMAX2-RV32-NEXT:    ret
;
; LMULMAX2-RV64-LABEL: bitreverse_v4i32:
; LMULMAX2-RV64:       # %bb.0:
; LMULMAX2-RV64-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; LMULMAX2-RV64-NEXT:    vle32.v v8, (a0)
; LMULMAX2-RV64-NEXT:    vsrl.vi v9, v8, 8
; LMULMAX2-RV64-NEXT:    lui a1, 16
; LMULMAX2-RV64-NEXT:    addiw a1, a1, -256
; LMULMAX2-RV64-NEXT:    vand.vx v9, v9, a1
; LMULMAX2-RV64-NEXT:    vsrl.vi v10, v8, 24
; LMULMAX2-RV64-NEXT:    vor.vv v9, v9, v10
; LMULMAX2-RV64-NEXT:    vsll.vi v10, v8, 8
; LMULMAX2-RV64-NEXT:    lui a1, 4080
; LMULMAX2-RV64-NEXT:    vand.vx v10, v10, a1
; LMULMAX2-RV64-NEXT:    vsll.vi v8, v8, 24
; LMULMAX2-RV64-NEXT:    vor.vv v8, v8, v10
; LMULMAX2-RV64-NEXT:    vor.vv v8, v8, v9
; LMULMAX2-RV64-NEXT:    vsrl.vi v9, v8, 4
; LMULMAX2-RV64-NEXT:    lui a1, 61681
; LMULMAX2-RV64-NEXT:    addiw a1, a1, -241
; LMULMAX2-RV64-NEXT:    vand.vx v9, v9, a1
; LMULMAX2-RV64-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV64-NEXT:    vsll.vi v8, v8, 4
; LMULMAX2-RV64-NEXT:    vor.vv v8, v9, v8
; LMULMAX2-RV64-NEXT:    vsrl.vi v9, v8, 2
; LMULMAX2-RV64-NEXT:    lui a1, 209715
; LMULMAX2-RV64-NEXT:    addiw a1, a1, 819
; LMULMAX2-RV64-NEXT:    vand.vx v9, v9, a1
; LMULMAX2-RV64-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV64-NEXT:    vsll.vi v8, v8, 2
; LMULMAX2-RV64-NEXT:    vor.vv v8, v9, v8
; LMULMAX2-RV64-NEXT:    vsrl.vi v9, v8, 1
; LMULMAX2-RV64-NEXT:    lui a1, 349525
; LMULMAX2-RV64-NEXT:    addiw a1, a1, 1365
; LMULMAX2-RV64-NEXT:    vand.vx v9, v9, a1
; LMULMAX2-RV64-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV64-NEXT:    vadd.vv v8, v8, v8
; LMULMAX2-RV64-NEXT:    vor.vv v8, v9, v8
; LMULMAX2-RV64-NEXT:    vse32.v v8, (a0)
; LMULMAX2-RV64-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: bitreverse_v4i32:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; LMULMAX1-RV32-NEXT:    vle32.v v8, (a0)
; LMULMAX1-RV32-NEXT:    vsrl.vi v9, v8, 8
; LMULMAX1-RV32-NEXT:    lui a1, 16
; LMULMAX1-RV32-NEXT:    addi a1, a1, -256
; LMULMAX1-RV32-NEXT:    vand.vx v9, v9, a1
; LMULMAX1-RV32-NEXT:    vsrl.vi v10, v8, 24
; LMULMAX1-RV32-NEXT:    vor.vv v9, v9, v10
; LMULMAX1-RV32-NEXT:    vsll.vi v10, v8, 8
; LMULMAX1-RV32-NEXT:    lui a1, 4080
; LMULMAX1-RV32-NEXT:    vand.vx v10, v10, a1
; LMULMAX1-RV32-NEXT:    vsll.vi v8, v8, 24
; LMULMAX1-RV32-NEXT:    vor.vv v8, v8, v10
; LMULMAX1-RV32-NEXT:    vor.vv v8, v8, v9
; LMULMAX1-RV32-NEXT:    vsrl.vi v9, v8, 4
; LMULMAX1-RV32-NEXT:    lui a1, 61681
; LMULMAX1-RV32-NEXT:    addi a1, a1, -241
; LMULMAX1-RV32-NEXT:    vand.vx v9, v9, a1
; LMULMAX1-RV32-NEXT:    vand.vx v8, v8, a1
; LMULMAX1-RV32-NEXT:    vsll.vi v8, v8, 4
; LMULMAX1-RV32-NEXT:    vor.vv v8, v9, v8
; LMULMAX1-RV32-NEXT:    vsrl.vi v9, v8, 2
; LMULMAX1-RV32-NEXT:    lui a1, 209715
; LMULMAX1-RV32-NEXT:    addi a1, a1, 819
; LMULMAX1-RV32-NEXT:    vand.vx v9, v9, a1
; LMULMAX1-RV32-NEXT:    vand.vx v8, v8, a1
; LMULMAX1-RV32-NEXT:    vsll.vi v8, v8, 2
; LMULMAX1-RV32-NEXT:    vor.vv v8, v9, v8
; LMULMAX1-RV32-NEXT:    vsrl.vi v9, v8, 1
; LMULMAX1-RV32-NEXT:    lui a1, 349525
; LMULMAX1-RV32-NEXT:    addi a1, a1, 1365
; LMULMAX1-RV32-NEXT:    vand.vx v9, v9, a1
; LMULMAX1-RV32-NEXT:    vand.vx v8, v8, a1
; LMULMAX1-RV32-NEXT:    vadd.vv v8, v8, v8
; LMULMAX1-RV32-NEXT:    vor.vv v8, v9, v8
; LMULMAX1-RV32-NEXT:    vse32.v v8, (a0)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: bitreverse_v4i32:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; LMULMAX1-RV64-NEXT:    vle32.v v8, (a0)
; LMULMAX1-RV64-NEXT:    vsrl.vi v9, v8, 8
; LMULMAX1-RV64-NEXT:    lui a1, 16
; LMULMAX1-RV64-NEXT:    addiw a1, a1, -256
; LMULMAX1-RV64-NEXT:    vand.vx v9, v9, a1
; LMULMAX1-RV64-NEXT:    vsrl.vi v10, v8, 24
; LMULMAX1-RV64-NEXT:    vor.vv v9, v9, v10
; LMULMAX1-RV64-NEXT:    vsll.vi v10, v8, 8
; LMULMAX1-RV64-NEXT:    lui a1, 4080
; LMULMAX1-RV64-NEXT:    vand.vx v10, v10, a1
; LMULMAX1-RV64-NEXT:    vsll.vi v8, v8, 24
; LMULMAX1-RV64-NEXT:    vor.vv v8, v8, v10
; LMULMAX1-RV64-NEXT:    vor.vv v8, v8, v9
; LMULMAX1-RV64-NEXT:    vsrl.vi v9, v8, 4
; LMULMAX1-RV64-NEXT:    lui a1, 61681
; LMULMAX1-RV64-NEXT:    addiw a1, a1, -241
; LMULMAX1-RV64-NEXT:    vand.vx v9, v9, a1
; LMULMAX1-RV64-NEXT:    vand.vx v8, v8, a1
; LMULMAX1-RV64-NEXT:    vsll.vi v8, v8, 4
; LMULMAX1-RV64-NEXT:    vor.vv v8, v9, v8
; LMULMAX1-RV64-NEXT:    vsrl.vi v9, v8, 2
; LMULMAX1-RV64-NEXT:    lui a1, 209715
; LMULMAX1-RV64-NEXT:    addiw a1, a1, 819
; LMULMAX1-RV64-NEXT:    vand.vx v9, v9, a1
; LMULMAX1-RV64-NEXT:    vand.vx v8, v8, a1
; LMULMAX1-RV64-NEXT:    vsll.vi v8, v8, 2
; LMULMAX1-RV64-NEXT:    vor.vv v8, v9, v8
; LMULMAX1-RV64-NEXT:    vsrl.vi v9, v8, 1
; LMULMAX1-RV64-NEXT:    lui a1, 349525
; LMULMAX1-RV64-NEXT:    addiw a1, a1, 1365
; LMULMAX1-RV64-NEXT:    vand.vx v9, v9, a1
; LMULMAX1-RV64-NEXT:    vand.vx v8, v8, a1
; LMULMAX1-RV64-NEXT:    vadd.vv v8, v8, v8
; LMULMAX1-RV64-NEXT:    vor.vv v8, v9, v8
; LMULMAX1-RV64-NEXT:    vse32.v v8, (a0)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <4 x i32>, <4 x i32>* %x
  %b = load <4 x i32>, <4 x i32>* %y
  %c = call <4 x i32> @llvm.bitreverse.v4i32(<4 x i32> %a)
  store <4 x i32> %c, <4 x i32>* %x
  ret void
}
declare <4 x i32> @llvm.bitreverse.v4i32(<4 x i32>)

define void @bitreverse_v2i64(<2 x i64>* %x, <2 x i64>* %y) {
; LMULMAX2-RV32-LABEL: bitreverse_v2i64:
; LMULMAX2-RV32:       # %bb.0:
; LMULMAX2-RV32-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; LMULMAX2-RV32-NEXT:    vle64.v v8, (a0)
; LMULMAX2-RV32-NEXT:    li a1, 56
; LMULMAX2-RV32-NEXT:    vsrl.vx v9, v8, a1
; LMULMAX2-RV32-NEXT:    li a2, 40
; LMULMAX2-RV32-NEXT:    vsrl.vx v10, v8, a2
; LMULMAX2-RV32-NEXT:    lui a3, 16
; LMULMAX2-RV32-NEXT:    addi a3, a3, -256
; LMULMAX2-RV32-NEXT:    vand.vx v10, v10, a3
; LMULMAX2-RV32-NEXT:    vor.vv v9, v10, v9
; LMULMAX2-RV32-NEXT:    vsrl.vi v10, v8, 24
; LMULMAX2-RV32-NEXT:    lui a4, 4080
; LMULMAX2-RV32-NEXT:    vand.vx v10, v10, a4
; LMULMAX2-RV32-NEXT:    li a5, 5
; LMULMAX2-RV32-NEXT:    vsetivli zero, 1, e8, mf8, ta, mu
; LMULMAX2-RV32-NEXT:    vmv.s.x v0, a5
; LMULMAX2-RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; LMULMAX2-RV32-NEXT:    vmv.v.i v11, 0
; LMULMAX2-RV32-NEXT:    lui a5, 1044480
; LMULMAX2-RV32-NEXT:    vmerge.vxm v11, v11, a5, v0
; LMULMAX2-RV32-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; LMULMAX2-RV32-NEXT:    vsrl.vi v12, v8, 8
; LMULMAX2-RV32-NEXT:    vand.vv v11, v12, v11
; LMULMAX2-RV32-NEXT:    vor.vv v10, v11, v10
; LMULMAX2-RV32-NEXT:    vor.vv v9, v10, v9
; LMULMAX2-RV32-NEXT:    li a5, 255
; LMULMAX2-RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; LMULMAX2-RV32-NEXT:    vmv.v.x v10, a5
; LMULMAX2-RV32-NEXT:    vmerge.vim v10, v10, 0, v0
; LMULMAX2-RV32-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; LMULMAX2-RV32-NEXT:    vsll.vi v11, v8, 8
; LMULMAX2-RV32-NEXT:    vand.vv v10, v11, v10
; LMULMAX2-RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; LMULMAX2-RV32-NEXT:    vmv.v.x v11, a3
; LMULMAX2-RV32-NEXT:    vmerge.vim v11, v11, 0, v0
; LMULMAX2-RV32-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; LMULMAX2-RV32-NEXT:    vsll.vi v12, v8, 24
; LMULMAX2-RV32-NEXT:    vand.vv v11, v12, v11
; LMULMAX2-RV32-NEXT:    vor.vv v10, v11, v10
; LMULMAX2-RV32-NEXT:    vsll.vx v11, v8, a2
; LMULMAX2-RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; LMULMAX2-RV32-NEXT:    vmv.v.x v12, a4
; LMULMAX2-RV32-NEXT:    vmerge.vim v12, v12, 0, v0
; LMULMAX2-RV32-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; LMULMAX2-RV32-NEXT:    vand.vv v11, v11, v12
; LMULMAX2-RV32-NEXT:    vsll.vx v8, v8, a1
; LMULMAX2-RV32-NEXT:    vor.vv v8, v8, v11
; LMULMAX2-RV32-NEXT:    vor.vv v8, v8, v10
; LMULMAX2-RV32-NEXT:    vor.vv v8, v8, v9
; LMULMAX2-RV32-NEXT:    vsrl.vi v9, v8, 4
; LMULMAX2-RV32-NEXT:    lui a1, 61681
; LMULMAX2-RV32-NEXT:    addi a1, a1, -241
; LMULMAX2-RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; LMULMAX2-RV32-NEXT:    vmv.v.x v10, a1
; LMULMAX2-RV32-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; LMULMAX2-RV32-NEXT:    vand.vv v9, v9, v10
; LMULMAX2-RV32-NEXT:    vand.vv v8, v8, v10
; LMULMAX2-RV32-NEXT:    vsll.vi v8, v8, 4
; LMULMAX2-RV32-NEXT:    vor.vv v8, v9, v8
; LMULMAX2-RV32-NEXT:    vsrl.vi v9, v8, 2
; LMULMAX2-RV32-NEXT:    lui a1, 209715
; LMULMAX2-RV32-NEXT:    addi a1, a1, 819
; LMULMAX2-RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; LMULMAX2-RV32-NEXT:    vmv.v.x v10, a1
; LMULMAX2-RV32-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; LMULMAX2-RV32-NEXT:    vand.vv v9, v9, v10
; LMULMAX2-RV32-NEXT:    vand.vv v8, v8, v10
; LMULMAX2-RV32-NEXT:    vsll.vi v8, v8, 2
; LMULMAX2-RV32-NEXT:    vor.vv v8, v9, v8
; LMULMAX2-RV32-NEXT:    vsrl.vi v9, v8, 1
; LMULMAX2-RV32-NEXT:    lui a1, 349525
; LMULMAX2-RV32-NEXT:    addi a1, a1, 1365
; LMULMAX2-RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; LMULMAX2-RV32-NEXT:    vmv.v.x v10, a1
; LMULMAX2-RV32-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; LMULMAX2-RV32-NEXT:    vand.vv v9, v9, v10
; LMULMAX2-RV32-NEXT:    vand.vv v8, v8, v10
; LMULMAX2-RV32-NEXT:    vadd.vv v8, v8, v8
; LMULMAX2-RV32-NEXT:    vor.vv v8, v9, v8
; LMULMAX2-RV32-NEXT:    vse64.v v8, (a0)
; LMULMAX2-RV32-NEXT:    ret
;
; LMULMAX2-RV64-LABEL: bitreverse_v2i64:
; LMULMAX2-RV64:       # %bb.0:
; LMULMAX2-RV64-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; LMULMAX2-RV64-NEXT:    vle64.v v8, (a0)
; LMULMAX2-RV64-NEXT:    li a1, 56
; LMULMAX2-RV64-NEXT:    vsrl.vx v9, v8, a1
; LMULMAX2-RV64-NEXT:    li a2, 40
; LMULMAX2-RV64-NEXT:    vsrl.vx v10, v8, a2
; LMULMAX2-RV64-NEXT:    lui a3, 16
; LMULMAX2-RV64-NEXT:    addiw a3, a3, -256
; LMULMAX2-RV64-NEXT:    vand.vx v10, v10, a3
; LMULMAX2-RV64-NEXT:    vor.vv v9, v10, v9
; LMULMAX2-RV64-NEXT:    vsrl.vi v10, v8, 24
; LMULMAX2-RV64-NEXT:    lui a3, 4080
; LMULMAX2-RV64-NEXT:    vand.vx v10, v10, a3
; LMULMAX2-RV64-NEXT:    vsrl.vi v11, v8, 8
; LMULMAX2-RV64-NEXT:    li a3, 255
; LMULMAX2-RV64-NEXT:    slli a4, a3, 24
; LMULMAX2-RV64-NEXT:    vand.vx v11, v11, a4
; LMULMAX2-RV64-NEXT:    vor.vv v10, v11, v10
; LMULMAX2-RV64-NEXT:    vor.vv v9, v10, v9
; LMULMAX2-RV64-NEXT:    vsll.vi v10, v8, 8
; LMULMAX2-RV64-NEXT:    slli a4, a3, 32
; LMULMAX2-RV64-NEXT:    vand.vx v10, v10, a4
; LMULMAX2-RV64-NEXT:    vsll.vi v11, v8, 24
; LMULMAX2-RV64-NEXT:    slli a4, a3, 40
; LMULMAX2-RV64-NEXT:    vand.vx v11, v11, a4
; LMULMAX2-RV64-NEXT:    vor.vv v10, v11, v10
; LMULMAX2-RV64-NEXT:    vsll.vx v11, v8, a1
; LMULMAX2-RV64-NEXT:    vsll.vx v8, v8, a2
; LMULMAX2-RV64-NEXT:    slli a1, a3, 48
; LMULMAX2-RV64-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV64-NEXT:    vor.vv v8, v11, v8
; LMULMAX2-RV64-NEXT:    lui a1, %hi(.LCPI2_0)
; LMULMAX2-RV64-NEXT:    ld a1, %lo(.LCPI2_0)(a1)
; LMULMAX2-RV64-NEXT:    vor.vv v8, v8, v10
; LMULMAX2-RV64-NEXT:    vor.vv v8, v8, v9
; LMULMAX2-RV64-NEXT:    vsrl.vi v9, v8, 4
; LMULMAX2-RV64-NEXT:    vand.vx v9, v9, a1
; LMULMAX2-RV64-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV64-NEXT:    lui a1, %hi(.LCPI2_1)
; LMULMAX2-RV64-NEXT:    ld a1, %lo(.LCPI2_1)(a1)
; LMULMAX2-RV64-NEXT:    vsll.vi v8, v8, 4
; LMULMAX2-RV64-NEXT:    vor.vv v8, v9, v8
; LMULMAX2-RV64-NEXT:    vsrl.vi v9, v8, 2
; LMULMAX2-RV64-NEXT:    vand.vx v9, v9, a1
; LMULMAX2-RV64-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV64-NEXT:    lui a1, %hi(.LCPI2_2)
; LMULMAX2-RV64-NEXT:    ld a1, %lo(.LCPI2_2)(a1)
; LMULMAX2-RV64-NEXT:    vsll.vi v8, v8, 2
; LMULMAX2-RV64-NEXT:    vor.vv v8, v9, v8
; LMULMAX2-RV64-NEXT:    vsrl.vi v9, v8, 1
; LMULMAX2-RV64-NEXT:    vand.vx v9, v9, a1
; LMULMAX2-RV64-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV64-NEXT:    vadd.vv v8, v8, v8
; LMULMAX2-RV64-NEXT:    vor.vv v8, v9, v8
; LMULMAX2-RV64-NEXT:    vse64.v v8, (a0)
; LMULMAX2-RV64-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: bitreverse_v2i64:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; LMULMAX1-RV32-NEXT:    vle64.v v8, (a0)
; LMULMAX1-RV32-NEXT:    li a1, 56
; LMULMAX1-RV32-NEXT:    vsrl.vx v9, v8, a1
; LMULMAX1-RV32-NEXT:    li a2, 40
; LMULMAX1-RV32-NEXT:    vsrl.vx v10, v8, a2
; LMULMAX1-RV32-NEXT:    lui a3, 16
; LMULMAX1-RV32-NEXT:    addi a3, a3, -256
; LMULMAX1-RV32-NEXT:    vand.vx v10, v10, a3
; LMULMAX1-RV32-NEXT:    vor.vv v9, v10, v9
; LMULMAX1-RV32-NEXT:    vsrl.vi v10, v8, 24
; LMULMAX1-RV32-NEXT:    lui a4, 4080
; LMULMAX1-RV32-NEXT:    vand.vx v10, v10, a4
; LMULMAX1-RV32-NEXT:    li a5, 5
; LMULMAX1-RV32-NEXT:    vsetivli zero, 1, e8, mf8, ta, mu
; LMULMAX1-RV32-NEXT:    vmv.s.x v0, a5
; LMULMAX1-RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; LMULMAX1-RV32-NEXT:    vmv.v.i v11, 0
; LMULMAX1-RV32-NEXT:    lui a5, 1044480
; LMULMAX1-RV32-NEXT:    vmerge.vxm v11, v11, a5, v0
; LMULMAX1-RV32-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; LMULMAX1-RV32-NEXT:    vsrl.vi v12, v8, 8
; LMULMAX1-RV32-NEXT:    vand.vv v11, v12, v11
; LMULMAX1-RV32-NEXT:    vor.vv v10, v11, v10
; LMULMAX1-RV32-NEXT:    vor.vv v9, v10, v9
; LMULMAX1-RV32-NEXT:    li a5, 255
; LMULMAX1-RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; LMULMAX1-RV32-NEXT:    vmv.v.x v10, a5
; LMULMAX1-RV32-NEXT:    vmerge.vim v10, v10, 0, v0
; LMULMAX1-RV32-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; LMULMAX1-RV32-NEXT:    vsll.vi v11, v8, 8
; LMULMAX1-RV32-NEXT:    vand.vv v10, v11, v10
; LMULMAX1-RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; LMULMAX1-RV32-NEXT:    vmv.v.x v11, a3
; LMULMAX1-RV32-NEXT:    vmerge.vim v11, v11, 0, v0
; LMULMAX1-RV32-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; LMULMAX1-RV32-NEXT:    vsll.vi v12, v8, 24
; LMULMAX1-RV32-NEXT:    vand.vv v11, v12, v11
; LMULMAX1-RV32-NEXT:    vor.vv v10, v11, v10
; LMULMAX1-RV32-NEXT:    vsll.vx v11, v8, a2
; LMULMAX1-RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; LMULMAX1-RV32-NEXT:    vmv.v.x v12, a4
; LMULMAX1-RV32-NEXT:    vmerge.vim v12, v12, 0, v0
; LMULMAX1-RV32-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; LMULMAX1-RV32-NEXT:    vand.vv v11, v11, v12
; LMULMAX1-RV32-NEXT:    vsll.vx v8, v8, a1
; LMULMAX1-RV32-NEXT:    vor.vv v8, v8, v11
; LMULMAX1-RV32-NEXT:    vor.vv v8, v8, v10
; LMULMAX1-RV32-NEXT:    vor.vv v8, v8, v9
; LMULMAX1-RV32-NEXT:    vsrl.vi v9, v8, 4
; LMULMAX1-RV32-NEXT:    lui a1, 61681
; LMULMAX1-RV32-NEXT:    addi a1, a1, -241
; LMULMAX1-RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; LMULMAX1-RV32-NEXT:    vmv.v.x v10, a1
; LMULMAX1-RV32-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; LMULMAX1-RV32-NEXT:    vand.vv v9, v9, v10
; LMULMAX1-RV32-NEXT:    vand.vv v8, v8, v10
; LMULMAX1-RV32-NEXT:    vsll.vi v8, v8, 4
; LMULMAX1-RV32-NEXT:    vor.vv v8, v9, v8
; LMULMAX1-RV32-NEXT:    vsrl.vi v9, v8, 2
; LMULMAX1-RV32-NEXT:    lui a1, 209715
; LMULMAX1-RV32-NEXT:    addi a1, a1, 819
; LMULMAX1-RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; LMULMAX1-RV32-NEXT:    vmv.v.x v10, a1
; LMULMAX1-RV32-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; LMULMAX1-RV32-NEXT:    vand.vv v9, v9, v10
; LMULMAX1-RV32-NEXT:    vand.vv v8, v8, v10
; LMULMAX1-RV32-NEXT:    vsll.vi v8, v8, 2
; LMULMAX1-RV32-NEXT:    vor.vv v8, v9, v8
; LMULMAX1-RV32-NEXT:    vsrl.vi v9, v8, 1
; LMULMAX1-RV32-NEXT:    lui a1, 349525
; LMULMAX1-RV32-NEXT:    addi a1, a1, 1365
; LMULMAX1-RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; LMULMAX1-RV32-NEXT:    vmv.v.x v10, a1
; LMULMAX1-RV32-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; LMULMAX1-RV32-NEXT:    vand.vv v9, v9, v10
; LMULMAX1-RV32-NEXT:    vand.vv v8, v8, v10
; LMULMAX1-RV32-NEXT:    vadd.vv v8, v8, v8
; LMULMAX1-RV32-NEXT:    vor.vv v8, v9, v8
; LMULMAX1-RV32-NEXT:    vse64.v v8, (a0)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: bitreverse_v2i64:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; LMULMAX1-RV64-NEXT:    vle64.v v8, (a0)
; LMULMAX1-RV64-NEXT:    li a1, 56
; LMULMAX1-RV64-NEXT:    vsrl.vx v9, v8, a1
; LMULMAX1-RV64-NEXT:    li a2, 40
; LMULMAX1-RV64-NEXT:    vsrl.vx v10, v8, a2
; LMULMAX1-RV64-NEXT:    lui a3, 16
; LMULMAX1-RV64-NEXT:    addiw a3, a3, -256
; LMULMAX1-RV64-NEXT:    vand.vx v10, v10, a3
; LMULMAX1-RV64-NEXT:    vor.vv v9, v10, v9
; LMULMAX1-RV64-NEXT:    vsrl.vi v10, v8, 24
; LMULMAX1-RV64-NEXT:    lui a3, 4080
; LMULMAX1-RV64-NEXT:    vand.vx v10, v10, a3
; LMULMAX1-RV64-NEXT:    vsrl.vi v11, v8, 8
; LMULMAX1-RV64-NEXT:    li a3, 255
; LMULMAX1-RV64-NEXT:    slli a4, a3, 24
; LMULMAX1-RV64-NEXT:    vand.vx v11, v11, a4
; LMULMAX1-RV64-NEXT:    vor.vv v10, v11, v10
; LMULMAX1-RV64-NEXT:    vor.vv v9, v10, v9
; LMULMAX1-RV64-NEXT:    vsll.vi v10, v8, 8
; LMULMAX1-RV64-NEXT:    slli a4, a3, 32
; LMULMAX1-RV64-NEXT:    vand.vx v10, v10, a4
; LMULMAX1-RV64-NEXT:    vsll.vi v11, v8, 24
; LMULMAX1-RV64-NEXT:    slli a4, a3, 40
; LMULMAX1-RV64-NEXT:    vand.vx v11, v11, a4
; LMULMAX1-RV64-NEXT:    vor.vv v10, v11, v10
; LMULMAX1-RV64-NEXT:    vsll.vx v11, v8, a1
; LMULMAX1-RV64-NEXT:    vsll.vx v8, v8, a2
; LMULMAX1-RV64-NEXT:    slli a1, a3, 48
; LMULMAX1-RV64-NEXT:    vand.vx v8, v8, a1
; LMULMAX1-RV64-NEXT:    vor.vv v8, v11, v8
; LMULMAX1-RV64-NEXT:    lui a1, %hi(.LCPI2_0)
; LMULMAX1-RV64-NEXT:    ld a1, %lo(.LCPI2_0)(a1)
; LMULMAX1-RV64-NEXT:    vor.vv v8, v8, v10
; LMULMAX1-RV64-NEXT:    vor.vv v8, v8, v9
; LMULMAX1-RV64-NEXT:    vsrl.vi v9, v8, 4
; LMULMAX1-RV64-NEXT:    vand.vx v9, v9, a1
; LMULMAX1-RV64-NEXT:    vand.vx v8, v8, a1
; LMULMAX1-RV64-NEXT:    lui a1, %hi(.LCPI2_1)
; LMULMAX1-RV64-NEXT:    ld a1, %lo(.LCPI2_1)(a1)
; LMULMAX1-RV64-NEXT:    vsll.vi v8, v8, 4
; LMULMAX1-RV64-NEXT:    vor.vv v8, v9, v8
; LMULMAX1-RV64-NEXT:    vsrl.vi v9, v8, 2
; LMULMAX1-RV64-NEXT:    vand.vx v9, v9, a1
; LMULMAX1-RV64-NEXT:    vand.vx v8, v8, a1
; LMULMAX1-RV64-NEXT:    lui a1, %hi(.LCPI2_2)
; LMULMAX1-RV64-NEXT:    ld a1, %lo(.LCPI2_2)(a1)
; LMULMAX1-RV64-NEXT:    vsll.vi v8, v8, 2
; LMULMAX1-RV64-NEXT:    vor.vv v8, v9, v8
; LMULMAX1-RV64-NEXT:    vsrl.vi v9, v8, 1
; LMULMAX1-RV64-NEXT:    vand.vx v9, v9, a1
; LMULMAX1-RV64-NEXT:    vand.vx v8, v8, a1
; LMULMAX1-RV64-NEXT:    vadd.vv v8, v8, v8
; LMULMAX1-RV64-NEXT:    vor.vv v8, v9, v8
; LMULMAX1-RV64-NEXT:    vse64.v v8, (a0)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <2 x i64>, <2 x i64>* %x
  %b = load <2 x i64>, <2 x i64>* %y
  %c = call <2 x i64> @llvm.bitreverse.v2i64(<2 x i64> %a)
  store <2 x i64> %c, <2 x i64>* %x
  ret void
}
declare <2 x i64> @llvm.bitreverse.v2i64(<2 x i64>)

define void @bitreverse_v16i16(<16 x i16>* %x, <16 x i16>* %y) {
; LMULMAX2-RV32-LABEL: bitreverse_v16i16:
; LMULMAX2-RV32:       # %bb.0:
; LMULMAX2-RV32-NEXT:    vsetivli zero, 16, e16, m2, ta, mu
; LMULMAX2-RV32-NEXT:    vle16.v v8, (a0)
; LMULMAX2-RV32-NEXT:    vsrl.vi v10, v8, 8
; LMULMAX2-RV32-NEXT:    vsll.vi v8, v8, 8
; LMULMAX2-RV32-NEXT:    vor.vv v8, v8, v10
; LMULMAX2-RV32-NEXT:    vsrl.vi v10, v8, 4
; LMULMAX2-RV32-NEXT:    lui a1, 1
; LMULMAX2-RV32-NEXT:    addi a1, a1, -241
; LMULMAX2-RV32-NEXT:    vand.vx v10, v10, a1
; LMULMAX2-RV32-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV32-NEXT:    vsll.vi v8, v8, 4
; LMULMAX2-RV32-NEXT:    vor.vv v8, v10, v8
; LMULMAX2-RV32-NEXT:    vsrl.vi v10, v8, 2
; LMULMAX2-RV32-NEXT:    lui a1, 3
; LMULMAX2-RV32-NEXT:    addi a1, a1, 819
; LMULMAX2-RV32-NEXT:    vand.vx v10, v10, a1
; LMULMAX2-RV32-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV32-NEXT:    vsll.vi v8, v8, 2
; LMULMAX2-RV32-NEXT:    vor.vv v8, v10, v8
; LMULMAX2-RV32-NEXT:    vsrl.vi v10, v8, 1
; LMULMAX2-RV32-NEXT:    lui a1, 5
; LMULMAX2-RV32-NEXT:    addi a1, a1, 1365
; LMULMAX2-RV32-NEXT:    vand.vx v10, v10, a1
; LMULMAX2-RV32-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV32-NEXT:    vadd.vv v8, v8, v8
; LMULMAX2-RV32-NEXT:    vor.vv v8, v10, v8
; LMULMAX2-RV32-NEXT:    vse16.v v8, (a0)
; LMULMAX2-RV32-NEXT:    ret
;
; LMULMAX2-RV64-LABEL: bitreverse_v16i16:
; LMULMAX2-RV64:       # %bb.0:
; LMULMAX2-RV64-NEXT:    vsetivli zero, 16, e16, m2, ta, mu
; LMULMAX2-RV64-NEXT:    vle16.v v8, (a0)
; LMULMAX2-RV64-NEXT:    vsrl.vi v10, v8, 8
; LMULMAX2-RV64-NEXT:    vsll.vi v8, v8, 8
; LMULMAX2-RV64-NEXT:    vor.vv v8, v8, v10
; LMULMAX2-RV64-NEXT:    vsrl.vi v10, v8, 4
; LMULMAX2-RV64-NEXT:    lui a1, 1
; LMULMAX2-RV64-NEXT:    addiw a1, a1, -241
; LMULMAX2-RV64-NEXT:    vand.vx v10, v10, a1
; LMULMAX2-RV64-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV64-NEXT:    vsll.vi v8, v8, 4
; LMULMAX2-RV64-NEXT:    vor.vv v8, v10, v8
; LMULMAX2-RV64-NEXT:    vsrl.vi v10, v8, 2
; LMULMAX2-RV64-NEXT:    lui a1, 3
; LMULMAX2-RV64-NEXT:    addiw a1, a1, 819
; LMULMAX2-RV64-NEXT:    vand.vx v10, v10, a1
; LMULMAX2-RV64-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV64-NEXT:    vsll.vi v8, v8, 2
; LMULMAX2-RV64-NEXT:    vor.vv v8, v10, v8
; LMULMAX2-RV64-NEXT:    vsrl.vi v10, v8, 1
; LMULMAX2-RV64-NEXT:    lui a1, 5
; LMULMAX2-RV64-NEXT:    addiw a1, a1, 1365
; LMULMAX2-RV64-NEXT:    vand.vx v10, v10, a1
; LMULMAX2-RV64-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV64-NEXT:    vadd.vv v8, v8, v8
; LMULMAX2-RV64-NEXT:    vor.vv v8, v10, v8
; LMULMAX2-RV64-NEXT:    vse16.v v8, (a0)
; LMULMAX2-RV64-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: bitreverse_v16i16:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; LMULMAX1-RV32-NEXT:    addi a1, a0, 16
; LMULMAX1-RV32-NEXT:    vle16.v v8, (a1)
; LMULMAX1-RV32-NEXT:    vle16.v v9, (a0)
; LMULMAX1-RV32-NEXT:    vsrl.vi v10, v8, 8
; LMULMAX1-RV32-NEXT:    vsll.vi v8, v8, 8
; LMULMAX1-RV32-NEXT:    vor.vv v8, v8, v10
; LMULMAX1-RV32-NEXT:    vsrl.vi v10, v8, 4
; LMULMAX1-RV32-NEXT:    lui a2, 1
; LMULMAX1-RV32-NEXT:    addi a2, a2, -241
; LMULMAX1-RV32-NEXT:    vand.vx v10, v10, a2
; LMULMAX1-RV32-NEXT:    vand.vx v8, v8, a2
; LMULMAX1-RV32-NEXT:    vsll.vi v8, v8, 4
; LMULMAX1-RV32-NEXT:    vor.vv v8, v10, v8
; LMULMAX1-RV32-NEXT:    vsrl.vi v10, v8, 2
; LMULMAX1-RV32-NEXT:    lui a3, 3
; LMULMAX1-RV32-NEXT:    addi a3, a3, 819
; LMULMAX1-RV32-NEXT:    vand.vx v10, v10, a3
; LMULMAX1-RV32-NEXT:    vand.vx v8, v8, a3
; LMULMAX1-RV32-NEXT:    vsll.vi v8, v8, 2
; LMULMAX1-RV32-NEXT:    vor.vv v8, v10, v8
; LMULMAX1-RV32-NEXT:    vsrl.vi v10, v8, 1
; LMULMAX1-RV32-NEXT:    lui a4, 5
; LMULMAX1-RV32-NEXT:    addi a4, a4, 1365
; LMULMAX1-RV32-NEXT:    vand.vx v10, v10, a4
; LMULMAX1-RV32-NEXT:    vand.vx v8, v8, a4
; LMULMAX1-RV32-NEXT:    vadd.vv v8, v8, v8
; LMULMAX1-RV32-NEXT:    vor.vv v8, v10, v8
; LMULMAX1-RV32-NEXT:    vsrl.vi v10, v9, 8
; LMULMAX1-RV32-NEXT:    vsll.vi v9, v9, 8
; LMULMAX1-RV32-NEXT:    vor.vv v9, v9, v10
; LMULMAX1-RV32-NEXT:    vsrl.vi v10, v9, 4
; LMULMAX1-RV32-NEXT:    vand.vx v10, v10, a2
; LMULMAX1-RV32-NEXT:    vand.vx v9, v9, a2
; LMULMAX1-RV32-NEXT:    vsll.vi v9, v9, 4
; LMULMAX1-RV32-NEXT:    vor.vv v9, v10, v9
; LMULMAX1-RV32-NEXT:    vsrl.vi v10, v9, 2
; LMULMAX1-RV32-NEXT:    vand.vx v10, v10, a3
; LMULMAX1-RV32-NEXT:    vand.vx v9, v9, a3
; LMULMAX1-RV32-NEXT:    vsll.vi v9, v9, 2
; LMULMAX1-RV32-NEXT:    vor.vv v9, v10, v9
; LMULMAX1-RV32-NEXT:    vsrl.vi v10, v9, 1
; LMULMAX1-RV32-NEXT:    vand.vx v10, v10, a4
; LMULMAX1-RV32-NEXT:    vand.vx v9, v9, a4
; LMULMAX1-RV32-NEXT:    vadd.vv v9, v9, v9
; LMULMAX1-RV32-NEXT:    vor.vv v9, v10, v9
; LMULMAX1-RV32-NEXT:    vse16.v v9, (a0)
; LMULMAX1-RV32-NEXT:    vse16.v v8, (a1)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: bitreverse_v16i16:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli zero, 8, e16, m1, ta, mu
; LMULMAX1-RV64-NEXT:    addi a1, a0, 16
; LMULMAX1-RV64-NEXT:    vle16.v v8, (a1)
; LMULMAX1-RV64-NEXT:    vle16.v v9, (a0)
; LMULMAX1-RV64-NEXT:    vsrl.vi v10, v8, 8
; LMULMAX1-RV64-NEXT:    vsll.vi v8, v8, 8
; LMULMAX1-RV64-NEXT:    vor.vv v8, v8, v10
; LMULMAX1-RV64-NEXT:    vsrl.vi v10, v8, 4
; LMULMAX1-RV64-NEXT:    lui a2, 1
; LMULMAX1-RV64-NEXT:    addiw a2, a2, -241
; LMULMAX1-RV64-NEXT:    vand.vx v10, v10, a2
; LMULMAX1-RV64-NEXT:    vand.vx v8, v8, a2
; LMULMAX1-RV64-NEXT:    vsll.vi v8, v8, 4
; LMULMAX1-RV64-NEXT:    vor.vv v8, v10, v8
; LMULMAX1-RV64-NEXT:    vsrl.vi v10, v8, 2
; LMULMAX1-RV64-NEXT:    lui a3, 3
; LMULMAX1-RV64-NEXT:    addiw a3, a3, 819
; LMULMAX1-RV64-NEXT:    vand.vx v10, v10, a3
; LMULMAX1-RV64-NEXT:    vand.vx v8, v8, a3
; LMULMAX1-RV64-NEXT:    vsll.vi v8, v8, 2
; LMULMAX1-RV64-NEXT:    vor.vv v8, v10, v8
; LMULMAX1-RV64-NEXT:    vsrl.vi v10, v8, 1
; LMULMAX1-RV64-NEXT:    lui a4, 5
; LMULMAX1-RV64-NEXT:    addiw a4, a4, 1365
; LMULMAX1-RV64-NEXT:    vand.vx v10, v10, a4
; LMULMAX1-RV64-NEXT:    vand.vx v8, v8, a4
; LMULMAX1-RV64-NEXT:    vadd.vv v8, v8, v8
; LMULMAX1-RV64-NEXT:    vor.vv v8, v10, v8
; LMULMAX1-RV64-NEXT:    vsrl.vi v10, v9, 8
; LMULMAX1-RV64-NEXT:    vsll.vi v9, v9, 8
; LMULMAX1-RV64-NEXT:    vor.vv v9, v9, v10
; LMULMAX1-RV64-NEXT:    vsrl.vi v10, v9, 4
; LMULMAX1-RV64-NEXT:    vand.vx v10, v10, a2
; LMULMAX1-RV64-NEXT:    vand.vx v9, v9, a2
; LMULMAX1-RV64-NEXT:    vsll.vi v9, v9, 4
; LMULMAX1-RV64-NEXT:    vor.vv v9, v10, v9
; LMULMAX1-RV64-NEXT:    vsrl.vi v10, v9, 2
; LMULMAX1-RV64-NEXT:    vand.vx v10, v10, a3
; LMULMAX1-RV64-NEXT:    vand.vx v9, v9, a3
; LMULMAX1-RV64-NEXT:    vsll.vi v9, v9, 2
; LMULMAX1-RV64-NEXT:    vor.vv v9, v10, v9
; LMULMAX1-RV64-NEXT:    vsrl.vi v10, v9, 1
; LMULMAX1-RV64-NEXT:    vand.vx v10, v10, a4
; LMULMAX1-RV64-NEXT:    vand.vx v9, v9, a4
; LMULMAX1-RV64-NEXT:    vadd.vv v9, v9, v9
; LMULMAX1-RV64-NEXT:    vor.vv v9, v10, v9
; LMULMAX1-RV64-NEXT:    vse16.v v9, (a0)
; LMULMAX1-RV64-NEXT:    vse16.v v8, (a1)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <16 x i16>, <16 x i16>* %x
  %b = load <16 x i16>, <16 x i16>* %y
  %c = call <16 x i16> @llvm.bitreverse.v16i16(<16 x i16> %a)
  store <16 x i16> %c, <16 x i16>* %x
  ret void
}
declare <16 x i16> @llvm.bitreverse.v16i16(<16 x i16>)

define void @bitreverse_v8i32(<8 x i32>* %x, <8 x i32>* %y) {
; LMULMAX2-RV32-LABEL: bitreverse_v8i32:
; LMULMAX2-RV32:       # %bb.0:
; LMULMAX2-RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; LMULMAX2-RV32-NEXT:    vle32.v v8, (a0)
; LMULMAX2-RV32-NEXT:    vsrl.vi v10, v8, 8
; LMULMAX2-RV32-NEXT:    lui a1, 16
; LMULMAX2-RV32-NEXT:    addi a1, a1, -256
; LMULMAX2-RV32-NEXT:    vand.vx v10, v10, a1
; LMULMAX2-RV32-NEXT:    vsrl.vi v12, v8, 24
; LMULMAX2-RV32-NEXT:    vor.vv v10, v10, v12
; LMULMAX2-RV32-NEXT:    vsll.vi v12, v8, 8
; LMULMAX2-RV32-NEXT:    lui a1, 4080
; LMULMAX2-RV32-NEXT:    vand.vx v12, v12, a1
; LMULMAX2-RV32-NEXT:    vsll.vi v8, v8, 24
; LMULMAX2-RV32-NEXT:    vor.vv v8, v8, v12
; LMULMAX2-RV32-NEXT:    vor.vv v8, v8, v10
; LMULMAX2-RV32-NEXT:    vsrl.vi v10, v8, 4
; LMULMAX2-RV32-NEXT:    lui a1, 61681
; LMULMAX2-RV32-NEXT:    addi a1, a1, -241
; LMULMAX2-RV32-NEXT:    vand.vx v10, v10, a1
; LMULMAX2-RV32-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV32-NEXT:    vsll.vi v8, v8, 4
; LMULMAX2-RV32-NEXT:    vor.vv v8, v10, v8
; LMULMAX2-RV32-NEXT:    vsrl.vi v10, v8, 2
; LMULMAX2-RV32-NEXT:    lui a1, 209715
; LMULMAX2-RV32-NEXT:    addi a1, a1, 819
; LMULMAX2-RV32-NEXT:    vand.vx v10, v10, a1
; LMULMAX2-RV32-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV32-NEXT:    vsll.vi v8, v8, 2
; LMULMAX2-RV32-NEXT:    vor.vv v8, v10, v8
; LMULMAX2-RV32-NEXT:    vsrl.vi v10, v8, 1
; LMULMAX2-RV32-NEXT:    lui a1, 349525
; LMULMAX2-RV32-NEXT:    addi a1, a1, 1365
; LMULMAX2-RV32-NEXT:    vand.vx v10, v10, a1
; LMULMAX2-RV32-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV32-NEXT:    vadd.vv v8, v8, v8
; LMULMAX2-RV32-NEXT:    vor.vv v8, v10, v8
; LMULMAX2-RV32-NEXT:    vse32.v v8, (a0)
; LMULMAX2-RV32-NEXT:    ret
;
; LMULMAX2-RV64-LABEL: bitreverse_v8i32:
; LMULMAX2-RV64:       # %bb.0:
; LMULMAX2-RV64-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; LMULMAX2-RV64-NEXT:    vle32.v v8, (a0)
; LMULMAX2-RV64-NEXT:    vsrl.vi v10, v8, 8
; LMULMAX2-RV64-NEXT:    lui a1, 16
; LMULMAX2-RV64-NEXT:    addiw a1, a1, -256
; LMULMAX2-RV64-NEXT:    vand.vx v10, v10, a1
; LMULMAX2-RV64-NEXT:    vsrl.vi v12, v8, 24
; LMULMAX2-RV64-NEXT:    vor.vv v10, v10, v12
; LMULMAX2-RV64-NEXT:    vsll.vi v12, v8, 8
; LMULMAX2-RV64-NEXT:    lui a1, 4080
; LMULMAX2-RV64-NEXT:    vand.vx v12, v12, a1
; LMULMAX2-RV64-NEXT:    vsll.vi v8, v8, 24
; LMULMAX2-RV64-NEXT:    vor.vv v8, v8, v12
; LMULMAX2-RV64-NEXT:    vor.vv v8, v8, v10
; LMULMAX2-RV64-NEXT:    vsrl.vi v10, v8, 4
; LMULMAX2-RV64-NEXT:    lui a1, 61681
; LMULMAX2-RV64-NEXT:    addiw a1, a1, -241
; LMULMAX2-RV64-NEXT:    vand.vx v10, v10, a1
; LMULMAX2-RV64-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV64-NEXT:    vsll.vi v8, v8, 4
; LMULMAX2-RV64-NEXT:    vor.vv v8, v10, v8
; LMULMAX2-RV64-NEXT:    vsrl.vi v10, v8, 2
; LMULMAX2-RV64-NEXT:    lui a1, 209715
; LMULMAX2-RV64-NEXT:    addiw a1, a1, 819
; LMULMAX2-RV64-NEXT:    vand.vx v10, v10, a1
; LMULMAX2-RV64-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV64-NEXT:    vsll.vi v8, v8, 2
; LMULMAX2-RV64-NEXT:    vor.vv v8, v10, v8
; LMULMAX2-RV64-NEXT:    vsrl.vi v10, v8, 1
; LMULMAX2-RV64-NEXT:    lui a1, 349525
; LMULMAX2-RV64-NEXT:    addiw a1, a1, 1365
; LMULMAX2-RV64-NEXT:    vand.vx v10, v10, a1
; LMULMAX2-RV64-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV64-NEXT:    vadd.vv v8, v8, v8
; LMULMAX2-RV64-NEXT:    vor.vv v8, v10, v8
; LMULMAX2-RV64-NEXT:    vse32.v v8, (a0)
; LMULMAX2-RV64-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: bitreverse_v8i32:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; LMULMAX1-RV32-NEXT:    addi a1, a0, 16
; LMULMAX1-RV32-NEXT:    vle32.v v8, (a1)
; LMULMAX1-RV32-NEXT:    vle32.v v9, (a0)
; LMULMAX1-RV32-NEXT:    vsrl.vi v10, v8, 8
; LMULMAX1-RV32-NEXT:    lui a2, 16
; LMULMAX1-RV32-NEXT:    addi a2, a2, -256
; LMULMAX1-RV32-NEXT:    vand.vx v10, v10, a2
; LMULMAX1-RV32-NEXT:    vsrl.vi v11, v8, 24
; LMULMAX1-RV32-NEXT:    vor.vv v10, v10, v11
; LMULMAX1-RV32-NEXT:    vsll.vi v11, v8, 8
; LMULMAX1-RV32-NEXT:    lui a3, 4080
; LMULMAX1-RV32-NEXT:    vand.vx v11, v11, a3
; LMULMAX1-RV32-NEXT:    vsll.vi v8, v8, 24
; LMULMAX1-RV32-NEXT:    vor.vv v8, v8, v11
; LMULMAX1-RV32-NEXT:    vor.vv v8, v8, v10
; LMULMAX1-RV32-NEXT:    vsrl.vi v10, v8, 4
; LMULMAX1-RV32-NEXT:    lui a4, 61681
; LMULMAX1-RV32-NEXT:    addi a4, a4, -241
; LMULMAX1-RV32-NEXT:    vand.vx v10, v10, a4
; LMULMAX1-RV32-NEXT:    vand.vx v8, v8, a4
; LMULMAX1-RV32-NEXT:    vsll.vi v8, v8, 4
; LMULMAX1-RV32-NEXT:    vor.vv v8, v10, v8
; LMULMAX1-RV32-NEXT:    vsrl.vi v10, v8, 2
; LMULMAX1-RV32-NEXT:    lui a5, 209715
; LMULMAX1-RV32-NEXT:    addi a5, a5, 819
; LMULMAX1-RV32-NEXT:    vand.vx v10, v10, a5
; LMULMAX1-RV32-NEXT:    vand.vx v8, v8, a5
; LMULMAX1-RV32-NEXT:    vsll.vi v8, v8, 2
; LMULMAX1-RV32-NEXT:    vor.vv v8, v10, v8
; LMULMAX1-RV32-NEXT:    vsrl.vi v10, v8, 1
; LMULMAX1-RV32-NEXT:    lui a6, 349525
; LMULMAX1-RV32-NEXT:    addi a6, a6, 1365
; LMULMAX1-RV32-NEXT:    vand.vx v10, v10, a6
; LMULMAX1-RV32-NEXT:    vand.vx v8, v8, a6
; LMULMAX1-RV32-NEXT:    vadd.vv v8, v8, v8
; LMULMAX1-RV32-NEXT:    vor.vv v8, v10, v8
; LMULMAX1-RV32-NEXT:    vsrl.vi v10, v9, 8
; LMULMAX1-RV32-NEXT:    vand.vx v10, v10, a2
; LMULMAX1-RV32-NEXT:    vsrl.vi v11, v9, 24
; LMULMAX1-RV32-NEXT:    vor.vv v10, v10, v11
; LMULMAX1-RV32-NEXT:    vsll.vi v11, v9, 8
; LMULMAX1-RV32-NEXT:    vand.vx v11, v11, a3
; LMULMAX1-RV32-NEXT:    vsll.vi v9, v9, 24
; LMULMAX1-RV32-NEXT:    vor.vv v9, v9, v11
; LMULMAX1-RV32-NEXT:    vor.vv v9, v9, v10
; LMULMAX1-RV32-NEXT:    vsrl.vi v10, v9, 4
; LMULMAX1-RV32-NEXT:    vand.vx v10, v10, a4
; LMULMAX1-RV32-NEXT:    vand.vx v9, v9, a4
; LMULMAX1-RV32-NEXT:    vsll.vi v9, v9, 4
; LMULMAX1-RV32-NEXT:    vor.vv v9, v10, v9
; LMULMAX1-RV32-NEXT:    vsrl.vi v10, v9, 2
; LMULMAX1-RV32-NEXT:    vand.vx v10, v10, a5
; LMULMAX1-RV32-NEXT:    vand.vx v9, v9, a5
; LMULMAX1-RV32-NEXT:    vsll.vi v9, v9, 2
; LMULMAX1-RV32-NEXT:    vor.vv v9, v10, v9
; LMULMAX1-RV32-NEXT:    vsrl.vi v10, v9, 1
; LMULMAX1-RV32-NEXT:    vand.vx v10, v10, a6
; LMULMAX1-RV32-NEXT:    vand.vx v9, v9, a6
; LMULMAX1-RV32-NEXT:    vadd.vv v9, v9, v9
; LMULMAX1-RV32-NEXT:    vor.vv v9, v10, v9
; LMULMAX1-RV32-NEXT:    vse32.v v9, (a0)
; LMULMAX1-RV32-NEXT:    vse32.v v8, (a1)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: bitreverse_v8i32:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; LMULMAX1-RV64-NEXT:    addi a1, a0, 16
; LMULMAX1-RV64-NEXT:    vle32.v v8, (a1)
; LMULMAX1-RV64-NEXT:    vle32.v v9, (a0)
; LMULMAX1-RV64-NEXT:    vsrl.vi v10, v8, 8
; LMULMAX1-RV64-NEXT:    lui a2, 16
; LMULMAX1-RV64-NEXT:    addiw a2, a2, -256
; LMULMAX1-RV64-NEXT:    vand.vx v10, v10, a2
; LMULMAX1-RV64-NEXT:    vsrl.vi v11, v8, 24
; LMULMAX1-RV64-NEXT:    vor.vv v10, v10, v11
; LMULMAX1-RV64-NEXT:    vsll.vi v11, v8, 8
; LMULMAX1-RV64-NEXT:    lui a3, 4080
; LMULMAX1-RV64-NEXT:    vand.vx v11, v11, a3
; LMULMAX1-RV64-NEXT:    vsll.vi v8, v8, 24
; LMULMAX1-RV64-NEXT:    vor.vv v8, v8, v11
; LMULMAX1-RV64-NEXT:    vor.vv v8, v8, v10
; LMULMAX1-RV64-NEXT:    vsrl.vi v10, v8, 4
; LMULMAX1-RV64-NEXT:    lui a4, 61681
; LMULMAX1-RV64-NEXT:    addiw a4, a4, -241
; LMULMAX1-RV64-NEXT:    vand.vx v10, v10, a4
; LMULMAX1-RV64-NEXT:    vand.vx v8, v8, a4
; LMULMAX1-RV64-NEXT:    vsll.vi v8, v8, 4
; LMULMAX1-RV64-NEXT:    vor.vv v8, v10, v8
; LMULMAX1-RV64-NEXT:    vsrl.vi v10, v8, 2
; LMULMAX1-RV64-NEXT:    lui a5, 209715
; LMULMAX1-RV64-NEXT:    addiw a5, a5, 819
; LMULMAX1-RV64-NEXT:    vand.vx v10, v10, a5
; LMULMAX1-RV64-NEXT:    vand.vx v8, v8, a5
; LMULMAX1-RV64-NEXT:    vsll.vi v8, v8, 2
; LMULMAX1-RV64-NEXT:    vor.vv v8, v10, v8
; LMULMAX1-RV64-NEXT:    vsrl.vi v10, v8, 1
; LMULMAX1-RV64-NEXT:    lui a6, 349525
; LMULMAX1-RV64-NEXT:    addiw a6, a6, 1365
; LMULMAX1-RV64-NEXT:    vand.vx v10, v10, a6
; LMULMAX1-RV64-NEXT:    vand.vx v8, v8, a6
; LMULMAX1-RV64-NEXT:    vadd.vv v8, v8, v8
; LMULMAX1-RV64-NEXT:    vor.vv v8, v10, v8
; LMULMAX1-RV64-NEXT:    vsrl.vi v10, v9, 8
; LMULMAX1-RV64-NEXT:    vand.vx v10, v10, a2
; LMULMAX1-RV64-NEXT:    vsrl.vi v11, v9, 24
; LMULMAX1-RV64-NEXT:    vor.vv v10, v10, v11
; LMULMAX1-RV64-NEXT:    vsll.vi v11, v9, 8
; LMULMAX1-RV64-NEXT:    vand.vx v11, v11, a3
; LMULMAX1-RV64-NEXT:    vsll.vi v9, v9, 24
; LMULMAX1-RV64-NEXT:    vor.vv v9, v9, v11
; LMULMAX1-RV64-NEXT:    vor.vv v9, v9, v10
; LMULMAX1-RV64-NEXT:    vsrl.vi v10, v9, 4
; LMULMAX1-RV64-NEXT:    vand.vx v10, v10, a4
; LMULMAX1-RV64-NEXT:    vand.vx v9, v9, a4
; LMULMAX1-RV64-NEXT:    vsll.vi v9, v9, 4
; LMULMAX1-RV64-NEXT:    vor.vv v9, v10, v9
; LMULMAX1-RV64-NEXT:    vsrl.vi v10, v9, 2
; LMULMAX1-RV64-NEXT:    vand.vx v10, v10, a5
; LMULMAX1-RV64-NEXT:    vand.vx v9, v9, a5
; LMULMAX1-RV64-NEXT:    vsll.vi v9, v9, 2
; LMULMAX1-RV64-NEXT:    vor.vv v9, v10, v9
; LMULMAX1-RV64-NEXT:    vsrl.vi v10, v9, 1
; LMULMAX1-RV64-NEXT:    vand.vx v10, v10, a6
; LMULMAX1-RV64-NEXT:    vand.vx v9, v9, a6
; LMULMAX1-RV64-NEXT:    vadd.vv v9, v9, v9
; LMULMAX1-RV64-NEXT:    vor.vv v9, v10, v9
; LMULMAX1-RV64-NEXT:    vse32.v v9, (a0)
; LMULMAX1-RV64-NEXT:    vse32.v v8, (a1)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <8 x i32>, <8 x i32>* %x
  %b = load <8 x i32>, <8 x i32>* %y
  %c = call <8 x i32> @llvm.bitreverse.v8i32(<8 x i32> %a)
  store <8 x i32> %c, <8 x i32>* %x
  ret void
}
declare <8 x i32> @llvm.bitreverse.v8i32(<8 x i32>)

define void @bitreverse_v4i64(<4 x i64>* %x, <4 x i64>* %y) {
; LMULMAX2-RV32-LABEL: bitreverse_v4i64:
; LMULMAX2-RV32:       # %bb.0:
; LMULMAX2-RV32-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; LMULMAX2-RV32-NEXT:    vle64.v v8, (a0)
; LMULMAX2-RV32-NEXT:    li a1, 56
; LMULMAX2-RV32-NEXT:    vsrl.vx v10, v8, a1
; LMULMAX2-RV32-NEXT:    li a2, 40
; LMULMAX2-RV32-NEXT:    vsrl.vx v12, v8, a2
; LMULMAX2-RV32-NEXT:    lui a3, 16
; LMULMAX2-RV32-NEXT:    addi a3, a3, -256
; LMULMAX2-RV32-NEXT:    vand.vx v12, v12, a3
; LMULMAX2-RV32-NEXT:    vor.vv v10, v12, v10
; LMULMAX2-RV32-NEXT:    vsrl.vi v12, v8, 24
; LMULMAX2-RV32-NEXT:    lui a4, 4080
; LMULMAX2-RV32-NEXT:    vand.vx v12, v12, a4
; LMULMAX2-RV32-NEXT:    li a5, 85
; LMULMAX2-RV32-NEXT:    vsetivli zero, 1, e8, mf8, ta, mu
; LMULMAX2-RV32-NEXT:    vmv.s.x v0, a5
; LMULMAX2-RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; LMULMAX2-RV32-NEXT:    vmv.v.i v14, 0
; LMULMAX2-RV32-NEXT:    lui a5, 1044480
; LMULMAX2-RV32-NEXT:    vmerge.vxm v14, v14, a5, v0
; LMULMAX2-RV32-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; LMULMAX2-RV32-NEXT:    vsrl.vi v16, v8, 8
; LMULMAX2-RV32-NEXT:    vand.vv v14, v16, v14
; LMULMAX2-RV32-NEXT:    vor.vv v12, v14, v12
; LMULMAX2-RV32-NEXT:    vor.vv v10, v12, v10
; LMULMAX2-RV32-NEXT:    li a5, 255
; LMULMAX2-RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; LMULMAX2-RV32-NEXT:    vmv.v.x v12, a5
; LMULMAX2-RV32-NEXT:    vmerge.vim v12, v12, 0, v0
; LMULMAX2-RV32-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; LMULMAX2-RV32-NEXT:    vsll.vi v14, v8, 8
; LMULMAX2-RV32-NEXT:    vand.vv v12, v14, v12
; LMULMAX2-RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; LMULMAX2-RV32-NEXT:    vmv.v.x v14, a3
; LMULMAX2-RV32-NEXT:    vmerge.vim v14, v14, 0, v0
; LMULMAX2-RV32-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; LMULMAX2-RV32-NEXT:    vsll.vi v16, v8, 24
; LMULMAX2-RV32-NEXT:    vand.vv v14, v16, v14
; LMULMAX2-RV32-NEXT:    vor.vv v12, v14, v12
; LMULMAX2-RV32-NEXT:    vsll.vx v14, v8, a2
; LMULMAX2-RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; LMULMAX2-RV32-NEXT:    vmv.v.x v16, a4
; LMULMAX2-RV32-NEXT:    vmerge.vim v16, v16, 0, v0
; LMULMAX2-RV32-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; LMULMAX2-RV32-NEXT:    vand.vv v14, v14, v16
; LMULMAX2-RV32-NEXT:    vsll.vx v8, v8, a1
; LMULMAX2-RV32-NEXT:    vor.vv v8, v8, v14
; LMULMAX2-RV32-NEXT:    vor.vv v8, v8, v12
; LMULMAX2-RV32-NEXT:    vor.vv v8, v8, v10
; LMULMAX2-RV32-NEXT:    vsrl.vi v10, v8, 4
; LMULMAX2-RV32-NEXT:    lui a1, 61681
; LMULMAX2-RV32-NEXT:    addi a1, a1, -241
; LMULMAX2-RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; LMULMAX2-RV32-NEXT:    vmv.v.x v12, a1
; LMULMAX2-RV32-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; LMULMAX2-RV32-NEXT:    vand.vv v10, v10, v12
; LMULMAX2-RV32-NEXT:    vand.vv v8, v8, v12
; LMULMAX2-RV32-NEXT:    vsll.vi v8, v8, 4
; LMULMAX2-RV32-NEXT:    vor.vv v8, v10, v8
; LMULMAX2-RV32-NEXT:    vsrl.vi v10, v8, 2
; LMULMAX2-RV32-NEXT:    lui a1, 209715
; LMULMAX2-RV32-NEXT:    addi a1, a1, 819
; LMULMAX2-RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; LMULMAX2-RV32-NEXT:    vmv.v.x v12, a1
; LMULMAX2-RV32-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; LMULMAX2-RV32-NEXT:    vand.vv v10, v10, v12
; LMULMAX2-RV32-NEXT:    vand.vv v8, v8, v12
; LMULMAX2-RV32-NEXT:    vsll.vi v8, v8, 2
; LMULMAX2-RV32-NEXT:    vor.vv v8, v10, v8
; LMULMAX2-RV32-NEXT:    vsrl.vi v10, v8, 1
; LMULMAX2-RV32-NEXT:    lui a1, 349525
; LMULMAX2-RV32-NEXT:    addi a1, a1, 1365
; LMULMAX2-RV32-NEXT:    vsetivli zero, 8, e32, m2, ta, mu
; LMULMAX2-RV32-NEXT:    vmv.v.x v12, a1
; LMULMAX2-RV32-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; LMULMAX2-RV32-NEXT:    vand.vv v10, v10, v12
; LMULMAX2-RV32-NEXT:    vand.vv v8, v8, v12
; LMULMAX2-RV32-NEXT:    vadd.vv v8, v8, v8
; LMULMAX2-RV32-NEXT:    vor.vv v8, v10, v8
; LMULMAX2-RV32-NEXT:    vse64.v v8, (a0)
; LMULMAX2-RV32-NEXT:    ret
;
; LMULMAX2-RV64-LABEL: bitreverse_v4i64:
; LMULMAX2-RV64:       # %bb.0:
; LMULMAX2-RV64-NEXT:    vsetivli zero, 4, e64, m2, ta, mu
; LMULMAX2-RV64-NEXT:    vle64.v v8, (a0)
; LMULMAX2-RV64-NEXT:    li a1, 56
; LMULMAX2-RV64-NEXT:    vsrl.vx v10, v8, a1
; LMULMAX2-RV64-NEXT:    li a2, 40
; LMULMAX2-RV64-NEXT:    vsrl.vx v12, v8, a2
; LMULMAX2-RV64-NEXT:    lui a3, 16
; LMULMAX2-RV64-NEXT:    addiw a3, a3, -256
; LMULMAX2-RV64-NEXT:    vand.vx v12, v12, a3
; LMULMAX2-RV64-NEXT:    vor.vv v10, v12, v10
; LMULMAX2-RV64-NEXT:    vsrl.vi v12, v8, 24
; LMULMAX2-RV64-NEXT:    lui a3, 4080
; LMULMAX2-RV64-NEXT:    vand.vx v12, v12, a3
; LMULMAX2-RV64-NEXT:    vsrl.vi v14, v8, 8
; LMULMAX2-RV64-NEXT:    li a3, 255
; LMULMAX2-RV64-NEXT:    slli a4, a3, 24
; LMULMAX2-RV64-NEXT:    vand.vx v14, v14, a4
; LMULMAX2-RV64-NEXT:    vor.vv v12, v14, v12
; LMULMAX2-RV64-NEXT:    vor.vv v10, v12, v10
; LMULMAX2-RV64-NEXT:    vsll.vi v12, v8, 8
; LMULMAX2-RV64-NEXT:    slli a4, a3, 32
; LMULMAX2-RV64-NEXT:    vand.vx v12, v12, a4
; LMULMAX2-RV64-NEXT:    vsll.vi v14, v8, 24
; LMULMAX2-RV64-NEXT:    slli a4, a3, 40
; LMULMAX2-RV64-NEXT:    vand.vx v14, v14, a4
; LMULMAX2-RV64-NEXT:    vor.vv v12, v14, v12
; LMULMAX2-RV64-NEXT:    vsll.vx v14, v8, a1
; LMULMAX2-RV64-NEXT:    vsll.vx v8, v8, a2
; LMULMAX2-RV64-NEXT:    slli a1, a3, 48
; LMULMAX2-RV64-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV64-NEXT:    vor.vv v8, v14, v8
; LMULMAX2-RV64-NEXT:    lui a1, %hi(.LCPI5_0)
; LMULMAX2-RV64-NEXT:    ld a1, %lo(.LCPI5_0)(a1)
; LMULMAX2-RV64-NEXT:    vor.vv v8, v8, v12
; LMULMAX2-RV64-NEXT:    vor.vv v8, v8, v10
; LMULMAX2-RV64-NEXT:    vsrl.vi v10, v8, 4
; LMULMAX2-RV64-NEXT:    vand.vx v10, v10, a1
; LMULMAX2-RV64-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV64-NEXT:    lui a1, %hi(.LCPI5_1)
; LMULMAX2-RV64-NEXT:    ld a1, %lo(.LCPI5_1)(a1)
; LMULMAX2-RV64-NEXT:    vsll.vi v8, v8, 4
; LMULMAX2-RV64-NEXT:    vor.vv v8, v10, v8
; LMULMAX2-RV64-NEXT:    vsrl.vi v10, v8, 2
; LMULMAX2-RV64-NEXT:    vand.vx v10, v10, a1
; LMULMAX2-RV64-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV64-NEXT:    lui a1, %hi(.LCPI5_2)
; LMULMAX2-RV64-NEXT:    ld a1, %lo(.LCPI5_2)(a1)
; LMULMAX2-RV64-NEXT:    vsll.vi v8, v8, 2
; LMULMAX2-RV64-NEXT:    vor.vv v8, v10, v8
; LMULMAX2-RV64-NEXT:    vsrl.vi v10, v8, 1
; LMULMAX2-RV64-NEXT:    vand.vx v10, v10, a1
; LMULMAX2-RV64-NEXT:    vand.vx v8, v8, a1
; LMULMAX2-RV64-NEXT:    vadd.vv v8, v8, v8
; LMULMAX2-RV64-NEXT:    vor.vv v8, v10, v8
; LMULMAX2-RV64-NEXT:    vse64.v v8, (a0)
; LMULMAX2-RV64-NEXT:    ret
;
; LMULMAX1-RV32-LABEL: bitreverse_v4i64:
; LMULMAX1-RV32:       # %bb.0:
; LMULMAX1-RV32-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; LMULMAX1-RV32-NEXT:    addi a1, a0, 16
; LMULMAX1-RV32-NEXT:    vle64.v v12, (a1)
; LMULMAX1-RV32-NEXT:    vle64.v v8, (a0)
; LMULMAX1-RV32-NEXT:    li a2, 56
; LMULMAX1-RV32-NEXT:    vsrl.vx v9, v12, a2
; LMULMAX1-RV32-NEXT:    li a3, 40
; LMULMAX1-RV32-NEXT:    vsrl.vx v10, v12, a3
; LMULMAX1-RV32-NEXT:    lui a4, 16
; LMULMAX1-RV32-NEXT:    addi a4, a4, -256
; LMULMAX1-RV32-NEXT:    vand.vx v10, v10, a4
; LMULMAX1-RV32-NEXT:    vor.vv v10, v10, v9
; LMULMAX1-RV32-NEXT:    vsrl.vi v9, v12, 24
; LMULMAX1-RV32-NEXT:    lui a5, 4080
; LMULMAX1-RV32-NEXT:    vand.vx v11, v9, a5
; LMULMAX1-RV32-NEXT:    li a6, 5
; LMULMAX1-RV32-NEXT:    vsetivli zero, 1, e8, mf8, ta, mu
; LMULMAX1-RV32-NEXT:    vmv.s.x v0, a6
; LMULMAX1-RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; LMULMAX1-RV32-NEXT:    vmv.v.i v9, 0
; LMULMAX1-RV32-NEXT:    lui a6, 1044480
; LMULMAX1-RV32-NEXT:    vmerge.vxm v9, v9, a6, v0
; LMULMAX1-RV32-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; LMULMAX1-RV32-NEXT:    vsrl.vi v13, v12, 8
; LMULMAX1-RV32-NEXT:    vand.vv v13, v13, v9
; LMULMAX1-RV32-NEXT:    vor.vv v11, v13, v11
; LMULMAX1-RV32-NEXT:    vor.vv v13, v11, v10
; LMULMAX1-RV32-NEXT:    li a6, 255
; LMULMAX1-RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; LMULMAX1-RV32-NEXT:    vmv.v.x v10, a6
; LMULMAX1-RV32-NEXT:    vmerge.vim v10, v10, 0, v0
; LMULMAX1-RV32-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; LMULMAX1-RV32-NEXT:    vsll.vi v11, v12, 8
; LMULMAX1-RV32-NEXT:    vand.vv v14, v11, v10
; LMULMAX1-RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; LMULMAX1-RV32-NEXT:    vmv.v.x v11, a4
; LMULMAX1-RV32-NEXT:    vmerge.vim v11, v11, 0, v0
; LMULMAX1-RV32-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; LMULMAX1-RV32-NEXT:    vsll.vi v15, v12, 24
; LMULMAX1-RV32-NEXT:    vand.vv v15, v15, v11
; LMULMAX1-RV32-NEXT:    vor.vv v14, v15, v14
; LMULMAX1-RV32-NEXT:    vsll.vx v15, v12, a3
; LMULMAX1-RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; LMULMAX1-RV32-NEXT:    vmv.v.x v16, a5
; LMULMAX1-RV32-NEXT:    vmerge.vim v16, v16, 0, v0
; LMULMAX1-RV32-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; LMULMAX1-RV32-NEXT:    vand.vv v15, v15, v16
; LMULMAX1-RV32-NEXT:    vsll.vx v12, v12, a2
; LMULMAX1-RV32-NEXT:    vor.vv v12, v12, v15
; LMULMAX1-RV32-NEXT:    vor.vv v12, v12, v14
; LMULMAX1-RV32-NEXT:    vor.vv v12, v12, v13
; LMULMAX1-RV32-NEXT:    vsrl.vi v13, v12, 4
; LMULMAX1-RV32-NEXT:    lui a6, 61681
; LMULMAX1-RV32-NEXT:    addi a6, a6, -241
; LMULMAX1-RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; LMULMAX1-RV32-NEXT:    vmv.v.x v14, a6
; LMULMAX1-RV32-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; LMULMAX1-RV32-NEXT:    vand.vv v13, v13, v14
; LMULMAX1-RV32-NEXT:    vand.vv v12, v12, v14
; LMULMAX1-RV32-NEXT:    vsll.vi v12, v12, 4
; LMULMAX1-RV32-NEXT:    vor.vv v12, v13, v12
; LMULMAX1-RV32-NEXT:    vsrl.vi v13, v12, 2
; LMULMAX1-RV32-NEXT:    lui a6, 209715
; LMULMAX1-RV32-NEXT:    addi a6, a6, 819
; LMULMAX1-RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; LMULMAX1-RV32-NEXT:    vmv.v.x v15, a6
; LMULMAX1-RV32-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; LMULMAX1-RV32-NEXT:    vand.vv v13, v13, v15
; LMULMAX1-RV32-NEXT:    vand.vv v12, v12, v15
; LMULMAX1-RV32-NEXT:    vsll.vi v12, v12, 2
; LMULMAX1-RV32-NEXT:    vor.vv v12, v13, v12
; LMULMAX1-RV32-NEXT:    vsrl.vi v13, v12, 1
; LMULMAX1-RV32-NEXT:    lui a6, 349525
; LMULMAX1-RV32-NEXT:    addi a6, a6, 1365
; LMULMAX1-RV32-NEXT:    vsetivli zero, 4, e32, m1, ta, mu
; LMULMAX1-RV32-NEXT:    vmv.v.x v17, a6
; LMULMAX1-RV32-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; LMULMAX1-RV32-NEXT:    vand.vv v13, v13, v17
; LMULMAX1-RV32-NEXT:    vand.vv v12, v12, v17
; LMULMAX1-RV32-NEXT:    vadd.vv v12, v12, v12
; LMULMAX1-RV32-NEXT:    vor.vv v12, v13, v12
; LMULMAX1-RV32-NEXT:    vsrl.vx v13, v8, a2
; LMULMAX1-RV32-NEXT:    vsrl.vx v18, v8, a3
; LMULMAX1-RV32-NEXT:    vand.vx v18, v18, a4
; LMULMAX1-RV32-NEXT:    vor.vv v13, v18, v13
; LMULMAX1-RV32-NEXT:    vsrl.vi v18, v8, 24
; LMULMAX1-RV32-NEXT:    vand.vx v18, v18, a5
; LMULMAX1-RV32-NEXT:    vsrl.vi v19, v8, 8
; LMULMAX1-RV32-NEXT:    vand.vv v9, v19, v9
; LMULMAX1-RV32-NEXT:    vor.vv v9, v9, v18
; LMULMAX1-RV32-NEXT:    vor.vv v9, v9, v13
; LMULMAX1-RV32-NEXT:    vsll.vi v13, v8, 8
; LMULMAX1-RV32-NEXT:    vand.vv v10, v13, v10
; LMULMAX1-RV32-NEXT:    vsll.vi v13, v8, 24
; LMULMAX1-RV32-NEXT:    vand.vv v11, v13, v11
; LMULMAX1-RV32-NEXT:    vor.vv v10, v11, v10
; LMULMAX1-RV32-NEXT:    vsll.vx v11, v8, a3
; LMULMAX1-RV32-NEXT:    vand.vv v11, v11, v16
; LMULMAX1-RV32-NEXT:    vsll.vx v8, v8, a2
; LMULMAX1-RV32-NEXT:    vor.vv v8, v8, v11
; LMULMAX1-RV32-NEXT:    vor.vv v8, v8, v10
; LMULMAX1-RV32-NEXT:    vor.vv v8, v8, v9
; LMULMAX1-RV32-NEXT:    vsrl.vi v9, v8, 4
; LMULMAX1-RV32-NEXT:    vand.vv v9, v9, v14
; LMULMAX1-RV32-NEXT:    vand.vv v8, v8, v14
; LMULMAX1-RV32-NEXT:    vsll.vi v8, v8, 4
; LMULMAX1-RV32-NEXT:    vor.vv v8, v9, v8
; LMULMAX1-RV32-NEXT:    vsrl.vi v9, v8, 2
; LMULMAX1-RV32-NEXT:    vand.vv v9, v9, v15
; LMULMAX1-RV32-NEXT:    vand.vv v8, v8, v15
; LMULMAX1-RV32-NEXT:    vsll.vi v8, v8, 2
; LMULMAX1-RV32-NEXT:    vor.vv v8, v9, v8
; LMULMAX1-RV32-NEXT:    vsrl.vi v9, v8, 1
; LMULMAX1-RV32-NEXT:    vand.vv v9, v9, v17
; LMULMAX1-RV32-NEXT:    vand.vv v8, v8, v17
; LMULMAX1-RV32-NEXT:    vadd.vv v8, v8, v8
; LMULMAX1-RV32-NEXT:    vor.vv v8, v9, v8
; LMULMAX1-RV32-NEXT:    vse64.v v8, (a0)
; LMULMAX1-RV32-NEXT:    vse64.v v12, (a1)
; LMULMAX1-RV32-NEXT:    ret
;
; LMULMAX1-RV64-LABEL: bitreverse_v4i64:
; LMULMAX1-RV64:       # %bb.0:
; LMULMAX1-RV64-NEXT:    vsetivli zero, 2, e64, m1, ta, mu
; LMULMAX1-RV64-NEXT:    addi a1, a0, 16
; LMULMAX1-RV64-NEXT:    vle64.v v9, (a1)
; LMULMAX1-RV64-NEXT:    vle64.v v8, (a0)
; LMULMAX1-RV64-NEXT:    li a2, 56
; LMULMAX1-RV64-NEXT:    vsrl.vx v10, v9, a2
; LMULMAX1-RV64-NEXT:    li a3, 40
; LMULMAX1-RV64-NEXT:    vsrl.vx v11, v9, a3
; LMULMAX1-RV64-NEXT:    lui a4, 16
; LMULMAX1-RV64-NEXT:    addiw a4, a4, -256
; LMULMAX1-RV64-NEXT:    vand.vx v11, v11, a4
; LMULMAX1-RV64-NEXT:    vor.vv v10, v11, v10
; LMULMAX1-RV64-NEXT:    vsrl.vi v11, v9, 24
; LMULMAX1-RV64-NEXT:    lui a5, 4080
; LMULMAX1-RV64-NEXT:    vand.vx v11, v11, a5
; LMULMAX1-RV64-NEXT:    vsrl.vi v12, v9, 8
; LMULMAX1-RV64-NEXT:    li a6, 255
; LMULMAX1-RV64-NEXT:    slli a7, a6, 24
; LMULMAX1-RV64-NEXT:    vand.vx v12, v12, a7
; LMULMAX1-RV64-NEXT:    vor.vv v11, v12, v11
; LMULMAX1-RV64-NEXT:    vor.vv v10, v11, v10
; LMULMAX1-RV64-NEXT:    vsll.vi v11, v9, 8
; LMULMAX1-RV64-NEXT:    slli t0, a6, 32
; LMULMAX1-RV64-NEXT:    vand.vx v11, v11, t0
; LMULMAX1-RV64-NEXT:    vsll.vi v12, v9, 24
; LMULMAX1-RV64-NEXT:    slli t1, a6, 40
; LMULMAX1-RV64-NEXT:    vand.vx v12, v12, t1
; LMULMAX1-RV64-NEXT:    vor.vv v11, v12, v11
; LMULMAX1-RV64-NEXT:    vsll.vx v12, v9, a2
; LMULMAX1-RV64-NEXT:    vsll.vx v9, v9, a3
; LMULMAX1-RV64-NEXT:    slli a6, a6, 48
; LMULMAX1-RV64-NEXT:    vand.vx v9, v9, a6
; LMULMAX1-RV64-NEXT:    vor.vv v9, v12, v9
; LMULMAX1-RV64-NEXT:    lui t2, %hi(.LCPI5_0)
; LMULMAX1-RV64-NEXT:    ld t2, %lo(.LCPI5_0)(t2)
; LMULMAX1-RV64-NEXT:    vor.vv v9, v9, v11
; LMULMAX1-RV64-NEXT:    vor.vv v9, v9, v10
; LMULMAX1-RV64-NEXT:    vsrl.vi v10, v9, 4
; LMULMAX1-RV64-NEXT:    vand.vx v10, v10, t2
; LMULMAX1-RV64-NEXT:    vand.vx v9, v9, t2
; LMULMAX1-RV64-NEXT:    lui t3, %hi(.LCPI5_1)
; LMULMAX1-RV64-NEXT:    ld t3, %lo(.LCPI5_1)(t3)
; LMULMAX1-RV64-NEXT:    vsll.vi v9, v9, 4
; LMULMAX1-RV64-NEXT:    vor.vv v9, v10, v9
; LMULMAX1-RV64-NEXT:    vsrl.vi v10, v9, 2
; LMULMAX1-RV64-NEXT:    vand.vx v10, v10, t3
; LMULMAX1-RV64-NEXT:    vand.vx v9, v9, t3
; LMULMAX1-RV64-NEXT:    lui t4, %hi(.LCPI5_2)
; LMULMAX1-RV64-NEXT:    ld t4, %lo(.LCPI5_2)(t4)
; LMULMAX1-RV64-NEXT:    vsll.vi v9, v9, 2
; LMULMAX1-RV64-NEXT:    vor.vv v9, v10, v9
; LMULMAX1-RV64-NEXT:    vsrl.vi v10, v9, 1
; LMULMAX1-RV64-NEXT:    vand.vx v10, v10, t4
; LMULMAX1-RV64-NEXT:    vand.vx v9, v9, t4
; LMULMAX1-RV64-NEXT:    vadd.vv v9, v9, v9
; LMULMAX1-RV64-NEXT:    vor.vv v9, v10, v9
; LMULMAX1-RV64-NEXT:    vsrl.vx v10, v8, a2
; LMULMAX1-RV64-NEXT:    vsrl.vx v11, v8, a3
; LMULMAX1-RV64-NEXT:    vand.vx v11, v11, a4
; LMULMAX1-RV64-NEXT:    vor.vv v10, v11, v10
; LMULMAX1-RV64-NEXT:    vsrl.vi v11, v8, 24
; LMULMAX1-RV64-NEXT:    vand.vx v11, v11, a5
; LMULMAX1-RV64-NEXT:    vsrl.vi v12, v8, 8
; LMULMAX1-RV64-NEXT:    vand.vx v12, v12, a7
; LMULMAX1-RV64-NEXT:    vor.vv v11, v12, v11
; LMULMAX1-RV64-NEXT:    vor.vv v10, v11, v10
; LMULMAX1-RV64-NEXT:    vsll.vi v11, v8, 8
; LMULMAX1-RV64-NEXT:    vand.vx v11, v11, t0
; LMULMAX1-RV64-NEXT:    vsll.vi v12, v8, 24
; LMULMAX1-RV64-NEXT:    vand.vx v12, v12, t1
; LMULMAX1-RV64-NEXT:    vor.vv v11, v12, v11
; LMULMAX1-RV64-NEXT:    vsll.vx v12, v8, a2
; LMULMAX1-RV64-NEXT:    vsll.vx v8, v8, a3
; LMULMAX1-RV64-NEXT:    vand.vx v8, v8, a6
; LMULMAX1-RV64-NEXT:    vor.vv v8, v12, v8
; LMULMAX1-RV64-NEXT:    vor.vv v8, v8, v11
; LMULMAX1-RV64-NEXT:    vor.vv v8, v8, v10
; LMULMAX1-RV64-NEXT:    vsrl.vi v10, v8, 4
; LMULMAX1-RV64-NEXT:    vand.vx v10, v10, t2
; LMULMAX1-RV64-NEXT:    vand.vx v8, v8, t2
; LMULMAX1-RV64-NEXT:    vsll.vi v8, v8, 4
; LMULMAX1-RV64-NEXT:    vor.vv v8, v10, v8
; LMULMAX1-RV64-NEXT:    vsrl.vi v10, v8, 2
; LMULMAX1-RV64-NEXT:    vand.vx v10, v10, t3
; LMULMAX1-RV64-NEXT:    vand.vx v8, v8, t3
; LMULMAX1-RV64-NEXT:    vsll.vi v8, v8, 2
; LMULMAX1-RV64-NEXT:    vor.vv v8, v10, v8
; LMULMAX1-RV64-NEXT:    vsrl.vi v10, v8, 1
; LMULMAX1-RV64-NEXT:    vand.vx v10, v10, t4
; LMULMAX1-RV64-NEXT:    vand.vx v8, v8, t4
; LMULMAX1-RV64-NEXT:    vadd.vv v8, v8, v8
; LMULMAX1-RV64-NEXT:    vor.vv v8, v10, v8
; LMULMAX1-RV64-NEXT:    vse64.v v8, (a0)
; LMULMAX1-RV64-NEXT:    vse64.v v9, (a1)
; LMULMAX1-RV64-NEXT:    ret
  %a = load <4 x i64>, <4 x i64>* %x
  %b = load <4 x i64>, <4 x i64>* %y
  %c = call <4 x i64> @llvm.bitreverse.v4i64(<4 x i64> %a)
  store <4 x i64> %c, <4 x i64>* %x
  ret void
}
declare <4 x i64> @llvm.bitreverse.v4i64(<4 x i64>)
