/*
 * Copyright 2021 Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) OR AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 */
#ifndef _sdma_4_4_2_OFFSET_HEADER
#define _sdma_4_4_2_OFFSET_HEADER



// addressBlock: aid_sdma_insts_sdma0_sdmadec
// base address: 0x4980
#define regSDMA_UCODE_ADDR                                                                              0x0000
#define regSDMA_UCODE_ADDR_BASE_IDX                                                                     0
#define regSDMA_UCODE_DATA                                                                              0x0001
#define regSDMA_UCODE_DATA_BASE_IDX                                                                     0
#define regSDMA_F32_CNTL                                                                                0x0002
#define regSDMA_F32_CNTL_BASE_IDX                                                                       0
#define regSDMA_MMHUB_CNTL                                                                              0x0005
#define regSDMA_MMHUB_CNTL_BASE_IDX                                                                     0
#define regSDMA_MMHUB_TRUSTLVL                                                                          0x0006
#define regSDMA_MMHUB_TRUSTLVL_BASE_IDX                                                                 0
#define regSDMA_VM_CNTL                                                                                 0x0010
#define regSDMA_VM_CNTL_BASE_IDX                                                                        0
#define regSDMA_VM_CTX_LO                                                                               0x0011
#define regSDMA_VM_CTX_LO_BASE_IDX                                                                      0
#define regSDMA_VM_CTX_HI                                                                               0x0012
#define regSDMA_VM_CTX_HI_BASE_IDX                                                                      0
#define regSDMA_ACTIVE_FCN_ID                                                                           0x0013
#define regSDMA_ACTIVE_FCN_ID_BASE_IDX                                                                  0
#define regSDMA_VM_CTX_CNTL                                                                             0x0014
#define regSDMA_VM_CTX_CNTL_BASE_IDX                                                                    0
#define regSDMA_VIRT_RESET_REQ                                                                          0x0015
#define regSDMA_VIRT_RESET_REQ_BASE_IDX                                                                 0
#define regSDMA_VF_ENABLE                                                                               0x0016
#define regSDMA_VF_ENABLE_BASE_IDX                                                                      0
#define regSDMA_CONTEXT_REG_TYPE0                                                                       0x0017
#define regSDMA_CONTEXT_REG_TYPE0_BASE_IDX                                                              0
#define regSDMA_CONTEXT_REG_TYPE1                                                                       0x0018
#define regSDMA_CONTEXT_REG_TYPE1_BASE_IDX                                                              0
#define regSDMA_CONTEXT_REG_TYPE2                                                                       0x0019
#define regSDMA_CONTEXT_REG_TYPE2_BASE_IDX                                                              0
#define regSDMA_CONTEXT_REG_TYPE3                                                                       0x001a
#define regSDMA_CONTEXT_REG_TYPE3_BASE_IDX                                                              0
#define regSDMA_PUB_REG_TYPE0                                                                           0x001b
#define regSDMA_PUB_REG_TYPE0_BASE_IDX                                                                  0
#define regSDMA_PUB_REG_TYPE1                                                                           0x001c
#define regSDMA_PUB_REG_TYPE1_BASE_IDX                                                                  0
#define regSDMA_PUB_REG_TYPE2                                                                           0x001d
#define regSDMA_PUB_REG_TYPE2_BASE_IDX                                                                  0
#define regSDMA_PUB_REG_TYPE3                                                                           0x001e
#define regSDMA_PUB_REG_TYPE3_BASE_IDX                                                                  0
#define regSDMA_CONTEXT_GROUP_BOUNDARY                                                                  0x001f
#define regSDMA_CONTEXT_GROUP_BOUNDARY_BASE_IDX                                                         0
#define regSDMA_RB_RPTR_FETCH_HI                                                                        0x0020
#define regSDMA_RB_RPTR_FETCH_HI_BASE_IDX                                                               0
#define regSDMA_SEM_WAIT_FAIL_TIMER_CNTL                                                                0x0021
#define regSDMA_SEM_WAIT_FAIL_TIMER_CNTL_BASE_IDX                                                       0
#define regSDMA_RB_RPTR_FETCH                                                                           0x0022
#define regSDMA_RB_RPTR_FETCH_BASE_IDX                                                                  0
#define regSDMA_IB_OFFSET_FETCH                                                                         0x0023
#define regSDMA_IB_OFFSET_FETCH_BASE_IDX                                                                0
#define regSDMA_PROGRAM                                                                                 0x0024
#define regSDMA_PROGRAM_BASE_IDX                                                                        0
#define regSDMA_STATUS_REG                                                                              0x0025
#define regSDMA_STATUS_REG_BASE_IDX                                                                     0
#define regSDMA_STATUS1_REG                                                                             0x0026
#define regSDMA_STATUS1_REG_BASE_IDX                                                                    0
#define regSDMA_RD_BURST_CNTL                                                                           0x0027
#define regSDMA_RD_BURST_CNTL_BASE_IDX                                                                  0
#define regSDMA_HBM_PAGE_CONFIG                                                                         0x0028
#define regSDMA_HBM_PAGE_CONFIG_BASE_IDX                                                                0
#define regSDMA_UCODE_CHECKSUM                                                                          0x0029
#define regSDMA_UCODE_CHECKSUM_BASE_IDX                                                                 0
#define regSDMA_FREEZE                                                                                  0x002b
#define regSDMA_FREEZE_BASE_IDX                                                                         0
#define regSDMA_PHASE0_QUANTUM                                                                          0x002c
#define regSDMA_PHASE0_QUANTUM_BASE_IDX                                                                 0
#define regSDMA_PHASE1_QUANTUM                                                                          0x002d
#define regSDMA_PHASE1_QUANTUM_BASE_IDX                                                                 0
#define regSDMA_POWER_GATING                                                                            0x002e
#define regSDMA_POWER_GATING_BASE_IDX                                                                   0
#define regSDMA_PGFSM_CONFIG                                                                            0x002f
#define regSDMA_PGFSM_CONFIG_BASE_IDX                                                                   0
#define regSDMA_PGFSM_WRITE                                                                             0x0030
#define regSDMA_PGFSM_WRITE_BASE_IDX                                                                    0
#define regSDMA_PGFSM_READ                                                                              0x0031
#define regSDMA_PGFSM_READ_BASE_IDX                                                                     0
#define regCC_SDMA_EDC_CONFIG                                                                           0x0032
#define regCC_SDMA_EDC_CONFIG_BASE_IDX                                                                  0
#define regSDMA_BA_THRESHOLD                                                                            0x0033
#define regSDMA_BA_THRESHOLD_BASE_IDX                                                                   0
#define regSDMA_ID                                                                                      0x0034
#define regSDMA_ID_BASE_IDX                                                                             0
#define regSDMA_VERSION                                                                                 0x0035
#define regSDMA_VERSION_BASE_IDX                                                                        0
#define regSDMA_EDC_COUNTER                                                                             0x0036
#define regSDMA_EDC_COUNTER_BASE_IDX                                                                    0
#define regSDMA_EDC_COUNTER2                                                                            0x0037
#define regSDMA_EDC_COUNTER2_BASE_IDX                                                                   0
#define regSDMA_STATUS2_REG                                                                             0x0038
#define regSDMA_STATUS2_REG_BASE_IDX                                                                    0
#define regSDMA_ATOMIC_CNTL                                                                             0x0039
#define regSDMA_ATOMIC_CNTL_BASE_IDX                                                                    0
#define regSDMA_ATOMIC_PREOP_LO                                                                         0x003a
#define regSDMA_ATOMIC_PREOP_LO_BASE_IDX                                                                0
#define regSDMA_ATOMIC_PREOP_HI                                                                         0x003b
#define regSDMA_ATOMIC_PREOP_HI_BASE_IDX                                                                0
#define regSDMA_UTCL1_CNTL                                                                              0x003c
#define regSDMA_UTCL1_CNTL_BASE_IDX                                                                     0
#define regSDMA_UTCL1_WATERMK                                                                           0x003d
#define regSDMA_UTCL1_WATERMK_BASE_IDX                                                                  0
#define regSDMA_UTCL1_RD_STATUS                                                                         0x003e
#define regSDMA_UTCL1_RD_STATUS_BASE_IDX                                                                0
#define regSDMA_UTCL1_WR_STATUS                                                                         0x003f
#define regSDMA_UTCL1_WR_STATUS_BASE_IDX                                                                0
#define regSDMA_UTCL1_INV0                                                                              0x0040
#define regSDMA_UTCL1_INV0_BASE_IDX                                                                     0
#define regSDMA_UTCL1_INV1                                                                              0x0041
#define regSDMA_UTCL1_INV1_BASE_IDX                                                                     0
#define regSDMA_UTCL1_INV2                                                                              0x0042
#define regSDMA_UTCL1_INV2_BASE_IDX                                                                     0
#define regSDMA_UTCL1_RD_XNACK0                                                                         0x0043
#define regSDMA_UTCL1_RD_XNACK0_BASE_IDX                                                                0
#define regSDMA_UTCL1_RD_XNACK1                                                                         0x0044
#define regSDMA_UTCL1_RD_XNACK1_BASE_IDX                                                                0
#define regSDMA_UTCL1_WR_XNACK0                                                                         0x0045
#define regSDMA_UTCL1_WR_XNACK0_BASE_IDX                                                                0
#define regSDMA_UTCL1_WR_XNACK1                                                                         0x0046
#define regSDMA_UTCL1_WR_XNACK1_BASE_IDX                                                                0
#define regSDMA_UTCL1_TIMEOUT                                                                           0x0047
#define regSDMA_UTCL1_TIMEOUT_BASE_IDX                                                                  0
#define regSDMA_UTCL1_PAGE                                                                              0x0048
#define regSDMA_UTCL1_PAGE_BASE_IDX                                                                     0
#define regSDMA_POWER_CNTL_IDLE                                                                         0x0049
#define regSDMA_POWER_CNTL_IDLE_BASE_IDX                                                                0
#define regSDMA_RELAX_ORDERING_LUT                                                                      0x004a
#define regSDMA_RELAX_ORDERING_LUT_BASE_IDX                                                             0
#define regSDMA_CHICKEN_BITS_2                                                                          0x004b
#define regSDMA_CHICKEN_BITS_2_BASE_IDX                                                                 0
#define regSDMA_STATUS3_REG                                                                             0x004c
#define regSDMA_STATUS3_REG_BASE_IDX                                                                    0
#define regSDMA_PHYSICAL_ADDR_LO                                                                        0x004d
#define regSDMA_PHYSICAL_ADDR_LO_BASE_IDX                                                               0
#define regSDMA_PHYSICAL_ADDR_HI                                                                        0x004e
#define regSDMA_PHYSICAL_ADDR_HI_BASE_IDX                                                               0
#define regSDMA_PHASE2_QUANTUM                                                                          0x004f
#define regSDMA_PHASE2_QUANTUM_BASE_IDX                                                                 0
#define regSDMA_ERROR_LOG                                                                               0x0050
#define regSDMA_ERROR_LOG_BASE_IDX                                                                      0
#define regSDMA_PUB_DUMMY_REG0                                                                          0x0051
#define regSDMA_PUB_DUMMY_REG0_BASE_IDX                                                                 0
#define regSDMA_PUB_DUMMY_REG1                                                                          0x0052
#define regSDMA_PUB_DUMMY_REG1_BASE_IDX                                                                 0
#define regSDMA_PUB_DUMMY_REG2                                                                          0x0053
#define regSDMA_PUB_DUMMY_REG2_BASE_IDX                                                                 0
#define regSDMA_PUB_DUMMY_REG3                                                                          0x0054
#define regSDMA_PUB_DUMMY_REG3_BASE_IDX                                                                 0
#define regSDMA_F32_COUNTER                                                                             0x0055
#define regSDMA_F32_COUNTER_BASE_IDX                                                                    0
#define regSDMA_PERFCNT_PERFCOUNTER0_CFG                                                                0x0057
#define regSDMA_PERFCNT_PERFCOUNTER0_CFG_BASE_IDX                                                       0
#define regSDMA_PERFCNT_PERFCOUNTER1_CFG                                                                0x0058
#define regSDMA_PERFCNT_PERFCOUNTER1_CFG_BASE_IDX                                                       0
#define regSDMA_PERFCNT_PERFCOUNTER_RSLT_CNTL                                                           0x0059
#define regSDMA_PERFCNT_PERFCOUNTER_RSLT_CNTL_BASE_IDX                                                  0
#define regSDMA_PERFCNT_MISC_CNTL                                                                       0x005a
#define regSDMA_PERFCNT_MISC_CNTL_BASE_IDX                                                              0
#define regSDMA_PERFCNT_PERFCOUNTER_LO                                                                  0x005b
#define regSDMA_PERFCNT_PERFCOUNTER_LO_BASE_IDX                                                         0
#define regSDMA_PERFCNT_PERFCOUNTER_HI                                                                  0x005c
#define regSDMA_PERFCNT_PERFCOUNTER_HI_BASE_IDX                                                         0
#define regSDMA_CRD_CNTL                                                                                0x005d
#define regSDMA_CRD_CNTL_BASE_IDX                                                                       0
#define regSDMA_GPU_IOV_VIOLATION_LOG                                                                   0x005e
#define regSDMA_GPU_IOV_VIOLATION_LOG_BASE_IDX                                                          0
#define regSDMA_ULV_CNTL                                                                                0x005f
#define regSDMA_ULV_CNTL_BASE_IDX                                                                       0
#define regSDMA_EA_DBIT_ADDR_DATA                                                                       0x0060
#define regSDMA_EA_DBIT_ADDR_DATA_BASE_IDX                                                              0
#define regSDMA_EA_DBIT_ADDR_INDEX                                                                      0x0061
#define regSDMA_EA_DBIT_ADDR_INDEX_BASE_IDX                                                             0
#define regSDMA_GPU_IOV_VIOLATION_LOG2                                                                  0x0062
#define regSDMA_GPU_IOV_VIOLATION_LOG2_BASE_IDX                                                         0
#define regSDMA_STATUS4_REG                                                                             0x0063
#define regSDMA_STATUS4_REG_BASE_IDX                                                                    0
#define regSDMA_SCRATCH_RAM_DATA                                                                        0x0064
#define regSDMA_SCRATCH_RAM_DATA_BASE_IDX                                                               0
#define regSDMA_SCRATCH_RAM_ADDR                                                                        0x0065
#define regSDMA_SCRATCH_RAM_ADDR_BASE_IDX                                                               0
#define regSDMA_CE_CTRL                                                                                 0x0066
#define regSDMA_CE_CTRL_BASE_IDX                                                                        0
#define regSDMA_RAS_STATUS                                                                              0x0067
#define regSDMA_RAS_STATUS_BASE_IDX                                                                     0
#define regSDMA_CLK_STATUS                                                                              0x0068
#define regSDMA_CLK_STATUS_BASE_IDX                                                                     0
#define regSDMA_UE_ERR_STATUS_LO                                                                        0x0069
#define regSDMA_UE_ERR_STATUS_LO_BASE_IDX                                                               0
#define regSDMA_UE_ERR_STATUS_HI                                                                        0x006a
#define regSDMA_UE_ERR_STATUS_HI_BASE_IDX                                                               0
#define regSDMA_POWER_CNTL                                                                              0x006b
#define regSDMA_POWER_CNTL_BASE_IDX                                                                     0
#define regSDMA_CLK_CTRL                                                                                0x006c
#define regSDMA_CLK_CTRL_BASE_IDX                                                                       0
#define regSDMA_CNTL                                                                                    0x006d
#define regSDMA_CNTL_BASE_IDX                                                                           0
#define regSDMA_CHICKEN_BITS                                                                            0x006e
#define regSDMA_CHICKEN_BITS_BASE_IDX                                                                   0
#define regSDMA_GB_ADDR_CONFIG                                                                          0x006f
#define regSDMA_GB_ADDR_CONFIG_BASE_IDX                                                                 0
#define regSDMA_GB_ADDR_CONFIG_READ                                                                     0x0070
#define regSDMA_GB_ADDR_CONFIG_READ_BASE_IDX                                                            0
#define regSDMA_GFX_RB_CNTL                                                                             0x0080
#define regSDMA_GFX_RB_CNTL_BASE_IDX                                                                    0
#define regSDMA_GFX_RB_BASE                                                                             0x0081
#define regSDMA_GFX_RB_BASE_BASE_IDX                                                                    0
#define regSDMA_GFX_RB_BASE_HI                                                                          0x0082
#define regSDMA_GFX_RB_BASE_HI_BASE_IDX                                                                 0
#define regSDMA_GFX_RB_RPTR                                                                             0x0083
#define regSDMA_GFX_RB_RPTR_BASE_IDX                                                                    0
#define regSDMA_GFX_RB_RPTR_HI                                                                          0x0084
#define regSDMA_GFX_RB_RPTR_HI_BASE_IDX                                                                 0
#define regSDMA_GFX_RB_WPTR                                                                             0x0085
#define regSDMA_GFX_RB_WPTR_BASE_IDX                                                                    0
#define regSDMA_GFX_RB_WPTR_HI                                                                          0x0086
#define regSDMA_GFX_RB_WPTR_HI_BASE_IDX                                                                 0
#define regSDMA_GFX_RB_WPTR_POLL_CNTL                                                                   0x0087
#define regSDMA_GFX_RB_WPTR_POLL_CNTL_BASE_IDX                                                          0
#define regSDMA_GFX_RB_RPTR_ADDR_HI                                                                     0x0088
#define regSDMA_GFX_RB_RPTR_ADDR_HI_BASE_IDX                                                            0
#define regSDMA_GFX_RB_RPTR_ADDR_LO                                                                     0x0089
#define regSDMA_GFX_RB_RPTR_ADDR_LO_BASE_IDX                                                            0
#define regSDMA_GFX_IB_CNTL                                                                             0x008a
#define regSDMA_GFX_IB_CNTL_BASE_IDX                                                                    0
#define regSDMA_GFX_IB_RPTR                                                                             0x008b
#define regSDMA_GFX_IB_RPTR_BASE_IDX                                                                    0
#define regSDMA_GFX_IB_OFFSET                                                                           0x008c
#define regSDMA_GFX_IB_OFFSET_BASE_IDX                                                                  0
#define regSDMA_GFX_IB_BASE_LO                                                                          0x008d
#define regSDMA_GFX_IB_BASE_LO_BASE_IDX                                                                 0
#define regSDMA_GFX_IB_BASE_HI                                                                          0x008e
#define regSDMA_GFX_IB_BASE_HI_BASE_IDX                                                                 0
#define regSDMA_GFX_IB_SIZE                                                                             0x008f
#define regSDMA_GFX_IB_SIZE_BASE_IDX                                                                    0
#define regSDMA_GFX_SKIP_CNTL                                                                           0x0090
#define regSDMA_GFX_SKIP_CNTL_BASE_IDX                                                                  0
#define regSDMA_GFX_CONTEXT_STATUS                                                                      0x0091
#define regSDMA_GFX_CONTEXT_STATUS_BASE_IDX                                                             0
#define regSDMA_GFX_DOORBELL                                                                            0x0092
#define regSDMA_GFX_DOORBELL_BASE_IDX                                                                   0
#define regSDMA_GFX_CONTEXT_CNTL                                                                        0x0093
#define regSDMA_GFX_CONTEXT_CNTL_BASE_IDX                                                               0
#define regSDMA_GFX_STATUS                                                                              0x00a8
#define regSDMA_GFX_STATUS_BASE_IDX                                                                     0
#define regSDMA_GFX_DOORBELL_LOG                                                                        0x00a9
#define regSDMA_GFX_DOORBELL_LOG_BASE_IDX                                                               0
#define regSDMA_GFX_WATERMARK                                                                           0x00aa
#define regSDMA_GFX_WATERMARK_BASE_IDX                                                                  0
#define regSDMA_GFX_DOORBELL_OFFSET                                                                     0x00ab
#define regSDMA_GFX_DOORBELL_OFFSET_BASE_IDX                                                            0
#define regSDMA_GFX_CSA_ADDR_LO                                                                         0x00ac
#define regSDMA_GFX_CSA_ADDR_LO_BASE_IDX                                                                0
#define regSDMA_GFX_CSA_ADDR_HI                                                                         0x00ad
#define regSDMA_GFX_CSA_ADDR_HI_BASE_IDX                                                                0
#define regSDMA_GFX_IB_SUB_REMAIN                                                                       0x00af
#define regSDMA_GFX_IB_SUB_REMAIN_BASE_IDX                                                              0
#define regSDMA_GFX_PREEMPT                                                                             0x00b0
#define regSDMA_GFX_PREEMPT_BASE_IDX                                                                    0
#define regSDMA_GFX_DUMMY_REG                                                                           0x00b1
#define regSDMA_GFX_DUMMY_REG_BASE_IDX                                                                  0
#define regSDMA_GFX_RB_WPTR_POLL_ADDR_HI                                                                0x00b2
#define regSDMA_GFX_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                       0
#define regSDMA_GFX_RB_WPTR_POLL_ADDR_LO                                                                0x00b3
#define regSDMA_GFX_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                       0
#define regSDMA_GFX_RB_AQL_CNTL                                                                         0x00b4
#define regSDMA_GFX_RB_AQL_CNTL_BASE_IDX                                                                0
#define regSDMA_GFX_MINOR_PTR_UPDATE                                                                    0x00b5
#define regSDMA_GFX_MINOR_PTR_UPDATE_BASE_IDX                                                           0
#define regSDMA_GFX_MIDCMD_DATA0                                                                        0x00c0
#define regSDMA_GFX_MIDCMD_DATA0_BASE_IDX                                                               0
#define regSDMA_GFX_MIDCMD_DATA1                                                                        0x00c1
#define regSDMA_GFX_MIDCMD_DATA1_BASE_IDX                                                               0
#define regSDMA_GFX_MIDCMD_DATA2                                                                        0x00c2
#define regSDMA_GFX_MIDCMD_DATA2_BASE_IDX                                                               0
#define regSDMA_GFX_MIDCMD_DATA3                                                                        0x00c3
#define regSDMA_GFX_MIDCMD_DATA3_BASE_IDX                                                               0
#define regSDMA_GFX_MIDCMD_DATA4                                                                        0x00c4
#define regSDMA_GFX_MIDCMD_DATA4_BASE_IDX                                                               0
#define regSDMA_GFX_MIDCMD_DATA5                                                                        0x00c5
#define regSDMA_GFX_MIDCMD_DATA5_BASE_IDX                                                               0
#define regSDMA_GFX_MIDCMD_DATA6                                                                        0x00c6
#define regSDMA_GFX_MIDCMD_DATA6_BASE_IDX                                                               0
#define regSDMA_GFX_MIDCMD_DATA7                                                                        0x00c7
#define regSDMA_GFX_MIDCMD_DATA7_BASE_IDX                                                               0
#define regSDMA_GFX_MIDCMD_DATA8                                                                        0x00c8
#define regSDMA_GFX_MIDCMD_DATA8_BASE_IDX                                                               0
#define regSDMA_GFX_MIDCMD_DATA9                                                                        0x00c9
#define regSDMA_GFX_MIDCMD_DATA9_BASE_IDX                                                               0
#define regSDMA_GFX_MIDCMD_DATA10                                                                       0x00ca
#define regSDMA_GFX_MIDCMD_DATA10_BASE_IDX                                                              0
#define regSDMA_GFX_MIDCMD_CNTL                                                                         0x00cb
#define regSDMA_GFX_MIDCMD_CNTL_BASE_IDX                                                                0
#define regSDMA_PAGE_RB_CNTL                                                                            0x00d8
#define regSDMA_PAGE_RB_CNTL_BASE_IDX                                                                   0
#define regSDMA_PAGE_RB_BASE                                                                            0x00d9
#define regSDMA_PAGE_RB_BASE_BASE_IDX                                                                   0
#define regSDMA_PAGE_RB_BASE_HI                                                                         0x00da
#define regSDMA_PAGE_RB_BASE_HI_BASE_IDX                                                                0
#define regSDMA_PAGE_RB_RPTR                                                                            0x00db
#define regSDMA_PAGE_RB_RPTR_BASE_IDX                                                                   0
#define regSDMA_PAGE_RB_RPTR_HI                                                                         0x00dc
#define regSDMA_PAGE_RB_RPTR_HI_BASE_IDX                                                                0
#define regSDMA_PAGE_RB_WPTR                                                                            0x00dd
#define regSDMA_PAGE_RB_WPTR_BASE_IDX                                                                   0
#define regSDMA_PAGE_RB_WPTR_HI                                                                         0x00de
#define regSDMA_PAGE_RB_WPTR_HI_BASE_IDX                                                                0
#define regSDMA_PAGE_RB_WPTR_POLL_CNTL                                                                  0x00df
#define regSDMA_PAGE_RB_WPTR_POLL_CNTL_BASE_IDX                                                         0
#define regSDMA_PAGE_RB_RPTR_ADDR_HI                                                                    0x00e0
#define regSDMA_PAGE_RB_RPTR_ADDR_HI_BASE_IDX                                                           0
#define regSDMA_PAGE_RB_RPTR_ADDR_LO                                                                    0x00e1
#define regSDMA_PAGE_RB_RPTR_ADDR_LO_BASE_IDX                                                           0
#define regSDMA_PAGE_IB_CNTL                                                                            0x00e2
#define regSDMA_PAGE_IB_CNTL_BASE_IDX                                                                   0
#define regSDMA_PAGE_IB_RPTR                                                                            0x00e3
#define regSDMA_PAGE_IB_RPTR_BASE_IDX                                                                   0
#define regSDMA_PAGE_IB_OFFSET                                                                          0x00e4
#define regSDMA_PAGE_IB_OFFSET_BASE_IDX                                                                 0
#define regSDMA_PAGE_IB_BASE_LO                                                                         0x00e5
#define regSDMA_PAGE_IB_BASE_LO_BASE_IDX                                                                0
#define regSDMA_PAGE_IB_BASE_HI                                                                         0x00e6
#define regSDMA_PAGE_IB_BASE_HI_BASE_IDX                                                                0
#define regSDMA_PAGE_IB_SIZE                                                                            0x00e7
#define regSDMA_PAGE_IB_SIZE_BASE_IDX                                                                   0
#define regSDMA_PAGE_SKIP_CNTL                                                                          0x00e8
#define regSDMA_PAGE_SKIP_CNTL_BASE_IDX                                                                 0
#define regSDMA_PAGE_CONTEXT_STATUS                                                                     0x00e9
#define regSDMA_PAGE_CONTEXT_STATUS_BASE_IDX                                                            0
#define regSDMA_PAGE_DOORBELL                                                                           0x00ea
#define regSDMA_PAGE_DOORBELL_BASE_IDX                                                                  0
#define regSDMA_PAGE_STATUS                                                                             0x0100
#define regSDMA_PAGE_STATUS_BASE_IDX                                                                    0
#define regSDMA_PAGE_DOORBELL_LOG                                                                       0x0101
#define regSDMA_PAGE_DOORBELL_LOG_BASE_IDX                                                              0
#define regSDMA_PAGE_WATERMARK                                                                          0x0102
#define regSDMA_PAGE_WATERMARK_BASE_IDX                                                                 0
#define regSDMA_PAGE_DOORBELL_OFFSET                                                                    0x0103
#define regSDMA_PAGE_DOORBELL_OFFSET_BASE_IDX                                                           0
#define regSDMA_PAGE_CSA_ADDR_LO                                                                        0x0104
#define regSDMA_PAGE_CSA_ADDR_LO_BASE_IDX                                                               0
#define regSDMA_PAGE_CSA_ADDR_HI                                                                        0x0105
#define regSDMA_PAGE_CSA_ADDR_HI_BASE_IDX                                                               0
#define regSDMA_PAGE_IB_SUB_REMAIN                                                                      0x0107
#define regSDMA_PAGE_IB_SUB_REMAIN_BASE_IDX                                                             0
#define regSDMA_PAGE_PREEMPT                                                                            0x0108
#define regSDMA_PAGE_PREEMPT_BASE_IDX                                                                   0
#define regSDMA_PAGE_DUMMY_REG                                                                          0x0109
#define regSDMA_PAGE_DUMMY_REG_BASE_IDX                                                                 0
#define regSDMA_PAGE_RB_WPTR_POLL_ADDR_HI                                                               0x010a
#define regSDMA_PAGE_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                      0
#define regSDMA_PAGE_RB_WPTR_POLL_ADDR_LO                                                               0x010b
#define regSDMA_PAGE_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                      0
#define regSDMA_PAGE_RB_AQL_CNTL                                                                        0x010c
#define regSDMA_PAGE_RB_AQL_CNTL_BASE_IDX                                                               0
#define regSDMA_PAGE_MINOR_PTR_UPDATE                                                                   0x010d
#define regSDMA_PAGE_MINOR_PTR_UPDATE_BASE_IDX                                                          0
#define regSDMA_PAGE_MIDCMD_DATA0                                                                       0x0118
#define regSDMA_PAGE_MIDCMD_DATA0_BASE_IDX                                                              0
#define regSDMA_PAGE_MIDCMD_DATA1                                                                       0x0119
#define regSDMA_PAGE_MIDCMD_DATA1_BASE_IDX                                                              0
#define regSDMA_PAGE_MIDCMD_DATA2                                                                       0x011a
#define regSDMA_PAGE_MIDCMD_DATA2_BASE_IDX                                                              0
#define regSDMA_PAGE_MIDCMD_DATA3                                                                       0x011b
#define regSDMA_PAGE_MIDCMD_DATA3_BASE_IDX                                                              0
#define regSDMA_PAGE_MIDCMD_DATA4                                                                       0x011c
#define regSDMA_PAGE_MIDCMD_DATA4_BASE_IDX                                                              0
#define regSDMA_PAGE_MIDCMD_DATA5                                                                       0x011d
#define regSDMA_PAGE_MIDCMD_DATA5_BASE_IDX                                                              0
#define regSDMA_PAGE_MIDCMD_DATA6                                                                       0x011e
#define regSDMA_PAGE_MIDCMD_DATA6_BASE_IDX                                                              0
#define regSDMA_PAGE_MIDCMD_DATA7                                                                       0x011f
#define regSDMA_PAGE_MIDCMD_DATA7_BASE_IDX                                                              0
#define regSDMA_PAGE_MIDCMD_DATA8                                                                       0x0120
#define regSDMA_PAGE_MIDCMD_DATA8_BASE_IDX                                                              0
#define regSDMA_PAGE_MIDCMD_DATA9                                                                       0x0121
#define regSDMA_PAGE_MIDCMD_DATA9_BASE_IDX                                                              0
#define regSDMA_PAGE_MIDCMD_DATA10                                                                      0x0122
#define regSDMA_PAGE_MIDCMD_DATA10_BASE_IDX                                                             0
#define regSDMA_PAGE_MIDCMD_CNTL                                                                        0x0123
#define regSDMA_PAGE_MIDCMD_CNTL_BASE_IDX                                                               0
#define regSDMA_RLC0_RB_CNTL                                                                            0x0130
#define regSDMA_RLC0_RB_CNTL_BASE_IDX                                                                   0
#define regSDMA_RLC0_RB_BASE                                                                            0x0131
#define regSDMA_RLC0_RB_BASE_BASE_IDX                                                                   0
#define regSDMA_RLC0_RB_BASE_HI                                                                         0x0132
#define regSDMA_RLC0_RB_BASE_HI_BASE_IDX                                                                0
#define regSDMA_RLC0_RB_RPTR                                                                            0x0133
#define regSDMA_RLC0_RB_RPTR_BASE_IDX                                                                   0
#define regSDMA_RLC0_RB_RPTR_HI                                                                         0x0134
#define regSDMA_RLC0_RB_RPTR_HI_BASE_IDX                                                                0
#define regSDMA_RLC0_RB_WPTR                                                                            0x0135
#define regSDMA_RLC0_RB_WPTR_BASE_IDX                                                                   0
#define regSDMA_RLC0_RB_WPTR_HI                                                                         0x0136
#define regSDMA_RLC0_RB_WPTR_HI_BASE_IDX                                                                0
#define regSDMA_RLC0_RB_WPTR_POLL_CNTL                                                                  0x0137
#define regSDMA_RLC0_RB_WPTR_POLL_CNTL_BASE_IDX                                                         0
#define regSDMA_RLC0_RB_RPTR_ADDR_HI                                                                    0x0138
#define regSDMA_RLC0_RB_RPTR_ADDR_HI_BASE_IDX                                                           0
#define regSDMA_RLC0_RB_RPTR_ADDR_LO                                                                    0x0139
#define regSDMA_RLC0_RB_RPTR_ADDR_LO_BASE_IDX                                                           0
#define regSDMA_RLC0_IB_CNTL                                                                            0x013a
#define regSDMA_RLC0_IB_CNTL_BASE_IDX                                                                   0
#define regSDMA_RLC0_IB_RPTR                                                                            0x013b
#define regSDMA_RLC0_IB_RPTR_BASE_IDX                                                                   0
#define regSDMA_RLC0_IB_OFFSET                                                                          0x013c
#define regSDMA_RLC0_IB_OFFSET_BASE_IDX                                                                 0
#define regSDMA_RLC0_IB_BASE_LO                                                                         0x013d
#define regSDMA_RLC0_IB_BASE_LO_BASE_IDX                                                                0
#define regSDMA_RLC0_IB_BASE_HI                                                                         0x013e
#define regSDMA_RLC0_IB_BASE_HI_BASE_IDX                                                                0
#define regSDMA_RLC0_IB_SIZE                                                                            0x013f
#define regSDMA_RLC0_IB_SIZE_BASE_IDX                                                                   0
#define regSDMA_RLC0_SKIP_CNTL                                                                          0x0140
#define regSDMA_RLC0_SKIP_CNTL_BASE_IDX                                                                 0
#define regSDMA_RLC0_CONTEXT_STATUS                                                                     0x0141
#define regSDMA_RLC0_CONTEXT_STATUS_BASE_IDX                                                            0
#define regSDMA_RLC0_DOORBELL                                                                           0x0142
#define regSDMA_RLC0_DOORBELL_BASE_IDX                                                                  0
#define regSDMA_RLC0_STATUS                                                                             0x0158
#define regSDMA_RLC0_STATUS_BASE_IDX                                                                    0
#define regSDMA_RLC0_DOORBELL_LOG                                                                       0x0159
#define regSDMA_RLC0_DOORBELL_LOG_BASE_IDX                                                              0
#define regSDMA_RLC0_WATERMARK                                                                          0x015a
#define regSDMA_RLC0_WATERMARK_BASE_IDX                                                                 0
#define regSDMA_RLC0_DOORBELL_OFFSET                                                                    0x015b
#define regSDMA_RLC0_DOORBELL_OFFSET_BASE_IDX                                                           0
#define regSDMA_RLC0_CSA_ADDR_LO                                                                        0x015c
#define regSDMA_RLC0_CSA_ADDR_LO_BASE_IDX                                                               0
#define regSDMA_RLC0_CSA_ADDR_HI                                                                        0x015d
#define regSDMA_RLC0_CSA_ADDR_HI_BASE_IDX                                                               0
#define regSDMA_RLC0_IB_SUB_REMAIN                                                                      0x015f
#define regSDMA_RLC0_IB_SUB_REMAIN_BASE_IDX                                                             0
#define regSDMA_RLC0_PREEMPT                                                                            0x0160
#define regSDMA_RLC0_PREEMPT_BASE_IDX                                                                   0
#define regSDMA_RLC0_DUMMY_REG                                                                          0x0161
#define regSDMA_RLC0_DUMMY_REG_BASE_IDX                                                                 0
#define regSDMA_RLC0_RB_WPTR_POLL_ADDR_HI                                                               0x0162
#define regSDMA_RLC0_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                      0
#define regSDMA_RLC0_RB_WPTR_POLL_ADDR_LO                                                               0x0163
#define regSDMA_RLC0_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                      0
#define regSDMA_RLC0_RB_AQL_CNTL                                                                        0x0164
#define regSDMA_RLC0_RB_AQL_CNTL_BASE_IDX                                                               0
#define regSDMA_RLC0_MINOR_PTR_UPDATE                                                                   0x0165
#define regSDMA_RLC0_MINOR_PTR_UPDATE_BASE_IDX                                                          0
#define regSDMA_RLC0_MIDCMD_DATA0                                                                       0x0170
#define regSDMA_RLC0_MIDCMD_DATA0_BASE_IDX                                                              0
#define regSDMA_RLC0_MIDCMD_DATA1                                                                       0x0171
#define regSDMA_RLC0_MIDCMD_DATA1_BASE_IDX                                                              0
#define regSDMA_RLC0_MIDCMD_DATA2                                                                       0x0172
#define regSDMA_RLC0_MIDCMD_DATA2_BASE_IDX                                                              0
#define regSDMA_RLC0_MIDCMD_DATA3                                                                       0x0173
#define regSDMA_RLC0_MIDCMD_DATA3_BASE_IDX                                                              0
#define regSDMA_RLC0_MIDCMD_DATA4                                                                       0x0174
#define regSDMA_RLC0_MIDCMD_DATA4_BASE_IDX                                                              0
#define regSDMA_RLC0_MIDCMD_DATA5                                                                       0x0175
#define regSDMA_RLC0_MIDCMD_DATA5_BASE_IDX                                                              0
#define regSDMA_RLC0_MIDCMD_DATA6                                                                       0x0176
#define regSDMA_RLC0_MIDCMD_DATA6_BASE_IDX                                                              0
#define regSDMA_RLC0_MIDCMD_DATA7                                                                       0x0177
#define regSDMA_RLC0_MIDCMD_DATA7_BASE_IDX                                                              0
#define regSDMA_RLC0_MIDCMD_DATA8                                                                       0x0178
#define regSDMA_RLC0_MIDCMD_DATA8_BASE_IDX                                                              0
#define regSDMA_RLC0_MIDCMD_DATA9                                                                       0x0179
#define regSDMA_RLC0_MIDCMD_DATA9_BASE_IDX                                                              0
#define regSDMA_RLC0_MIDCMD_DATA10                                                                      0x017a
#define regSDMA_RLC0_MIDCMD_DATA10_BASE_IDX                                                             0
#define regSDMA_RLC0_MIDCMD_CNTL                                                                        0x017b
#define regSDMA_RLC0_MIDCMD_CNTL_BASE_IDX                                                               0
#define regSDMA_RLC1_RB_CNTL                                                                            0x0188
#define regSDMA_RLC1_RB_CNTL_BASE_IDX                                                                   0
#define regSDMA_RLC1_RB_BASE                                                                            0x0189
#define regSDMA_RLC1_RB_BASE_BASE_IDX                                                                   0
#define regSDMA_RLC1_RB_BASE_HI                                                                         0x018a
#define regSDMA_RLC1_RB_BASE_HI_BASE_IDX                                                                0
#define regSDMA_RLC1_RB_RPTR                                                                            0x018b
#define regSDMA_RLC1_RB_RPTR_BASE_IDX                                                                   0
#define regSDMA_RLC1_RB_RPTR_HI                                                                         0x018c
#define regSDMA_RLC1_RB_RPTR_HI_BASE_IDX                                                                0
#define regSDMA_RLC1_RB_WPTR                                                                            0x018d
#define regSDMA_RLC1_RB_WPTR_BASE_IDX                                                                   0
#define regSDMA_RLC1_RB_WPTR_HI                                                                         0x018e
#define regSDMA_RLC1_RB_WPTR_HI_BASE_IDX                                                                0
#define regSDMA_RLC1_RB_WPTR_POLL_CNTL                                                                  0x018f
#define regSDMA_RLC1_RB_WPTR_POLL_CNTL_BASE_IDX                                                         0
#define regSDMA_RLC1_RB_RPTR_ADDR_HI                                                                    0x0190
#define regSDMA_RLC1_RB_RPTR_ADDR_HI_BASE_IDX                                                           0
#define regSDMA_RLC1_RB_RPTR_ADDR_LO                                                                    0x0191
#define regSDMA_RLC1_RB_RPTR_ADDR_LO_BASE_IDX                                                           0
#define regSDMA_RLC1_IB_CNTL                                                                            0x0192
#define regSDMA_RLC1_IB_CNTL_BASE_IDX                                                                   0
#define regSDMA_RLC1_IB_RPTR                                                                            0x0193
#define regSDMA_RLC1_IB_RPTR_BASE_IDX                                                                   0
#define regSDMA_RLC1_IB_OFFSET                                                                          0x0194
#define regSDMA_RLC1_IB_OFFSET_BASE_IDX                                                                 0
#define regSDMA_RLC1_IB_BASE_LO                                                                         0x0195
#define regSDMA_RLC1_IB_BASE_LO_BASE_IDX                                                                0
#define regSDMA_RLC1_IB_BASE_HI                                                                         0x0196
#define regSDMA_RLC1_IB_BASE_HI_BASE_IDX                                                                0
#define regSDMA_RLC1_IB_SIZE                                                                            0x0197
#define regSDMA_RLC1_IB_SIZE_BASE_IDX                                                                   0
#define regSDMA_RLC1_SKIP_CNTL                                                                          0x0198
#define regSDMA_RLC1_SKIP_CNTL_BASE_IDX                                                                 0
#define regSDMA_RLC1_CONTEXT_STATUS                                                                     0x0199
#define regSDMA_RLC1_CONTEXT_STATUS_BASE_IDX                                                            0
#define regSDMA_RLC1_DOORBELL                                                                           0x019a
#define regSDMA_RLC1_DOORBELL_BASE_IDX                                                                  0
#define regSDMA_RLC1_STATUS                                                                             0x01b0
#define regSDMA_RLC1_STATUS_BASE_IDX                                                                    0
#define regSDMA_RLC1_DOORBELL_LOG                                                                       0x01b1
#define regSDMA_RLC1_DOORBELL_LOG_BASE_IDX                                                              0
#define regSDMA_RLC1_WATERMARK                                                                          0x01b2
#define regSDMA_RLC1_WATERMARK_BASE_IDX                                                                 0
#define regSDMA_RLC1_DOORBELL_OFFSET                                                                    0x01b3
#define regSDMA_RLC1_DOORBELL_OFFSET_BASE_IDX                                                           0
#define regSDMA_RLC1_CSA_ADDR_LO                                                                        0x01b4
#define regSDMA_RLC1_CSA_ADDR_LO_BASE_IDX                                                               0
#define regSDMA_RLC1_CSA_ADDR_HI                                                                        0x01b5
#define regSDMA_RLC1_CSA_ADDR_HI_BASE_IDX                                                               0
#define regSDMA_RLC1_IB_SUB_REMAIN                                                                      0x01b7
#define regSDMA_RLC1_IB_SUB_REMAIN_BASE_IDX                                                             0
#define regSDMA_RLC1_PREEMPT                                                                            0x01b8
#define regSDMA_RLC1_PREEMPT_BASE_IDX                                                                   0
#define regSDMA_RLC1_DUMMY_REG                                                                          0x01b9
#define regSDMA_RLC1_DUMMY_REG_BASE_IDX                                                                 0
#define regSDMA_RLC1_RB_WPTR_POLL_ADDR_HI                                                               0x01ba
#define regSDMA_RLC1_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                      0
#define regSDMA_RLC1_RB_WPTR_POLL_ADDR_LO                                                               0x01bb
#define regSDMA_RLC1_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                      0
#define regSDMA_RLC1_RB_AQL_CNTL                                                                        0x01bc
#define regSDMA_RLC1_RB_AQL_CNTL_BASE_IDX                                                               0
#define regSDMA_RLC1_MINOR_PTR_UPDATE                                                                   0x01bd
#define regSDMA_RLC1_MINOR_PTR_UPDATE_BASE_IDX                                                          0
#define regSDMA_RLC1_MIDCMD_DATA0                                                                       0x01c8
#define regSDMA_RLC1_MIDCMD_DATA0_BASE_IDX                                                              0
#define regSDMA_RLC1_MIDCMD_DATA1                                                                       0x01c9
#define regSDMA_RLC1_MIDCMD_DATA1_BASE_IDX                                                              0
#define regSDMA_RLC1_MIDCMD_DATA2                                                                       0x01ca
#define regSDMA_RLC1_MIDCMD_DATA2_BASE_IDX                                                              0
#define regSDMA_RLC1_MIDCMD_DATA3                                                                       0x01cb
#define regSDMA_RLC1_MIDCMD_DATA3_BASE_IDX                                                              0
#define regSDMA_RLC1_MIDCMD_DATA4                                                                       0x01cc
#define regSDMA_RLC1_MIDCMD_DATA4_BASE_IDX                                                              0
#define regSDMA_RLC1_MIDCMD_DATA5                                                                       0x01cd
#define regSDMA_RLC1_MIDCMD_DATA5_BASE_IDX                                                              0
#define regSDMA_RLC1_MIDCMD_DATA6                                                                       0x01ce
#define regSDMA_RLC1_MIDCMD_DATA6_BASE_IDX                                                              0
#define regSDMA_RLC1_MIDCMD_DATA7                                                                       0x01cf
#define regSDMA_RLC1_MIDCMD_DATA7_BASE_IDX                                                              0
#define regSDMA_RLC1_MIDCMD_DATA8                                                                       0x01d0
#define regSDMA_RLC1_MIDCMD_DATA8_BASE_IDX                                                              0
#define regSDMA_RLC1_MIDCMD_DATA9                                                                       0x01d1
#define regSDMA_RLC1_MIDCMD_DATA9_BASE_IDX                                                              0
#define regSDMA_RLC1_MIDCMD_DATA10                                                                      0x01d2
#define regSDMA_RLC1_MIDCMD_DATA10_BASE_IDX                                                             0
#define regSDMA_RLC1_MIDCMD_CNTL                                                                        0x01d3
#define regSDMA_RLC1_MIDCMD_CNTL_BASE_IDX                                                               0
#define regSDMA_RLC2_RB_CNTL                                                                            0x01e0
#define regSDMA_RLC2_RB_CNTL_BASE_IDX                                                                   0
#define regSDMA_RLC2_RB_BASE                                                                            0x01e1
#define regSDMA_RLC2_RB_BASE_BASE_IDX                                                                   0
#define regSDMA_RLC2_RB_BASE_HI                                                                         0x01e2
#define regSDMA_RLC2_RB_BASE_HI_BASE_IDX                                                                0
#define regSDMA_RLC2_RB_RPTR                                                                            0x01e3
#define regSDMA_RLC2_RB_RPTR_BASE_IDX                                                                   0
#define regSDMA_RLC2_RB_RPTR_HI                                                                         0x01e4
#define regSDMA_RLC2_RB_RPTR_HI_BASE_IDX                                                                0
#define regSDMA_RLC2_RB_WPTR                                                                            0x01e5
#define regSDMA_RLC2_RB_WPTR_BASE_IDX                                                                   0
#define regSDMA_RLC2_RB_WPTR_HI                                                                         0x01e6
#define regSDMA_RLC2_RB_WPTR_HI_BASE_IDX                                                                0
#define regSDMA_RLC2_RB_WPTR_POLL_CNTL                                                                  0x01e7
#define regSDMA_RLC2_RB_WPTR_POLL_CNTL_BASE_IDX                                                         0
#define regSDMA_RLC2_RB_RPTR_ADDR_HI                                                                    0x01e8
#define regSDMA_RLC2_RB_RPTR_ADDR_HI_BASE_IDX                                                           0
#define regSDMA_RLC2_RB_RPTR_ADDR_LO                                                                    0x01e9
#define regSDMA_RLC2_RB_RPTR_ADDR_LO_BASE_IDX                                                           0
#define regSDMA_RLC2_IB_CNTL                                                                            0x01ea
#define regSDMA_RLC2_IB_CNTL_BASE_IDX                                                                   0
#define regSDMA_RLC2_IB_RPTR                                                                            0x01eb
#define regSDMA_RLC2_IB_RPTR_BASE_IDX                                                                   0
#define regSDMA_RLC2_IB_OFFSET                                                                          0x01ec
#define regSDMA_RLC2_IB_OFFSET_BASE_IDX                                                                 0
#define regSDMA_RLC2_IB_BASE_LO                                                                         0x01ed
#define regSDMA_RLC2_IB_BASE_LO_BASE_IDX                                                                0
#define regSDMA_RLC2_IB_BASE_HI                                                                         0x01ee
#define regSDMA_RLC2_IB_BASE_HI_BASE_IDX                                                                0
#define regSDMA_RLC2_IB_SIZE                                                                            0x01ef
#define regSDMA_RLC2_IB_SIZE_BASE_IDX                                                                   0
#define regSDMA_RLC2_SKIP_CNTL                                                                          0x01f0
#define regSDMA_RLC2_SKIP_CNTL_BASE_IDX                                                                 0
#define regSDMA_RLC2_CONTEXT_STATUS                                                                     0x01f1
#define regSDMA_RLC2_CONTEXT_STATUS_BASE_IDX                                                            0
#define regSDMA_RLC2_DOORBELL                                                                           0x01f2
#define regSDMA_RLC2_DOORBELL_BASE_IDX                                                                  0
#define regSDMA_RLC2_STATUS                                                                             0x0208
#define regSDMA_RLC2_STATUS_BASE_IDX                                                                    0
#define regSDMA_RLC2_DOORBELL_LOG                                                                       0x0209
#define regSDMA_RLC2_DOORBELL_LOG_BASE_IDX                                                              0
#define regSDMA_RLC2_WATERMARK                                                                          0x020a
#define regSDMA_RLC2_WATERMARK_BASE_IDX                                                                 0
#define regSDMA_RLC2_DOORBELL_OFFSET                                                                    0x020b
#define regSDMA_RLC2_DOORBELL_OFFSET_BASE_IDX                                                           0
#define regSDMA_RLC2_CSA_ADDR_LO                                                                        0x020c
#define regSDMA_RLC2_CSA_ADDR_LO_BASE_IDX                                                               0
#define regSDMA_RLC2_CSA_ADDR_HI                                                                        0x020d
#define regSDMA_RLC2_CSA_ADDR_HI_BASE_IDX                                                               0
#define regSDMA_RLC2_IB_SUB_REMAIN                                                                      0x020f
#define regSDMA_RLC2_IB_SUB_REMAIN_BASE_IDX                                                             0
#define regSDMA_RLC2_PREEMPT                                                                            0x0210
#define regSDMA_RLC2_PREEMPT_BASE_IDX                                                                   0
#define regSDMA_RLC2_DUMMY_REG                                                                          0x0211
#define regSDMA_RLC2_DUMMY_REG_BASE_IDX                                                                 0
#define regSDMA_RLC2_RB_WPTR_POLL_ADDR_HI                                                               0x0212
#define regSDMA_RLC2_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                      0
#define regSDMA_RLC2_RB_WPTR_POLL_ADDR_LO                                                               0x0213
#define regSDMA_RLC2_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                      0
#define regSDMA_RLC2_RB_AQL_CNTL                                                                        0x0214
#define regSDMA_RLC2_RB_AQL_CNTL_BASE_IDX                                                               0
#define regSDMA_RLC2_MINOR_PTR_UPDATE                                                                   0x0215
#define regSDMA_RLC2_MINOR_PTR_UPDATE_BASE_IDX                                                          0
#define regSDMA_RLC2_MIDCMD_DATA0                                                                       0x0220
#define regSDMA_RLC2_MIDCMD_DATA0_BASE_IDX                                                              0
#define regSDMA_RLC2_MIDCMD_DATA1                                                                       0x0221
#define regSDMA_RLC2_MIDCMD_DATA1_BASE_IDX                                                              0
#define regSDMA_RLC2_MIDCMD_DATA2                                                                       0x0222
#define regSDMA_RLC2_MIDCMD_DATA2_BASE_IDX                                                              0
#define regSDMA_RLC2_MIDCMD_DATA3                                                                       0x0223
#define regSDMA_RLC2_MIDCMD_DATA3_BASE_IDX                                                              0
#define regSDMA_RLC2_MIDCMD_DATA4                                                                       0x0224
#define regSDMA_RLC2_MIDCMD_DATA4_BASE_IDX                                                              0
#define regSDMA_RLC2_MIDCMD_DATA5                                                                       0x0225
#define regSDMA_RLC2_MIDCMD_DATA5_BASE_IDX                                                              0
#define regSDMA_RLC2_MIDCMD_DATA6                                                                       0x0226
#define regSDMA_RLC2_MIDCMD_DATA6_BASE_IDX                                                              0
#define regSDMA_RLC2_MIDCMD_DATA7                                                                       0x0227
#define regSDMA_RLC2_MIDCMD_DATA7_BASE_IDX                                                              0
#define regSDMA_RLC2_MIDCMD_DATA8                                                                       0x0228
#define regSDMA_RLC2_MIDCMD_DATA8_BASE_IDX                                                              0
#define regSDMA_RLC2_MIDCMD_DATA9                                                                       0x0229
#define regSDMA_RLC2_MIDCMD_DATA9_BASE_IDX                                                              0
#define regSDMA_RLC2_MIDCMD_DATA10                                                                      0x022a
#define regSDMA_RLC2_MIDCMD_DATA10_BASE_IDX                                                             0
#define regSDMA_RLC2_MIDCMD_CNTL                                                                        0x022b
#define regSDMA_RLC2_MIDCMD_CNTL_BASE_IDX                                                               0
#define regSDMA_RLC3_RB_CNTL                                                                            0x0238
#define regSDMA_RLC3_RB_CNTL_BASE_IDX                                                                   0
#define regSDMA_RLC3_RB_BASE                                                                            0x0239
#define regSDMA_RLC3_RB_BASE_BASE_IDX                                                                   0
#define regSDMA_RLC3_RB_BASE_HI                                                                         0x023a
#define regSDMA_RLC3_RB_BASE_HI_BASE_IDX                                                                0
#define regSDMA_RLC3_RB_RPTR                                                                            0x023b
#define regSDMA_RLC3_RB_RPTR_BASE_IDX                                                                   0
#define regSDMA_RLC3_RB_RPTR_HI                                                                         0x023c
#define regSDMA_RLC3_RB_RPTR_HI_BASE_IDX                                                                0
#define regSDMA_RLC3_RB_WPTR                                                                            0x023d
#define regSDMA_RLC3_RB_WPTR_BASE_IDX                                                                   0
#define regSDMA_RLC3_RB_WPTR_HI                                                                         0x023e
#define regSDMA_RLC3_RB_WPTR_HI_BASE_IDX                                                                0
#define regSDMA_RLC3_RB_WPTR_POLL_CNTL                                                                  0x023f
#define regSDMA_RLC3_RB_WPTR_POLL_CNTL_BASE_IDX                                                         0
#define regSDMA_RLC3_RB_RPTR_ADDR_HI                                                                    0x0240
#define regSDMA_RLC3_RB_RPTR_ADDR_HI_BASE_IDX                                                           0
#define regSDMA_RLC3_RB_RPTR_ADDR_LO                                                                    0x0241
#define regSDMA_RLC3_RB_RPTR_ADDR_LO_BASE_IDX                                                           0
#define regSDMA_RLC3_IB_CNTL                                                                            0x0242
#define regSDMA_RLC3_IB_CNTL_BASE_IDX                                                                   0
#define regSDMA_RLC3_IB_RPTR                                                                            0x0243
#define regSDMA_RLC3_IB_RPTR_BASE_IDX                                                                   0
#define regSDMA_RLC3_IB_OFFSET                                                                          0x0244
#define regSDMA_RLC3_IB_OFFSET_BASE_IDX                                                                 0
#define regSDMA_RLC3_IB_BASE_LO                                                                         0x0245
#define regSDMA_RLC3_IB_BASE_LO_BASE_IDX                                                                0
#define regSDMA_RLC3_IB_BASE_HI                                                                         0x0246
#define regSDMA_RLC3_IB_BASE_HI_BASE_IDX                                                                0
#define regSDMA_RLC3_IB_SIZE                                                                            0x0247
#define regSDMA_RLC3_IB_SIZE_BASE_IDX                                                                   0
#define regSDMA_RLC3_SKIP_CNTL                                                                          0x0248
#define regSDMA_RLC3_SKIP_CNTL_BASE_IDX                                                                 0
#define regSDMA_RLC3_CONTEXT_STATUS                                                                     0x0249
#define regSDMA_RLC3_CONTEXT_STATUS_BASE_IDX                                                            0
#define regSDMA_RLC3_DOORBELL                                                                           0x024a
#define regSDMA_RLC3_DOORBELL_BASE_IDX                                                                  0
#define regSDMA_RLC3_STATUS                                                                             0x0260
#define regSDMA_RLC3_STATUS_BASE_IDX                                                                    0
#define regSDMA_RLC3_DOORBELL_LOG                                                                       0x0261
#define regSDMA_RLC3_DOORBELL_LOG_BASE_IDX                                                              0
#define regSDMA_RLC3_WATERMARK                                                                          0x0262
#define regSDMA_RLC3_WATERMARK_BASE_IDX                                                                 0
#define regSDMA_RLC3_DOORBELL_OFFSET                                                                    0x0263
#define regSDMA_RLC3_DOORBELL_OFFSET_BASE_IDX                                                           0
#define regSDMA_RLC3_CSA_ADDR_LO                                                                        0x0264
#define regSDMA_RLC3_CSA_ADDR_LO_BASE_IDX                                                               0
#define regSDMA_RLC3_CSA_ADDR_HI                                                                        0x0265
#define regSDMA_RLC3_CSA_ADDR_HI_BASE_IDX                                                               0
#define regSDMA_RLC3_IB_SUB_REMAIN                                                                      0x0267
#define regSDMA_RLC3_IB_SUB_REMAIN_BASE_IDX                                                             0
#define regSDMA_RLC3_PREEMPT                                                                            0x0268
#define regSDMA_RLC3_PREEMPT_BASE_IDX                                                                   0
#define regSDMA_RLC3_DUMMY_REG                                                                          0x0269
#define regSDMA_RLC3_DUMMY_REG_BASE_IDX                                                                 0
#define regSDMA_RLC3_RB_WPTR_POLL_ADDR_HI                                                               0x026a
#define regSDMA_RLC3_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                      0
#define regSDMA_RLC3_RB_WPTR_POLL_ADDR_LO                                                               0x026b
#define regSDMA_RLC3_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                      0
#define regSDMA_RLC3_RB_AQL_CNTL                                                                        0x026c
#define regSDMA_RLC3_RB_AQL_CNTL_BASE_IDX                                                               0
#define regSDMA_RLC3_MINOR_PTR_UPDATE                                                                   0x026d
#define regSDMA_RLC3_MINOR_PTR_UPDATE_BASE_IDX                                                          0
#define regSDMA_RLC3_MIDCMD_DATA0                                                                       0x0278
#define regSDMA_RLC3_MIDCMD_DATA0_BASE_IDX                                                              0
#define regSDMA_RLC3_MIDCMD_DATA1                                                                       0x0279
#define regSDMA_RLC3_MIDCMD_DATA1_BASE_IDX                                                              0
#define regSDMA_RLC3_MIDCMD_DATA2                                                                       0x027a
#define regSDMA_RLC3_MIDCMD_DATA2_BASE_IDX                                                              0
#define regSDMA_RLC3_MIDCMD_DATA3                                                                       0x027b
#define regSDMA_RLC3_MIDCMD_DATA3_BASE_IDX                                                              0
#define regSDMA_RLC3_MIDCMD_DATA4                                                                       0x027c
#define regSDMA_RLC3_MIDCMD_DATA4_BASE_IDX                                                              0
#define regSDMA_RLC3_MIDCMD_DATA5                                                                       0x027d
#define regSDMA_RLC3_MIDCMD_DATA5_BASE_IDX                                                              0
#define regSDMA_RLC3_MIDCMD_DATA6                                                                       0x027e
#define regSDMA_RLC3_MIDCMD_DATA6_BASE_IDX                                                              0
#define regSDMA_RLC3_MIDCMD_DATA7                                                                       0x027f
#define regSDMA_RLC3_MIDCMD_DATA7_BASE_IDX                                                              0
#define regSDMA_RLC3_MIDCMD_DATA8                                                                       0x0280
#define regSDMA_RLC3_MIDCMD_DATA8_BASE_IDX                                                              0
#define regSDMA_RLC3_MIDCMD_DATA9                                                                       0x0281
#define regSDMA_RLC3_MIDCMD_DATA9_BASE_IDX                                                              0
#define regSDMA_RLC3_MIDCMD_DATA10                                                                      0x0282
#define regSDMA_RLC3_MIDCMD_DATA10_BASE_IDX                                                             0
#define regSDMA_RLC3_MIDCMD_CNTL                                                                        0x0283
#define regSDMA_RLC3_MIDCMD_CNTL_BASE_IDX                                                               0
#define regSDMA_RLC4_RB_CNTL                                                                            0x0290
#define regSDMA_RLC4_RB_CNTL_BASE_IDX                                                                   0
#define regSDMA_RLC4_RB_BASE                                                                            0x0291
#define regSDMA_RLC4_RB_BASE_BASE_IDX                                                                   0
#define regSDMA_RLC4_RB_BASE_HI                                                                         0x0292
#define regSDMA_RLC4_RB_BASE_HI_BASE_IDX                                                                0
#define regSDMA_RLC4_RB_RPTR                                                                            0x0293
#define regSDMA_RLC4_RB_RPTR_BASE_IDX                                                                   0
#define regSDMA_RLC4_RB_RPTR_HI                                                                         0x0294
#define regSDMA_RLC4_RB_RPTR_HI_BASE_IDX                                                                0
#define regSDMA_RLC4_RB_WPTR                                                                            0x0295
#define regSDMA_RLC4_RB_WPTR_BASE_IDX                                                                   0
#define regSDMA_RLC4_RB_WPTR_HI                                                                         0x0296
#define regSDMA_RLC4_RB_WPTR_HI_BASE_IDX                                                                0
#define regSDMA_RLC4_RB_WPTR_POLL_CNTL                                                                  0x0297
#define regSDMA_RLC4_RB_WPTR_POLL_CNTL_BASE_IDX                                                         0
#define regSDMA_RLC4_RB_RPTR_ADDR_HI                                                                    0x0298
#define regSDMA_RLC4_RB_RPTR_ADDR_HI_BASE_IDX                                                           0
#define regSDMA_RLC4_RB_RPTR_ADDR_LO                                                                    0x0299
#define regSDMA_RLC4_RB_RPTR_ADDR_LO_BASE_IDX                                                           0
#define regSDMA_RLC4_IB_CNTL                                                                            0x029a
#define regSDMA_RLC4_IB_CNTL_BASE_IDX                                                                   0
#define regSDMA_RLC4_IB_RPTR                                                                            0x029b
#define regSDMA_RLC4_IB_RPTR_BASE_IDX                                                                   0
#define regSDMA_RLC4_IB_OFFSET                                                                          0x029c
#define regSDMA_RLC4_IB_OFFSET_BASE_IDX                                                                 0
#define regSDMA_RLC4_IB_BASE_LO                                                                         0x029d
#define regSDMA_RLC4_IB_BASE_LO_BASE_IDX                                                                0
#define regSDMA_RLC4_IB_BASE_HI                                                                         0x029e
#define regSDMA_RLC4_IB_BASE_HI_BASE_IDX                                                                0
#define regSDMA_RLC4_IB_SIZE                                                                            0x029f
#define regSDMA_RLC4_IB_SIZE_BASE_IDX                                                                   0
#define regSDMA_RLC4_SKIP_CNTL                                                                          0x02a0
#define regSDMA_RLC4_SKIP_CNTL_BASE_IDX                                                                 0
#define regSDMA_RLC4_CONTEXT_STATUS                                                                     0x02a1
#define regSDMA_RLC4_CONTEXT_STATUS_BASE_IDX                                                            0
#define regSDMA_RLC4_DOORBELL                                                                           0x02a2
#define regSDMA_RLC4_DOORBELL_BASE_IDX                                                                  0
#define regSDMA_RLC4_STATUS                                                                             0x02b8
#define regSDMA_RLC4_STATUS_BASE_IDX                                                                    0
#define regSDMA_RLC4_DOORBELL_LOG                                                                       0x02b9
#define regSDMA_RLC4_DOORBELL_LOG_BASE_IDX                                                              0
#define regSDMA_RLC4_WATERMARK                                                                          0x02ba
#define regSDMA_RLC4_WATERMARK_BASE_IDX                                                                 0
#define regSDMA_RLC4_DOORBELL_OFFSET                                                                    0x02bb
#define regSDMA_RLC4_DOORBELL_OFFSET_BASE_IDX                                                           0
#define regSDMA_RLC4_CSA_ADDR_LO                                                                        0x02bc
#define regSDMA_RLC4_CSA_ADDR_LO_BASE_IDX                                                               0
#define regSDMA_RLC4_CSA_ADDR_HI                                                                        0x02bd
#define regSDMA_RLC4_CSA_ADDR_HI_BASE_IDX                                                               0
#define regSDMA_RLC4_IB_SUB_REMAIN                                                                      0x02bf
#define regSDMA_RLC4_IB_SUB_REMAIN_BASE_IDX                                                             0
#define regSDMA_RLC4_PREEMPT                                                                            0x02c0
#define regSDMA_RLC4_PREEMPT_BASE_IDX                                                                   0
#define regSDMA_RLC4_DUMMY_REG                                                                          0x02c1
#define regSDMA_RLC4_DUMMY_REG_BASE_IDX                                                                 0
#define regSDMA_RLC4_RB_WPTR_POLL_ADDR_HI                                                               0x02c2
#define regSDMA_RLC4_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                      0
#define regSDMA_RLC4_RB_WPTR_POLL_ADDR_LO                                                               0x02c3
#define regSDMA_RLC4_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                      0
#define regSDMA_RLC4_RB_AQL_CNTL                                                                        0x02c4
#define regSDMA_RLC4_RB_AQL_CNTL_BASE_IDX                                                               0
#define regSDMA_RLC4_MINOR_PTR_UPDATE                                                                   0x02c5
#define regSDMA_RLC4_MINOR_PTR_UPDATE_BASE_IDX                                                          0
#define regSDMA_RLC4_MIDCMD_DATA0                                                                       0x02d0
#define regSDMA_RLC4_MIDCMD_DATA0_BASE_IDX                                                              0
#define regSDMA_RLC4_MIDCMD_DATA1                                                                       0x02d1
#define regSDMA_RLC4_MIDCMD_DATA1_BASE_IDX                                                              0
#define regSDMA_RLC4_MIDCMD_DATA2                                                                       0x02d2
#define regSDMA_RLC4_MIDCMD_DATA2_BASE_IDX                                                              0
#define regSDMA_RLC4_MIDCMD_DATA3                                                                       0x02d3
#define regSDMA_RLC4_MIDCMD_DATA3_BASE_IDX                                                              0
#define regSDMA_RLC4_MIDCMD_DATA4                                                                       0x02d4
#define regSDMA_RLC4_MIDCMD_DATA4_BASE_IDX                                                              0
#define regSDMA_RLC4_MIDCMD_DATA5                                                                       0x02d5
#define regSDMA_RLC4_MIDCMD_DATA5_BASE_IDX                                                              0
#define regSDMA_RLC4_MIDCMD_DATA6                                                                       0x02d6
#define regSDMA_RLC4_MIDCMD_DATA6_BASE_IDX                                                              0
#define regSDMA_RLC4_MIDCMD_DATA7                                                                       0x02d7
#define regSDMA_RLC4_MIDCMD_DATA7_BASE_IDX                                                              0
#define regSDMA_RLC4_MIDCMD_DATA8                                                                       0x02d8
#define regSDMA_RLC4_MIDCMD_DATA8_BASE_IDX                                                              0
#define regSDMA_RLC4_MIDCMD_DATA9                                                                       0x02d9
#define regSDMA_RLC4_MIDCMD_DATA9_BASE_IDX                                                              0
#define regSDMA_RLC4_MIDCMD_DATA10                                                                      0x02da
#define regSDMA_RLC4_MIDCMD_DATA10_BASE_IDX                                                             0
#define regSDMA_RLC4_MIDCMD_CNTL                                                                        0x02db
#define regSDMA_RLC4_MIDCMD_CNTL_BASE_IDX                                                               0
#define regSDMA_RLC5_RB_CNTL                                                                            0x02e8
#define regSDMA_RLC5_RB_CNTL_BASE_IDX                                                                   0
#define regSDMA_RLC5_RB_BASE                                                                            0x02e9
#define regSDMA_RLC5_RB_BASE_BASE_IDX                                                                   0
#define regSDMA_RLC5_RB_BASE_HI                                                                         0x02ea
#define regSDMA_RLC5_RB_BASE_HI_BASE_IDX                                                                0
#define regSDMA_RLC5_RB_RPTR                                                                            0x02eb
#define regSDMA_RLC5_RB_RPTR_BASE_IDX                                                                   0
#define regSDMA_RLC5_RB_RPTR_HI                                                                         0x02ec
#define regSDMA_RLC5_RB_RPTR_HI_BASE_IDX                                                                0
#define regSDMA_RLC5_RB_WPTR                                                                            0x02ed
#define regSDMA_RLC5_RB_WPTR_BASE_IDX                                                                   0
#define regSDMA_RLC5_RB_WPTR_HI                                                                         0x02ee
#define regSDMA_RLC5_RB_WPTR_HI_BASE_IDX                                                                0
#define regSDMA_RLC5_RB_WPTR_POLL_CNTL                                                                  0x02ef
#define regSDMA_RLC5_RB_WPTR_POLL_CNTL_BASE_IDX                                                         0
#define regSDMA_RLC5_RB_RPTR_ADDR_HI                                                                    0x02f0
#define regSDMA_RLC5_RB_RPTR_ADDR_HI_BASE_IDX                                                           0
#define regSDMA_RLC5_RB_RPTR_ADDR_LO                                                                    0x02f1
#define regSDMA_RLC5_RB_RPTR_ADDR_LO_BASE_IDX                                                           0
#define regSDMA_RLC5_IB_CNTL                                                                            0x02f2
#define regSDMA_RLC5_IB_CNTL_BASE_IDX                                                                   0
#define regSDMA_RLC5_IB_RPTR                                                                            0x02f3
#define regSDMA_RLC5_IB_RPTR_BASE_IDX                                                                   0
#define regSDMA_RLC5_IB_OFFSET                                                                          0x02f4
#define regSDMA_RLC5_IB_OFFSET_BASE_IDX                                                                 0
#define regSDMA_RLC5_IB_BASE_LO                                                                         0x02f5
#define regSDMA_RLC5_IB_BASE_LO_BASE_IDX                                                                0
#define regSDMA_RLC5_IB_BASE_HI                                                                         0x02f6
#define regSDMA_RLC5_IB_BASE_HI_BASE_IDX                                                                0
#define regSDMA_RLC5_IB_SIZE                                                                            0x02f7
#define regSDMA_RLC5_IB_SIZE_BASE_IDX                                                                   0
#define regSDMA_RLC5_SKIP_CNTL                                                                          0x02f8
#define regSDMA_RLC5_SKIP_CNTL_BASE_IDX                                                                 0
#define regSDMA_RLC5_CONTEXT_STATUS                                                                     0x02f9
#define regSDMA_RLC5_CONTEXT_STATUS_BASE_IDX                                                            0
#define regSDMA_RLC5_DOORBELL                                                                           0x02fa
#define regSDMA_RLC5_DOORBELL_BASE_IDX                                                                  0
#define regSDMA_RLC5_STATUS                                                                             0x0310
#define regSDMA_RLC5_STATUS_BASE_IDX                                                                    0
#define regSDMA_RLC5_DOORBELL_LOG                                                                       0x0311
#define regSDMA_RLC5_DOORBELL_LOG_BASE_IDX                                                              0
#define regSDMA_RLC5_WATERMARK                                                                          0x0312
#define regSDMA_RLC5_WATERMARK_BASE_IDX                                                                 0
#define regSDMA_RLC5_DOORBELL_OFFSET                                                                    0x0313
#define regSDMA_RLC5_DOORBELL_OFFSET_BASE_IDX                                                           0
#define regSDMA_RLC5_CSA_ADDR_LO                                                                        0x0314
#define regSDMA_RLC5_CSA_ADDR_LO_BASE_IDX                                                               0
#define regSDMA_RLC5_CSA_ADDR_HI                                                                        0x0315
#define regSDMA_RLC5_CSA_ADDR_HI_BASE_IDX                                                               0
#define regSDMA_RLC5_IB_SUB_REMAIN                                                                      0x0317
#define regSDMA_RLC5_IB_SUB_REMAIN_BASE_IDX                                                             0
#define regSDMA_RLC5_PREEMPT                                                                            0x0318
#define regSDMA_RLC5_PREEMPT_BASE_IDX                                                                   0
#define regSDMA_RLC5_DUMMY_REG                                                                          0x0319
#define regSDMA_RLC5_DUMMY_REG_BASE_IDX                                                                 0
#define regSDMA_RLC5_RB_WPTR_POLL_ADDR_HI                                                               0x031a
#define regSDMA_RLC5_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                      0
#define regSDMA_RLC5_RB_WPTR_POLL_ADDR_LO                                                               0x031b
#define regSDMA_RLC5_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                      0
#define regSDMA_RLC5_RB_AQL_CNTL                                                                        0x031c
#define regSDMA_RLC5_RB_AQL_CNTL_BASE_IDX                                                               0
#define regSDMA_RLC5_MINOR_PTR_UPDATE                                                                   0x031d
#define regSDMA_RLC5_MINOR_PTR_UPDATE_BASE_IDX                                                          0
#define regSDMA_RLC5_MIDCMD_DATA0                                                                       0x0328
#define regSDMA_RLC5_MIDCMD_DATA0_BASE_IDX                                                              0
#define regSDMA_RLC5_MIDCMD_DATA1                                                                       0x0329
#define regSDMA_RLC5_MIDCMD_DATA1_BASE_IDX                                                              0
#define regSDMA_RLC5_MIDCMD_DATA2                                                                       0x032a
#define regSDMA_RLC5_MIDCMD_DATA2_BASE_IDX                                                              0
#define regSDMA_RLC5_MIDCMD_DATA3                                                                       0x032b
#define regSDMA_RLC5_MIDCMD_DATA3_BASE_IDX                                                              0
#define regSDMA_RLC5_MIDCMD_DATA4                                                                       0x032c
#define regSDMA_RLC5_MIDCMD_DATA4_BASE_IDX                                                              0
#define regSDMA_RLC5_MIDCMD_DATA5                                                                       0x032d
#define regSDMA_RLC5_MIDCMD_DATA5_BASE_IDX                                                              0
#define regSDMA_RLC5_MIDCMD_DATA6                                                                       0x032e
#define regSDMA_RLC5_MIDCMD_DATA6_BASE_IDX                                                              0
#define regSDMA_RLC5_MIDCMD_DATA7                                                                       0x032f
#define regSDMA_RLC5_MIDCMD_DATA7_BASE_IDX                                                              0
#define regSDMA_RLC5_MIDCMD_DATA8                                                                       0x0330
#define regSDMA_RLC5_MIDCMD_DATA8_BASE_IDX                                                              0
#define regSDMA_RLC5_MIDCMD_DATA9                                                                       0x0331
#define regSDMA_RLC5_MIDCMD_DATA9_BASE_IDX                                                              0
#define regSDMA_RLC5_MIDCMD_DATA10                                                                      0x0332
#define regSDMA_RLC5_MIDCMD_DATA10_BASE_IDX                                                             0
#define regSDMA_RLC5_MIDCMD_CNTL                                                                        0x0333
#define regSDMA_RLC5_MIDCMD_CNTL_BASE_IDX                                                               0
#define regSDMA_RLC6_RB_CNTL                                                                            0x0340
#define regSDMA_RLC6_RB_CNTL_BASE_IDX                                                                   0
#define regSDMA_RLC6_RB_BASE                                                                            0x0341
#define regSDMA_RLC6_RB_BASE_BASE_IDX                                                                   0
#define regSDMA_RLC6_RB_BASE_HI                                                                         0x0342
#define regSDMA_RLC6_RB_BASE_HI_BASE_IDX                                                                0
#define regSDMA_RLC6_RB_RPTR                                                                            0x0343
#define regSDMA_RLC6_RB_RPTR_BASE_IDX                                                                   0
#define regSDMA_RLC6_RB_RPTR_HI                                                                         0x0344
#define regSDMA_RLC6_RB_RPTR_HI_BASE_IDX                                                                0
#define regSDMA_RLC6_RB_WPTR                                                                            0x0345
#define regSDMA_RLC6_RB_WPTR_BASE_IDX                                                                   0
#define regSDMA_RLC6_RB_WPTR_HI                                                                         0x0346
#define regSDMA_RLC6_RB_WPTR_HI_BASE_IDX                                                                0
#define regSDMA_RLC6_RB_WPTR_POLL_CNTL                                                                  0x0347
#define regSDMA_RLC6_RB_WPTR_POLL_CNTL_BASE_IDX                                                         0
#define regSDMA_RLC6_RB_RPTR_ADDR_HI                                                                    0x0348
#define regSDMA_RLC6_RB_RPTR_ADDR_HI_BASE_IDX                                                           0
#define regSDMA_RLC6_RB_RPTR_ADDR_LO                                                                    0x0349
#define regSDMA_RLC6_RB_RPTR_ADDR_LO_BASE_IDX                                                           0
#define regSDMA_RLC6_IB_CNTL                                                                            0x034a
#define regSDMA_RLC6_IB_CNTL_BASE_IDX                                                                   0
#define regSDMA_RLC6_IB_RPTR                                                                            0x034b
#define regSDMA_RLC6_IB_RPTR_BASE_IDX                                                                   0
#define regSDMA_RLC6_IB_OFFSET                                                                          0x034c
#define regSDMA_RLC6_IB_OFFSET_BASE_IDX                                                                 0
#define regSDMA_RLC6_IB_BASE_LO                                                                         0x034d
#define regSDMA_RLC6_IB_BASE_LO_BASE_IDX                                                                0
#define regSDMA_RLC6_IB_BASE_HI                                                                         0x034e
#define regSDMA_RLC6_IB_BASE_HI_BASE_IDX                                                                0
#define regSDMA_RLC6_IB_SIZE                                                                            0x034f
#define regSDMA_RLC6_IB_SIZE_BASE_IDX                                                                   0
#define regSDMA_RLC6_SKIP_CNTL                                                                          0x0350
#define regSDMA_RLC6_SKIP_CNTL_BASE_IDX                                                                 0
#define regSDMA_RLC6_CONTEXT_STATUS                                                                     0x0351
#define regSDMA_RLC6_CONTEXT_STATUS_BASE_IDX                                                            0
#define regSDMA_RLC6_DOORBELL                                                                           0x0352
#define regSDMA_RLC6_DOORBELL_BASE_IDX                                                                  0
#define regSDMA_RLC6_STATUS                                                                             0x0368
#define regSDMA_RLC6_STATUS_BASE_IDX                                                                    0
#define regSDMA_RLC6_DOORBELL_LOG                                                                       0x0369
#define regSDMA_RLC6_DOORBELL_LOG_BASE_IDX                                                              0
#define regSDMA_RLC6_WATERMARK                                                                          0x036a
#define regSDMA_RLC6_WATERMARK_BASE_IDX                                                                 0
#define regSDMA_RLC6_DOORBELL_OFFSET                                                                    0x036b
#define regSDMA_RLC6_DOORBELL_OFFSET_BASE_IDX                                                           0
#define regSDMA_RLC6_CSA_ADDR_LO                                                                        0x036c
#define regSDMA_RLC6_CSA_ADDR_LO_BASE_IDX                                                               0
#define regSDMA_RLC6_CSA_ADDR_HI                                                                        0x036d
#define regSDMA_RLC6_CSA_ADDR_HI_BASE_IDX                                                               0
#define regSDMA_RLC6_IB_SUB_REMAIN                                                                      0x036f
#define regSDMA_RLC6_IB_SUB_REMAIN_BASE_IDX                                                             0
#define regSDMA_RLC6_PREEMPT                                                                            0x0370
#define regSDMA_RLC6_PREEMPT_BASE_IDX                                                                   0
#define regSDMA_RLC6_DUMMY_REG                                                                          0x0371
#define regSDMA_RLC6_DUMMY_REG_BASE_IDX                                                                 0
#define regSDMA_RLC6_RB_WPTR_POLL_ADDR_HI                                                               0x0372
#define regSDMA_RLC6_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                      0
#define regSDMA_RLC6_RB_WPTR_POLL_ADDR_LO                                                               0x0373
#define regSDMA_RLC6_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                      0
#define regSDMA_RLC6_RB_AQL_CNTL                                                                        0x0374
#define regSDMA_RLC6_RB_AQL_CNTL_BASE_IDX                                                               0
#define regSDMA_RLC6_MINOR_PTR_UPDATE                                                                   0x0375
#define regSDMA_RLC6_MINOR_PTR_UPDATE_BASE_IDX                                                          0
#define regSDMA_RLC6_MIDCMD_DATA0                                                                       0x0380
#define regSDMA_RLC6_MIDCMD_DATA0_BASE_IDX                                                              0
#define regSDMA_RLC6_MIDCMD_DATA1                                                                       0x0381
#define regSDMA_RLC6_MIDCMD_DATA1_BASE_IDX                                                              0
#define regSDMA_RLC6_MIDCMD_DATA2                                                                       0x0382
#define regSDMA_RLC6_MIDCMD_DATA2_BASE_IDX                                                              0
#define regSDMA_RLC6_MIDCMD_DATA3                                                                       0x0383
#define regSDMA_RLC6_MIDCMD_DATA3_BASE_IDX                                                              0
#define regSDMA_RLC6_MIDCMD_DATA4                                                                       0x0384
#define regSDMA_RLC6_MIDCMD_DATA4_BASE_IDX                                                              0
#define regSDMA_RLC6_MIDCMD_DATA5                                                                       0x0385
#define regSDMA_RLC6_MIDCMD_DATA5_BASE_IDX                                                              0
#define regSDMA_RLC6_MIDCMD_DATA6                                                                       0x0386
#define regSDMA_RLC6_MIDCMD_DATA6_BASE_IDX                                                              0
#define regSDMA_RLC6_MIDCMD_DATA7                                                                       0x0387
#define regSDMA_RLC6_MIDCMD_DATA7_BASE_IDX                                                              0
#define regSDMA_RLC6_MIDCMD_DATA8                                                                       0x0388
#define regSDMA_RLC6_MIDCMD_DATA8_BASE_IDX                                                              0
#define regSDMA_RLC6_MIDCMD_DATA9                                                                       0x0389
#define regSDMA_RLC6_MIDCMD_DATA9_BASE_IDX                                                              0
#define regSDMA_RLC6_MIDCMD_DATA10                                                                      0x038a
#define regSDMA_RLC6_MIDCMD_DATA10_BASE_IDX                                                             0
#define regSDMA_RLC6_MIDCMD_CNTL                                                                        0x038b
#define regSDMA_RLC6_MIDCMD_CNTL_BASE_IDX                                                               0
#define regSDMA_RLC7_RB_CNTL                                                                            0x0398
#define regSDMA_RLC7_RB_CNTL_BASE_IDX                                                                   0
#define regSDMA_RLC7_RB_BASE                                                                            0x0399
#define regSDMA_RLC7_RB_BASE_BASE_IDX                                                                   0
#define regSDMA_RLC7_RB_BASE_HI                                                                         0x039a
#define regSDMA_RLC7_RB_BASE_HI_BASE_IDX                                                                0
#define regSDMA_RLC7_RB_RPTR                                                                            0x039b
#define regSDMA_RLC7_RB_RPTR_BASE_IDX                                                                   0
#define regSDMA_RLC7_RB_RPTR_HI                                                                         0x039c
#define regSDMA_RLC7_RB_RPTR_HI_BASE_IDX                                                                0
#define regSDMA_RLC7_RB_WPTR                                                                            0x039d
#define regSDMA_RLC7_RB_WPTR_BASE_IDX                                                                   0
#define regSDMA_RLC7_RB_WPTR_HI                                                                         0x039e
#define regSDMA_RLC7_RB_WPTR_HI_BASE_IDX                                                                0
#define regSDMA_RLC7_RB_WPTR_POLL_CNTL                                                                  0x039f
#define regSDMA_RLC7_RB_WPTR_POLL_CNTL_BASE_IDX                                                         0
#define regSDMA_RLC7_RB_RPTR_ADDR_HI                                                                    0x03a0
#define regSDMA_RLC7_RB_RPTR_ADDR_HI_BASE_IDX                                                           0
#define regSDMA_RLC7_RB_RPTR_ADDR_LO                                                                    0x03a1
#define regSDMA_RLC7_RB_RPTR_ADDR_LO_BASE_IDX                                                           0
#define regSDMA_RLC7_IB_CNTL                                                                            0x03a2
#define regSDMA_RLC7_IB_CNTL_BASE_IDX                                                                   0
#define regSDMA_RLC7_IB_RPTR                                                                            0x03a3
#define regSDMA_RLC7_IB_RPTR_BASE_IDX                                                                   0
#define regSDMA_RLC7_IB_OFFSET                                                                          0x03a4
#define regSDMA_RLC7_IB_OFFSET_BASE_IDX                                                                 0
#define regSDMA_RLC7_IB_BASE_LO                                                                         0x03a5
#define regSDMA_RLC7_IB_BASE_LO_BASE_IDX                                                                0
#define regSDMA_RLC7_IB_BASE_HI                                                                         0x03a6
#define regSDMA_RLC7_IB_BASE_HI_BASE_IDX                                                                0
#define regSDMA_RLC7_IB_SIZE                                                                            0x03a7
#define regSDMA_RLC7_IB_SIZE_BASE_IDX                                                                   0
#define regSDMA_RLC7_SKIP_CNTL                                                                          0x03a8
#define regSDMA_RLC7_SKIP_CNTL_BASE_IDX                                                                 0
#define regSDMA_RLC7_CONTEXT_STATUS                                                                     0x03a9
#define regSDMA_RLC7_CONTEXT_STATUS_BASE_IDX                                                            0
#define regSDMA_RLC7_DOORBELL                                                                           0x03aa
#define regSDMA_RLC7_DOORBELL_BASE_IDX                                                                  0
#define regSDMA_RLC7_STATUS                                                                             0x03c0
#define regSDMA_RLC7_STATUS_BASE_IDX                                                                    0
#define regSDMA_RLC7_DOORBELL_LOG                                                                       0x03c1
#define regSDMA_RLC7_DOORBELL_LOG_BASE_IDX                                                              0
#define regSDMA_RLC7_WATERMARK                                                                          0x03c2
#define regSDMA_RLC7_WATERMARK_BASE_IDX                                                                 0
#define regSDMA_RLC7_DOORBELL_OFFSET                                                                    0x03c3
#define regSDMA_RLC7_DOORBELL_OFFSET_BASE_IDX                                                           0
#define regSDMA_RLC7_CSA_ADDR_LO                                                                        0x03c4
#define regSDMA_RLC7_CSA_ADDR_LO_BASE_IDX                                                               0
#define regSDMA_RLC7_CSA_ADDR_HI                                                                        0x03c5
#define regSDMA_RLC7_CSA_ADDR_HI_BASE_IDX                                                               0
#define regSDMA_RLC7_IB_SUB_REMAIN                                                                      0x03c7
#define regSDMA_RLC7_IB_SUB_REMAIN_BASE_IDX                                                             0
#define regSDMA_RLC7_PREEMPT                                                                            0x03c8
#define regSDMA_RLC7_PREEMPT_BASE_IDX                                                                   0
#define regSDMA_RLC7_DUMMY_REG                                                                          0x03c9
#define regSDMA_RLC7_DUMMY_REG_BASE_IDX                                                                 0
#define regSDMA_RLC7_RB_WPTR_POLL_ADDR_HI                                                               0x03ca
#define regSDMA_RLC7_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                      0
#define regSDMA_RLC7_RB_WPTR_POLL_ADDR_LO                                                               0x03cb
#define regSDMA_RLC7_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                      0
#define regSDMA_RLC7_RB_AQL_CNTL                                                                        0x03cc
#define regSDMA_RLC7_RB_AQL_CNTL_BASE_IDX                                                               0
#define regSDMA_RLC7_MINOR_PTR_UPDATE                                                                   0x03cd
#define regSDMA_RLC7_MINOR_PTR_UPDATE_BASE_IDX                                                          0
#define regSDMA_RLC7_MIDCMD_DATA0                                                                       0x03d8
#define regSDMA_RLC7_MIDCMD_DATA0_BASE_IDX                                                              0
#define regSDMA_RLC7_MIDCMD_DATA1                                                                       0x03d9
#define regSDMA_RLC7_MIDCMD_DATA1_BASE_IDX                                                              0
#define regSDMA_RLC7_MIDCMD_DATA2                                                                       0x03da
#define regSDMA_RLC7_MIDCMD_DATA2_BASE_IDX                                                              0
#define regSDMA_RLC7_MIDCMD_DATA3                                                                       0x03db
#define regSDMA_RLC7_MIDCMD_DATA3_BASE_IDX                                                              0
#define regSDMA_RLC7_MIDCMD_DATA4                                                                       0x03dc
#define regSDMA_RLC7_MIDCMD_DATA4_BASE_IDX                                                              0
#define regSDMA_RLC7_MIDCMD_DATA5                                                                       0x03dd
#define regSDMA_RLC7_MIDCMD_DATA5_BASE_IDX                                                              0
#define regSDMA_RLC7_MIDCMD_DATA6                                                                       0x03de
#define regSDMA_RLC7_MIDCMD_DATA6_BASE_IDX                                                              0
#define regSDMA_RLC7_MIDCMD_DATA7                                                                       0x03df
#define regSDMA_RLC7_MIDCMD_DATA7_BASE_IDX                                                              0
#define regSDMA_RLC7_MIDCMD_DATA8                                                                       0x03e0
#define regSDMA_RLC7_MIDCMD_DATA8_BASE_IDX                                                              0
#define regSDMA_RLC7_MIDCMD_DATA9                                                                       0x03e1
#define regSDMA_RLC7_MIDCMD_DATA9_BASE_IDX                                                              0
#define regSDMA_RLC7_MIDCMD_DATA10                                                                      0x03e2
#define regSDMA_RLC7_MIDCMD_DATA10_BASE_IDX                                                             0
#define regSDMA_RLC7_MIDCMD_CNTL                                                                        0x03e3
#define regSDMA_RLC7_MIDCMD_CNTL_BASE_IDX                                                               0

#endif
