//  Copyright (c) 2014 Anton Bikineev
//  Use, modification and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

   static const std::array<std::array<typename table_type<T>::type, 3>, 483> sph_bessel_prime_data = {{
      {{ SC_(0.0), SC_(0.177219114266335964202880859375e-2), SC_(-0.00059073019535939412595095618568542910878323045134112) }}, 
      {{ SC_(0.0), SC_(0.22177286446094512939453125e-2), SC_(-0.0007392425179532175006179700888774678679099292507914) }}, 
      {{ SC_(0.0), SC_(0.7444499991834163665771484375e-2), SC_(-0.0024814862446883313885487614621559116604243461510807) }}, 
      {{ SC_(0.0), SC_(0.1433600485324859619140625e-1), SC_(-0.0047785700734518270869887108117642374264304543690086) }}, 
      {{ SC_(0.0), SC_(0.1760916970670223236083984375e-1), SC_(-0.0058695412275275349739779365143257794851809057009949) }}, 
      {{ SC_(0.0), SC_(0.6152711808681488037109375e-1), SC_(-0.020501276538108264396701196346605910882498145757291) }}, 
      {{ SC_(0.0), SC_(0.11958599090576171875e0), SC_(-0.0398050201948621421941210292157710448603891479912) }}, 
      {{ SC_(0.0), SC_(0.15262925624847412109375e0), SC_(-0.050757997187143693624549397713895165716696398867447) }}, 
      {{ SC_(0.0), SC_(0.408089816570281982421875e0), SC_(-0.13377796562095979256130243985129184943424781197872) }}, 
      {{ SC_(0.0), SC_(0.6540834903717041015625e0), SC_(-0.20884144970928802982189805833598707117509621554352) }}, 
      {{ SC_(0.0), SC_(0.1097540378570556640625e1), SC_(-0.32363128996423098800986369726506637424206110966053) }}, 
      {{ SC_(0.0), SC_(0.30944411754608154296875e1), SC_(-0.32772327847873480601847094737228509203871367413028) }}, 
      {{ SC_(0.0), SC_(0.51139926910400390625e1), SC_(0.11163071296732071010113814667118028729655393651111) }}, 
      {{ SC_(0.0), SC_(0.95070552825927734375e1), SC_(-0.1039199329743298950197804325967556415006213845802) }}, 
      {{ SC_(0.0), SC_(0.24750102996826171875e2), SC_(0.038091493701984986673737163109015930323251871551582) }}, 
      {{ SC_(0.0), SC_(0.637722015380859375e2), SC_(0.0090453234887771021139730907545305433164756214767811) }}, 
      {{ SC_(0.0), SC_(0.1252804412841796875e3), SC_(0.0074268064702894469014213220013686771951555840502162) }}, 
      {{ SC_(0.0), SC_(0.25554705810546875e3), SC_(-0.00183761395344989507935202292272917754447956178171) }}, 
      {{ SC_(0.0), SC_(0.503011474609375e3), SC_(0.0018615431855091944536114595361221124430107214407522) }}, 
      {{ SC_(0.0), SC_(0.10074598388671875e4), SC_(-0.00054428673820734722554558098627640390758578523460701) }}, 
      {{ SC_(0.0), SC_(0.1185395751953125e4), SC_(-0.00044426512255437104112668514555200612663124555018049) }}, 
      {{ SC_(0.1e1), SC_(0.177219114266335964202880859375e-2), SC_(0.33333301926724743270544869351763393018362657616392) }}, 
      {{ SC_(0.1e1), SC_(0.22177286446094512939453125e-2), SC_(0.3333328415014432085386400929337573117609545008093) }}, 
      {{ SC_(0.1e1), SC_(0.7444499991834163665771484375e-2), SC_(0.33332779129360285030797547432947735031266674305945) }}, 
      {{ SC_(0.1e1), SC_(0.1433600485324859619140625e-1), SC_(0.33331278148123875629513526073849384333270175643975) }}, 
      {{ SC_(0.1e1), SC_(0.1760916970670223236083984375e-1), SC_(0.33330232561988242330958281233316747723693794820455) }}, 
      {{ SC_(0.1e1), SC_(0.6152711808681488037109375e-1), SC_(0.33295486000052245722479825677039409556977258754827) }}, 
      {{ SC_(0.1e1), SC_(0.11958599090576171875e0), SC_(0.33190446930013828241423485313960950113040759442892) }}, 
      {{ SC_(0.1e1), SC_(0.15262925624847412109375e0), SC_(0.33100699268938180482919728425881255141316146257203) }}, 
      {{ SC_(0.1e1), SC_(0.408089816570281982421875e0), SC_(0.31684397977136935818191725069170520885289580667372) }}, 
      {{ SC_(0.1e1), SC_(0.6540834903717041015625e0), SC_(0.29162829350516425665943334374032067915239244394482) }}, 
      {{ SC_(0.1e1), SC_(0.1097540378570556640625e1), SC_(0.22124599283501171173496936153192115103165929919417) }}, 
      {{ SC_(0.1e1), SC_(0.30944411754608154296875e1), SC_(-0.19658235981058149100067699652905647880353385101318) }}, 
      {{ SC_(0.1e1), SC_(0.51139926910400390625e1), SC_(-0.13632672388834861015098125025833845101001637438382) }}, 
      {{ SC_(0.1e1), SC_(0.95070552825927734375e1), SC_(-0.030506227258358994609193779703787362812550193231335) }}, 
      {{ SC_(0.1e1), SC_(0.24750102996826171875e2), SC_(-0.012007474110778034828048934989840770598051223303604) }}, 
      {{ SC_(0.1e1), SC_(0.637722015380859375e2), SC_(0.012950066011127413222136249398220597518537587964799) }}, 
      {{ SC_(0.1e1), SC_(0.1252804412841796875e3), SC_(-0.0028663439400863297269154521533717825094247750357527) }}, 
      {{ SC_(0.1e1), SC_(0.25554705810546875e3), SC_(-0.0034620385452588388131810886999664980476244699917351) }}, 
      {{ SC_(0.1e1), SC_(0.503011474609375e3), SC_(0.00070149518464400215480658438983679586030848453205773) }}, 
      {{ SC_(0.1e1), SC_(0.10074598388671875e4), SC_(0.0008295182856630904173759913801736292531102367170295) }}, 
      {{ SC_(0.1e1), SC_(0.1185395751953125e4), SC_(-0.00071751454546951262848899688991345089056033018694987) }}, 
      {{ SC_(0.2e1), SC_(0.177219114266335964202880859375e-2), SC_(0.00023629204633889236005291087967272193505400040615219) }}, 
      {{ SC_(0.2e1), SC_(0.22177286446094512939453125e-2), SC_(0.00029569694485273315164816147890259355192137248909295) }}, 
      {{ SC_(0.2e1), SC_(0.7444499991834163665771484375e-2), SC_(0.00099259214029111530755282245585705320491168842896141) }}, 
      {{ SC_(0.2e1), SC_(0.1433600485324859619140625e-1), SC_(0.0019114111932840645445818300271381057911738485587312) }}, 
      {{ SC_(0.2e1), SC_(0.1760916970670223236083984375e-1), SC_(0.0023477852898247144211041643348229918938730351868808) }}, 
      {{ SC_(0.2e1), SC_(0.6152711808681488037109375e-1), SC_(0.0081991799453440166335962556334444408919344491974601) }}, 
      {{ SC_(0.2e1), SC_(0.11958599090576171875e0), SC_(0.015912243402711100514084762269717735532938018525996) }}, 
      {{ SC_(0.2e1), SC_(0.15262925624847412109375e0), SC_(0.020282907420154689051735712951937456114120792493934) }}, 
      {{ SC_(0.2e1), SC_(0.408089816570281982421875e0), SC_(0.053126410480031212586678205904563545693624738137461) }}, 
      {{ SC_(0.2e1), SC_(0.6540834903717041015625e0), SC_(0.081975170591889690668828338896856296226644215079007) }}, 
      {{ SC_(0.2e1), SC_(0.1097540378570556640625e1), SC_(0.12238965993933725860630405289274902840828844318344) }}, 
      {{ SC_(0.2e1), SC_(0.30944411754608154296875e1), SC_(0.034465686615074225277590510072478137128753981101953) }}, 
      {{ SC_(0.2e1), SC_(0.51139926910400390625e1), SC_(-0.17879833272894307974747883202034026500043024669226) }}, 
      {{ SC_(0.2e1), SC_(0.95070552825927734375e1), SC_(0.090844259664134671428993934186541052105632224421664) }}, 
      {{ SC_(0.2e1), SC_(0.24750102996826171875e2), SC_(-0.039360389059662599226736923236622677555963563488009) }}, 
      {{ SC_(0.2e1), SC_(0.637722015380859375e2), SC_(-0.0084294483711138144664987808201587482568010268919194) }}, 
      {{ SC_(0.2e1), SC_(0.1252804412841796875e3), SC_(-0.007494025162831139850518338448699859999892387891701) }}, 
      {{ SC_(0.2e1), SC_(0.25554705810546875e3), SC_(0.0017968868622435421755669393910269529503530851519011) }}, 
      {{ SC_(0.2e1), SC_(0.503011474609375e3), SC_(-0.0018573373412080144431644641210179018451222515992051) }}, 
      {{ SC_(0.2e1), SC_(0.10074598388671875e4), SC_(0.00054675525753835161682975502530985141120463926776899) }}, 
      {{ SC_(0.2e1), SC_(0.1185395751953125e4), SC_(0.00044244828798313716547648484028729073874463724553589) }}, 
      {{ SC_(0.4e1), SC_(0.177219114266335964202880859375e-2), SC_(2.3559158540082455768840080546112798663585697720826e-11) }}, 
      {{ SC_(0.4e1), SC_(0.22177286446094512939453125e-2), SC_(4.6169296279996473101914438794288203617891850406346e-11) }}, 
      {{ SC_(0.4e1), SC_(0.7444499991834163665771484375e-2), SC_(1.7463574574188387463066063010615387231365303592733e-09) }}, 
      {{ SC_(0.4e1), SC_(0.1433600485324859619140625e-1), SC_(1.2471150353404544376761085027683328476900937718487e-08) }}, 
      {{ SC_(0.4e1), SC_(0.1760916970670223236083984375e-1), SC_(2.311189936327654251816226989778718929688090519853e-08) }}, 
      {{ SC_(0.4e1), SC_(0.6152711808681488037109375e-1), SC_(9.8563429042288849994856658277243792242658610319728e-07) }}, 
      {{ SC_(0.4e1), SC_(0.11958599090576171875e0), SC_(7.231786397396951376253209809064929853071380936624e-06) }}, 
      {{ SC_(0.4e1), SC_(0.15262925624847412109375e0), SC_(1.50262843312992102987994629093877535298021202843e-05) }}, 
      {{ SC_(0.4e1), SC_(0.408089816570281982421875e0), SC_(0.00028441805397096435085790720535042306460060226531091) }}, 
      {{ SC_(0.4e1), SC_(0.6540834903717041015625e0), SC_(0.001150305647829084975995260918897017859199796438499) }}, 
      {{ SC_(0.4e1), SC_(0.1097540378570556640625e1), SC_(0.0051504955094770510161456682011514250134666357100256) }}, 
      {{ SC_(0.4e1), SC_(0.30944411754608154296875e1), SC_(0.061181156542238193041428456833192155137194232033491) }}, 
      {{ SC_(0.4e1), SC_(0.51139926910400390625e1), SC_(0.0363139052452261531505102240194494994808838785407) }}, 
      {{ SC_(0.4e1), SC_(0.95070552825927734375e1), SC_(-0.028531747960133660687636648425778013058000555983439) }}, 
      {{ SC_(0.4e1), SC_(0.24750102996826171875e2), SC_(0.040023894469610698102224436340566930082865587314546) }}, 
      {{ SC_(0.4e1), SC_(0.637722015380859375e2), SC_(0.0069233954610770121084670925372575700986670045449065) }}, 
      {{ SC_(0.4e1), SC_(0.1252804412841796875e3), SC_(0.0076340573012197958490927279614525838224840772867187) }}, 
      {{ SC_(0.4e1), SC_(0.25554705810546875e3), SC_(-0.0017009084886748170712160784869903924973747756235339) }}, 
      {{ SC_(0.4e1), SC_(0.503011474609375e3), SC_(0.0018472671693257273380791200050711158717490250370617) }}, 
      {{ SC_(0.4e1), SC_(0.10074598388671875e4), SC_(-0.0005524962251405277471852625842752467825656975241184) }}, 
      {{ SC_(0.4e1), SC_(0.1185395751953125e4), SC_(-0.00043819801692200450821440523901760623658697168103297) }}, 
      {{ SC_(0.7e1), SC_(0.177219114266335964202880859375e-2), SC_(1.0697991617160864248323531864233446640746976139854e-22) }}, 
      {{ SC_(0.7e1), SC_(0.22177286446094512939453125e-2), SC_(4.1085567478339757461750632668035113963198711865523e-22) }}, 
      {{ SC_(0.7e1), SC_(0.7444499991834163665771484375e-2), SC_(5.8782929736374897959537031744425834377447039058243e-19) }}, 
      {{ SC_(0.7e1), SC_(0.1433600485324859619140625e-1), SC_(2.9978120142841261857414643883582477264791257677086e-17) }}, 
      {{ SC_(0.7e1), SC_(0.1760916970670223236083984375e-1), SC_(1.0295966390411680856066604959250082829678041409389e-16) }}, 
      {{ SC_(0.7e1), SC_(0.6152711808681488037109375e-1), SC_(1.8731657314409352602419226071487809223291506164013e-13) }}, 
      {{ SC_(0.7e1), SC_(0.11958599090576171875e0), SC_(1.0094525367251698204292336826164457531302538571881e-11) }}, 
      {{ SC_(0.7e1), SC_(0.15262925624847412109375e0), SC_(4.3619738196814295533377222934031291971752264117272e-11) }}, 
      {{ SC_(0.7e1), SC_(0.408089816570281982421875e0), SC_(1.5850288314657106432878037070208657925534509527748e-08) }}, 
      {{ SC_(0.7e1), SC_(0.6540834903717041015625e0), SC_(2.6607459451995592354008784318795643172975569379218e-07) }}, 
      {{ SC_(0.7e1), SC_(0.1097540378570556640625e1), SC_(5.7664845836207484595125117901185694632395607204332e-06) }}, 
      {{ SC_(0.7e1), SC_(0.30944411754608154296875e1), SC_(0.0020888804576047189611023488334433681892088860115477) }}, 
      {{ SC_(0.7e1), SC_(0.51139926910400390625e1), SC_(0.020994124403255141274583447055949464819307285101337) }}, 
      {{ SC_(0.7e1), SC_(0.95070552825927734375e1), SC_(-0.024922140779284456438576044228491755023009874226221) }}, 
      {{ SC_(0.7e1), SC_(0.24750102996826171875e2), SC_(-0.028353909279783084726423510128135587959189228123484) }}, 
      {{ SC_(0.7e1), SC_(0.637722015380859375e2), SC_(-0.015389749527676762124638831431065414818429874166795) }}, 
      {{ SC_(0.7e1), SC_(0.1252804412841796875e3), SC_(0.0012051773854908700975190933641856566280801489744695) }}, 
      {{ SC_(0.7e1), SC_(0.25554705810546875e3), SC_(0.0036343607024917448468070861534877423287026662015176) }}, 
      {{ SC_(0.7e1), SC_(0.503011474609375e3), SC_(-0.00080024331306904311961557194136562626174732449978119) }}, 
      {{ SC_(0.7e1), SC_(0.10074598388671875e4), SC_(-0.00081460223150121705486726923945454262688469958748775) }}, 
      {{ SC_(0.7e1), SC_(0.1185395751953125e4), SC_(0.00072742594119996417485681196942112356035858739895609) }}, 
      {{ SC_(0.1e2), SC_(0.177219114266335964202880859375e-2), SC_(1.2540478186663120628602812079578808351729367819032e-34) }}, 
      {{ SC_(0.1e2), SC_(0.22177286446094512939453125e-2), SC_(9.4383195208714184217770984897928377645764418426331e-34) }}, 
      {{ SC_(0.1e2), SC_(0.7444499991834163665771484375e-2), SC_(5.1078513992279099655984000849207169156531500720582e-29) }}, 
      {{ SC_(0.1e2), SC_(0.1433600485324859619140625e-1), SC_(1.8602443902338341728545744334412177842231591534504e-26) }}, 
      {{ SC_(0.1e2), SC_(0.1760916970670223236083984375e-1), SC_(1.184037549370526220954087484921021630287809015208e-25) }}, 
      {{ SC_(0.1e2), SC_(0.6152711808681488037109375e-1), SC_(9.1891501761794684800165337570318820156562613422773e-21) }}, 
      {{ SC_(0.1e2), SC_(0.11958599090576171875e0), SC_(3.636468360943061368725393960169440670304331201129e-18) }}, 
      {{ SC_(0.1e2), SC_(0.15262925624847412109375e0), SC_(3.2673468058175873706620435736465562121531182610027e-17) }}, 
      {{ SC_(0.1e2), SC_(0.408089816570281982421875e0), SC_(2.2731792965182072429022860094049372896122789728251e-13) }}, 
      {{ SC_(0.1e2), SC_(0.6540834903717041015625e0), SC_(1.5760423825992973985064566597131710758930245916175e-11) }}, 
      {{ SC_(0.1e2), SC_(0.1097540378570556640625e1), SC_(1.6286716907590974417319456530375671570565066879608e-09) }}, 
      {{ SC_(0.1e2), SC_(0.30944411754608154296875e1), SC_(1.4689037278392991527257463063818041335347730983745e-05) }}, 
      {{ SC_(0.1e2), SC_(0.51139926910400390625e1), SC_(0.00085602285501601593976405612569490993161547868879281) }}, 
      {{ SC_(0.1e2), SC_(0.95070552825927734375e1), SC_(0.027522034393506434808155354136522567666541010162809) }}, 
      {{ SC_(0.1e2), SC_(0.24750102996826171875e2), SC_(0.013240180531579579689175259669579050941417887171516) }}, 
      {{ SC_(0.1e2), SC_(0.637722015380859375e2), SC_(0.0038529486866003068299591547844152695910806887598016) }}, 
      {{ SC_(0.1e2), SC_(0.1252804412841796875e3), SC_(-0.0079519986322761114107454671009239592487568415292458) }}, 
      {{ SC_(0.1e2), SC_(0.25554705810546875e3), SC_(0.0010567873526868367398938930691328674623714508884516) }}, 
      {{ SC_(0.1e2), SC_(0.503011474609375e3), SC_(-0.0017740831740702497766096751754348177543562210628555) }}, 
      {{ SC_(0.1e2), SC_(0.10074598388671875e4), SC_(0.00058875307252099371564561348285478225978994918772465) }}, 
      {{ SC_(0.1e2), SC_(0.1185395751953125e4), SC_(0.00041051677093140307970749698818936573310086302759084) }}, 
      {{ SC_(0.13e2), SC_(0.177219114266335964202880859375e-2), SC_(5.844636876725227683357500120233184213859698178325e-47) }}, 
      {{ SC_(0.13e2), SC_(0.22177286446094512939453125e-2), SC_(8.6204840014851849620782773810249872710860076599731e-46) }}, 
      {{ SC_(0.13e2), SC_(0.7444499991834163665771484375e-2), SC_(1.7646425536684117404987064621393414030517423224716e-39) }}, 
      {{ SC_(0.13e2), SC_(0.1433600485324859619140625e-1), SC_(4.5895141989470824090019578322510045314228712072451e-36) }}, 
      {{ SC_(0.13e2), SC_(0.1760916970670223236083984375e-1), SC_(5.4137062826342044067019095715091771539033704124656e-35) }}, 
      {{ SC_(0.13e2), SC_(0.6152711808681488037109375e-1), SC_(1.7922434195259212798397221036078262364270769258554e-28) }}, 
      {{ SC_(0.13e2), SC_(0.11958599090576171875e0), SC_(5.207999593815064904352013709968872189384819831291e-25) }}, 
      {{ SC_(0.13e2), SC_(0.15262925624847412109375e0), SC_(9.7293315333331498808814011282373323528498860975414e-24) }}, 
      {{ SC_(0.13e2), SC_(0.408089816570281982421875e0), SC_(1.2949734605874300886572486185950822325449690423218e-18) }}, 
      {{ SC_(0.13e2), SC_(0.6540834903717041015625e0), SC_(3.7028102957059242582344597779119196616563738547491e-16) }}, 
      {{ SC_(0.13e2), SC_(0.1097540378570556640625e1), SC_(1.8165999084094667801479868191211362692402474437176e-13) }}, 
      {{ SC_(0.13e2), SC_(0.30944411754608154296875e1), SC_(3.874662930327891438025602851203401854883608380588e-08) }}, 
      {{ SC_(0.13e2), SC_(0.51139926910400390625e1), SC_(1.1448383455987062078137542664340476336485929663997e-05) }}, 
      {{ SC_(0.13e2), SC_(0.95070552825927734375e1), SC_(0.0046628876383342342772038568967367112659724633082712) }}, 
      {{ SC_(0.13e2), SC_(0.24750102996826171875e2), SC_(-0.01117656190828203075472481429183028048799460826676) }}, 
      {{ SC_(0.13e2), SC_(0.637722015380859375e2), SC_(0.010598673195256440313938792579092293019780831210011) }}, 
      {{ SC_(0.13e2), SC_(0.1252804412841796875e3), SC_(0.0027430791801645705207848713037387821034434075188766) }}, 
      {{ SC_(0.13e2), SC_(0.25554705810546875e3), SC_(-0.0038761255237585401684704883829167504315149989100148) }}, 
      {{ SC_(0.13e2), SC_(0.503011474609375e3), SC_(0.0010211843922021481727620592752130338289258660256726) }}, 
      {{ SC_(0.13e2), SC_(0.10074598388671875e4), SC_(0.00077754321765859870173136381128102882302233156780171) }}, 
      {{ SC_(0.13e2), SC_(0.1185395751953125e4), SC_(-0.00074907594119393902463592941572342714737319755923209) }}, 
      {{ SC_(0.16e2), SC_(0.177219114266335964202880859375e-2), SC_(1.3495600783099502899950963886790789671659704859283e-59) }}, 
      {{ SC_(0.16e2), SC_(0.22177286446094512939453125e-2), SC_(3.9008556074063175004828466466467288482527178352895e-58) }}, 
      {{ SC_(0.16e2), SC_(0.7444499991834163665771484375e-2), SC_(3.0204137588045755013901027920392279808697835290103e-50) }}, 
      {{ SC_(0.16e2), SC_(0.1433600485324859619140625e-1), SC_(5.6098916812841687360216078933911008658558701992775e-46) }}, 
      {{ SC_(0.16e2), SC_(0.1760916970670223236083984375e-1), SC_(1.2263511425538625519614083593882583366877162702465e-44) }}, 
      {{ SC_(0.16e2), SC_(0.6152711808681488037109375e-1), SC_(1.7318329473066848211744833236205437222206172400932e-36) }}, 
      {{ SC_(0.16e2), SC_(0.11958599090576171875e0), SC_(3.6952055460769452575097659340512610882536953525738e-32) }}, 
      {{ SC_(0.16e2), SC_(0.15262925624847412109375e0), SC_(1.4352846477090182579157024306063120671330414546019e-30) }}, 
      {{ SC_(0.16e2), SC_(0.408089816570281982421875e0), SC_(3.6534880868007374632934776308452078231568915655124e-24) }}, 
      {{ SC_(0.16e2), SC_(0.6540834903717041015625e0), SC_(4.305710725183856426287910265085945783752618777951e-21) }}, 
      {{ SC_(0.16e2), SC_(0.1097540378570556640625e1), SC_(1.00098671832464221668640959168292770754304817644e-17) }}, 
      {{ SC_(0.16e2), SC_(0.30944411754608154296875e1), SC_(4.9441288840052372129244730736277722931023943475652e-11) }}, 
      {{ SC_(0.16e2), SC_(0.51139926910400390625e1), SC_(7.0595516535814032647085470511792729447901701655408e-08) }}, 
      {{ SC_(0.16e2), SC_(0.95070552825927734375e1), SC_(0.00025566549795055262530090446336705861013015707343491) }}, 
      {{ SC_(0.16e2), SC_(0.24750102996826171875e2), SC_(0.022634355413314348907283536289892355277345319373343) }}, 
      {{ SC_(0.16e2), SC_(0.637722015380859375e2), SC_(-0.01540174509868024029489311756958683766754343228854) }}, 
      {{ SC_(0.16e2), SC_(0.1252804412841796875e3), SC_(0.0060169356246801741550608880896659179542006666999987) }}, 
      {{ SC_(0.16e2), SC_(0.25554705810546875e3), SC_(0.00017022296564041618695912818508535828739775926074729) }}, 
      {{ SC_(0.16e2), SC_(0.503011474609375e3), SC_(0.0016070798188046508269212196806042850364534468562929) }}, 
      {{ SC_(0.16e2), SC_(0.10074598388671875e4), SC_(-0.00065100592295585385782397687880761306193642478410738) }}, 
      {{ SC_(0.16e2), SC_(0.1185395751953125e4), SC_(-0.0003592286843481734688729587542252681144939689273743) }}, 
      {{ SC_(0.19e2), SC_(0.177219114266335964202880859375e-2), SC_(1.7661319782573514361481247541024265805595628959129e-72) }}, 
      {{ SC_(0.19e2), SC_(0.22177286446094512939453125e-2), SC_(1.0004245512839555542998159548622369255602509481431e-70) }}, 
      {{ SC_(0.19e2), SC_(0.7444499991834163665771484375e-2), SC_(2.9300318855618648766454541327970130696726968421268e-61) }}, 
      {{ SC_(0.19e2), SC_(0.1433600485324859619140625e-1), SC_(3.8863183038012879013314779510454954805741296197262e-56) }}, 
      {{ SC_(0.19e2), SC_(0.1760916970670223236083984375e-1), SC_(1.5744579598286635091294225983158141343148529008064e-54) }}, 
      {{ SC_(0.19e2), SC_(0.6152711808681488037109375e-1), SC_(9.4843860462743048384207025030771172152971066468606e-45) }}, 
      {{ SC_(0.19e2), SC_(0.11958599090576171875e0), SC_(1.4859180758222816275256230016311656865534560713177e-39) }}, 
      {{ SC_(0.19e2), SC_(0.15262925624847412109375e0), SC_(1.1999879277498142774840330342037184943916982930588e-37) }}, 
      {{ SC_(0.19e2), SC_(0.408089816570281982421875e0), SC_(5.8406578634529086948375376100969944762342508748402e-30) }}, 
      {{ SC_(0.19e2), SC_(0.6540834903717041015625e0), SC_(2.8361267931496515464353474719652060744077259825334e-26) }}, 
      {{ SC_(0.19e2), SC_(0.1097540378570556640625e1), SC_(3.12138685235595911660052444788534153532344914257e-22) }}, 
      {{ SC_(0.19e2), SC_(0.30944411754608154296875e1), SC_(3.5323079935449595038742904325684320806229481333541e-14) }}, 
      {{ SC_(0.19e2), SC_(0.51139926910400390625e1), SC_(2.3817350478745501598665221339337101236576535366461e-10) }}, 
      {{ SC_(0.19e2), SC_(0.95070552825927734375e1), SC_(6.7606809858916882986751788364365338067482645306245e-06) }}, 
      {{ SC_(0.19e2), SC_(0.24750102996826171875e2), SC_(-0.032066114212636288815765664469329174546453513846913) }}, 
      {{ SC_(0.19e2), SC_(0.637722015380859375e2), SC_(0.011177350325672386052106100398795833389131199790171) }}, 
      {{ SC_(0.19e2), SC_(0.1252804412841796875e3), SC_(-0.0072237226028169908015550738351624189693076047492072) }}, 
      {{ SC_(0.19e2), SC_(0.25554705810546875e3), SC_(0.003781092705165487438145395776764171218520037593198) }}, 
      {{ SC_(0.19e2), SC_(0.503011474609375e3), SC_(-0.0013347277944503932257151113910284756689087366752937) }}, 
      {{ SC_(0.19e2), SC_(0.10074598388671875e4), SC_(-0.0007132291938059210873371864791789607361144096894876) }}, 
      {{ SC_(0.19e2), SC_(0.1185395751953125e4), SC_(0.00077880061896923008134170334208354546556905942975403) }}, 
      {{ SC_(0.22e2), SC_(0.177219114266335964202880859375e-2), SC_(1.4346933832978683544839998492716828880754366926735e-85) }}, 
      {{ SC_(0.22e2), SC_(0.22177286446094512939453125e-2), SC_(1.5926260563637304370749076888728326789144725615133e-83) }}, 
      {{ SC_(0.22e2), SC_(0.7444499991834163665771484375e-2), SC_(1.7643439262335660267806726384109932711879661909605e-72) }}, 
      {{ SC_(0.22e2), SC_(0.1433600485324859619140625e-1), SC_(1.6711953057454406320763177073212793401081578215498e-66) }}, 
      {{ SC_(0.22e2), SC_(0.1760916970670223236083984375e-1), SC_(1.2547355757524417491331265024162187407473465870829e-64) }}, 
      {{ SC_(0.22e2), SC_(0.6152711808681488037109375e-1), SC_(3.2241577061365422977003361143750748537318851348158e-53) }}, 
      {{ SC_(0.22e2), SC_(0.11958599090576171875e0), SC_(3.708955942761436362929736808816782538676676938117e-47) }}, 
      {{ SC_(0.22e2), SC_(0.15262925624847412109375e0), SC_(6.2274958751714899114159396996840540688135748722571e-45) }}, 
      {{ SC_(0.22e2), SC_(0.408089816570281982421875e0), SC_(5.7952051054347475180019707026620465014620505683472e-36) }}, 
      {{ SC_(0.22e2), SC_(0.6540834903717041015625e0), SC_(1.1592515491968586785779826695412987976056812000675e-31) }}, 
      {{ SC_(0.22e2), SC_(0.1097540378570556640625e1), SC_(6.0366303781719743309191881216305597308663660005275e-27) }}, 
      {{ SC_(0.22e2), SC_(0.30944411754608154296875e1), SC_(1.555512445813602857888580463846869810081155819047e-17) }}, 
      {{ SC_(0.22e2), SC_(0.51139926910400390625e1), SC_(4.8889537574080551751361208406662647835960569758233e-13) }}, 
      {{ SC_(0.22e2), SC_(0.95070552825927734375e1), SC_(1.0216003036016414061374022008955559352184655464246e-07) }}, 
      {{ SC_(0.22e2), SC_(0.24750102996826171875e2), SC_(-0.00060983487545783466779682765301973242178822136276568) }}, 
      {{ SC_(0.22e2), SC_(0.637722015380859375e2), SC_(-0.0038316123612077474120859693157126089392487891444175) }}, 
      {{ SC_(0.22e2), SC_(0.1252804412841796875e3), SC_(0.00062535117479769214439359781873778339477464025863906) }}, 
      {{ SC_(0.22e2), SC_(0.25554705810546875e3), SC_(-0.0018788397092936301426859974248173150754957818180952) }}, 
      {{ SC_(0.22e2), SC_(0.503011474609375e3), SC_(-0.0012938612771396743247113261344139175012528005114729) }}, 
      {{ SC_(0.22e2), SC_(0.10074598388671875e4), SC_(0.00073339587241511328223293284161911824164418323602695) }}, 
      {{ SC_(0.22e2), SC_(0.1185395751953125e4), SC_(0.00028225360511187614570179196395865568691473005914978) }}, 
      {{ SC_(0.25e2), SC_(0.177219114266335964202880859375e-2), SC_(7.7258095132040441980776945600738126962737399499636e-99) }}, 
      {{ SC_(0.25e2), SC_(0.22177286446094512939453125e-2), SC_(1.6807079386621848290351580696278987637014928167498e-96) }}, 
      {{ SC_(0.25e2), SC_(0.7444499991834163665771484375e-2), SC_(7.042763356714140140486595780452609188207704262168e-84) }}, 
      {{ SC_(0.25e2), SC_(0.1433600485324859619140625e-1), SC_(4.7639255453489281012297651834444933262393807848319e-77) }}, 
      {{ SC_(0.25e2), SC_(0.1760916970670223236083984375e-1), SC_(6.6286067267693988056350837009781630931577812062007e-75) }}, 
      {{ SC_(0.25e2), SC_(0.6152711808681488037109375e-1), SC_(7.265600922139165640632145509370924623824760242158e-62) }}, 
      {{ SC_(0.25e2), SC_(0.11958599090576171875e0), SC_(6.1369785727465985931084450038036181258246158471756e-55) }}, 
      {{ SC_(0.25e2), SC_(0.15262925624847412109375e0), SC_(2.1423694158888427897520102853182607132906088463658e-52) }}, 
      {{ SC_(0.25e2), SC_(0.408089816570281982421875e0), SC_(3.8114636076613657659597915762060022252636896020907e-42) }}, 
      {{ SC_(0.25e2), SC_(0.6540834903717041015625e0), SC_(3.140463684290774324979770718663798820850988252464e-37) }}, 
      {{ SC_(0.25e2), SC_(0.1097540378570556640625e1), SC_(7.7348364829323197475998441700425791092575137357626e-32) }}, 
      {{ SC_(0.25e2), SC_(0.30944411754608154296875e1), SC_(4.5207107709187403321240363776085711912713195242772e-21) }}, 
      {{ SC_(0.25e2), SC_(0.51139926910400390625e1), SC_(6.5698792183785360453992048033520793383446850741142e-16) }}, 
      {{ SC_(0.25e2), SC_(0.95070552825927734375e1), SC_(9.7445652423982177651775026895653514078534729269353e-10) }}, 
      {{ SC_(0.25e2), SC_(0.24750102996826171875e2), SC_(0.010656785586923790285072859656240528251584498414306) }}, 
      {{ SC_(0.25e2), SC_(0.637722015380859375e2), SC_(-0.0023515977031882882215858032650254199002539692652263) }}, 
      {{ SC_(0.25e2), SC_(0.1252804412841796875e3), SC_(0.0062521328884808503467803422120054353424133352629674) }}, 
      {{ SC_(0.25e2), SC_(0.25554705810546875e3), SC_(-0.0027638911357905044755733722269417694421930684768425) }}, 
      {{ SC_(0.25e2), SC_(0.503011474609375e3), SC_(0.0016770222051048209654617388332428809783038759706704) }}, 
      {{ SC_(0.25e2), SC_(0.10074598388671875e4), SC_(0.00061457590173839919986608740800369702762429707234221) }}, 
      {{ SC_(0.25e2), SC_(0.1185395751953125e4), SC_(-0.00081054795380479799851530237384450628135816076566901) }}, 
      {{ SC_(0.28e2), SC_(0.177219114266335964202880859375e-2), SC_(2.898546622900036293987317744369820735153321771705e-112) }}, 
      {{ SC_(0.28e2), SC_(0.22177286446094512939453125e-2), SC_(1.2357257014767428209969166591842518136913072721119e-109) }}, 
      {{ SC_(0.28e2), SC_(0.7444499991834163665771484375e-2), SC_(1.9586387024827130530752559374450946732796710119965e-95) }}, 
      {{ SC_(0.28e2), SC_(0.1433600485324859619140625e-1), SC_(9.4613713884946658828918939968722934792263120933653e-88) }}, 
      {{ SC_(0.28e2), SC_(0.1760916970670223236083984375e-1), SC_(2.4397405656696298025414857745099001661890552457561e-85) }}, 
      {{ SC_(0.28e2), SC_(0.6152711808681488037109375e-1), SC_(1.1407164132819334164739485306206907261741045287899e-70) }}, 
      {{ SC_(0.28e2), SC_(0.11958599090576171875e0), SC_(7.0746835839733745667390777032370447768255169184717e-63) }}, 
      {{ SC_(0.28e2), SC_(0.15262925624847412109375e0), SC_(5.1348001990497321033729471063173622814993346655318e-60) }}, 
      {{ SC_(0.28e2), SC_(0.408089816570281982421875e0), SC_(1.7464005491456426537972561895789063757931870253966e-48) }}, 
      {{ SC_(0.28e2), SC_(0.6540834903717041015625e0), SC_(5.9265780579842452076258271675117482951486709116898e-43) }}, 
      {{ SC_(0.28e2), SC_(0.1097540378570556640625e1), SC_(6.9023618029131720514273998375109062245277013850635e-37) }}, 
      {{ SC_(0.28e2), SC_(0.30944411754608154296875e1), SC_(9.1262931672652772267227175616672412026513841005263e-25) }}, 
      {{ SC_(0.28e2), SC_(0.51139926910400390625e1), SC_(6.0999770221169356671434825086404934409239971621924e-19) }}, 
      {{ SC_(0.28e2), SC_(0.95070552825927734375e1), SC_(6.2742715911152067973728814831615584229317030269889e-12) }}, 
      {{ SC_(0.28e2), SC_(0.24750102996826171875e2), SC_(0.0039300879467825949731664375073644391863034991515792) }}, 
      {{ SC_(0.28e2), SC_(0.637722015380859375e2), SC_(0.0059904906652512850580870168068200074877976167696718) }}, 
      {{ SC_(0.28e2), SC_(0.1252804412841796875e3), SC_(-0.0076090271219723373594751131625788526799793620930378) }}, 
      {{ SC_(0.28e2), SC_(0.25554705810546875e3), SC_(0.0034794254397496951757436647238015815697187773454001) }}, 
      {{ SC_(0.28e2), SC_(0.503011474609375e3), SC_(0.00078232453396346747246899849654730599055219916763595) }}, 
      {{ SC_(0.28e2), SC_(0.10074598388671875e4), SC_(-0.00082606201592292679825384367092133760568234811830151) }}, 
      {{ SC_(0.28e2), SC_(0.1185395751953125e4), SC_(-0.00017757389425738557045001783828413707190767872062493) }}, 
      {{ SC_(0.31e2), SC_(0.177219114266335964202880859375e-2), SC_(7.8775876287499286838072280673927581265901242531937e-126) }}, 
      {{ SC_(0.31e2), SC_(0.22177286446094512939453125e-2), SC_(6.5815557688895803443776521344388159335962864455371e-123) }}, 
      {{ SC_(0.31e2), SC_(0.7444499991834163665771484375e-2), SC_(3.9458649854080256342595726849788090907419076447369e-107) }}, 
      {{ SC_(0.31e2), SC_(0.1433600485324859619140625e-1), SC_(1.3611934612281749297816254343607090026292280213525e-98) }}, 
      {{ SC_(0.31e2), SC_(0.1760916970670223236083984375e-1), SC_(6.5049156674033312768834581294743787260247954231427e-96) }}, 
      {{ SC_(0.31e2), SC_(0.6152711808681488037109375e-1), SC_(1.2973589201851510142026012344780313381956052232527e-79) }}, 
      {{ SC_(0.31e2), SC_(0.11958599090576171875e0), SC_(5.9079218584766593664811039915407659593668093719886e-71) }}, 
      {{ SC_(0.31e2), SC_(0.15262925624847412109375e0), SC_(8.9151200825793139020994259611923107296371268402097e-68) }}, 
      {{ SC_(0.31e2), SC_(0.408089816570281982421875e0), SC_(5.7963802621031875890867031072365473417972309973337e-55) }}, 
      {{ SC_(0.31e2), SC_(0.6540834903717041015625e0), SC_(8.1012209712257258584393627518337907553907566281919e-49) }}, 
      {{ SC_(0.31e2), SC_(0.1097540378570556640625e1), SC_(4.4607415007994099477136066025094924609658816997112e-42) }}, 
      {{ SC_(0.31e2), SC_(0.30944411754608154296875e1), SC_(1.331819582790790484470790607868004443732716895579e-28) }}, 
      {{ SC_(0.31e2), SC_(0.51139926910400390625e1), SC_(4.0788428020086662052384479362530030307659672590624e-22) }}, 
      {{ SC_(0.31e2), SC_(0.95070552825927734375e1), SC_(2.8636186143389368365805958850719039042374981238687e-14) }}, 
      {{ SC_(0.31e2), SC_(0.24750102996826171875e2), SC_(0.00066890334625585515840434420831913284957694064761637) }}, 
      {{ SC_(0.31e2), SC_(0.637722015380859375e2), SC_(-0.0072179221079394562427995221598245531810206611030009) }}, 
      {{ SC_(0.31e2), SC_(0.1252804412841796875e3), SC_(0.003513858559154446458393689430054491554076377158595) }}, 
      {{ SC_(0.31e2), SC_(0.25554705810546875e3), SC_(0.00045187648426654295136799903979151773759509797051897) }}, 
      {{ SC_(0.31e2), SC_(0.503011474609375e3), SC_(-0.0019356765934413212855449721214046075543634795516571) }}, 
      {{ SC_(0.31e2), SC_(0.10074598388671875e4), SC_(-0.00047405358209737925809636732975041483609849706835429) }}, 
      {{ SC_(0.31e2), SC_(0.1185395751953125e4), SC_(0.00083564262076065638544356048748426018009228278361569) }}, 
      {{ SC_(0.34e2), SC_(0.177219114266335964202880859375e-2), SC_(1.6003128847491793168137503257182087284127816249509e-139) }}, 
      {{ SC_(0.34e2), SC_(0.22177286446094512939453125e-2), SC_(2.6201958724541480984793808249211873312850994607026e-136) }}, 
      {{ SC_(0.34e2), SC_(0.7444499991834163665771484375e-2), SC_(5.9419475387178050045407286271267437024821577461238e-119) }}, 
      {{ SC_(0.34e2), SC_(0.1433600485324859619140625e-1), SC_(1.4638086551302196921669416873779929845100896435665e-109) }}, 
      {{ SC_(0.34e2), SC_(0.1760916970670223236083984375e-1), SC_(1.2963980798514123019645531520400448730142340697548e-106) }}, 
      {{ SC_(0.34e2), SC_(0.6152711808681488037109375e-1), SC_(1.102912449351827475546751590980657401270146334249e-88) }}, 
      {{ SC_(0.34e2), SC_(0.11958599090576171875e0), SC_(3.6877390480158343480758813816584570829717950890918e-79) }}, 
      {{ SC_(0.34e2), SC_(0.15262925624847412109375e0), SC_(1.1569855659669671795727844841235875282419276184683e-75) }}, 
      {{ SC_(0.34e2), SC_(0.408089816570281982421875e0), SC_(1.4379939762468847626273680758227385457216077171783e-61) }}, 
      {{ SC_(0.34e2), SC_(0.6540834903717041015625e0), SC_(8.2768685425570700505088951217289765965202528952712e-55) }}, 
      {{ SC_(0.34e2), SC_(0.1097540378570556640625e1), SC_(2.1544266467313328465916566948249268733731492301561e-47) }}, 
      {{ SC_(0.34e2), SC_(0.30944411754608154296875e1), SC_(1.450532711253854063062392490092524526169882346293e-32) }}, 
      {{ SC_(0.34e2), SC_(0.51139926910400390625e1), SC_(2.029996276133185186171030096753719108008188681144e-25) }}, 
      {{ SC_(0.34e2), SC_(0.95070552825927734375e1), SC_(9.6183050948196245799324261684804441243947832867063e-17) }}, 
      {{ SC_(0.34e2), SC_(0.24750102996826171875e2), SC_(6.8315003036127184082019796332326490349643933979132e-05) }}, 
      {{ SC_(0.34e2), SC_(0.637722015380859375e2), SC_(0.0063080230453916141641871065360141379334606472381749) }}, 
      {{ SC_(0.34e2), SC_(0.1252804412841796875e3), SC_(0.0023660988295490931496750138598722842983282005209642) }}, 
      {{ SC_(0.34e2), SC_(0.25554705810546875e3), SC_(-0.0037517111748559958509773683514461711396348749501652) }}, 
      {{ SC_(0.34e2), SC_(0.503011474609375e3), SC_(-5.7202472461057850278506940525672272874481222328935e-05) }}, 
      {{ SC_(0.34e2), SC_(0.10074598388671875e4), SC_(0.00091406695210952258179220803912651922054308452646979) }}, 
      {{ SC_(0.34e2), SC_(0.1185395751953125e4), SC_(4.4388284041495360178966061765997129838859725604204e-05) }}, 
      {{ SC_(0.37e2), SC_(0.177219114266335964202880859375e-2), SC_(2.4935433482370437336343513296728982363498760516925e-153) }}, 
      {{ SC_(0.37e2), SC_(0.22177286446094512939453125e-2), SC_(8.0009086536962859237696566583671735445447514546313e-150) }}, 
      {{ SC_(0.37e2), SC_(0.7444499991834163665771484375e-2), SC_(6.8630278928882414384414070172123459339579214390083e-131) }}, 
      {{ SC_(0.37e2), SC_(0.1433600485324859619140625e-1), SC_(1.2073942913568333104379292294826806894142393279905e-120) }}, 
      {{ SC_(0.37e2), SC_(0.1760916970670223236083984375e-1), SC_(1.9816887009824956135575332613591064392542723185953e-117) }}, 
      {{ SC_(0.37e2), SC_(0.6152711808681488037109375e-1), SC_(7.1915433036198452751094551414559844081745612427534e-98) }}, 
      {{ SC_(0.37e2), SC_(0.11958599090576171875e0), SC_(1.7655712048275108209120094710331007956086648000123e-87) }}, 
      {{ SC_(0.37e2), SC_(0.15262925624847412109375e0), SC_(1.1516694093847271588663419791426043896951039689755e-83) }}, 
      {{ SC_(0.37e2), SC_(0.408089816570281982421875e0), SC_(2.7362069396799248724678152895719605158407039424678e-68) }}, 
      {{ SC_(0.37e2), SC_(0.6540834903717041015625e0), SC_(6.4857421677698090454882198378828867007126695756744e-61) }}, 
      {{ SC_(0.37e2), SC_(0.1097540378570556640625e1), SC_(7.9798339458266299958356913753831546856284350172324e-53) }}, 
      {{ SC_(0.37e2), SC_(0.30944411754608154296875e1), SC_(1.2103397516418761052178982869123109099380325558983e-36) }}, 
      {{ SC_(0.37e2), SC_(0.51139926910400390625e1), SC_(7.7243997361989404138558735969624260978501060319165e-29) }}, 
      {{ SC_(0.37e2), SC_(0.95070552825927734375e1), SC_(2.4493533884738741017300408411408467992175104522667e-19) }}, 
      {{ SC_(0.37e2), SC_(0.24750102996826171875e2), SC_(4.6794414825088494745529642760886136349593280610034e-06) }}, 
      {{ SC_(0.37e2), SC_(0.637722015380859375e2), SC_(-0.0031277695929286612125212722762053443316092775054172) }}, 
      {{ SC_(0.37e2), SC_(0.1252804412841796875e3), SC_(-0.0065755128353966358445057425350218575583759042635842) }}, 
      {{ SC_(0.37e2), SC_(0.25554705810546875e3), SC_(0.0024964456982885421909400386065350058381362443809731) }}, 
      {{ SC_(0.37e2), SC_(0.503011474609375e3), SC_(0.0019509907949171234522760818173515619007212873878106) }}, 
      {{ SC_(0.37e2), SC_(0.10074598388671875e4), SC_(0.00028614526782253706871300034653006187678545901528539) }}, 
      {{ SC_(0.37e2), SC_(0.1185395751953125e4), SC_(-0.00084276531729694519809795245216109750610694408803882) }}, 
      {{ SC_(0.4e2), SC_(0.177219114266335964202880859375e-2), SC_(3.0451173940776633796510397511476502457616285425822e-167) }}, 
      {{ SC_(0.4e2), SC_(0.22177286446094512939453125e-2), SC_(1.9147847632589324423897280046376641620833387728587e-163) }}, 
      {{ SC_(0.4e2), SC_(0.7444499991834163665771484375e-2), SC_(6.2126631909745937307748470227359796617873927403459e-143) }}, 
      {{ SC_(0.4e2), SC_(0.1433600485324859619140625e-1), SC_(7.8052894758536104921007382334197472766550749656088e-132) }}, 
      {{ SC_(0.4e2), SC_(0.1760916970670223236083984375e-1), SC_(2.3741468152165135768966729906726839540292037296954e-128) }}, 
      {{ SC_(0.4e2), SC_(0.6152711808681488037109375e-1), SC_(3.6751756921085051889473435234446845382854638966484e-107) }}, 
      {{ SC_(0.4e2), SC_(0.11958599090576171875e0), SC_(6.62498368796121614018153582192941343901040397855e-96) }}, 
      {{ SC_(0.4e2), SC_(0.15262925624847412109375e0), SC_(8.9846648178506045088398860576593412774166955500632e-92) }}, 
      {{ SC_(0.4e2), SC_(0.408089816570281982421875e0), SC_(4.0804606916410823394910712004487763408204710093008e-75) }}, 
      {{ SC_(0.4e2), SC_(0.6540834903717041015625e0), SC_(3.9830077751917535293311427176144717711206863030811e-67) }}, 
      {{ SC_(0.4e2), SC_(0.1097540378570556640625e1), SC_(2.3162344446895224600516446647447168072093597787386e-58) }}, 
      {{ SC_(0.4e2), SC_(0.30944411754608154296875e1), SC_(7.9081357888811428685511702752745680140266657661447e-41) }}, 
      {{ SC_(0.4e2), SC_(0.51139926910400390625e1), SC_(2.2979421547191201655238536384054658156938451872151e-32) }}, 
      {{ SC_(0.4e2), SC_(0.95070552825927734375e1), SC_(4.8454438459543453675590259468246567115846204535433e-22) }}, 
      {{ SC_(0.4e2), SC_(0.24750102996826171875e2), SC_(2.2937101113543054325386002186330175831847124660417e-07) }}, 
      {{ SC_(0.4e2), SC_(0.637722015380859375e2), SC_(-0.002493930765343431385263937829034325891390818934864) }}, 
      {{ SC_(0.4e2), SC_(0.1252804412841796875e3), SC_(0.0077540624122761492816004524108307648710095750440158) }}, 
      {{ SC_(0.4e2), SC_(0.25554705810546875e3), SC_(0.0015669755299232093288154794385260061011335506607663) }}, 
      {{ SC_(0.4e2), SC_(0.503011474609375e3), SC_(-0.0008073568695373682723595866839766883540273651955663) }}, 
      {{ SC_(0.4e2), SC_(0.10074598388671875e4), SC_(-0.00097680263698142025514026259986871490439507410945443) }}, 
      {{ SC_(0.4e2), SC_(0.1185395751953125e4), SC_(0.00011533630248695024404826352436816029956313030919627) }}, 
      {{ SC_(0.43e2), SC_(0.177219114266335964202880859375e-2), SC_(2.9684375666291969236553020979579902554171693354356e-181) }}, 
      {{ SC_(0.43e2), SC_(0.22177286446094512939453125e-2), SC_(3.6579467186424006530510793525675777195332020411446e-177) }}, 
      {{ SC_(0.43e2), SC_(0.7444499991834163665771484375e-2), SC_(4.4892791914053390349831452703744911997636760062944e-155) }}, 
      {{ SC_(0.43e2), SC_(0.1433600485324859619140625e-1), SC_(4.0277793019996706145770781475106086346017960388662e-143) }}, 
      {{ SC_(0.43e2), SC_(0.1760916970670223236083984375e-1), SC_(2.2704736303675671656892301618535465698877733011064e-139) }}, 
      {{ SC_(0.43e2), SC_(0.6152711808681488037109375e-1), SC_(1.4992385897105826139967226088154711921779465651534e-116) }}, 
      {{ SC_(0.43e2), SC_(0.11958599090576171875e0), SC_(1.9843610618084790801378839806672557794751239870285e-104) }}, 
      {{ SC_(0.43e2), SC_(0.15262925624847412109375e0), SC_(5.5951527806601865842283308970825407508958871141011e-100) }}, 
      {{ SC_(0.43e2), SC_(0.408089816570281982421875e0), SC_(4.8573670798144572622238601052870195129292148658411e-82) }}, 
      {{ SC_(0.43e2), SC_(0.6540834903717041015625e0), SC_(1.9524763841770075140223662568060012126353147916695e-73) }}, 
      {{ SC_(0.43e2), SC_(0.1097540378570556640625e1), SC_(5.3662342931246775732014790507973242913428532243778e-64) }}, 
      {{ SC_(0.43e2), SC_(0.30944411754608154296875e1), SC_(4.1216575595235093142918843353725556264506212864125e-45) }}, 
      {{ SC_(0.43e2), SC_(0.51139926910400390625e1), SC_(5.4463813503274181913070687530410938115216113472093e-36) }}, 
      {{ SC_(0.43e2), SC_(0.95070552825927734375e1), SC_(7.5987859853337546594566426625321963954519870473707e-25) }}, 
      {{ SC_(0.43e2), SC_(0.24750102996826171875e2), SC_(8.4046020901128022865517951949295241513745318568783e-09) }}, 
      {{ SC_(0.43e2), SC_(0.637722015380859375e2), SC_(0.009348897400560900595398716444898344316821423299023) }}, 
      {{ SC_(0.43e2), SC_(0.1252804412841796875e3), SC_(-0.0063859887199031891861776239394957010438185373771712) }}, 
      {{ SC_(0.43e2), SC_(0.25554705810546875e3), SC_(-0.0038719562179160789760563870151935512507547780971195) }}, 
      {{ SC_(0.43e2), SC_(0.503011474609375e3), SC_(-0.001555709122146954214435598774490700581240533794035) }}, 
      {{ SC_(0.43e2), SC_(0.10074598388671875e4), SC_(-5.0842154760502898438411578368062196011142932619031e-05) }}, 
      {{ SC_(0.43e2), SC_(0.1185395751953125e4), SC_(0.00081843752506265893621966352988194062108131044924503) }}, 
      {{ SC_(0.46e2), SC_(0.177219114266335964202880859375e-2), SC_(2.3465760464467227718228864345084111292340563290299e-195) }}, 
      {{ SC_(0.46e2), SC_(0.22177286446094512939453125e-2), SC_(5.6667965721701405950188601564010479380374376351177e-191) }}, 
      {{ SC_(0.46e2), SC_(0.7444499991834163665771484375e-2), SC_(2.6306208293516154185511096574027754090806944290439e-167) }}, 
      {{ SC_(0.46e2), SC_(0.1433600485324859619140625e-1), SC_(1.6854859901517895777297286032652467691716954766545e-154) }}, 
      {{ SC_(0.46e2), SC_(0.1760916970670223236083984375e-1), SC_(1.7607925007716527218940895079066234135337830469543e-150) }}, 
      {{ SC_(0.46e2), SC_(0.6152711808681488037109375e-1), SC_(4.9595941324378526925880462699809310693988141879801e-126) }}, 
      {{ SC_(0.46e2), SC_(0.11958599090576171875e0), SC_(4.8199113430094689671755711681348543368922953803762e-113) }}, 
      {{ SC_(0.46e2), SC_(0.15262925624847412109375e0), SC_(2.8255582215978619276489613510194077665983443017394e-108) }}, 
      {{ SC_(0.46e2), SC_(0.408089816570281982421875e0), SC_(4.6889028908333129823482276037355275258916616604331e-89) }}, 
      {{ SC_(0.46e2), SC_(0.6540834903717041015625e0), SC_(7.761262014918922100234463014583189994330893180393e-80) }}, 
      {{ SC_(0.46e2), SC_(0.1097540378570556640625e1), SC_(1.008112122787803562518136395044936898719947223729e-69) }}, 
      {{ SC_(0.46e2), SC_(0.30944411754608154296875e1), SC_(1.7410340755259691681551316923371678403883262396424e-49) }}, 
      {{ SC_(0.46e2), SC_(0.51139926910400390625e1), SC_(1.0451657559886888457676976618036214561019450704874e-39) }}, 
      {{ SC_(0.46e2), SC_(0.95070552825927734375e1), SC_(9.6103463965130866394520685308205826344529770831916e-28) }}, 
      {{ SC_(0.46e2), SC_(0.24750102996826171875e2), SC_(2.377006229148584695361115020248291122507923348323e-10) }}, 
      {{ SC_(0.46e2), SC_(0.637722015380859375e2), SC_(-0.012984372332519932271899277178048134429447493299467) }}, 
      {{ SC_(0.46e2), SC_(0.1252804412841796875e3), SC_(0.003713109026792423316068907913505459378734353624254) }}, 
      {{ SC_(0.46e2), SC_(0.25554705810546875e3), SC_(0.0022280669563351163048968571887253279726689983065867) }}, 
      {{ SC_(0.46e2), SC_(0.503011474609375e3), SC_(0.0016001881958429069308162077886574467838775452613443) }}, 
      {{ SC_(0.46e2), SC_(0.10074598388671875e4), SC_(0.00098866995047942334190440604554176140175778825117921) }}, 
      {{ SC_(0.46e2), SC_(0.1185395751953125e4), SC_(-0.000295025965609695717528776858442689489997623144281) }}, 
      {{ SC_(0.49e2), SC_(0.177219114266335964202880859375e-2), SC_(1.5250147096143372849566752109100531730111819723907e-209) }}, 
      {{ SC_(0.49e2), SC_(0.22177286446094512939453125e-2), SC_(7.2172301592916608923188728885596241510596004358558e-205) }}, 
      {{ SC_(0.49e2), SC_(0.7444499991834163665771484375e-2), SC_(1.2672799920775077978006468810268302201900190250084e-179) }}, 
      {{ SC_(0.49e2), SC_(0.1433600485324859619140625e-1), SC_(5.7985220035532424148597986257688941684276917971573e-166) }}, 
      {{ SC_(0.49e2), SC_(0.1760916970670223236083984375e-1), SC_(1.1226194869563980646484449148774426904376387200075e-161) }}, 
      {{ SC_(0.49e2), SC_(0.6152711808681488037109375e-1), SC_(1.3488204124990469982122501541568897987612508948045e-135) }}, 
      {{ SC_(0.49e2), SC_(0.11958599090576171875e0), SC_(9.6247574051528022808390643223670793872913867916866e-122) }}, 
      {{ SC_(0.49e2), SC_(0.15262925624847412109375e0), SC_(1.1730830851132380141747368944230959106173943631674e-116) }}, 
      {{ SC_(0.49e2), SC_(0.408089816570281982421875e0), SC_(3.7210951568601009503294794950690305162488779863731e-96) }}, 
      {{ SC_(0.49e2), SC_(0.6540834903717041015625e0), SC_(2.536312100357242699632511697293988207674177263205e-86) }}, 
      {{ SC_(0.49e2), SC_(0.1097540378570556640625e1), SC_(1.5568819523373445158146294255834240805140366207068e-75) }}, 
      {{ SC_(0.49e2), SC_(0.30944411754608154296875e1), SC_(6.0433202052291576330350176542593207623631320589555e-54) }}, 
      {{ SC_(0.49e2), SC_(0.51139926910400390625e1), SC_(1.6468199108941964192504991138375592734615557660727e-43) }}, 
      {{ SC_(0.49e2), SC_(0.95070552825927734375e1), SC_(9.9476944865388990121999138459773754997416073401977e-31) }}, 
      {{ SC_(0.49e2), SC_(0.24750102996826171875e2), SC_(5.3189833713626445541995680783504805187928724212459e-12) }}, 
      {{ SC_(0.49e2), SC_(0.637722015380859375e2), SC_(0.0070059148096379026224899104955815383432429141927778) }}, 
      {{ SC_(0.49e2), SC_(0.1252804412841796875e3), SC_(-0.00086060297893907525916966880252846527764358124363935) }}, 
      {{ SC_(0.49e2), SC_(0.25554705810546875e3), SC_(0.001481872975980406534754164071205331793638181287783) }}, 
      {{ SC_(0.49e2), SC_(0.503011474609375e3), SC_(0.00067190051483461535027161847660612630402333967825335) }}, 
      {{ SC_(0.49e2), SC_(0.10074598388671875e4), SC_(-0.00022206095312387607948149797318578191783557627074517) }}, 
      {{ SC_(0.49e2), SC_(0.1185395751953125e4), SC_(-0.00074835901022497307972980187930903425275172250228273) }}, 
      {{ SC_(0.52e2), SC_(0.177219114266335964202880859375e-2), SC_(8.2464130490430638818942837282410943243540604293665e-224) }}, 
      {{ SC_(0.52e2), SC_(0.22177286446094512939453125e-2), SC_(7.6481278602729115201699894046300119134352390123829e-219) }}, 
      {{ SC_(0.52e2), SC_(0.7444499991834163665771484375e-2), SC_(5.0797057152200150550776004193233133040508959471144e-192) }}, 
      {{ SC_(0.52e2), SC_(0.1433600485324859619140625e-1), SC_(1.6598204855445227444331511584097605545167355633243e-177) }}, 
      {{ SC_(0.52e2), SC_(0.1760916970670223236083984375e-1), SC_(5.9553682320089324009041120690317997864198220400168e-173) }}, 
      {{ SC_(0.52e2), SC_(0.6152711808681488037109375e-1), SC_(3.0522050664493628692304987838494997568816879921978e-145) }}, 
      {{ SC_(0.52e2), SC_(0.11958599090576171875e0), SC_(1.5991600809552013982944696990992903751467218385591e-130) }}, 
      {{ SC_(0.52e2), SC_(0.15262925624847412109375e0), SC_(4.0523275019377536149687374299578439049310100768411e-125) }}, 
      {{ SC_(0.52e2), SC_(0.408089816570281982421875e0), SC_(2.4570789331707945117282123094591452293190771637082e-103) }}, 
      {{ SC_(0.52e2), SC_(0.6540834903717041015625e0), SC_(6.8963191752321978717285541566277411929957116311348e-93) }}, 
      {{ SC_(0.52e2), SC_(0.1097540378570556640625e1), SC_(2.0004767539355678595455700978821155299365525515893e-81) }}, 
      {{ SC_(0.52e2), SC_(0.30944411754608154296875e1), SC_(1.7447403263191658956236453842155848777769879365678e-58) }}, 
      {{ SC_(0.52e2), SC_(0.51139926910400390625e1), SC_(2.1567814746633518149573636695707201486897157917772e-47) }}, 
      {{ SC_(0.52e2), SC_(0.95070552825927734375e1), SC_(8.5360984670723598078708244156118269969115503747257e-34) }}, 
      {{ SC_(0.52e2), SC_(0.24750102996826171875e2), SC_(9.6060272004903322555555632525925341749138146156907e-14) }}, 
      {{ SC_(0.52e2), SC_(0.637722015380859375e2), SC_(0.006908601793473096298323418806687121540307945754602) }}, 
      {{ SC_(0.52e2), SC_(0.1252804412841796875e3), SC_(-0.001511757553038325947585368492378747782337215149421) }}, 
      {{ SC_(0.52e2), SC_(0.25554705810546875e3), SC_(-0.0037858209621674373462298729134791360497163520374069) }}, 
      {{ SC_(0.52e2), SC_(0.503011474609375e3), SC_(-0.0019809328831869368876220080380433647612809704631087) }}, 
      {{ SC_(0.52e2), SC_(0.10074598388671875e4), SC_(-0.00092200687722808090005995172059672150180743809268283) }}, 
      {{ SC_(0.52e2), SC_(0.1185395751953125e4), SC_(0.00048167937168500539874758510969943625232721572654437) }}, 
      {{ SC_(0.55e2), SC_(0.177219114266335964202880859375e-2), SC_(3.7499274096965781403755047291140161204907447872079e-238) }}, 
      {{ SC_(0.55e2), SC_(0.22177286446094512939453125e-2), SC_(6.8156369646128465690286532515860830877781488075398e-233) }}, 
      {{ SC_(0.55e2), SC_(0.7444499991834163665771484375e-2), SC_(1.7122660747048565255626343786097763976528368796317e-204) }}, 
      {{ SC_(0.55e2), SC_(0.1433600485324859619140625e-1), SC_(3.9955047716183914987761883255557038544818646167407e-189) }}, 
      {{ SC_(0.55e2), SC_(0.1760916970670223236083984375e-1), SC_(2.6567542510578514165105911532729820728759508569179e-184) }}, 
      {{ SC_(0.55e2), SC_(0.6152711808681488037109375e-1), SC_(5.8081785583507577295015116363296166486701161948475e-155) }}, 
      {{ SC_(0.55e2), SC_(0.11958599090576171875e0), SC_(2.2343983863523528056451847025992477458763997926411e-139) }}, 
      {{ SC_(0.55e2), SC_(0.15262925624847412109375e0), SC_(1.1771903491869512075462189279952313690643597693028e-133) }}, 
      {{ SC_(0.55e2), SC_(0.408089816570281982421875e0), SC_(1.3643688014628027906587326086714925578079475494015e-110) }}, 
      {{ SC_(0.55e2), SC_(0.6540834903717041015625e0), SC_(1.5768580818724559427837940690686281474208252257894e-99) }}, 
      {{ SC_(0.55e2), SC_(0.1097540378570556640625e1), SC_(2.1615276523190658462020328801805510693869381236864e-87) }}, 
      {{ SC_(0.55e2), SC_(0.30944411754608154296875e1), SC_(4.2346268961579078795789945127742390736624102001168e-63) }}, 
      {{ SC_(0.55e2), SC_(0.51139926910400390625e1), SC_(2.3733148720740138224053085922360925485635049732368e-51) }}, 
      {{ SC_(0.55e2), SC_(0.95070552825927734375e1), SC_(6.1409175579485028996750267978630042798061205873868e-37) }}, 
      {{ SC_(0.55e2), SC_(0.24750102996826171875e2), SC_(1.4233100381415828902958185237029417343254441363024e-15) }}, 
      {{ SC_(0.55e2), SC_(0.637722015380859375e2), SC_(-0.0095812290850987183413608150795252333160605783231688) }}, 
      {{ SC_(0.55e2), SC_(0.1252804412841796875e3), SC_(0.0031764973177480983239838537298407622280291942692672) }}, 
      {{ SC_(0.55e2), SC_(0.25554705810546875e3), SC_(0.0029026850504740781957066048954958719842096907926845) }}, 
      {{ SC_(0.55e2), SC_(0.503011474609375e3), SC_(0.00055103958348322567252256718296661947038978095706673) }}, 
      {{ SC_(0.55e2), SC_(0.10074598388671875e4), SC_(0.00050872952715596185376282875298835402606685453166988) }}, 
      {{ SC_(0.55e2), SC_(0.1185395751953125e4), SC_(0.00061992219813287452157517509292431972827188083669598) }}, 
      {{ SC_(0.58e2), SC_(0.177219114266335964202880859375e-2), SC_(1.4476304330586041136551705000804145544902261640658e-252) }}, 
      {{ SC_(0.58e2), SC_(0.22177286446094512939453125e-2), SC_(5.1562602174440199627484531866737157576226691467083e-247) }}, 
      {{ SC_(0.58e2), SC_(0.7444499991834163665771484375e-2), SC_(4.8998300587608731374827545421219171950099307319986e-217) }}, 
      {{ SC_(0.58e2), SC_(0.1433600485324859619140625e-1), SC_(8.1650575759274771557361281104075843991539954474695e-201) }}, 
      {{ SC_(0.58e2), SC_(0.1760916970670223236083984375e-1), SC_(1.0061696465790781667736469203102729534045381762147e-195) }}, 
      {{ SC_(0.58e2), SC_(0.6152711808681488037109375e-1), SC_(9.3830327209999123686806584846160930127251471007793e-165) }}, 
      {{ SC_(0.58e2), SC_(0.11958599090576171875e0), SC_(2.650367956085127995216751337073278183462605995287e-148) }}, 
      {{ SC_(0.58e2), SC_(0.15262925624847412109375e0), SC_(2.903124323622911409829050402803289231887083028365e-142) }}, 
      {{ SC_(0.58e2), SC_(0.408089816570281982421875e0), SC_(6.4316070964139898664384321499139698923133148702845e-118) }}, 
      {{ SC_(0.58e2), SC_(0.6540834903717041015625e0), SC_(3.0608338729787222843236230594814098330550735585225e-106) }}, 
      {{ SC_(0.58e2), SC_(0.1097540378570556640625e1), SC_(1.9826706855355044678661424675211702071205612839288e-93) }}, 
      {{ SC_(0.58e2), SC_(0.30944411754608154296875e1), SC_(8.7228930336356092303723788918145325583313934911015e-68) }}, 
      {{ SC_(0.58e2), SC_(0.51139926910400390625e1), SC_(2.2154573151564605748776496480208597972846093651378e-55) }}, 
      {{ SC_(0.58e2), SC_(0.95070552825927734375e1), SC_(3.7408088108382429205686154655296968150299217766739e-40) }}, 
      {{ SC_(0.58e2), SC_(0.24750102996826171875e2), SC_(1.7542837953515687203678203434382344249154612451961e-17) }}, 
      {{ SC_(0.58e2), SC_(0.637722015380859375e2), SC_(-0.0067708610212249877224120895037510817852901962275794) }}, 
      {{ SC_(0.58e2), SC_(0.1252804412841796875e3), SC_(-0.0041591007901644300956897573166715522264542608471619) }}, 
      {{ SC_(0.58e2), SC_(0.25554705810546875e3), SC_(0.00018025720350905183747192616094732195540361038314487) }}, 
      {{ SC_(0.58e2), SC_(0.503011474609375e3), SC_(0.0016097164295892651390631514736999139286215525312629) }}, 
      {{ SC_(0.58e2), SC_(0.10074598388671875e4), SC_(0.00075314462564204569171828178095268549063987732399349) }}, 
      {{ SC_(0.58e2), SC_(0.1185395751953125e4), SC_(-0.00065464124389262563181804449659033668956464404581817) }}, 
      {{ SC_(0.61e2), SC_(0.177219114266335964202880859375e-2), SC_(4.7846898125667423746743417551270010003238247276516e-267) }}, 
      {{ SC_(0.61e2), SC_(0.22177286446094512939453125e-2), SC_(3.3398306277294130849325090739222518892213759455678e-261) }}, 
      {{ SC_(0.61e2), SC_(0.7444499991834163665771484375e-2), SC_(1.2004719653715347459853992856818224416918187152011e-229) }}, 
      {{ SC_(0.61e2), SC_(0.1433600485324859619140625e-1), SC_(1.4285915831759991702708235266908413559013185784195e-212) }}, 
      {{ SC_(0.61e2), SC_(0.1760916970670223236083984375e-1), SC_(3.2625131876993266095119855855632714544764549752144e-207) }}, 
      {{ SC_(0.61e2), SC_(0.6152711808681488037109375e-1), SC_(1.2977998011404656319853160359712626507524420160768e-174) }}, 
      {{ SC_(0.61e2), SC_(0.11958599090576171875e0), SC_(2.6916143055563581590059162764926003782754791173255e-157) }}, 
      {{ SC_(0.61e2), SC_(0.15262925624847412109375e0), SC_(6.1297897139867231982089254896862393455712506778801e-151) }}, 
      {{ SC_(0.61e2), SC_(0.408089816570281982421875e0), SC_(2.5957732787881650403239180128287001269910591991745e-125) }}, 
      {{ SC_(0.61e2), SC_(0.6540834903717041015625e0), SC_(5.0867892663014227309637157527310247694699831316708e-113) }}, 
      {{ SC_(0.61e2), SC_(0.1097540378570556640625e1), SC_(1.5570021614075599265149811316648324454876817163322e-99) }}, 
      {{ SC_(0.61e2), SC_(0.30944411754608154296875e1), SC_(1.5380428116647953033235087266220830366935795977434e-72) }}, 
      {{ SC_(0.61e2), SC_(0.51139926910400390625e1), SC_(1.7695460915697677845853843221170529803110031977443e-59) }}, 
      {{ SC_(0.61e2), SC_(0.95070552825927734375e1), SC_(1.9467442792778411416797267656516287666544599838604e-43) }}, 
      {{ SC_(0.61e2), SC_(0.24750102996826171875e2), SC_(1.8200790244284308790522222260292196200777876151537e-19) }}, 
      {{ SC_(0.61e2), SC_(0.637722015380859375e2), SC_(0.0018677398563172789782680089690103735276080112074262) }}, 
      {{ SC_(0.61e2), SC_(0.1252804412841796875e3), SC_(0.0045651073151555244232064475776021546403039720433722) }}, 
      {{ SC_(0.61e2), SC_(0.25554705810546875e3), SC_(-0.0030353854346433689710635352699470295083576244341073) }}, 
      {{ SC_(0.61e2), SC_(0.503011474609375e3), SC_(-0.0016460943300783220104010798160172646122205004417106) }}, 
      {{ SC_(0.61e2), SC_(0.10074598388671875e4), SC_(-0.00076883161702827974394772020363121878699485590527748) }}, 
      {{ SC_(0.61e2), SC_(0.1185395751953125e4), SC_(-0.00042604986672311800200670840141747346530141242152301) }},
   }};


