# Expand $PATH to include the directory where snappy applications go.
set -ul snap_bin_path "/snap/bin"
if not contains $snap_bin_path $PATH
    set PATH $PATH $snap_bin_path
end

# Desktop files (used by desktop environments within both X11 and Wayland) are
# looked for in XDG_DATA_DIRS; make sure it includes the relevant directory for
# snappy applications' desktop files.
set -ul snap_xdg_path /var/lib/snapd/desktop
set --path --export XDG_DATA_DIRS $XDG_DATA_DIRS
if not contains $snap_xdg_path $XDG_DATA_DIRS
    set XDG_DATA_DIRS $XDG_DATA_DIRS $snap_xdg_path
end
