/*
 * Reserve all free nodes on the system
 */
#define _GNU_SOURCE	/* required for getsid */
#include "basil_alps.h"
#include "basil_mysql.h"

extern int my_system(const char *fmt, ...);

int main(int argc, char **argv)
{
	MYSQL *handle;
	struct nodespec *free_nodes;
	int rc, num_nodes, num_cores;
	long rsvn_id;

	if (geteuid())
		errx(1, "this program can only be run by root.");

	handle = cray_connect_sdb();
	if (handle == NULL)
		errx(1, "can not connect to SDB database");

	num_cores = cray_num_compute_node_cores(handle);
	if (num_cores < 0)
		errx(1, "number-of-cores lookup failed");
	printf("Number of compute-node-cores: %i\n", num_cores);

	mysql_close(handle);

	/*
	 * 1. query available nodes
	 */
	free_nodes = get_free_nodes(get_basil_version());
	num_nodes  = ns_count_nodes(free_nodes);

	printf("%u free node%s: ", num_nodes, num_nodes == 1 ? "" : "s");
	if (num_nodes)
		printf(" %s\n", ns_to_string(free_nodes));
	else
		exit(EXIT_SUCCESS);	/* nothing to reserve */

	/*
	 * 2. create the reservation, use current user as owner
	 */
	rsvn_id = basil_reserve(cuserid(NULL), "1234.this.is.a.test",
				num_nodes * num_cores, 0, 0, 0, free_nodes, NULL);
	if (rsvn_id < 0)
		errx(1, "RESERVE request failed with %s error",
		     is_transient_error(rsvn_id) ? "transient" : "permanent");


	printf("STEP 1: RESERVEd reservation #%ld\n", rsvn_id);
	my_system("sleep 1; apstat -rvv -R %ld", rsvn_id);

	/*
	 * 3. Confirm it using the session-leader PID as admin_cookie
	 */
	rc = basil_confirm(rsvn_id, -1, getsid(0));
	if (rc < 0)
		errx(1, "CONFIRM request failed with %s error",
		     is_transient_error(rc) ? "transient" : "permanent");

	printf("\nSTEP 2: CONFIRMed reservation #%ld\n", rsvn_id);
	my_system("sleep 1; apstat -rvv -R %ld", rsvn_id);

	/*
	 * 4. Release it
	 */
	if (basil_release(rsvn_id) < 0)
		warnx("WARNING: could not release reservation #%ld", rsvn_id);
	printf("\nSTEP 3: RELEASEd reservation #%ld\n", rsvn_id);

	return EXIT_SUCCESS;
}
