/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.xml.dtd.parse;

import com.thaiopensource.xml.dtd.om.AttlistDecl;
import com.thaiopensource.xml.dtd.om.AttributeDefaultDef;
import com.thaiopensource.xml.dtd.om.AttributeGroupDef;
import com.thaiopensource.xml.dtd.om.Comment;
import com.thaiopensource.xml.dtd.om.DatatypeDef;
import com.thaiopensource.xml.dtd.om.Def;
import com.thaiopensource.xml.dtd.om.ElementDecl;
import com.thaiopensource.xml.dtd.om.EnumGroupDef;
import com.thaiopensource.xml.dtd.om.ExternalEntityDecl;
import com.thaiopensource.xml.dtd.om.ExternalIdDef;
import com.thaiopensource.xml.dtd.om.ExternalIdRef;
import com.thaiopensource.xml.dtd.om.Flag;
import com.thaiopensource.xml.dtd.om.FlagDef;
import com.thaiopensource.xml.dtd.om.IgnoredSection;
import com.thaiopensource.xml.dtd.om.IncludedSection;
import com.thaiopensource.xml.dtd.om.InternalEntityDecl;
import com.thaiopensource.xml.dtd.om.ModelGroupDef;
import com.thaiopensource.xml.dtd.om.NameSpec;
import com.thaiopensource.xml.dtd.om.NameSpecDef;
import com.thaiopensource.xml.dtd.om.NotationDecl;
import com.thaiopensource.xml.dtd.om.OverriddenDef;
import com.thaiopensource.xml.dtd.om.ParamDef;
import com.thaiopensource.xml.dtd.om.ProcessingInstruction;
import com.thaiopensource.xml.dtd.om.TopLevel;
import com.thaiopensource.xml.dtd.parse.DtdBuilder;
import com.thaiopensource.xml.dtd.parse.Entity;
import com.thaiopensource.xml.dtd.parse.Param;
import com.thaiopensource.xml.dtd.parse.ParamStream;
import java.util.Enumeration;
import java.util.Vector;

class Decl {
    static final int REFERENCE = 0;
    static final int REFERENCE_END = 1;
    static final int ELEMENT = 2;
    static final int ATTLIST = 3;
    static final int ENTITY = 4;
    static final int NOTATION = 5;
    static final int INCLUDE_SECTION = 6;
    static final int IGNORE_SECTION = 7;
    static final int COMMENT = 8;
    static final int PROCESSING_INSTRUCTION = 9;
    final int type;
    Vector params;
    String value;
    Entity entity;
    Vector decls;

    Decl(int n) {
        this.type = n;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Decl)) {
            return false;
        }
        Decl decl = (Decl)object;
        if (this.type != decl.type) {
            return false;
        }
        if (this.entity != decl.entity) {
            return false;
        }
        if (this.value != null && !this.value.equals(decl.value)) {
            return false;
        }
        if (this.params != null) {
            int n = this.params.size();
            if (decl.params.size() != n) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (this.params.elementAt(i).equals(decl.params.elementAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    ElementDecl createElementDecl() {
        ParamStream paramStream = new ParamStream(this.params, true);
        NameSpec nameSpec = Param.paramsToNameSpec(paramStream);
        return new ElementDecl(nameSpec, Param.paramsToModelGroup(paramStream));
    }

    AttlistDecl createAttlistDecl() {
        ParamStream paramStream = new ParamStream(this.params, true);
        NameSpec nameSpec = Param.paramsToNameSpec(paramStream);
        return new AttlistDecl(nameSpec, Param.paramsToAttributeGroup(paramStream));
    }

    TopLevel createEntityDecl(DtdBuilder dtdBuilder) {
        ParamStream paramStream = new ParamStream(this.params);
        paramStream.advance();
        if (paramStream.type != 4) {
            return this.createGeneralEntityDecl(dtdBuilder, paramStream.value);
        }
        paramStream.advance();
        String string = paramStream.value;
        Entity entity = dtdBuilder.lookupParamEntity(string);
        if (entity.decl == null) {
            entity.decl = this;
            return Decl.createDef(entity);
        }
        Entity entity2 = entity.overrides;
        while (entity2.decl != null) {
            entity2 = entity2.overrides;
        }
        entity2.decl = this;
        return new OverriddenDef(Decl.createDef(entity2), entity.entityValue != null && entity.entityValue.equals(entity2.entityValue));
    }

    static Def createDef(Entity entity) {
        String string = entity.name;
        switch (entity.semantic) {
            case 1: {
                entity.modelGroup = entity.toModelGroup();
                return new ModelGroupDef(string, entity.modelGroup);
            }
            case 2: {
                entity.attributeGroup = Param.paramsToAttributeGroup(entity.parsed);
                return new AttributeGroupDef(string, entity.attributeGroup);
            }
            case 4: {
                entity.datatype = Param.paramsToDatatype(entity.parsed);
                return new DatatypeDef(string, entity.datatype);
            }
            case 3: {
                entity.enumGroup = entity.toEnumGroup();
                return new EnumGroupDef(string, entity.enumGroup);
            }
            case 5: {
                entity.flag = Param.paramsToFlag(entity.parsed);
                return new FlagDef(string, entity.flag);
            }
            case 6: {
                entity.nameSpec = entity.toNameSpec();
                return new NameSpecDef(string, entity.nameSpec);
            }
            case 7: {
                entity.attributeDefault = Param.paramsToAttributeDefault(entity.parsed);
                return new AttributeDefaultDef(string, entity.attributeDefault);
            }
        }
        if (entity.problem == 0 && !entity.overridden) {
            throw new RuntimeException("unexplained problem for entity " + entity.name);
        }
        if (entity.text == null) {
            return new ExternalIdDef(string, entity.getExternalId());
        }
        return new ParamDef(string, entity.entityValue);
    }

    TopLevel createGeneralEntityDecl(DtdBuilder dtdBuilder, String string) {
        Entity entity = dtdBuilder.lookupGeneralEntity(string);
        while (entity.decl != null) {
            entity = entity.overrides;
        }
        entity.decl = this;
        if (entity.text == null) {
            return new ExternalEntityDecl(string, entity.getExternalId());
        }
        return new InternalEntityDecl(string, new String(entity.text));
    }

    IncludedSection createIncludedSection(DtdBuilder dtdBuilder) {
        Flag flag = Param.paramsToFlag(this.params);
        Vector vector = Decl.declsToTopLevel(dtdBuilder, this.decls.elements());
        TopLevel[] topLevelArray = new TopLevel[vector.size()];
        for (int i = 0; i < topLevelArray.length; ++i) {
            topLevelArray[i] = (TopLevel)vector.elementAt(i);
        }
        return new IncludedSection(flag, topLevelArray);
    }

    static Vector declsToTopLevel(DtdBuilder dtdBuilder, Enumeration enumeration) {
        Vector<ProcessingInstruction> vector = new Vector<ProcessingInstruction>();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            TopLevel topLevel = null;
            Decl decl = (Decl)enumeration.nextElement();
            switch (decl.type) {
                case 8: {
                    topLevel = new Comment(decl.value);
                    break;
                }
                case 9: {
                    topLevel = decl.createProcessingInstruction();
                    break;
                }
                case 5: {
                    topLevel = decl.createNotationDecl(dtdBuilder);
                    break;
                }
                case 2: {
                    topLevel = decl.createElementDecl();
                    break;
                }
                case 3: {
                    topLevel = decl.createAttlistDecl();
                    break;
                }
                case 4: {
                    topLevel = decl.createEntityDecl(dtdBuilder);
                    break;
                }
                case 6: {
                    topLevel = decl.createIncludedSection(dtdBuilder);
                    break;
                }
                case 7: {
                    topLevel = decl.createIgnoredSection();
                    break;
                }
                case 0: {
                    if (decl.entity.text == null) {
                        topLevel = decl.createExternalIdRef(dtdBuilder, enumeration);
                        break;
                    }
                    ++n;
                    break;
                }
                case 1: {
                    if (n == 0) {
                        return vector;
                    }
                    --n;
                }
            }
            if (topLevel == null) continue;
            vector.addElement((ProcessingInstruction)topLevel);
        }
        return vector;
    }

    ExternalIdRef createExternalIdRef(DtdBuilder dtdBuilder, Enumeration enumeration) {
        Vector vector = Decl.declsToTopLevel(dtdBuilder, enumeration);
        TopLevel[] topLevelArray = new TopLevel[vector.size()];
        for (int i = 0; i < topLevelArray.length; ++i) {
            topLevelArray[i] = (TopLevel)vector.elementAt(i);
        }
        return new ExternalIdRef(this.entity.name, this.entity.getExternalId(), this.entity.uri, this.entity.encoding, topLevelArray);
    }

    IgnoredSection createIgnoredSection() {
        return new IgnoredSection(Param.paramsToFlag(this.params), this.value);
    }

    ProcessingInstruction createProcessingInstruction() {
        int n;
        int n2 = this.value.length();
        for (n = 0; n < n2 && !Decl.isWS(this.value.charAt(n)); ++n) {
        }
        String string = this.value.substring(0, n);
        if (n < n2) {
            ++n;
            while (n < n2 && Decl.isWS(this.value.charAt(n))) {
                ++n;
            }
        }
        return new ProcessingInstruction(string, this.value.substring(n, n2));
    }

    private static boolean isWS(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    NotationDecl createNotationDecl(DtdBuilder dtdBuilder) {
        ParamStream paramStream = new ParamStream(this.params);
        paramStream.advance();
        return new NotationDecl(paramStream.value, dtdBuilder.lookupNotation(paramStream.value).getExternalId());
    }

    static void examineElementNames(DtdBuilder dtdBuilder, Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            Decl decl = (Decl)enumeration.nextElement();
            switch (decl.type) {
                case 2: 
                case 3: {
                    Param.examineElementNames(dtdBuilder, decl.params.elements());
                    break;
                }
                case 6: {
                    Decl.examineElementNames(dtdBuilder, decl.decls.elements());
                }
            }
        }
    }
}

