////////////////////////////////////////////////////////////////////////////////////////
//
//  Copyright 2023 OVITO GmbH, Germany
//  Copyright 2019 Henrik Andersen Sveinsson
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify it either under the
//  terms of the GNU General Public License version 3 as published by the Free Software
//  Foundation (the "GPL") or, at your option, under the terms of the MIT License.
//  If you do not alter this notice, a recipient may use your version of this
//  file under either the GPL or the MIT License.
//
//  You should have received a copy of the GPL along with this program in a
//  file LICENSE.GPL.txt.  You should have received a copy of the MIT License along
//  with this program in a file LICENSE.MIT.txt
//
//  This software is distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND,
//  either express or implied. See the GPL or the MIT License for the specific language
//  governing rights and limitations.
//
////////////////////////////////////////////////////////////////////////////////////////

#include <ovito/particles/gui/ParticlesGui.h>
#include <ovito/particles/gui/modifier/analysis/StructureListParameterUI.h>
#include <ovito/particles/modifier/analysis/chill_plus/ChillPlusModifier.h>
#include <ovito/gui/desktop/properties/FloatParameterUI.h>
#include <ovito/gui/desktop/properties/BooleanParameterUI.h>
#include <ovito/gui/desktop/properties/ObjectStatusDisplay.h>
#include "ChillPlusModifierEditor.h"

namespace Ovito {

IMPLEMENT_OVITO_CLASS(ChillPlusModifierEditor);
SET_OVITO_OBJECT_EDITOR(ChillPlusModifier, ChillPlusModifierEditor);

/******************************************************************************
* Sets up the UI widgets of the editor.
******************************************************************************/
void ChillPlusModifierEditor::createUI(const RolloutInsertionParameters& rolloutParams)
{
    // Create a rollout.
    QWidget* rollout = createRollout(tr("Chill+"), rolloutParams, "manual:particles.modifiers.chill_plus");

    // Create the rollout contents.
    QVBoxLayout* layout1 = new QVBoxLayout(rollout);
    layout1->setContentsMargins(4,4,4,4);
    layout1->setSpacing(4);

    QGridLayout* gridlayout = new QGridLayout();

    // Cutoff
    FloatParameterUI* cutoffRadiusPUI = new FloatParameterUI(this, PROPERTY_FIELD(ChillPlusModifier::cutoff));
    gridlayout->addWidget(cutoffRadiusPUI->label(), 0, 0);
    gridlayout->addLayout(cutoffRadiusPUI->createFieldLayout(), 0, 1);
    layout1->addLayout(gridlayout);

    // Use only selected particles.
    BooleanParameterUI* onlySelectedParticlesUI = new BooleanParameterUI(this, PROPERTY_FIELD(StructureIdentificationModifier::onlySelectedParticles));
    layout1->addWidget(onlySelectedParticlesUI->checkBox());

    // Color by type
    BooleanParameterUI* colorByTypeUI = new BooleanParameterUI(this, PROPERTY_FIELD(StructureIdentificationModifier::colorByType));
    layout1->addWidget(colorByTypeUI->checkBox());

    // Status label.
    layout1->addSpacing(10);
    layout1->addWidget((new ObjectStatusDisplay(this))->statusWidget());

    StructureListParameterUI* structureTypesPUI = new StructureListParameterUI(this, true);
    layout1->addSpacing(10);
    layout1->addWidget(new QLabel(tr("Structure types:")));
    layout1->addWidget(structureTypesPUI->tableWidget());
    layout1->addWidget(structureTypesPUI->createNotesLabel());
}

}   // End of namespace
