/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.chefproject.util.BlobNode;

public class Blob
implements Cloneable,
Serializable {
    public static final int NODE_SIZE = 512;
    protected transient BlobNode head;
    protected transient BlobNode tail;
    protected transient int size;
    protected int nodeSize;
    protected transient BlobNode curr;
    protected transient BlobNode enumerationNode = null;
    protected transient int enumerationPos = 0;

    protected static final boolean between(char test, char low, char high) {
        return test >= low && test <= high;
    }

    public static final boolean between(int test, int low, int high) {
        return test >= low && test <= high;
    }

    public static final String toHex(byte b) {
        char[] ret = new char[]{Blob.hexDigit(b >>> 4 & 0xF), Blob.hexDigit(b >>> 0 & 0xF)};
        return new String(ret);
    }

    public static final String toHex(short s) {
        StringBuffer sb = new StringBuffer(5);
        sb.append(Blob.toHex((byte)(s >>> 8)));
        sb.append(' ');
        sb.append(Blob.toHex((byte)(s >>> 0)));
        return sb.toString();
    }

    public static final String toHex(int i) {
        StringBuffer sb = new StringBuffer(11);
        sb.append(Blob.toHex((byte)(i >>> 24)));
        sb.append(' ');
        sb.append(Blob.toHex((byte)(i >>> 16)));
        sb.append(' ');
        sb.append(Blob.toHex((byte)(i >>> 8)));
        sb.append(' ');
        sb.append(Blob.toHex((byte)(i >>> 0)));
        return sb.toString();
    }

    public static final String toHex(long l) {
        StringBuffer sb = new StringBuffer(11);
        sb.append(Blob.toHex((byte)(l >>> 56)));
        sb.append(' ');
        sb.append(Blob.toHex((byte)(l >>> 48)));
        sb.append(' ');
        sb.append(Blob.toHex((byte)(l >>> 40)));
        sb.append(' ');
        sb.append(Blob.toHex((byte)(l >>> 32)));
        sb.append(' ');
        sb.append(Blob.toHex((byte)(l >>> 24)));
        sb.append(' ');
        sb.append(Blob.toHex((byte)(l >>> 16)));
        sb.append(' ');
        sb.append(Blob.toHex((byte)(l >>> 8)));
        sb.append(' ');
        sb.append(Blob.toHex((byte)(l >>> 0)));
        return sb.toString();
    }

    public static final String toHex(String s) {
        StringBuffer sb = new StringBuffer();
        char[] chars = s.toCharArray();
        int x = 0;
        while (x < chars.length) {
            sb.append(Blob.toHex((byte)chars[x]));
            if (x != chars.length - 1) {
                sb.append(' ');
            }
            ++x;
        }
        return sb.toString();
    }

    public static final char hexDigit(int i) {
        switch (i) {
            case 0: {
                return '0';
            }
            case 1: {
                return '1';
            }
            case 2: {
                return '2';
            }
            case 3: {
                return '3';
            }
            case 4: {
                return '4';
            }
            case 5: {
                return '5';
            }
            case 6: {
                return '6';
            }
            case 7: {
                return '7';
            }
            case 8: {
                return '8';
            }
            case 9: {
                return '9';
            }
            case 10: {
                return 'A';
            }
            case 11: {
                return 'B';
            }
            case 12: {
                return 'C';
            }
            case 13: {
                return 'D';
            }
            case 14: {
                return 'E';
            }
            case 15: {
                return 'F';
            }
        }
        throw new IllegalArgumentException("Invalid digit:" + i);
    }

    public static final String strstr(int n, char c) {
        StringBuffer ret = new StringBuffer(n);
        int x = 0;
        while (x < n) {
            ret.append(c);
            ++x;
        }
        return ret.toString();
    }

    public static final String spaces(int n) {
        return Blob.strstr(n, ' ');
    }

    public Blob() {
        this(512);
    }

    public Blob(int nodeSize) {
        this.nodeSize = nodeSize;
        this.tail = this.head = new BlobNode(nodeSize);
        this.size = 0;
    }

    public Blob(Blob b) {
        this();
        this.append(b);
    }

    public Blob(byte[] arr) {
        this(arr, 0, arr.length);
    }

    public Blob(byte[] arr, int startPos, int len) {
        this();
        this.append(arr, startPos, len);
    }

    public synchronized void append(byte b) {
        if (this.tail.freespace() == 0) {
            this.appendNode(this.nodeSize);
        }
        this.tail.data[this.tail.size] = b;
        ++this.tail.size;
        ++this.size;
    }

    public synchronized void append(char c) {
        this.append(false, c);
    }

    public synchronized void append(boolean addHighByte, char c) {
        if (addHighByte) {
            this.append((byte)(c >> 8));
        }
        this.append((byte)(c >> 0));
    }

    public synchronized void append(short s) {
        this.append((byte)(s >> 8));
        this.append((byte)(s >> 0));
    }

    public synchronized void append(int i) {
        this.append((byte)(i >> 24));
        this.append((byte)(i >> 16));
        this.append((byte)(i >> 8));
        this.append((byte)(i >> 0));
    }

    public synchronized void append(long l) {
        this.append((byte)(l >> 56));
        this.append((byte)(l >> 48));
        this.append((byte)(l >> 40));
        this.append((byte)(l >> 32));
        this.append((byte)(l >> 24));
        this.append((byte)(l >> 16));
        this.append((byte)(l >> 8));
        this.append((byte)(l >> 0));
    }

    public synchronized void append(float f) {
        this.append(Float.floatToIntBits(f));
    }

    public synchronized void append(double d) {
        this.append(Double.doubleToLongBits(d));
    }

    public synchronized void append(String s) {
        this.append(false, s);
    }

    public synchronized void append(boolean addHighByte, String s) {
        int x = 0;
        while (x < s.length()) {
            this.append(addHighByte, s.charAt(x));
            ++x;
        }
    }

    public synchronized void append(byte[] arr) {
        this.append(arr, 0, arr.length);
    }

    public synchronized void append(byte[] arr, int startPos, int len) {
        if (this.tail.freespace() < len) {
            BlobNode oldTail = this.tail;
            this.appendNode(Math.max(len, this.nodeSize));
            if (oldTail.size == 0) {
                BlobNode bn = this.findBefore(oldTail);
                if (bn == null) {
                    this.head = this.tail;
                } else {
                    bn.next = this.tail;
                }
            }
        }
        System.arraycopy(arr, startPos, this.tail.data, this.tail.size, len);
        this.tail.size += len;
        this.size += len;
    }

    public synchronized void append(Blob b) {
        BlobNode bn;
        boolean setHead = false;
        if (this.tail.size == 0) {
            bn = this.findBefore(this.tail);
            if (bn == null) {
                setHead = true;
            } else {
                this.tail = bn;
                this.tail.next = null;
            }
        }
        bn = b.head;
        if (setHead) {
            this.tail = this.head = (BlobNode)bn.clone();
            this.size = this.head.size;
            bn = bn.next;
        }
        while (bn != null) {
            this.tail = this.tail.next = (BlobNode)bn.clone();
            this.size += this.tail.size;
            bn = bn.next;
        }
    }

    public synchronized void insertByte(int pos, byte b) {
        byte[] arr = new byte[]{b};
        this.insertBytes(pos, arr, 0, 1);
    }

    public synchronized void insertBytes(int pos, byte[] arr) {
        this.insertBytes(pos, arr, 0, arr.length);
    }

    public synchronized void insertBytes(int pos, byte[] arr, int startPos, int len) {
        if (pos == this.size) {
            this.append(arr, startPos, len);
            return;
        }
        if (!Blob.between(pos, 0, this.size - 1)) {
            throw new IndexOutOfBoundsException();
        }
        int currIndex = this.seek(pos);
        if (this.curr.freespace() >= len) {
            System.arraycopy(this.curr.data, currIndex, this.curr.data, currIndex + len, this.curr.size - currIndex);
            System.arraycopy(arr, startPos, this.curr.data, currIndex, len);
            this.curr.size += len;
        } else {
            BlobNode newNode = new BlobNode(this.nodeSize, arr, startPos, len);
            BlobNode before = this.findBefore(this.curr);
            if (currIndex == 0) {
                if (before == null) {
                    newNode.next = this.head;
                    this.head = newNode;
                } else {
                    newNode.next = before.next;
                    before.next = newNode;
                }
            } else {
                BlobNode a = new BlobNode(Math.max(this.nodeSize, currIndex));
                BlobNode b = new BlobNode(Math.max(this.nodeSize, this.curr.size - currIndex));
                a.size = currIndex;
                System.arraycopy(this.curr.data, 0, a.data, 0, a.size);
                b.size = this.curr.size - currIndex;
                System.arraycopy(this.curr.data, currIndex, b.data, 0, b.size);
                b.next = before == null ? this.head : before.next;
                newNode.next = b;
                a.next = newNode;
                if (before == null) {
                    this.head = a;
                } else {
                    before.next = a;
                }
            }
        }
        this.size += len;
    }

    public synchronized void truncate(int len) {
        int currIndex;
        if (len == this.size) {
            return;
        }
        if (!Blob.between(len, 0, this.size)) {
            throw new IndexOutOfBoundsException();
        }
        this.curr.size = currIndex = this.seek(len);
        this.size = len;
        this.curr.next = null;
        this.tail = this.curr;
        System.gc();
    }

    public synchronized void removeByte(int pos) {
        this.removeBytes(pos, 1);
    }

    public synchronized void removeBytes(int pos, int len) {
        if (!Blob.between(pos, 0, this.size - 1) || !Blob.between(pos + len, 0, this.size)) {
            throw new IndexOutOfBoundsException();
        }
        int startPos = this.seek(pos);
        BlobNode startNode = this.curr;
        int endPos = this.seek(pos + len);
        BlobNode endNode = this.curr;
        if (startNode == endNode) {
            System.arraycopy(this.curr.data, endPos, this.curr.data, startPos, this.curr.size - endPos);
            this.curr.size -= len;
        } else {
            BlobNode newNode = new BlobNode(Math.max(this.nodeSize, startPos + (endNode.size - endPos)));
            System.arraycopy(startNode.data, 0, newNode.data, 0, startPos);
            System.arraycopy(endNode.data, endPos, newNode.data, startPos, endNode.size - endPos);
            newNode.size = startPos + 1 + (endNode.size - endPos);
            newNode.next = endNode.next;
            BlobNode before = this.findBefore(startNode);
            if (before == null) {
                this.head = newNode;
            } else {
                before.next = newNode;
            }
            System.gc();
        }
        this.size -= len;
    }

    public byte[] getBytes() {
        return this.getBytes(0, this.size);
    }

    public synchronized byte[] getBytes(int start, int len) {
        if (start == 0 && len == 0) {
            return new byte[0];
        }
        if (!Blob.between(start, 0, this.size - 1) || !Blob.between(start + len, 0, this.size)) {
            throw new IndexOutOfBoundsException();
        }
        byte[] ret = new byte[len];
        int bytesCopied = 0;
        int copyFromThis = 0;
        int currIndex = this.seek(start);
        while (bytesCopied < len) {
            copyFromThis = Math.min(this.curr.size - currIndex, len - bytesCopied);
            System.arraycopy(this.curr.data, currIndex, ret, bytesCopied, copyFromThis);
            bytesCopied += copyFromThis;
            this.curr = this.curr.next;
            currIndex = 0;
        }
        return ret;
    }

    public synchronized byte byteAt(int pos) {
        if (!Blob.between(pos, 0, this.size - 1)) {
            throw new IndexOutOfBoundsException();
        }
        int currIndex = this.seek(pos);
        return this.curr.data[currIndex];
    }

    public synchronized char charAt(int pos) {
        return this.charAt(false, pos);
    }

    public synchronized char charAt(boolean useHighByte, int pos) {
        if (!Blob.between(pos, 0, this.size - (useHighByte ? 2 : 1))) {
            throw new IndexOutOfBoundsException();
        }
        char ret = useHighByte ? (char)this.shortAt(pos) : (char)this.byteAt(pos);
        return ret;
    }

    public synchronized short shortAt(int pos) {
        if (!Blob.between(pos, 0, this.size - 2)) {
            throw new IndexOutOfBoundsException();
        }
        short ret = 0;
        this.beginEnumeration(pos);
        int x = 0;
        while (x < 2) {
            short temp = (short)(this.nextByte() << 8 >>> 8);
            ret = (short)(ret | temp << 8 * (1 - x));
            ++x;
        }
        return ret;
    }

    public synchronized int intAt(int pos) {
        if (!Blob.between(pos, 0, this.size - 4)) {
            throw new IndexOutOfBoundsException();
        }
        int ret = 0;
        this.beginEnumeration(pos);
        int x = 0;
        while (x < 4) {
            int temp = this.nextByte() << 24 >>> 24;
            ret |= temp << 8 * (3 - x);
            ++x;
        }
        return ret;
    }

    public synchronized long longAt(int pos) {
        if (!Blob.between(pos, 0, this.size - 8)) {
            throw new IndexOutOfBoundsException();
        }
        long ret = 0L;
        this.beginEnumeration(pos);
        int x = 0;
        while (x < 8) {
            long temp = (long)this.nextByte() << 56 >>> 56;
            ret |= temp << 8 * (7 - x);
            ++x;
        }
        return ret;
    }

    protected synchronized float floatAt(int pos) {
        return Float.intBitsToFloat(this.intAt(pos));
    }

    public synchronized double doubleAt(int pos) {
        return Double.longBitsToDouble(this.longAt(pos));
    }

    public synchronized String getString() {
        return this.getString(false, 0, this.size);
    }

    public synchronized String getString(int pos, int len) {
        return this.getString(false, pos, len);
    }

    public synchronized String getString(boolean useHighByte, int pos, int len) {
        if (pos == 0 && len == 0) {
            return new String();
        }
        if (!Blob.between(pos, 0, this.size - 1) || !Blob.between(pos + len * (useHighByte ? 2 : 1), 0, this.size)) {
            throw new IndexOutOfBoundsException();
        }
        StringBuffer ret = new StringBuffer(len);
        this.beginEnumeration(pos);
        int x = 0;
        while (x < len) {
            char c;
            if (useHighByte) {
                c = (char)(this.nextByte() << 8);
                c = (char)(c | this.nextByte());
            } else {
                c = (char)this.nextByte();
            }
            ret.append(c);
            ++x;
        }
        return ret.toString();
    }

    public synchronized Object clone() {
        return this.getBlob(0, this.size);
    }

    public synchronized Blob getBlob(int pos, int len) {
        return new Blob(this.getBytes(pos, len));
    }

    public synchronized Enumeration enumerateBytes(int pos) {
        if (!Blob.between(pos, 0, this.size - 1)) {
            throw new IndexOutOfBoundsException();
        }
        final int cep = this.seek(pos);
        final BlobNode cen = this.curr;
        return new Enumeration(){
            int currEnumerationPos;
            BlobNode currEnumerationNode;
            {
                this.currEnumerationPos = cep;
                this.currEnumerationNode = cen;
            }

            public synchronized boolean hasMoreElements() {
                return this.currEnumerationNode != null;
            }

            public synchronized Object nextElement() {
                if (this.currEnumerationNode == null) {
                    throw new NoSuchElementException("Past end of current Enumeration");
                }
                byte ret = this.currEnumerationNode.data[this.currEnumerationPos++];
                if (this.currEnumerationPos == this.currEnumerationNode.size) {
                    this.currEnumerationNode = this.currEnumerationNode.next;
                    this.currEnumerationPos = 0;
                }
                return new Byte(ret);
            }
        };
    }

    public synchronized void setByteAt(int pos, byte b) {
        if (!Blob.between(pos, 0, this.size - 1)) {
            throw new IndexOutOfBoundsException();
        }
        int currIndex = this.seek(pos);
        this.curr.data[currIndex] = b;
    }

    public synchronized int length() {
        return this.size;
    }

    public synchronized boolean equals(Object o) {
        if (o == null || !(o instanceof Blob)) {
            return false;
        }
        Blob b = (Blob)o;
        if (this.size != b.size) {
            return false;
        }
        this.beginEnumeration(0);
        b.beginEnumeration(0);
        while (this.hasMoreBytes()) {
            if (this.nextByte() == b.nextByte()) continue;
            return false;
        }
        return true;
    }

    public synchronized int indexOf(byte b) {
        return this.indexOf(b, 0);
    }

    public synchronized int indexOf(byte b, int pos) {
        if (!Blob.between(pos, 0, this.size - 1)) {
            throw new IndexOutOfBoundsException();
        }
        this.beginEnumeration(pos);
        int currentPos = pos;
        while (this.hasMoreBytes()) {
            if (this.nextByte() == b) {
                return currentPos;
            }
            ++currentPos;
        }
        return -1;
    }

    public synchronized int read(int len, InputStream in) throws IOException {
        int bytesRead;
        byte[] b = new byte[len];
        try {
            bytesRead = in.read(b);
        }
        catch (EOFException e) {
            return -1;
        }
        catch (IOException e) {
            throw (IOException)e.fillInStackTrace();
        }
        this.append(b, 0, bytesRead);
        return bytesRead;
    }

    public synchronized int read(InputStream in) throws IOException {
        byte[] b = new byte[this.nodeSize];
        int totalBytesRead = -1;
        while (true) {
            int bytesRead;
            try {
                bytesRead = in.read(b);
            }
            catch (EOFException e) {
                break;
            }
            catch (IOException e) {
                throw (IOException)e.fillInStackTrace();
            }
            if (bytesRead == -1) break;
            if (totalBytesRead == -1) {
                totalBytesRead = 0;
            }
            this.append(b, 0, bytesRead);
            totalBytesRead += bytesRead;
        }
        return totalBytesRead;
    }

    public synchronized int readLimiting(InputStream in, long max) throws IOException {
        byte[] b = new byte[this.nodeSize];
        int totalBytesRead = -1;
        while (true) {
            int bytesRead;
            try {
                bytesRead = in.read(b);
            }
            catch (EOFException e) {
                break;
            }
            catch (IOException e) {
                throw (IOException)e.fillInStackTrace();
            }
            if (bytesRead == -1) break;
            if (totalBytesRead == -1) {
                totalBytesRead = 0;
            }
            if ((long)totalBytesRead > max && bytesRead > 0) {
                totalBytesRead = -2;
                break;
            }
            this.append(b, 0, bytesRead);
            totalBytesRead += bytesRead;
        }
        return totalBytesRead;
    }

    public OutputStream outputStream() {
        return new OutputStream(){

            public void write(int b) {
                Blob.this.append((byte)b);
            }

            public void write(byte[] b) {
                Blob.this.append(b);
            }

            public void write(byte[] b, int off, int len) {
                Blob.this.append(b, off, len);
            }
        };
    }

    public InputStream inputStream() {
        return new InputStream(){
            private int m_pos = 0;

            public int read() throws IOException {
                int rv = -1;
                try {
                    rv = Blob.this.byteAt(this.m_pos);
                    if (rv < 0) {
                        rv = 256 + rv;
                    }
                    ++this.m_pos;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
                return rv;
            }

            public int available() {
                return Blob.this.size - this.m_pos;
            }
        };
    }

    public synchronized void write(OutputStream out) throws IOException {
        this.write(0, this.size, out);
    }

    public synchronized void write(int pos, int len, OutputStream out) throws IOException {
        if (!Blob.between(pos, 0, this.size - 1) || !Blob.between(pos + len, 0, this.size)) {
            throw new IndexOutOfBoundsException();
        }
        int bytesWritten = 0;
        int writeFromThis = 0;
        int currIndex = this.seek(pos);
        while (bytesWritten < len) {
            writeFromThis = Math.min(this.curr.size - currIndex, len - bytesWritten);
            out.write(this.curr.data, currIndex, writeFromThis);
            bytesWritten += writeFromThis;
            this.curr = this.curr.next;
            currIndex = 0;
        }
    }

    public synchronized long checksum() {
        long ret = 0L;
        long temp = 0L;
        long hold = 0L;
        int index = 0;
        if (this.size == 0) {
            return ret;
        }
        this.beginEnumeration(0);
        while (this.hasMoreBytes()) {
            temp = (long)this.nextByte() << 56 >>> 56;
            hold |= temp << 8 * (7 - index);
            if (++index != 8) continue;
            ret ^= hold;
            hold = 0L;
            index = 0;
        }
        if (index != 0) {
            ret ^= hold;
        }
        return ret;
    }

    public synchronized String toString() {
        return new String("Blob[length=" + this.size + ";checksum=" + Blob.toHex(this.checksum()) + "]");
    }

    public synchronized void printContents() {
        int x;
        char[] rep = new char[16];
        long cksum = this.checksum();
        PrintStream o = System.out;
        int currWidth = 86;
        String holdStr = "Blob: length = " + this.size + " -- Checksum = " + Blob.toHex(cksum) + " ";
        o.print(holdStr);
        o.println(Blob.strstr(currWidth - holdStr.length(), '-'));
        if (this.size == 0) {
            o.println(Blob.strstr(currWidth, '-'));
            return;
        }
        o.print("     0 | ");
        int bytesPast = 0;
        this.beginEnumeration(0);
        while (this.hasMoreBytes()) {
            byte b = this.nextByte();
            o.print(Blob.toHex(b));
            rep[bytesPast % 16] = Blob.between(b, 32, 126) ? (int)b : 46;
            if (++bytesPast % 16 == 0) {
                o.print("   <");
                x = 0;
                while (x < 16) {
                    o.print(rep[x]);
                    ++x;
                }
                o.println(">");
                if (!this.hasMoreBytes()) continue;
                holdStr = Integer.toString(bytesPast);
                o.print(Blob.spaces(6 - holdStr.length()));
                o.print(holdStr);
                o.print(" | ");
                continue;
            }
            if (bytesPast % 4 == 0) {
                o.print("   ");
                continue;
            }
            o.print(' ');
        }
        if (bytesPast % 16 != 0) {
            x = bytesPast % 16;
            while (x < 16) {
                o.print("  ");
                rep[x] = 32;
                if (x % 4 == 0) {
                    o.print("   ");
                } else {
                    o.print(' ');
                }
                ++x;
            }
            o.print("   <");
            x = 0;
            while (x < 16) {
                o.print(rep[x]);
                ++x;
            }
            o.println(">");
        }
        holdStr = "---------------" + Blob.strstr(String.valueOf(this.size).length(), '-') + "--- Checksum = " + Blob.toHex(cksum) + " ";
        o.print(holdStr);
        o.println(Blob.strstr(currWidth - holdStr.length(), '-'));
    }

    protected void appendNode(int newNodeSize) {
        this.tail = this.tail.next = new BlobNode(newNodeSize);
    }

    protected int seek(int pos) {
        if (!Blob.between(pos, 0, this.size - 1)) {
            throw new IndexOutOfBoundsException("Seek past end:pos=" + pos + "   " + "size=" + this.size);
        }
        int bytesPast = 0;
        this.curr = this.head;
        while (this.curr.size + bytesPast <= pos) {
            bytesPast += this.curr.size;
            this.curr = this.curr.next;
        }
        return pos - bytesPast;
    }

    protected BlobNode findBefore(BlobNode target) {
        if (target == this.head) {
            return null;
        }
        BlobNode bn = this.head;
        while (bn.next != target) {
            if (bn.next == null) {
                throw new NoSuchElementException("Couldn't find BlobNode");
            }
            bn = bn.next;
        }
        return bn;
    }

    protected synchronized void beginEnumeration(int pos) {
        this.enumerationNode = null;
        if (!Blob.between(pos, 0, this.size - 1)) {
            throw new IndexOutOfBoundsException();
        }
        this.enumerationPos = this.seek(pos);
        this.enumerationNode = this.curr;
    }

    protected synchronized boolean hasMoreBytes() {
        return this.enumerationNode != null;
    }

    protected synchronized byte nextByte() {
        if (this.enumerationNode == null) {
            throw new NoSuchElementException("Past end of current Enumeration");
        }
        byte ret = this.enumerationNode.data[this.enumerationPos++];
        if (this.enumerationPos == this.enumerationNode.size) {
            this.enumerationNode = this.enumerationNode.next;
            this.enumerationPos = 0;
        }
        return ret;
    }

    protected void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        byte[] a = this.getBytes();
        out.writeObject(a);
    }

    protected void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        byte[] a = (byte[])in.readObject();
        this.tail = this.head = new BlobNode(this.nodeSize, a, 0, a.length);
        this.size = a.length;
    }

    static {
        NODE_SIZE = 512;
    }
}

