/* "NETGEN", a netlist-specification tool for VLSI
   Copyright (C) 1989, 1990   Massimo A. Sivilotti
   Author's address: mass@csvax.cs.caltech.edu;
                     Caltech 256-80, Pasadena CA 91125.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation (any version).

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file copying.  If not, write to
the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

/* ccode.c  -- Output routines to write a cell as NETGEN embedded C code */

#include "config.h"

#include <stdio.h>
#include <stdarg.h>

#include "netgen.h"
#include "hash.h"
#include "objlist.h"
#include "netfile.h"
#include "print.h"

void ccodeCell(char *name)
{
  struct nlist *tp, *tp2;
  struct objlist *ob, *ob2;

  tp = LookupCell(name);
  if (tp == NULL) {
    Printf("No cell '%s' found.\n", name);
    return;
  }

  /* do NOT dump primitive cells */
  if (tp->class != CLASS_SUBCKT) return;

  /* check to see that all children have been dumped */
  for (ob = tp->cell; ob != NULL; ob = ob->next) {
    tp2 = LookupCell(ob->model.class);
    if ((tp2 != NULL) && !(tp2->dumped)) 
      ccodeCell(tp2->name);
  }

  /* print out header list */
  FlushString("CellDef(\"%s\", -1);\n", tp->name);
  for (ob = tp->cell; ob != NULL; ob = ob->next) {
    switch (ob->type) {
    case PORT: FlushString("   Port(\"%s\");\n", ob->name);
      break;
    case GLOBAL: FlushString("   Global(\"%s\");\n", ob->name);
      break;
    case UNIQUEGLOBAL: FlushString("   UniqueGlobal(\"%s\");\n", ob->name);
      break;
    default: break;
    }
  }

  /* now run through cell's contents, print instances */
  for (ob = tp->cell; ob != NULL; ob = ob->next) {
    if (ob->type == FIRSTPIN) {
      /* this is an instance, so print out a cell */
      FlushString("   Cell(\"%s\"", ob->model.class);
      ob2 = ob;
      do {
	FlushString(", \"%s\"", NodeAlias(tp, ob2));
	ob2 = ob2->next;
      } while ((ob2 != NULL) && (ob2->type > FIRSTPIN));
      FlushString(");\n");
    }
  }
  FlushString ("EndDef();\n\n");
  tp->dumped = 1;		/* set dumped flag */
}


void Ccode(char *name, char *filename)
{
  char FileName[500];

  if (filename == NULL || strlen(filename) == 0) 
    SetExtension(FileName, name, CCODE_EXTENSION);
  else 
    SetExtension(FileName, filename, CCODE_EXTENSION);

  if (!OpenFile(FileName, 80)) {
    Printf("Unable to open CCODE file %s\n", FileName);
    return;
  }
  ClearDumpedList();

  /* create top level call */
  if (LookupCell(name) != NULL) {
    FlushString("/* Cell: %s;  code generated by NETGEN */\n", name);
    ccodeCell(name);
  }

  CloseFile(FileName);
}




