/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.codec.language;

import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.StringEncoder;

public class RefinedSoundex
implements StringEncoder {
    public static final char[] US_ENGLISH_MAPPING = "01360240043788015936020505".toCharArray();
    public static final RefinedSoundex US_ENGLISH = new RefinedSoundex();
    private char[] soundexMapping;

    public RefinedSoundex() {
        this(US_ENGLISH_MAPPING);
    }

    public RefinedSoundex(char[] cArray) {
        this.soundexMapping = cArray;
    }

    public String soundex(String string) {
        if (null == string || string.length() == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        string = string.toUpperCase();
        stringBuffer.append(string.charAt(0));
        char c = '*';
        int n = 0;
        while (n < string.length()) {
            char c2 = this.getMappingCode(string.charAt(n));
            if (c2 != c) {
                if (c2 != '\u0000') {
                    stringBuffer.append(c2);
                }
                c = c2;
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public String encode(String string) throws EncoderException {
        return this.soundex(string);
    }

    public Object encode(Object object) throws EncoderException {
        if (!(object instanceof String)) {
            throw new EncoderException("Parameter supplied to RefinedSoundex encode is not of type java.lang.String");
        }
        String string = this.soundex((String)object);
        return string;
    }

    private char getMappingCode(char c) {
        if (!Character.isLetter(c)) {
            return '\u0000';
        }
        return this.soundexMapping[Character.toUpperCase(c) - 65];
    }
}

