/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2017 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * scale vary Abox v2- based on DarkBeams maths
 * @reference
 * http://www.fractalforums.com/mandelbulb-3d/custom-formulas-and-transforms-release-t17106/
 */

/* ### This file has been autogenerated. Remove this line, to prevent override. ### */

#ifndef DOUBLE_PRECISION
float4 TransfScaleVaryAboxV2Iteration(float4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	if (aux->i >= fractal->transformCommon.startIterations
			&& aux->i < fractal->transformCommon.stopIterations)
	{
		z *= aux->actualScale;
		aux->DE = mad(aux->DE, fabs(aux->actualScale), 1.0f);
		aux->r_dz *= fabs(aux->actualScale);

		float base = fractal->mandelbox.scale;
		float vary = (fabs(aux->actualScale) - fractal->transformCommon.offset1);

		if (fractal->transformCommon.functionEnabled)
		{
			aux->actualScale = mad((vary), fractal->mandelboxVary4D.scaleVary, base);
		}
		else if (fractal->transformCommon.functionEnabledBxFalse)
		{
			base = aux->actualScale;
			aux->actualScale = mad((vary), fractal->transformCommon.scale0, base);
		}

		else if (fractal->transformCommon.functionEnabledByFalse)
		{
			float base2 = mad((fabs(aux->actualScale) - fractal->transformCommon.offset1),
				fractal->mandelboxVary4D.scaleVary, base);

			aux->actualScale = mad((fabs(aux->actualScale) - fractal->transformCommon.offset1),
				fractal->transformCommon.scale0, base2);
		}

		else if (fractal->transformCommon.functionEnabledBzFalse)
		{

			base = aux->actualScale;
			float base2 = mad((fabs(aux->actualScale) - fractal->transformCommon.offset1),
				fractal->transformCommon.scale0, base);

			aux->actualScale = mad((fabs(aux->actualScale) - fractal->transformCommon.offset1),
				fractal->mandelboxVary4D.scaleVary, base2);
		}
	}
	else
	{
		z *= fractal->mandelbox.scale;
		aux->DE = mad(aux->DE, fabs(fractal->mandelbox.scale), 1.0f);
		aux->r_dz *= fabs(fractal->mandelbox.scale);
	}

	/*	if (aux->i >= fractal->transformCommon.startIterations
				&& aux->i < fractal->transformCommon.stopIterations)
		{
			z *= aux->actualScale;
			aux->DE = mad(aux->DE, fabs(aux->actualScale), 1.0f);
			aux->r_dz *= fabs(aux->actualScale);
			aux->actualScale =
				mad((fabs(aux->actualScale) - 1.0f), fractal->mandelboxVary4D.scaleVary,
		fractal->mandelbox.scale);
		}
		else
		{
			z *= fractal->mandelbox.scale;
			aux->DE = mad(aux->DE, fabs(fractal->mandelbox.scale), 1.0f);
			aux->r_dz *= fabs(fractal->mandelbox.scale);
		}*/
	return z;
}
#else
double4 TransfScaleVaryAboxV2Iteration(
	double4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	if (aux->i >= fractal->transformCommon.startIterations
			&& aux->i < fractal->transformCommon.stopIterations)
	{
		z *= aux->actualScale;
		aux->DE = aux->DE * fabs(aux->actualScale) + 1.0;
		aux->r_dz *= fabs(aux->actualScale);

		double base = fractal->mandelbox.scale;
		double vary = (fabs(aux->actualScale) - fractal->transformCommon.offset1);

		if (fractal->transformCommon.functionEnabled)
		{
			aux->actualScale = mad((vary), fractal->mandelboxVary4D.scaleVary, base);
		}
		else if (fractal->transformCommon.functionEnabledBxFalse)
		{
			base = aux->actualScale;
			aux->actualScale = mad((vary), fractal->transformCommon.scale0, base);
		}

		else if (fractal->transformCommon.functionEnabledByFalse)
		{
			double base2 = mad((fabs(aux->actualScale) - fractal->transformCommon.offset1),
				fractal->mandelboxVary4D.scaleVary, base);

			aux->actualScale = mad((fabs(aux->actualScale) - fractal->transformCommon.offset1),
				fractal->transformCommon.scale0, base2);
		}

		else if (fractal->transformCommon.functionEnabledBzFalse)
		{

			base = aux->actualScale;
			double base2 = mad((fabs(aux->actualScale) - fractal->transformCommon.offset1),
				fractal->transformCommon.scale0, base);

			aux->actualScale = mad((fabs(aux->actualScale) - fractal->transformCommon.offset1),
				fractal->mandelboxVary4D.scaleVary, base2);
		}
	}
	else
	{
		z *= fractal->mandelbox.scale;
		aux->DE = aux->DE * fabs(fractal->mandelbox.scale) + 1.0;
		aux->r_dz *= fabs(fractal->mandelbox.scale);
	}

	/*	if (aux->i >= fractal->transformCommon.startIterations
				&& aux->i < fractal->transformCommon.stopIterations)
		{
			z *= aux->actualScale;
			aux->DE = aux->DE * fabs(aux->actualScale) + 1.0;
			aux->r_dz *= fabs(aux->actualScale);
			aux->actualScale =
				mad((fabs(aux->actualScale) - 1.0), fractal->mandelboxVary4D.scaleVary,
		fractal->mandelbox.scale);
		}
		else
		{
			z *= fractal->mandelbox.scale;
			aux->DE = aux->DE * fabs(fractal->mandelbox.scale) + 1.0;
			aux->r_dz *= fabs(fractal->mandelbox.scale);
		}*/
	return z;
}
#endif
