/*
 * libexplain - Explain errno values returned by libc functions
 * Copyright (C) 2010, 2013 Peter Miller
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#include <libexplain/ac/errno.h>
#include <libexplain/ac/stdio.h>

#include <libexplain/buffer/errno/printf.h>
#include <libexplain/common_message_buffer.h>
#include <libexplain/printf.h>


const char *
explain_printf(const char *format, ...)
{
    int             errnum;
    va_list         ap;
    explain_string_buffer_t sb;

    va_start(ap, format);
    errnum = errno;
    explain_string_buffer_init
    (
        &sb,
        explain_common_message_buffer,
        explain_common_message_buffer_size
    );
    explain_buffer_errno_printf(&sb, errnum, format, ap);
    va_end(ap);
    return explain_common_message_buffer;
}


const char *
explain_errno_printf(int errnum, const char *format, ...)
{
    va_list         ap;
    explain_string_buffer_t sb;

    va_start(ap, format);
    explain_string_buffer_init
    (
        &sb,
        explain_common_message_buffer,
        explain_common_message_buffer_size
    );
    explain_buffer_errno_printf(&sb, errnum, format, ap);
    va_end(ap);
    return explain_common_message_buffer;
}


void
explain_message_printf(char *message, int message_size, const char *format, ...)
{
    int             errnum;
    va_list         ap;
    explain_string_buffer_t sb;

    va_start(ap, format);
    errnum = errno;
    explain_string_buffer_init(&sb, message, message_size);
    explain_buffer_errno_printf(&sb, errnum, format, ap);
    va_end(ap);
}


void
explain_message_errno_printf(char *message, int message_size, int errnum,
    const char *format, ...)
{
    va_list         ap;
    explain_string_buffer_t sb;

    va_start(ap, format);
    explain_string_buffer_init(&sb, message, message_size);
    explain_buffer_errno_printf(&sb, errnum, format, ap);
    va_end(ap);
}


/* vim: set ts=8 sw=4 et : */
