## API Report File for "@lumino/polling"

> Do not edit this file. It is a report generated by [API Extractor](https://api-extractor.com/).

```ts

import { IDisposable } from '@lumino/disposable';
import { IObservableDisposable } from '@lumino/disposable';
import { ISignal } from '@lumino/signaling';
import { PromiseDelegate } from '@lumino/coreutils';

// @public
export class Debouncer<T = any, U = any> extends RateLimiter<T, U> {
    invoke(): Promise<T>;
}

// @public
export interface IPoll<T, U, V extends string> {
    readonly disposed: ISignal<this, void>;
    readonly frequency: IPoll.Frequency;
    readonly isDisposed: boolean;
    readonly name: string;
    readonly state: IPoll.State<T, U, V>;
    readonly tick: Promise<IPoll<T, U, V>>;
    readonly ticked: ISignal<IPoll<T, U, V>, IPoll.State<T, U, V>>;
}

// @public
export namespace IPoll {
    export type Frequency = {
        readonly backoff: boolean | number;
        readonly interval: number;
        readonly max: number;
    };
    export type Phase<T extends string> = T | 'constructed' | 'disposed' | 'reconnected' | 'refreshed' | 'rejected' | 'resolved' | 'standby' | 'started' | 'stopped';
    export type State<T, U, V extends string> = {
        readonly interval: number;
        readonly payload: T | U | null;
        readonly phase: Phase<V>;
        readonly timestamp: number;
    };
}

// @public
export interface IRateLimiter<T = any, U = any> extends IDisposable {
    invoke(): Promise<T>;
    readonly limit: number;
    stop(): Promise<void>;
}

// @public
export class Poll<T = any, U = any, V extends string = 'standby'> implements IObservableDisposable, IPoll<T, U, V> {
    constructor(options: Poll.IOptions<T, U, V>);
    dispose(): void;
    readonly disposed: ISignal<this, void>;
    frequency: IPoll.Frequency;
    readonly isDisposed: boolean;
    readonly name: string;
    refresh(): Promise<void>;
    schedule(next?: Partial<IPoll.State<T, U, V> & {
        cancel: (last: IPoll.State<T, U, V>) => boolean;
    }>): Promise<void>;
    standby: Poll.Standby | (() => boolean | Poll.Standby);
    start(): Promise<void>;
    readonly state: IPoll.State<T, U, V>;
    stop(): Promise<void>;
    readonly tick: Promise<this>;
    readonly ticked: ISignal<this, IPoll.State<T, U, V>>;
    }

// @public
export namespace Poll {
    export type Factory<T, U, V extends string> = (state: IPoll.State<T, U, V>) => Promise<T>;
    export interface IOptions<T, U, V extends string> {
        auto?: boolean;
        factory: Factory<T, U, V>;
        frequency?: Partial<IPoll.Frequency>;
        name?: string;
        standby?: Standby | (() => boolean | Standby);
    }
    export type Standby = 'never' | 'when-hidden';
    const IMMEDIATE = 0;
    const MAX_INTERVAL = 2147483647;
    const NEVER: number;
}

// @public
export abstract class RateLimiter<T, U> implements IRateLimiter<T, U> {
    constructor(fn: () => T | Promise<T>, limit?: number);
    dispose(): void;
    abstract invoke(): Promise<T>;
    readonly isDisposed: boolean;
    readonly limit: number;
    protected payload: PromiseDelegate<T> | null;
    protected poll: Poll<T, U, 'invoked'>;
    stop(): Promise<void>;
}

// @public
export class Throttler<T = any, U = any> extends RateLimiter<T, U> {
    invoke(): Promise<T>;
}


// (No @packageDocumentation comment for this package)

```
