; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx | FileCheck %s --check-prefixes=ALL,AVX,AVX1,AVX1-FALLBACK
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2 | FileCheck %s --check-prefixes=ALL,AVX,AVX2,AVX2-FALLBACK
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+xop | FileCheck %s --check-prefixes=ALL,XOP,XOP-FALLBACK
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+xop,+avx | FileCheck %s --check-prefixes=ALL,XOP,AVX,AVX1,XOPAVX,XOPAVX1,XOPAVX1-FALLBACK
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+xop,+avx2 | FileCheck %s --check-prefixes=ALL,XOP,AVX,AVX2,XOPAVX,XOPAVX2,XOPAVX2-FALLBACK
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f | FileCheck %s --check-prefixes=ALL,AVX512,AVX512F
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f,+avx512vl | FileCheck %s --check-prefixes=ALL,AVX512,AVX512VL,AVX512VL-FALLBACK
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f,+avx512bw | FileCheck %s --check-prefixes=ALL,AVX512,AVX512BW,AVX512BW-FALLBACK
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f,+avx512vl,+avx512bw | FileCheck %s --check-prefixes=ALL,AVX512,AVX512VL,AVX512BW,AVX512VLBW

; These test cases are inspired by C++2a std::midpoint().
; See https://bugs.llvm.org/show_bug.cgi?id=40965

; Using 256-bit vector regs.

; ---------------------------------------------------------------------------- ;
; 32-bit width. 256 / 32 = 8 elts.
; ---------------------------------------------------------------------------- ;

; Values come from regs

define <8 x i32> @vec256_i32_signed_reg_reg(<8 x i32> %a1, <8 x i32> %a2) nounwind {
; AVX1-FALLBACK-LABEL: vec256_i32_signed_reg_reg:
; AVX1-FALLBACK:       # %bb.0:
; AVX1-FALLBACK-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-FALLBACK-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-FALLBACK-NEXT:    vpminsd %xmm2, %xmm3, %xmm4
; AVX1-FALLBACK-NEXT:    vpminsd %xmm1, %xmm0, %xmm5
; AVX1-FALLBACK-NEXT:    vpmaxsd %xmm2, %xmm3, %xmm2
; AVX1-FALLBACK-NEXT:    vpsubd %xmm4, %xmm2, %xmm2
; AVX1-FALLBACK-NEXT:    vpmaxsd %xmm1, %xmm0, %xmm1
; AVX1-FALLBACK-NEXT:    vpsubd %xmm5, %xmm1, %xmm1
; AVX1-FALLBACK-NEXT:    vpsrld $1, %xmm2, %xmm2
; AVX1-FALLBACK-NEXT:    vpsrld $1, %xmm1, %xmm1
; AVX1-FALLBACK-NEXT:    vpmulld %xmm1, %xmm1, %xmm1
; AVX1-FALLBACK-NEXT:    vpmulld %xmm2, %xmm2, %xmm2
; AVX1-FALLBACK-NEXT:    vpaddd %xmm3, %xmm2, %xmm2
; AVX1-FALLBACK-NEXT:    vpaddd %xmm0, %xmm1, %xmm0
; AVX1-FALLBACK-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-FALLBACK-NEXT:    retq
;
; AVX2-LABEL: vec256_i32_signed_reg_reg:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpminsd %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vpmaxsd %ymm1, %ymm0, %ymm1
; AVX2-NEXT:    vpsubd %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpsrld $1, %ymm1, %ymm1
; AVX2-NEXT:    vpmulld %ymm1, %ymm1, %ymm1
; AVX2-NEXT:    vpaddd %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; XOP-FALLBACK-LABEL: vec256_i32_signed_reg_reg:
; XOP-FALLBACK:       # %bb.0:
; XOP-FALLBACK-NEXT:    vpminsd %xmm1, %xmm0, %xmm2
; XOP-FALLBACK-NEXT:    vextractf128 $1, %ymm1, %xmm3
; XOP-FALLBACK-NEXT:    vextractf128 $1, %ymm0, %xmm4
; XOP-FALLBACK-NEXT:    vpminsd %xmm3, %xmm4, %xmm5
; XOP-FALLBACK-NEXT:    vpmaxsd %xmm1, %xmm0, %xmm1
; XOP-FALLBACK-NEXT:    vpsubd %xmm2, %xmm1, %xmm1
; XOP-FALLBACK-NEXT:    vpmaxsd %xmm3, %xmm4, %xmm2
; XOP-FALLBACK-NEXT:    vpsubd %xmm5, %xmm2, %xmm2
; XOP-FALLBACK-NEXT:    vpsrld $1, %xmm1, %xmm1
; XOP-FALLBACK-NEXT:    vpsrld $1, %xmm2, %xmm2
; XOP-FALLBACK-NEXT:    vpmacsdd %xmm4, %xmm2, %xmm2, %xmm2
; XOP-FALLBACK-NEXT:    vpmacsdd %xmm0, %xmm1, %xmm1, %xmm0
; XOP-FALLBACK-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOP-FALLBACK-NEXT:    retq
;
; XOPAVX1-LABEL: vec256_i32_signed_reg_reg:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vpminsd %xmm1, %xmm0, %xmm2
; XOPAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm4
; XOPAVX1-NEXT:    vpminsd %xmm3, %xmm4, %xmm5
; XOPAVX1-NEXT:    vpmaxsd %xmm1, %xmm0, %xmm1
; XOPAVX1-NEXT:    vpsubd %xmm2, %xmm1, %xmm1
; XOPAVX1-NEXT:    vpmaxsd %xmm3, %xmm4, %xmm2
; XOPAVX1-NEXT:    vpsubd %xmm5, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpsrld $1, %xmm1, %xmm1
; XOPAVX1-NEXT:    vpsrld $1, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpmacsdd %xmm4, %xmm2, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpmacsdd %xmm0, %xmm1, %xmm1, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOPAVX1-NEXT:    retq
;
; AVX512-LABEL: vec256_i32_signed_reg_reg:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpminsd %ymm1, %ymm0, %ymm2
; AVX512-NEXT:    vpmaxsd %ymm1, %ymm0, %ymm1
; AVX512-NEXT:    vpsubd %ymm2, %ymm1, %ymm1
; AVX512-NEXT:    vpsrld $1, %ymm1, %ymm1
; AVX512-NEXT:    vpmulld %ymm1, %ymm1, %ymm1
; AVX512-NEXT:    vpaddd %ymm0, %ymm1, %ymm0
; AVX512-NEXT:    retq
  %t3 = icmp sgt <8 x i32> %a1, %a2 ; signed
  %t4 = select <8 x i1> %t3, <8 x i32> <i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1>, <8 x i32> <i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1>
  %t5 = select <8 x i1> %t3, <8 x i32> %a2, <8 x i32> %a1
  %t6 = select <8 x i1> %t3, <8 x i32> %a1, <8 x i32> %a2
  %t7 = sub <8 x i32> %t6, %t5
  %t8 = lshr <8 x i32> %t7, <i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1>
  %t9 = mul nsw <8 x i32> %t8, %t8 ; signed
  %a10 = add nsw <8 x i32> %t9, %a1 ; signed
  ret <8 x i32> %a10
}

define <8 x i32> @vec256_i32_unsigned_reg_reg(<8 x i32> %a1, <8 x i32> %a2) nounwind {
; AVX1-FALLBACK-LABEL: vec256_i32_unsigned_reg_reg:
; AVX1-FALLBACK:       # %bb.0:
; AVX1-FALLBACK-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-FALLBACK-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-FALLBACK-NEXT:    vpminud %xmm2, %xmm3, %xmm4
; AVX1-FALLBACK-NEXT:    vpminud %xmm1, %xmm0, %xmm5
; AVX1-FALLBACK-NEXT:    vpmaxud %xmm2, %xmm3, %xmm2
; AVX1-FALLBACK-NEXT:    vpsubd %xmm4, %xmm2, %xmm2
; AVX1-FALLBACK-NEXT:    vpmaxud %xmm1, %xmm0, %xmm1
; AVX1-FALLBACK-NEXT:    vpsubd %xmm5, %xmm1, %xmm1
; AVX1-FALLBACK-NEXT:    vpsrld $1, %xmm2, %xmm2
; AVX1-FALLBACK-NEXT:    vpsrld $1, %xmm1, %xmm1
; AVX1-FALLBACK-NEXT:    vpmulld %xmm1, %xmm1, %xmm1
; AVX1-FALLBACK-NEXT:    vpmulld %xmm2, %xmm2, %xmm2
; AVX1-FALLBACK-NEXT:    vpaddd %xmm3, %xmm2, %xmm2
; AVX1-FALLBACK-NEXT:    vpaddd %xmm0, %xmm1, %xmm0
; AVX1-FALLBACK-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-FALLBACK-NEXT:    retq
;
; AVX2-LABEL: vec256_i32_unsigned_reg_reg:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpminud %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vpmaxud %ymm1, %ymm0, %ymm1
; AVX2-NEXT:    vpsubd %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpsrld $1, %ymm1, %ymm1
; AVX2-NEXT:    vpmulld %ymm1, %ymm1, %ymm1
; AVX2-NEXT:    vpaddd %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; XOP-FALLBACK-LABEL: vec256_i32_unsigned_reg_reg:
; XOP-FALLBACK:       # %bb.0:
; XOP-FALLBACK-NEXT:    vpminud %xmm1, %xmm0, %xmm2
; XOP-FALLBACK-NEXT:    vextractf128 $1, %ymm1, %xmm3
; XOP-FALLBACK-NEXT:    vextractf128 $1, %ymm0, %xmm4
; XOP-FALLBACK-NEXT:    vpminud %xmm3, %xmm4, %xmm5
; XOP-FALLBACK-NEXT:    vpmaxud %xmm1, %xmm0, %xmm1
; XOP-FALLBACK-NEXT:    vpsubd %xmm2, %xmm1, %xmm1
; XOP-FALLBACK-NEXT:    vpmaxud %xmm3, %xmm4, %xmm2
; XOP-FALLBACK-NEXT:    vpsubd %xmm5, %xmm2, %xmm2
; XOP-FALLBACK-NEXT:    vpsrld $1, %xmm1, %xmm1
; XOP-FALLBACK-NEXT:    vpsrld $1, %xmm2, %xmm2
; XOP-FALLBACK-NEXT:    vpmacsdd %xmm4, %xmm2, %xmm2, %xmm2
; XOP-FALLBACK-NEXT:    vpmacsdd %xmm0, %xmm1, %xmm1, %xmm0
; XOP-FALLBACK-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOP-FALLBACK-NEXT:    retq
;
; XOPAVX1-LABEL: vec256_i32_unsigned_reg_reg:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vpminud %xmm1, %xmm0, %xmm2
; XOPAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm4
; XOPAVX1-NEXT:    vpminud %xmm3, %xmm4, %xmm5
; XOPAVX1-NEXT:    vpmaxud %xmm1, %xmm0, %xmm1
; XOPAVX1-NEXT:    vpsubd %xmm2, %xmm1, %xmm1
; XOPAVX1-NEXT:    vpmaxud %xmm3, %xmm4, %xmm2
; XOPAVX1-NEXT:    vpsubd %xmm5, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpsrld $1, %xmm1, %xmm1
; XOPAVX1-NEXT:    vpsrld $1, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpmacsdd %xmm4, %xmm2, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpmacsdd %xmm0, %xmm1, %xmm1, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOPAVX1-NEXT:    retq
;
; AVX512-LABEL: vec256_i32_unsigned_reg_reg:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpminud %ymm1, %ymm0, %ymm2
; AVX512-NEXT:    vpmaxud %ymm1, %ymm0, %ymm1
; AVX512-NEXT:    vpsubd %ymm2, %ymm1, %ymm1
; AVX512-NEXT:    vpsrld $1, %ymm1, %ymm1
; AVX512-NEXT:    vpmulld %ymm1, %ymm1, %ymm1
; AVX512-NEXT:    vpaddd %ymm0, %ymm1, %ymm0
; AVX512-NEXT:    retq
  %t3 = icmp ugt <8 x i32> %a1, %a2
  %t4 = select <8 x i1> %t3, <8 x i32> <i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1>, <8 x i32> <i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1>
  %t5 = select <8 x i1> %t3, <8 x i32> %a2, <8 x i32> %a1
  %t6 = select <8 x i1> %t3, <8 x i32> %a1, <8 x i32> %a2
  %t7 = sub <8 x i32> %t6, %t5
  %t8 = lshr <8 x i32> %t7, <i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1>
  %t9 = mul <8 x i32> %t8, %t8
  %a10 = add <8 x i32> %t9, %a1
  ret <8 x i32> %a10
}

; Values are loaded. Only check signed case.

define <8 x i32> @vec256_i32_signed_mem_reg(<8 x i32>* %a1_addr, <8 x i32> %a2) nounwind {
; AVX1-FALLBACK-LABEL: vec256_i32_signed_mem_reg:
; AVX1-FALLBACK:       # %bb.0:
; AVX1-FALLBACK-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-FALLBACK-NEXT:    vmovdqa (%rdi), %xmm2
; AVX1-FALLBACK-NEXT:    vmovdqa 16(%rdi), %xmm3
; AVX1-FALLBACK-NEXT:    vpminsd %xmm1, %xmm3, %xmm4
; AVX1-FALLBACK-NEXT:    vpminsd %xmm0, %xmm2, %xmm5
; AVX1-FALLBACK-NEXT:    vpmaxsd %xmm1, %xmm3, %xmm1
; AVX1-FALLBACK-NEXT:    vpsubd %xmm4, %xmm1, %xmm1
; AVX1-FALLBACK-NEXT:    vpmaxsd %xmm0, %xmm2, %xmm0
; AVX1-FALLBACK-NEXT:    vpsubd %xmm5, %xmm0, %xmm0
; AVX1-FALLBACK-NEXT:    vpsrld $1, %xmm1, %xmm1
; AVX1-FALLBACK-NEXT:    vpsrld $1, %xmm0, %xmm0
; AVX1-FALLBACK-NEXT:    vpmulld %xmm0, %xmm0, %xmm0
; AVX1-FALLBACK-NEXT:    vpmulld %xmm1, %xmm1, %xmm1
; AVX1-FALLBACK-NEXT:    vpaddd %xmm3, %xmm1, %xmm1
; AVX1-FALLBACK-NEXT:    vpaddd %xmm2, %xmm0, %xmm0
; AVX1-FALLBACK-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-FALLBACK-NEXT:    retq
;
; AVX2-LABEL: vec256_i32_signed_mem_reg:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %ymm1
; AVX2-NEXT:    vpminsd %ymm0, %ymm1, %ymm2
; AVX2-NEXT:    vpmaxsd %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpsubd %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsrld $1, %ymm0, %ymm0
; AVX2-NEXT:    vpmulld %ymm0, %ymm0, %ymm0
; AVX2-NEXT:    vpaddd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; XOP-FALLBACK-LABEL: vec256_i32_signed_mem_reg:
; XOP-FALLBACK:       # %bb.0:
; XOP-FALLBACK-NEXT:    vmovdqa (%rdi), %xmm1
; XOP-FALLBACK-NEXT:    vmovdqa 16(%rdi), %xmm2
; XOP-FALLBACK-NEXT:    vpminsd %xmm0, %xmm1, %xmm3
; XOP-FALLBACK-NEXT:    vextractf128 $1, %ymm0, %xmm4
; XOP-FALLBACK-NEXT:    vpminsd %xmm4, %xmm2, %xmm5
; XOP-FALLBACK-NEXT:    vpmaxsd %xmm0, %xmm1, %xmm0
; XOP-FALLBACK-NEXT:    vpsubd %xmm3, %xmm0, %xmm0
; XOP-FALLBACK-NEXT:    vpmaxsd %xmm4, %xmm2, %xmm3
; XOP-FALLBACK-NEXT:    vpsubd %xmm5, %xmm3, %xmm3
; XOP-FALLBACK-NEXT:    vpsrld $1, %xmm0, %xmm0
; XOP-FALLBACK-NEXT:    vpsrld $1, %xmm3, %xmm3
; XOP-FALLBACK-NEXT:    vpmacsdd %xmm2, %xmm3, %xmm3, %xmm2
; XOP-FALLBACK-NEXT:    vpmacsdd %xmm1, %xmm0, %xmm0, %xmm0
; XOP-FALLBACK-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOP-FALLBACK-NEXT:    retq
;
; XOPAVX1-LABEL: vec256_i32_signed_mem_reg:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vmovdqa (%rdi), %xmm1
; XOPAVX1-NEXT:    vmovdqa 16(%rdi), %xmm2
; XOPAVX1-NEXT:    vpminsd %xmm0, %xmm1, %xmm3
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm4
; XOPAVX1-NEXT:    vpminsd %xmm4, %xmm2, %xmm5
; XOPAVX1-NEXT:    vpmaxsd %xmm0, %xmm1, %xmm0
; XOPAVX1-NEXT:    vpsubd %xmm3, %xmm0, %xmm0
; XOPAVX1-NEXT:    vpmaxsd %xmm4, %xmm2, %xmm3
; XOPAVX1-NEXT:    vpsubd %xmm5, %xmm3, %xmm3
; XOPAVX1-NEXT:    vpsrld $1, %xmm0, %xmm0
; XOPAVX1-NEXT:    vpsrld $1, %xmm3, %xmm3
; XOPAVX1-NEXT:    vpmacsdd %xmm2, %xmm3, %xmm3, %xmm2
; XOPAVX1-NEXT:    vpmacsdd %xmm1, %xmm0, %xmm0, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOPAVX1-NEXT:    retq
;
; AVX512-LABEL: vec256_i32_signed_mem_reg:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa (%rdi), %ymm1
; AVX512-NEXT:    vpminsd %ymm0, %ymm1, %ymm2
; AVX512-NEXT:    vpmaxsd %ymm0, %ymm1, %ymm0
; AVX512-NEXT:    vpsubd %ymm2, %ymm0, %ymm0
; AVX512-NEXT:    vpsrld $1, %ymm0, %ymm0
; AVX512-NEXT:    vpmulld %ymm0, %ymm0, %ymm0
; AVX512-NEXT:    vpaddd %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    retq
  %a1 = load <8 x i32>, <8 x i32>* %a1_addr
  %t3 = icmp sgt <8 x i32> %a1, %a2 ; signed
  %t4 = select <8 x i1> %t3, <8 x i32> <i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1>, <8 x i32> <i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1>
  %t5 = select <8 x i1> %t3, <8 x i32> %a2, <8 x i32> %a1
  %t6 = select <8 x i1> %t3, <8 x i32> %a1, <8 x i32> %a2
  %t7 = sub <8 x i32> %t6, %t5
  %t8 = lshr <8 x i32> %t7, <i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1>
  %t9 = mul nsw <8 x i32> %t8, %t8 ; signed
  %a10 = add nsw <8 x i32> %t9, %a1 ; signed
  ret <8 x i32> %a10
}

define <8 x i32> @vec256_i32_signed_reg_mem(<8 x i32> %a1, <8 x i32>* %a2_addr) nounwind {
; AVX1-FALLBACK-LABEL: vec256_i32_signed_reg_mem:
; AVX1-FALLBACK:       # %bb.0:
; AVX1-FALLBACK-NEXT:    vmovdqa (%rdi), %xmm1
; AVX1-FALLBACK-NEXT:    vmovdqa 16(%rdi), %xmm2
; AVX1-FALLBACK-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-FALLBACK-NEXT:    vpminsd %xmm2, %xmm3, %xmm4
; AVX1-FALLBACK-NEXT:    vpminsd %xmm1, %xmm0, %xmm5
; AVX1-FALLBACK-NEXT:    vpmaxsd %xmm2, %xmm3, %xmm2
; AVX1-FALLBACK-NEXT:    vpsubd %xmm4, %xmm2, %xmm2
; AVX1-FALLBACK-NEXT:    vpmaxsd %xmm1, %xmm0, %xmm1
; AVX1-FALLBACK-NEXT:    vpsubd %xmm5, %xmm1, %xmm1
; AVX1-FALLBACK-NEXT:    vpsrld $1, %xmm2, %xmm2
; AVX1-FALLBACK-NEXT:    vpsrld $1, %xmm1, %xmm1
; AVX1-FALLBACK-NEXT:    vpmulld %xmm1, %xmm1, %xmm1
; AVX1-FALLBACK-NEXT:    vpmulld %xmm2, %xmm2, %xmm2
; AVX1-FALLBACK-NEXT:    vpaddd %xmm3, %xmm2, %xmm2
; AVX1-FALLBACK-NEXT:    vpaddd %xmm0, %xmm1, %xmm0
; AVX1-FALLBACK-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-FALLBACK-NEXT:    retq
;
; AVX2-LABEL: vec256_i32_signed_reg_mem:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %ymm1
; AVX2-NEXT:    vpminsd %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vpmaxsd %ymm1, %ymm0, %ymm1
; AVX2-NEXT:    vpsubd %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpsrld $1, %ymm1, %ymm1
; AVX2-NEXT:    vpmulld %ymm1, %ymm1, %ymm1
; AVX2-NEXT:    vpaddd %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; XOP-FALLBACK-LABEL: vec256_i32_signed_reg_mem:
; XOP-FALLBACK:       # %bb.0:
; XOP-FALLBACK-NEXT:    vmovdqa (%rdi), %xmm1
; XOP-FALLBACK-NEXT:    vmovdqa 16(%rdi), %xmm2
; XOP-FALLBACK-NEXT:    vpminsd %xmm1, %xmm0, %xmm3
; XOP-FALLBACK-NEXT:    vextractf128 $1, %ymm0, %xmm4
; XOP-FALLBACK-NEXT:    vpminsd %xmm2, %xmm4, %xmm5
; XOP-FALLBACK-NEXT:    vpmaxsd %xmm1, %xmm0, %xmm1
; XOP-FALLBACK-NEXT:    vpsubd %xmm3, %xmm1, %xmm1
; XOP-FALLBACK-NEXT:    vpmaxsd %xmm2, %xmm4, %xmm2
; XOP-FALLBACK-NEXT:    vpsubd %xmm5, %xmm2, %xmm2
; XOP-FALLBACK-NEXT:    vpsrld $1, %xmm1, %xmm1
; XOP-FALLBACK-NEXT:    vpsrld $1, %xmm2, %xmm2
; XOP-FALLBACK-NEXT:    vpmacsdd %xmm4, %xmm2, %xmm2, %xmm2
; XOP-FALLBACK-NEXT:    vpmacsdd %xmm0, %xmm1, %xmm1, %xmm0
; XOP-FALLBACK-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOP-FALLBACK-NEXT:    retq
;
; XOPAVX1-LABEL: vec256_i32_signed_reg_mem:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vmovdqa (%rdi), %xmm1
; XOPAVX1-NEXT:    vmovdqa 16(%rdi), %xmm2
; XOPAVX1-NEXT:    vpminsd %xmm1, %xmm0, %xmm3
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm4
; XOPAVX1-NEXT:    vpminsd %xmm2, %xmm4, %xmm5
; XOPAVX1-NEXT:    vpmaxsd %xmm1, %xmm0, %xmm1
; XOPAVX1-NEXT:    vpsubd %xmm3, %xmm1, %xmm1
; XOPAVX1-NEXT:    vpmaxsd %xmm2, %xmm4, %xmm2
; XOPAVX1-NEXT:    vpsubd %xmm5, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpsrld $1, %xmm1, %xmm1
; XOPAVX1-NEXT:    vpsrld $1, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpmacsdd %xmm4, %xmm2, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpmacsdd %xmm0, %xmm1, %xmm1, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOPAVX1-NEXT:    retq
;
; AVX512-LABEL: vec256_i32_signed_reg_mem:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa (%rdi), %ymm1
; AVX512-NEXT:    vpminsd %ymm1, %ymm0, %ymm2
; AVX512-NEXT:    vpmaxsd %ymm1, %ymm0, %ymm1
; AVX512-NEXT:    vpsubd %ymm2, %ymm1, %ymm1
; AVX512-NEXT:    vpsrld $1, %ymm1, %ymm1
; AVX512-NEXT:    vpmulld %ymm1, %ymm1, %ymm1
; AVX512-NEXT:    vpaddd %ymm0, %ymm1, %ymm0
; AVX512-NEXT:    retq
  %a2 = load <8 x i32>, <8 x i32>* %a2_addr
  %t3 = icmp sgt <8 x i32> %a1, %a2 ; signed
  %t4 = select <8 x i1> %t3, <8 x i32> <i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1>, <8 x i32> <i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1>
  %t5 = select <8 x i1> %t3, <8 x i32> %a2, <8 x i32> %a1
  %t6 = select <8 x i1> %t3, <8 x i32> %a1, <8 x i32> %a2
  %t7 = sub <8 x i32> %t6, %t5
  %t8 = lshr <8 x i32> %t7, <i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1>
  %t9 = mul nsw <8 x i32> %t8, %t8 ; signed
  %a10 = add nsw <8 x i32> %t9, %a1 ; signed
  ret <8 x i32> %a10
}

define <8 x i32> @vec256_i32_signed_mem_mem(<8 x i32>* %a1_addr, <8 x i32>* %a2_addr) nounwind {
; AVX1-FALLBACK-LABEL: vec256_i32_signed_mem_mem:
; AVX1-FALLBACK:       # %bb.0:
; AVX1-FALLBACK-NEXT:    vmovdqa (%rsi), %xmm0
; AVX1-FALLBACK-NEXT:    vmovdqa 16(%rsi), %xmm1
; AVX1-FALLBACK-NEXT:    vmovdqa (%rdi), %xmm2
; AVX1-FALLBACK-NEXT:    vmovdqa 16(%rdi), %xmm3
; AVX1-FALLBACK-NEXT:    vpminsd %xmm1, %xmm3, %xmm4
; AVX1-FALLBACK-NEXT:    vpminsd %xmm0, %xmm2, %xmm5
; AVX1-FALLBACK-NEXT:    vpmaxsd %xmm1, %xmm3, %xmm1
; AVX1-FALLBACK-NEXT:    vpsubd %xmm4, %xmm1, %xmm1
; AVX1-FALLBACK-NEXT:    vpmaxsd %xmm0, %xmm2, %xmm0
; AVX1-FALLBACK-NEXT:    vpsubd %xmm5, %xmm0, %xmm0
; AVX1-FALLBACK-NEXT:    vpsrld $1, %xmm1, %xmm1
; AVX1-FALLBACK-NEXT:    vpsrld $1, %xmm0, %xmm0
; AVX1-FALLBACK-NEXT:    vpmulld %xmm0, %xmm0, %xmm0
; AVX1-FALLBACK-NEXT:    vpmulld %xmm1, %xmm1, %xmm1
; AVX1-FALLBACK-NEXT:    vpaddd %xmm3, %xmm1, %xmm1
; AVX1-FALLBACK-NEXT:    vpaddd %xmm2, %xmm0, %xmm0
; AVX1-FALLBACK-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-FALLBACK-NEXT:    retq
;
; AVX2-LABEL: vec256_i32_signed_mem_mem:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %ymm0
; AVX2-NEXT:    vmovdqa (%rsi), %ymm1
; AVX2-NEXT:    vpminsd %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vpmaxsd %ymm1, %ymm0, %ymm1
; AVX2-NEXT:    vpsubd %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpsrld $1, %ymm1, %ymm1
; AVX2-NEXT:    vpmulld %ymm1, %ymm1, %ymm1
; AVX2-NEXT:    vpaddd %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; XOP-FALLBACK-LABEL: vec256_i32_signed_mem_mem:
; XOP-FALLBACK:       # %bb.0:
; XOP-FALLBACK-NEXT:    vmovdqa (%rsi), %xmm0
; XOP-FALLBACK-NEXT:    vmovdqa 16(%rsi), %xmm1
; XOP-FALLBACK-NEXT:    vmovdqa (%rdi), %xmm2
; XOP-FALLBACK-NEXT:    vmovdqa 16(%rdi), %xmm3
; XOP-FALLBACK-NEXT:    vpminsd %xmm0, %xmm2, %xmm4
; XOP-FALLBACK-NEXT:    vpminsd %xmm1, %xmm3, %xmm5
; XOP-FALLBACK-NEXT:    vpmaxsd %xmm0, %xmm2, %xmm0
; XOP-FALLBACK-NEXT:    vpsubd %xmm4, %xmm0, %xmm0
; XOP-FALLBACK-NEXT:    vpmaxsd %xmm1, %xmm3, %xmm1
; XOP-FALLBACK-NEXT:    vpsubd %xmm5, %xmm1, %xmm1
; XOP-FALLBACK-NEXT:    vpsrld $1, %xmm0, %xmm0
; XOP-FALLBACK-NEXT:    vpsrld $1, %xmm1, %xmm1
; XOP-FALLBACK-NEXT:    vpmacsdd %xmm3, %xmm1, %xmm1, %xmm1
; XOP-FALLBACK-NEXT:    vpmacsdd %xmm2, %xmm0, %xmm0, %xmm0
; XOP-FALLBACK-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; XOP-FALLBACK-NEXT:    retq
;
; XOPAVX1-LABEL: vec256_i32_signed_mem_mem:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vmovdqa (%rsi), %xmm0
; XOPAVX1-NEXT:    vmovdqa 16(%rsi), %xmm1
; XOPAVX1-NEXT:    vmovdqa (%rdi), %xmm2
; XOPAVX1-NEXT:    vmovdqa 16(%rdi), %xmm3
; XOPAVX1-NEXT:    vpminsd %xmm0, %xmm2, %xmm4
; XOPAVX1-NEXT:    vpminsd %xmm1, %xmm3, %xmm5
; XOPAVX1-NEXT:    vpmaxsd %xmm0, %xmm2, %xmm0
; XOPAVX1-NEXT:    vpsubd %xmm4, %xmm0, %xmm0
; XOPAVX1-NEXT:    vpmaxsd %xmm1, %xmm3, %xmm1
; XOPAVX1-NEXT:    vpsubd %xmm5, %xmm1, %xmm1
; XOPAVX1-NEXT:    vpsrld $1, %xmm0, %xmm0
; XOPAVX1-NEXT:    vpsrld $1, %xmm1, %xmm1
; XOPAVX1-NEXT:    vpmacsdd %xmm3, %xmm1, %xmm1, %xmm1
; XOPAVX1-NEXT:    vpmacsdd %xmm2, %xmm0, %xmm0, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; XOPAVX1-NEXT:    retq
;
; AVX512-LABEL: vec256_i32_signed_mem_mem:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512-NEXT:    vmovdqa (%rsi), %ymm1
; AVX512-NEXT:    vpminsd %ymm1, %ymm0, %ymm2
; AVX512-NEXT:    vpmaxsd %ymm1, %ymm0, %ymm1
; AVX512-NEXT:    vpsubd %ymm2, %ymm1, %ymm1
; AVX512-NEXT:    vpsrld $1, %ymm1, %ymm1
; AVX512-NEXT:    vpmulld %ymm1, %ymm1, %ymm1
; AVX512-NEXT:    vpaddd %ymm0, %ymm1, %ymm0
; AVX512-NEXT:    retq
  %a1 = load <8 x i32>, <8 x i32>* %a1_addr
  %a2 = load <8 x i32>, <8 x i32>* %a2_addr
  %t3 = icmp sgt <8 x i32> %a1, %a2 ; signed
  %t4 = select <8 x i1> %t3, <8 x i32> <i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1>, <8 x i32> <i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1>
  %t5 = select <8 x i1> %t3, <8 x i32> %a2, <8 x i32> %a1
  %t6 = select <8 x i1> %t3, <8 x i32> %a1, <8 x i32> %a2
  %t7 = sub <8 x i32> %t6, %t5
  %t8 = lshr <8 x i32> %t7, <i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1>
  %t9 = mul nsw <8 x i32> %t8, %t8 ; signed
  %a10 = add nsw <8 x i32> %t9, %a1 ; signed
  ret <8 x i32> %a10
}

; ---------------------------------------------------------------------------- ;
; 64-bit width. 256 / 64 = 4 elts.
; ---------------------------------------------------------------------------- ;

; Values come from regs

define <4 x i64> @vec256_i64_signed_reg_reg(<4 x i64> %a1, <4 x i64> %a2) nounwind {
; AVX1-FALLBACK-LABEL: vec256_i64_signed_reg_reg:
; AVX1-FALLBACK:       # %bb.0:
; AVX1-FALLBACK-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-FALLBACK-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-FALLBACK-NEXT:    vpcmpgtq %xmm2, %xmm3, %xmm4
; AVX1-FALLBACK-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm5
; AVX1-FALLBACK-NEXT:    vpcmpgtq %xmm3, %xmm2, %xmm6
; AVX1-FALLBACK-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm7
; AVX1-FALLBACK-NEXT:    vblendvpd %xmm7, %xmm0, %xmm1, %xmm7
; AVX1-FALLBACK-NEXT:    vblendvpd %xmm5, %xmm0, %xmm1, %xmm1
; AVX1-FALLBACK-NEXT:    vpsubq %xmm7, %xmm1, %xmm1
; AVX1-FALLBACK-NEXT:    vblendvpd %xmm6, %xmm3, %xmm2, %xmm6
; AVX1-FALLBACK-NEXT:    vblendvpd %xmm4, %xmm3, %xmm2, %xmm2
; AVX1-FALLBACK-NEXT:    vpsubq %xmm6, %xmm2, %xmm2
; AVX1-FALLBACK-NEXT:    vpsrlq $1, %xmm2, %xmm2
; AVX1-FALLBACK-NEXT:    vpsrlq $1, %xmm1, %xmm1
; AVX1-FALLBACK-NEXT:    vmovdqa {{.*#+}} xmm8 = [1,1]
; AVX1-FALLBACK-NEXT:    vpor %xmm8, %xmm5, %xmm5
; AVX1-FALLBACK-NEXT:    vpsrlq $32, %xmm5, %xmm7
; AVX1-FALLBACK-NEXT:    vpmuludq %xmm7, %xmm1, %xmm7
; AVX1-FALLBACK-NEXT:    vpsrlq $32, %xmm1, %xmm6
; AVX1-FALLBACK-NEXT:    vpmuludq %xmm5, %xmm6, %xmm6
; AVX1-FALLBACK-NEXT:    vpaddq %xmm6, %xmm7, %xmm6
; AVX1-FALLBACK-NEXT:    vpsllq $32, %xmm6, %xmm6
; AVX1-FALLBACK-NEXT:    vpmuludq %xmm5, %xmm1, %xmm1
; AVX1-FALLBACK-NEXT:    vpor %xmm8, %xmm4, %xmm4
; AVX1-FALLBACK-NEXT:    vpsrlq $32, %xmm4, %xmm5
; AVX1-FALLBACK-NEXT:    vpmuludq %xmm5, %xmm2, %xmm5
; AVX1-FALLBACK-NEXT:    vpsrlq $32, %xmm2, %xmm7
; AVX1-FALLBACK-NEXT:    vpmuludq %xmm4, %xmm7, %xmm7
; AVX1-FALLBACK-NEXT:    vpaddq %xmm7, %xmm5, %xmm5
; AVX1-FALLBACK-NEXT:    vpsllq $32, %xmm5, %xmm5
; AVX1-FALLBACK-NEXT:    vpmuludq %xmm4, %xmm2, %xmm2
; AVX1-FALLBACK-NEXT:    vpaddq %xmm3, %xmm5, %xmm3
; AVX1-FALLBACK-NEXT:    vpaddq %xmm3, %xmm2, %xmm2
; AVX1-FALLBACK-NEXT:    vpaddq %xmm0, %xmm6, %xmm0
; AVX1-FALLBACK-NEXT:    vpaddq %xmm0, %xmm1, %xmm0
; AVX1-FALLBACK-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-FALLBACK-NEXT:    retq
;
; AVX2-LABEL: vec256_i64_signed_reg_reg:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm3 = [1,1,1,1]
; AVX2-NEXT:    vpor %ymm3, %ymm2, %ymm3
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm4
; AVX2-NEXT:    vblendvpd %ymm4, %ymm0, %ymm1, %ymm4
; AVX2-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm1
; AVX2-NEXT:    vpsubq %ymm4, %ymm1, %ymm1
; AVX2-NEXT:    vpsrlq $1, %ymm1, %ymm1
; AVX2-NEXT:    vpsrlq $32, %ymm3, %ymm2
; AVX2-NEXT:    vpmuludq %ymm2, %ymm1, %ymm2
; AVX2-NEXT:    vpsrlq $32, %ymm1, %ymm4
; AVX2-NEXT:    vpmuludq %ymm3, %ymm4, %ymm4
; AVX2-NEXT:    vpaddq %ymm4, %ymm2, %ymm2
; AVX2-NEXT:    vpsllq $32, %ymm2, %ymm2
; AVX2-NEXT:    vpmuludq %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpaddq %ymm0, %ymm2, %ymm0
; AVX2-NEXT:    vpaddq %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; XOP-FALLBACK-LABEL: vec256_i64_signed_reg_reg:
; XOP-FALLBACK:       # %bb.0:
; XOP-FALLBACK-NEXT:    vextractf128 $1, %ymm1, %xmm2
; XOP-FALLBACK-NEXT:    vextractf128 $1, %ymm0, %xmm3
; XOP-FALLBACK-NEXT:    vpcomgtq %xmm2, %xmm3, %xmm4
; XOP-FALLBACK-NEXT:    vpcomgtq %xmm1, %xmm0, %xmm5
; XOP-FALLBACK-NEXT:    vpcomltq %xmm2, %xmm3, %xmm6
; XOP-FALLBACK-NEXT:    vpcomltq %xmm1, %xmm0, %xmm7
; XOP-FALLBACK-NEXT:    vblendvpd %xmm7, %xmm0, %xmm1, %xmm7
; XOP-FALLBACK-NEXT:    vblendvpd %xmm5, %xmm0, %xmm1, %xmm1
; XOP-FALLBACK-NEXT:    vpsubq %xmm7, %xmm1, %xmm1
; XOP-FALLBACK-NEXT:    vblendvpd %xmm6, %xmm3, %xmm2, %xmm6
; XOP-FALLBACK-NEXT:    vblendvpd %xmm4, %xmm3, %xmm2, %xmm2
; XOP-FALLBACK-NEXT:    vpsubq %xmm6, %xmm2, %xmm2
; XOP-FALLBACK-NEXT:    vpsrlq $1, %xmm2, %xmm2
; XOP-FALLBACK-NEXT:    vpsrlq $1, %xmm1, %xmm1
; XOP-FALLBACK-NEXT:    vmovdqa {{.*#+}} xmm8 = [1,1]
; XOP-FALLBACK-NEXT:    vpor %xmm8, %xmm5, %xmm5
; XOP-FALLBACK-NEXT:    vpsrlq $32, %xmm5, %xmm7
; XOP-FALLBACK-NEXT:    vpmuludq %xmm7, %xmm1, %xmm7
; XOP-FALLBACK-NEXT:    vpsrlq $32, %xmm1, %xmm6
; XOP-FALLBACK-NEXT:    vpmuludq %xmm5, %xmm6, %xmm6
; XOP-FALLBACK-NEXT:    vpaddq %xmm6, %xmm7, %xmm6
; XOP-FALLBACK-NEXT:    vpsllq $32, %xmm6, %xmm6
; XOP-FALLBACK-NEXT:    vpmuludq %xmm5, %xmm1, %xmm1
; XOP-FALLBACK-NEXT:    vpor %xmm8, %xmm4, %xmm4
; XOP-FALLBACK-NEXT:    vpsrlq $32, %xmm4, %xmm5
; XOP-FALLBACK-NEXT:    vpmuludq %xmm5, %xmm2, %xmm5
; XOP-FALLBACK-NEXT:    vpsrlq $32, %xmm2, %xmm7
; XOP-FALLBACK-NEXT:    vpmuludq %xmm4, %xmm7, %xmm7
; XOP-FALLBACK-NEXT:    vpaddq %xmm7, %xmm5, %xmm5
; XOP-FALLBACK-NEXT:    vpsllq $32, %xmm5, %xmm5
; XOP-FALLBACK-NEXT:    vpmuludq %xmm4, %xmm2, %xmm2
; XOP-FALLBACK-NEXT:    vpaddq %xmm3, %xmm5, %xmm3
; XOP-FALLBACK-NEXT:    vpaddq %xmm3, %xmm2, %xmm2
; XOP-FALLBACK-NEXT:    vpaddq %xmm0, %xmm6, %xmm0
; XOP-FALLBACK-NEXT:    vpaddq %xmm0, %xmm1, %xmm0
; XOP-FALLBACK-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOP-FALLBACK-NEXT:    retq
;
; XOPAVX1-LABEL: vec256_i64_signed_reg_reg:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; XOPAVX1-NEXT:    vpcomgtq %xmm2, %xmm3, %xmm4
; XOPAVX1-NEXT:    vpcomgtq %xmm1, %xmm0, %xmm5
; XOPAVX1-NEXT:    vpcomltq %xmm2, %xmm3, %xmm6
; XOPAVX1-NEXT:    vpcomltq %xmm1, %xmm0, %xmm7
; XOPAVX1-NEXT:    vblendvpd %xmm7, %xmm0, %xmm1, %xmm7
; XOPAVX1-NEXT:    vblendvpd %xmm5, %xmm0, %xmm1, %xmm1
; XOPAVX1-NEXT:    vpsubq %xmm7, %xmm1, %xmm1
; XOPAVX1-NEXT:    vblendvpd %xmm6, %xmm3, %xmm2, %xmm6
; XOPAVX1-NEXT:    vblendvpd %xmm4, %xmm3, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpsubq %xmm6, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpsrlq $1, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpsrlq $1, %xmm1, %xmm1
; XOPAVX1-NEXT:    vmovdqa {{.*#+}} xmm8 = [1,1]
; XOPAVX1-NEXT:    vpor %xmm8, %xmm5, %xmm5
; XOPAVX1-NEXT:    vpsrlq $32, %xmm5, %xmm7
; XOPAVX1-NEXT:    vpmuludq %xmm7, %xmm1, %xmm7
; XOPAVX1-NEXT:    vpsrlq $32, %xmm1, %xmm6
; XOPAVX1-NEXT:    vpmuludq %xmm5, %xmm6, %xmm6
; XOPAVX1-NEXT:    vpaddq %xmm6, %xmm7, %xmm6
; XOPAVX1-NEXT:    vpsllq $32, %xmm6, %xmm6
; XOPAVX1-NEXT:    vpmuludq %xmm5, %xmm1, %xmm1
; XOPAVX1-NEXT:    vpor %xmm8, %xmm4, %xmm4
; XOPAVX1-NEXT:    vpsrlq $32, %xmm4, %xmm5
; XOPAVX1-NEXT:    vpmuludq %xmm5, %xmm2, %xmm5
; XOPAVX1-NEXT:    vpsrlq $32, %xmm2, %xmm7
; XOPAVX1-NEXT:    vpmuludq %xmm4, %xmm7, %xmm7
; XOPAVX1-NEXT:    vpaddq %xmm7, %xmm5, %xmm5
; XOPAVX1-NEXT:    vpsllq $32, %xmm5, %xmm5
; XOPAVX1-NEXT:    vpmuludq %xmm4, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpaddq %xmm3, %xmm5, %xmm3
; XOPAVX1-NEXT:    vpaddq %xmm3, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpaddq %xmm0, %xmm6, %xmm0
; XOPAVX1-NEXT:    vpaddq %xmm0, %xmm1, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOPAVX1-NEXT:    retq
;
; AVX512F-LABEL: vec256_i64_signed_reg_reg:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-NEXT:    vpcmpgtq %zmm1, %zmm0, %k1
; AVX512F-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512F-NEXT:    vpbroadcastq {{.*#+}} ymm3 = [1,1,1,1]
; AVX512F-NEXT:    vmovdqa64 %zmm2, %zmm3 {%k1}
; AVX512F-NEXT:    vpminsq %zmm1, %zmm0, %zmm2
; AVX512F-NEXT:    vpmaxsq %zmm1, %zmm0, %zmm1
; AVX512F-NEXT:    vpsubq %ymm2, %ymm1, %ymm1
; AVX512F-NEXT:    vpsrlq $1, %ymm1, %ymm1
; AVX512F-NEXT:    vpsrlq $32, %ymm1, %ymm2
; AVX512F-NEXT:    vpmuludq %ymm3, %ymm2, %ymm2
; AVX512F-NEXT:    vpsrlq $32, %ymm3, %ymm4
; AVX512F-NEXT:    vpmuludq %ymm4, %ymm1, %ymm4
; AVX512F-NEXT:    vpaddq %ymm2, %ymm4, %ymm2
; AVX512F-NEXT:    vpsllq $32, %ymm2, %ymm2
; AVX512F-NEXT:    vpmuludq %ymm3, %ymm1, %ymm1
; AVX512F-NEXT:    vpaddq %ymm0, %ymm2, %ymm0
; AVX512F-NEXT:    vpaddq %ymm0, %ymm1, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: vec256_i64_signed_reg_reg:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpcmpgtq %ymm1, %ymm0, %k1
; AVX512VL-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512VL-NEXT:    vpbroadcastq {{.*#+}} ymm3 = [1,1,1,1]
; AVX512VL-NEXT:    vmovdqa64 %ymm2, %ymm3 {%k1}
; AVX512VL-NEXT:    vpminsq %ymm1, %ymm0, %ymm2
; AVX512VL-NEXT:    vpmaxsq %ymm1, %ymm0, %ymm1
; AVX512VL-NEXT:    vpsubq %ymm2, %ymm1, %ymm1
; AVX512VL-NEXT:    vpsrlq $1, %ymm1, %ymm1
; AVX512VL-NEXT:    vpsrlq $32, %ymm3, %ymm2
; AVX512VL-NEXT:    vpmuludq %ymm2, %ymm1, %ymm2
; AVX512VL-NEXT:    vpsrlq $32, %ymm1, %ymm4
; AVX512VL-NEXT:    vpmuludq %ymm3, %ymm4, %ymm4
; AVX512VL-NEXT:    vpaddq %ymm4, %ymm2, %ymm2
; AVX512VL-NEXT:    vpsllq $32, %ymm2, %ymm2
; AVX512VL-NEXT:    vpmuludq %ymm3, %ymm1, %ymm1
; AVX512VL-NEXT:    vpaddq %ymm0, %ymm2, %ymm0
; AVX512VL-NEXT:    vpaddq %ymm0, %ymm1, %ymm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-FALLBACK-LABEL: vec256_i64_signed_reg_reg:
; AVX512BW-FALLBACK:       # %bb.0:
; AVX512BW-FALLBACK-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512BW-FALLBACK-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-FALLBACK-NEXT:    vpcmpgtq %zmm1, %zmm0, %k1
; AVX512BW-FALLBACK-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpbroadcastq {{.*#+}} ymm3 = [1,1,1,1]
; AVX512BW-FALLBACK-NEXT:    vmovdqa64 %zmm2, %zmm3 {%k1}
; AVX512BW-FALLBACK-NEXT:    vpminsq %zmm1, %zmm0, %zmm2
; AVX512BW-FALLBACK-NEXT:    vpmaxsq %zmm1, %zmm0, %zmm1
; AVX512BW-FALLBACK-NEXT:    vpsubq %ymm2, %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpsrlq $1, %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpsrlq $32, %ymm1, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpmuludq %ymm3, %ymm2, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpsrlq $32, %ymm3, %ymm4
; AVX512BW-FALLBACK-NEXT:    vpmuludq %ymm4, %ymm1, %ymm4
; AVX512BW-FALLBACK-NEXT:    vpaddq %ymm2, %ymm4, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpsllq $32, %ymm2, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpmuludq %ymm3, %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpaddq %ymm0, %ymm2, %ymm0
; AVX512BW-FALLBACK-NEXT:    vpaddq %ymm0, %ymm1, %ymm0
; AVX512BW-FALLBACK-NEXT:    retq
  %t3 = icmp sgt <4 x i64> %a1, %a2 ; signed
  %t4 = select <4 x i1> %t3, <4 x i64> <i64 -1, i64 -1, i64 -1, i64 -1>, <4 x i64> <i64 1, i64 1, i64 1, i64 1>
  %t5 = select <4 x i1> %t3, <4 x i64> %a2, <4 x i64> %a1
  %t6 = select <4 x i1> %t3, <4 x i64> %a1, <4 x i64> %a2
  %t7 = sub <4 x i64> %t6, %t5
  %t8 = lshr <4 x i64> %t7, <i64 1, i64 1, i64 1, i64 1>
  %t9 = mul nsw <4 x i64> %t8, %t4 ; signed
  %a10 = add nsw <4 x i64> %t9, %a1 ; signed
  ret <4 x i64> %a10
}

define <4 x i64> @vec256_i64_unsigned_reg_reg(<4 x i64> %a1, <4 x i64> %a2) nounwind {
; AVX1-FALLBACK-LABEL: vec256_i64_unsigned_reg_reg:
; AVX1-FALLBACK:       # %bb.0:
; AVX1-FALLBACK-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-FALLBACK-NEXT:    vmovdqa {{.*#+}} xmm4 = [9223372036854775808,9223372036854775808]
; AVX1-FALLBACK-NEXT:    vpxor %xmm4, %xmm3, %xmm5
; AVX1-FALLBACK-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-FALLBACK-NEXT:    vpxor %xmm4, %xmm2, %xmm6
; AVX1-FALLBACK-NEXT:    vpcmpgtq %xmm5, %xmm6, %xmm8
; AVX1-FALLBACK-NEXT:    vpxor %xmm4, %xmm1, %xmm7
; AVX1-FALLBACK-NEXT:    vpxor %xmm4, %xmm0, %xmm4
; AVX1-FALLBACK-NEXT:    vpcmpgtq %xmm7, %xmm4, %xmm9
; AVX1-FALLBACK-NEXT:    vpcmpgtq %xmm6, %xmm5, %xmm5
; AVX1-FALLBACK-NEXT:    vpcmpgtq %xmm4, %xmm7, %xmm4
; AVX1-FALLBACK-NEXT:    vblendvpd %xmm4, %xmm0, %xmm1, %xmm4
; AVX1-FALLBACK-NEXT:    vblendvpd %xmm9, %xmm0, %xmm1, %xmm1
; AVX1-FALLBACK-NEXT:    vpsubq %xmm4, %xmm1, %xmm1
; AVX1-FALLBACK-NEXT:    vblendvpd %xmm5, %xmm2, %xmm3, %xmm4
; AVX1-FALLBACK-NEXT:    vblendvpd %xmm8, %xmm2, %xmm3, %xmm3
; AVX1-FALLBACK-NEXT:    vpsubq %xmm4, %xmm3, %xmm3
; AVX1-FALLBACK-NEXT:    vpsrlq $1, %xmm3, %xmm3
; AVX1-FALLBACK-NEXT:    vpsrlq $1, %xmm1, %xmm1
; AVX1-FALLBACK-NEXT:    vmovdqa {{.*#+}} xmm4 = [1,1]
; AVX1-FALLBACK-NEXT:    vpor %xmm4, %xmm9, %xmm5
; AVX1-FALLBACK-NEXT:    vpsrlq $32, %xmm5, %xmm6
; AVX1-FALLBACK-NEXT:    vpmuludq %xmm6, %xmm1, %xmm6
; AVX1-FALLBACK-NEXT:    vpsrlq $32, %xmm1, %xmm7
; AVX1-FALLBACK-NEXT:    vpmuludq %xmm5, %xmm7, %xmm7
; AVX1-FALLBACK-NEXT:    vpaddq %xmm7, %xmm6, %xmm6
; AVX1-FALLBACK-NEXT:    vpsllq $32, %xmm6, %xmm6
; AVX1-FALLBACK-NEXT:    vpmuludq %xmm5, %xmm1, %xmm1
; AVX1-FALLBACK-NEXT:    vpor %xmm4, %xmm8, %xmm4
; AVX1-FALLBACK-NEXT:    vpsrlq $32, %xmm4, %xmm5
; AVX1-FALLBACK-NEXT:    vpmuludq %xmm5, %xmm3, %xmm5
; AVX1-FALLBACK-NEXT:    vpsrlq $32, %xmm3, %xmm7
; AVX1-FALLBACK-NEXT:    vpmuludq %xmm4, %xmm7, %xmm7
; AVX1-FALLBACK-NEXT:    vpaddq %xmm7, %xmm5, %xmm5
; AVX1-FALLBACK-NEXT:    vpsllq $32, %xmm5, %xmm5
; AVX1-FALLBACK-NEXT:    vpmuludq %xmm4, %xmm3, %xmm3
; AVX1-FALLBACK-NEXT:    vpaddq %xmm2, %xmm5, %xmm2
; AVX1-FALLBACK-NEXT:    vpaddq %xmm2, %xmm3, %xmm2
; AVX1-FALLBACK-NEXT:    vpaddq %xmm0, %xmm6, %xmm0
; AVX1-FALLBACK-NEXT:    vpaddq %xmm0, %xmm1, %xmm0
; AVX1-FALLBACK-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-FALLBACK-NEXT:    retq
;
; AVX2-LABEL: vec256_i64_unsigned_reg_reg:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm2 = [9223372036854775808,9223372036854775808,9223372036854775808,9223372036854775808]
; AVX2-NEXT:    vpxor %ymm2, %ymm1, %ymm3
; AVX2-NEXT:    vpxor %ymm2, %ymm0, %ymm2
; AVX2-NEXT:    vpcmpgtq %ymm3, %ymm2, %ymm4
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm5 = [1,1,1,1]
; AVX2-NEXT:    vpor %ymm5, %ymm4, %ymm5
; AVX2-NEXT:    vpcmpgtq %ymm2, %ymm3, %ymm2
; AVX2-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm2
; AVX2-NEXT:    vblendvpd %ymm4, %ymm0, %ymm1, %ymm1
; AVX2-NEXT:    vpsubq %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpsrlq $1, %ymm1, %ymm1
; AVX2-NEXT:    vpsrlq $32, %ymm5, %ymm2
; AVX2-NEXT:    vpmuludq %ymm2, %ymm1, %ymm2
; AVX2-NEXT:    vpsrlq $32, %ymm1, %ymm3
; AVX2-NEXT:    vpmuludq %ymm5, %ymm3, %ymm3
; AVX2-NEXT:    vpaddq %ymm3, %ymm2, %ymm2
; AVX2-NEXT:    vpsllq $32, %ymm2, %ymm2
; AVX2-NEXT:    vpmuludq %ymm5, %ymm1, %ymm1
; AVX2-NEXT:    vpaddq %ymm0, %ymm2, %ymm0
; AVX2-NEXT:    vpaddq %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; XOP-FALLBACK-LABEL: vec256_i64_unsigned_reg_reg:
; XOP-FALLBACK:       # %bb.0:
; XOP-FALLBACK-NEXT:    vextractf128 $1, %ymm1, %xmm2
; XOP-FALLBACK-NEXT:    vextractf128 $1, %ymm0, %xmm3
; XOP-FALLBACK-NEXT:    vpcomgtuq %xmm2, %xmm3, %xmm4
; XOP-FALLBACK-NEXT:    vpcomgtuq %xmm1, %xmm0, %xmm5
; XOP-FALLBACK-NEXT:    vpcomltuq %xmm2, %xmm3, %xmm6
; XOP-FALLBACK-NEXT:    vpcomltuq %xmm1, %xmm0, %xmm7
; XOP-FALLBACK-NEXT:    vblendvpd %xmm7, %xmm0, %xmm1, %xmm7
; XOP-FALLBACK-NEXT:    vblendvpd %xmm5, %xmm0, %xmm1, %xmm1
; XOP-FALLBACK-NEXT:    vpsubq %xmm7, %xmm1, %xmm1
; XOP-FALLBACK-NEXT:    vblendvpd %xmm6, %xmm3, %xmm2, %xmm6
; XOP-FALLBACK-NEXT:    vblendvpd %xmm4, %xmm3, %xmm2, %xmm2
; XOP-FALLBACK-NEXT:    vpsubq %xmm6, %xmm2, %xmm2
; XOP-FALLBACK-NEXT:    vpsrlq $1, %xmm2, %xmm2
; XOP-FALLBACK-NEXT:    vpsrlq $1, %xmm1, %xmm1
; XOP-FALLBACK-NEXT:    vmovdqa {{.*#+}} xmm8 = [1,1]
; XOP-FALLBACK-NEXT:    vpor %xmm8, %xmm5, %xmm5
; XOP-FALLBACK-NEXT:    vpsrlq $32, %xmm5, %xmm7
; XOP-FALLBACK-NEXT:    vpmuludq %xmm7, %xmm1, %xmm7
; XOP-FALLBACK-NEXT:    vpsrlq $32, %xmm1, %xmm6
; XOP-FALLBACK-NEXT:    vpmuludq %xmm5, %xmm6, %xmm6
; XOP-FALLBACK-NEXT:    vpaddq %xmm6, %xmm7, %xmm6
; XOP-FALLBACK-NEXT:    vpsllq $32, %xmm6, %xmm6
; XOP-FALLBACK-NEXT:    vpmuludq %xmm5, %xmm1, %xmm1
; XOP-FALLBACK-NEXT:    vpor %xmm8, %xmm4, %xmm4
; XOP-FALLBACK-NEXT:    vpsrlq $32, %xmm4, %xmm5
; XOP-FALLBACK-NEXT:    vpmuludq %xmm5, %xmm2, %xmm5
; XOP-FALLBACK-NEXT:    vpsrlq $32, %xmm2, %xmm7
; XOP-FALLBACK-NEXT:    vpmuludq %xmm4, %xmm7, %xmm7
; XOP-FALLBACK-NEXT:    vpaddq %xmm7, %xmm5, %xmm5
; XOP-FALLBACK-NEXT:    vpsllq $32, %xmm5, %xmm5
; XOP-FALLBACK-NEXT:    vpmuludq %xmm4, %xmm2, %xmm2
; XOP-FALLBACK-NEXT:    vpaddq %xmm3, %xmm5, %xmm3
; XOP-FALLBACK-NEXT:    vpaddq %xmm3, %xmm2, %xmm2
; XOP-FALLBACK-NEXT:    vpaddq %xmm0, %xmm6, %xmm0
; XOP-FALLBACK-NEXT:    vpaddq %xmm0, %xmm1, %xmm0
; XOP-FALLBACK-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOP-FALLBACK-NEXT:    retq
;
; XOPAVX1-LABEL: vec256_i64_unsigned_reg_reg:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; XOPAVX1-NEXT:    vpcomgtuq %xmm2, %xmm3, %xmm4
; XOPAVX1-NEXT:    vpcomgtuq %xmm1, %xmm0, %xmm5
; XOPAVX1-NEXT:    vpcomltuq %xmm2, %xmm3, %xmm6
; XOPAVX1-NEXT:    vpcomltuq %xmm1, %xmm0, %xmm7
; XOPAVX1-NEXT:    vblendvpd %xmm7, %xmm0, %xmm1, %xmm7
; XOPAVX1-NEXT:    vblendvpd %xmm5, %xmm0, %xmm1, %xmm1
; XOPAVX1-NEXT:    vpsubq %xmm7, %xmm1, %xmm1
; XOPAVX1-NEXT:    vblendvpd %xmm6, %xmm3, %xmm2, %xmm6
; XOPAVX1-NEXT:    vblendvpd %xmm4, %xmm3, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpsubq %xmm6, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpsrlq $1, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpsrlq $1, %xmm1, %xmm1
; XOPAVX1-NEXT:    vmovdqa {{.*#+}} xmm8 = [1,1]
; XOPAVX1-NEXT:    vpor %xmm8, %xmm5, %xmm5
; XOPAVX1-NEXT:    vpsrlq $32, %xmm5, %xmm7
; XOPAVX1-NEXT:    vpmuludq %xmm7, %xmm1, %xmm7
; XOPAVX1-NEXT:    vpsrlq $32, %xmm1, %xmm6
; XOPAVX1-NEXT:    vpmuludq %xmm5, %xmm6, %xmm6
; XOPAVX1-NEXT:    vpaddq %xmm6, %xmm7, %xmm6
; XOPAVX1-NEXT:    vpsllq $32, %xmm6, %xmm6
; XOPAVX1-NEXT:    vpmuludq %xmm5, %xmm1, %xmm1
; XOPAVX1-NEXT:    vpor %xmm8, %xmm4, %xmm4
; XOPAVX1-NEXT:    vpsrlq $32, %xmm4, %xmm5
; XOPAVX1-NEXT:    vpmuludq %xmm5, %xmm2, %xmm5
; XOPAVX1-NEXT:    vpsrlq $32, %xmm2, %xmm7
; XOPAVX1-NEXT:    vpmuludq %xmm4, %xmm7, %xmm7
; XOPAVX1-NEXT:    vpaddq %xmm7, %xmm5, %xmm5
; XOPAVX1-NEXT:    vpsllq $32, %xmm5, %xmm5
; XOPAVX1-NEXT:    vpmuludq %xmm4, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpaddq %xmm3, %xmm5, %xmm3
; XOPAVX1-NEXT:    vpaddq %xmm3, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpaddq %xmm0, %xmm6, %xmm0
; XOPAVX1-NEXT:    vpaddq %xmm0, %xmm1, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOPAVX1-NEXT:    retq
;
; AVX512F-LABEL: vec256_i64_unsigned_reg_reg:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-NEXT:    vpcmpnleuq %zmm1, %zmm0, %k1
; AVX512F-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512F-NEXT:    vpbroadcastq {{.*#+}} ymm3 = [1,1,1,1]
; AVX512F-NEXT:    vmovdqa64 %zmm2, %zmm3 {%k1}
; AVX512F-NEXT:    vpminuq %zmm1, %zmm0, %zmm2
; AVX512F-NEXT:    vpmaxuq %zmm1, %zmm0, %zmm1
; AVX512F-NEXT:    vpsubq %ymm2, %ymm1, %ymm1
; AVX512F-NEXT:    vpsrlq $1, %ymm1, %ymm1
; AVX512F-NEXT:    vpsrlq $32, %ymm1, %ymm2
; AVX512F-NEXT:    vpmuludq %ymm3, %ymm2, %ymm2
; AVX512F-NEXT:    vpsrlq $32, %ymm3, %ymm4
; AVX512F-NEXT:    vpmuludq %ymm4, %ymm1, %ymm4
; AVX512F-NEXT:    vpaddq %ymm2, %ymm4, %ymm2
; AVX512F-NEXT:    vpsllq $32, %ymm2, %ymm2
; AVX512F-NEXT:    vpmuludq %ymm3, %ymm1, %ymm1
; AVX512F-NEXT:    vpaddq %ymm0, %ymm2, %ymm0
; AVX512F-NEXT:    vpaddq %ymm0, %ymm1, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: vec256_i64_unsigned_reg_reg:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpcmpnleuq %ymm1, %ymm0, %k1
; AVX512VL-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512VL-NEXT:    vpbroadcastq {{.*#+}} ymm3 = [1,1,1,1]
; AVX512VL-NEXT:    vmovdqa64 %ymm2, %ymm3 {%k1}
; AVX512VL-NEXT:    vpminuq %ymm1, %ymm0, %ymm2
; AVX512VL-NEXT:    vpmaxuq %ymm1, %ymm0, %ymm1
; AVX512VL-NEXT:    vpsubq %ymm2, %ymm1, %ymm1
; AVX512VL-NEXT:    vpsrlq $1, %ymm1, %ymm1
; AVX512VL-NEXT:    vpsrlq $32, %ymm3, %ymm2
; AVX512VL-NEXT:    vpmuludq %ymm2, %ymm1, %ymm2
; AVX512VL-NEXT:    vpsrlq $32, %ymm1, %ymm4
; AVX512VL-NEXT:    vpmuludq %ymm3, %ymm4, %ymm4
; AVX512VL-NEXT:    vpaddq %ymm4, %ymm2, %ymm2
; AVX512VL-NEXT:    vpsllq $32, %ymm2, %ymm2
; AVX512VL-NEXT:    vpmuludq %ymm3, %ymm1, %ymm1
; AVX512VL-NEXT:    vpaddq %ymm0, %ymm2, %ymm0
; AVX512VL-NEXT:    vpaddq %ymm0, %ymm1, %ymm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-FALLBACK-LABEL: vec256_i64_unsigned_reg_reg:
; AVX512BW-FALLBACK:       # %bb.0:
; AVX512BW-FALLBACK-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512BW-FALLBACK-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-FALLBACK-NEXT:    vpcmpnleuq %zmm1, %zmm0, %k1
; AVX512BW-FALLBACK-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpbroadcastq {{.*#+}} ymm3 = [1,1,1,1]
; AVX512BW-FALLBACK-NEXT:    vmovdqa64 %zmm2, %zmm3 {%k1}
; AVX512BW-FALLBACK-NEXT:    vpminuq %zmm1, %zmm0, %zmm2
; AVX512BW-FALLBACK-NEXT:    vpmaxuq %zmm1, %zmm0, %zmm1
; AVX512BW-FALLBACK-NEXT:    vpsubq %ymm2, %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpsrlq $1, %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpsrlq $32, %ymm1, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpmuludq %ymm3, %ymm2, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpsrlq $32, %ymm3, %ymm4
; AVX512BW-FALLBACK-NEXT:    vpmuludq %ymm4, %ymm1, %ymm4
; AVX512BW-FALLBACK-NEXT:    vpaddq %ymm2, %ymm4, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpsllq $32, %ymm2, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpmuludq %ymm3, %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpaddq %ymm0, %ymm2, %ymm0
; AVX512BW-FALLBACK-NEXT:    vpaddq %ymm0, %ymm1, %ymm0
; AVX512BW-FALLBACK-NEXT:    retq
  %t3 = icmp ugt <4 x i64> %a1, %a2
  %t4 = select <4 x i1> %t3, <4 x i64> <i64 -1, i64 -1, i64 -1, i64 -1>, <4 x i64> <i64 1, i64 1, i64 1, i64 1>
  %t5 = select <4 x i1> %t3, <4 x i64> %a2, <4 x i64> %a1
  %t6 = select <4 x i1> %t3, <4 x i64> %a1, <4 x i64> %a2
  %t7 = sub <4 x i64> %t6, %t5
  %t8 = lshr <4 x i64> %t7, <i64 1, i64 1, i64 1, i64 1>
  %t9 = mul <4 x i64> %t8, %t4
  %a10 = add <4 x i64> %t9, %a1
  ret <4 x i64> %a10
}

; Values are loaded. Only check signed case.

define <4 x i64> @vec256_i64_signed_mem_reg(<4 x i64>* %a1_addr, <4 x i64> %a2) nounwind {
; AVX1-FALLBACK-LABEL: vec256_i64_signed_mem_reg:
; AVX1-FALLBACK:       # %bb.0:
; AVX1-FALLBACK-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-FALLBACK-NEXT:    vmovdqa (%rdi), %xmm1
; AVX1-FALLBACK-NEXT:    vmovdqa 16(%rdi), %xmm3
; AVX1-FALLBACK-NEXT:    vpcmpgtq %xmm2, %xmm3, %xmm4
; AVX1-FALLBACK-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm5
; AVX1-FALLBACK-NEXT:    vpcmpgtq %xmm3, %xmm2, %xmm6
; AVX1-FALLBACK-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm7
; AVX1-FALLBACK-NEXT:    vblendvpd %xmm7, %xmm1, %xmm0, %xmm7
; AVX1-FALLBACK-NEXT:    vblendvpd %xmm5, %xmm1, %xmm0, %xmm0
; AVX1-FALLBACK-NEXT:    vpsubq %xmm7, %xmm0, %xmm0
; AVX1-FALLBACK-NEXT:    vblendvpd %xmm6, %xmm3, %xmm2, %xmm6
; AVX1-FALLBACK-NEXT:    vblendvpd %xmm4, %xmm3, %xmm2, %xmm2
; AVX1-FALLBACK-NEXT:    vpsubq %xmm6, %xmm2, %xmm2
; AVX1-FALLBACK-NEXT:    vpsrlq $1, %xmm2, %xmm2
; AVX1-FALLBACK-NEXT:    vpsrlq $1, %xmm0, %xmm0
; AVX1-FALLBACK-NEXT:    vmovdqa {{.*#+}} xmm8 = [1,1]
; AVX1-FALLBACK-NEXT:    vpor %xmm8, %xmm5, %xmm5
; AVX1-FALLBACK-NEXT:    vpsrlq $32, %xmm5, %xmm7
; AVX1-FALLBACK-NEXT:    vpmuludq %xmm7, %xmm0, %xmm7
; AVX1-FALLBACK-NEXT:    vpsrlq $32, %xmm0, %xmm6
; AVX1-FALLBACK-NEXT:    vpmuludq %xmm5, %xmm6, %xmm6
; AVX1-FALLBACK-NEXT:    vpaddq %xmm6, %xmm7, %xmm6
; AVX1-FALLBACK-NEXT:    vpsllq $32, %xmm6, %xmm6
; AVX1-FALLBACK-NEXT:    vpmuludq %xmm5, %xmm0, %xmm0
; AVX1-FALLBACK-NEXT:    vpor %xmm8, %xmm4, %xmm4
; AVX1-FALLBACK-NEXT:    vpsrlq $32, %xmm4, %xmm5
; AVX1-FALLBACK-NEXT:    vpmuludq %xmm5, %xmm2, %xmm5
; AVX1-FALLBACK-NEXT:    vpsrlq $32, %xmm2, %xmm7
; AVX1-FALLBACK-NEXT:    vpmuludq %xmm4, %xmm7, %xmm7
; AVX1-FALLBACK-NEXT:    vpaddq %xmm7, %xmm5, %xmm5
; AVX1-FALLBACK-NEXT:    vpsllq $32, %xmm5, %xmm5
; AVX1-FALLBACK-NEXT:    vpmuludq %xmm4, %xmm2, %xmm2
; AVX1-FALLBACK-NEXT:    vpaddq %xmm3, %xmm5, %xmm3
; AVX1-FALLBACK-NEXT:    vpaddq %xmm3, %xmm2, %xmm2
; AVX1-FALLBACK-NEXT:    vpaddq %xmm1, %xmm6, %xmm1
; AVX1-FALLBACK-NEXT:    vpaddq %xmm1, %xmm0, %xmm0
; AVX1-FALLBACK-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-FALLBACK-NEXT:    retq
;
; AVX2-LABEL: vec256_i64_signed_mem_reg:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %ymm1
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm2
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm3 = [1,1,1,1]
; AVX2-NEXT:    vpor %ymm3, %ymm2, %ymm3
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm4
; AVX2-NEXT:    vblendvpd %ymm4, %ymm1, %ymm0, %ymm4
; AVX2-NEXT:    vblendvpd %ymm2, %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpsubq %ymm4, %ymm0, %ymm0
; AVX2-NEXT:    vpsrlq $1, %ymm0, %ymm0
; AVX2-NEXT:    vpsrlq $32, %ymm3, %ymm2
; AVX2-NEXT:    vpmuludq %ymm2, %ymm0, %ymm2
; AVX2-NEXT:    vpsrlq $32, %ymm0, %ymm4
; AVX2-NEXT:    vpmuludq %ymm3, %ymm4, %ymm4
; AVX2-NEXT:    vpaddq %ymm4, %ymm2, %ymm2
; AVX2-NEXT:    vpsllq $32, %ymm2, %ymm2
; AVX2-NEXT:    vpmuludq %ymm3, %ymm0, %ymm0
; AVX2-NEXT:    vpaddq %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vpaddq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; XOP-FALLBACK-LABEL: vec256_i64_signed_mem_reg:
; XOP-FALLBACK:       # %bb.0:
; XOP-FALLBACK-NEXT:    vextractf128 $1, %ymm0, %xmm2
; XOP-FALLBACK-NEXT:    vmovdqa (%rdi), %xmm1
; XOP-FALLBACK-NEXT:    vmovdqa 16(%rdi), %xmm3
; XOP-FALLBACK-NEXT:    vpcomgtq %xmm2, %xmm3, %xmm4
; XOP-FALLBACK-NEXT:    vpcomgtq %xmm0, %xmm1, %xmm5
; XOP-FALLBACK-NEXT:    vpcomltq %xmm2, %xmm3, %xmm6
; XOP-FALLBACK-NEXT:    vpcomltq %xmm0, %xmm1, %xmm7
; XOP-FALLBACK-NEXT:    vblendvpd %xmm7, %xmm1, %xmm0, %xmm7
; XOP-FALLBACK-NEXT:    vblendvpd %xmm5, %xmm1, %xmm0, %xmm0
; XOP-FALLBACK-NEXT:    vpsubq %xmm7, %xmm0, %xmm0
; XOP-FALLBACK-NEXT:    vblendvpd %xmm6, %xmm3, %xmm2, %xmm6
; XOP-FALLBACK-NEXT:    vblendvpd %xmm4, %xmm3, %xmm2, %xmm2
; XOP-FALLBACK-NEXT:    vpsubq %xmm6, %xmm2, %xmm2
; XOP-FALLBACK-NEXT:    vpsrlq $1, %xmm2, %xmm2
; XOP-FALLBACK-NEXT:    vpsrlq $1, %xmm0, %xmm0
; XOP-FALLBACK-NEXT:    vmovdqa {{.*#+}} xmm8 = [1,1]
; XOP-FALLBACK-NEXT:    vpor %xmm8, %xmm5, %xmm5
; XOP-FALLBACK-NEXT:    vpsrlq $32, %xmm5, %xmm7
; XOP-FALLBACK-NEXT:    vpmuludq %xmm7, %xmm0, %xmm7
; XOP-FALLBACK-NEXT:    vpsrlq $32, %xmm0, %xmm6
; XOP-FALLBACK-NEXT:    vpmuludq %xmm5, %xmm6, %xmm6
; XOP-FALLBACK-NEXT:    vpaddq %xmm6, %xmm7, %xmm6
; XOP-FALLBACK-NEXT:    vpsllq $32, %xmm6, %xmm6
; XOP-FALLBACK-NEXT:    vpmuludq %xmm5, %xmm0, %xmm0
; XOP-FALLBACK-NEXT:    vpor %xmm8, %xmm4, %xmm4
; XOP-FALLBACK-NEXT:    vpsrlq $32, %xmm4, %xmm5
; XOP-FALLBACK-NEXT:    vpmuludq %xmm5, %xmm2, %xmm5
; XOP-FALLBACK-NEXT:    vpsrlq $32, %xmm2, %xmm7
; XOP-FALLBACK-NEXT:    vpmuludq %xmm4, %xmm7, %xmm7
; XOP-FALLBACK-NEXT:    vpaddq %xmm7, %xmm5, %xmm5
; XOP-FALLBACK-NEXT:    vpsllq $32, %xmm5, %xmm5
; XOP-FALLBACK-NEXT:    vpmuludq %xmm4, %xmm2, %xmm2
; XOP-FALLBACK-NEXT:    vpaddq %xmm3, %xmm5, %xmm3
; XOP-FALLBACK-NEXT:    vpaddq %xmm3, %xmm2, %xmm2
; XOP-FALLBACK-NEXT:    vpaddq %xmm1, %xmm6, %xmm1
; XOP-FALLBACK-NEXT:    vpaddq %xmm1, %xmm0, %xmm0
; XOP-FALLBACK-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOP-FALLBACK-NEXT:    retq
;
; XOPAVX1-LABEL: vec256_i64_signed_mem_reg:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; XOPAVX1-NEXT:    vmovdqa (%rdi), %xmm1
; XOPAVX1-NEXT:    vmovdqa 16(%rdi), %xmm3
; XOPAVX1-NEXT:    vpcomgtq %xmm2, %xmm3, %xmm4
; XOPAVX1-NEXT:    vpcomgtq %xmm0, %xmm1, %xmm5
; XOPAVX1-NEXT:    vpcomltq %xmm2, %xmm3, %xmm6
; XOPAVX1-NEXT:    vpcomltq %xmm0, %xmm1, %xmm7
; XOPAVX1-NEXT:    vblendvpd %xmm7, %xmm1, %xmm0, %xmm7
; XOPAVX1-NEXT:    vblendvpd %xmm5, %xmm1, %xmm0, %xmm0
; XOPAVX1-NEXT:    vpsubq %xmm7, %xmm0, %xmm0
; XOPAVX1-NEXT:    vblendvpd %xmm6, %xmm3, %xmm2, %xmm6
; XOPAVX1-NEXT:    vblendvpd %xmm4, %xmm3, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpsubq %xmm6, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpsrlq $1, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpsrlq $1, %xmm0, %xmm0
; XOPAVX1-NEXT:    vmovdqa {{.*#+}} xmm8 = [1,1]
; XOPAVX1-NEXT:    vpor %xmm8, %xmm5, %xmm5
; XOPAVX1-NEXT:    vpsrlq $32, %xmm5, %xmm7
; XOPAVX1-NEXT:    vpmuludq %xmm7, %xmm0, %xmm7
; XOPAVX1-NEXT:    vpsrlq $32, %xmm0, %xmm6
; XOPAVX1-NEXT:    vpmuludq %xmm5, %xmm6, %xmm6
; XOPAVX1-NEXT:    vpaddq %xmm6, %xmm7, %xmm6
; XOPAVX1-NEXT:    vpsllq $32, %xmm6, %xmm6
; XOPAVX1-NEXT:    vpmuludq %xmm5, %xmm0, %xmm0
; XOPAVX1-NEXT:    vpor %xmm8, %xmm4, %xmm4
; XOPAVX1-NEXT:    vpsrlq $32, %xmm4, %xmm5
; XOPAVX1-NEXT:    vpmuludq %xmm5, %xmm2, %xmm5
; XOPAVX1-NEXT:    vpsrlq $32, %xmm2, %xmm7
; XOPAVX1-NEXT:    vpmuludq %xmm4, %xmm7, %xmm7
; XOPAVX1-NEXT:    vpaddq %xmm7, %xmm5, %xmm5
; XOPAVX1-NEXT:    vpsllq $32, %xmm5, %xmm5
; XOPAVX1-NEXT:    vpmuludq %xmm4, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpaddq %xmm3, %xmm5, %xmm3
; XOPAVX1-NEXT:    vpaddq %xmm3, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpaddq %xmm1, %xmm6, %xmm1
; XOPAVX1-NEXT:    vpaddq %xmm1, %xmm0, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOPAVX1-NEXT:    retq
;
; AVX512F-LABEL: vec256_i64_signed_mem_reg:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-NEXT:    vmovdqa (%rdi), %ymm1
; AVX512F-NEXT:    vpcmpgtq %zmm0, %zmm1, %k1
; AVX512F-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512F-NEXT:    vpbroadcastq {{.*#+}} ymm3 = [1,1,1,1]
; AVX512F-NEXT:    vmovdqa64 %zmm2, %zmm3 {%k1}
; AVX512F-NEXT:    vpminsq %zmm0, %zmm1, %zmm2
; AVX512F-NEXT:    vpmaxsq %zmm0, %zmm1, %zmm0
; AVX512F-NEXT:    vpsubq %ymm2, %ymm0, %ymm0
; AVX512F-NEXT:    vpsrlq $1, %ymm0, %ymm0
; AVX512F-NEXT:    vpsrlq $32, %ymm0, %ymm2
; AVX512F-NEXT:    vpmuludq %ymm3, %ymm2, %ymm2
; AVX512F-NEXT:    vpsrlq $32, %ymm3, %ymm4
; AVX512F-NEXT:    vpmuludq %ymm4, %ymm0, %ymm4
; AVX512F-NEXT:    vpaddq %ymm2, %ymm4, %ymm2
; AVX512F-NEXT:    vpsllq $32, %ymm2, %ymm2
; AVX512F-NEXT:    vpmuludq %ymm3, %ymm0, %ymm0
; AVX512F-NEXT:    vpaddq %ymm1, %ymm2, %ymm1
; AVX512F-NEXT:    vpaddq %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: vec256_i64_signed_mem_reg:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vmovdqa (%rdi), %ymm1
; AVX512VL-NEXT:    vpcmpgtq %ymm0, %ymm1, %k1
; AVX512VL-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512VL-NEXT:    vpbroadcastq {{.*#+}} ymm3 = [1,1,1,1]
; AVX512VL-NEXT:    vmovdqa64 %ymm2, %ymm3 {%k1}
; AVX512VL-NEXT:    vpminsq %ymm0, %ymm1, %ymm2
; AVX512VL-NEXT:    vpmaxsq %ymm0, %ymm1, %ymm0
; AVX512VL-NEXT:    vpsubq %ymm2, %ymm0, %ymm0
; AVX512VL-NEXT:    vpsrlq $1, %ymm0, %ymm0
; AVX512VL-NEXT:    vpsrlq $32, %ymm3, %ymm2
; AVX512VL-NEXT:    vpmuludq %ymm2, %ymm0, %ymm2
; AVX512VL-NEXT:    vpsrlq $32, %ymm0, %ymm4
; AVX512VL-NEXT:    vpmuludq %ymm3, %ymm4, %ymm4
; AVX512VL-NEXT:    vpaddq %ymm4, %ymm2, %ymm2
; AVX512VL-NEXT:    vpsllq $32, %ymm2, %ymm2
; AVX512VL-NEXT:    vpmuludq %ymm3, %ymm0, %ymm0
; AVX512VL-NEXT:    vpaddq %ymm1, %ymm2, %ymm1
; AVX512VL-NEXT:    vpaddq %ymm1, %ymm0, %ymm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-FALLBACK-LABEL: vec256_i64_signed_mem_reg:
; AVX512BW-FALLBACK:       # %bb.0:
; AVX512BW-FALLBACK-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-FALLBACK-NEXT:    vmovdqa (%rdi), %ymm1
; AVX512BW-FALLBACK-NEXT:    vpcmpgtq %zmm0, %zmm1, %k1
; AVX512BW-FALLBACK-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpbroadcastq {{.*#+}} ymm3 = [1,1,1,1]
; AVX512BW-FALLBACK-NEXT:    vmovdqa64 %zmm2, %zmm3 {%k1}
; AVX512BW-FALLBACK-NEXT:    vpminsq %zmm0, %zmm1, %zmm2
; AVX512BW-FALLBACK-NEXT:    vpmaxsq %zmm0, %zmm1, %zmm0
; AVX512BW-FALLBACK-NEXT:    vpsubq %ymm2, %ymm0, %ymm0
; AVX512BW-FALLBACK-NEXT:    vpsrlq $1, %ymm0, %ymm0
; AVX512BW-FALLBACK-NEXT:    vpsrlq $32, %ymm0, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpmuludq %ymm3, %ymm2, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpsrlq $32, %ymm3, %ymm4
; AVX512BW-FALLBACK-NEXT:    vpmuludq %ymm4, %ymm0, %ymm4
; AVX512BW-FALLBACK-NEXT:    vpaddq %ymm2, %ymm4, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpsllq $32, %ymm2, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpmuludq %ymm3, %ymm0, %ymm0
; AVX512BW-FALLBACK-NEXT:    vpaddq %ymm1, %ymm2, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpaddq %ymm1, %ymm0, %ymm0
; AVX512BW-FALLBACK-NEXT:    retq
  %a1 = load <4 x i64>, <4 x i64>* %a1_addr
  %t3 = icmp sgt <4 x i64> %a1, %a2 ; signed
  %t4 = select <4 x i1> %t3, <4 x i64> <i64 -1, i64 -1, i64 -1, i64 -1>, <4 x i64> <i64 1, i64 1, i64 1, i64 1>
  %t5 = select <4 x i1> %t3, <4 x i64> %a2, <4 x i64> %a1
  %t6 = select <4 x i1> %t3, <4 x i64> %a1, <4 x i64> %a2
  %t7 = sub <4 x i64> %t6, %t5
  %t8 = lshr <4 x i64> %t7, <i64 1, i64 1, i64 1, i64 1>
  %t9 = mul nsw <4 x i64> %t8, %t4 ; signed
  %a10 = add nsw <4 x i64> %t9, %a1 ; signed
  ret <4 x i64> %a10
}

define <4 x i64> @vec256_i64_signed_reg_mem(<4 x i64> %a1, <4 x i64>* %a2_addr) nounwind {
; AVX1-FALLBACK-LABEL: vec256_i64_signed_reg_mem:
; AVX1-FALLBACK:       # %bb.0:
; AVX1-FALLBACK-NEXT:    vmovdqa (%rdi), %xmm1
; AVX1-FALLBACK-NEXT:    vmovdqa 16(%rdi), %xmm2
; AVX1-FALLBACK-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-FALLBACK-NEXT:    vpcmpgtq %xmm2, %xmm3, %xmm4
; AVX1-FALLBACK-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm5
; AVX1-FALLBACK-NEXT:    vpcmpgtq %xmm3, %xmm2, %xmm6
; AVX1-FALLBACK-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm7
; AVX1-FALLBACK-NEXT:    vblendvpd %xmm7, %xmm0, %xmm1, %xmm7
; AVX1-FALLBACK-NEXT:    vblendvpd %xmm5, %xmm0, %xmm1, %xmm1
; AVX1-FALLBACK-NEXT:    vpsubq %xmm7, %xmm1, %xmm1
; AVX1-FALLBACK-NEXT:    vblendvpd %xmm6, %xmm3, %xmm2, %xmm6
; AVX1-FALLBACK-NEXT:    vblendvpd %xmm4, %xmm3, %xmm2, %xmm2
; AVX1-FALLBACK-NEXT:    vpsubq %xmm6, %xmm2, %xmm2
; AVX1-FALLBACK-NEXT:    vpsrlq $1, %xmm2, %xmm2
; AVX1-FALLBACK-NEXT:    vpsrlq $1, %xmm1, %xmm1
; AVX1-FALLBACK-NEXT:    vmovdqa {{.*#+}} xmm8 = [1,1]
; AVX1-FALLBACK-NEXT:    vpor %xmm8, %xmm5, %xmm5
; AVX1-FALLBACK-NEXT:    vpsrlq $32, %xmm5, %xmm7
; AVX1-FALLBACK-NEXT:    vpmuludq %xmm7, %xmm1, %xmm7
; AVX1-FALLBACK-NEXT:    vpsrlq $32, %xmm1, %xmm6
; AVX1-FALLBACK-NEXT:    vpmuludq %xmm5, %xmm6, %xmm6
; AVX1-FALLBACK-NEXT:    vpaddq %xmm6, %xmm7, %xmm6
; AVX1-FALLBACK-NEXT:    vpsllq $32, %xmm6, %xmm6
; AVX1-FALLBACK-NEXT:    vpmuludq %xmm5, %xmm1, %xmm1
; AVX1-FALLBACK-NEXT:    vpor %xmm8, %xmm4, %xmm4
; AVX1-FALLBACK-NEXT:    vpsrlq $32, %xmm4, %xmm5
; AVX1-FALLBACK-NEXT:    vpmuludq %xmm5, %xmm2, %xmm5
; AVX1-FALLBACK-NEXT:    vpsrlq $32, %xmm2, %xmm7
; AVX1-FALLBACK-NEXT:    vpmuludq %xmm4, %xmm7, %xmm7
; AVX1-FALLBACK-NEXT:    vpaddq %xmm7, %xmm5, %xmm5
; AVX1-FALLBACK-NEXT:    vpsllq $32, %xmm5, %xmm5
; AVX1-FALLBACK-NEXT:    vpmuludq %xmm4, %xmm2, %xmm2
; AVX1-FALLBACK-NEXT:    vpaddq %xmm3, %xmm5, %xmm3
; AVX1-FALLBACK-NEXT:    vpaddq %xmm3, %xmm2, %xmm2
; AVX1-FALLBACK-NEXT:    vpaddq %xmm0, %xmm6, %xmm0
; AVX1-FALLBACK-NEXT:    vpaddq %xmm0, %xmm1, %xmm0
; AVX1-FALLBACK-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-FALLBACK-NEXT:    retq
;
; AVX2-LABEL: vec256_i64_signed_reg_mem:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %ymm1
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm3 = [1,1,1,1]
; AVX2-NEXT:    vpor %ymm3, %ymm2, %ymm3
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm4
; AVX2-NEXT:    vblendvpd %ymm4, %ymm0, %ymm1, %ymm4
; AVX2-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm1
; AVX2-NEXT:    vpsubq %ymm4, %ymm1, %ymm1
; AVX2-NEXT:    vpsrlq $1, %ymm1, %ymm1
; AVX2-NEXT:    vpsrlq $32, %ymm3, %ymm2
; AVX2-NEXT:    vpmuludq %ymm2, %ymm1, %ymm2
; AVX2-NEXT:    vpsrlq $32, %ymm1, %ymm4
; AVX2-NEXT:    vpmuludq %ymm3, %ymm4, %ymm4
; AVX2-NEXT:    vpaddq %ymm4, %ymm2, %ymm2
; AVX2-NEXT:    vpsllq $32, %ymm2, %ymm2
; AVX2-NEXT:    vpmuludq %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpaddq %ymm0, %ymm2, %ymm0
; AVX2-NEXT:    vpaddq %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; XOP-FALLBACK-LABEL: vec256_i64_signed_reg_mem:
; XOP-FALLBACK:       # %bb.0:
; XOP-FALLBACK-NEXT:    vmovdqa (%rdi), %xmm1
; XOP-FALLBACK-NEXT:    vmovdqa 16(%rdi), %xmm2
; XOP-FALLBACK-NEXT:    vextractf128 $1, %ymm0, %xmm3
; XOP-FALLBACK-NEXT:    vpcomgtq %xmm2, %xmm3, %xmm4
; XOP-FALLBACK-NEXT:    vpcomgtq %xmm1, %xmm0, %xmm5
; XOP-FALLBACK-NEXT:    vpcomltq %xmm2, %xmm3, %xmm6
; XOP-FALLBACK-NEXT:    vpcomltq %xmm1, %xmm0, %xmm7
; XOP-FALLBACK-NEXT:    vblendvpd %xmm7, %xmm0, %xmm1, %xmm7
; XOP-FALLBACK-NEXT:    vblendvpd %xmm5, %xmm0, %xmm1, %xmm1
; XOP-FALLBACK-NEXT:    vpsubq %xmm7, %xmm1, %xmm1
; XOP-FALLBACK-NEXT:    vblendvpd %xmm6, %xmm3, %xmm2, %xmm6
; XOP-FALLBACK-NEXT:    vblendvpd %xmm4, %xmm3, %xmm2, %xmm2
; XOP-FALLBACK-NEXT:    vpsubq %xmm6, %xmm2, %xmm2
; XOP-FALLBACK-NEXT:    vpsrlq $1, %xmm2, %xmm2
; XOP-FALLBACK-NEXT:    vpsrlq $1, %xmm1, %xmm1
; XOP-FALLBACK-NEXT:    vmovdqa {{.*#+}} xmm8 = [1,1]
; XOP-FALLBACK-NEXT:    vpor %xmm8, %xmm5, %xmm5
; XOP-FALLBACK-NEXT:    vpsrlq $32, %xmm5, %xmm7
; XOP-FALLBACK-NEXT:    vpmuludq %xmm7, %xmm1, %xmm7
; XOP-FALLBACK-NEXT:    vpsrlq $32, %xmm1, %xmm6
; XOP-FALLBACK-NEXT:    vpmuludq %xmm5, %xmm6, %xmm6
; XOP-FALLBACK-NEXT:    vpaddq %xmm6, %xmm7, %xmm6
; XOP-FALLBACK-NEXT:    vpsllq $32, %xmm6, %xmm6
; XOP-FALLBACK-NEXT:    vpmuludq %xmm5, %xmm1, %xmm1
; XOP-FALLBACK-NEXT:    vpor %xmm8, %xmm4, %xmm4
; XOP-FALLBACK-NEXT:    vpsrlq $32, %xmm4, %xmm5
; XOP-FALLBACK-NEXT:    vpmuludq %xmm5, %xmm2, %xmm5
; XOP-FALLBACK-NEXT:    vpsrlq $32, %xmm2, %xmm7
; XOP-FALLBACK-NEXT:    vpmuludq %xmm4, %xmm7, %xmm7
; XOP-FALLBACK-NEXT:    vpaddq %xmm7, %xmm5, %xmm5
; XOP-FALLBACK-NEXT:    vpsllq $32, %xmm5, %xmm5
; XOP-FALLBACK-NEXT:    vpmuludq %xmm4, %xmm2, %xmm2
; XOP-FALLBACK-NEXT:    vpaddq %xmm3, %xmm5, %xmm3
; XOP-FALLBACK-NEXT:    vpaddq %xmm3, %xmm2, %xmm2
; XOP-FALLBACK-NEXT:    vpaddq %xmm0, %xmm6, %xmm0
; XOP-FALLBACK-NEXT:    vpaddq %xmm0, %xmm1, %xmm0
; XOP-FALLBACK-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOP-FALLBACK-NEXT:    retq
;
; XOPAVX1-LABEL: vec256_i64_signed_reg_mem:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vmovdqa (%rdi), %xmm1
; XOPAVX1-NEXT:    vmovdqa 16(%rdi), %xmm2
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; XOPAVX1-NEXT:    vpcomgtq %xmm2, %xmm3, %xmm4
; XOPAVX1-NEXT:    vpcomgtq %xmm1, %xmm0, %xmm5
; XOPAVX1-NEXT:    vpcomltq %xmm2, %xmm3, %xmm6
; XOPAVX1-NEXT:    vpcomltq %xmm1, %xmm0, %xmm7
; XOPAVX1-NEXT:    vblendvpd %xmm7, %xmm0, %xmm1, %xmm7
; XOPAVX1-NEXT:    vblendvpd %xmm5, %xmm0, %xmm1, %xmm1
; XOPAVX1-NEXT:    vpsubq %xmm7, %xmm1, %xmm1
; XOPAVX1-NEXT:    vblendvpd %xmm6, %xmm3, %xmm2, %xmm6
; XOPAVX1-NEXT:    vblendvpd %xmm4, %xmm3, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpsubq %xmm6, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpsrlq $1, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpsrlq $1, %xmm1, %xmm1
; XOPAVX1-NEXT:    vmovdqa {{.*#+}} xmm8 = [1,1]
; XOPAVX1-NEXT:    vpor %xmm8, %xmm5, %xmm5
; XOPAVX1-NEXT:    vpsrlq $32, %xmm5, %xmm7
; XOPAVX1-NEXT:    vpmuludq %xmm7, %xmm1, %xmm7
; XOPAVX1-NEXT:    vpsrlq $32, %xmm1, %xmm6
; XOPAVX1-NEXT:    vpmuludq %xmm5, %xmm6, %xmm6
; XOPAVX1-NEXT:    vpaddq %xmm6, %xmm7, %xmm6
; XOPAVX1-NEXT:    vpsllq $32, %xmm6, %xmm6
; XOPAVX1-NEXT:    vpmuludq %xmm5, %xmm1, %xmm1
; XOPAVX1-NEXT:    vpor %xmm8, %xmm4, %xmm4
; XOPAVX1-NEXT:    vpsrlq $32, %xmm4, %xmm5
; XOPAVX1-NEXT:    vpmuludq %xmm5, %xmm2, %xmm5
; XOPAVX1-NEXT:    vpsrlq $32, %xmm2, %xmm7
; XOPAVX1-NEXT:    vpmuludq %xmm4, %xmm7, %xmm7
; XOPAVX1-NEXT:    vpaddq %xmm7, %xmm5, %xmm5
; XOPAVX1-NEXT:    vpsllq $32, %xmm5, %xmm5
; XOPAVX1-NEXT:    vpmuludq %xmm4, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpaddq %xmm3, %xmm5, %xmm3
; XOPAVX1-NEXT:    vpaddq %xmm3, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpaddq %xmm0, %xmm6, %xmm0
; XOPAVX1-NEXT:    vpaddq %xmm0, %xmm1, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOPAVX1-NEXT:    retq
;
; AVX512F-LABEL: vec256_i64_signed_reg_mem:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-NEXT:    vmovdqa (%rdi), %ymm1
; AVX512F-NEXT:    vpcmpgtq %zmm1, %zmm0, %k1
; AVX512F-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512F-NEXT:    vpbroadcastq {{.*#+}} ymm3 = [1,1,1,1]
; AVX512F-NEXT:    vmovdqa64 %zmm2, %zmm3 {%k1}
; AVX512F-NEXT:    vpminsq %zmm1, %zmm0, %zmm2
; AVX512F-NEXT:    vpmaxsq %zmm1, %zmm0, %zmm1
; AVX512F-NEXT:    vpsubq %ymm2, %ymm1, %ymm1
; AVX512F-NEXT:    vpsrlq $1, %ymm1, %ymm1
; AVX512F-NEXT:    vpsrlq $32, %ymm1, %ymm2
; AVX512F-NEXT:    vpmuludq %ymm3, %ymm2, %ymm2
; AVX512F-NEXT:    vpsrlq $32, %ymm3, %ymm4
; AVX512F-NEXT:    vpmuludq %ymm4, %ymm1, %ymm4
; AVX512F-NEXT:    vpaddq %ymm2, %ymm4, %ymm2
; AVX512F-NEXT:    vpsllq $32, %ymm2, %ymm2
; AVX512F-NEXT:    vpmuludq %ymm3, %ymm1, %ymm1
; AVX512F-NEXT:    vpaddq %ymm0, %ymm2, %ymm0
; AVX512F-NEXT:    vpaddq %ymm0, %ymm1, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: vec256_i64_signed_reg_mem:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vmovdqa (%rdi), %ymm1
; AVX512VL-NEXT:    vpcmpgtq %ymm1, %ymm0, %k1
; AVX512VL-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512VL-NEXT:    vpbroadcastq {{.*#+}} ymm3 = [1,1,1,1]
; AVX512VL-NEXT:    vmovdqa64 %ymm2, %ymm3 {%k1}
; AVX512VL-NEXT:    vpminsq %ymm1, %ymm0, %ymm2
; AVX512VL-NEXT:    vpmaxsq %ymm1, %ymm0, %ymm1
; AVX512VL-NEXT:    vpsubq %ymm2, %ymm1, %ymm1
; AVX512VL-NEXT:    vpsrlq $1, %ymm1, %ymm1
; AVX512VL-NEXT:    vpsrlq $32, %ymm3, %ymm2
; AVX512VL-NEXT:    vpmuludq %ymm2, %ymm1, %ymm2
; AVX512VL-NEXT:    vpsrlq $32, %ymm1, %ymm4
; AVX512VL-NEXT:    vpmuludq %ymm3, %ymm4, %ymm4
; AVX512VL-NEXT:    vpaddq %ymm4, %ymm2, %ymm2
; AVX512VL-NEXT:    vpsllq $32, %ymm2, %ymm2
; AVX512VL-NEXT:    vpmuludq %ymm3, %ymm1, %ymm1
; AVX512VL-NEXT:    vpaddq %ymm0, %ymm2, %ymm0
; AVX512VL-NEXT:    vpaddq %ymm0, %ymm1, %ymm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-FALLBACK-LABEL: vec256_i64_signed_reg_mem:
; AVX512BW-FALLBACK:       # %bb.0:
; AVX512BW-FALLBACK-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-FALLBACK-NEXT:    vmovdqa (%rdi), %ymm1
; AVX512BW-FALLBACK-NEXT:    vpcmpgtq %zmm1, %zmm0, %k1
; AVX512BW-FALLBACK-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpbroadcastq {{.*#+}} ymm3 = [1,1,1,1]
; AVX512BW-FALLBACK-NEXT:    vmovdqa64 %zmm2, %zmm3 {%k1}
; AVX512BW-FALLBACK-NEXT:    vpminsq %zmm1, %zmm0, %zmm2
; AVX512BW-FALLBACK-NEXT:    vpmaxsq %zmm1, %zmm0, %zmm1
; AVX512BW-FALLBACK-NEXT:    vpsubq %ymm2, %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpsrlq $1, %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpsrlq $32, %ymm1, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpmuludq %ymm3, %ymm2, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpsrlq $32, %ymm3, %ymm4
; AVX512BW-FALLBACK-NEXT:    vpmuludq %ymm4, %ymm1, %ymm4
; AVX512BW-FALLBACK-NEXT:    vpaddq %ymm2, %ymm4, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpsllq $32, %ymm2, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpmuludq %ymm3, %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpaddq %ymm0, %ymm2, %ymm0
; AVX512BW-FALLBACK-NEXT:    vpaddq %ymm0, %ymm1, %ymm0
; AVX512BW-FALLBACK-NEXT:    retq
  %a2 = load <4 x i64>, <4 x i64>* %a2_addr
  %t3 = icmp sgt <4 x i64> %a1, %a2 ; signed
  %t4 = select <4 x i1> %t3, <4 x i64> <i64 -1, i64 -1, i64 -1, i64 -1>, <4 x i64> <i64 1, i64 1, i64 1, i64 1>
  %t5 = select <4 x i1> %t3, <4 x i64> %a2, <4 x i64> %a1
  %t6 = select <4 x i1> %t3, <4 x i64> %a1, <4 x i64> %a2
  %t7 = sub <4 x i64> %t6, %t5
  %t8 = lshr <4 x i64> %t7, <i64 1, i64 1, i64 1, i64 1>
  %t9 = mul nsw <4 x i64> %t8, %t4 ; signed
  %a10 = add nsw <4 x i64> %t9, %a1 ; signed
  ret <4 x i64> %a10
}

define <4 x i64> @vec256_i64_signed_mem_mem(<4 x i64>* %a1_addr, <4 x i64>* %a2_addr) nounwind {
; AVX1-FALLBACK-LABEL: vec256_i64_signed_mem_mem:
; AVX1-FALLBACK:       # %bb.0:
; AVX1-FALLBACK-NEXT:    vmovdqa (%rsi), %xmm1
; AVX1-FALLBACK-NEXT:    vmovdqa 16(%rsi), %xmm2
; AVX1-FALLBACK-NEXT:    vmovdqa (%rdi), %xmm0
; AVX1-FALLBACK-NEXT:    vmovdqa 16(%rdi), %xmm3
; AVX1-FALLBACK-NEXT:    vpcmpgtq %xmm2, %xmm3, %xmm4
; AVX1-FALLBACK-NEXT:    vpcmpgtq %xmm1, %xmm0, %xmm5
; AVX1-FALLBACK-NEXT:    vpcmpgtq %xmm3, %xmm2, %xmm6
; AVX1-FALLBACK-NEXT:    vpcmpgtq %xmm0, %xmm1, %xmm7
; AVX1-FALLBACK-NEXT:    vblendvpd %xmm7, %xmm0, %xmm1, %xmm7
; AVX1-FALLBACK-NEXT:    vblendvpd %xmm5, %xmm0, %xmm1, %xmm1
; AVX1-FALLBACK-NEXT:    vpsubq %xmm7, %xmm1, %xmm1
; AVX1-FALLBACK-NEXT:    vblendvpd %xmm6, %xmm3, %xmm2, %xmm6
; AVX1-FALLBACK-NEXT:    vblendvpd %xmm4, %xmm3, %xmm2, %xmm2
; AVX1-FALLBACK-NEXT:    vpsubq %xmm6, %xmm2, %xmm2
; AVX1-FALLBACK-NEXT:    vpsrlq $1, %xmm2, %xmm2
; AVX1-FALLBACK-NEXT:    vpsrlq $1, %xmm1, %xmm1
; AVX1-FALLBACK-NEXT:    vmovdqa {{.*#+}} xmm8 = [1,1]
; AVX1-FALLBACK-NEXT:    vpor %xmm8, %xmm5, %xmm5
; AVX1-FALLBACK-NEXT:    vpsrlq $32, %xmm5, %xmm7
; AVX1-FALLBACK-NEXT:    vpmuludq %xmm7, %xmm1, %xmm7
; AVX1-FALLBACK-NEXT:    vpsrlq $32, %xmm1, %xmm6
; AVX1-FALLBACK-NEXT:    vpmuludq %xmm5, %xmm6, %xmm6
; AVX1-FALLBACK-NEXT:    vpaddq %xmm6, %xmm7, %xmm6
; AVX1-FALLBACK-NEXT:    vpsllq $32, %xmm6, %xmm6
; AVX1-FALLBACK-NEXT:    vpmuludq %xmm5, %xmm1, %xmm1
; AVX1-FALLBACK-NEXT:    vpor %xmm8, %xmm4, %xmm4
; AVX1-FALLBACK-NEXT:    vpsrlq $32, %xmm4, %xmm5
; AVX1-FALLBACK-NEXT:    vpmuludq %xmm5, %xmm2, %xmm5
; AVX1-FALLBACK-NEXT:    vpsrlq $32, %xmm2, %xmm7
; AVX1-FALLBACK-NEXT:    vpmuludq %xmm4, %xmm7, %xmm7
; AVX1-FALLBACK-NEXT:    vpaddq %xmm7, %xmm5, %xmm5
; AVX1-FALLBACK-NEXT:    vpsllq $32, %xmm5, %xmm5
; AVX1-FALLBACK-NEXT:    vpmuludq %xmm4, %xmm2, %xmm2
; AVX1-FALLBACK-NEXT:    vpaddq %xmm3, %xmm5, %xmm3
; AVX1-FALLBACK-NEXT:    vpaddq %xmm3, %xmm2, %xmm2
; AVX1-FALLBACK-NEXT:    vpaddq %xmm0, %xmm6, %xmm0
; AVX1-FALLBACK-NEXT:    vpaddq %xmm0, %xmm1, %xmm0
; AVX1-FALLBACK-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-FALLBACK-NEXT:    retq
;
; AVX2-LABEL: vec256_i64_signed_mem_mem:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %ymm0
; AVX2-NEXT:    vmovdqa (%rsi), %ymm1
; AVX2-NEXT:    vpcmpgtq %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm3 = [1,1,1,1]
; AVX2-NEXT:    vpor %ymm3, %ymm2, %ymm3
; AVX2-NEXT:    vpcmpgtq %ymm0, %ymm1, %ymm4
; AVX2-NEXT:    vblendvpd %ymm4, %ymm0, %ymm1, %ymm4
; AVX2-NEXT:    vblendvpd %ymm2, %ymm0, %ymm1, %ymm1
; AVX2-NEXT:    vpsubq %ymm4, %ymm1, %ymm1
; AVX2-NEXT:    vpsrlq $1, %ymm1, %ymm1
; AVX2-NEXT:    vpsrlq $32, %ymm3, %ymm2
; AVX2-NEXT:    vpmuludq %ymm2, %ymm1, %ymm2
; AVX2-NEXT:    vpsrlq $32, %ymm1, %ymm4
; AVX2-NEXT:    vpmuludq %ymm3, %ymm4, %ymm4
; AVX2-NEXT:    vpaddq %ymm4, %ymm2, %ymm2
; AVX2-NEXT:    vpsllq $32, %ymm2, %ymm2
; AVX2-NEXT:    vpmuludq %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpaddq %ymm0, %ymm2, %ymm0
; AVX2-NEXT:    vpaddq %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; XOP-FALLBACK-LABEL: vec256_i64_signed_mem_mem:
; XOP-FALLBACK:       # %bb.0:
; XOP-FALLBACK-NEXT:    vmovdqa (%rsi), %xmm1
; XOP-FALLBACK-NEXT:    vmovdqa 16(%rsi), %xmm2
; XOP-FALLBACK-NEXT:    vmovdqa (%rdi), %xmm0
; XOP-FALLBACK-NEXT:    vmovdqa 16(%rdi), %xmm3
; XOP-FALLBACK-NEXT:    vpcomgtq %xmm2, %xmm3, %xmm4
; XOP-FALLBACK-NEXT:    vpcomgtq %xmm1, %xmm0, %xmm5
; XOP-FALLBACK-NEXT:    vpcomltq %xmm2, %xmm3, %xmm6
; XOP-FALLBACK-NEXT:    vpcomltq %xmm1, %xmm0, %xmm7
; XOP-FALLBACK-NEXT:    vblendvpd %xmm7, %xmm0, %xmm1, %xmm7
; XOP-FALLBACK-NEXT:    vblendvpd %xmm5, %xmm0, %xmm1, %xmm1
; XOP-FALLBACK-NEXT:    vpsubq %xmm7, %xmm1, %xmm1
; XOP-FALLBACK-NEXT:    vblendvpd %xmm6, %xmm3, %xmm2, %xmm6
; XOP-FALLBACK-NEXT:    vblendvpd %xmm4, %xmm3, %xmm2, %xmm2
; XOP-FALLBACK-NEXT:    vpsubq %xmm6, %xmm2, %xmm2
; XOP-FALLBACK-NEXT:    vpsrlq $1, %xmm2, %xmm2
; XOP-FALLBACK-NEXT:    vpsrlq $1, %xmm1, %xmm1
; XOP-FALLBACK-NEXT:    vmovdqa {{.*#+}} xmm8 = [1,1]
; XOP-FALLBACK-NEXT:    vpor %xmm8, %xmm5, %xmm5
; XOP-FALLBACK-NEXT:    vpsrlq $32, %xmm5, %xmm7
; XOP-FALLBACK-NEXT:    vpmuludq %xmm7, %xmm1, %xmm7
; XOP-FALLBACK-NEXT:    vpsrlq $32, %xmm1, %xmm6
; XOP-FALLBACK-NEXT:    vpmuludq %xmm5, %xmm6, %xmm6
; XOP-FALLBACK-NEXT:    vpaddq %xmm6, %xmm7, %xmm6
; XOP-FALLBACK-NEXT:    vpsllq $32, %xmm6, %xmm6
; XOP-FALLBACK-NEXT:    vpmuludq %xmm5, %xmm1, %xmm1
; XOP-FALLBACK-NEXT:    vpor %xmm8, %xmm4, %xmm4
; XOP-FALLBACK-NEXT:    vpsrlq $32, %xmm4, %xmm5
; XOP-FALLBACK-NEXT:    vpmuludq %xmm5, %xmm2, %xmm5
; XOP-FALLBACK-NEXT:    vpsrlq $32, %xmm2, %xmm7
; XOP-FALLBACK-NEXT:    vpmuludq %xmm4, %xmm7, %xmm7
; XOP-FALLBACK-NEXT:    vpaddq %xmm7, %xmm5, %xmm5
; XOP-FALLBACK-NEXT:    vpsllq $32, %xmm5, %xmm5
; XOP-FALLBACK-NEXT:    vpmuludq %xmm4, %xmm2, %xmm2
; XOP-FALLBACK-NEXT:    vpaddq %xmm3, %xmm5, %xmm3
; XOP-FALLBACK-NEXT:    vpaddq %xmm3, %xmm2, %xmm2
; XOP-FALLBACK-NEXT:    vpaddq %xmm0, %xmm6, %xmm0
; XOP-FALLBACK-NEXT:    vpaddq %xmm0, %xmm1, %xmm0
; XOP-FALLBACK-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOP-FALLBACK-NEXT:    retq
;
; XOPAVX1-LABEL: vec256_i64_signed_mem_mem:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vmovdqa (%rsi), %xmm1
; XOPAVX1-NEXT:    vmovdqa 16(%rsi), %xmm2
; XOPAVX1-NEXT:    vmovdqa (%rdi), %xmm0
; XOPAVX1-NEXT:    vmovdqa 16(%rdi), %xmm3
; XOPAVX1-NEXT:    vpcomgtq %xmm2, %xmm3, %xmm4
; XOPAVX1-NEXT:    vpcomgtq %xmm1, %xmm0, %xmm5
; XOPAVX1-NEXT:    vpcomltq %xmm2, %xmm3, %xmm6
; XOPAVX1-NEXT:    vpcomltq %xmm1, %xmm0, %xmm7
; XOPAVX1-NEXT:    vblendvpd %xmm7, %xmm0, %xmm1, %xmm7
; XOPAVX1-NEXT:    vblendvpd %xmm5, %xmm0, %xmm1, %xmm1
; XOPAVX1-NEXT:    vpsubq %xmm7, %xmm1, %xmm1
; XOPAVX1-NEXT:    vblendvpd %xmm6, %xmm3, %xmm2, %xmm6
; XOPAVX1-NEXT:    vblendvpd %xmm4, %xmm3, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpsubq %xmm6, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpsrlq $1, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpsrlq $1, %xmm1, %xmm1
; XOPAVX1-NEXT:    vmovdqa {{.*#+}} xmm8 = [1,1]
; XOPAVX1-NEXT:    vpor %xmm8, %xmm5, %xmm5
; XOPAVX1-NEXT:    vpsrlq $32, %xmm5, %xmm7
; XOPAVX1-NEXT:    vpmuludq %xmm7, %xmm1, %xmm7
; XOPAVX1-NEXT:    vpsrlq $32, %xmm1, %xmm6
; XOPAVX1-NEXT:    vpmuludq %xmm5, %xmm6, %xmm6
; XOPAVX1-NEXT:    vpaddq %xmm6, %xmm7, %xmm6
; XOPAVX1-NEXT:    vpsllq $32, %xmm6, %xmm6
; XOPAVX1-NEXT:    vpmuludq %xmm5, %xmm1, %xmm1
; XOPAVX1-NEXT:    vpor %xmm8, %xmm4, %xmm4
; XOPAVX1-NEXT:    vpsrlq $32, %xmm4, %xmm5
; XOPAVX1-NEXT:    vpmuludq %xmm5, %xmm2, %xmm5
; XOPAVX1-NEXT:    vpsrlq $32, %xmm2, %xmm7
; XOPAVX1-NEXT:    vpmuludq %xmm4, %xmm7, %xmm7
; XOPAVX1-NEXT:    vpaddq %xmm7, %xmm5, %xmm5
; XOPAVX1-NEXT:    vpsllq $32, %xmm5, %xmm5
; XOPAVX1-NEXT:    vpmuludq %xmm4, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpaddq %xmm3, %xmm5, %xmm3
; XOPAVX1-NEXT:    vpaddq %xmm3, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpaddq %xmm0, %xmm6, %xmm0
; XOPAVX1-NEXT:    vpaddq %xmm0, %xmm1, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOPAVX1-NEXT:    retq
;
; AVX512F-LABEL: vec256_i64_signed_mem_mem:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512F-NEXT:    vmovdqa (%rsi), %ymm1
; AVX512F-NEXT:    vpcmpgtq %zmm1, %zmm0, %k1
; AVX512F-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512F-NEXT:    vpbroadcastq {{.*#+}} ymm3 = [1,1,1,1]
; AVX512F-NEXT:    vmovdqa64 %zmm2, %zmm3 {%k1}
; AVX512F-NEXT:    vpminsq %zmm1, %zmm0, %zmm2
; AVX512F-NEXT:    vpmaxsq %zmm1, %zmm0, %zmm1
; AVX512F-NEXT:    vpsubq %ymm2, %ymm1, %ymm1
; AVX512F-NEXT:    vpsrlq $1, %ymm1, %ymm1
; AVX512F-NEXT:    vpsrlq $32, %ymm1, %ymm2
; AVX512F-NEXT:    vpmuludq %ymm3, %ymm2, %ymm2
; AVX512F-NEXT:    vpsrlq $32, %ymm3, %ymm4
; AVX512F-NEXT:    vpmuludq %ymm4, %ymm1, %ymm4
; AVX512F-NEXT:    vpaddq %ymm2, %ymm4, %ymm2
; AVX512F-NEXT:    vpsllq $32, %ymm2, %ymm2
; AVX512F-NEXT:    vpmuludq %ymm3, %ymm1, %ymm1
; AVX512F-NEXT:    vpaddq %ymm0, %ymm2, %ymm0
; AVX512F-NEXT:    vpaddq %ymm0, %ymm1, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-LABEL: vec256_i64_signed_mem_mem:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512VL-NEXT:    vmovdqa (%rsi), %ymm1
; AVX512VL-NEXT:    vpcmpgtq %ymm1, %ymm0, %k1
; AVX512VL-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512VL-NEXT:    vpbroadcastq {{.*#+}} ymm3 = [1,1,1,1]
; AVX512VL-NEXT:    vmovdqa64 %ymm2, %ymm3 {%k1}
; AVX512VL-NEXT:    vpminsq %ymm1, %ymm0, %ymm2
; AVX512VL-NEXT:    vpmaxsq %ymm1, %ymm0, %ymm1
; AVX512VL-NEXT:    vpsubq %ymm2, %ymm1, %ymm1
; AVX512VL-NEXT:    vpsrlq $1, %ymm1, %ymm1
; AVX512VL-NEXT:    vpsrlq $32, %ymm3, %ymm2
; AVX512VL-NEXT:    vpmuludq %ymm2, %ymm1, %ymm2
; AVX512VL-NEXT:    vpsrlq $32, %ymm1, %ymm4
; AVX512VL-NEXT:    vpmuludq %ymm3, %ymm4, %ymm4
; AVX512VL-NEXT:    vpaddq %ymm4, %ymm2, %ymm2
; AVX512VL-NEXT:    vpsllq $32, %ymm2, %ymm2
; AVX512VL-NEXT:    vpmuludq %ymm3, %ymm1, %ymm1
; AVX512VL-NEXT:    vpaddq %ymm0, %ymm2, %ymm0
; AVX512VL-NEXT:    vpaddq %ymm0, %ymm1, %ymm0
; AVX512VL-NEXT:    retq
;
; AVX512BW-FALLBACK-LABEL: vec256_i64_signed_mem_mem:
; AVX512BW-FALLBACK:       # %bb.0:
; AVX512BW-FALLBACK-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512BW-FALLBACK-NEXT:    vmovdqa (%rsi), %ymm1
; AVX512BW-FALLBACK-NEXT:    vpcmpgtq %zmm1, %zmm0, %k1
; AVX512BW-FALLBACK-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpbroadcastq {{.*#+}} ymm3 = [1,1,1,1]
; AVX512BW-FALLBACK-NEXT:    vmovdqa64 %zmm2, %zmm3 {%k1}
; AVX512BW-FALLBACK-NEXT:    vpminsq %zmm1, %zmm0, %zmm2
; AVX512BW-FALLBACK-NEXT:    vpmaxsq %zmm1, %zmm0, %zmm1
; AVX512BW-FALLBACK-NEXT:    vpsubq %ymm2, %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpsrlq $1, %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpsrlq $32, %ymm1, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpmuludq %ymm3, %ymm2, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpsrlq $32, %ymm3, %ymm4
; AVX512BW-FALLBACK-NEXT:    vpmuludq %ymm4, %ymm1, %ymm4
; AVX512BW-FALLBACK-NEXT:    vpaddq %ymm2, %ymm4, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpsllq $32, %ymm2, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpmuludq %ymm3, %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpaddq %ymm0, %ymm2, %ymm0
; AVX512BW-FALLBACK-NEXT:    vpaddq %ymm0, %ymm1, %ymm0
; AVX512BW-FALLBACK-NEXT:    retq
  %a1 = load <4 x i64>, <4 x i64>* %a1_addr
  %a2 = load <4 x i64>, <4 x i64>* %a2_addr
  %t3 = icmp sgt <4 x i64> %a1, %a2 ; signed
  %t4 = select <4 x i1> %t3, <4 x i64> <i64 -1, i64 -1, i64 -1, i64 -1>, <4 x i64> <i64 1, i64 1, i64 1, i64 1>
  %t5 = select <4 x i1> %t3, <4 x i64> %a2, <4 x i64> %a1
  %t6 = select <4 x i1> %t3, <4 x i64> %a1, <4 x i64> %a2
  %t7 = sub <4 x i64> %t6, %t5
  %t8 = lshr <4 x i64> %t7, <i64 1, i64 1, i64 1, i64 1>
  %t9 = mul nsw <4 x i64> %t8, %t4 ; signed
  %a10 = add nsw <4 x i64> %t9, %a1 ; signed
  ret <4 x i64> %a10
}

; ---------------------------------------------------------------------------- ;
; 16-bit width. 256 / 16 = 16 elts.
; ---------------------------------------------------------------------------- ;

; Values come from regs

define <16 x i16> @vec256_i16_signed_reg_reg(<16 x i16> %a1, <16 x i16> %a2) nounwind {
; AVX1-FALLBACK-LABEL: vec256_i16_signed_reg_reg:
; AVX1-FALLBACK:       # %bb.0:
; AVX1-FALLBACK-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-FALLBACK-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-FALLBACK-NEXT:    vpcmpgtw %xmm2, %xmm3, %xmm4
; AVX1-FALLBACK-NEXT:    vpcmpgtw %xmm1, %xmm0, %xmm5
; AVX1-FALLBACK-NEXT:    vpminsw %xmm2, %xmm3, %xmm6
; AVX1-FALLBACK-NEXT:    vpminsw %xmm1, %xmm0, %xmm7
; AVX1-FALLBACK-NEXT:    vpmaxsw %xmm2, %xmm3, %xmm2
; AVX1-FALLBACK-NEXT:    vpsubw %xmm6, %xmm2, %xmm2
; AVX1-FALLBACK-NEXT:    vpmaxsw %xmm1, %xmm0, %xmm1
; AVX1-FALLBACK-NEXT:    vpsubw %xmm7, %xmm1, %xmm1
; AVX1-FALLBACK-NEXT:    vpsrlw $1, %xmm2, %xmm2
; AVX1-FALLBACK-NEXT:    vpsrlw $1, %xmm1, %xmm1
; AVX1-FALLBACK-NEXT:    vmovdqa {{.*#+}} xmm6 = [1,1,1,1,1,1,1,1]
; AVX1-FALLBACK-NEXT:    vpor %xmm6, %xmm5, %xmm5
; AVX1-FALLBACK-NEXT:    vpmullw %xmm5, %xmm1, %xmm1
; AVX1-FALLBACK-NEXT:    vpor %xmm6, %xmm4, %xmm4
; AVX1-FALLBACK-NEXT:    vpmullw %xmm4, %xmm2, %xmm2
; AVX1-FALLBACK-NEXT:    vpaddw %xmm3, %xmm2, %xmm2
; AVX1-FALLBACK-NEXT:    vpaddw %xmm0, %xmm1, %xmm0
; AVX1-FALLBACK-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-FALLBACK-NEXT:    retq
;
; AVX2-LABEL: vec256_i16_signed_reg_reg:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpgtw %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vpor {{.*}}(%rip), %ymm2, %ymm2
; AVX2-NEXT:    vpminsw %ymm1, %ymm0, %ymm3
; AVX2-NEXT:    vpmaxsw %ymm1, %ymm0, %ymm1
; AVX2-NEXT:    vpsubw %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX2-NEXT:    vpmullw %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpaddw %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; XOP-FALLBACK-LABEL: vec256_i16_signed_reg_reg:
; XOP-FALLBACK:       # %bb.0:
; XOP-FALLBACK-NEXT:    vextractf128 $1, %ymm1, %xmm2
; XOP-FALLBACK-NEXT:    vextractf128 $1, %ymm0, %xmm3
; XOP-FALLBACK-NEXT:    vpcomgtw %xmm2, %xmm3, %xmm4
; XOP-FALLBACK-NEXT:    vpcomgtw %xmm1, %xmm0, %xmm5
; XOP-FALLBACK-NEXT:    vpminsw %xmm1, %xmm0, %xmm6
; XOP-FALLBACK-NEXT:    vpminsw %xmm2, %xmm3, %xmm7
; XOP-FALLBACK-NEXT:    vpmaxsw %xmm1, %xmm0, %xmm1
; XOP-FALLBACK-NEXT:    vpsubw %xmm6, %xmm1, %xmm1
; XOP-FALLBACK-NEXT:    vpmaxsw %xmm2, %xmm3, %xmm2
; XOP-FALLBACK-NEXT:    vpsubw %xmm7, %xmm2, %xmm2
; XOP-FALLBACK-NEXT:    vpsrlw $1, %xmm1, %xmm1
; XOP-FALLBACK-NEXT:    vpsrlw $1, %xmm2, %xmm2
; XOP-FALLBACK-NEXT:    vmovdqa {{.*#+}} xmm6 = [1,1,1,1,1,1,1,1]
; XOP-FALLBACK-NEXT:    vpor %xmm6, %xmm5, %xmm5
; XOP-FALLBACK-NEXT:    vpor %xmm6, %xmm4, %xmm4
; XOP-FALLBACK-NEXT:    vpmacsww %xmm3, %xmm4, %xmm2, %xmm2
; XOP-FALLBACK-NEXT:    vpmacsww %xmm0, %xmm5, %xmm1, %xmm0
; XOP-FALLBACK-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOP-FALLBACK-NEXT:    retq
;
; XOPAVX1-LABEL: vec256_i16_signed_reg_reg:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; XOPAVX1-NEXT:    vpcomgtw %xmm2, %xmm3, %xmm4
; XOPAVX1-NEXT:    vpcomgtw %xmm1, %xmm0, %xmm5
; XOPAVX1-NEXT:    vpminsw %xmm1, %xmm0, %xmm6
; XOPAVX1-NEXT:    vpminsw %xmm2, %xmm3, %xmm7
; XOPAVX1-NEXT:    vpmaxsw %xmm1, %xmm0, %xmm1
; XOPAVX1-NEXT:    vpsubw %xmm6, %xmm1, %xmm1
; XOPAVX1-NEXT:    vpmaxsw %xmm2, %xmm3, %xmm2
; XOPAVX1-NEXT:    vpsubw %xmm7, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpsrlw $1, %xmm1, %xmm1
; XOPAVX1-NEXT:    vpsrlw $1, %xmm2, %xmm2
; XOPAVX1-NEXT:    vmovdqa {{.*#+}} xmm6 = [1,1,1,1,1,1,1,1]
; XOPAVX1-NEXT:    vpor %xmm6, %xmm5, %xmm5
; XOPAVX1-NEXT:    vpor %xmm6, %xmm4, %xmm4
; XOPAVX1-NEXT:    vpmacsww %xmm3, %xmm4, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpmacsww %xmm0, %xmm5, %xmm1, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOPAVX1-NEXT:    retq
;
; AVX512F-LABEL: vec256_i16_signed_reg_reg:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpcmpgtw %ymm1, %ymm0, %ymm2
; AVX512F-NEXT:    vpor {{.*}}(%rip), %ymm2, %ymm2
; AVX512F-NEXT:    vpminsw %ymm1, %ymm0, %ymm3
; AVX512F-NEXT:    vpmaxsw %ymm1, %ymm0, %ymm1
; AVX512F-NEXT:    vpsubw %ymm3, %ymm1, %ymm1
; AVX512F-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512F-NEXT:    vpmullw %ymm2, %ymm1, %ymm1
; AVX512F-NEXT:    vpaddw %ymm0, %ymm1, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-FALLBACK-LABEL: vec256_i16_signed_reg_reg:
; AVX512VL-FALLBACK:       # %bb.0:
; AVX512VL-FALLBACK-NEXT:    vpcmpgtw %ymm1, %ymm0, %ymm2
; AVX512VL-FALLBACK-NEXT:    vpor {{.*}}(%rip), %ymm2, %ymm2
; AVX512VL-FALLBACK-NEXT:    vpminsw %ymm1, %ymm0, %ymm3
; AVX512VL-FALLBACK-NEXT:    vpmaxsw %ymm1, %ymm0, %ymm1
; AVX512VL-FALLBACK-NEXT:    vpsubw %ymm3, %ymm1, %ymm1
; AVX512VL-FALLBACK-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512VL-FALLBACK-NEXT:    vpmullw %ymm2, %ymm1, %ymm1
; AVX512VL-FALLBACK-NEXT:    vpaddw %ymm0, %ymm1, %ymm0
; AVX512VL-FALLBACK-NEXT:    retq
;
; AVX512BW-FALLBACK-LABEL: vec256_i16_signed_reg_reg:
; AVX512BW-FALLBACK:       # %bb.0:
; AVX512BW-FALLBACK-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512BW-FALLBACK-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-FALLBACK-NEXT:    vpcmpgtw %zmm1, %zmm0, %k1
; AVX512BW-FALLBACK-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512BW-FALLBACK-NEXT:    vmovdqa {{.*#+}} ymm3 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; AVX512BW-FALLBACK-NEXT:    vmovdqu16 %zmm2, %zmm3 {%k1}
; AVX512BW-FALLBACK-NEXT:    vpminsw %ymm1, %ymm0, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpmaxsw %ymm1, %ymm0, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpsubw %ymm2, %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpmullw %ymm3, %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpaddw %ymm0, %ymm1, %ymm0
; AVX512BW-FALLBACK-NEXT:    retq
;
; AVX512VLBW-LABEL: vec256_i16_signed_reg_reg:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpcmpgtw %ymm1, %ymm0, %k1
; AVX512VLBW-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512VLBW-NEXT:    vmovdqa {{.*#+}} ymm3 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; AVX512VLBW-NEXT:    vmovdqu16 %ymm2, %ymm3 {%k1}
; AVX512VLBW-NEXT:    vpminsw %ymm1, %ymm0, %ymm2
; AVX512VLBW-NEXT:    vpmaxsw %ymm1, %ymm0, %ymm1
; AVX512VLBW-NEXT:    vpsubw %ymm2, %ymm1, %ymm1
; AVX512VLBW-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512VLBW-NEXT:    vpmullw %ymm3, %ymm1, %ymm1
; AVX512VLBW-NEXT:    vpaddw %ymm0, %ymm1, %ymm0
; AVX512VLBW-NEXT:    retq
  %t3 = icmp sgt <16 x i16> %a1, %a2 ; signed
  %t4 = select <16 x i1> %t3, <16 x i16> <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>, <16 x i16> <i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1>
  %t5 = select <16 x i1> %t3, <16 x i16> %a2, <16 x i16> %a1
  %t6 = select <16 x i1> %t3, <16 x i16> %a1, <16 x i16> %a2
  %t7 = sub <16 x i16> %t6, %t5
  %t16 = lshr <16 x i16> %t7, <i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1>
  %t9 = mul nsw <16 x i16> %t16, %t4 ; signed
  %a10 = add nsw <16 x i16> %t9, %a1 ; signed
  ret <16 x i16> %a10
}

define <16 x i16> @vec256_i16_unsigned_reg_reg(<16 x i16> %a1, <16 x i16> %a2) nounwind {
; AVX1-FALLBACK-LABEL: vec256_i16_unsigned_reg_reg:
; AVX1-FALLBACK:       # %bb.0:
; AVX1-FALLBACK-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-FALLBACK-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-FALLBACK-NEXT:    vpminuw %xmm2, %xmm3, %xmm4
; AVX1-FALLBACK-NEXT:    vpcmpeqw %xmm4, %xmm3, %xmm5
; AVX1-FALLBACK-NEXT:    vpcmpeqd %xmm8, %xmm8, %xmm8
; AVX1-FALLBACK-NEXT:    vpxor %xmm8, %xmm5, %xmm5
; AVX1-FALLBACK-NEXT:    vpminuw %xmm1, %xmm0, %xmm7
; AVX1-FALLBACK-NEXT:    vpcmpeqw %xmm7, %xmm0, %xmm6
; AVX1-FALLBACK-NEXT:    vpxor %xmm8, %xmm6, %xmm6
; AVX1-FALLBACK-NEXT:    vpmaxuw %xmm2, %xmm3, %xmm2
; AVX1-FALLBACK-NEXT:    vpmaxuw %xmm1, %xmm0, %xmm1
; AVX1-FALLBACK-NEXT:    vpsubw %xmm7, %xmm1, %xmm1
; AVX1-FALLBACK-NEXT:    vpsubw %xmm4, %xmm2, %xmm2
; AVX1-FALLBACK-NEXT:    vpsrlw $1, %xmm2, %xmm2
; AVX1-FALLBACK-NEXT:    vpsrlw $1, %xmm1, %xmm1
; AVX1-FALLBACK-NEXT:    vmovdqa {{.*#+}} xmm4 = [1,1,1,1,1,1,1,1]
; AVX1-FALLBACK-NEXT:    vpor %xmm4, %xmm6, %xmm6
; AVX1-FALLBACK-NEXT:    vpmullw %xmm6, %xmm1, %xmm1
; AVX1-FALLBACK-NEXT:    vpor %xmm4, %xmm5, %xmm4
; AVX1-FALLBACK-NEXT:    vpmullw %xmm4, %xmm2, %xmm2
; AVX1-FALLBACK-NEXT:    vpaddw %xmm3, %xmm2, %xmm2
; AVX1-FALLBACK-NEXT:    vpaddw %xmm0, %xmm1, %xmm0
; AVX1-FALLBACK-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-FALLBACK-NEXT:    retq
;
; AVX2-LABEL: vec256_i16_unsigned_reg_reg:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpminuw %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vpcmpeqw %ymm2, %ymm0, %ymm3
; AVX2-NEXT:    vpcmpeqd %ymm4, %ymm4, %ymm4
; AVX2-NEXT:    vpxor %ymm4, %ymm3, %ymm3
; AVX2-NEXT:    vpor {{.*}}(%rip), %ymm3, %ymm3
; AVX2-NEXT:    vpmaxuw %ymm1, %ymm0, %ymm1
; AVX2-NEXT:    vpsubw %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX2-NEXT:    vpmullw %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpaddw %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; XOP-FALLBACK-LABEL: vec256_i16_unsigned_reg_reg:
; XOP-FALLBACK:       # %bb.0:
; XOP-FALLBACK-NEXT:    vextractf128 $1, %ymm1, %xmm2
; XOP-FALLBACK-NEXT:    vextractf128 $1, %ymm0, %xmm3
; XOP-FALLBACK-NEXT:    vpcomgtuw %xmm2, %xmm3, %xmm4
; XOP-FALLBACK-NEXT:    vpcomgtuw %xmm1, %xmm0, %xmm5
; XOP-FALLBACK-NEXT:    vpminuw %xmm1, %xmm0, %xmm6
; XOP-FALLBACK-NEXT:    vpminuw %xmm2, %xmm3, %xmm7
; XOP-FALLBACK-NEXT:    vpmaxuw %xmm1, %xmm0, %xmm1
; XOP-FALLBACK-NEXT:    vpsubw %xmm6, %xmm1, %xmm1
; XOP-FALLBACK-NEXT:    vpmaxuw %xmm2, %xmm3, %xmm2
; XOP-FALLBACK-NEXT:    vpsubw %xmm7, %xmm2, %xmm2
; XOP-FALLBACK-NEXT:    vpsrlw $1, %xmm1, %xmm1
; XOP-FALLBACK-NEXT:    vpsrlw $1, %xmm2, %xmm2
; XOP-FALLBACK-NEXT:    vmovdqa {{.*#+}} xmm6 = [1,1,1,1,1,1,1,1]
; XOP-FALLBACK-NEXT:    vpor %xmm6, %xmm5, %xmm5
; XOP-FALLBACK-NEXT:    vpor %xmm6, %xmm4, %xmm4
; XOP-FALLBACK-NEXT:    vpmacsww %xmm3, %xmm4, %xmm2, %xmm2
; XOP-FALLBACK-NEXT:    vpmacsww %xmm0, %xmm5, %xmm1, %xmm0
; XOP-FALLBACK-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOP-FALLBACK-NEXT:    retq
;
; XOPAVX1-LABEL: vec256_i16_unsigned_reg_reg:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; XOPAVX1-NEXT:    vpcomgtuw %xmm2, %xmm3, %xmm4
; XOPAVX1-NEXT:    vpcomgtuw %xmm1, %xmm0, %xmm5
; XOPAVX1-NEXT:    vpminuw %xmm1, %xmm0, %xmm6
; XOPAVX1-NEXT:    vpminuw %xmm2, %xmm3, %xmm7
; XOPAVX1-NEXT:    vpmaxuw %xmm1, %xmm0, %xmm1
; XOPAVX1-NEXT:    vpsubw %xmm6, %xmm1, %xmm1
; XOPAVX1-NEXT:    vpmaxuw %xmm2, %xmm3, %xmm2
; XOPAVX1-NEXT:    vpsubw %xmm7, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpsrlw $1, %xmm1, %xmm1
; XOPAVX1-NEXT:    vpsrlw $1, %xmm2, %xmm2
; XOPAVX1-NEXT:    vmovdqa {{.*#+}} xmm6 = [1,1,1,1,1,1,1,1]
; XOPAVX1-NEXT:    vpor %xmm6, %xmm5, %xmm5
; XOPAVX1-NEXT:    vpor %xmm6, %xmm4, %xmm4
; XOPAVX1-NEXT:    vpmacsww %xmm3, %xmm4, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpmacsww %xmm0, %xmm5, %xmm1, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOPAVX1-NEXT:    retq
;
; AVX512F-LABEL: vec256_i16_unsigned_reg_reg:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpminuw %ymm1, %ymm0, %ymm2
; AVX512F-NEXT:    vpcmpeqw %ymm2, %ymm0, %ymm3
; AVX512F-NEXT:    vpternlogq $15, %zmm3, %zmm3, %zmm3
; AVX512F-NEXT:    vpor {{.*}}(%rip), %ymm3, %ymm3
; AVX512F-NEXT:    vpmaxuw %ymm1, %ymm0, %ymm1
; AVX512F-NEXT:    vpsubw %ymm2, %ymm1, %ymm1
; AVX512F-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512F-NEXT:    vpmullw %ymm3, %ymm1, %ymm1
; AVX512F-NEXT:    vpaddw %ymm0, %ymm1, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-FALLBACK-LABEL: vec256_i16_unsigned_reg_reg:
; AVX512VL-FALLBACK:       # %bb.0:
; AVX512VL-FALLBACK-NEXT:    vpminuw %ymm1, %ymm0, %ymm2
; AVX512VL-FALLBACK-NEXT:    vpcmpeqw %ymm2, %ymm0, %ymm3
; AVX512VL-FALLBACK-NEXT:    vpternlogq $15, %ymm3, %ymm3, %ymm3
; AVX512VL-FALLBACK-NEXT:    vpor {{.*}}(%rip), %ymm3, %ymm3
; AVX512VL-FALLBACK-NEXT:    vpmaxuw %ymm1, %ymm0, %ymm1
; AVX512VL-FALLBACK-NEXT:    vpsubw %ymm2, %ymm1, %ymm1
; AVX512VL-FALLBACK-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512VL-FALLBACK-NEXT:    vpmullw %ymm3, %ymm1, %ymm1
; AVX512VL-FALLBACK-NEXT:    vpaddw %ymm0, %ymm1, %ymm0
; AVX512VL-FALLBACK-NEXT:    retq
;
; AVX512BW-FALLBACK-LABEL: vec256_i16_unsigned_reg_reg:
; AVX512BW-FALLBACK:       # %bb.0:
; AVX512BW-FALLBACK-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512BW-FALLBACK-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-FALLBACK-NEXT:    vpcmpnleuw %zmm1, %zmm0, %k1
; AVX512BW-FALLBACK-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512BW-FALLBACK-NEXT:    vmovdqa {{.*#+}} ymm3 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; AVX512BW-FALLBACK-NEXT:    vmovdqu16 %zmm2, %zmm3 {%k1}
; AVX512BW-FALLBACK-NEXT:    vpminuw %ymm1, %ymm0, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpmaxuw %ymm1, %ymm0, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpsubw %ymm2, %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpmullw %ymm3, %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpaddw %ymm0, %ymm1, %ymm0
; AVX512BW-FALLBACK-NEXT:    retq
;
; AVX512VLBW-LABEL: vec256_i16_unsigned_reg_reg:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpcmpnleuw %ymm1, %ymm0, %k1
; AVX512VLBW-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512VLBW-NEXT:    vmovdqa {{.*#+}} ymm3 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; AVX512VLBW-NEXT:    vmovdqu16 %ymm2, %ymm3 {%k1}
; AVX512VLBW-NEXT:    vpminuw %ymm1, %ymm0, %ymm2
; AVX512VLBW-NEXT:    vpmaxuw %ymm1, %ymm0, %ymm1
; AVX512VLBW-NEXT:    vpsubw %ymm2, %ymm1, %ymm1
; AVX512VLBW-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512VLBW-NEXT:    vpmullw %ymm3, %ymm1, %ymm1
; AVX512VLBW-NEXT:    vpaddw %ymm0, %ymm1, %ymm0
; AVX512VLBW-NEXT:    retq
  %t3 = icmp ugt <16 x i16> %a1, %a2
  %t4 = select <16 x i1> %t3, <16 x i16> <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>, <16 x i16> <i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1>
  %t5 = select <16 x i1> %t3, <16 x i16> %a2, <16 x i16> %a1
  %t6 = select <16 x i1> %t3, <16 x i16> %a1, <16 x i16> %a2
  %t7 = sub <16 x i16> %t6, %t5
  %t16 = lshr <16 x i16> %t7, <i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1>
  %t9 = mul <16 x i16> %t16, %t4
  %a10 = add <16 x i16> %t9, %a1
  ret <16 x i16> %a10
}

; Values are loaded. Only check signed case.

define <16 x i16> @vec256_i16_signed_mem_reg(<16 x i16>* %a1_addr, <16 x i16> %a2) nounwind {
; AVX1-FALLBACK-LABEL: vec256_i16_signed_mem_reg:
; AVX1-FALLBACK:       # %bb.0:
; AVX1-FALLBACK-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-FALLBACK-NEXT:    vmovdqa (%rdi), %xmm2
; AVX1-FALLBACK-NEXT:    vmovdqa 16(%rdi), %xmm3
; AVX1-FALLBACK-NEXT:    vpcmpgtw %xmm1, %xmm3, %xmm4
; AVX1-FALLBACK-NEXT:    vpcmpgtw %xmm0, %xmm2, %xmm5
; AVX1-FALLBACK-NEXT:    vpminsw %xmm1, %xmm3, %xmm6
; AVX1-FALLBACK-NEXT:    vpminsw %xmm0, %xmm2, %xmm7
; AVX1-FALLBACK-NEXT:    vpmaxsw %xmm1, %xmm3, %xmm1
; AVX1-FALLBACK-NEXT:    vpsubw %xmm6, %xmm1, %xmm1
; AVX1-FALLBACK-NEXT:    vpmaxsw %xmm0, %xmm2, %xmm0
; AVX1-FALLBACK-NEXT:    vpsubw %xmm7, %xmm0, %xmm0
; AVX1-FALLBACK-NEXT:    vpsrlw $1, %xmm1, %xmm1
; AVX1-FALLBACK-NEXT:    vpsrlw $1, %xmm0, %xmm0
; AVX1-FALLBACK-NEXT:    vmovdqa {{.*#+}} xmm6 = [1,1,1,1,1,1,1,1]
; AVX1-FALLBACK-NEXT:    vpor %xmm6, %xmm5, %xmm5
; AVX1-FALLBACK-NEXT:    vpmullw %xmm5, %xmm0, %xmm0
; AVX1-FALLBACK-NEXT:    vpor %xmm6, %xmm4, %xmm4
; AVX1-FALLBACK-NEXT:    vpmullw %xmm4, %xmm1, %xmm1
; AVX1-FALLBACK-NEXT:    vpaddw %xmm3, %xmm1, %xmm1
; AVX1-FALLBACK-NEXT:    vpaddw %xmm2, %xmm0, %xmm0
; AVX1-FALLBACK-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-FALLBACK-NEXT:    retq
;
; AVX2-LABEL: vec256_i16_signed_mem_reg:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %ymm1
; AVX2-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm2
; AVX2-NEXT:    vpor {{.*}}(%rip), %ymm2, %ymm2
; AVX2-NEXT:    vpminsw %ymm0, %ymm1, %ymm3
; AVX2-NEXT:    vpmaxsw %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpsubw %ymm3, %ymm0, %ymm0
; AVX2-NEXT:    vpsrlw $1, %ymm0, %ymm0
; AVX2-NEXT:    vpmullw %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpaddw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; XOP-FALLBACK-LABEL: vec256_i16_signed_mem_reg:
; XOP-FALLBACK:       # %bb.0:
; XOP-FALLBACK-NEXT:    vextractf128 $1, %ymm0, %xmm1
; XOP-FALLBACK-NEXT:    vmovdqa (%rdi), %xmm2
; XOP-FALLBACK-NEXT:    vmovdqa 16(%rdi), %xmm3
; XOP-FALLBACK-NEXT:    vpcomgtw %xmm1, %xmm3, %xmm4
; XOP-FALLBACK-NEXT:    vpcomgtw %xmm0, %xmm2, %xmm5
; XOP-FALLBACK-NEXT:    vpminsw %xmm0, %xmm2, %xmm6
; XOP-FALLBACK-NEXT:    vpminsw %xmm1, %xmm3, %xmm7
; XOP-FALLBACK-NEXT:    vpmaxsw %xmm0, %xmm2, %xmm0
; XOP-FALLBACK-NEXT:    vpsubw %xmm6, %xmm0, %xmm0
; XOP-FALLBACK-NEXT:    vpmaxsw %xmm1, %xmm3, %xmm1
; XOP-FALLBACK-NEXT:    vpsubw %xmm7, %xmm1, %xmm1
; XOP-FALLBACK-NEXT:    vpsrlw $1, %xmm0, %xmm0
; XOP-FALLBACK-NEXT:    vpsrlw $1, %xmm1, %xmm1
; XOP-FALLBACK-NEXT:    vmovdqa {{.*#+}} xmm6 = [1,1,1,1,1,1,1,1]
; XOP-FALLBACK-NEXT:    vpor %xmm6, %xmm5, %xmm5
; XOP-FALLBACK-NEXT:    vpor %xmm6, %xmm4, %xmm4
; XOP-FALLBACK-NEXT:    vpmacsww %xmm3, %xmm4, %xmm1, %xmm1
; XOP-FALLBACK-NEXT:    vpmacsww %xmm2, %xmm5, %xmm0, %xmm0
; XOP-FALLBACK-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; XOP-FALLBACK-NEXT:    retq
;
; XOPAVX1-LABEL: vec256_i16_signed_mem_reg:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; XOPAVX1-NEXT:    vmovdqa (%rdi), %xmm2
; XOPAVX1-NEXT:    vmovdqa 16(%rdi), %xmm3
; XOPAVX1-NEXT:    vpcomgtw %xmm1, %xmm3, %xmm4
; XOPAVX1-NEXT:    vpcomgtw %xmm0, %xmm2, %xmm5
; XOPAVX1-NEXT:    vpminsw %xmm0, %xmm2, %xmm6
; XOPAVX1-NEXT:    vpminsw %xmm1, %xmm3, %xmm7
; XOPAVX1-NEXT:    vpmaxsw %xmm0, %xmm2, %xmm0
; XOPAVX1-NEXT:    vpsubw %xmm6, %xmm0, %xmm0
; XOPAVX1-NEXT:    vpmaxsw %xmm1, %xmm3, %xmm1
; XOPAVX1-NEXT:    vpsubw %xmm7, %xmm1, %xmm1
; XOPAVX1-NEXT:    vpsrlw $1, %xmm0, %xmm0
; XOPAVX1-NEXT:    vpsrlw $1, %xmm1, %xmm1
; XOPAVX1-NEXT:    vmovdqa {{.*#+}} xmm6 = [1,1,1,1,1,1,1,1]
; XOPAVX1-NEXT:    vpor %xmm6, %xmm5, %xmm5
; XOPAVX1-NEXT:    vpor %xmm6, %xmm4, %xmm4
; XOPAVX1-NEXT:    vpmacsww %xmm3, %xmm4, %xmm1, %xmm1
; XOPAVX1-NEXT:    vpmacsww %xmm2, %xmm5, %xmm0, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; XOPAVX1-NEXT:    retq
;
; AVX512F-LABEL: vec256_i16_signed_mem_reg:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vmovdqa (%rdi), %ymm1
; AVX512F-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm2
; AVX512F-NEXT:    vpor {{.*}}(%rip), %ymm2, %ymm2
; AVX512F-NEXT:    vpminsw %ymm0, %ymm1, %ymm3
; AVX512F-NEXT:    vpmaxsw %ymm0, %ymm1, %ymm0
; AVX512F-NEXT:    vpsubw %ymm3, %ymm0, %ymm0
; AVX512F-NEXT:    vpsrlw $1, %ymm0, %ymm0
; AVX512F-NEXT:    vpmullw %ymm2, %ymm0, %ymm0
; AVX512F-NEXT:    vpaddw %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-FALLBACK-LABEL: vec256_i16_signed_mem_reg:
; AVX512VL-FALLBACK:       # %bb.0:
; AVX512VL-FALLBACK-NEXT:    vmovdqa (%rdi), %ymm1
; AVX512VL-FALLBACK-NEXT:    vpcmpgtw %ymm0, %ymm1, %ymm2
; AVX512VL-FALLBACK-NEXT:    vpor {{.*}}(%rip), %ymm2, %ymm2
; AVX512VL-FALLBACK-NEXT:    vpminsw %ymm0, %ymm1, %ymm3
; AVX512VL-FALLBACK-NEXT:    vpmaxsw %ymm0, %ymm1, %ymm0
; AVX512VL-FALLBACK-NEXT:    vpsubw %ymm3, %ymm0, %ymm0
; AVX512VL-FALLBACK-NEXT:    vpsrlw $1, %ymm0, %ymm0
; AVX512VL-FALLBACK-NEXT:    vpmullw %ymm2, %ymm0, %ymm0
; AVX512VL-FALLBACK-NEXT:    vpaddw %ymm1, %ymm0, %ymm0
; AVX512VL-FALLBACK-NEXT:    retq
;
; AVX512BW-FALLBACK-LABEL: vec256_i16_signed_mem_reg:
; AVX512BW-FALLBACK:       # %bb.0:
; AVX512BW-FALLBACK-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-FALLBACK-NEXT:    vmovdqa (%rdi), %ymm1
; AVX512BW-FALLBACK-NEXT:    vpcmpgtw %zmm0, %zmm1, %k1
; AVX512BW-FALLBACK-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512BW-FALLBACK-NEXT:    vmovdqa {{.*#+}} ymm3 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; AVX512BW-FALLBACK-NEXT:    vmovdqu16 %zmm2, %zmm3 {%k1}
; AVX512BW-FALLBACK-NEXT:    vpminsw %ymm0, %ymm1, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpmaxsw %ymm0, %ymm1, %ymm0
; AVX512BW-FALLBACK-NEXT:    vpsubw %ymm2, %ymm0, %ymm0
; AVX512BW-FALLBACK-NEXT:    vpsrlw $1, %ymm0, %ymm0
; AVX512BW-FALLBACK-NEXT:    vpmullw %ymm3, %ymm0, %ymm0
; AVX512BW-FALLBACK-NEXT:    vpaddw %ymm1, %ymm0, %ymm0
; AVX512BW-FALLBACK-NEXT:    retq
;
; AVX512VLBW-LABEL: vec256_i16_signed_mem_reg:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vmovdqa (%rdi), %ymm1
; AVX512VLBW-NEXT:    vpcmpgtw %ymm0, %ymm1, %k1
; AVX512VLBW-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512VLBW-NEXT:    vmovdqa {{.*#+}} ymm3 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; AVX512VLBW-NEXT:    vmovdqu16 %ymm2, %ymm3 {%k1}
; AVX512VLBW-NEXT:    vpminsw %ymm0, %ymm1, %ymm2
; AVX512VLBW-NEXT:    vpmaxsw %ymm0, %ymm1, %ymm0
; AVX512VLBW-NEXT:    vpsubw %ymm2, %ymm0, %ymm0
; AVX512VLBW-NEXT:    vpsrlw $1, %ymm0, %ymm0
; AVX512VLBW-NEXT:    vpmullw %ymm3, %ymm0, %ymm0
; AVX512VLBW-NEXT:    vpaddw %ymm1, %ymm0, %ymm0
; AVX512VLBW-NEXT:    retq
  %a1 = load <16 x i16>, <16 x i16>* %a1_addr
  %t3 = icmp sgt <16 x i16> %a1, %a2 ; signed
  %t4 = select <16 x i1> %t3, <16 x i16> <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>, <16 x i16> <i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1>
  %t5 = select <16 x i1> %t3, <16 x i16> %a2, <16 x i16> %a1
  %t6 = select <16 x i1> %t3, <16 x i16> %a1, <16 x i16> %a2
  %t7 = sub <16 x i16> %t6, %t5
  %t16 = lshr <16 x i16> %t7, <i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1>
  %t9 = mul nsw <16 x i16> %t16, %t4 ; signed
  %a10 = add nsw <16 x i16> %t9, %a1 ; signed
  ret <16 x i16> %a10
}

define <16 x i16> @vec256_i16_signed_reg_mem(<16 x i16> %a1, <16 x i16>* %a2_addr) nounwind {
; AVX1-FALLBACK-LABEL: vec256_i16_signed_reg_mem:
; AVX1-FALLBACK:       # %bb.0:
; AVX1-FALLBACK-NEXT:    vmovdqa (%rdi), %xmm1
; AVX1-FALLBACK-NEXT:    vmovdqa 16(%rdi), %xmm2
; AVX1-FALLBACK-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-FALLBACK-NEXT:    vpcmpgtw %xmm2, %xmm3, %xmm4
; AVX1-FALLBACK-NEXT:    vpcmpgtw %xmm1, %xmm0, %xmm5
; AVX1-FALLBACK-NEXT:    vpminsw %xmm2, %xmm3, %xmm6
; AVX1-FALLBACK-NEXT:    vpminsw %xmm1, %xmm0, %xmm7
; AVX1-FALLBACK-NEXT:    vpmaxsw %xmm2, %xmm3, %xmm2
; AVX1-FALLBACK-NEXT:    vpsubw %xmm6, %xmm2, %xmm2
; AVX1-FALLBACK-NEXT:    vpmaxsw %xmm1, %xmm0, %xmm1
; AVX1-FALLBACK-NEXT:    vpsubw %xmm7, %xmm1, %xmm1
; AVX1-FALLBACK-NEXT:    vpsrlw $1, %xmm2, %xmm2
; AVX1-FALLBACK-NEXT:    vpsrlw $1, %xmm1, %xmm1
; AVX1-FALLBACK-NEXT:    vmovdqa {{.*#+}} xmm6 = [1,1,1,1,1,1,1,1]
; AVX1-FALLBACK-NEXT:    vpor %xmm6, %xmm5, %xmm5
; AVX1-FALLBACK-NEXT:    vpmullw %xmm5, %xmm1, %xmm1
; AVX1-FALLBACK-NEXT:    vpor %xmm6, %xmm4, %xmm4
; AVX1-FALLBACK-NEXT:    vpmullw %xmm4, %xmm2, %xmm2
; AVX1-FALLBACK-NEXT:    vpaddw %xmm3, %xmm2, %xmm2
; AVX1-FALLBACK-NEXT:    vpaddw %xmm0, %xmm1, %xmm0
; AVX1-FALLBACK-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-FALLBACK-NEXT:    retq
;
; AVX2-LABEL: vec256_i16_signed_reg_mem:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %ymm1
; AVX2-NEXT:    vpcmpgtw %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vpor {{.*}}(%rip), %ymm2, %ymm2
; AVX2-NEXT:    vpminsw %ymm1, %ymm0, %ymm3
; AVX2-NEXT:    vpmaxsw %ymm1, %ymm0, %ymm1
; AVX2-NEXT:    vpsubw %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX2-NEXT:    vpmullw %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpaddw %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; XOP-FALLBACK-LABEL: vec256_i16_signed_reg_mem:
; XOP-FALLBACK:       # %bb.0:
; XOP-FALLBACK-NEXT:    vmovdqa (%rdi), %xmm1
; XOP-FALLBACK-NEXT:    vmovdqa 16(%rdi), %xmm2
; XOP-FALLBACK-NEXT:    vextractf128 $1, %ymm0, %xmm3
; XOP-FALLBACK-NEXT:    vpcomgtw %xmm2, %xmm3, %xmm4
; XOP-FALLBACK-NEXT:    vpcomgtw %xmm1, %xmm0, %xmm5
; XOP-FALLBACK-NEXT:    vpminsw %xmm1, %xmm0, %xmm6
; XOP-FALLBACK-NEXT:    vpminsw %xmm2, %xmm3, %xmm7
; XOP-FALLBACK-NEXT:    vpmaxsw %xmm1, %xmm0, %xmm1
; XOP-FALLBACK-NEXT:    vpsubw %xmm6, %xmm1, %xmm1
; XOP-FALLBACK-NEXT:    vpmaxsw %xmm2, %xmm3, %xmm2
; XOP-FALLBACK-NEXT:    vpsubw %xmm7, %xmm2, %xmm2
; XOP-FALLBACK-NEXT:    vpsrlw $1, %xmm1, %xmm1
; XOP-FALLBACK-NEXT:    vpsrlw $1, %xmm2, %xmm2
; XOP-FALLBACK-NEXT:    vmovdqa {{.*#+}} xmm6 = [1,1,1,1,1,1,1,1]
; XOP-FALLBACK-NEXT:    vpor %xmm6, %xmm5, %xmm5
; XOP-FALLBACK-NEXT:    vpor %xmm6, %xmm4, %xmm4
; XOP-FALLBACK-NEXT:    vpmacsww %xmm3, %xmm4, %xmm2, %xmm2
; XOP-FALLBACK-NEXT:    vpmacsww %xmm0, %xmm5, %xmm1, %xmm0
; XOP-FALLBACK-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOP-FALLBACK-NEXT:    retq
;
; XOPAVX1-LABEL: vec256_i16_signed_reg_mem:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vmovdqa (%rdi), %xmm1
; XOPAVX1-NEXT:    vmovdqa 16(%rdi), %xmm2
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; XOPAVX1-NEXT:    vpcomgtw %xmm2, %xmm3, %xmm4
; XOPAVX1-NEXT:    vpcomgtw %xmm1, %xmm0, %xmm5
; XOPAVX1-NEXT:    vpminsw %xmm1, %xmm0, %xmm6
; XOPAVX1-NEXT:    vpminsw %xmm2, %xmm3, %xmm7
; XOPAVX1-NEXT:    vpmaxsw %xmm1, %xmm0, %xmm1
; XOPAVX1-NEXT:    vpsubw %xmm6, %xmm1, %xmm1
; XOPAVX1-NEXT:    vpmaxsw %xmm2, %xmm3, %xmm2
; XOPAVX1-NEXT:    vpsubw %xmm7, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpsrlw $1, %xmm1, %xmm1
; XOPAVX1-NEXT:    vpsrlw $1, %xmm2, %xmm2
; XOPAVX1-NEXT:    vmovdqa {{.*#+}} xmm6 = [1,1,1,1,1,1,1,1]
; XOPAVX1-NEXT:    vpor %xmm6, %xmm5, %xmm5
; XOPAVX1-NEXT:    vpor %xmm6, %xmm4, %xmm4
; XOPAVX1-NEXT:    vpmacsww %xmm3, %xmm4, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpmacsww %xmm0, %xmm5, %xmm1, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOPAVX1-NEXT:    retq
;
; AVX512F-LABEL: vec256_i16_signed_reg_mem:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vmovdqa (%rdi), %ymm1
; AVX512F-NEXT:    vpcmpgtw %ymm1, %ymm0, %ymm2
; AVX512F-NEXT:    vpor {{.*}}(%rip), %ymm2, %ymm2
; AVX512F-NEXT:    vpminsw %ymm1, %ymm0, %ymm3
; AVX512F-NEXT:    vpmaxsw %ymm1, %ymm0, %ymm1
; AVX512F-NEXT:    vpsubw %ymm3, %ymm1, %ymm1
; AVX512F-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512F-NEXT:    vpmullw %ymm2, %ymm1, %ymm1
; AVX512F-NEXT:    vpaddw %ymm0, %ymm1, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-FALLBACK-LABEL: vec256_i16_signed_reg_mem:
; AVX512VL-FALLBACK:       # %bb.0:
; AVX512VL-FALLBACK-NEXT:    vmovdqa (%rdi), %ymm1
; AVX512VL-FALLBACK-NEXT:    vpcmpgtw %ymm1, %ymm0, %ymm2
; AVX512VL-FALLBACK-NEXT:    vpor {{.*}}(%rip), %ymm2, %ymm2
; AVX512VL-FALLBACK-NEXT:    vpminsw %ymm1, %ymm0, %ymm3
; AVX512VL-FALLBACK-NEXT:    vpmaxsw %ymm1, %ymm0, %ymm1
; AVX512VL-FALLBACK-NEXT:    vpsubw %ymm3, %ymm1, %ymm1
; AVX512VL-FALLBACK-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512VL-FALLBACK-NEXT:    vpmullw %ymm2, %ymm1, %ymm1
; AVX512VL-FALLBACK-NEXT:    vpaddw %ymm0, %ymm1, %ymm0
; AVX512VL-FALLBACK-NEXT:    retq
;
; AVX512BW-FALLBACK-LABEL: vec256_i16_signed_reg_mem:
; AVX512BW-FALLBACK:       # %bb.0:
; AVX512BW-FALLBACK-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-FALLBACK-NEXT:    vmovdqa (%rdi), %ymm1
; AVX512BW-FALLBACK-NEXT:    vpcmpgtw %zmm1, %zmm0, %k1
; AVX512BW-FALLBACK-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512BW-FALLBACK-NEXT:    vmovdqa {{.*#+}} ymm3 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; AVX512BW-FALLBACK-NEXT:    vmovdqu16 %zmm2, %zmm3 {%k1}
; AVX512BW-FALLBACK-NEXT:    vpminsw %ymm1, %ymm0, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpmaxsw %ymm1, %ymm0, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpsubw %ymm2, %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpmullw %ymm3, %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpaddw %ymm0, %ymm1, %ymm0
; AVX512BW-FALLBACK-NEXT:    retq
;
; AVX512VLBW-LABEL: vec256_i16_signed_reg_mem:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vmovdqa (%rdi), %ymm1
; AVX512VLBW-NEXT:    vpcmpgtw %ymm1, %ymm0, %k1
; AVX512VLBW-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512VLBW-NEXT:    vmovdqa {{.*#+}} ymm3 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; AVX512VLBW-NEXT:    vmovdqu16 %ymm2, %ymm3 {%k1}
; AVX512VLBW-NEXT:    vpminsw %ymm1, %ymm0, %ymm2
; AVX512VLBW-NEXT:    vpmaxsw %ymm1, %ymm0, %ymm1
; AVX512VLBW-NEXT:    vpsubw %ymm2, %ymm1, %ymm1
; AVX512VLBW-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512VLBW-NEXT:    vpmullw %ymm3, %ymm1, %ymm1
; AVX512VLBW-NEXT:    vpaddw %ymm0, %ymm1, %ymm0
; AVX512VLBW-NEXT:    retq
  %a2 = load <16 x i16>, <16 x i16>* %a2_addr
  %t3 = icmp sgt <16 x i16> %a1, %a2 ; signed
  %t4 = select <16 x i1> %t3, <16 x i16> <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>, <16 x i16> <i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1>
  %t5 = select <16 x i1> %t3, <16 x i16> %a2, <16 x i16> %a1
  %t6 = select <16 x i1> %t3, <16 x i16> %a1, <16 x i16> %a2
  %t7 = sub <16 x i16> %t6, %t5
  %t16 = lshr <16 x i16> %t7, <i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1>
  %t9 = mul nsw <16 x i16> %t16, %t4 ; signed
  %a10 = add nsw <16 x i16> %t9, %a1 ; signed
  ret <16 x i16> %a10
}

define <16 x i16> @vec256_i16_signed_mem_mem(<16 x i16>* %a1_addr, <16 x i16>* %a2_addr) nounwind {
; AVX1-FALLBACK-LABEL: vec256_i16_signed_mem_mem:
; AVX1-FALLBACK:       # %bb.0:
; AVX1-FALLBACK-NEXT:    vmovdqa (%rsi), %xmm0
; AVX1-FALLBACK-NEXT:    vmovdqa 16(%rsi), %xmm1
; AVX1-FALLBACK-NEXT:    vmovdqa (%rdi), %xmm2
; AVX1-FALLBACK-NEXT:    vmovdqa 16(%rdi), %xmm3
; AVX1-FALLBACK-NEXT:    vpcmpgtw %xmm1, %xmm3, %xmm4
; AVX1-FALLBACK-NEXT:    vpcmpgtw %xmm0, %xmm2, %xmm5
; AVX1-FALLBACK-NEXT:    vpminsw %xmm1, %xmm3, %xmm6
; AVX1-FALLBACK-NEXT:    vpminsw %xmm0, %xmm2, %xmm7
; AVX1-FALLBACK-NEXT:    vpmaxsw %xmm1, %xmm3, %xmm1
; AVX1-FALLBACK-NEXT:    vpsubw %xmm6, %xmm1, %xmm1
; AVX1-FALLBACK-NEXT:    vpmaxsw %xmm0, %xmm2, %xmm0
; AVX1-FALLBACK-NEXT:    vpsubw %xmm7, %xmm0, %xmm0
; AVX1-FALLBACK-NEXT:    vpsrlw $1, %xmm1, %xmm1
; AVX1-FALLBACK-NEXT:    vpsrlw $1, %xmm0, %xmm0
; AVX1-FALLBACK-NEXT:    vmovdqa {{.*#+}} xmm6 = [1,1,1,1,1,1,1,1]
; AVX1-FALLBACK-NEXT:    vpor %xmm6, %xmm5, %xmm5
; AVX1-FALLBACK-NEXT:    vpmullw %xmm5, %xmm0, %xmm0
; AVX1-FALLBACK-NEXT:    vpor %xmm6, %xmm4, %xmm4
; AVX1-FALLBACK-NEXT:    vpmullw %xmm4, %xmm1, %xmm1
; AVX1-FALLBACK-NEXT:    vpaddw %xmm3, %xmm1, %xmm1
; AVX1-FALLBACK-NEXT:    vpaddw %xmm2, %xmm0, %xmm0
; AVX1-FALLBACK-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-FALLBACK-NEXT:    retq
;
; AVX2-LABEL: vec256_i16_signed_mem_mem:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %ymm0
; AVX2-NEXT:    vmovdqa (%rsi), %ymm1
; AVX2-NEXT:    vpcmpgtw %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vpor {{.*}}(%rip), %ymm2, %ymm2
; AVX2-NEXT:    vpminsw %ymm1, %ymm0, %ymm3
; AVX2-NEXT:    vpmaxsw %ymm1, %ymm0, %ymm1
; AVX2-NEXT:    vpsubw %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX2-NEXT:    vpmullw %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpaddw %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; XOP-FALLBACK-LABEL: vec256_i16_signed_mem_mem:
; XOP-FALLBACK:       # %bb.0:
; XOP-FALLBACK-NEXT:    vmovdqa (%rsi), %xmm0
; XOP-FALLBACK-NEXT:    vmovdqa 16(%rsi), %xmm1
; XOP-FALLBACK-NEXT:    vmovdqa (%rdi), %xmm2
; XOP-FALLBACK-NEXT:    vmovdqa 16(%rdi), %xmm3
; XOP-FALLBACK-NEXT:    vpcomgtw %xmm1, %xmm3, %xmm4
; XOP-FALLBACK-NEXT:    vpcomgtw %xmm0, %xmm2, %xmm5
; XOP-FALLBACK-NEXT:    vpminsw %xmm0, %xmm2, %xmm6
; XOP-FALLBACK-NEXT:    vpminsw %xmm1, %xmm3, %xmm7
; XOP-FALLBACK-NEXT:    vpmaxsw %xmm0, %xmm2, %xmm0
; XOP-FALLBACK-NEXT:    vpsubw %xmm6, %xmm0, %xmm0
; XOP-FALLBACK-NEXT:    vpmaxsw %xmm1, %xmm3, %xmm1
; XOP-FALLBACK-NEXT:    vpsubw %xmm7, %xmm1, %xmm1
; XOP-FALLBACK-NEXT:    vpsrlw $1, %xmm0, %xmm0
; XOP-FALLBACK-NEXT:    vpsrlw $1, %xmm1, %xmm1
; XOP-FALLBACK-NEXT:    vmovdqa {{.*#+}} xmm6 = [1,1,1,1,1,1,1,1]
; XOP-FALLBACK-NEXT:    vpor %xmm6, %xmm5, %xmm5
; XOP-FALLBACK-NEXT:    vpor %xmm6, %xmm4, %xmm4
; XOP-FALLBACK-NEXT:    vpmacsww %xmm3, %xmm4, %xmm1, %xmm1
; XOP-FALLBACK-NEXT:    vpmacsww %xmm2, %xmm5, %xmm0, %xmm0
; XOP-FALLBACK-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; XOP-FALLBACK-NEXT:    retq
;
; XOPAVX1-LABEL: vec256_i16_signed_mem_mem:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vmovdqa (%rsi), %xmm0
; XOPAVX1-NEXT:    vmovdqa 16(%rsi), %xmm1
; XOPAVX1-NEXT:    vmovdqa (%rdi), %xmm2
; XOPAVX1-NEXT:    vmovdqa 16(%rdi), %xmm3
; XOPAVX1-NEXT:    vpcomgtw %xmm1, %xmm3, %xmm4
; XOPAVX1-NEXT:    vpcomgtw %xmm0, %xmm2, %xmm5
; XOPAVX1-NEXT:    vpminsw %xmm0, %xmm2, %xmm6
; XOPAVX1-NEXT:    vpminsw %xmm1, %xmm3, %xmm7
; XOPAVX1-NEXT:    vpmaxsw %xmm0, %xmm2, %xmm0
; XOPAVX1-NEXT:    vpsubw %xmm6, %xmm0, %xmm0
; XOPAVX1-NEXT:    vpmaxsw %xmm1, %xmm3, %xmm1
; XOPAVX1-NEXT:    vpsubw %xmm7, %xmm1, %xmm1
; XOPAVX1-NEXT:    vpsrlw $1, %xmm0, %xmm0
; XOPAVX1-NEXT:    vpsrlw $1, %xmm1, %xmm1
; XOPAVX1-NEXT:    vmovdqa {{.*#+}} xmm6 = [1,1,1,1,1,1,1,1]
; XOPAVX1-NEXT:    vpor %xmm6, %xmm5, %xmm5
; XOPAVX1-NEXT:    vpor %xmm6, %xmm4, %xmm4
; XOPAVX1-NEXT:    vpmacsww %xmm3, %xmm4, %xmm1, %xmm1
; XOPAVX1-NEXT:    vpmacsww %xmm2, %xmm5, %xmm0, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; XOPAVX1-NEXT:    retq
;
; AVX512F-LABEL: vec256_i16_signed_mem_mem:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512F-NEXT:    vmovdqa (%rsi), %ymm1
; AVX512F-NEXT:    vpcmpgtw %ymm1, %ymm0, %ymm2
; AVX512F-NEXT:    vpor {{.*}}(%rip), %ymm2, %ymm2
; AVX512F-NEXT:    vpminsw %ymm1, %ymm0, %ymm3
; AVX512F-NEXT:    vpmaxsw %ymm1, %ymm0, %ymm1
; AVX512F-NEXT:    vpsubw %ymm3, %ymm1, %ymm1
; AVX512F-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512F-NEXT:    vpmullw %ymm2, %ymm1, %ymm1
; AVX512F-NEXT:    vpaddw %ymm0, %ymm1, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-FALLBACK-LABEL: vec256_i16_signed_mem_mem:
; AVX512VL-FALLBACK:       # %bb.0:
; AVX512VL-FALLBACK-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512VL-FALLBACK-NEXT:    vmovdqa (%rsi), %ymm1
; AVX512VL-FALLBACK-NEXT:    vpcmpgtw %ymm1, %ymm0, %ymm2
; AVX512VL-FALLBACK-NEXT:    vpor {{.*}}(%rip), %ymm2, %ymm2
; AVX512VL-FALLBACK-NEXT:    vpminsw %ymm1, %ymm0, %ymm3
; AVX512VL-FALLBACK-NEXT:    vpmaxsw %ymm1, %ymm0, %ymm1
; AVX512VL-FALLBACK-NEXT:    vpsubw %ymm3, %ymm1, %ymm1
; AVX512VL-FALLBACK-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512VL-FALLBACK-NEXT:    vpmullw %ymm2, %ymm1, %ymm1
; AVX512VL-FALLBACK-NEXT:    vpaddw %ymm0, %ymm1, %ymm0
; AVX512VL-FALLBACK-NEXT:    retq
;
; AVX512BW-FALLBACK-LABEL: vec256_i16_signed_mem_mem:
; AVX512BW-FALLBACK:       # %bb.0:
; AVX512BW-FALLBACK-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512BW-FALLBACK-NEXT:    vmovdqa (%rsi), %ymm1
; AVX512BW-FALLBACK-NEXT:    vpcmpgtw %zmm1, %zmm0, %k1
; AVX512BW-FALLBACK-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512BW-FALLBACK-NEXT:    vmovdqa {{.*#+}} ymm3 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; AVX512BW-FALLBACK-NEXT:    vmovdqu16 %zmm2, %zmm3 {%k1}
; AVX512BW-FALLBACK-NEXT:    vpminsw %ymm1, %ymm0, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpmaxsw %ymm1, %ymm0, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpsubw %ymm2, %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpmullw %ymm3, %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpaddw %ymm0, %ymm1, %ymm0
; AVX512BW-FALLBACK-NEXT:    retq
;
; AVX512VLBW-LABEL: vec256_i16_signed_mem_mem:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512VLBW-NEXT:    vmovdqa (%rsi), %ymm1
; AVX512VLBW-NEXT:    vpcmpgtw %ymm1, %ymm0, %k1
; AVX512VLBW-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512VLBW-NEXT:    vmovdqa {{.*#+}} ymm3 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; AVX512VLBW-NEXT:    vmovdqu16 %ymm2, %ymm3 {%k1}
; AVX512VLBW-NEXT:    vpminsw %ymm1, %ymm0, %ymm2
; AVX512VLBW-NEXT:    vpmaxsw %ymm1, %ymm0, %ymm1
; AVX512VLBW-NEXT:    vpsubw %ymm2, %ymm1, %ymm1
; AVX512VLBW-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512VLBW-NEXT:    vpmullw %ymm3, %ymm1, %ymm1
; AVX512VLBW-NEXT:    vpaddw %ymm0, %ymm1, %ymm0
; AVX512VLBW-NEXT:    retq
  %a1 = load <16 x i16>, <16 x i16>* %a1_addr
  %a2 = load <16 x i16>, <16 x i16>* %a2_addr
  %t3 = icmp sgt <16 x i16> %a1, %a2 ; signed
  %t4 = select <16 x i1> %t3, <16 x i16> <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>, <16 x i16> <i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1>
  %t5 = select <16 x i1> %t3, <16 x i16> %a2, <16 x i16> %a1
  %t6 = select <16 x i1> %t3, <16 x i16> %a1, <16 x i16> %a2
  %t7 = sub <16 x i16> %t6, %t5
  %t16 = lshr <16 x i16> %t7, <i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1>
  %t9 = mul nsw <16 x i16> %t16, %t4 ; signed
  %a10 = add nsw <16 x i16> %t9, %a1 ; signed
  ret <16 x i16> %a10
}

; ---------------------------------------------------------------------------- ;
; 8-bit width. 256 / 8 = 32 elts.
; ---------------------------------------------------------------------------- ;

; Values come from regs

define <32 x i8> @vec256_i8_signed_reg_reg(<32 x i8> %a1, <32 x i8> %a2) nounwind {
; AVX1-FALLBACK-LABEL: vec256_i8_signed_reg_reg:
; AVX1-FALLBACK:       # %bb.0:
; AVX1-FALLBACK-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-FALLBACK-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-FALLBACK-NEXT:    vpcmpgtb %xmm3, %xmm2, %xmm8
; AVX1-FALLBACK-NEXT:    vpcmpgtb %xmm1, %xmm0, %xmm5
; AVX1-FALLBACK-NEXT:    vpminsb %xmm3, %xmm2, %xmm6
; AVX1-FALLBACK-NEXT:    vpminsb %xmm1, %xmm0, %xmm7
; AVX1-FALLBACK-NEXT:    vpmaxsb %xmm3, %xmm2, %xmm3
; AVX1-FALLBACK-NEXT:    vpsubb %xmm6, %xmm3, %xmm3
; AVX1-FALLBACK-NEXT:    vpmaxsb %xmm1, %xmm0, %xmm1
; AVX1-FALLBACK-NEXT:    vpsubb %xmm7, %xmm1, %xmm1
; AVX1-FALLBACK-NEXT:    vpsrlw $1, %xmm3, %xmm3
; AVX1-FALLBACK-NEXT:    vmovdqa {{.*#+}} xmm6 = [127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127]
; AVX1-FALLBACK-NEXT:    vpand %xmm6, %xmm3, %xmm3
; AVX1-FALLBACK-NEXT:    vpsrlw $1, %xmm1, %xmm1
; AVX1-FALLBACK-NEXT:    vpand %xmm6, %xmm1, %xmm1
; AVX1-FALLBACK-NEXT:    vpunpckhbw {{.*#+}} xmm6 = xmm1[8],xmm0[8],xmm1[9],xmm0[9],xmm1[10],xmm0[10],xmm1[11],xmm0[11],xmm1[12],xmm0[12],xmm1[13],xmm0[13],xmm1[14],xmm0[14],xmm1[15],xmm0[15]
; AVX1-FALLBACK-NEXT:    vmovdqa {{.*#+}} xmm7 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; AVX1-FALLBACK-NEXT:    vpor %xmm7, %xmm5, %xmm5
; AVX1-FALLBACK-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm5[8],xmm0[8],xmm5[9],xmm0[9],xmm5[10],xmm0[10],xmm5[11],xmm0[11],xmm5[12],xmm0[12],xmm5[13],xmm0[13],xmm5[14],xmm0[14],xmm5[15],xmm0[15]
; AVX1-FALLBACK-NEXT:    vpmullw %xmm4, %xmm6, %xmm4
; AVX1-FALLBACK-NEXT:    vmovdqa {{.*#+}} xmm6 = [255,255,255,255,255,255,255,255]
; AVX1-FALLBACK-NEXT:    vpand %xmm6, %xmm4, %xmm4
; AVX1-FALLBACK-NEXT:    vpmovzxbw {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero,xmm1[4],zero,xmm1[5],zero,xmm1[6],zero,xmm1[7],zero
; AVX1-FALLBACK-NEXT:    vpmovzxbw {{.*#+}} xmm5 = xmm5[0],zero,xmm5[1],zero,xmm5[2],zero,xmm5[3],zero,xmm5[4],zero,xmm5[5],zero,xmm5[6],zero,xmm5[7],zero
; AVX1-FALLBACK-NEXT:    vpmullw %xmm5, %xmm1, %xmm1
; AVX1-FALLBACK-NEXT:    vpand %xmm6, %xmm1, %xmm1
; AVX1-FALLBACK-NEXT:    vpackuswb %xmm4, %xmm1, %xmm1
; AVX1-FALLBACK-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm3[8],xmm0[8],xmm3[9],xmm0[9],xmm3[10],xmm0[10],xmm3[11],xmm0[11],xmm3[12],xmm0[12],xmm3[13],xmm0[13],xmm3[14],xmm0[14],xmm3[15],xmm0[15]
; AVX1-FALLBACK-NEXT:    vpor %xmm7, %xmm8, %xmm5
; AVX1-FALLBACK-NEXT:    vpunpckhbw {{.*#+}} xmm7 = xmm5[8],xmm0[8],xmm5[9],xmm0[9],xmm5[10],xmm0[10],xmm5[11],xmm0[11],xmm5[12],xmm0[12],xmm5[13],xmm0[13],xmm5[14],xmm0[14],xmm5[15],xmm0[15]
; AVX1-FALLBACK-NEXT:    vpmullw %xmm7, %xmm4, %xmm4
; AVX1-FALLBACK-NEXT:    vpand %xmm6, %xmm4, %xmm4
; AVX1-FALLBACK-NEXT:    vpmovzxbw {{.*#+}} xmm3 = xmm3[0],zero,xmm3[1],zero,xmm3[2],zero,xmm3[3],zero,xmm3[4],zero,xmm3[5],zero,xmm3[6],zero,xmm3[7],zero
; AVX1-FALLBACK-NEXT:    vpmovzxbw {{.*#+}} xmm5 = xmm5[0],zero,xmm5[1],zero,xmm5[2],zero,xmm5[3],zero,xmm5[4],zero,xmm5[5],zero,xmm5[6],zero,xmm5[7],zero
; AVX1-FALLBACK-NEXT:    vpmullw %xmm5, %xmm3, %xmm3
; AVX1-FALLBACK-NEXT:    vpand %xmm6, %xmm3, %xmm3
; AVX1-FALLBACK-NEXT:    vpackuswb %xmm4, %xmm3, %xmm3
; AVX1-FALLBACK-NEXT:    vpaddb %xmm2, %xmm3, %xmm2
; AVX1-FALLBACK-NEXT:    vpaddb %xmm0, %xmm1, %xmm0
; AVX1-FALLBACK-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-FALLBACK-NEXT:    retq
;
; AVX2-LABEL: vec256_i8_signed_reg_reg:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpgtb %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vpor {{.*}}(%rip), %ymm2, %ymm2
; AVX2-NEXT:    vpminsb %ymm1, %ymm0, %ymm3
; AVX2-NEXT:    vpmaxsb %ymm1, %ymm0, %ymm1
; AVX2-NEXT:    vpsubb %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX2-NEXT:    vpand {{.*}}(%rip), %ymm1, %ymm1
; AVX2-NEXT:    vpunpckhbw {{.*#+}} ymm3 = ymm1[8],ymm0[8],ymm1[9],ymm0[9],ymm1[10],ymm0[10],ymm1[11],ymm0[11],ymm1[12],ymm0[12],ymm1[13],ymm0[13],ymm1[14],ymm0[14],ymm1[15],ymm0[15],ymm1[24],ymm0[24],ymm1[25],ymm0[25],ymm1[26],ymm0[26],ymm1[27],ymm0[27],ymm1[28],ymm0[28],ymm1[29],ymm0[29],ymm1[30],ymm0[30],ymm1[31],ymm0[31]
; AVX2-NEXT:    vpunpckhbw {{.*#+}} ymm4 = ymm2[8],ymm0[8],ymm2[9],ymm0[9],ymm2[10],ymm0[10],ymm2[11],ymm0[11],ymm2[12],ymm0[12],ymm2[13],ymm0[13],ymm2[14],ymm0[14],ymm2[15],ymm0[15],ymm2[24],ymm0[24],ymm2[25],ymm0[25],ymm2[26],ymm0[26],ymm2[27],ymm0[27],ymm2[28],ymm0[28],ymm2[29],ymm0[29],ymm2[30],ymm0[30],ymm2[31],ymm0[31]
; AVX2-NEXT:    vpmullw %ymm4, %ymm3, %ymm3
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm4 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX2-NEXT:    vpand %ymm4, %ymm3, %ymm3
; AVX2-NEXT:    vpunpcklbw {{.*#+}} ymm1 = ymm1[0],ymm0[0],ymm1[1],ymm0[1],ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[4],ymm0[4],ymm1[5],ymm0[5],ymm1[6],ymm0[6],ymm1[7],ymm0[7],ymm1[16],ymm0[16],ymm1[17],ymm0[17],ymm1[18],ymm0[18],ymm1[19],ymm0[19],ymm1[20],ymm0[20],ymm1[21],ymm0[21],ymm1[22],ymm0[22],ymm1[23],ymm0[23]
; AVX2-NEXT:    vpunpcklbw {{.*#+}} ymm2 = ymm2[0],ymm0[0],ymm2[1],ymm0[1],ymm2[2],ymm0[2],ymm2[3],ymm0[3],ymm2[4],ymm0[4],ymm2[5],ymm0[5],ymm2[6],ymm0[6],ymm2[7],ymm0[7],ymm2[16],ymm0[16],ymm2[17],ymm0[17],ymm2[18],ymm0[18],ymm2[19],ymm0[19],ymm2[20],ymm0[20],ymm2[21],ymm0[21],ymm2[22],ymm0[22],ymm2[23],ymm0[23]
; AVX2-NEXT:    vpmullw %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpand %ymm4, %ymm1, %ymm1
; AVX2-NEXT:    vpackuswb %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; XOP-FALLBACK-LABEL: vec256_i8_signed_reg_reg:
; XOP-FALLBACK:       # %bb.0:
; XOP-FALLBACK-NEXT:    vextractf128 $1, %ymm1, %xmm2
; XOP-FALLBACK-NEXT:    vextractf128 $1, %ymm0, %xmm3
; XOP-FALLBACK-NEXT:    vpcomgtb %xmm2, %xmm3, %xmm8
; XOP-FALLBACK-NEXT:    vpcomgtb %xmm1, %xmm0, %xmm5
; XOP-FALLBACK-NEXT:    vpminsb %xmm2, %xmm3, %xmm6
; XOP-FALLBACK-NEXT:    vpminsb %xmm1, %xmm0, %xmm7
; XOP-FALLBACK-NEXT:    vpmaxsb %xmm2, %xmm3, %xmm2
; XOP-FALLBACK-NEXT:    vpsubb %xmm6, %xmm2, %xmm2
; XOP-FALLBACK-NEXT:    vpmaxsb %xmm1, %xmm0, %xmm1
; XOP-FALLBACK-NEXT:    vpsubb %xmm7, %xmm1, %xmm1
; XOP-FALLBACK-NEXT:    vpcmpeqd %xmm6, %xmm6, %xmm6
; XOP-FALLBACK-NEXT:    vpshlb %xmm6, %xmm2, %xmm2
; XOP-FALLBACK-NEXT:    vpshlb %xmm6, %xmm1, %xmm1
; XOP-FALLBACK-NEXT:    vpunpckhbw {{.*#+}} xmm6 = xmm1[8],xmm0[8],xmm1[9],xmm0[9],xmm1[10],xmm0[10],xmm1[11],xmm0[11],xmm1[12],xmm0[12],xmm1[13],xmm0[13],xmm1[14],xmm0[14],xmm1[15],xmm0[15]
; XOP-FALLBACK-NEXT:    vmovdqa {{.*#+}} xmm7 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; XOP-FALLBACK-NEXT:    vpor %xmm7, %xmm5, %xmm5
; XOP-FALLBACK-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm5[8],xmm0[8],xmm5[9],xmm0[9],xmm5[10],xmm0[10],xmm5[11],xmm0[11],xmm5[12],xmm0[12],xmm5[13],xmm0[13],xmm5[14],xmm0[14],xmm5[15],xmm0[15]
; XOP-FALLBACK-NEXT:    vpmullw %xmm4, %xmm6, %xmm4
; XOP-FALLBACK-NEXT:    vpmovzxbw {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero,xmm1[4],zero,xmm1[5],zero,xmm1[6],zero,xmm1[7],zero
; XOP-FALLBACK-NEXT:    vpmovzxbw {{.*#+}} xmm5 = xmm5[0],zero,xmm5[1],zero,xmm5[2],zero,xmm5[3],zero,xmm5[4],zero,xmm5[5],zero,xmm5[6],zero,xmm5[7],zero
; XOP-FALLBACK-NEXT:    vpmullw %xmm5, %xmm1, %xmm1
; XOP-FALLBACK-NEXT:    vmovdqa {{.*#+}} xmm5 = [0,2,4,6,8,10,12,14,16,18,20,22,24,26,28,30]
; XOP-FALLBACK-NEXT:    vpperm %xmm5, %xmm4, %xmm1, %xmm1
; XOP-FALLBACK-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm2[8],xmm0[8],xmm2[9],xmm0[9],xmm2[10],xmm0[10],xmm2[11],xmm0[11],xmm2[12],xmm0[12],xmm2[13],xmm0[13],xmm2[14],xmm0[14],xmm2[15],xmm0[15]
; XOP-FALLBACK-NEXT:    vpor %xmm7, %xmm8, %xmm6
; XOP-FALLBACK-NEXT:    vpunpckhbw {{.*#+}} xmm7 = xmm6[8],xmm0[8],xmm6[9],xmm0[9],xmm6[10],xmm0[10],xmm6[11],xmm0[11],xmm6[12],xmm0[12],xmm6[13],xmm0[13],xmm6[14],xmm0[14],xmm6[15],xmm0[15]
; XOP-FALLBACK-NEXT:    vpmullw %xmm7, %xmm4, %xmm4
; XOP-FALLBACK-NEXT:    vpmovzxbw {{.*#+}} xmm2 = xmm2[0],zero,xmm2[1],zero,xmm2[2],zero,xmm2[3],zero,xmm2[4],zero,xmm2[5],zero,xmm2[6],zero,xmm2[7],zero
; XOP-FALLBACK-NEXT:    vpmovzxbw {{.*#+}} xmm6 = xmm6[0],zero,xmm6[1],zero,xmm6[2],zero,xmm6[3],zero,xmm6[4],zero,xmm6[5],zero,xmm6[6],zero,xmm6[7],zero
; XOP-FALLBACK-NEXT:    vpmullw %xmm6, %xmm2, %xmm2
; XOP-FALLBACK-NEXT:    vpperm %xmm5, %xmm4, %xmm2, %xmm2
; XOP-FALLBACK-NEXT:    vpaddb %xmm3, %xmm2, %xmm2
; XOP-FALLBACK-NEXT:    vpaddb %xmm0, %xmm1, %xmm0
; XOP-FALLBACK-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOP-FALLBACK-NEXT:    retq
;
; XOPAVX1-LABEL: vec256_i8_signed_reg_reg:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; XOPAVX1-NEXT:    vpcomgtb %xmm2, %xmm3, %xmm8
; XOPAVX1-NEXT:    vpcomgtb %xmm1, %xmm0, %xmm5
; XOPAVX1-NEXT:    vpminsb %xmm2, %xmm3, %xmm6
; XOPAVX1-NEXT:    vpminsb %xmm1, %xmm0, %xmm7
; XOPAVX1-NEXT:    vpmaxsb %xmm2, %xmm3, %xmm2
; XOPAVX1-NEXT:    vpsubb %xmm6, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpmaxsb %xmm1, %xmm0, %xmm1
; XOPAVX1-NEXT:    vpsubb %xmm7, %xmm1, %xmm1
; XOPAVX1-NEXT:    vpcmpeqd %xmm6, %xmm6, %xmm6
; XOPAVX1-NEXT:    vpshlb %xmm6, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpshlb %xmm6, %xmm1, %xmm1
; XOPAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm6 = xmm1[8],xmm0[8],xmm1[9],xmm0[9],xmm1[10],xmm0[10],xmm1[11],xmm0[11],xmm1[12],xmm0[12],xmm1[13],xmm0[13],xmm1[14],xmm0[14],xmm1[15],xmm0[15]
; XOPAVX1-NEXT:    vmovdqa {{.*#+}} xmm7 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; XOPAVX1-NEXT:    vpor %xmm7, %xmm5, %xmm5
; XOPAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm5[8],xmm0[8],xmm5[9],xmm0[9],xmm5[10],xmm0[10],xmm5[11],xmm0[11],xmm5[12],xmm0[12],xmm5[13],xmm0[13],xmm5[14],xmm0[14],xmm5[15],xmm0[15]
; XOPAVX1-NEXT:    vpmullw %xmm4, %xmm6, %xmm4
; XOPAVX1-NEXT:    vpmovzxbw {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero,xmm1[4],zero,xmm1[5],zero,xmm1[6],zero,xmm1[7],zero
; XOPAVX1-NEXT:    vpmovzxbw {{.*#+}} xmm5 = xmm5[0],zero,xmm5[1],zero,xmm5[2],zero,xmm5[3],zero,xmm5[4],zero,xmm5[5],zero,xmm5[6],zero,xmm5[7],zero
; XOPAVX1-NEXT:    vpmullw %xmm5, %xmm1, %xmm1
; XOPAVX1-NEXT:    vmovdqa {{.*#+}} xmm5 = [0,2,4,6,8,10,12,14,16,18,20,22,24,26,28,30]
; XOPAVX1-NEXT:    vpperm %xmm5, %xmm4, %xmm1, %xmm1
; XOPAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm2[8],xmm0[8],xmm2[9],xmm0[9],xmm2[10],xmm0[10],xmm2[11],xmm0[11],xmm2[12],xmm0[12],xmm2[13],xmm0[13],xmm2[14],xmm0[14],xmm2[15],xmm0[15]
; XOPAVX1-NEXT:    vpor %xmm7, %xmm8, %xmm6
; XOPAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm7 = xmm6[8],xmm0[8],xmm6[9],xmm0[9],xmm6[10],xmm0[10],xmm6[11],xmm0[11],xmm6[12],xmm0[12],xmm6[13],xmm0[13],xmm6[14],xmm0[14],xmm6[15],xmm0[15]
; XOPAVX1-NEXT:    vpmullw %xmm7, %xmm4, %xmm4
; XOPAVX1-NEXT:    vpmovzxbw {{.*#+}} xmm2 = xmm2[0],zero,xmm2[1],zero,xmm2[2],zero,xmm2[3],zero,xmm2[4],zero,xmm2[5],zero,xmm2[6],zero,xmm2[7],zero
; XOPAVX1-NEXT:    vpmovzxbw {{.*#+}} xmm6 = xmm6[0],zero,xmm6[1],zero,xmm6[2],zero,xmm6[3],zero,xmm6[4],zero,xmm6[5],zero,xmm6[6],zero,xmm6[7],zero
; XOPAVX1-NEXT:    vpmullw %xmm6, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpperm %xmm5, %xmm4, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpaddb %xmm3, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpaddb %xmm0, %xmm1, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOPAVX1-NEXT:    retq
;
; AVX512F-LABEL: vec256_i8_signed_reg_reg:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpcmpgtb %ymm1, %ymm0, %ymm2
; AVX512F-NEXT:    vpor {{.*}}(%rip), %ymm2, %ymm2
; AVX512F-NEXT:    vpminsb %ymm1, %ymm0, %ymm3
; AVX512F-NEXT:    vpmaxsb %ymm1, %ymm0, %ymm1
; AVX512F-NEXT:    vpsubb %ymm3, %ymm1, %ymm1
; AVX512F-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512F-NEXT:    vpand {{.*}}(%rip), %ymm1, %ymm1
; AVX512F-NEXT:    vpunpckhbw {{.*#+}} ymm3 = ymm1[8],ymm0[8],ymm1[9],ymm0[9],ymm1[10],ymm0[10],ymm1[11],ymm0[11],ymm1[12],ymm0[12],ymm1[13],ymm0[13],ymm1[14],ymm0[14],ymm1[15],ymm0[15],ymm1[24],ymm0[24],ymm1[25],ymm0[25],ymm1[26],ymm0[26],ymm1[27],ymm0[27],ymm1[28],ymm0[28],ymm1[29],ymm0[29],ymm1[30],ymm0[30],ymm1[31],ymm0[31]
; AVX512F-NEXT:    vpunpckhbw {{.*#+}} ymm4 = ymm2[8],ymm0[8],ymm2[9],ymm0[9],ymm2[10],ymm0[10],ymm2[11],ymm0[11],ymm2[12],ymm0[12],ymm2[13],ymm0[13],ymm2[14],ymm0[14],ymm2[15],ymm0[15],ymm2[24],ymm0[24],ymm2[25],ymm0[25],ymm2[26],ymm0[26],ymm2[27],ymm0[27],ymm2[28],ymm0[28],ymm2[29],ymm0[29],ymm2[30],ymm0[30],ymm2[31],ymm0[31]
; AVX512F-NEXT:    vpmullw %ymm4, %ymm3, %ymm3
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm4 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-NEXT:    vpand %ymm4, %ymm3, %ymm3
; AVX512F-NEXT:    vpunpcklbw {{.*#+}} ymm1 = ymm1[0],ymm0[0],ymm1[1],ymm0[1],ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[4],ymm0[4],ymm1[5],ymm0[5],ymm1[6],ymm0[6],ymm1[7],ymm0[7],ymm1[16],ymm0[16],ymm1[17],ymm0[17],ymm1[18],ymm0[18],ymm1[19],ymm0[19],ymm1[20],ymm0[20],ymm1[21],ymm0[21],ymm1[22],ymm0[22],ymm1[23],ymm0[23]
; AVX512F-NEXT:    vpunpcklbw {{.*#+}} ymm2 = ymm2[0],ymm0[0],ymm2[1],ymm0[1],ymm2[2],ymm0[2],ymm2[3],ymm0[3],ymm2[4],ymm0[4],ymm2[5],ymm0[5],ymm2[6],ymm0[6],ymm2[7],ymm0[7],ymm2[16],ymm0[16],ymm2[17],ymm0[17],ymm2[18],ymm0[18],ymm2[19],ymm0[19],ymm2[20],ymm0[20],ymm2[21],ymm0[21],ymm2[22],ymm0[22],ymm2[23],ymm0[23]
; AVX512F-NEXT:    vpmullw %ymm2, %ymm1, %ymm1
; AVX512F-NEXT:    vpand %ymm4, %ymm1, %ymm1
; AVX512F-NEXT:    vpackuswb %ymm3, %ymm1, %ymm1
; AVX512F-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-FALLBACK-LABEL: vec256_i8_signed_reg_reg:
; AVX512VL-FALLBACK:       # %bb.0:
; AVX512VL-FALLBACK-NEXT:    vpcmpgtb %ymm1, %ymm0, %ymm2
; AVX512VL-FALLBACK-NEXT:    vpor {{.*}}(%rip), %ymm2, %ymm2
; AVX512VL-FALLBACK-NEXT:    vpminsb %ymm1, %ymm0, %ymm3
; AVX512VL-FALLBACK-NEXT:    vpmaxsb %ymm1, %ymm0, %ymm1
; AVX512VL-FALLBACK-NEXT:    vpsubb %ymm3, %ymm1, %ymm1
; AVX512VL-FALLBACK-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512VL-FALLBACK-NEXT:    vpand {{.*}}(%rip), %ymm1, %ymm1
; AVX512VL-FALLBACK-NEXT:    vpunpckhbw {{.*#+}} ymm3 = ymm1[8],ymm0[8],ymm1[9],ymm0[9],ymm1[10],ymm0[10],ymm1[11],ymm0[11],ymm1[12],ymm0[12],ymm1[13],ymm0[13],ymm1[14],ymm0[14],ymm1[15],ymm0[15],ymm1[24],ymm0[24],ymm1[25],ymm0[25],ymm1[26],ymm0[26],ymm1[27],ymm0[27],ymm1[28],ymm0[28],ymm1[29],ymm0[29],ymm1[30],ymm0[30],ymm1[31],ymm0[31]
; AVX512VL-FALLBACK-NEXT:    vpunpckhbw {{.*#+}} ymm4 = ymm2[8],ymm0[8],ymm2[9],ymm0[9],ymm2[10],ymm0[10],ymm2[11],ymm0[11],ymm2[12],ymm0[12],ymm2[13],ymm0[13],ymm2[14],ymm0[14],ymm2[15],ymm0[15],ymm2[24],ymm0[24],ymm2[25],ymm0[25],ymm2[26],ymm0[26],ymm2[27],ymm0[27],ymm2[28],ymm0[28],ymm2[29],ymm0[29],ymm2[30],ymm0[30],ymm2[31],ymm0[31]
; AVX512VL-FALLBACK-NEXT:    vpmullw %ymm4, %ymm3, %ymm3
; AVX512VL-FALLBACK-NEXT:    vmovdqa {{.*#+}} ymm4 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512VL-FALLBACK-NEXT:    vpand %ymm4, %ymm3, %ymm3
; AVX512VL-FALLBACK-NEXT:    vpunpcklbw {{.*#+}} ymm1 = ymm1[0],ymm0[0],ymm1[1],ymm0[1],ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[4],ymm0[4],ymm1[5],ymm0[5],ymm1[6],ymm0[6],ymm1[7],ymm0[7],ymm1[16],ymm0[16],ymm1[17],ymm0[17],ymm1[18],ymm0[18],ymm1[19],ymm0[19],ymm1[20],ymm0[20],ymm1[21],ymm0[21],ymm1[22],ymm0[22],ymm1[23],ymm0[23]
; AVX512VL-FALLBACK-NEXT:    vpunpcklbw {{.*#+}} ymm2 = ymm2[0],ymm0[0],ymm2[1],ymm0[1],ymm2[2],ymm0[2],ymm2[3],ymm0[3],ymm2[4],ymm0[4],ymm2[5],ymm0[5],ymm2[6],ymm0[6],ymm2[7],ymm0[7],ymm2[16],ymm0[16],ymm2[17],ymm0[17],ymm2[18],ymm0[18],ymm2[19],ymm0[19],ymm2[20],ymm0[20],ymm2[21],ymm0[21],ymm2[22],ymm0[22],ymm2[23],ymm0[23]
; AVX512VL-FALLBACK-NEXT:    vpmullw %ymm2, %ymm1, %ymm1
; AVX512VL-FALLBACK-NEXT:    vpand %ymm4, %ymm1, %ymm1
; AVX512VL-FALLBACK-NEXT:    vpackuswb %ymm3, %ymm1, %ymm1
; AVX512VL-FALLBACK-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX512VL-FALLBACK-NEXT:    retq
;
; AVX512BW-FALLBACK-LABEL: vec256_i8_signed_reg_reg:
; AVX512BW-FALLBACK:       # %bb.0:
; AVX512BW-FALLBACK-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512BW-FALLBACK-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-FALLBACK-NEXT:    vpcmpgtb %zmm1, %zmm0, %k1
; AVX512BW-FALLBACK-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512BW-FALLBACK-NEXT:    vmovdqa {{.*#+}} ymm3 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; AVX512BW-FALLBACK-NEXT:    vmovdqu8 %zmm2, %zmm3 {%k1}
; AVX512BW-FALLBACK-NEXT:    vpminsb %ymm1, %ymm0, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpmaxsb %ymm1, %ymm0, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpsubb %ymm2, %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpand {{.*}}(%rip), %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpmovzxbw {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero,ymm1[16],zero,ymm1[17],zero,ymm1[18],zero,ymm1[19],zero,ymm1[20],zero,ymm1[21],zero,ymm1[22],zero,ymm1[23],zero,ymm1[24],zero,ymm1[25],zero,ymm1[26],zero,ymm1[27],zero,ymm1[28],zero,ymm1[29],zero,ymm1[30],zero,ymm1[31],zero
; AVX512BW-FALLBACK-NEXT:    vpmovzxbw {{.*#+}} zmm2 = ymm3[0],zero,ymm3[1],zero,ymm3[2],zero,ymm3[3],zero,ymm3[4],zero,ymm3[5],zero,ymm3[6],zero,ymm3[7],zero,ymm3[8],zero,ymm3[9],zero,ymm3[10],zero,ymm3[11],zero,ymm3[12],zero,ymm3[13],zero,ymm3[14],zero,ymm3[15],zero,ymm3[16],zero,ymm3[17],zero,ymm3[18],zero,ymm3[19],zero,ymm3[20],zero,ymm3[21],zero,ymm3[22],zero,ymm3[23],zero,ymm3[24],zero,ymm3[25],zero,ymm3[26],zero,ymm3[27],zero,ymm3[28],zero,ymm3[29],zero,ymm3[30],zero,ymm3[31],zero
; AVX512BW-FALLBACK-NEXT:    vpmullw %zmm2, %zmm1, %zmm1
; AVX512BW-FALLBACK-NEXT:    vpmovwb %zmm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX512BW-FALLBACK-NEXT:    retq
;
; AVX512VLBW-LABEL: vec256_i8_signed_reg_reg:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpcmpgtb %ymm1, %ymm0, %k1
; AVX512VLBW-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512VLBW-NEXT:    vmovdqa {{.*#+}} ymm3 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; AVX512VLBW-NEXT:    vmovdqu8 %ymm2, %ymm3 {%k1}
; AVX512VLBW-NEXT:    vpminsb %ymm1, %ymm0, %ymm2
; AVX512VLBW-NEXT:    vpmaxsb %ymm1, %ymm0, %ymm1
; AVX512VLBW-NEXT:    vpsubb %ymm2, %ymm1, %ymm1
; AVX512VLBW-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512VLBW-NEXT:    vpand {{.*}}(%rip), %ymm1, %ymm1
; AVX512VLBW-NEXT:    vpmovzxbw {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero,ymm1[16],zero,ymm1[17],zero,ymm1[18],zero,ymm1[19],zero,ymm1[20],zero,ymm1[21],zero,ymm1[22],zero,ymm1[23],zero,ymm1[24],zero,ymm1[25],zero,ymm1[26],zero,ymm1[27],zero,ymm1[28],zero,ymm1[29],zero,ymm1[30],zero,ymm1[31],zero
; AVX512VLBW-NEXT:    vpmovzxbw {{.*#+}} zmm2 = ymm3[0],zero,ymm3[1],zero,ymm3[2],zero,ymm3[3],zero,ymm3[4],zero,ymm3[5],zero,ymm3[6],zero,ymm3[7],zero,ymm3[8],zero,ymm3[9],zero,ymm3[10],zero,ymm3[11],zero,ymm3[12],zero,ymm3[13],zero,ymm3[14],zero,ymm3[15],zero,ymm3[16],zero,ymm3[17],zero,ymm3[18],zero,ymm3[19],zero,ymm3[20],zero,ymm3[21],zero,ymm3[22],zero,ymm3[23],zero,ymm3[24],zero,ymm3[25],zero,ymm3[26],zero,ymm3[27],zero,ymm3[28],zero,ymm3[29],zero,ymm3[30],zero,ymm3[31],zero
; AVX512VLBW-NEXT:    vpmullw %zmm2, %zmm1, %zmm1
; AVX512VLBW-NEXT:    vpmovwb %zmm1, %ymm1
; AVX512VLBW-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX512VLBW-NEXT:    retq
  %t3 = icmp sgt <32 x i8> %a1, %a2 ; signed
  %t4 = select <32 x i1> %t3, <32 x i8> <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>, <32 x i8> <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %t5 = select <32 x i1> %t3, <32 x i8> %a2, <32 x i8> %a1
  %t6 = select <32 x i1> %t3, <32 x i8> %a1, <32 x i8> %a2
  %t7 = sub <32 x i8> %t6, %t5
  %t8 = lshr <32 x i8> %t7, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %t9 = mul nsw <32 x i8> %t8, %t4 ; signed
  %a10 = add nsw <32 x i8> %t9, %a1 ; signed
  ret <32 x i8> %a10
}

define <32 x i8> @vec256_i8_unsigned_reg_reg(<32 x i8> %a1, <32 x i8> %a2) nounwind {
; AVX1-FALLBACK-LABEL: vec256_i8_unsigned_reg_reg:
; AVX1-FALLBACK:       # %bb.0:
; AVX1-FALLBACK-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-FALLBACK-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-FALLBACK-NEXT:    vpminub %xmm3, %xmm2, %xmm4
; AVX1-FALLBACK-NEXT:    vpcmpeqb %xmm4, %xmm2, %xmm5
; AVX1-FALLBACK-NEXT:    vpcmpeqd %xmm6, %xmm6, %xmm6
; AVX1-FALLBACK-NEXT:    vpxor %xmm6, %xmm5, %xmm8
; AVX1-FALLBACK-NEXT:    vpminub %xmm1, %xmm0, %xmm7
; AVX1-FALLBACK-NEXT:    vpcmpeqb %xmm7, %xmm0, %xmm5
; AVX1-FALLBACK-NEXT:    vpxor %xmm6, %xmm5, %xmm5
; AVX1-FALLBACK-NEXT:    vpmaxub %xmm3, %xmm2, %xmm3
; AVX1-FALLBACK-NEXT:    vpmaxub %xmm1, %xmm0, %xmm1
; AVX1-FALLBACK-NEXT:    vpsubb %xmm7, %xmm1, %xmm1
; AVX1-FALLBACK-NEXT:    vpsubb %xmm4, %xmm3, %xmm3
; AVX1-FALLBACK-NEXT:    vpsrlw $1, %xmm3, %xmm3
; AVX1-FALLBACK-NEXT:    vmovdqa {{.*#+}} xmm4 = [127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127]
; AVX1-FALLBACK-NEXT:    vpand %xmm4, %xmm3, %xmm3
; AVX1-FALLBACK-NEXT:    vpsrlw $1, %xmm1, %xmm1
; AVX1-FALLBACK-NEXT:    vpand %xmm4, %xmm1, %xmm1
; AVX1-FALLBACK-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm1[8],xmm0[8],xmm1[9],xmm0[9],xmm1[10],xmm0[10],xmm1[11],xmm0[11],xmm1[12],xmm0[12],xmm1[13],xmm0[13],xmm1[14],xmm0[14],xmm1[15],xmm0[15]
; AVX1-FALLBACK-NEXT:    vmovdqa {{.*#+}} xmm6 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; AVX1-FALLBACK-NEXT:    vpor %xmm6, %xmm5, %xmm5
; AVX1-FALLBACK-NEXT:    vpunpckhbw {{.*#+}} xmm7 = xmm5[8],xmm0[8],xmm5[9],xmm0[9],xmm5[10],xmm0[10],xmm5[11],xmm0[11],xmm5[12],xmm0[12],xmm5[13],xmm0[13],xmm5[14],xmm0[14],xmm5[15],xmm0[15]
; AVX1-FALLBACK-NEXT:    vpmullw %xmm7, %xmm4, %xmm4
; AVX1-FALLBACK-NEXT:    vmovdqa {{.*#+}} xmm7 = [255,255,255,255,255,255,255,255]
; AVX1-FALLBACK-NEXT:    vpand %xmm7, %xmm4, %xmm4
; AVX1-FALLBACK-NEXT:    vpmovzxbw {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero,xmm1[4],zero,xmm1[5],zero,xmm1[6],zero,xmm1[7],zero
; AVX1-FALLBACK-NEXT:    vpmovzxbw {{.*#+}} xmm5 = xmm5[0],zero,xmm5[1],zero,xmm5[2],zero,xmm5[3],zero,xmm5[4],zero,xmm5[5],zero,xmm5[6],zero,xmm5[7],zero
; AVX1-FALLBACK-NEXT:    vpmullw %xmm5, %xmm1, %xmm1
; AVX1-FALLBACK-NEXT:    vpand %xmm7, %xmm1, %xmm1
; AVX1-FALLBACK-NEXT:    vpackuswb %xmm4, %xmm1, %xmm1
; AVX1-FALLBACK-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm3[8],xmm0[8],xmm3[9],xmm0[9],xmm3[10],xmm0[10],xmm3[11],xmm0[11],xmm3[12],xmm0[12],xmm3[13],xmm0[13],xmm3[14],xmm0[14],xmm3[15],xmm0[15]
; AVX1-FALLBACK-NEXT:    vpor %xmm6, %xmm8, %xmm5
; AVX1-FALLBACK-NEXT:    vpunpckhbw {{.*#+}} xmm6 = xmm5[8],xmm0[8],xmm5[9],xmm0[9],xmm5[10],xmm0[10],xmm5[11],xmm0[11],xmm5[12],xmm0[12],xmm5[13],xmm0[13],xmm5[14],xmm0[14],xmm5[15],xmm0[15]
; AVX1-FALLBACK-NEXT:    vpmullw %xmm6, %xmm4, %xmm4
; AVX1-FALLBACK-NEXT:    vpand %xmm7, %xmm4, %xmm4
; AVX1-FALLBACK-NEXT:    vpmovzxbw {{.*#+}} xmm3 = xmm3[0],zero,xmm3[1],zero,xmm3[2],zero,xmm3[3],zero,xmm3[4],zero,xmm3[5],zero,xmm3[6],zero,xmm3[7],zero
; AVX1-FALLBACK-NEXT:    vpmovzxbw {{.*#+}} xmm5 = xmm5[0],zero,xmm5[1],zero,xmm5[2],zero,xmm5[3],zero,xmm5[4],zero,xmm5[5],zero,xmm5[6],zero,xmm5[7],zero
; AVX1-FALLBACK-NEXT:    vpmullw %xmm5, %xmm3, %xmm3
; AVX1-FALLBACK-NEXT:    vpand %xmm7, %xmm3, %xmm3
; AVX1-FALLBACK-NEXT:    vpackuswb %xmm4, %xmm3, %xmm3
; AVX1-FALLBACK-NEXT:    vpaddb %xmm2, %xmm3, %xmm2
; AVX1-FALLBACK-NEXT:    vpaddb %xmm0, %xmm1, %xmm0
; AVX1-FALLBACK-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-FALLBACK-NEXT:    retq
;
; AVX2-LABEL: vec256_i8_unsigned_reg_reg:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpminub %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vpcmpeqb %ymm2, %ymm0, %ymm3
; AVX2-NEXT:    vpcmpeqd %ymm4, %ymm4, %ymm4
; AVX2-NEXT:    vpxor %ymm4, %ymm3, %ymm3
; AVX2-NEXT:    vpor {{.*}}(%rip), %ymm3, %ymm3
; AVX2-NEXT:    vpmaxub %ymm1, %ymm0, %ymm1
; AVX2-NEXT:    vpsubb %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX2-NEXT:    vpand {{.*}}(%rip), %ymm1, %ymm1
; AVX2-NEXT:    vpunpckhbw {{.*#+}} ymm2 = ymm1[8],ymm0[8],ymm1[9],ymm0[9],ymm1[10],ymm0[10],ymm1[11],ymm0[11],ymm1[12],ymm0[12],ymm1[13],ymm0[13],ymm1[14],ymm0[14],ymm1[15],ymm0[15],ymm1[24],ymm0[24],ymm1[25],ymm0[25],ymm1[26],ymm0[26],ymm1[27],ymm0[27],ymm1[28],ymm0[28],ymm1[29],ymm0[29],ymm1[30],ymm0[30],ymm1[31],ymm0[31]
; AVX2-NEXT:    vpunpckhbw {{.*#+}} ymm4 = ymm3[8],ymm0[8],ymm3[9],ymm0[9],ymm3[10],ymm0[10],ymm3[11],ymm0[11],ymm3[12],ymm0[12],ymm3[13],ymm0[13],ymm3[14],ymm0[14],ymm3[15],ymm0[15],ymm3[24],ymm0[24],ymm3[25],ymm0[25],ymm3[26],ymm0[26],ymm3[27],ymm0[27],ymm3[28],ymm0[28],ymm3[29],ymm0[29],ymm3[30],ymm0[30],ymm3[31],ymm0[31]
; AVX2-NEXT:    vpmullw %ymm4, %ymm2, %ymm2
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm4 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX2-NEXT:    vpand %ymm4, %ymm2, %ymm2
; AVX2-NEXT:    vpunpcklbw {{.*#+}} ymm1 = ymm1[0],ymm0[0],ymm1[1],ymm0[1],ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[4],ymm0[4],ymm1[5],ymm0[5],ymm1[6],ymm0[6],ymm1[7],ymm0[7],ymm1[16],ymm0[16],ymm1[17],ymm0[17],ymm1[18],ymm0[18],ymm1[19],ymm0[19],ymm1[20],ymm0[20],ymm1[21],ymm0[21],ymm1[22],ymm0[22],ymm1[23],ymm0[23]
; AVX2-NEXT:    vpunpcklbw {{.*#+}} ymm3 = ymm3[0],ymm0[0],ymm3[1],ymm0[1],ymm3[2],ymm0[2],ymm3[3],ymm0[3],ymm3[4],ymm0[4],ymm3[5],ymm0[5],ymm3[6],ymm0[6],ymm3[7],ymm0[7],ymm3[16],ymm0[16],ymm3[17],ymm0[17],ymm3[18],ymm0[18],ymm3[19],ymm0[19],ymm3[20],ymm0[20],ymm3[21],ymm0[21],ymm3[22],ymm0[22],ymm3[23],ymm0[23]
; AVX2-NEXT:    vpmullw %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpand %ymm4, %ymm1, %ymm1
; AVX2-NEXT:    vpackuswb %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; XOP-FALLBACK-LABEL: vec256_i8_unsigned_reg_reg:
; XOP-FALLBACK:       # %bb.0:
; XOP-FALLBACK-NEXT:    vextractf128 $1, %ymm1, %xmm2
; XOP-FALLBACK-NEXT:    vextractf128 $1, %ymm0, %xmm3
; XOP-FALLBACK-NEXT:    vpcomgtub %xmm2, %xmm3, %xmm8
; XOP-FALLBACK-NEXT:    vpcomgtub %xmm1, %xmm0, %xmm5
; XOP-FALLBACK-NEXT:    vpminub %xmm2, %xmm3, %xmm6
; XOP-FALLBACK-NEXT:    vpminub %xmm1, %xmm0, %xmm7
; XOP-FALLBACK-NEXT:    vpmaxub %xmm2, %xmm3, %xmm2
; XOP-FALLBACK-NEXT:    vpsubb %xmm6, %xmm2, %xmm2
; XOP-FALLBACK-NEXT:    vpmaxub %xmm1, %xmm0, %xmm1
; XOP-FALLBACK-NEXT:    vpsubb %xmm7, %xmm1, %xmm1
; XOP-FALLBACK-NEXT:    vpcmpeqd %xmm6, %xmm6, %xmm6
; XOP-FALLBACK-NEXT:    vpshlb %xmm6, %xmm2, %xmm2
; XOP-FALLBACK-NEXT:    vpshlb %xmm6, %xmm1, %xmm1
; XOP-FALLBACK-NEXT:    vpunpckhbw {{.*#+}} xmm6 = xmm1[8],xmm0[8],xmm1[9],xmm0[9],xmm1[10],xmm0[10],xmm1[11],xmm0[11],xmm1[12],xmm0[12],xmm1[13],xmm0[13],xmm1[14],xmm0[14],xmm1[15],xmm0[15]
; XOP-FALLBACK-NEXT:    vmovdqa {{.*#+}} xmm7 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; XOP-FALLBACK-NEXT:    vpor %xmm7, %xmm5, %xmm5
; XOP-FALLBACK-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm5[8],xmm0[8],xmm5[9],xmm0[9],xmm5[10],xmm0[10],xmm5[11],xmm0[11],xmm5[12],xmm0[12],xmm5[13],xmm0[13],xmm5[14],xmm0[14],xmm5[15],xmm0[15]
; XOP-FALLBACK-NEXT:    vpmullw %xmm4, %xmm6, %xmm4
; XOP-FALLBACK-NEXT:    vpmovzxbw {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero,xmm1[4],zero,xmm1[5],zero,xmm1[6],zero,xmm1[7],zero
; XOP-FALLBACK-NEXT:    vpmovzxbw {{.*#+}} xmm5 = xmm5[0],zero,xmm5[1],zero,xmm5[2],zero,xmm5[3],zero,xmm5[4],zero,xmm5[5],zero,xmm5[6],zero,xmm5[7],zero
; XOP-FALLBACK-NEXT:    vpmullw %xmm5, %xmm1, %xmm1
; XOP-FALLBACK-NEXT:    vmovdqa {{.*#+}} xmm5 = [0,2,4,6,8,10,12,14,16,18,20,22,24,26,28,30]
; XOP-FALLBACK-NEXT:    vpperm %xmm5, %xmm4, %xmm1, %xmm1
; XOP-FALLBACK-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm2[8],xmm0[8],xmm2[9],xmm0[9],xmm2[10],xmm0[10],xmm2[11],xmm0[11],xmm2[12],xmm0[12],xmm2[13],xmm0[13],xmm2[14],xmm0[14],xmm2[15],xmm0[15]
; XOP-FALLBACK-NEXT:    vpor %xmm7, %xmm8, %xmm6
; XOP-FALLBACK-NEXT:    vpunpckhbw {{.*#+}} xmm7 = xmm6[8],xmm0[8],xmm6[9],xmm0[9],xmm6[10],xmm0[10],xmm6[11],xmm0[11],xmm6[12],xmm0[12],xmm6[13],xmm0[13],xmm6[14],xmm0[14],xmm6[15],xmm0[15]
; XOP-FALLBACK-NEXT:    vpmullw %xmm7, %xmm4, %xmm4
; XOP-FALLBACK-NEXT:    vpmovzxbw {{.*#+}} xmm2 = xmm2[0],zero,xmm2[1],zero,xmm2[2],zero,xmm2[3],zero,xmm2[4],zero,xmm2[5],zero,xmm2[6],zero,xmm2[7],zero
; XOP-FALLBACK-NEXT:    vpmovzxbw {{.*#+}} xmm6 = xmm6[0],zero,xmm6[1],zero,xmm6[2],zero,xmm6[3],zero,xmm6[4],zero,xmm6[5],zero,xmm6[6],zero,xmm6[7],zero
; XOP-FALLBACK-NEXT:    vpmullw %xmm6, %xmm2, %xmm2
; XOP-FALLBACK-NEXT:    vpperm %xmm5, %xmm4, %xmm2, %xmm2
; XOP-FALLBACK-NEXT:    vpaddb %xmm3, %xmm2, %xmm2
; XOP-FALLBACK-NEXT:    vpaddb %xmm0, %xmm1, %xmm0
; XOP-FALLBACK-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOP-FALLBACK-NEXT:    retq
;
; XOPAVX1-LABEL: vec256_i8_unsigned_reg_reg:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; XOPAVX1-NEXT:    vpcomgtub %xmm2, %xmm3, %xmm8
; XOPAVX1-NEXT:    vpcomgtub %xmm1, %xmm0, %xmm5
; XOPAVX1-NEXT:    vpminub %xmm2, %xmm3, %xmm6
; XOPAVX1-NEXT:    vpminub %xmm1, %xmm0, %xmm7
; XOPAVX1-NEXT:    vpmaxub %xmm2, %xmm3, %xmm2
; XOPAVX1-NEXT:    vpsubb %xmm6, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpmaxub %xmm1, %xmm0, %xmm1
; XOPAVX1-NEXT:    vpsubb %xmm7, %xmm1, %xmm1
; XOPAVX1-NEXT:    vpcmpeqd %xmm6, %xmm6, %xmm6
; XOPAVX1-NEXT:    vpshlb %xmm6, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpshlb %xmm6, %xmm1, %xmm1
; XOPAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm6 = xmm1[8],xmm0[8],xmm1[9],xmm0[9],xmm1[10],xmm0[10],xmm1[11],xmm0[11],xmm1[12],xmm0[12],xmm1[13],xmm0[13],xmm1[14],xmm0[14],xmm1[15],xmm0[15]
; XOPAVX1-NEXT:    vmovdqa {{.*#+}} xmm7 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; XOPAVX1-NEXT:    vpor %xmm7, %xmm5, %xmm5
; XOPAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm5[8],xmm0[8],xmm5[9],xmm0[9],xmm5[10],xmm0[10],xmm5[11],xmm0[11],xmm5[12],xmm0[12],xmm5[13],xmm0[13],xmm5[14],xmm0[14],xmm5[15],xmm0[15]
; XOPAVX1-NEXT:    vpmullw %xmm4, %xmm6, %xmm4
; XOPAVX1-NEXT:    vpmovzxbw {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero,xmm1[4],zero,xmm1[5],zero,xmm1[6],zero,xmm1[7],zero
; XOPAVX1-NEXT:    vpmovzxbw {{.*#+}} xmm5 = xmm5[0],zero,xmm5[1],zero,xmm5[2],zero,xmm5[3],zero,xmm5[4],zero,xmm5[5],zero,xmm5[6],zero,xmm5[7],zero
; XOPAVX1-NEXT:    vpmullw %xmm5, %xmm1, %xmm1
; XOPAVX1-NEXT:    vmovdqa {{.*#+}} xmm5 = [0,2,4,6,8,10,12,14,16,18,20,22,24,26,28,30]
; XOPAVX1-NEXT:    vpperm %xmm5, %xmm4, %xmm1, %xmm1
; XOPAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm2[8],xmm0[8],xmm2[9],xmm0[9],xmm2[10],xmm0[10],xmm2[11],xmm0[11],xmm2[12],xmm0[12],xmm2[13],xmm0[13],xmm2[14],xmm0[14],xmm2[15],xmm0[15]
; XOPAVX1-NEXT:    vpor %xmm7, %xmm8, %xmm6
; XOPAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm7 = xmm6[8],xmm0[8],xmm6[9],xmm0[9],xmm6[10],xmm0[10],xmm6[11],xmm0[11],xmm6[12],xmm0[12],xmm6[13],xmm0[13],xmm6[14],xmm0[14],xmm6[15],xmm0[15]
; XOPAVX1-NEXT:    vpmullw %xmm7, %xmm4, %xmm4
; XOPAVX1-NEXT:    vpmovzxbw {{.*#+}} xmm2 = xmm2[0],zero,xmm2[1],zero,xmm2[2],zero,xmm2[3],zero,xmm2[4],zero,xmm2[5],zero,xmm2[6],zero,xmm2[7],zero
; XOPAVX1-NEXT:    vpmovzxbw {{.*#+}} xmm6 = xmm6[0],zero,xmm6[1],zero,xmm6[2],zero,xmm6[3],zero,xmm6[4],zero,xmm6[5],zero,xmm6[6],zero,xmm6[7],zero
; XOPAVX1-NEXT:    vpmullw %xmm6, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpperm %xmm5, %xmm4, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpaddb %xmm3, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpaddb %xmm0, %xmm1, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOPAVX1-NEXT:    retq
;
; AVX512F-LABEL: vec256_i8_unsigned_reg_reg:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpminub %ymm1, %ymm0, %ymm2
; AVX512F-NEXT:    vpcmpeqb %ymm2, %ymm0, %ymm3
; AVX512F-NEXT:    vpternlogq $15, %zmm3, %zmm3, %zmm3
; AVX512F-NEXT:    vpor {{.*}}(%rip), %ymm3, %ymm3
; AVX512F-NEXT:    vpmaxub %ymm1, %ymm0, %ymm1
; AVX512F-NEXT:    vpsubb %ymm2, %ymm1, %ymm1
; AVX512F-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512F-NEXT:    vpand {{.*}}(%rip), %ymm1, %ymm1
; AVX512F-NEXT:    vpunpckhbw {{.*#+}} ymm2 = ymm1[8],ymm0[8],ymm1[9],ymm0[9],ymm1[10],ymm0[10],ymm1[11],ymm0[11],ymm1[12],ymm0[12],ymm1[13],ymm0[13],ymm1[14],ymm0[14],ymm1[15],ymm0[15],ymm1[24],ymm0[24],ymm1[25],ymm0[25],ymm1[26],ymm0[26],ymm1[27],ymm0[27],ymm1[28],ymm0[28],ymm1[29],ymm0[29],ymm1[30],ymm0[30],ymm1[31],ymm0[31]
; AVX512F-NEXT:    vpunpckhbw {{.*#+}} ymm4 = ymm3[8],ymm0[8],ymm3[9],ymm0[9],ymm3[10],ymm0[10],ymm3[11],ymm0[11],ymm3[12],ymm0[12],ymm3[13],ymm0[13],ymm3[14],ymm0[14],ymm3[15],ymm0[15],ymm3[24],ymm0[24],ymm3[25],ymm0[25],ymm3[26],ymm0[26],ymm3[27],ymm0[27],ymm3[28],ymm0[28],ymm3[29],ymm0[29],ymm3[30],ymm0[30],ymm3[31],ymm0[31]
; AVX512F-NEXT:    vpmullw %ymm4, %ymm2, %ymm2
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm4 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-NEXT:    vpand %ymm4, %ymm2, %ymm2
; AVX512F-NEXT:    vpunpcklbw {{.*#+}} ymm1 = ymm1[0],ymm0[0],ymm1[1],ymm0[1],ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[4],ymm0[4],ymm1[5],ymm0[5],ymm1[6],ymm0[6],ymm1[7],ymm0[7],ymm1[16],ymm0[16],ymm1[17],ymm0[17],ymm1[18],ymm0[18],ymm1[19],ymm0[19],ymm1[20],ymm0[20],ymm1[21],ymm0[21],ymm1[22],ymm0[22],ymm1[23],ymm0[23]
; AVX512F-NEXT:    vpunpcklbw {{.*#+}} ymm3 = ymm3[0],ymm0[0],ymm3[1],ymm0[1],ymm3[2],ymm0[2],ymm3[3],ymm0[3],ymm3[4],ymm0[4],ymm3[5],ymm0[5],ymm3[6],ymm0[6],ymm3[7],ymm0[7],ymm3[16],ymm0[16],ymm3[17],ymm0[17],ymm3[18],ymm0[18],ymm3[19],ymm0[19],ymm3[20],ymm0[20],ymm3[21],ymm0[21],ymm3[22],ymm0[22],ymm3[23],ymm0[23]
; AVX512F-NEXT:    vpmullw %ymm3, %ymm1, %ymm1
; AVX512F-NEXT:    vpand %ymm4, %ymm1, %ymm1
; AVX512F-NEXT:    vpackuswb %ymm2, %ymm1, %ymm1
; AVX512F-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-FALLBACK-LABEL: vec256_i8_unsigned_reg_reg:
; AVX512VL-FALLBACK:       # %bb.0:
; AVX512VL-FALLBACK-NEXT:    vpminub %ymm1, %ymm0, %ymm2
; AVX512VL-FALLBACK-NEXT:    vpcmpeqb %ymm2, %ymm0, %ymm3
; AVX512VL-FALLBACK-NEXT:    vpternlogq $15, %ymm3, %ymm3, %ymm3
; AVX512VL-FALLBACK-NEXT:    vpor {{.*}}(%rip), %ymm3, %ymm3
; AVX512VL-FALLBACK-NEXT:    vpmaxub %ymm1, %ymm0, %ymm1
; AVX512VL-FALLBACK-NEXT:    vpsubb %ymm2, %ymm1, %ymm1
; AVX512VL-FALLBACK-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512VL-FALLBACK-NEXT:    vpand {{.*}}(%rip), %ymm1, %ymm1
; AVX512VL-FALLBACK-NEXT:    vpunpckhbw {{.*#+}} ymm2 = ymm1[8],ymm0[8],ymm1[9],ymm0[9],ymm1[10],ymm0[10],ymm1[11],ymm0[11],ymm1[12],ymm0[12],ymm1[13],ymm0[13],ymm1[14],ymm0[14],ymm1[15],ymm0[15],ymm1[24],ymm0[24],ymm1[25],ymm0[25],ymm1[26],ymm0[26],ymm1[27],ymm0[27],ymm1[28],ymm0[28],ymm1[29],ymm0[29],ymm1[30],ymm0[30],ymm1[31],ymm0[31]
; AVX512VL-FALLBACK-NEXT:    vpunpckhbw {{.*#+}} ymm4 = ymm3[8],ymm0[8],ymm3[9],ymm0[9],ymm3[10],ymm0[10],ymm3[11],ymm0[11],ymm3[12],ymm0[12],ymm3[13],ymm0[13],ymm3[14],ymm0[14],ymm3[15],ymm0[15],ymm3[24],ymm0[24],ymm3[25],ymm0[25],ymm3[26],ymm0[26],ymm3[27],ymm0[27],ymm3[28],ymm0[28],ymm3[29],ymm0[29],ymm3[30],ymm0[30],ymm3[31],ymm0[31]
; AVX512VL-FALLBACK-NEXT:    vpmullw %ymm4, %ymm2, %ymm2
; AVX512VL-FALLBACK-NEXT:    vmovdqa {{.*#+}} ymm4 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512VL-FALLBACK-NEXT:    vpand %ymm4, %ymm2, %ymm2
; AVX512VL-FALLBACK-NEXT:    vpunpcklbw {{.*#+}} ymm1 = ymm1[0],ymm0[0],ymm1[1],ymm0[1],ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[4],ymm0[4],ymm1[5],ymm0[5],ymm1[6],ymm0[6],ymm1[7],ymm0[7],ymm1[16],ymm0[16],ymm1[17],ymm0[17],ymm1[18],ymm0[18],ymm1[19],ymm0[19],ymm1[20],ymm0[20],ymm1[21],ymm0[21],ymm1[22],ymm0[22],ymm1[23],ymm0[23]
; AVX512VL-FALLBACK-NEXT:    vpunpcklbw {{.*#+}} ymm3 = ymm3[0],ymm0[0],ymm3[1],ymm0[1],ymm3[2],ymm0[2],ymm3[3],ymm0[3],ymm3[4],ymm0[4],ymm3[5],ymm0[5],ymm3[6],ymm0[6],ymm3[7],ymm0[7],ymm3[16],ymm0[16],ymm3[17],ymm0[17],ymm3[18],ymm0[18],ymm3[19],ymm0[19],ymm3[20],ymm0[20],ymm3[21],ymm0[21],ymm3[22],ymm0[22],ymm3[23],ymm0[23]
; AVX512VL-FALLBACK-NEXT:    vpmullw %ymm3, %ymm1, %ymm1
; AVX512VL-FALLBACK-NEXT:    vpand %ymm4, %ymm1, %ymm1
; AVX512VL-FALLBACK-NEXT:    vpackuswb %ymm2, %ymm1, %ymm1
; AVX512VL-FALLBACK-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX512VL-FALLBACK-NEXT:    retq
;
; AVX512BW-FALLBACK-LABEL: vec256_i8_unsigned_reg_reg:
; AVX512BW-FALLBACK:       # %bb.0:
; AVX512BW-FALLBACK-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512BW-FALLBACK-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-FALLBACK-NEXT:    vpcmpnleub %zmm1, %zmm0, %k1
; AVX512BW-FALLBACK-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512BW-FALLBACK-NEXT:    vmovdqa {{.*#+}} ymm3 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; AVX512BW-FALLBACK-NEXT:    vmovdqu8 %zmm2, %zmm3 {%k1}
; AVX512BW-FALLBACK-NEXT:    vpminub %ymm1, %ymm0, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpmaxub %ymm1, %ymm0, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpsubb %ymm2, %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpand {{.*}}(%rip), %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpmovzxbw {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero,ymm1[16],zero,ymm1[17],zero,ymm1[18],zero,ymm1[19],zero,ymm1[20],zero,ymm1[21],zero,ymm1[22],zero,ymm1[23],zero,ymm1[24],zero,ymm1[25],zero,ymm1[26],zero,ymm1[27],zero,ymm1[28],zero,ymm1[29],zero,ymm1[30],zero,ymm1[31],zero
; AVX512BW-FALLBACK-NEXT:    vpmovzxbw {{.*#+}} zmm2 = ymm3[0],zero,ymm3[1],zero,ymm3[2],zero,ymm3[3],zero,ymm3[4],zero,ymm3[5],zero,ymm3[6],zero,ymm3[7],zero,ymm3[8],zero,ymm3[9],zero,ymm3[10],zero,ymm3[11],zero,ymm3[12],zero,ymm3[13],zero,ymm3[14],zero,ymm3[15],zero,ymm3[16],zero,ymm3[17],zero,ymm3[18],zero,ymm3[19],zero,ymm3[20],zero,ymm3[21],zero,ymm3[22],zero,ymm3[23],zero,ymm3[24],zero,ymm3[25],zero,ymm3[26],zero,ymm3[27],zero,ymm3[28],zero,ymm3[29],zero,ymm3[30],zero,ymm3[31],zero
; AVX512BW-FALLBACK-NEXT:    vpmullw %zmm2, %zmm1, %zmm1
; AVX512BW-FALLBACK-NEXT:    vpmovwb %zmm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX512BW-FALLBACK-NEXT:    retq
;
; AVX512VLBW-LABEL: vec256_i8_unsigned_reg_reg:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vpcmpnleub %ymm1, %ymm0, %k1
; AVX512VLBW-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512VLBW-NEXT:    vmovdqa {{.*#+}} ymm3 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; AVX512VLBW-NEXT:    vmovdqu8 %ymm2, %ymm3 {%k1}
; AVX512VLBW-NEXT:    vpminub %ymm1, %ymm0, %ymm2
; AVX512VLBW-NEXT:    vpmaxub %ymm1, %ymm0, %ymm1
; AVX512VLBW-NEXT:    vpsubb %ymm2, %ymm1, %ymm1
; AVX512VLBW-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512VLBW-NEXT:    vpand {{.*}}(%rip), %ymm1, %ymm1
; AVX512VLBW-NEXT:    vpmovzxbw {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero,ymm1[16],zero,ymm1[17],zero,ymm1[18],zero,ymm1[19],zero,ymm1[20],zero,ymm1[21],zero,ymm1[22],zero,ymm1[23],zero,ymm1[24],zero,ymm1[25],zero,ymm1[26],zero,ymm1[27],zero,ymm1[28],zero,ymm1[29],zero,ymm1[30],zero,ymm1[31],zero
; AVX512VLBW-NEXT:    vpmovzxbw {{.*#+}} zmm2 = ymm3[0],zero,ymm3[1],zero,ymm3[2],zero,ymm3[3],zero,ymm3[4],zero,ymm3[5],zero,ymm3[6],zero,ymm3[7],zero,ymm3[8],zero,ymm3[9],zero,ymm3[10],zero,ymm3[11],zero,ymm3[12],zero,ymm3[13],zero,ymm3[14],zero,ymm3[15],zero,ymm3[16],zero,ymm3[17],zero,ymm3[18],zero,ymm3[19],zero,ymm3[20],zero,ymm3[21],zero,ymm3[22],zero,ymm3[23],zero,ymm3[24],zero,ymm3[25],zero,ymm3[26],zero,ymm3[27],zero,ymm3[28],zero,ymm3[29],zero,ymm3[30],zero,ymm3[31],zero
; AVX512VLBW-NEXT:    vpmullw %zmm2, %zmm1, %zmm1
; AVX512VLBW-NEXT:    vpmovwb %zmm1, %ymm1
; AVX512VLBW-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX512VLBW-NEXT:    retq
  %t3 = icmp ugt <32 x i8> %a1, %a2
  %t4 = select <32 x i1> %t3, <32 x i8> <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>, <32 x i8> <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %t5 = select <32 x i1> %t3, <32 x i8> %a2, <32 x i8> %a1
  %t6 = select <32 x i1> %t3, <32 x i8> %a1, <32 x i8> %a2
  %t7 = sub <32 x i8> %t6, %t5
  %t8 = lshr <32 x i8> %t7, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %t9 = mul <32 x i8> %t8, %t4
  %a10 = add <32 x i8> %t9, %a1
  ret <32 x i8> %a10
}

; Values are loaded. Only check signed case.

define <32 x i8> @vec256_i8_signed_mem_reg(<32 x i8>* %a1_addr, <32 x i8> %a2) nounwind {
; AVX1-FALLBACK-LABEL: vec256_i8_signed_mem_reg:
; AVX1-FALLBACK:       # %bb.0:
; AVX1-FALLBACK-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-FALLBACK-NEXT:    vmovdqa (%rdi), %xmm1
; AVX1-FALLBACK-NEXT:    vmovdqa 16(%rdi), %xmm2
; AVX1-FALLBACK-NEXT:    vpcmpgtb %xmm3, %xmm2, %xmm8
; AVX1-FALLBACK-NEXT:    vpcmpgtb %xmm0, %xmm1, %xmm5
; AVX1-FALLBACK-NEXT:    vpminsb %xmm3, %xmm2, %xmm6
; AVX1-FALLBACK-NEXT:    vpminsb %xmm0, %xmm1, %xmm7
; AVX1-FALLBACK-NEXT:    vpmaxsb %xmm3, %xmm2, %xmm3
; AVX1-FALLBACK-NEXT:    vpsubb %xmm6, %xmm3, %xmm3
; AVX1-FALLBACK-NEXT:    vpmaxsb %xmm0, %xmm1, %xmm0
; AVX1-FALLBACK-NEXT:    vpsubb %xmm7, %xmm0, %xmm0
; AVX1-FALLBACK-NEXT:    vpsrlw $1, %xmm3, %xmm3
; AVX1-FALLBACK-NEXT:    vmovdqa {{.*#+}} xmm6 = [127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127]
; AVX1-FALLBACK-NEXT:    vpand %xmm6, %xmm3, %xmm3
; AVX1-FALLBACK-NEXT:    vpsrlw $1, %xmm0, %xmm0
; AVX1-FALLBACK-NEXT:    vpand %xmm6, %xmm0, %xmm0
; AVX1-FALLBACK-NEXT:    vpunpckhbw {{.*#+}} xmm6 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; AVX1-FALLBACK-NEXT:    vmovdqa {{.*#+}} xmm7 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; AVX1-FALLBACK-NEXT:    vpor %xmm7, %xmm5, %xmm5
; AVX1-FALLBACK-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm5[8],xmm0[8],xmm5[9],xmm0[9],xmm5[10],xmm0[10],xmm5[11],xmm0[11],xmm5[12],xmm0[12],xmm5[13],xmm0[13],xmm5[14],xmm0[14],xmm5[15],xmm0[15]
; AVX1-FALLBACK-NEXT:    vpmullw %xmm4, %xmm6, %xmm4
; AVX1-FALLBACK-NEXT:    vmovdqa {{.*#+}} xmm6 = [255,255,255,255,255,255,255,255]
; AVX1-FALLBACK-NEXT:    vpand %xmm6, %xmm4, %xmm4
; AVX1-FALLBACK-NEXT:    vpmovzxbw {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX1-FALLBACK-NEXT:    vpmovzxbw {{.*#+}} xmm5 = xmm5[0],zero,xmm5[1],zero,xmm5[2],zero,xmm5[3],zero,xmm5[4],zero,xmm5[5],zero,xmm5[6],zero,xmm5[7],zero
; AVX1-FALLBACK-NEXT:    vpmullw %xmm5, %xmm0, %xmm0
; AVX1-FALLBACK-NEXT:    vpand %xmm6, %xmm0, %xmm0
; AVX1-FALLBACK-NEXT:    vpackuswb %xmm4, %xmm0, %xmm0
; AVX1-FALLBACK-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm3[8],xmm0[8],xmm3[9],xmm0[9],xmm3[10],xmm0[10],xmm3[11],xmm0[11],xmm3[12],xmm0[12],xmm3[13],xmm0[13],xmm3[14],xmm0[14],xmm3[15],xmm0[15]
; AVX1-FALLBACK-NEXT:    vpor %xmm7, %xmm8, %xmm5
; AVX1-FALLBACK-NEXT:    vpunpckhbw {{.*#+}} xmm7 = xmm5[8],xmm0[8],xmm5[9],xmm0[9],xmm5[10],xmm0[10],xmm5[11],xmm0[11],xmm5[12],xmm0[12],xmm5[13],xmm0[13],xmm5[14],xmm0[14],xmm5[15],xmm0[15]
; AVX1-FALLBACK-NEXT:    vpmullw %xmm7, %xmm4, %xmm4
; AVX1-FALLBACK-NEXT:    vpand %xmm6, %xmm4, %xmm4
; AVX1-FALLBACK-NEXT:    vpmovzxbw {{.*#+}} xmm3 = xmm3[0],zero,xmm3[1],zero,xmm3[2],zero,xmm3[3],zero,xmm3[4],zero,xmm3[5],zero,xmm3[6],zero,xmm3[7],zero
; AVX1-FALLBACK-NEXT:    vpmovzxbw {{.*#+}} xmm5 = xmm5[0],zero,xmm5[1],zero,xmm5[2],zero,xmm5[3],zero,xmm5[4],zero,xmm5[5],zero,xmm5[6],zero,xmm5[7],zero
; AVX1-FALLBACK-NEXT:    vpmullw %xmm5, %xmm3, %xmm3
; AVX1-FALLBACK-NEXT:    vpand %xmm6, %xmm3, %xmm3
; AVX1-FALLBACK-NEXT:    vpackuswb %xmm4, %xmm3, %xmm3
; AVX1-FALLBACK-NEXT:    vpaddb %xmm2, %xmm3, %xmm2
; AVX1-FALLBACK-NEXT:    vpaddb %xmm1, %xmm0, %xmm0
; AVX1-FALLBACK-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-FALLBACK-NEXT:    retq
;
; AVX2-LABEL: vec256_i8_signed_mem_reg:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %ymm1
; AVX2-NEXT:    vpcmpgtb %ymm0, %ymm1, %ymm2
; AVX2-NEXT:    vpor {{.*}}(%rip), %ymm2, %ymm2
; AVX2-NEXT:    vpminsb %ymm0, %ymm1, %ymm3
; AVX2-NEXT:    vpmaxsb %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    vpsubb %ymm3, %ymm0, %ymm0
; AVX2-NEXT:    vpsrlw $1, %ymm0, %ymm0
; AVX2-NEXT:    vpand {{.*}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    vpunpckhbw {{.*#+}} ymm3 = ymm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31]
; AVX2-NEXT:    vpunpckhbw {{.*#+}} ymm4 = ymm2[8],ymm0[8],ymm2[9],ymm0[9],ymm2[10],ymm0[10],ymm2[11],ymm0[11],ymm2[12],ymm0[12],ymm2[13],ymm0[13],ymm2[14],ymm0[14],ymm2[15],ymm0[15],ymm2[24],ymm0[24],ymm2[25],ymm0[25],ymm2[26],ymm0[26],ymm2[27],ymm0[27],ymm2[28],ymm0[28],ymm2[29],ymm0[29],ymm2[30],ymm0[30],ymm2[31],ymm0[31]
; AVX2-NEXT:    vpmullw %ymm4, %ymm3, %ymm3
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm4 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX2-NEXT:    vpand %ymm4, %ymm3, %ymm3
; AVX2-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23]
; AVX2-NEXT:    vpunpcklbw {{.*#+}} ymm2 = ymm2[0],ymm0[0],ymm2[1],ymm0[1],ymm2[2],ymm0[2],ymm2[3],ymm0[3],ymm2[4],ymm0[4],ymm2[5],ymm0[5],ymm2[6],ymm0[6],ymm2[7],ymm0[7],ymm2[16],ymm0[16],ymm2[17],ymm0[17],ymm2[18],ymm0[18],ymm2[19],ymm0[19],ymm2[20],ymm0[20],ymm2[21],ymm0[21],ymm2[22],ymm0[22],ymm2[23],ymm0[23]
; AVX2-NEXT:    vpmullw %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm4, %ymm0, %ymm0
; AVX2-NEXT:    vpackuswb %ymm3, %ymm0, %ymm0
; AVX2-NEXT:    vpaddb %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; XOP-FALLBACK-LABEL: vec256_i8_signed_mem_reg:
; XOP-FALLBACK:       # %bb.0:
; XOP-FALLBACK-NEXT:    vextractf128 $1, %ymm0, %xmm2
; XOP-FALLBACK-NEXT:    vmovdqa (%rdi), %xmm1
; XOP-FALLBACK-NEXT:    vmovdqa 16(%rdi), %xmm3
; XOP-FALLBACK-NEXT:    vpcomgtb %xmm2, %xmm3, %xmm8
; XOP-FALLBACK-NEXT:    vpcomgtb %xmm0, %xmm1, %xmm5
; XOP-FALLBACK-NEXT:    vpminsb %xmm2, %xmm3, %xmm6
; XOP-FALLBACK-NEXT:    vpminsb %xmm0, %xmm1, %xmm7
; XOP-FALLBACK-NEXT:    vpmaxsb %xmm2, %xmm3, %xmm2
; XOP-FALLBACK-NEXT:    vpsubb %xmm6, %xmm2, %xmm2
; XOP-FALLBACK-NEXT:    vpmaxsb %xmm0, %xmm1, %xmm0
; XOP-FALLBACK-NEXT:    vpsubb %xmm7, %xmm0, %xmm0
; XOP-FALLBACK-NEXT:    vpcmpeqd %xmm6, %xmm6, %xmm6
; XOP-FALLBACK-NEXT:    vpshlb %xmm6, %xmm2, %xmm2
; XOP-FALLBACK-NEXT:    vpshlb %xmm6, %xmm0, %xmm0
; XOP-FALLBACK-NEXT:    vpunpckhbw {{.*#+}} xmm6 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; XOP-FALLBACK-NEXT:    vmovdqa {{.*#+}} xmm7 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; XOP-FALLBACK-NEXT:    vpor %xmm7, %xmm5, %xmm5
; XOP-FALLBACK-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm5[8],xmm0[8],xmm5[9],xmm0[9],xmm5[10],xmm0[10],xmm5[11],xmm0[11],xmm5[12],xmm0[12],xmm5[13],xmm0[13],xmm5[14],xmm0[14],xmm5[15],xmm0[15]
; XOP-FALLBACK-NEXT:    vpmullw %xmm4, %xmm6, %xmm4
; XOP-FALLBACK-NEXT:    vpmovzxbw {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; XOP-FALLBACK-NEXT:    vpmovzxbw {{.*#+}} xmm5 = xmm5[0],zero,xmm5[1],zero,xmm5[2],zero,xmm5[3],zero,xmm5[4],zero,xmm5[5],zero,xmm5[6],zero,xmm5[7],zero
; XOP-FALLBACK-NEXT:    vpmullw %xmm5, %xmm0, %xmm0
; XOP-FALLBACK-NEXT:    vmovdqa {{.*#+}} xmm5 = [0,2,4,6,8,10,12,14,16,18,20,22,24,26,28,30]
; XOP-FALLBACK-NEXT:    vpperm %xmm5, %xmm4, %xmm0, %xmm0
; XOP-FALLBACK-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm2[8],xmm0[8],xmm2[9],xmm0[9],xmm2[10],xmm0[10],xmm2[11],xmm0[11],xmm2[12],xmm0[12],xmm2[13],xmm0[13],xmm2[14],xmm0[14],xmm2[15],xmm0[15]
; XOP-FALLBACK-NEXT:    vpor %xmm7, %xmm8, %xmm6
; XOP-FALLBACK-NEXT:    vpunpckhbw {{.*#+}} xmm7 = xmm6[8],xmm0[8],xmm6[9],xmm0[9],xmm6[10],xmm0[10],xmm6[11],xmm0[11],xmm6[12],xmm0[12],xmm6[13],xmm0[13],xmm6[14],xmm0[14],xmm6[15],xmm0[15]
; XOP-FALLBACK-NEXT:    vpmullw %xmm7, %xmm4, %xmm4
; XOP-FALLBACK-NEXT:    vpmovzxbw {{.*#+}} xmm2 = xmm2[0],zero,xmm2[1],zero,xmm2[2],zero,xmm2[3],zero,xmm2[4],zero,xmm2[5],zero,xmm2[6],zero,xmm2[7],zero
; XOP-FALLBACK-NEXT:    vpmovzxbw {{.*#+}} xmm6 = xmm6[0],zero,xmm6[1],zero,xmm6[2],zero,xmm6[3],zero,xmm6[4],zero,xmm6[5],zero,xmm6[6],zero,xmm6[7],zero
; XOP-FALLBACK-NEXT:    vpmullw %xmm6, %xmm2, %xmm2
; XOP-FALLBACK-NEXT:    vpperm %xmm5, %xmm4, %xmm2, %xmm2
; XOP-FALLBACK-NEXT:    vpaddb %xmm3, %xmm2, %xmm2
; XOP-FALLBACK-NEXT:    vpaddb %xmm1, %xmm0, %xmm0
; XOP-FALLBACK-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOP-FALLBACK-NEXT:    retq
;
; XOPAVX1-LABEL: vec256_i8_signed_mem_reg:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; XOPAVX1-NEXT:    vmovdqa (%rdi), %xmm1
; XOPAVX1-NEXT:    vmovdqa 16(%rdi), %xmm3
; XOPAVX1-NEXT:    vpcomgtb %xmm2, %xmm3, %xmm8
; XOPAVX1-NEXT:    vpcomgtb %xmm0, %xmm1, %xmm5
; XOPAVX1-NEXT:    vpminsb %xmm2, %xmm3, %xmm6
; XOPAVX1-NEXT:    vpminsb %xmm0, %xmm1, %xmm7
; XOPAVX1-NEXT:    vpmaxsb %xmm2, %xmm3, %xmm2
; XOPAVX1-NEXT:    vpsubb %xmm6, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpmaxsb %xmm0, %xmm1, %xmm0
; XOPAVX1-NEXT:    vpsubb %xmm7, %xmm0, %xmm0
; XOPAVX1-NEXT:    vpcmpeqd %xmm6, %xmm6, %xmm6
; XOPAVX1-NEXT:    vpshlb %xmm6, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpshlb %xmm6, %xmm0, %xmm0
; XOPAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm6 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; XOPAVX1-NEXT:    vmovdqa {{.*#+}} xmm7 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; XOPAVX1-NEXT:    vpor %xmm7, %xmm5, %xmm5
; XOPAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm5[8],xmm0[8],xmm5[9],xmm0[9],xmm5[10],xmm0[10],xmm5[11],xmm0[11],xmm5[12],xmm0[12],xmm5[13],xmm0[13],xmm5[14],xmm0[14],xmm5[15],xmm0[15]
; XOPAVX1-NEXT:    vpmullw %xmm4, %xmm6, %xmm4
; XOPAVX1-NEXT:    vpmovzxbw {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; XOPAVX1-NEXT:    vpmovzxbw {{.*#+}} xmm5 = xmm5[0],zero,xmm5[1],zero,xmm5[2],zero,xmm5[3],zero,xmm5[4],zero,xmm5[5],zero,xmm5[6],zero,xmm5[7],zero
; XOPAVX1-NEXT:    vpmullw %xmm5, %xmm0, %xmm0
; XOPAVX1-NEXT:    vmovdqa {{.*#+}} xmm5 = [0,2,4,6,8,10,12,14,16,18,20,22,24,26,28,30]
; XOPAVX1-NEXT:    vpperm %xmm5, %xmm4, %xmm0, %xmm0
; XOPAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm2[8],xmm0[8],xmm2[9],xmm0[9],xmm2[10],xmm0[10],xmm2[11],xmm0[11],xmm2[12],xmm0[12],xmm2[13],xmm0[13],xmm2[14],xmm0[14],xmm2[15],xmm0[15]
; XOPAVX1-NEXT:    vpor %xmm7, %xmm8, %xmm6
; XOPAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm7 = xmm6[8],xmm0[8],xmm6[9],xmm0[9],xmm6[10],xmm0[10],xmm6[11],xmm0[11],xmm6[12],xmm0[12],xmm6[13],xmm0[13],xmm6[14],xmm0[14],xmm6[15],xmm0[15]
; XOPAVX1-NEXT:    vpmullw %xmm7, %xmm4, %xmm4
; XOPAVX1-NEXT:    vpmovzxbw {{.*#+}} xmm2 = xmm2[0],zero,xmm2[1],zero,xmm2[2],zero,xmm2[3],zero,xmm2[4],zero,xmm2[5],zero,xmm2[6],zero,xmm2[7],zero
; XOPAVX1-NEXT:    vpmovzxbw {{.*#+}} xmm6 = xmm6[0],zero,xmm6[1],zero,xmm6[2],zero,xmm6[3],zero,xmm6[4],zero,xmm6[5],zero,xmm6[6],zero,xmm6[7],zero
; XOPAVX1-NEXT:    vpmullw %xmm6, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpperm %xmm5, %xmm4, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpaddb %xmm3, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpaddb %xmm1, %xmm0, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOPAVX1-NEXT:    retq
;
; AVX512F-LABEL: vec256_i8_signed_mem_reg:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vmovdqa (%rdi), %ymm1
; AVX512F-NEXT:    vpcmpgtb %ymm0, %ymm1, %ymm2
; AVX512F-NEXT:    vpor {{.*}}(%rip), %ymm2, %ymm2
; AVX512F-NEXT:    vpminsb %ymm0, %ymm1, %ymm3
; AVX512F-NEXT:    vpmaxsb %ymm0, %ymm1, %ymm0
; AVX512F-NEXT:    vpsubb %ymm3, %ymm0, %ymm0
; AVX512F-NEXT:    vpsrlw $1, %ymm0, %ymm0
; AVX512F-NEXT:    vpand {{.*}}(%rip), %ymm0, %ymm0
; AVX512F-NEXT:    vpunpckhbw {{.*#+}} ymm3 = ymm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31]
; AVX512F-NEXT:    vpunpckhbw {{.*#+}} ymm4 = ymm2[8],ymm0[8],ymm2[9],ymm0[9],ymm2[10],ymm0[10],ymm2[11],ymm0[11],ymm2[12],ymm0[12],ymm2[13],ymm0[13],ymm2[14],ymm0[14],ymm2[15],ymm0[15],ymm2[24],ymm0[24],ymm2[25],ymm0[25],ymm2[26],ymm0[26],ymm2[27],ymm0[27],ymm2[28],ymm0[28],ymm2[29],ymm0[29],ymm2[30],ymm0[30],ymm2[31],ymm0[31]
; AVX512F-NEXT:    vpmullw %ymm4, %ymm3, %ymm3
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm4 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-NEXT:    vpand %ymm4, %ymm3, %ymm3
; AVX512F-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23]
; AVX512F-NEXT:    vpunpcklbw {{.*#+}} ymm2 = ymm2[0],ymm0[0],ymm2[1],ymm0[1],ymm2[2],ymm0[2],ymm2[3],ymm0[3],ymm2[4],ymm0[4],ymm2[5],ymm0[5],ymm2[6],ymm0[6],ymm2[7],ymm0[7],ymm2[16],ymm0[16],ymm2[17],ymm0[17],ymm2[18],ymm0[18],ymm2[19],ymm0[19],ymm2[20],ymm0[20],ymm2[21],ymm0[21],ymm2[22],ymm0[22],ymm2[23],ymm0[23]
; AVX512F-NEXT:    vpmullw %ymm2, %ymm0, %ymm0
; AVX512F-NEXT:    vpand %ymm4, %ymm0, %ymm0
; AVX512F-NEXT:    vpackuswb %ymm3, %ymm0, %ymm0
; AVX512F-NEXT:    vpaddb %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-FALLBACK-LABEL: vec256_i8_signed_mem_reg:
; AVX512VL-FALLBACK:       # %bb.0:
; AVX512VL-FALLBACK-NEXT:    vmovdqa (%rdi), %ymm1
; AVX512VL-FALLBACK-NEXT:    vpcmpgtb %ymm0, %ymm1, %ymm2
; AVX512VL-FALLBACK-NEXT:    vpor {{.*}}(%rip), %ymm2, %ymm2
; AVX512VL-FALLBACK-NEXT:    vpminsb %ymm0, %ymm1, %ymm3
; AVX512VL-FALLBACK-NEXT:    vpmaxsb %ymm0, %ymm1, %ymm0
; AVX512VL-FALLBACK-NEXT:    vpsubb %ymm3, %ymm0, %ymm0
; AVX512VL-FALLBACK-NEXT:    vpsrlw $1, %ymm0, %ymm0
; AVX512VL-FALLBACK-NEXT:    vpand {{.*}}(%rip), %ymm0, %ymm0
; AVX512VL-FALLBACK-NEXT:    vpunpckhbw {{.*#+}} ymm3 = ymm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15,24,24,25,25,26,26,27,27,28,28,29,29,30,30,31,31]
; AVX512VL-FALLBACK-NEXT:    vpunpckhbw {{.*#+}} ymm4 = ymm2[8],ymm0[8],ymm2[9],ymm0[9],ymm2[10],ymm0[10],ymm2[11],ymm0[11],ymm2[12],ymm0[12],ymm2[13],ymm0[13],ymm2[14],ymm0[14],ymm2[15],ymm0[15],ymm2[24],ymm0[24],ymm2[25],ymm0[25],ymm2[26],ymm0[26],ymm2[27],ymm0[27],ymm2[28],ymm0[28],ymm2[29],ymm0[29],ymm2[30],ymm0[30],ymm2[31],ymm0[31]
; AVX512VL-FALLBACK-NEXT:    vpmullw %ymm4, %ymm3, %ymm3
; AVX512VL-FALLBACK-NEXT:    vmovdqa {{.*#+}} ymm4 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512VL-FALLBACK-NEXT:    vpand %ymm4, %ymm3, %ymm3
; AVX512VL-FALLBACK-NEXT:    vpunpcklbw {{.*#+}} ymm0 = ymm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23]
; AVX512VL-FALLBACK-NEXT:    vpunpcklbw {{.*#+}} ymm2 = ymm2[0],ymm0[0],ymm2[1],ymm0[1],ymm2[2],ymm0[2],ymm2[3],ymm0[3],ymm2[4],ymm0[4],ymm2[5],ymm0[5],ymm2[6],ymm0[6],ymm2[7],ymm0[7],ymm2[16],ymm0[16],ymm2[17],ymm0[17],ymm2[18],ymm0[18],ymm2[19],ymm0[19],ymm2[20],ymm0[20],ymm2[21],ymm0[21],ymm2[22],ymm0[22],ymm2[23],ymm0[23]
; AVX512VL-FALLBACK-NEXT:    vpmullw %ymm2, %ymm0, %ymm0
; AVX512VL-FALLBACK-NEXT:    vpand %ymm4, %ymm0, %ymm0
; AVX512VL-FALLBACK-NEXT:    vpackuswb %ymm3, %ymm0, %ymm0
; AVX512VL-FALLBACK-NEXT:    vpaddb %ymm1, %ymm0, %ymm0
; AVX512VL-FALLBACK-NEXT:    retq
;
; AVX512BW-FALLBACK-LABEL: vec256_i8_signed_mem_reg:
; AVX512BW-FALLBACK:       # %bb.0:
; AVX512BW-FALLBACK-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-FALLBACK-NEXT:    vmovdqa (%rdi), %ymm1
; AVX512BW-FALLBACK-NEXT:    vpcmpgtb %zmm0, %zmm1, %k1
; AVX512BW-FALLBACK-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512BW-FALLBACK-NEXT:    vmovdqa {{.*#+}} ymm3 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; AVX512BW-FALLBACK-NEXT:    vmovdqu8 %zmm2, %zmm3 {%k1}
; AVX512BW-FALLBACK-NEXT:    vpminsb %ymm0, %ymm1, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpmaxsb %ymm0, %ymm1, %ymm0
; AVX512BW-FALLBACK-NEXT:    vpsubb %ymm2, %ymm0, %ymm0
; AVX512BW-FALLBACK-NEXT:    vpsrlw $1, %ymm0, %ymm0
; AVX512BW-FALLBACK-NEXT:    vpand {{.*}}(%rip), %ymm0, %ymm0
; AVX512BW-FALLBACK-NEXT:    vpmovzxbw {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero,ymm0[16],zero,ymm0[17],zero,ymm0[18],zero,ymm0[19],zero,ymm0[20],zero,ymm0[21],zero,ymm0[22],zero,ymm0[23],zero,ymm0[24],zero,ymm0[25],zero,ymm0[26],zero,ymm0[27],zero,ymm0[28],zero,ymm0[29],zero,ymm0[30],zero,ymm0[31],zero
; AVX512BW-FALLBACK-NEXT:    vpmovzxbw {{.*#+}} zmm2 = ymm3[0],zero,ymm3[1],zero,ymm3[2],zero,ymm3[3],zero,ymm3[4],zero,ymm3[5],zero,ymm3[6],zero,ymm3[7],zero,ymm3[8],zero,ymm3[9],zero,ymm3[10],zero,ymm3[11],zero,ymm3[12],zero,ymm3[13],zero,ymm3[14],zero,ymm3[15],zero,ymm3[16],zero,ymm3[17],zero,ymm3[18],zero,ymm3[19],zero,ymm3[20],zero,ymm3[21],zero,ymm3[22],zero,ymm3[23],zero,ymm3[24],zero,ymm3[25],zero,ymm3[26],zero,ymm3[27],zero,ymm3[28],zero,ymm3[29],zero,ymm3[30],zero,ymm3[31],zero
; AVX512BW-FALLBACK-NEXT:    vpmullw %zmm2, %zmm0, %zmm0
; AVX512BW-FALLBACK-NEXT:    vpmovwb %zmm0, %ymm0
; AVX512BW-FALLBACK-NEXT:    vpaddb %ymm1, %ymm0, %ymm0
; AVX512BW-FALLBACK-NEXT:    retq
;
; AVX512VLBW-LABEL: vec256_i8_signed_mem_reg:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vmovdqa (%rdi), %ymm1
; AVX512VLBW-NEXT:    vpcmpgtb %ymm0, %ymm1, %k1
; AVX512VLBW-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512VLBW-NEXT:    vmovdqa {{.*#+}} ymm3 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; AVX512VLBW-NEXT:    vmovdqu8 %ymm2, %ymm3 {%k1}
; AVX512VLBW-NEXT:    vpminsb %ymm0, %ymm1, %ymm2
; AVX512VLBW-NEXT:    vpmaxsb %ymm0, %ymm1, %ymm0
; AVX512VLBW-NEXT:    vpsubb %ymm2, %ymm0, %ymm0
; AVX512VLBW-NEXT:    vpsrlw $1, %ymm0, %ymm0
; AVX512VLBW-NEXT:    vpand {{.*}}(%rip), %ymm0, %ymm0
; AVX512VLBW-NEXT:    vpmovzxbw {{.*#+}} zmm0 = ymm0[0],zero,ymm0[1],zero,ymm0[2],zero,ymm0[3],zero,ymm0[4],zero,ymm0[5],zero,ymm0[6],zero,ymm0[7],zero,ymm0[8],zero,ymm0[9],zero,ymm0[10],zero,ymm0[11],zero,ymm0[12],zero,ymm0[13],zero,ymm0[14],zero,ymm0[15],zero,ymm0[16],zero,ymm0[17],zero,ymm0[18],zero,ymm0[19],zero,ymm0[20],zero,ymm0[21],zero,ymm0[22],zero,ymm0[23],zero,ymm0[24],zero,ymm0[25],zero,ymm0[26],zero,ymm0[27],zero,ymm0[28],zero,ymm0[29],zero,ymm0[30],zero,ymm0[31],zero
; AVX512VLBW-NEXT:    vpmovzxbw {{.*#+}} zmm2 = ymm3[0],zero,ymm3[1],zero,ymm3[2],zero,ymm3[3],zero,ymm3[4],zero,ymm3[5],zero,ymm3[6],zero,ymm3[7],zero,ymm3[8],zero,ymm3[9],zero,ymm3[10],zero,ymm3[11],zero,ymm3[12],zero,ymm3[13],zero,ymm3[14],zero,ymm3[15],zero,ymm3[16],zero,ymm3[17],zero,ymm3[18],zero,ymm3[19],zero,ymm3[20],zero,ymm3[21],zero,ymm3[22],zero,ymm3[23],zero,ymm3[24],zero,ymm3[25],zero,ymm3[26],zero,ymm3[27],zero,ymm3[28],zero,ymm3[29],zero,ymm3[30],zero,ymm3[31],zero
; AVX512VLBW-NEXT:    vpmullw %zmm2, %zmm0, %zmm0
; AVX512VLBW-NEXT:    vpmovwb %zmm0, %ymm0
; AVX512VLBW-NEXT:    vpaddb %ymm1, %ymm0, %ymm0
; AVX512VLBW-NEXT:    retq
  %a1 = load <32 x i8>, <32 x i8>* %a1_addr
  %t3 = icmp sgt <32 x i8> %a1, %a2 ; signed
  %t4 = select <32 x i1> %t3, <32 x i8> <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>, <32 x i8> <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %t5 = select <32 x i1> %t3, <32 x i8> %a2, <32 x i8> %a1
  %t6 = select <32 x i1> %t3, <32 x i8> %a1, <32 x i8> %a2
  %t7 = sub <32 x i8> %t6, %t5
  %t8 = lshr <32 x i8> %t7, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %t9 = mul nsw <32 x i8> %t8, %t4 ; signed
  %a10 = add nsw <32 x i8> %t9, %a1 ; signed
  ret <32 x i8> %a10
}

define <32 x i8> @vec256_i8_signed_reg_mem(<32 x i8> %a1, <32 x i8>* %a2_addr) nounwind {
; AVX1-FALLBACK-LABEL: vec256_i8_signed_reg_mem:
; AVX1-FALLBACK:       # %bb.0:
; AVX1-FALLBACK-NEXT:    vmovdqa (%rdi), %xmm2
; AVX1-FALLBACK-NEXT:    vmovdqa 16(%rdi), %xmm3
; AVX1-FALLBACK-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-FALLBACK-NEXT:    vpcmpgtb %xmm3, %xmm1, %xmm8
; AVX1-FALLBACK-NEXT:    vpcmpgtb %xmm2, %xmm0, %xmm5
; AVX1-FALLBACK-NEXT:    vpminsb %xmm3, %xmm1, %xmm6
; AVX1-FALLBACK-NEXT:    vpminsb %xmm2, %xmm0, %xmm7
; AVX1-FALLBACK-NEXT:    vpmaxsb %xmm3, %xmm1, %xmm3
; AVX1-FALLBACK-NEXT:    vpsubb %xmm6, %xmm3, %xmm3
; AVX1-FALLBACK-NEXT:    vpmaxsb %xmm2, %xmm0, %xmm2
; AVX1-FALLBACK-NEXT:    vpsubb %xmm7, %xmm2, %xmm2
; AVX1-FALLBACK-NEXT:    vpsrlw $1, %xmm3, %xmm3
; AVX1-FALLBACK-NEXT:    vmovdqa {{.*#+}} xmm6 = [127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127]
; AVX1-FALLBACK-NEXT:    vpand %xmm6, %xmm3, %xmm3
; AVX1-FALLBACK-NEXT:    vpsrlw $1, %xmm2, %xmm2
; AVX1-FALLBACK-NEXT:    vpand %xmm6, %xmm2, %xmm2
; AVX1-FALLBACK-NEXT:    vpunpckhbw {{.*#+}} xmm6 = xmm2[8],xmm0[8],xmm2[9],xmm0[9],xmm2[10],xmm0[10],xmm2[11],xmm0[11],xmm2[12],xmm0[12],xmm2[13],xmm0[13],xmm2[14],xmm0[14],xmm2[15],xmm0[15]
; AVX1-FALLBACK-NEXT:    vmovdqa {{.*#+}} xmm7 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; AVX1-FALLBACK-NEXT:    vpor %xmm7, %xmm5, %xmm5
; AVX1-FALLBACK-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm5[8],xmm0[8],xmm5[9],xmm0[9],xmm5[10],xmm0[10],xmm5[11],xmm0[11],xmm5[12],xmm0[12],xmm5[13],xmm0[13],xmm5[14],xmm0[14],xmm5[15],xmm0[15]
; AVX1-FALLBACK-NEXT:    vpmullw %xmm4, %xmm6, %xmm4
; AVX1-FALLBACK-NEXT:    vmovdqa {{.*#+}} xmm6 = [255,255,255,255,255,255,255,255]
; AVX1-FALLBACK-NEXT:    vpand %xmm6, %xmm4, %xmm4
; AVX1-FALLBACK-NEXT:    vpmovzxbw {{.*#+}} xmm2 = xmm2[0],zero,xmm2[1],zero,xmm2[2],zero,xmm2[3],zero,xmm2[4],zero,xmm2[5],zero,xmm2[6],zero,xmm2[7],zero
; AVX1-FALLBACK-NEXT:    vpmovzxbw {{.*#+}} xmm5 = xmm5[0],zero,xmm5[1],zero,xmm5[2],zero,xmm5[3],zero,xmm5[4],zero,xmm5[5],zero,xmm5[6],zero,xmm5[7],zero
; AVX1-FALLBACK-NEXT:    vpmullw %xmm5, %xmm2, %xmm2
; AVX1-FALLBACK-NEXT:    vpand %xmm6, %xmm2, %xmm2
; AVX1-FALLBACK-NEXT:    vpackuswb %xmm4, %xmm2, %xmm2
; AVX1-FALLBACK-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm3[8],xmm0[8],xmm3[9],xmm0[9],xmm3[10],xmm0[10],xmm3[11],xmm0[11],xmm3[12],xmm0[12],xmm3[13],xmm0[13],xmm3[14],xmm0[14],xmm3[15],xmm0[15]
; AVX1-FALLBACK-NEXT:    vpor %xmm7, %xmm8, %xmm5
; AVX1-FALLBACK-NEXT:    vpunpckhbw {{.*#+}} xmm7 = xmm5[8],xmm0[8],xmm5[9],xmm0[9],xmm5[10],xmm0[10],xmm5[11],xmm0[11],xmm5[12],xmm0[12],xmm5[13],xmm0[13],xmm5[14],xmm0[14],xmm5[15],xmm0[15]
; AVX1-FALLBACK-NEXT:    vpmullw %xmm7, %xmm4, %xmm4
; AVX1-FALLBACK-NEXT:    vpand %xmm6, %xmm4, %xmm4
; AVX1-FALLBACK-NEXT:    vpmovzxbw {{.*#+}} xmm3 = xmm3[0],zero,xmm3[1],zero,xmm3[2],zero,xmm3[3],zero,xmm3[4],zero,xmm3[5],zero,xmm3[6],zero,xmm3[7],zero
; AVX1-FALLBACK-NEXT:    vpmovzxbw {{.*#+}} xmm5 = xmm5[0],zero,xmm5[1],zero,xmm5[2],zero,xmm5[3],zero,xmm5[4],zero,xmm5[5],zero,xmm5[6],zero,xmm5[7],zero
; AVX1-FALLBACK-NEXT:    vpmullw %xmm5, %xmm3, %xmm3
; AVX1-FALLBACK-NEXT:    vpand %xmm6, %xmm3, %xmm3
; AVX1-FALLBACK-NEXT:    vpackuswb %xmm4, %xmm3, %xmm3
; AVX1-FALLBACK-NEXT:    vpaddb %xmm1, %xmm3, %xmm1
; AVX1-FALLBACK-NEXT:    vpaddb %xmm0, %xmm2, %xmm0
; AVX1-FALLBACK-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-FALLBACK-NEXT:    retq
;
; AVX2-LABEL: vec256_i8_signed_reg_mem:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %ymm1
; AVX2-NEXT:    vpcmpgtb %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vpor {{.*}}(%rip), %ymm2, %ymm2
; AVX2-NEXT:    vpminsb %ymm1, %ymm0, %ymm3
; AVX2-NEXT:    vpmaxsb %ymm1, %ymm0, %ymm1
; AVX2-NEXT:    vpsubb %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX2-NEXT:    vpand {{.*}}(%rip), %ymm1, %ymm1
; AVX2-NEXT:    vpunpckhbw {{.*#+}} ymm3 = ymm1[8],ymm0[8],ymm1[9],ymm0[9],ymm1[10],ymm0[10],ymm1[11],ymm0[11],ymm1[12],ymm0[12],ymm1[13],ymm0[13],ymm1[14],ymm0[14],ymm1[15],ymm0[15],ymm1[24],ymm0[24],ymm1[25],ymm0[25],ymm1[26],ymm0[26],ymm1[27],ymm0[27],ymm1[28],ymm0[28],ymm1[29],ymm0[29],ymm1[30],ymm0[30],ymm1[31],ymm0[31]
; AVX2-NEXT:    vpunpckhbw {{.*#+}} ymm4 = ymm2[8],ymm0[8],ymm2[9],ymm0[9],ymm2[10],ymm0[10],ymm2[11],ymm0[11],ymm2[12],ymm0[12],ymm2[13],ymm0[13],ymm2[14],ymm0[14],ymm2[15],ymm0[15],ymm2[24],ymm0[24],ymm2[25],ymm0[25],ymm2[26],ymm0[26],ymm2[27],ymm0[27],ymm2[28],ymm0[28],ymm2[29],ymm0[29],ymm2[30],ymm0[30],ymm2[31],ymm0[31]
; AVX2-NEXT:    vpmullw %ymm4, %ymm3, %ymm3
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm4 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX2-NEXT:    vpand %ymm4, %ymm3, %ymm3
; AVX2-NEXT:    vpunpcklbw {{.*#+}} ymm1 = ymm1[0],ymm0[0],ymm1[1],ymm0[1],ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[4],ymm0[4],ymm1[5],ymm0[5],ymm1[6],ymm0[6],ymm1[7],ymm0[7],ymm1[16],ymm0[16],ymm1[17],ymm0[17],ymm1[18],ymm0[18],ymm1[19],ymm0[19],ymm1[20],ymm0[20],ymm1[21],ymm0[21],ymm1[22],ymm0[22],ymm1[23],ymm0[23]
; AVX2-NEXT:    vpunpcklbw {{.*#+}} ymm2 = ymm2[0],ymm0[0],ymm2[1],ymm0[1],ymm2[2],ymm0[2],ymm2[3],ymm0[3],ymm2[4],ymm0[4],ymm2[5],ymm0[5],ymm2[6],ymm0[6],ymm2[7],ymm0[7],ymm2[16],ymm0[16],ymm2[17],ymm0[17],ymm2[18],ymm0[18],ymm2[19],ymm0[19],ymm2[20],ymm0[20],ymm2[21],ymm0[21],ymm2[22],ymm0[22],ymm2[23],ymm0[23]
; AVX2-NEXT:    vpmullw %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpand %ymm4, %ymm1, %ymm1
; AVX2-NEXT:    vpackuswb %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; XOP-FALLBACK-LABEL: vec256_i8_signed_reg_mem:
; XOP-FALLBACK:       # %bb.0:
; XOP-FALLBACK-NEXT:    vmovdqa (%rdi), %xmm1
; XOP-FALLBACK-NEXT:    vmovdqa 16(%rdi), %xmm2
; XOP-FALLBACK-NEXT:    vextractf128 $1, %ymm0, %xmm3
; XOP-FALLBACK-NEXT:    vpcomgtb %xmm2, %xmm3, %xmm8
; XOP-FALLBACK-NEXT:    vpcomgtb %xmm1, %xmm0, %xmm5
; XOP-FALLBACK-NEXT:    vpminsb %xmm2, %xmm3, %xmm6
; XOP-FALLBACK-NEXT:    vpminsb %xmm1, %xmm0, %xmm7
; XOP-FALLBACK-NEXT:    vpmaxsb %xmm2, %xmm3, %xmm2
; XOP-FALLBACK-NEXT:    vpsubb %xmm6, %xmm2, %xmm2
; XOP-FALLBACK-NEXT:    vpmaxsb %xmm1, %xmm0, %xmm1
; XOP-FALLBACK-NEXT:    vpsubb %xmm7, %xmm1, %xmm1
; XOP-FALLBACK-NEXT:    vpcmpeqd %xmm6, %xmm6, %xmm6
; XOP-FALLBACK-NEXT:    vpshlb %xmm6, %xmm2, %xmm2
; XOP-FALLBACK-NEXT:    vpshlb %xmm6, %xmm1, %xmm1
; XOP-FALLBACK-NEXT:    vpunpckhbw {{.*#+}} xmm6 = xmm1[8],xmm0[8],xmm1[9],xmm0[9],xmm1[10],xmm0[10],xmm1[11],xmm0[11],xmm1[12],xmm0[12],xmm1[13],xmm0[13],xmm1[14],xmm0[14],xmm1[15],xmm0[15]
; XOP-FALLBACK-NEXT:    vmovdqa {{.*#+}} xmm7 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; XOP-FALLBACK-NEXT:    vpor %xmm7, %xmm5, %xmm5
; XOP-FALLBACK-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm5[8],xmm0[8],xmm5[9],xmm0[9],xmm5[10],xmm0[10],xmm5[11],xmm0[11],xmm5[12],xmm0[12],xmm5[13],xmm0[13],xmm5[14],xmm0[14],xmm5[15],xmm0[15]
; XOP-FALLBACK-NEXT:    vpmullw %xmm4, %xmm6, %xmm4
; XOP-FALLBACK-NEXT:    vpmovzxbw {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero,xmm1[4],zero,xmm1[5],zero,xmm1[6],zero,xmm1[7],zero
; XOP-FALLBACK-NEXT:    vpmovzxbw {{.*#+}} xmm5 = xmm5[0],zero,xmm5[1],zero,xmm5[2],zero,xmm5[3],zero,xmm5[4],zero,xmm5[5],zero,xmm5[6],zero,xmm5[7],zero
; XOP-FALLBACK-NEXT:    vpmullw %xmm5, %xmm1, %xmm1
; XOP-FALLBACK-NEXT:    vmovdqa {{.*#+}} xmm5 = [0,2,4,6,8,10,12,14,16,18,20,22,24,26,28,30]
; XOP-FALLBACK-NEXT:    vpperm %xmm5, %xmm4, %xmm1, %xmm1
; XOP-FALLBACK-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm2[8],xmm0[8],xmm2[9],xmm0[9],xmm2[10],xmm0[10],xmm2[11],xmm0[11],xmm2[12],xmm0[12],xmm2[13],xmm0[13],xmm2[14],xmm0[14],xmm2[15],xmm0[15]
; XOP-FALLBACK-NEXT:    vpor %xmm7, %xmm8, %xmm6
; XOP-FALLBACK-NEXT:    vpunpckhbw {{.*#+}} xmm7 = xmm6[8],xmm0[8],xmm6[9],xmm0[9],xmm6[10],xmm0[10],xmm6[11],xmm0[11],xmm6[12],xmm0[12],xmm6[13],xmm0[13],xmm6[14],xmm0[14],xmm6[15],xmm0[15]
; XOP-FALLBACK-NEXT:    vpmullw %xmm7, %xmm4, %xmm4
; XOP-FALLBACK-NEXT:    vpmovzxbw {{.*#+}} xmm2 = xmm2[0],zero,xmm2[1],zero,xmm2[2],zero,xmm2[3],zero,xmm2[4],zero,xmm2[5],zero,xmm2[6],zero,xmm2[7],zero
; XOP-FALLBACK-NEXT:    vpmovzxbw {{.*#+}} xmm6 = xmm6[0],zero,xmm6[1],zero,xmm6[2],zero,xmm6[3],zero,xmm6[4],zero,xmm6[5],zero,xmm6[6],zero,xmm6[7],zero
; XOP-FALLBACK-NEXT:    vpmullw %xmm6, %xmm2, %xmm2
; XOP-FALLBACK-NEXT:    vpperm %xmm5, %xmm4, %xmm2, %xmm2
; XOP-FALLBACK-NEXT:    vpaddb %xmm3, %xmm2, %xmm2
; XOP-FALLBACK-NEXT:    vpaddb %xmm0, %xmm1, %xmm0
; XOP-FALLBACK-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOP-FALLBACK-NEXT:    retq
;
; XOPAVX1-LABEL: vec256_i8_signed_reg_mem:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vmovdqa (%rdi), %xmm1
; XOPAVX1-NEXT:    vmovdqa 16(%rdi), %xmm2
; XOPAVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; XOPAVX1-NEXT:    vpcomgtb %xmm2, %xmm3, %xmm8
; XOPAVX1-NEXT:    vpcomgtb %xmm1, %xmm0, %xmm5
; XOPAVX1-NEXT:    vpminsb %xmm2, %xmm3, %xmm6
; XOPAVX1-NEXT:    vpminsb %xmm1, %xmm0, %xmm7
; XOPAVX1-NEXT:    vpmaxsb %xmm2, %xmm3, %xmm2
; XOPAVX1-NEXT:    vpsubb %xmm6, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpmaxsb %xmm1, %xmm0, %xmm1
; XOPAVX1-NEXT:    vpsubb %xmm7, %xmm1, %xmm1
; XOPAVX1-NEXT:    vpcmpeqd %xmm6, %xmm6, %xmm6
; XOPAVX1-NEXT:    vpshlb %xmm6, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpshlb %xmm6, %xmm1, %xmm1
; XOPAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm6 = xmm1[8],xmm0[8],xmm1[9],xmm0[9],xmm1[10],xmm0[10],xmm1[11],xmm0[11],xmm1[12],xmm0[12],xmm1[13],xmm0[13],xmm1[14],xmm0[14],xmm1[15],xmm0[15]
; XOPAVX1-NEXT:    vmovdqa {{.*#+}} xmm7 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; XOPAVX1-NEXT:    vpor %xmm7, %xmm5, %xmm5
; XOPAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm5[8],xmm0[8],xmm5[9],xmm0[9],xmm5[10],xmm0[10],xmm5[11],xmm0[11],xmm5[12],xmm0[12],xmm5[13],xmm0[13],xmm5[14],xmm0[14],xmm5[15],xmm0[15]
; XOPAVX1-NEXT:    vpmullw %xmm4, %xmm6, %xmm4
; XOPAVX1-NEXT:    vpmovzxbw {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero,xmm1[4],zero,xmm1[5],zero,xmm1[6],zero,xmm1[7],zero
; XOPAVX1-NEXT:    vpmovzxbw {{.*#+}} xmm5 = xmm5[0],zero,xmm5[1],zero,xmm5[2],zero,xmm5[3],zero,xmm5[4],zero,xmm5[5],zero,xmm5[6],zero,xmm5[7],zero
; XOPAVX1-NEXT:    vpmullw %xmm5, %xmm1, %xmm1
; XOPAVX1-NEXT:    vmovdqa {{.*#+}} xmm5 = [0,2,4,6,8,10,12,14,16,18,20,22,24,26,28,30]
; XOPAVX1-NEXT:    vpperm %xmm5, %xmm4, %xmm1, %xmm1
; XOPAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm2[8],xmm0[8],xmm2[9],xmm0[9],xmm2[10],xmm0[10],xmm2[11],xmm0[11],xmm2[12],xmm0[12],xmm2[13],xmm0[13],xmm2[14],xmm0[14],xmm2[15],xmm0[15]
; XOPAVX1-NEXT:    vpor %xmm7, %xmm8, %xmm6
; XOPAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm7 = xmm6[8],xmm0[8],xmm6[9],xmm0[9],xmm6[10],xmm0[10],xmm6[11],xmm0[11],xmm6[12],xmm0[12],xmm6[13],xmm0[13],xmm6[14],xmm0[14],xmm6[15],xmm0[15]
; XOPAVX1-NEXT:    vpmullw %xmm7, %xmm4, %xmm4
; XOPAVX1-NEXT:    vpmovzxbw {{.*#+}} xmm2 = xmm2[0],zero,xmm2[1],zero,xmm2[2],zero,xmm2[3],zero,xmm2[4],zero,xmm2[5],zero,xmm2[6],zero,xmm2[7],zero
; XOPAVX1-NEXT:    vpmovzxbw {{.*#+}} xmm6 = xmm6[0],zero,xmm6[1],zero,xmm6[2],zero,xmm6[3],zero,xmm6[4],zero,xmm6[5],zero,xmm6[6],zero,xmm6[7],zero
; XOPAVX1-NEXT:    vpmullw %xmm6, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpperm %xmm5, %xmm4, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpaddb %xmm3, %xmm2, %xmm2
; XOPAVX1-NEXT:    vpaddb %xmm0, %xmm1, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; XOPAVX1-NEXT:    retq
;
; AVX512F-LABEL: vec256_i8_signed_reg_mem:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vmovdqa (%rdi), %ymm1
; AVX512F-NEXT:    vpcmpgtb %ymm1, %ymm0, %ymm2
; AVX512F-NEXT:    vpor {{.*}}(%rip), %ymm2, %ymm2
; AVX512F-NEXT:    vpminsb %ymm1, %ymm0, %ymm3
; AVX512F-NEXT:    vpmaxsb %ymm1, %ymm0, %ymm1
; AVX512F-NEXT:    vpsubb %ymm3, %ymm1, %ymm1
; AVX512F-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512F-NEXT:    vpand {{.*}}(%rip), %ymm1, %ymm1
; AVX512F-NEXT:    vpunpckhbw {{.*#+}} ymm3 = ymm1[8],ymm0[8],ymm1[9],ymm0[9],ymm1[10],ymm0[10],ymm1[11],ymm0[11],ymm1[12],ymm0[12],ymm1[13],ymm0[13],ymm1[14],ymm0[14],ymm1[15],ymm0[15],ymm1[24],ymm0[24],ymm1[25],ymm0[25],ymm1[26],ymm0[26],ymm1[27],ymm0[27],ymm1[28],ymm0[28],ymm1[29],ymm0[29],ymm1[30],ymm0[30],ymm1[31],ymm0[31]
; AVX512F-NEXT:    vpunpckhbw {{.*#+}} ymm4 = ymm2[8],ymm0[8],ymm2[9],ymm0[9],ymm2[10],ymm0[10],ymm2[11],ymm0[11],ymm2[12],ymm0[12],ymm2[13],ymm0[13],ymm2[14],ymm0[14],ymm2[15],ymm0[15],ymm2[24],ymm0[24],ymm2[25],ymm0[25],ymm2[26],ymm0[26],ymm2[27],ymm0[27],ymm2[28],ymm0[28],ymm2[29],ymm0[29],ymm2[30],ymm0[30],ymm2[31],ymm0[31]
; AVX512F-NEXT:    vpmullw %ymm4, %ymm3, %ymm3
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm4 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-NEXT:    vpand %ymm4, %ymm3, %ymm3
; AVX512F-NEXT:    vpunpcklbw {{.*#+}} ymm1 = ymm1[0],ymm0[0],ymm1[1],ymm0[1],ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[4],ymm0[4],ymm1[5],ymm0[5],ymm1[6],ymm0[6],ymm1[7],ymm0[7],ymm1[16],ymm0[16],ymm1[17],ymm0[17],ymm1[18],ymm0[18],ymm1[19],ymm0[19],ymm1[20],ymm0[20],ymm1[21],ymm0[21],ymm1[22],ymm0[22],ymm1[23],ymm0[23]
; AVX512F-NEXT:    vpunpcklbw {{.*#+}} ymm2 = ymm2[0],ymm0[0],ymm2[1],ymm0[1],ymm2[2],ymm0[2],ymm2[3],ymm0[3],ymm2[4],ymm0[4],ymm2[5],ymm0[5],ymm2[6],ymm0[6],ymm2[7],ymm0[7],ymm2[16],ymm0[16],ymm2[17],ymm0[17],ymm2[18],ymm0[18],ymm2[19],ymm0[19],ymm2[20],ymm0[20],ymm2[21],ymm0[21],ymm2[22],ymm0[22],ymm2[23],ymm0[23]
; AVX512F-NEXT:    vpmullw %ymm2, %ymm1, %ymm1
; AVX512F-NEXT:    vpand %ymm4, %ymm1, %ymm1
; AVX512F-NEXT:    vpackuswb %ymm3, %ymm1, %ymm1
; AVX512F-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-FALLBACK-LABEL: vec256_i8_signed_reg_mem:
; AVX512VL-FALLBACK:       # %bb.0:
; AVX512VL-FALLBACK-NEXT:    vmovdqa (%rdi), %ymm1
; AVX512VL-FALLBACK-NEXT:    vpcmpgtb %ymm1, %ymm0, %ymm2
; AVX512VL-FALLBACK-NEXT:    vpor {{.*}}(%rip), %ymm2, %ymm2
; AVX512VL-FALLBACK-NEXT:    vpminsb %ymm1, %ymm0, %ymm3
; AVX512VL-FALLBACK-NEXT:    vpmaxsb %ymm1, %ymm0, %ymm1
; AVX512VL-FALLBACK-NEXT:    vpsubb %ymm3, %ymm1, %ymm1
; AVX512VL-FALLBACK-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512VL-FALLBACK-NEXT:    vpand {{.*}}(%rip), %ymm1, %ymm1
; AVX512VL-FALLBACK-NEXT:    vpunpckhbw {{.*#+}} ymm3 = ymm1[8],ymm0[8],ymm1[9],ymm0[9],ymm1[10],ymm0[10],ymm1[11],ymm0[11],ymm1[12],ymm0[12],ymm1[13],ymm0[13],ymm1[14],ymm0[14],ymm1[15],ymm0[15],ymm1[24],ymm0[24],ymm1[25],ymm0[25],ymm1[26],ymm0[26],ymm1[27],ymm0[27],ymm1[28],ymm0[28],ymm1[29],ymm0[29],ymm1[30],ymm0[30],ymm1[31],ymm0[31]
; AVX512VL-FALLBACK-NEXT:    vpunpckhbw {{.*#+}} ymm4 = ymm2[8],ymm0[8],ymm2[9],ymm0[9],ymm2[10],ymm0[10],ymm2[11],ymm0[11],ymm2[12],ymm0[12],ymm2[13],ymm0[13],ymm2[14],ymm0[14],ymm2[15],ymm0[15],ymm2[24],ymm0[24],ymm2[25],ymm0[25],ymm2[26],ymm0[26],ymm2[27],ymm0[27],ymm2[28],ymm0[28],ymm2[29],ymm0[29],ymm2[30],ymm0[30],ymm2[31],ymm0[31]
; AVX512VL-FALLBACK-NEXT:    vpmullw %ymm4, %ymm3, %ymm3
; AVX512VL-FALLBACK-NEXT:    vmovdqa {{.*#+}} ymm4 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512VL-FALLBACK-NEXT:    vpand %ymm4, %ymm3, %ymm3
; AVX512VL-FALLBACK-NEXT:    vpunpcklbw {{.*#+}} ymm1 = ymm1[0],ymm0[0],ymm1[1],ymm0[1],ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[4],ymm0[4],ymm1[5],ymm0[5],ymm1[6],ymm0[6],ymm1[7],ymm0[7],ymm1[16],ymm0[16],ymm1[17],ymm0[17],ymm1[18],ymm0[18],ymm1[19],ymm0[19],ymm1[20],ymm0[20],ymm1[21],ymm0[21],ymm1[22],ymm0[22],ymm1[23],ymm0[23]
; AVX512VL-FALLBACK-NEXT:    vpunpcklbw {{.*#+}} ymm2 = ymm2[0],ymm0[0],ymm2[1],ymm0[1],ymm2[2],ymm0[2],ymm2[3],ymm0[3],ymm2[4],ymm0[4],ymm2[5],ymm0[5],ymm2[6],ymm0[6],ymm2[7],ymm0[7],ymm2[16],ymm0[16],ymm2[17],ymm0[17],ymm2[18],ymm0[18],ymm2[19],ymm0[19],ymm2[20],ymm0[20],ymm2[21],ymm0[21],ymm2[22],ymm0[22],ymm2[23],ymm0[23]
; AVX512VL-FALLBACK-NEXT:    vpmullw %ymm2, %ymm1, %ymm1
; AVX512VL-FALLBACK-NEXT:    vpand %ymm4, %ymm1, %ymm1
; AVX512VL-FALLBACK-NEXT:    vpackuswb %ymm3, %ymm1, %ymm1
; AVX512VL-FALLBACK-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX512VL-FALLBACK-NEXT:    retq
;
; AVX512BW-FALLBACK-LABEL: vec256_i8_signed_reg_mem:
; AVX512BW-FALLBACK:       # %bb.0:
; AVX512BW-FALLBACK-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-FALLBACK-NEXT:    vmovdqa (%rdi), %ymm1
; AVX512BW-FALLBACK-NEXT:    vpcmpgtb %zmm1, %zmm0, %k1
; AVX512BW-FALLBACK-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512BW-FALLBACK-NEXT:    vmovdqa {{.*#+}} ymm3 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; AVX512BW-FALLBACK-NEXT:    vmovdqu8 %zmm2, %zmm3 {%k1}
; AVX512BW-FALLBACK-NEXT:    vpminsb %ymm1, %ymm0, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpmaxsb %ymm1, %ymm0, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpsubb %ymm2, %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpand {{.*}}(%rip), %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpmovzxbw {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero,ymm1[16],zero,ymm1[17],zero,ymm1[18],zero,ymm1[19],zero,ymm1[20],zero,ymm1[21],zero,ymm1[22],zero,ymm1[23],zero,ymm1[24],zero,ymm1[25],zero,ymm1[26],zero,ymm1[27],zero,ymm1[28],zero,ymm1[29],zero,ymm1[30],zero,ymm1[31],zero
; AVX512BW-FALLBACK-NEXT:    vpmovzxbw {{.*#+}} zmm2 = ymm3[0],zero,ymm3[1],zero,ymm3[2],zero,ymm3[3],zero,ymm3[4],zero,ymm3[5],zero,ymm3[6],zero,ymm3[7],zero,ymm3[8],zero,ymm3[9],zero,ymm3[10],zero,ymm3[11],zero,ymm3[12],zero,ymm3[13],zero,ymm3[14],zero,ymm3[15],zero,ymm3[16],zero,ymm3[17],zero,ymm3[18],zero,ymm3[19],zero,ymm3[20],zero,ymm3[21],zero,ymm3[22],zero,ymm3[23],zero,ymm3[24],zero,ymm3[25],zero,ymm3[26],zero,ymm3[27],zero,ymm3[28],zero,ymm3[29],zero,ymm3[30],zero,ymm3[31],zero
; AVX512BW-FALLBACK-NEXT:    vpmullw %zmm2, %zmm1, %zmm1
; AVX512BW-FALLBACK-NEXT:    vpmovwb %zmm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX512BW-FALLBACK-NEXT:    retq
;
; AVX512VLBW-LABEL: vec256_i8_signed_reg_mem:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vmovdqa (%rdi), %ymm1
; AVX512VLBW-NEXT:    vpcmpgtb %ymm1, %ymm0, %k1
; AVX512VLBW-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512VLBW-NEXT:    vmovdqa {{.*#+}} ymm3 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; AVX512VLBW-NEXT:    vmovdqu8 %ymm2, %ymm3 {%k1}
; AVX512VLBW-NEXT:    vpminsb %ymm1, %ymm0, %ymm2
; AVX512VLBW-NEXT:    vpmaxsb %ymm1, %ymm0, %ymm1
; AVX512VLBW-NEXT:    vpsubb %ymm2, %ymm1, %ymm1
; AVX512VLBW-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512VLBW-NEXT:    vpand {{.*}}(%rip), %ymm1, %ymm1
; AVX512VLBW-NEXT:    vpmovzxbw {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero,ymm1[16],zero,ymm1[17],zero,ymm1[18],zero,ymm1[19],zero,ymm1[20],zero,ymm1[21],zero,ymm1[22],zero,ymm1[23],zero,ymm1[24],zero,ymm1[25],zero,ymm1[26],zero,ymm1[27],zero,ymm1[28],zero,ymm1[29],zero,ymm1[30],zero,ymm1[31],zero
; AVX512VLBW-NEXT:    vpmovzxbw {{.*#+}} zmm2 = ymm3[0],zero,ymm3[1],zero,ymm3[2],zero,ymm3[3],zero,ymm3[4],zero,ymm3[5],zero,ymm3[6],zero,ymm3[7],zero,ymm3[8],zero,ymm3[9],zero,ymm3[10],zero,ymm3[11],zero,ymm3[12],zero,ymm3[13],zero,ymm3[14],zero,ymm3[15],zero,ymm3[16],zero,ymm3[17],zero,ymm3[18],zero,ymm3[19],zero,ymm3[20],zero,ymm3[21],zero,ymm3[22],zero,ymm3[23],zero,ymm3[24],zero,ymm3[25],zero,ymm3[26],zero,ymm3[27],zero,ymm3[28],zero,ymm3[29],zero,ymm3[30],zero,ymm3[31],zero
; AVX512VLBW-NEXT:    vpmullw %zmm2, %zmm1, %zmm1
; AVX512VLBW-NEXT:    vpmovwb %zmm1, %ymm1
; AVX512VLBW-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX512VLBW-NEXT:    retq
  %a2 = load <32 x i8>, <32 x i8>* %a2_addr
  %t3 = icmp sgt <32 x i8> %a1, %a2 ; signed
  %t4 = select <32 x i1> %t3, <32 x i8> <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>, <32 x i8> <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %t5 = select <32 x i1> %t3, <32 x i8> %a2, <32 x i8> %a1
  %t6 = select <32 x i1> %t3, <32 x i8> %a1, <32 x i8> %a2
  %t7 = sub <32 x i8> %t6, %t5
  %t8 = lshr <32 x i8> %t7, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %t9 = mul nsw <32 x i8> %t8, %t4 ; signed
  %a10 = add nsw <32 x i8> %t9, %a1 ; signed
  ret <32 x i8> %a10
}

define <32 x i8> @vec256_i8_signed_mem_mem(<32 x i8>* %a1_addr, <32 x i8>* %a2_addr) nounwind {
; AVX1-FALLBACK-LABEL: vec256_i8_signed_mem_mem:
; AVX1-FALLBACK:       # %bb.0:
; AVX1-FALLBACK-NEXT:    vmovdqa (%rsi), %xmm2
; AVX1-FALLBACK-NEXT:    vmovdqa 16(%rsi), %xmm3
; AVX1-FALLBACK-NEXT:    vmovdqa (%rdi), %xmm0
; AVX1-FALLBACK-NEXT:    vmovdqa 16(%rdi), %xmm1
; AVX1-FALLBACK-NEXT:    vpcmpgtb %xmm3, %xmm1, %xmm8
; AVX1-FALLBACK-NEXT:    vpcmpgtb %xmm2, %xmm0, %xmm5
; AVX1-FALLBACK-NEXT:    vpminsb %xmm3, %xmm1, %xmm6
; AVX1-FALLBACK-NEXT:    vpminsb %xmm2, %xmm0, %xmm7
; AVX1-FALLBACK-NEXT:    vpmaxsb %xmm3, %xmm1, %xmm3
; AVX1-FALLBACK-NEXT:    vpsubb %xmm6, %xmm3, %xmm3
; AVX1-FALLBACK-NEXT:    vpmaxsb %xmm2, %xmm0, %xmm2
; AVX1-FALLBACK-NEXT:    vpsubb %xmm7, %xmm2, %xmm2
; AVX1-FALLBACK-NEXT:    vpsrlw $1, %xmm3, %xmm3
; AVX1-FALLBACK-NEXT:    vmovdqa {{.*#+}} xmm6 = [127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127]
; AVX1-FALLBACK-NEXT:    vpand %xmm6, %xmm3, %xmm3
; AVX1-FALLBACK-NEXT:    vpsrlw $1, %xmm2, %xmm2
; AVX1-FALLBACK-NEXT:    vpand %xmm6, %xmm2, %xmm2
; AVX1-FALLBACK-NEXT:    vpunpckhbw {{.*#+}} xmm6 = xmm2[8],xmm0[8],xmm2[9],xmm0[9],xmm2[10],xmm0[10],xmm2[11],xmm0[11],xmm2[12],xmm0[12],xmm2[13],xmm0[13],xmm2[14],xmm0[14],xmm2[15],xmm0[15]
; AVX1-FALLBACK-NEXT:    vmovdqa {{.*#+}} xmm7 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; AVX1-FALLBACK-NEXT:    vpor %xmm7, %xmm5, %xmm5
; AVX1-FALLBACK-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm5[8],xmm0[8],xmm5[9],xmm0[9],xmm5[10],xmm0[10],xmm5[11],xmm0[11],xmm5[12],xmm0[12],xmm5[13],xmm0[13],xmm5[14],xmm0[14],xmm5[15],xmm0[15]
; AVX1-FALLBACK-NEXT:    vpmullw %xmm4, %xmm6, %xmm4
; AVX1-FALLBACK-NEXT:    vmovdqa {{.*#+}} xmm6 = [255,255,255,255,255,255,255,255]
; AVX1-FALLBACK-NEXT:    vpand %xmm6, %xmm4, %xmm4
; AVX1-FALLBACK-NEXT:    vpmovzxbw {{.*#+}} xmm2 = xmm2[0],zero,xmm2[1],zero,xmm2[2],zero,xmm2[3],zero,xmm2[4],zero,xmm2[5],zero,xmm2[6],zero,xmm2[7],zero
; AVX1-FALLBACK-NEXT:    vpmovzxbw {{.*#+}} xmm5 = xmm5[0],zero,xmm5[1],zero,xmm5[2],zero,xmm5[3],zero,xmm5[4],zero,xmm5[5],zero,xmm5[6],zero,xmm5[7],zero
; AVX1-FALLBACK-NEXT:    vpmullw %xmm5, %xmm2, %xmm2
; AVX1-FALLBACK-NEXT:    vpand %xmm6, %xmm2, %xmm2
; AVX1-FALLBACK-NEXT:    vpackuswb %xmm4, %xmm2, %xmm2
; AVX1-FALLBACK-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm3[8],xmm0[8],xmm3[9],xmm0[9],xmm3[10],xmm0[10],xmm3[11],xmm0[11],xmm3[12],xmm0[12],xmm3[13],xmm0[13],xmm3[14],xmm0[14],xmm3[15],xmm0[15]
; AVX1-FALLBACK-NEXT:    vpor %xmm7, %xmm8, %xmm5
; AVX1-FALLBACK-NEXT:    vpunpckhbw {{.*#+}} xmm7 = xmm5[8],xmm0[8],xmm5[9],xmm0[9],xmm5[10],xmm0[10],xmm5[11],xmm0[11],xmm5[12],xmm0[12],xmm5[13],xmm0[13],xmm5[14],xmm0[14],xmm5[15],xmm0[15]
; AVX1-FALLBACK-NEXT:    vpmullw %xmm7, %xmm4, %xmm4
; AVX1-FALLBACK-NEXT:    vpand %xmm6, %xmm4, %xmm4
; AVX1-FALLBACK-NEXT:    vpmovzxbw {{.*#+}} xmm3 = xmm3[0],zero,xmm3[1],zero,xmm3[2],zero,xmm3[3],zero,xmm3[4],zero,xmm3[5],zero,xmm3[6],zero,xmm3[7],zero
; AVX1-FALLBACK-NEXT:    vpmovzxbw {{.*#+}} xmm5 = xmm5[0],zero,xmm5[1],zero,xmm5[2],zero,xmm5[3],zero,xmm5[4],zero,xmm5[5],zero,xmm5[6],zero,xmm5[7],zero
; AVX1-FALLBACK-NEXT:    vpmullw %xmm5, %xmm3, %xmm3
; AVX1-FALLBACK-NEXT:    vpand %xmm6, %xmm3, %xmm3
; AVX1-FALLBACK-NEXT:    vpackuswb %xmm4, %xmm3, %xmm3
; AVX1-FALLBACK-NEXT:    vpaddb %xmm1, %xmm3, %xmm1
; AVX1-FALLBACK-NEXT:    vpaddb %xmm0, %xmm2, %xmm0
; AVX1-FALLBACK-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-FALLBACK-NEXT:    retq
;
; AVX2-LABEL: vec256_i8_signed_mem_mem:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vmovdqa (%rdi), %ymm0
; AVX2-NEXT:    vmovdqa (%rsi), %ymm1
; AVX2-NEXT:    vpcmpgtb %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vpor {{.*}}(%rip), %ymm2, %ymm2
; AVX2-NEXT:    vpminsb %ymm1, %ymm0, %ymm3
; AVX2-NEXT:    vpmaxsb %ymm1, %ymm0, %ymm1
; AVX2-NEXT:    vpsubb %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX2-NEXT:    vpand {{.*}}(%rip), %ymm1, %ymm1
; AVX2-NEXT:    vpunpckhbw {{.*#+}} ymm3 = ymm1[8],ymm0[8],ymm1[9],ymm0[9],ymm1[10],ymm0[10],ymm1[11],ymm0[11],ymm1[12],ymm0[12],ymm1[13],ymm0[13],ymm1[14],ymm0[14],ymm1[15],ymm0[15],ymm1[24],ymm0[24],ymm1[25],ymm0[25],ymm1[26],ymm0[26],ymm1[27],ymm0[27],ymm1[28],ymm0[28],ymm1[29],ymm0[29],ymm1[30],ymm0[30],ymm1[31],ymm0[31]
; AVX2-NEXT:    vpunpckhbw {{.*#+}} ymm4 = ymm2[8],ymm0[8],ymm2[9],ymm0[9],ymm2[10],ymm0[10],ymm2[11],ymm0[11],ymm2[12],ymm0[12],ymm2[13],ymm0[13],ymm2[14],ymm0[14],ymm2[15],ymm0[15],ymm2[24],ymm0[24],ymm2[25],ymm0[25],ymm2[26],ymm0[26],ymm2[27],ymm0[27],ymm2[28],ymm0[28],ymm2[29],ymm0[29],ymm2[30],ymm0[30],ymm2[31],ymm0[31]
; AVX2-NEXT:    vpmullw %ymm4, %ymm3, %ymm3
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm4 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX2-NEXT:    vpand %ymm4, %ymm3, %ymm3
; AVX2-NEXT:    vpunpcklbw {{.*#+}} ymm1 = ymm1[0],ymm0[0],ymm1[1],ymm0[1],ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[4],ymm0[4],ymm1[5],ymm0[5],ymm1[6],ymm0[6],ymm1[7],ymm0[7],ymm1[16],ymm0[16],ymm1[17],ymm0[17],ymm1[18],ymm0[18],ymm1[19],ymm0[19],ymm1[20],ymm0[20],ymm1[21],ymm0[21],ymm1[22],ymm0[22],ymm1[23],ymm0[23]
; AVX2-NEXT:    vpunpcklbw {{.*#+}} ymm2 = ymm2[0],ymm0[0],ymm2[1],ymm0[1],ymm2[2],ymm0[2],ymm2[3],ymm0[3],ymm2[4],ymm0[4],ymm2[5],ymm0[5],ymm2[6],ymm0[6],ymm2[7],ymm0[7],ymm2[16],ymm0[16],ymm2[17],ymm0[17],ymm2[18],ymm0[18],ymm2[19],ymm0[19],ymm2[20],ymm0[20],ymm2[21],ymm0[21],ymm2[22],ymm0[22],ymm2[23],ymm0[23]
; AVX2-NEXT:    vpmullw %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpand %ymm4, %ymm1, %ymm1
; AVX2-NEXT:    vpackuswb %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; XOP-FALLBACK-LABEL: vec256_i8_signed_mem_mem:
; XOP-FALLBACK:       # %bb.0:
; XOP-FALLBACK-NEXT:    vmovdqa (%rsi), %xmm0
; XOP-FALLBACK-NEXT:    vmovdqa 16(%rsi), %xmm1
; XOP-FALLBACK-NEXT:    vmovdqa (%rdi), %xmm2
; XOP-FALLBACK-NEXT:    vmovdqa 16(%rdi), %xmm3
; XOP-FALLBACK-NEXT:    vpcomgtb %xmm1, %xmm3, %xmm8
; XOP-FALLBACK-NEXT:    vpcomgtb %xmm0, %xmm2, %xmm5
; XOP-FALLBACK-NEXT:    vpminsb %xmm1, %xmm3, %xmm6
; XOP-FALLBACK-NEXT:    vpminsb %xmm0, %xmm2, %xmm7
; XOP-FALLBACK-NEXT:    vpmaxsb %xmm1, %xmm3, %xmm1
; XOP-FALLBACK-NEXT:    vpsubb %xmm6, %xmm1, %xmm1
; XOP-FALLBACK-NEXT:    vpmaxsb %xmm0, %xmm2, %xmm0
; XOP-FALLBACK-NEXT:    vpsubb %xmm7, %xmm0, %xmm0
; XOP-FALLBACK-NEXT:    vpcmpeqd %xmm6, %xmm6, %xmm6
; XOP-FALLBACK-NEXT:    vpshlb %xmm6, %xmm1, %xmm1
; XOP-FALLBACK-NEXT:    vpshlb %xmm6, %xmm0, %xmm0
; XOP-FALLBACK-NEXT:    vpunpckhbw {{.*#+}} xmm6 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; XOP-FALLBACK-NEXT:    vmovdqa {{.*#+}} xmm7 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; XOP-FALLBACK-NEXT:    vpor %xmm7, %xmm5, %xmm5
; XOP-FALLBACK-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm5[8],xmm0[8],xmm5[9],xmm0[9],xmm5[10],xmm0[10],xmm5[11],xmm0[11],xmm5[12],xmm0[12],xmm5[13],xmm0[13],xmm5[14],xmm0[14],xmm5[15],xmm0[15]
; XOP-FALLBACK-NEXT:    vpmullw %xmm4, %xmm6, %xmm4
; XOP-FALLBACK-NEXT:    vpmovzxbw {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; XOP-FALLBACK-NEXT:    vpmovzxbw {{.*#+}} xmm5 = xmm5[0],zero,xmm5[1],zero,xmm5[2],zero,xmm5[3],zero,xmm5[4],zero,xmm5[5],zero,xmm5[6],zero,xmm5[7],zero
; XOP-FALLBACK-NEXT:    vpmullw %xmm5, %xmm0, %xmm0
; XOP-FALLBACK-NEXT:    vmovdqa {{.*#+}} xmm5 = [0,2,4,6,8,10,12,14,16,18,20,22,24,26,28,30]
; XOP-FALLBACK-NEXT:    vpperm %xmm5, %xmm4, %xmm0, %xmm0
; XOP-FALLBACK-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm1[8],xmm0[8],xmm1[9],xmm0[9],xmm1[10],xmm0[10],xmm1[11],xmm0[11],xmm1[12],xmm0[12],xmm1[13],xmm0[13],xmm1[14],xmm0[14],xmm1[15],xmm0[15]
; XOP-FALLBACK-NEXT:    vpor %xmm7, %xmm8, %xmm6
; XOP-FALLBACK-NEXT:    vpunpckhbw {{.*#+}} xmm7 = xmm6[8],xmm0[8],xmm6[9],xmm0[9],xmm6[10],xmm0[10],xmm6[11],xmm0[11],xmm6[12],xmm0[12],xmm6[13],xmm0[13],xmm6[14],xmm0[14],xmm6[15],xmm0[15]
; XOP-FALLBACK-NEXT:    vpmullw %xmm7, %xmm4, %xmm4
; XOP-FALLBACK-NEXT:    vpmovzxbw {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero,xmm1[4],zero,xmm1[5],zero,xmm1[6],zero,xmm1[7],zero
; XOP-FALLBACK-NEXT:    vpmovzxbw {{.*#+}} xmm6 = xmm6[0],zero,xmm6[1],zero,xmm6[2],zero,xmm6[3],zero,xmm6[4],zero,xmm6[5],zero,xmm6[6],zero,xmm6[7],zero
; XOP-FALLBACK-NEXT:    vpmullw %xmm6, %xmm1, %xmm1
; XOP-FALLBACK-NEXT:    vpperm %xmm5, %xmm4, %xmm1, %xmm1
; XOP-FALLBACK-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; XOP-FALLBACK-NEXT:    vpaddb %xmm2, %xmm0, %xmm0
; XOP-FALLBACK-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; XOP-FALLBACK-NEXT:    retq
;
; XOPAVX1-LABEL: vec256_i8_signed_mem_mem:
; XOPAVX1:       # %bb.0:
; XOPAVX1-NEXT:    vmovdqa (%rsi), %xmm0
; XOPAVX1-NEXT:    vmovdqa 16(%rsi), %xmm1
; XOPAVX1-NEXT:    vmovdqa (%rdi), %xmm2
; XOPAVX1-NEXT:    vmovdqa 16(%rdi), %xmm3
; XOPAVX1-NEXT:    vpcomgtb %xmm1, %xmm3, %xmm8
; XOPAVX1-NEXT:    vpcomgtb %xmm0, %xmm2, %xmm5
; XOPAVX1-NEXT:    vpminsb %xmm1, %xmm3, %xmm6
; XOPAVX1-NEXT:    vpminsb %xmm0, %xmm2, %xmm7
; XOPAVX1-NEXT:    vpmaxsb %xmm1, %xmm3, %xmm1
; XOPAVX1-NEXT:    vpsubb %xmm6, %xmm1, %xmm1
; XOPAVX1-NEXT:    vpmaxsb %xmm0, %xmm2, %xmm0
; XOPAVX1-NEXT:    vpsubb %xmm7, %xmm0, %xmm0
; XOPAVX1-NEXT:    vpcmpeqd %xmm6, %xmm6, %xmm6
; XOPAVX1-NEXT:    vpshlb %xmm6, %xmm1, %xmm1
; XOPAVX1-NEXT:    vpshlb %xmm6, %xmm0, %xmm0
; XOPAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm6 = xmm0[8,8,9,9,10,10,11,11,12,12,13,13,14,14,15,15]
; XOPAVX1-NEXT:    vmovdqa {{.*#+}} xmm7 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; XOPAVX1-NEXT:    vpor %xmm7, %xmm5, %xmm5
; XOPAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm5[8],xmm0[8],xmm5[9],xmm0[9],xmm5[10],xmm0[10],xmm5[11],xmm0[11],xmm5[12],xmm0[12],xmm5[13],xmm0[13],xmm5[14],xmm0[14],xmm5[15],xmm0[15]
; XOPAVX1-NEXT:    vpmullw %xmm4, %xmm6, %xmm4
; XOPAVX1-NEXT:    vpmovzxbw {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; XOPAVX1-NEXT:    vpmovzxbw {{.*#+}} xmm5 = xmm5[0],zero,xmm5[1],zero,xmm5[2],zero,xmm5[3],zero,xmm5[4],zero,xmm5[5],zero,xmm5[6],zero,xmm5[7],zero
; XOPAVX1-NEXT:    vpmullw %xmm5, %xmm0, %xmm0
; XOPAVX1-NEXT:    vmovdqa {{.*#+}} xmm5 = [0,2,4,6,8,10,12,14,16,18,20,22,24,26,28,30]
; XOPAVX1-NEXT:    vpperm %xmm5, %xmm4, %xmm0, %xmm0
; XOPAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm4 = xmm1[8],xmm0[8],xmm1[9],xmm0[9],xmm1[10],xmm0[10],xmm1[11],xmm0[11],xmm1[12],xmm0[12],xmm1[13],xmm0[13],xmm1[14],xmm0[14],xmm1[15],xmm0[15]
; XOPAVX1-NEXT:    vpor %xmm7, %xmm8, %xmm6
; XOPAVX1-NEXT:    vpunpckhbw {{.*#+}} xmm7 = xmm6[8],xmm0[8],xmm6[9],xmm0[9],xmm6[10],xmm0[10],xmm6[11],xmm0[11],xmm6[12],xmm0[12],xmm6[13],xmm0[13],xmm6[14],xmm0[14],xmm6[15],xmm0[15]
; XOPAVX1-NEXT:    vpmullw %xmm7, %xmm4, %xmm4
; XOPAVX1-NEXT:    vpmovzxbw {{.*#+}} xmm1 = xmm1[0],zero,xmm1[1],zero,xmm1[2],zero,xmm1[3],zero,xmm1[4],zero,xmm1[5],zero,xmm1[6],zero,xmm1[7],zero
; XOPAVX1-NEXT:    vpmovzxbw {{.*#+}} xmm6 = xmm6[0],zero,xmm6[1],zero,xmm6[2],zero,xmm6[3],zero,xmm6[4],zero,xmm6[5],zero,xmm6[6],zero,xmm6[7],zero
; XOPAVX1-NEXT:    vpmullw %xmm6, %xmm1, %xmm1
; XOPAVX1-NEXT:    vpperm %xmm5, %xmm4, %xmm1, %xmm1
; XOPAVX1-NEXT:    vpaddb %xmm3, %xmm1, %xmm1
; XOPAVX1-NEXT:    vpaddb %xmm2, %xmm0, %xmm0
; XOPAVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; XOPAVX1-NEXT:    retq
;
; AVX512F-LABEL: vec256_i8_signed_mem_mem:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512F-NEXT:    vmovdqa (%rsi), %ymm1
; AVX512F-NEXT:    vpcmpgtb %ymm1, %ymm0, %ymm2
; AVX512F-NEXT:    vpor {{.*}}(%rip), %ymm2, %ymm2
; AVX512F-NEXT:    vpminsb %ymm1, %ymm0, %ymm3
; AVX512F-NEXT:    vpmaxsb %ymm1, %ymm0, %ymm1
; AVX512F-NEXT:    vpsubb %ymm3, %ymm1, %ymm1
; AVX512F-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512F-NEXT:    vpand {{.*}}(%rip), %ymm1, %ymm1
; AVX512F-NEXT:    vpunpckhbw {{.*#+}} ymm3 = ymm1[8],ymm0[8],ymm1[9],ymm0[9],ymm1[10],ymm0[10],ymm1[11],ymm0[11],ymm1[12],ymm0[12],ymm1[13],ymm0[13],ymm1[14],ymm0[14],ymm1[15],ymm0[15],ymm1[24],ymm0[24],ymm1[25],ymm0[25],ymm1[26],ymm0[26],ymm1[27],ymm0[27],ymm1[28],ymm0[28],ymm1[29],ymm0[29],ymm1[30],ymm0[30],ymm1[31],ymm0[31]
; AVX512F-NEXT:    vpunpckhbw {{.*#+}} ymm4 = ymm2[8],ymm0[8],ymm2[9],ymm0[9],ymm2[10],ymm0[10],ymm2[11],ymm0[11],ymm2[12],ymm0[12],ymm2[13],ymm0[13],ymm2[14],ymm0[14],ymm2[15],ymm0[15],ymm2[24],ymm0[24],ymm2[25],ymm0[25],ymm2[26],ymm0[26],ymm2[27],ymm0[27],ymm2[28],ymm0[28],ymm2[29],ymm0[29],ymm2[30],ymm0[30],ymm2[31],ymm0[31]
; AVX512F-NEXT:    vpmullw %ymm4, %ymm3, %ymm3
; AVX512F-NEXT:    vmovdqa {{.*#+}} ymm4 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512F-NEXT:    vpand %ymm4, %ymm3, %ymm3
; AVX512F-NEXT:    vpunpcklbw {{.*#+}} ymm1 = ymm1[0],ymm0[0],ymm1[1],ymm0[1],ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[4],ymm0[4],ymm1[5],ymm0[5],ymm1[6],ymm0[6],ymm1[7],ymm0[7],ymm1[16],ymm0[16],ymm1[17],ymm0[17],ymm1[18],ymm0[18],ymm1[19],ymm0[19],ymm1[20],ymm0[20],ymm1[21],ymm0[21],ymm1[22],ymm0[22],ymm1[23],ymm0[23]
; AVX512F-NEXT:    vpunpcklbw {{.*#+}} ymm2 = ymm2[0],ymm0[0],ymm2[1],ymm0[1],ymm2[2],ymm0[2],ymm2[3],ymm0[3],ymm2[4],ymm0[4],ymm2[5],ymm0[5],ymm2[6],ymm0[6],ymm2[7],ymm0[7],ymm2[16],ymm0[16],ymm2[17],ymm0[17],ymm2[18],ymm0[18],ymm2[19],ymm0[19],ymm2[20],ymm0[20],ymm2[21],ymm0[21],ymm2[22],ymm0[22],ymm2[23],ymm0[23]
; AVX512F-NEXT:    vpmullw %ymm2, %ymm1, %ymm1
; AVX512F-NEXT:    vpand %ymm4, %ymm1, %ymm1
; AVX512F-NEXT:    vpackuswb %ymm3, %ymm1, %ymm1
; AVX512F-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX512F-NEXT:    retq
;
; AVX512VL-FALLBACK-LABEL: vec256_i8_signed_mem_mem:
; AVX512VL-FALLBACK:       # %bb.0:
; AVX512VL-FALLBACK-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512VL-FALLBACK-NEXT:    vmovdqa (%rsi), %ymm1
; AVX512VL-FALLBACK-NEXT:    vpcmpgtb %ymm1, %ymm0, %ymm2
; AVX512VL-FALLBACK-NEXT:    vpor {{.*}}(%rip), %ymm2, %ymm2
; AVX512VL-FALLBACK-NEXT:    vpminsb %ymm1, %ymm0, %ymm3
; AVX512VL-FALLBACK-NEXT:    vpmaxsb %ymm1, %ymm0, %ymm1
; AVX512VL-FALLBACK-NEXT:    vpsubb %ymm3, %ymm1, %ymm1
; AVX512VL-FALLBACK-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512VL-FALLBACK-NEXT:    vpand {{.*}}(%rip), %ymm1, %ymm1
; AVX512VL-FALLBACK-NEXT:    vpunpckhbw {{.*#+}} ymm3 = ymm1[8],ymm0[8],ymm1[9],ymm0[9],ymm1[10],ymm0[10],ymm1[11],ymm0[11],ymm1[12],ymm0[12],ymm1[13],ymm0[13],ymm1[14],ymm0[14],ymm1[15],ymm0[15],ymm1[24],ymm0[24],ymm1[25],ymm0[25],ymm1[26],ymm0[26],ymm1[27],ymm0[27],ymm1[28],ymm0[28],ymm1[29],ymm0[29],ymm1[30],ymm0[30],ymm1[31],ymm0[31]
; AVX512VL-FALLBACK-NEXT:    vpunpckhbw {{.*#+}} ymm4 = ymm2[8],ymm0[8],ymm2[9],ymm0[9],ymm2[10],ymm0[10],ymm2[11],ymm0[11],ymm2[12],ymm0[12],ymm2[13],ymm0[13],ymm2[14],ymm0[14],ymm2[15],ymm0[15],ymm2[24],ymm0[24],ymm2[25],ymm0[25],ymm2[26],ymm0[26],ymm2[27],ymm0[27],ymm2[28],ymm0[28],ymm2[29],ymm0[29],ymm2[30],ymm0[30],ymm2[31],ymm0[31]
; AVX512VL-FALLBACK-NEXT:    vpmullw %ymm4, %ymm3, %ymm3
; AVX512VL-FALLBACK-NEXT:    vmovdqa {{.*#+}} ymm4 = [255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255]
; AVX512VL-FALLBACK-NEXT:    vpand %ymm4, %ymm3, %ymm3
; AVX512VL-FALLBACK-NEXT:    vpunpcklbw {{.*#+}} ymm1 = ymm1[0],ymm0[0],ymm1[1],ymm0[1],ymm1[2],ymm0[2],ymm1[3],ymm0[3],ymm1[4],ymm0[4],ymm1[5],ymm0[5],ymm1[6],ymm0[6],ymm1[7],ymm0[7],ymm1[16],ymm0[16],ymm1[17],ymm0[17],ymm1[18],ymm0[18],ymm1[19],ymm0[19],ymm1[20],ymm0[20],ymm1[21],ymm0[21],ymm1[22],ymm0[22],ymm1[23],ymm0[23]
; AVX512VL-FALLBACK-NEXT:    vpunpcklbw {{.*#+}} ymm2 = ymm2[0],ymm0[0],ymm2[1],ymm0[1],ymm2[2],ymm0[2],ymm2[3],ymm0[3],ymm2[4],ymm0[4],ymm2[5],ymm0[5],ymm2[6],ymm0[6],ymm2[7],ymm0[7],ymm2[16],ymm0[16],ymm2[17],ymm0[17],ymm2[18],ymm0[18],ymm2[19],ymm0[19],ymm2[20],ymm0[20],ymm2[21],ymm0[21],ymm2[22],ymm0[22],ymm2[23],ymm0[23]
; AVX512VL-FALLBACK-NEXT:    vpmullw %ymm2, %ymm1, %ymm1
; AVX512VL-FALLBACK-NEXT:    vpand %ymm4, %ymm1, %ymm1
; AVX512VL-FALLBACK-NEXT:    vpackuswb %ymm3, %ymm1, %ymm1
; AVX512VL-FALLBACK-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX512VL-FALLBACK-NEXT:    retq
;
; AVX512BW-FALLBACK-LABEL: vec256_i8_signed_mem_mem:
; AVX512BW-FALLBACK:       # %bb.0:
; AVX512BW-FALLBACK-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512BW-FALLBACK-NEXT:    vmovdqa (%rsi), %ymm1
; AVX512BW-FALLBACK-NEXT:    vpcmpgtb %zmm1, %zmm0, %k1
; AVX512BW-FALLBACK-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512BW-FALLBACK-NEXT:    vmovdqa {{.*#+}} ymm3 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; AVX512BW-FALLBACK-NEXT:    vmovdqu8 %zmm2, %zmm3 {%k1}
; AVX512BW-FALLBACK-NEXT:    vpminsb %ymm1, %ymm0, %ymm2
; AVX512BW-FALLBACK-NEXT:    vpmaxsb %ymm1, %ymm0, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpsubb %ymm2, %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpand {{.*}}(%rip), %ymm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpmovzxbw {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero,ymm1[16],zero,ymm1[17],zero,ymm1[18],zero,ymm1[19],zero,ymm1[20],zero,ymm1[21],zero,ymm1[22],zero,ymm1[23],zero,ymm1[24],zero,ymm1[25],zero,ymm1[26],zero,ymm1[27],zero,ymm1[28],zero,ymm1[29],zero,ymm1[30],zero,ymm1[31],zero
; AVX512BW-FALLBACK-NEXT:    vpmovzxbw {{.*#+}} zmm2 = ymm3[0],zero,ymm3[1],zero,ymm3[2],zero,ymm3[3],zero,ymm3[4],zero,ymm3[5],zero,ymm3[6],zero,ymm3[7],zero,ymm3[8],zero,ymm3[9],zero,ymm3[10],zero,ymm3[11],zero,ymm3[12],zero,ymm3[13],zero,ymm3[14],zero,ymm3[15],zero,ymm3[16],zero,ymm3[17],zero,ymm3[18],zero,ymm3[19],zero,ymm3[20],zero,ymm3[21],zero,ymm3[22],zero,ymm3[23],zero,ymm3[24],zero,ymm3[25],zero,ymm3[26],zero,ymm3[27],zero,ymm3[28],zero,ymm3[29],zero,ymm3[30],zero,ymm3[31],zero
; AVX512BW-FALLBACK-NEXT:    vpmullw %zmm2, %zmm1, %zmm1
; AVX512BW-FALLBACK-NEXT:    vpmovwb %zmm1, %ymm1
; AVX512BW-FALLBACK-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX512BW-FALLBACK-NEXT:    retq
;
; AVX512VLBW-LABEL: vec256_i8_signed_mem_mem:
; AVX512VLBW:       # %bb.0:
; AVX512VLBW-NEXT:    vmovdqa (%rdi), %ymm0
; AVX512VLBW-NEXT:    vmovdqa (%rsi), %ymm1
; AVX512VLBW-NEXT:    vpcmpgtb %ymm1, %ymm0, %k1
; AVX512VLBW-NEXT:    vpcmpeqd %ymm2, %ymm2, %ymm2
; AVX512VLBW-NEXT:    vmovdqa {{.*#+}} ymm3 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; AVX512VLBW-NEXT:    vmovdqu8 %ymm2, %ymm3 {%k1}
; AVX512VLBW-NEXT:    vpminsb %ymm1, %ymm0, %ymm2
; AVX512VLBW-NEXT:    vpmaxsb %ymm1, %ymm0, %ymm1
; AVX512VLBW-NEXT:    vpsubb %ymm2, %ymm1, %ymm1
; AVX512VLBW-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX512VLBW-NEXT:    vpand {{.*}}(%rip), %ymm1, %ymm1
; AVX512VLBW-NEXT:    vpmovzxbw {{.*#+}} zmm1 = ymm1[0],zero,ymm1[1],zero,ymm1[2],zero,ymm1[3],zero,ymm1[4],zero,ymm1[5],zero,ymm1[6],zero,ymm1[7],zero,ymm1[8],zero,ymm1[9],zero,ymm1[10],zero,ymm1[11],zero,ymm1[12],zero,ymm1[13],zero,ymm1[14],zero,ymm1[15],zero,ymm1[16],zero,ymm1[17],zero,ymm1[18],zero,ymm1[19],zero,ymm1[20],zero,ymm1[21],zero,ymm1[22],zero,ymm1[23],zero,ymm1[24],zero,ymm1[25],zero,ymm1[26],zero,ymm1[27],zero,ymm1[28],zero,ymm1[29],zero,ymm1[30],zero,ymm1[31],zero
; AVX512VLBW-NEXT:    vpmovzxbw {{.*#+}} zmm2 = ymm3[0],zero,ymm3[1],zero,ymm3[2],zero,ymm3[3],zero,ymm3[4],zero,ymm3[5],zero,ymm3[6],zero,ymm3[7],zero,ymm3[8],zero,ymm3[9],zero,ymm3[10],zero,ymm3[11],zero,ymm3[12],zero,ymm3[13],zero,ymm3[14],zero,ymm3[15],zero,ymm3[16],zero,ymm3[17],zero,ymm3[18],zero,ymm3[19],zero,ymm3[20],zero,ymm3[21],zero,ymm3[22],zero,ymm3[23],zero,ymm3[24],zero,ymm3[25],zero,ymm3[26],zero,ymm3[27],zero,ymm3[28],zero,ymm3[29],zero,ymm3[30],zero,ymm3[31],zero
; AVX512VLBW-NEXT:    vpmullw %zmm2, %zmm1, %zmm1
; AVX512VLBW-NEXT:    vpmovwb %zmm1, %ymm1
; AVX512VLBW-NEXT:    vpaddb %ymm0, %ymm1, %ymm0
; AVX512VLBW-NEXT:    retq
  %a1 = load <32 x i8>, <32 x i8>* %a1_addr
  %a2 = load <32 x i8>, <32 x i8>* %a2_addr
  %t3 = icmp sgt <32 x i8> %a1, %a2 ; signed
  %t4 = select <32 x i1> %t3, <32 x i8> <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>, <32 x i8> <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %t5 = select <32 x i1> %t3, <32 x i8> %a2, <32 x i8> %a1
  %t6 = select <32 x i1> %t3, <32 x i8> %a1, <32 x i8> %a2
  %t7 = sub <32 x i8> %t6, %t5
  %t8 = lshr <32 x i8> %t7, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %t9 = mul nsw <32 x i8> %t8, %t4 ; signed
  %a10 = add nsw <32 x i8> %t9, %a1 ; signed
  ret <32 x i8> %a10
}
