/***********************************************************************************

    Copyright (C) 2007-2020 Ahmet Öztürk (aoz_2@yahoo.com)

    This file is part of Lifeograph.

    Lifeograph is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Lifeograph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#ifndef LIFEOGRAPH_TABLE_HEADER
#define LIFEOGRAPH_TABLE_HEADER


#include <gtkmm/widget.h>

#include "../helpers.hpp"
#include "../diary.hpp"


namespace LIFEO
{

using namespace HELPERS;

class Table
{
    public:
        // CONSTANTS
        static constexpr double     S_MARGIN{ 6.0 };
        static constexpr double     S_CELL_MARGIN{ 3.0 };
        static constexpr double     S_LABEL_H = 10.0;
        static constexpr int        S_MIN_LINES = 3;

                                    Table();
        virtual                     ~Table() { }

        void                        set_diary( Diary* diary )
        { m_p2diary = diary; m_data.set_diary( diary ); }
        Diary*                      get_diary()
        { return m_p2diary; }

        TableData&                  get_table_data()
        { return m_data; }

        void                        resize( int, int );
        void                        calculate_line_h( Glib::RefPtr< Pango::Context > );
        void                        scroll( int );

        virtual void                refresh() { }

    protected:
        void                        update_col_geom();

        bool                        draw( const Cairo::RefPtr< Cairo::Context >& );

        // DATA
        TableData                   m_data;

        // GEOMETRY
        int                         m_width{ -1 };
        int                         m_height{ -1 };

        double                      m_width_net{ 0.0 };
        double                      m_height_net{ 0.0 };

        double                      m_col_w{ 0.0 };
        double                      m_line_h{ 0.0 };

        unsigned int                m_line_c_vis{ 0 }; // visible line count
        unsigned int                m_line_c_total{ 0 }; // total line count
        int                         m_i_line_top{ 0 };
        int                         m_i_col_cur{ -1 };
        int                         m_i_line_cur{ -1 };

        Pango::FontDescription      m_font_main;
        Pango::FontDescription      m_font_header;
//        const static std::valarray< double >
//                                    s_dash_pattern;

        // FLAGS
        bool                        m_flag_button_pressed{ false };
        bool                        m_flag_widget_hovered{ false };

        Diary*                      m_p2diary{ nullptr };
};

} // end of namespace LIFEO

#endif
