
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2023 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQMdiSubWindow.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QMdiSubWindow>
#include <QAction>
#include <QActionEvent>
#include <QBackingStore>
#include <QBitmap>
#include <QChildEvent>
#include <QCloseEvent>
#include <QContextMenuEvent>
#include <QCursor>
#include <QDragEnterEvent>
#include <QDragLeaveEvent>
#include <QDragMoveEvent>
#include <QDropEvent>
#include <QEvent>
#include <QFocusEvent>
#include <QFont>
#include <QFontInfo>
#include <QFontMetrics>
#include <QGraphicsEffect>
#include <QGraphicsProxyWidget>
#include <QHideEvent>
#include <QIcon>
#include <QInputMethodEvent>
#include <QKeyEvent>
#include <QKeySequence>
#include <QLayout>
#include <QLocale>
#include <QMargins>
#include <QMdiArea>
#include <QMenu>
#include <QMetaMethod>
#include <QMouseEvent>
#include <QMoveEvent>
#include <QObject>
#include <QPaintDevice>
#include <QPaintEngine>
#include <QPaintEvent>
#include <QPainter>
#include <QPalette>
#include <QPixmap>
#include <QPoint>
#include <QRect>
#include <QRegion>
#include <QResizeEvent>
#include <QShowEvent>
#include <QSize>
#include <QSizePolicy>
#include <QStyle>
#include <QTabletEvent>
#include <QThread>
#include <QTimerEvent>
#include <QWheelEvent>
#include <QWidget>
#include <QWindow>
#include "gsiQt.h"
#include "gsiQtWidgetsCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QMdiSubWindow

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QMdiSubWindow::staticMetaObject);
}


// bool QMdiSubWindow::isShaded()


static void _init_f_isShaded_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isShaded_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QMdiSubWindow *)cls)->isShaded ());
}


// int QMdiSubWindow::keyboardPageStep()


static void _init_f_keyboardPageStep_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_keyboardPageStep_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QMdiSubWindow *)cls)->keyboardPageStep ());
}


// int QMdiSubWindow::keyboardSingleStep()


static void _init_f_keyboardSingleStep_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_keyboardSingleStep_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QMdiSubWindow *)cls)->keyboardSingleStep ());
}


// QWidget *QMdiSubWindow::maximizedButtonsWidget()


static void _init_f_maximizedButtonsWidget_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QWidget * > ();
}

static void _call_f_maximizedButtonsWidget_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QWidget * > ((QWidget *)((QMdiSubWindow *)cls)->maximizedButtonsWidget ());
}


// QWidget *QMdiSubWindow::maximizedSystemMenuIconWidget()


static void _init_f_maximizedSystemMenuIconWidget_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QWidget * > ();
}

static void _call_f_maximizedSystemMenuIconWidget_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QWidget * > ((QWidget *)((QMdiSubWindow *)cls)->maximizedSystemMenuIconWidget ());
}


// QMdiArea *QMdiSubWindow::mdiArea()


static void _init_f_mdiArea_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMdiArea * > ();
}

static void _call_f_mdiArea_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMdiArea * > ((QMdiArea *)((QMdiSubWindow *)cls)->mdiArea ());
}


// QSize QMdiSubWindow::minimumSizeHint()


static void _init_f_minimumSizeHint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_minimumSizeHint_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QMdiSubWindow *)cls)->minimumSizeHint ());
}


// void QMdiSubWindow::setKeyboardPageStep(int step)


static void _init_f_setKeyboardPageStep_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("step");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setKeyboardPageStep_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiSubWindow *)cls)->setKeyboardPageStep (arg1);
}


// void QMdiSubWindow::setKeyboardSingleStep(int step)


static void _init_f_setKeyboardSingleStep_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("step");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setKeyboardSingleStep_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiSubWindow *)cls)->setKeyboardSingleStep (arg1);
}


// void QMdiSubWindow::setOption(QMdiSubWindow::SubWindowOption option, bool on)


static void _init_f_setOption_4164 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<const qt_gsi::Converter<QMdiSubWindow::SubWindowOption>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("on", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setOption_4164 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QMdiSubWindow::SubWindowOption>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QMdiSubWindow::SubWindowOption>::target_type & >() (args, heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiSubWindow *)cls)->setOption (qt_gsi::QtToCppAdaptor<QMdiSubWindow::SubWindowOption>(arg1).cref(), arg2);
}


// void QMdiSubWindow::setSystemMenu(QMenu *systemMenu)


static void _init_f_setSystemMenu_1108 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("systemMenu");
  decl->add_arg<QMenu * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSystemMenu_1108 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMenu *arg1 = gsi::arg_reader<QMenu * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiSubWindow *)cls)->setSystemMenu (arg1);
}


// void QMdiSubWindow::setWidget(QWidget *widget)


static void _init_f_setWidget_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("widget");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWidget_1315 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiSubWindow *)cls)->setWidget (arg1);
}


// void QMdiSubWindow::showShaded()


static void _init_f_showShaded_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_showShaded_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiSubWindow *)cls)->showShaded ();
}


// void QMdiSubWindow::showSystemMenu()


static void _init_f_showSystemMenu_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_showSystemMenu_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiSubWindow *)cls)->showSystemMenu ();
}


// QSize QMdiSubWindow::sizeHint()


static void _init_f_sizeHint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_sizeHint_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QMdiSubWindow *)cls)->sizeHint ());
}


// QMenu *QMdiSubWindow::systemMenu()


static void _init_f_systemMenu_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMenu * > ();
}

static void _call_f_systemMenu_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMenu * > ((QMenu *)((QMdiSubWindow *)cls)->systemMenu ());
}


// bool QMdiSubWindow::testOption(QMdiSubWindow::SubWindowOption)


static void _init_f_testOption_c3408 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QMdiSubWindow::SubWindowOption>::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_testOption_c3408 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QMdiSubWindow::SubWindowOption>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QMdiSubWindow::SubWindowOption>::target_type & >() (args, heap);
  ret.write<bool > ((bool)((QMdiSubWindow *)cls)->testOption (qt_gsi::QtToCppAdaptor<QMdiSubWindow::SubWindowOption>(arg1).cref()));
}


// QWidget *QMdiSubWindow::widget()


static void _init_f_widget_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QWidget * > ();
}

static void _call_f_widget_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QWidget * > ((QWidget *)((QMdiSubWindow *)cls)->widget ());
}


// static QString QMdiSubWindow::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QMdiSubWindow::tr (arg1, arg2, arg3));
}


// static QString QMdiSubWindow::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QMdiSubWindow::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QMdiSubWindow () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("isShaded?", "@brief Method bool QMdiSubWindow::isShaded()\n", true, &_init_f_isShaded_c0, &_call_f_isShaded_c0);
  methods += new qt_gsi::GenericMethod (":keyboardPageStep", "@brief Method int QMdiSubWindow::keyboardPageStep()\n", true, &_init_f_keyboardPageStep_c0, &_call_f_keyboardPageStep_c0);
  methods += new qt_gsi::GenericMethod (":keyboardSingleStep", "@brief Method int QMdiSubWindow::keyboardSingleStep()\n", true, &_init_f_keyboardSingleStep_c0, &_call_f_keyboardSingleStep_c0);
  methods += new qt_gsi::GenericMethod ("maximizedButtonsWidget", "@brief Method QWidget *QMdiSubWindow::maximizedButtonsWidget()\n", true, &_init_f_maximizedButtonsWidget_c0, &_call_f_maximizedButtonsWidget_c0);
  methods += new qt_gsi::GenericMethod ("maximizedSystemMenuIconWidget", "@brief Method QWidget *QMdiSubWindow::maximizedSystemMenuIconWidget()\n", true, &_init_f_maximizedSystemMenuIconWidget_c0, &_call_f_maximizedSystemMenuIconWidget_c0);
  methods += new qt_gsi::GenericMethod ("mdiArea", "@brief Method QMdiArea *QMdiSubWindow::mdiArea()\n", true, &_init_f_mdiArea_c0, &_call_f_mdiArea_c0);
  methods += new qt_gsi::GenericMethod (":minimumSizeHint", "@brief Method QSize QMdiSubWindow::minimumSizeHint()\nThis is a reimplementation of QWidget::minimumSizeHint", true, &_init_f_minimumSizeHint_c0, &_call_f_minimumSizeHint_c0);
  methods += new qt_gsi::GenericMethod ("setKeyboardPageStep|keyboardPageStep=", "@brief Method void QMdiSubWindow::setKeyboardPageStep(int step)\n", false, &_init_f_setKeyboardPageStep_767, &_call_f_setKeyboardPageStep_767);
  methods += new qt_gsi::GenericMethod ("setKeyboardSingleStep|keyboardSingleStep=", "@brief Method void QMdiSubWindow::setKeyboardSingleStep(int step)\n", false, &_init_f_setKeyboardSingleStep_767, &_call_f_setKeyboardSingleStep_767);
  methods += new qt_gsi::GenericMethod ("setOption", "@brief Method void QMdiSubWindow::setOption(QMdiSubWindow::SubWindowOption option, bool on)\n", false, &_init_f_setOption_4164, &_call_f_setOption_4164);
  methods += new qt_gsi::GenericMethod ("setSystemMenu|systemMenu=", "@brief Method void QMdiSubWindow::setSystemMenu(QMenu *systemMenu)\n", false, &_init_f_setSystemMenu_1108, &_call_f_setSystemMenu_1108);
  methods += new qt_gsi::GenericMethod ("setWidget|widget=", "@brief Method void QMdiSubWindow::setWidget(QWidget *widget)\n", false, &_init_f_setWidget_1315, &_call_f_setWidget_1315);
  methods += new qt_gsi::GenericMethod ("showShaded", "@brief Method void QMdiSubWindow::showShaded()\n", false, &_init_f_showShaded_0, &_call_f_showShaded_0);
  methods += new qt_gsi::GenericMethod ("showSystemMenu", "@brief Method void QMdiSubWindow::showSystemMenu()\n", false, &_init_f_showSystemMenu_0, &_call_f_showSystemMenu_0);
  methods += new qt_gsi::GenericMethod (":sizeHint", "@brief Method QSize QMdiSubWindow::sizeHint()\nThis is a reimplementation of QWidget::sizeHint", true, &_init_f_sizeHint_c0, &_call_f_sizeHint_c0);
  methods += new qt_gsi::GenericMethod (":systemMenu", "@brief Method QMenu *QMdiSubWindow::systemMenu()\n", true, &_init_f_systemMenu_c0, &_call_f_systemMenu_c0);
  methods += new qt_gsi::GenericMethod ("testOption", "@brief Method bool QMdiSubWindow::testOption(QMdiSubWindow::SubWindowOption)\n", true, &_init_f_testOption_c3408, &_call_f_testOption_c3408);
  methods += new qt_gsi::GenericMethod (":widget", "@brief Method QWidget *QMdiSubWindow::widget()\n", true, &_init_f_widget_c0, &_call_f_widget_c0);
  methods += gsi::qt_signal ("aboutToActivate()", "aboutToActivate", "@brief Signal declaration for QMdiSubWindow::aboutToActivate()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QPoint & > ("customContextMenuRequested(const QPoint &)", "customContextMenuRequested", gsi::arg("pos"), "@brief Signal declaration for QMdiSubWindow::customContextMenuRequested(const QPoint &pos)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QMdiSubWindow::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QMdiSubWindow::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QIcon & > ("windowIconChanged(const QIcon &)", "windowIconChanged", gsi::arg("icon"), "@brief Signal declaration for QMdiSubWindow::windowIconChanged(const QIcon &icon)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("windowIconTextChanged(const QString &)", "windowIconTextChanged", gsi::arg("iconText"), "@brief Signal declaration for QMdiSubWindow::windowIconTextChanged(const QString &iconText)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QFlags<Qt::WindowState>, QFlags<Qt::WindowState> > ("windowStateChanged(QFlags<Qt::WindowState>, QFlags<Qt::WindowState>)", "windowStateChanged", gsi::arg("oldState"), gsi::arg("newState"), "@brief Signal declaration for QMdiSubWindow::windowStateChanged(QFlags<Qt::WindowState> oldState, QFlags<Qt::WindowState> newState)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("windowTitleChanged(const QString &)", "windowTitleChanged", gsi::arg("title"), "@brief Signal declaration for QMdiSubWindow::windowTitleChanged(const QString &title)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QMdiSubWindow::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QMdiSubWindow::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QWidget> &qtdecl_QWidget ();

qt_gsi::QtNativeClass<QMdiSubWindow> decl_QMdiSubWindow (qtdecl_QWidget (), "QtWidgets", "QMdiSubWindow_Native",
  methods_QMdiSubWindow (),
  "@hide\n@alias QMdiSubWindow");

GSI_QTWIDGETS_PUBLIC gsi::Class<QMdiSubWindow> &qtdecl_QMdiSubWindow () { return decl_QMdiSubWindow; }

}


class QMdiSubWindow_Adaptor : public QMdiSubWindow, public qt_gsi::QtObjectBase
{
public:

  virtual ~QMdiSubWindow_Adaptor();

  //  [adaptor ctor] QMdiSubWindow::QMdiSubWindow(QWidget *parent, QFlags<Qt::WindowType> flags)
  QMdiSubWindow_Adaptor() : QMdiSubWindow()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QMdiSubWindow::QMdiSubWindow(QWidget *parent, QFlags<Qt::WindowType> flags)
  QMdiSubWindow_Adaptor(QWidget *parent) : QMdiSubWindow(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QMdiSubWindow::QMdiSubWindow(QWidget *parent, QFlags<Qt::WindowType> flags)
  QMdiSubWindow_Adaptor(QWidget *parent, QFlags<Qt::WindowType> flags) : QMdiSubWindow(parent, flags)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] void QMdiSubWindow::create(WId, bool initializeWindow, bool destroyOldWindow)
  void fp_QMdiSubWindow_create_2208 (const qt_gsi::Converter<WId>::target_type & arg1, bool initializeWindow, bool destroyOldWindow) {
    QMdiSubWindow::create(qt_gsi::QtToCppAdaptor<WId>(arg1).cref(), initializeWindow, destroyOldWindow);
  }

  //  [expose] void QMdiSubWindow::destroy(bool destroyWindow, bool destroySubWindows)
  void fp_QMdiSubWindow_destroy_1620 (bool destroyWindow, bool destroySubWindows) {
    QMdiSubWindow::destroy(destroyWindow, destroySubWindows);
  }

  //  [expose] bool QMdiSubWindow::focusNextChild()
  bool fp_QMdiSubWindow_focusNextChild_0 () {
    return QMdiSubWindow::focusNextChild();
  }

  //  [expose] bool QMdiSubWindow::focusPreviousChild()
  bool fp_QMdiSubWindow_focusPreviousChild_0 () {
    return QMdiSubWindow::focusPreviousChild();
  }

  //  [expose] bool QMdiSubWindow::isSignalConnected(const QMetaMethod &signal)
  bool fp_QMdiSubWindow_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QMdiSubWindow::isSignalConnected(signal);
  }

  //  [expose] int QMdiSubWindow::receivers(const char *signal)
  int fp_QMdiSubWindow_receivers_c1731 (const char *signal) const {
    return QMdiSubWindow::receivers(signal);
  }

  //  [expose] QObject *QMdiSubWindow::sender()
  QObject * fp_QMdiSubWindow_sender_c0 () const {
    return QMdiSubWindow::sender();
  }

  //  [expose] int QMdiSubWindow::senderSignalIndex()
  int fp_QMdiSubWindow_senderSignalIndex_c0 () const {
    return QMdiSubWindow::senderSignalIndex();
  }

  //  [expose] void QMdiSubWindow::updateMicroFocus()
  void fp_QMdiSubWindow_updateMicroFocus_0 () {
    QMdiSubWindow::updateMicroFocus();
  }

  //  [emitter impl] void QMdiSubWindow::aboutToActivate()
  void emitter_QMdiSubWindow_aboutToActivate_0()
  {
    emit QMdiSubWindow::aboutToActivate();
  }

  //  [emitter impl] void QMdiSubWindow::customContextMenuRequested(const QPoint &pos)
  void emitter_QMdiSubWindow_customContextMenuRequested_1916(const QPoint &pos)
  {
    emit QMdiSubWindow::customContextMenuRequested(pos);
  }

  //  [emitter impl] void QMdiSubWindow::destroyed(QObject *)
  void emitter_QMdiSubWindow_destroyed_1302(QObject *arg1)
  {
    emit QMdiSubWindow::destroyed(arg1);
  }

  //  [adaptor impl] bool QMdiSubWindow::hasHeightForWidth()
  bool cbs_hasHeightForWidth_c0_0() const
  {
    return QMdiSubWindow::hasHeightForWidth();
  }

  virtual bool hasHeightForWidth() const
  {
    if (cb_hasHeightForWidth_c0_0.can_issue()) {
      return cb_hasHeightForWidth_c0_0.issue<QMdiSubWindow_Adaptor, bool>(&QMdiSubWindow_Adaptor::cbs_hasHeightForWidth_c0_0);
    } else {
      return QMdiSubWindow::hasHeightForWidth();
    }
  }

  //  [adaptor impl] int QMdiSubWindow::heightForWidth(int)
  int cbs_heightForWidth_c767_0(int arg1) const
  {
    return QMdiSubWindow::heightForWidth(arg1);
  }

  virtual int heightForWidth(int arg1) const
  {
    if (cb_heightForWidth_c767_0.can_issue()) {
      return cb_heightForWidth_c767_0.issue<QMdiSubWindow_Adaptor, int, int>(&QMdiSubWindow_Adaptor::cbs_heightForWidth_c767_0, arg1);
    } else {
      return QMdiSubWindow::heightForWidth(arg1);
    }
  }

  //  [adaptor impl] QVariant QMdiSubWindow::inputMethodQuery(Qt::InputMethodQuery)
  QVariant cbs_inputMethodQuery_c2420_0(const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1) const
  {
    return QMdiSubWindow::inputMethodQuery(qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(arg1).cref());
  }

  virtual QVariant inputMethodQuery(Qt::InputMethodQuery arg1) const
  {
    if (cb_inputMethodQuery_c2420_0.can_issue()) {
      return cb_inputMethodQuery_c2420_0.issue<QMdiSubWindow_Adaptor, QVariant, const qt_gsi::Converter<Qt::InputMethodQuery>::target_type &>(&QMdiSubWindow_Adaptor::cbs_inputMethodQuery_c2420_0, qt_gsi::CppToQtAdaptor<Qt::InputMethodQuery>(arg1));
    } else {
      return QMdiSubWindow::inputMethodQuery(arg1);
    }
  }

  //  [adaptor impl] QSize QMdiSubWindow::minimumSizeHint()
  QSize cbs_minimumSizeHint_c0_0() const
  {
    return QMdiSubWindow::minimumSizeHint();
  }

  virtual QSize minimumSizeHint() const
  {
    if (cb_minimumSizeHint_c0_0.can_issue()) {
      return cb_minimumSizeHint_c0_0.issue<QMdiSubWindow_Adaptor, QSize>(&QMdiSubWindow_Adaptor::cbs_minimumSizeHint_c0_0);
    } else {
      return QMdiSubWindow::minimumSizeHint();
    }
  }

  //  [emitter impl] void QMdiSubWindow::objectNameChanged(const QString &objectName)
  void emitter_QMdiSubWindow_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QMdiSubWindow::objectNameChanged(const QString &objectName)'");
  }

  //  [adaptor impl] QPaintEngine *QMdiSubWindow::paintEngine()
  QPaintEngine * cbs_paintEngine_c0_0() const
  {
    return QMdiSubWindow::paintEngine();
  }

  virtual QPaintEngine * paintEngine() const
  {
    if (cb_paintEngine_c0_0.can_issue()) {
      return cb_paintEngine_c0_0.issue<QMdiSubWindow_Adaptor, QPaintEngine *>(&QMdiSubWindow_Adaptor::cbs_paintEngine_c0_0);
    } else {
      return QMdiSubWindow::paintEngine();
    }
  }

  //  [adaptor impl] void QMdiSubWindow::setVisible(bool visible)
  void cbs_setVisible_864_0(bool visible)
  {
    QMdiSubWindow::setVisible(visible);
  }

  virtual void setVisible(bool visible)
  {
    if (cb_setVisible_864_0.can_issue()) {
      cb_setVisible_864_0.issue<QMdiSubWindow_Adaptor, bool>(&QMdiSubWindow_Adaptor::cbs_setVisible_864_0, visible);
    } else {
      QMdiSubWindow::setVisible(visible);
    }
  }

  //  [adaptor impl] QSize QMdiSubWindow::sizeHint()
  QSize cbs_sizeHint_c0_0() const
  {
    return QMdiSubWindow::sizeHint();
  }

  virtual QSize sizeHint() const
  {
    if (cb_sizeHint_c0_0.can_issue()) {
      return cb_sizeHint_c0_0.issue<QMdiSubWindow_Adaptor, QSize>(&QMdiSubWindow_Adaptor::cbs_sizeHint_c0_0);
    } else {
      return QMdiSubWindow::sizeHint();
    }
  }

  //  [emitter impl] void QMdiSubWindow::windowIconChanged(const QIcon &icon)
  void emitter_QMdiSubWindow_windowIconChanged_1787(const QIcon &icon)
  {
    emit QMdiSubWindow::windowIconChanged(icon);
  }

  //  [emitter impl] void QMdiSubWindow::windowIconTextChanged(const QString &iconText)
  void emitter_QMdiSubWindow_windowIconTextChanged_2025(const QString &iconText)
  {
    emit QMdiSubWindow::windowIconTextChanged(iconText);
  }

  //  [emitter impl] void QMdiSubWindow::windowStateChanged(QFlags<Qt::WindowState> oldState, QFlags<Qt::WindowState> newState)
  void emitter_QMdiSubWindow_windowStateChanged_5072(QFlags<Qt::WindowState> oldState, QFlags<Qt::WindowState> newState)
  {
    emit QMdiSubWindow::windowStateChanged(oldState, newState);
  }

  //  [emitter impl] void QMdiSubWindow::windowTitleChanged(const QString &title)
  void emitter_QMdiSubWindow_windowTitleChanged_2025(const QString &title)
  {
    emit QMdiSubWindow::windowTitleChanged(title);
  }

  //  [adaptor impl] void QMdiSubWindow::actionEvent(QActionEvent *)
  void cbs_actionEvent_1823_0(QActionEvent *arg1)
  {
    QMdiSubWindow::actionEvent(arg1);
  }

  virtual void actionEvent(QActionEvent *arg1)
  {
    if (cb_actionEvent_1823_0.can_issue()) {
      cb_actionEvent_1823_0.issue<QMdiSubWindow_Adaptor, QActionEvent *>(&QMdiSubWindow_Adaptor::cbs_actionEvent_1823_0, arg1);
    } else {
      QMdiSubWindow::actionEvent(arg1);
    }
  }

  //  [adaptor impl] void QMdiSubWindow::changeEvent(QEvent *changeEvent)
  void cbs_changeEvent_1217_0(QEvent *_changeEvent)
  {
    QMdiSubWindow::changeEvent(_changeEvent);
  }

  virtual void changeEvent(QEvent *_changeEvent)
  {
    if (cb_changeEvent_1217_0.can_issue()) {
      cb_changeEvent_1217_0.issue<QMdiSubWindow_Adaptor, QEvent *>(&QMdiSubWindow_Adaptor::cbs_changeEvent_1217_0, _changeEvent);
    } else {
      QMdiSubWindow::changeEvent(_changeEvent);
    }
  }

  //  [adaptor impl] void QMdiSubWindow::childEvent(QChildEvent *childEvent)
  void cbs_childEvent_1701_0(QChildEvent *_childEvent)
  {
    QMdiSubWindow::childEvent(_childEvent);
  }

  virtual void childEvent(QChildEvent *_childEvent)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QMdiSubWindow_Adaptor, QChildEvent *>(&QMdiSubWindow_Adaptor::cbs_childEvent_1701_0, _childEvent);
    } else {
      QMdiSubWindow::childEvent(_childEvent);
    }
  }

  //  [adaptor impl] void QMdiSubWindow::closeEvent(QCloseEvent *closeEvent)
  void cbs_closeEvent_1719_0(QCloseEvent *_closeEvent)
  {
    QMdiSubWindow::closeEvent(_closeEvent);
  }

  virtual void closeEvent(QCloseEvent *_closeEvent)
  {
    if (cb_closeEvent_1719_0.can_issue()) {
      cb_closeEvent_1719_0.issue<QMdiSubWindow_Adaptor, QCloseEvent *>(&QMdiSubWindow_Adaptor::cbs_closeEvent_1719_0, _closeEvent);
    } else {
      QMdiSubWindow::closeEvent(_closeEvent);
    }
  }

  //  [adaptor impl] void QMdiSubWindow::contextMenuEvent(QContextMenuEvent *contextMenuEvent)
  void cbs_contextMenuEvent_2363_0(QContextMenuEvent *_contextMenuEvent)
  {
    QMdiSubWindow::contextMenuEvent(_contextMenuEvent);
  }

  virtual void contextMenuEvent(QContextMenuEvent *_contextMenuEvent)
  {
    if (cb_contextMenuEvent_2363_0.can_issue()) {
      cb_contextMenuEvent_2363_0.issue<QMdiSubWindow_Adaptor, QContextMenuEvent *>(&QMdiSubWindow_Adaptor::cbs_contextMenuEvent_2363_0, _contextMenuEvent);
    } else {
      QMdiSubWindow::contextMenuEvent(_contextMenuEvent);
    }
  }

  //  [adaptor impl] void QMdiSubWindow::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QMdiSubWindow::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QMdiSubWindow_Adaptor, QEvent *>(&QMdiSubWindow_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QMdiSubWindow::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QMdiSubWindow::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QMdiSubWindow::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QMdiSubWindow_Adaptor, const QMetaMethod &>(&QMdiSubWindow_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QMdiSubWindow::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QMdiSubWindow::dragEnterEvent(QDragEnterEvent *)
  void cbs_dragEnterEvent_2109_0(QDragEnterEvent *arg1)
  {
    QMdiSubWindow::dragEnterEvent(arg1);
  }

  virtual void dragEnterEvent(QDragEnterEvent *arg1)
  {
    if (cb_dragEnterEvent_2109_0.can_issue()) {
      cb_dragEnterEvent_2109_0.issue<QMdiSubWindow_Adaptor, QDragEnterEvent *>(&QMdiSubWindow_Adaptor::cbs_dragEnterEvent_2109_0, arg1);
    } else {
      QMdiSubWindow::dragEnterEvent(arg1);
    }
  }

  //  [adaptor impl] void QMdiSubWindow::dragLeaveEvent(QDragLeaveEvent *)
  void cbs_dragLeaveEvent_2092_0(QDragLeaveEvent *arg1)
  {
    QMdiSubWindow::dragLeaveEvent(arg1);
  }

  virtual void dragLeaveEvent(QDragLeaveEvent *arg1)
  {
    if (cb_dragLeaveEvent_2092_0.can_issue()) {
      cb_dragLeaveEvent_2092_0.issue<QMdiSubWindow_Adaptor, QDragLeaveEvent *>(&QMdiSubWindow_Adaptor::cbs_dragLeaveEvent_2092_0, arg1);
    } else {
      QMdiSubWindow::dragLeaveEvent(arg1);
    }
  }

  //  [adaptor impl] void QMdiSubWindow::dragMoveEvent(QDragMoveEvent *)
  void cbs_dragMoveEvent_2006_0(QDragMoveEvent *arg1)
  {
    QMdiSubWindow::dragMoveEvent(arg1);
  }

  virtual void dragMoveEvent(QDragMoveEvent *arg1)
  {
    if (cb_dragMoveEvent_2006_0.can_issue()) {
      cb_dragMoveEvent_2006_0.issue<QMdiSubWindow_Adaptor, QDragMoveEvent *>(&QMdiSubWindow_Adaptor::cbs_dragMoveEvent_2006_0, arg1);
    } else {
      QMdiSubWindow::dragMoveEvent(arg1);
    }
  }

  //  [adaptor impl] void QMdiSubWindow::dropEvent(QDropEvent *)
  void cbs_dropEvent_1622_0(QDropEvent *arg1)
  {
    QMdiSubWindow::dropEvent(arg1);
  }

  virtual void dropEvent(QDropEvent *arg1)
  {
    if (cb_dropEvent_1622_0.can_issue()) {
      cb_dropEvent_1622_0.issue<QMdiSubWindow_Adaptor, QDropEvent *>(&QMdiSubWindow_Adaptor::cbs_dropEvent_1622_0, arg1);
    } else {
      QMdiSubWindow::dropEvent(arg1);
    }
  }

  //  [adaptor impl] void QMdiSubWindow::enterEvent(QEvent *)
  void cbs_enterEvent_1217_0(QEvent *arg1)
  {
    QMdiSubWindow::enterEvent(arg1);
  }

  virtual void enterEvent(QEvent *arg1)
  {
    if (cb_enterEvent_1217_0.can_issue()) {
      cb_enterEvent_1217_0.issue<QMdiSubWindow_Adaptor, QEvent *>(&QMdiSubWindow_Adaptor::cbs_enterEvent_1217_0, arg1);
    } else {
      QMdiSubWindow::enterEvent(arg1);
    }
  }

  //  [adaptor impl] bool QMdiSubWindow::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QMdiSubWindow::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QMdiSubWindow_Adaptor, bool, QEvent *>(&QMdiSubWindow_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QMdiSubWindow::event(_event);
    }
  }

  //  [adaptor impl] bool QMdiSubWindow::eventFilter(QObject *object, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *object, QEvent *event)
  {
    return QMdiSubWindow::eventFilter(object, event);
  }

  virtual bool eventFilter(QObject *object, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QMdiSubWindow_Adaptor, bool, QObject *, QEvent *>(&QMdiSubWindow_Adaptor::cbs_eventFilter_2411_0, object, event);
    } else {
      return QMdiSubWindow::eventFilter(object, event);
    }
  }

  //  [adaptor impl] void QMdiSubWindow::focusInEvent(QFocusEvent *focusInEvent)
  void cbs_focusInEvent_1729_0(QFocusEvent *_focusInEvent)
  {
    QMdiSubWindow::focusInEvent(_focusInEvent);
  }

  virtual void focusInEvent(QFocusEvent *_focusInEvent)
  {
    if (cb_focusInEvent_1729_0.can_issue()) {
      cb_focusInEvent_1729_0.issue<QMdiSubWindow_Adaptor, QFocusEvent *>(&QMdiSubWindow_Adaptor::cbs_focusInEvent_1729_0, _focusInEvent);
    } else {
      QMdiSubWindow::focusInEvent(_focusInEvent);
    }
  }

  //  [adaptor impl] bool QMdiSubWindow::focusNextPrevChild(bool next)
  bool cbs_focusNextPrevChild_864_0(bool next)
  {
    return QMdiSubWindow::focusNextPrevChild(next);
  }

  virtual bool focusNextPrevChild(bool next)
  {
    if (cb_focusNextPrevChild_864_0.can_issue()) {
      return cb_focusNextPrevChild_864_0.issue<QMdiSubWindow_Adaptor, bool, bool>(&QMdiSubWindow_Adaptor::cbs_focusNextPrevChild_864_0, next);
    } else {
      return QMdiSubWindow::focusNextPrevChild(next);
    }
  }

  //  [adaptor impl] void QMdiSubWindow::focusOutEvent(QFocusEvent *focusOutEvent)
  void cbs_focusOutEvent_1729_0(QFocusEvent *_focusOutEvent)
  {
    QMdiSubWindow::focusOutEvent(_focusOutEvent);
  }

  virtual void focusOutEvent(QFocusEvent *_focusOutEvent)
  {
    if (cb_focusOutEvent_1729_0.can_issue()) {
      cb_focusOutEvent_1729_0.issue<QMdiSubWindow_Adaptor, QFocusEvent *>(&QMdiSubWindow_Adaptor::cbs_focusOutEvent_1729_0, _focusOutEvent);
    } else {
      QMdiSubWindow::focusOutEvent(_focusOutEvent);
    }
  }

  //  [adaptor impl] void QMdiSubWindow::hideEvent(QHideEvent *hideEvent)
  void cbs_hideEvent_1595_0(QHideEvent *_hideEvent)
  {
    QMdiSubWindow::hideEvent(_hideEvent);
  }

  virtual void hideEvent(QHideEvent *_hideEvent)
  {
    if (cb_hideEvent_1595_0.can_issue()) {
      cb_hideEvent_1595_0.issue<QMdiSubWindow_Adaptor, QHideEvent *>(&QMdiSubWindow_Adaptor::cbs_hideEvent_1595_0, _hideEvent);
    } else {
      QMdiSubWindow::hideEvent(_hideEvent);
    }
  }

  //  [adaptor impl] void QMdiSubWindow::initPainter(QPainter *painter)
  void cbs_initPainter_c1426_0(QPainter *painter) const
  {
    QMdiSubWindow::initPainter(painter);
  }

  virtual void initPainter(QPainter *painter) const
  {
    if (cb_initPainter_c1426_0.can_issue()) {
      cb_initPainter_c1426_0.issue<QMdiSubWindow_Adaptor, QPainter *>(&QMdiSubWindow_Adaptor::cbs_initPainter_c1426_0, painter);
    } else {
      QMdiSubWindow::initPainter(painter);
    }
  }

  //  [adaptor impl] void QMdiSubWindow::inputMethodEvent(QInputMethodEvent *)
  void cbs_inputMethodEvent_2354_0(QInputMethodEvent *arg1)
  {
    QMdiSubWindow::inputMethodEvent(arg1);
  }

  virtual void inputMethodEvent(QInputMethodEvent *arg1)
  {
    if (cb_inputMethodEvent_2354_0.can_issue()) {
      cb_inputMethodEvent_2354_0.issue<QMdiSubWindow_Adaptor, QInputMethodEvent *>(&QMdiSubWindow_Adaptor::cbs_inputMethodEvent_2354_0, arg1);
    } else {
      QMdiSubWindow::inputMethodEvent(arg1);
    }
  }

  //  [adaptor impl] void QMdiSubWindow::keyPressEvent(QKeyEvent *keyEvent)
  void cbs_keyPressEvent_1514_0(QKeyEvent *keyEvent)
  {
    QMdiSubWindow::keyPressEvent(keyEvent);
  }

  virtual void keyPressEvent(QKeyEvent *keyEvent)
  {
    if (cb_keyPressEvent_1514_0.can_issue()) {
      cb_keyPressEvent_1514_0.issue<QMdiSubWindow_Adaptor, QKeyEvent *>(&QMdiSubWindow_Adaptor::cbs_keyPressEvent_1514_0, keyEvent);
    } else {
      QMdiSubWindow::keyPressEvent(keyEvent);
    }
  }

  //  [adaptor impl] void QMdiSubWindow::keyReleaseEvent(QKeyEvent *)
  void cbs_keyReleaseEvent_1514_0(QKeyEvent *arg1)
  {
    QMdiSubWindow::keyReleaseEvent(arg1);
  }

  virtual void keyReleaseEvent(QKeyEvent *arg1)
  {
    if (cb_keyReleaseEvent_1514_0.can_issue()) {
      cb_keyReleaseEvent_1514_0.issue<QMdiSubWindow_Adaptor, QKeyEvent *>(&QMdiSubWindow_Adaptor::cbs_keyReleaseEvent_1514_0, arg1);
    } else {
      QMdiSubWindow::keyReleaseEvent(arg1);
    }
  }

  //  [adaptor impl] void QMdiSubWindow::leaveEvent(QEvent *leaveEvent)
  void cbs_leaveEvent_1217_0(QEvent *_leaveEvent)
  {
    QMdiSubWindow::leaveEvent(_leaveEvent);
  }

  virtual void leaveEvent(QEvent *_leaveEvent)
  {
    if (cb_leaveEvent_1217_0.can_issue()) {
      cb_leaveEvent_1217_0.issue<QMdiSubWindow_Adaptor, QEvent *>(&QMdiSubWindow_Adaptor::cbs_leaveEvent_1217_0, _leaveEvent);
    } else {
      QMdiSubWindow::leaveEvent(_leaveEvent);
    }
  }

  //  [adaptor impl] int QMdiSubWindow::metric(QPaintDevice::PaintDeviceMetric)
  int cbs_metric_c3445_0(const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1) const
  {
    return QMdiSubWindow::metric(qt_gsi::QtToCppAdaptor<QPaintDevice::PaintDeviceMetric>(arg1).cref());
  }

  virtual int metric(QPaintDevice::PaintDeviceMetric arg1) const
  {
    if (cb_metric_c3445_0.can_issue()) {
      return cb_metric_c3445_0.issue<QMdiSubWindow_Adaptor, int, const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type &>(&QMdiSubWindow_Adaptor::cbs_metric_c3445_0, qt_gsi::CppToQtAdaptor<QPaintDevice::PaintDeviceMetric>(arg1));
    } else {
      return QMdiSubWindow::metric(arg1);
    }
  }

  //  [adaptor impl] void QMdiSubWindow::mouseDoubleClickEvent(QMouseEvent *mouseEvent)
  void cbs_mouseDoubleClickEvent_1738_0(QMouseEvent *mouseEvent)
  {
    QMdiSubWindow::mouseDoubleClickEvent(mouseEvent);
  }

  virtual void mouseDoubleClickEvent(QMouseEvent *mouseEvent)
  {
    if (cb_mouseDoubleClickEvent_1738_0.can_issue()) {
      cb_mouseDoubleClickEvent_1738_0.issue<QMdiSubWindow_Adaptor, QMouseEvent *>(&QMdiSubWindow_Adaptor::cbs_mouseDoubleClickEvent_1738_0, mouseEvent);
    } else {
      QMdiSubWindow::mouseDoubleClickEvent(mouseEvent);
    }
  }

  //  [adaptor impl] void QMdiSubWindow::mouseMoveEvent(QMouseEvent *mouseEvent)
  void cbs_mouseMoveEvent_1738_0(QMouseEvent *mouseEvent)
  {
    QMdiSubWindow::mouseMoveEvent(mouseEvent);
  }

  virtual void mouseMoveEvent(QMouseEvent *mouseEvent)
  {
    if (cb_mouseMoveEvent_1738_0.can_issue()) {
      cb_mouseMoveEvent_1738_0.issue<QMdiSubWindow_Adaptor, QMouseEvent *>(&QMdiSubWindow_Adaptor::cbs_mouseMoveEvent_1738_0, mouseEvent);
    } else {
      QMdiSubWindow::mouseMoveEvent(mouseEvent);
    }
  }

  //  [adaptor impl] void QMdiSubWindow::mousePressEvent(QMouseEvent *mouseEvent)
  void cbs_mousePressEvent_1738_0(QMouseEvent *mouseEvent)
  {
    QMdiSubWindow::mousePressEvent(mouseEvent);
  }

  virtual void mousePressEvent(QMouseEvent *mouseEvent)
  {
    if (cb_mousePressEvent_1738_0.can_issue()) {
      cb_mousePressEvent_1738_0.issue<QMdiSubWindow_Adaptor, QMouseEvent *>(&QMdiSubWindow_Adaptor::cbs_mousePressEvent_1738_0, mouseEvent);
    } else {
      QMdiSubWindow::mousePressEvent(mouseEvent);
    }
  }

  //  [adaptor impl] void QMdiSubWindow::mouseReleaseEvent(QMouseEvent *mouseEvent)
  void cbs_mouseReleaseEvent_1738_0(QMouseEvent *mouseEvent)
  {
    QMdiSubWindow::mouseReleaseEvent(mouseEvent);
  }

  virtual void mouseReleaseEvent(QMouseEvent *mouseEvent)
  {
    if (cb_mouseReleaseEvent_1738_0.can_issue()) {
      cb_mouseReleaseEvent_1738_0.issue<QMdiSubWindow_Adaptor, QMouseEvent *>(&QMdiSubWindow_Adaptor::cbs_mouseReleaseEvent_1738_0, mouseEvent);
    } else {
      QMdiSubWindow::mouseReleaseEvent(mouseEvent);
    }
  }

  //  [adaptor impl] void QMdiSubWindow::moveEvent(QMoveEvent *moveEvent)
  void cbs_moveEvent_1624_0(QMoveEvent *_moveEvent)
  {
    QMdiSubWindow::moveEvent(_moveEvent);
  }

  virtual void moveEvent(QMoveEvent *_moveEvent)
  {
    if (cb_moveEvent_1624_0.can_issue()) {
      cb_moveEvent_1624_0.issue<QMdiSubWindow_Adaptor, QMoveEvent *>(&QMdiSubWindow_Adaptor::cbs_moveEvent_1624_0, _moveEvent);
    } else {
      QMdiSubWindow::moveEvent(_moveEvent);
    }
  }

  //  [adaptor impl] bool QMdiSubWindow::nativeEvent(const QByteArray &eventType, void *message, long int *result)
  bool cbs_nativeEvent_4678_0(const QByteArray &eventType, void *message, long int *result)
  {
    return QMdiSubWindow::nativeEvent(eventType, message, result);
  }

  virtual bool nativeEvent(const QByteArray &eventType, void *message, long int *result)
  {
    if (cb_nativeEvent_4678_0.can_issue()) {
      return cb_nativeEvent_4678_0.issue<QMdiSubWindow_Adaptor, bool, const QByteArray &, void *, long int *>(&QMdiSubWindow_Adaptor::cbs_nativeEvent_4678_0, eventType, message, result);
    } else {
      return QMdiSubWindow::nativeEvent(eventType, message, result);
    }
  }

  //  [adaptor impl] void QMdiSubWindow::paintEvent(QPaintEvent *paintEvent)
  void cbs_paintEvent_1725_0(QPaintEvent *_paintEvent)
  {
    QMdiSubWindow::paintEvent(_paintEvent);
  }

  virtual void paintEvent(QPaintEvent *_paintEvent)
  {
    if (cb_paintEvent_1725_0.can_issue()) {
      cb_paintEvent_1725_0.issue<QMdiSubWindow_Adaptor, QPaintEvent *>(&QMdiSubWindow_Adaptor::cbs_paintEvent_1725_0, _paintEvent);
    } else {
      QMdiSubWindow::paintEvent(_paintEvent);
    }
  }

  //  [adaptor impl] QPaintDevice *QMdiSubWindow::redirected(QPoint *offset)
  QPaintDevice * cbs_redirected_c1225_0(QPoint *offset) const
  {
    return QMdiSubWindow::redirected(offset);
  }

  virtual QPaintDevice * redirected(QPoint *offset) const
  {
    if (cb_redirected_c1225_0.can_issue()) {
      return cb_redirected_c1225_0.issue<QMdiSubWindow_Adaptor, QPaintDevice *, QPoint *>(&QMdiSubWindow_Adaptor::cbs_redirected_c1225_0, offset);
    } else {
      return QMdiSubWindow::redirected(offset);
    }
  }

  //  [adaptor impl] void QMdiSubWindow::resizeEvent(QResizeEvent *resizeEvent)
  void cbs_resizeEvent_1843_0(QResizeEvent *_resizeEvent)
  {
    QMdiSubWindow::resizeEvent(_resizeEvent);
  }

  virtual void resizeEvent(QResizeEvent *_resizeEvent)
  {
    if (cb_resizeEvent_1843_0.can_issue()) {
      cb_resizeEvent_1843_0.issue<QMdiSubWindow_Adaptor, QResizeEvent *>(&QMdiSubWindow_Adaptor::cbs_resizeEvent_1843_0, _resizeEvent);
    } else {
      QMdiSubWindow::resizeEvent(_resizeEvent);
    }
  }

  //  [adaptor impl] QPainter *QMdiSubWindow::sharedPainter()
  QPainter * cbs_sharedPainter_c0_0() const
  {
    return QMdiSubWindow::sharedPainter();
  }

  virtual QPainter * sharedPainter() const
  {
    if (cb_sharedPainter_c0_0.can_issue()) {
      return cb_sharedPainter_c0_0.issue<QMdiSubWindow_Adaptor, QPainter *>(&QMdiSubWindow_Adaptor::cbs_sharedPainter_c0_0);
    } else {
      return QMdiSubWindow::sharedPainter();
    }
  }

  //  [adaptor impl] void QMdiSubWindow::showEvent(QShowEvent *showEvent)
  void cbs_showEvent_1634_0(QShowEvent *_showEvent)
  {
    QMdiSubWindow::showEvent(_showEvent);
  }

  virtual void showEvent(QShowEvent *_showEvent)
  {
    if (cb_showEvent_1634_0.can_issue()) {
      cb_showEvent_1634_0.issue<QMdiSubWindow_Adaptor, QShowEvent *>(&QMdiSubWindow_Adaptor::cbs_showEvent_1634_0, _showEvent);
    } else {
      QMdiSubWindow::showEvent(_showEvent);
    }
  }

  //  [adaptor impl] void QMdiSubWindow::tabletEvent(QTabletEvent *)
  void cbs_tabletEvent_1821_0(QTabletEvent *arg1)
  {
    QMdiSubWindow::tabletEvent(arg1);
  }

  virtual void tabletEvent(QTabletEvent *arg1)
  {
    if (cb_tabletEvent_1821_0.can_issue()) {
      cb_tabletEvent_1821_0.issue<QMdiSubWindow_Adaptor, QTabletEvent *>(&QMdiSubWindow_Adaptor::cbs_tabletEvent_1821_0, arg1);
    } else {
      QMdiSubWindow::tabletEvent(arg1);
    }
  }

  //  [adaptor impl] void QMdiSubWindow::timerEvent(QTimerEvent *timerEvent)
  void cbs_timerEvent_1730_0(QTimerEvent *_timerEvent)
  {
    QMdiSubWindow::timerEvent(_timerEvent);
  }

  virtual void timerEvent(QTimerEvent *_timerEvent)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QMdiSubWindow_Adaptor, QTimerEvent *>(&QMdiSubWindow_Adaptor::cbs_timerEvent_1730_0, _timerEvent);
    } else {
      QMdiSubWindow::timerEvent(_timerEvent);
    }
  }

  //  [adaptor impl] void QMdiSubWindow::wheelEvent(QWheelEvent *)
  void cbs_wheelEvent_1718_0(QWheelEvent *arg1)
  {
    QMdiSubWindow::wheelEvent(arg1);
  }

  virtual void wheelEvent(QWheelEvent *arg1)
  {
    if (cb_wheelEvent_1718_0.can_issue()) {
      cb_wheelEvent_1718_0.issue<QMdiSubWindow_Adaptor, QWheelEvent *>(&QMdiSubWindow_Adaptor::cbs_wheelEvent_1718_0, arg1);
    } else {
      QMdiSubWindow::wheelEvent(arg1);
    }
  }

  gsi::Callback cb_hasHeightForWidth_c0_0;
  gsi::Callback cb_heightForWidth_c767_0;
  gsi::Callback cb_inputMethodQuery_c2420_0;
  gsi::Callback cb_minimumSizeHint_c0_0;
  gsi::Callback cb_paintEngine_c0_0;
  gsi::Callback cb_setVisible_864_0;
  gsi::Callback cb_sizeHint_c0_0;
  gsi::Callback cb_actionEvent_1823_0;
  gsi::Callback cb_changeEvent_1217_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_closeEvent_1719_0;
  gsi::Callback cb_contextMenuEvent_2363_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_dragEnterEvent_2109_0;
  gsi::Callback cb_dragLeaveEvent_2092_0;
  gsi::Callback cb_dragMoveEvent_2006_0;
  gsi::Callback cb_dropEvent_1622_0;
  gsi::Callback cb_enterEvent_1217_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_focusInEvent_1729_0;
  gsi::Callback cb_focusNextPrevChild_864_0;
  gsi::Callback cb_focusOutEvent_1729_0;
  gsi::Callback cb_hideEvent_1595_0;
  gsi::Callback cb_initPainter_c1426_0;
  gsi::Callback cb_inputMethodEvent_2354_0;
  gsi::Callback cb_keyPressEvent_1514_0;
  gsi::Callback cb_keyReleaseEvent_1514_0;
  gsi::Callback cb_leaveEvent_1217_0;
  gsi::Callback cb_metric_c3445_0;
  gsi::Callback cb_mouseDoubleClickEvent_1738_0;
  gsi::Callback cb_mouseMoveEvent_1738_0;
  gsi::Callback cb_mousePressEvent_1738_0;
  gsi::Callback cb_mouseReleaseEvent_1738_0;
  gsi::Callback cb_moveEvent_1624_0;
  gsi::Callback cb_nativeEvent_4678_0;
  gsi::Callback cb_paintEvent_1725_0;
  gsi::Callback cb_redirected_c1225_0;
  gsi::Callback cb_resizeEvent_1843_0;
  gsi::Callback cb_sharedPainter_c0_0;
  gsi::Callback cb_showEvent_1634_0;
  gsi::Callback cb_tabletEvent_1821_0;
  gsi::Callback cb_timerEvent_1730_0;
  gsi::Callback cb_wheelEvent_1718_0;
};

QMdiSubWindow_Adaptor::~QMdiSubWindow_Adaptor() { }

//  Constructor QMdiSubWindow::QMdiSubWindow(QWidget *parent, QFlags<Qt::WindowType> flags) (adaptor class)

static void _init_ctor_QMdiSubWindow_Adaptor_3702 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("flags", true, "0");
  decl->add_arg<QFlags<Qt::WindowType> > (argspec_1);
  decl->set_return_new<QMdiSubWindow_Adaptor> ();
}

static void _call_ctor_QMdiSubWindow_Adaptor_3702 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args ? gsi::arg_reader<QWidget * >() (args, heap) : gsi::arg_maker<QWidget * >() (0, heap);
  QFlags<Qt::WindowType> arg2 = args ? gsi::arg_reader<QFlags<Qt::WindowType> >() (args, heap) : gsi::arg_maker<QFlags<Qt::WindowType> >() (0, heap);
  ret.write<QMdiSubWindow_Adaptor *> (new QMdiSubWindow_Adaptor (arg1, arg2));
}


// emitter void QMdiSubWindow::aboutToActivate()

static void _init_emitter_aboutToActivate_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_aboutToActivate_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QMdiSubWindow_Adaptor *)cls)->emitter_QMdiSubWindow_aboutToActivate_0 ();
}


// void QMdiSubWindow::actionEvent(QActionEvent *)

static void _init_cbs_actionEvent_1823_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QActionEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_actionEvent_1823_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QActionEvent *arg1 = args.read<QActionEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiSubWindow_Adaptor *)cls)->cbs_actionEvent_1823_0 (arg1);
}

static void _set_callback_cbs_actionEvent_1823_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiSubWindow_Adaptor *)cls)->cb_actionEvent_1823_0 = cb;
}


// void QMdiSubWindow::changeEvent(QEvent *changeEvent)

static void _init_cbs_changeEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("changeEvent");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_changeEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiSubWindow_Adaptor *)cls)->cbs_changeEvent_1217_0 (arg1);
}

static void _set_callback_cbs_changeEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiSubWindow_Adaptor *)cls)->cb_changeEvent_1217_0 = cb;
}


// void QMdiSubWindow::childEvent(QChildEvent *childEvent)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("childEvent");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiSubWindow_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiSubWindow_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QMdiSubWindow::closeEvent(QCloseEvent *closeEvent)

static void _init_cbs_closeEvent_1719_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("closeEvent");
  decl->add_arg<QCloseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_closeEvent_1719_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QCloseEvent *arg1 = args.read<QCloseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiSubWindow_Adaptor *)cls)->cbs_closeEvent_1719_0 (arg1);
}

static void _set_callback_cbs_closeEvent_1719_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiSubWindow_Adaptor *)cls)->cb_closeEvent_1719_0 = cb;
}


// void QMdiSubWindow::contextMenuEvent(QContextMenuEvent *contextMenuEvent)

static void _init_cbs_contextMenuEvent_2363_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("contextMenuEvent");
  decl->add_arg<QContextMenuEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_contextMenuEvent_2363_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QContextMenuEvent *arg1 = args.read<QContextMenuEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiSubWindow_Adaptor *)cls)->cbs_contextMenuEvent_2363_0 (arg1);
}

static void _set_callback_cbs_contextMenuEvent_2363_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiSubWindow_Adaptor *)cls)->cb_contextMenuEvent_2363_0 = cb;
}


// exposed void QMdiSubWindow::create(WId, bool initializeWindow, bool destroyOldWindow)

static void _init_fp_create_2208 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<const qt_gsi::Converter<WId>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("initializeWindow", true, "true");
  decl->add_arg<bool > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("destroyOldWindow", true, "true");
  decl->add_arg<bool > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_create_2208 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<WId>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<WId>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<WId>::target_type & >() (qt_gsi::CppToQtReadAdaptor<WId>(heap, 0), heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  bool arg3 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiSubWindow_Adaptor *)cls)->fp_QMdiSubWindow_create_2208 (arg1, arg2, arg3);
}


// emitter void QMdiSubWindow::customContextMenuRequested(const QPoint &pos)

static void _init_emitter_customContextMenuRequested_1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_customContextMenuRequested_1916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPoint &arg1 = gsi::arg_reader<const QPoint & >() (args, heap);
  ((QMdiSubWindow_Adaptor *)cls)->emitter_QMdiSubWindow_customContextMenuRequested_1916 (arg1);
}


// void QMdiSubWindow::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiSubWindow_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiSubWindow_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// exposed void QMdiSubWindow::destroy(bool destroyWindow, bool destroySubWindows)

static void _init_fp_destroy_1620 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("destroyWindow", true, "true");
  decl->add_arg<bool > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("destroySubWindows", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_destroy_1620 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiSubWindow_Adaptor *)cls)->fp_QMdiSubWindow_destroy_1620 (arg1, arg2);
}


// emitter void QMdiSubWindow::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ((QMdiSubWindow_Adaptor *)cls)->emitter_QMdiSubWindow_destroyed_1302 (arg1);
}


// void QMdiSubWindow::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiSubWindow_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiSubWindow_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// void QMdiSubWindow::dragEnterEvent(QDragEnterEvent *)

static void _init_cbs_dragEnterEvent_2109_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragEnterEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragEnterEvent_2109_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragEnterEvent *arg1 = args.read<QDragEnterEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiSubWindow_Adaptor *)cls)->cbs_dragEnterEvent_2109_0 (arg1);
}

static void _set_callback_cbs_dragEnterEvent_2109_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiSubWindow_Adaptor *)cls)->cb_dragEnterEvent_2109_0 = cb;
}


// void QMdiSubWindow::dragLeaveEvent(QDragLeaveEvent *)

static void _init_cbs_dragLeaveEvent_2092_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragLeaveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragLeaveEvent_2092_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragLeaveEvent *arg1 = args.read<QDragLeaveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiSubWindow_Adaptor *)cls)->cbs_dragLeaveEvent_2092_0 (arg1);
}

static void _set_callback_cbs_dragLeaveEvent_2092_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiSubWindow_Adaptor *)cls)->cb_dragLeaveEvent_2092_0 = cb;
}


// void QMdiSubWindow::dragMoveEvent(QDragMoveEvent *)

static void _init_cbs_dragMoveEvent_2006_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragMoveEvent_2006_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDragMoveEvent *arg1 = args.read<QDragMoveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiSubWindow_Adaptor *)cls)->cbs_dragMoveEvent_2006_0 (arg1);
}

static void _set_callback_cbs_dragMoveEvent_2006_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiSubWindow_Adaptor *)cls)->cb_dragMoveEvent_2006_0 = cb;
}


// void QMdiSubWindow::dropEvent(QDropEvent *)

static void _init_cbs_dropEvent_1622_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dropEvent_1622_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDropEvent *arg1 = args.read<QDropEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiSubWindow_Adaptor *)cls)->cbs_dropEvent_1622_0 (arg1);
}

static void _set_callback_cbs_dropEvent_1622_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiSubWindow_Adaptor *)cls)->cb_dropEvent_1622_0 = cb;
}


// void QMdiSubWindow::enterEvent(QEvent *)

static void _init_cbs_enterEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enterEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiSubWindow_Adaptor *)cls)->cbs_enterEvent_1217_0 (arg1);
}

static void _set_callback_cbs_enterEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiSubWindow_Adaptor *)cls)->cb_enterEvent_1217_0 = cb;
}


// bool QMdiSubWindow::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QMdiSubWindow_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiSubWindow_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QMdiSubWindow::eventFilter(QObject *object, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("object");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QMdiSubWindow_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiSubWindow_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// void QMdiSubWindow::focusInEvent(QFocusEvent *focusInEvent)

static void _init_cbs_focusInEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("focusInEvent");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusInEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiSubWindow_Adaptor *)cls)->cbs_focusInEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusInEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiSubWindow_Adaptor *)cls)->cb_focusInEvent_1729_0 = cb;
}


// exposed bool QMdiSubWindow::focusNextChild()

static void _init_fp_focusNextChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusNextChild_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QMdiSubWindow_Adaptor *)cls)->fp_QMdiSubWindow_focusNextChild_0 ());
}


// bool QMdiSubWindow::focusNextPrevChild(bool next)

static void _init_cbs_focusNextPrevChild_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("next");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_focusNextPrevChild_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  ret.write<bool > ((bool)((QMdiSubWindow_Adaptor *)cls)->cbs_focusNextPrevChild_864_0 (arg1));
}

static void _set_callback_cbs_focusNextPrevChild_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiSubWindow_Adaptor *)cls)->cb_focusNextPrevChild_864_0 = cb;
}


// void QMdiSubWindow::focusOutEvent(QFocusEvent *focusOutEvent)

static void _init_cbs_focusOutEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("focusOutEvent");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusOutEvent_1729_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFocusEvent *arg1 = args.read<QFocusEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiSubWindow_Adaptor *)cls)->cbs_focusOutEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusOutEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiSubWindow_Adaptor *)cls)->cb_focusOutEvent_1729_0 = cb;
}


// exposed bool QMdiSubWindow::focusPreviousChild()

static void _init_fp_focusPreviousChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusPreviousChild_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QMdiSubWindow_Adaptor *)cls)->fp_QMdiSubWindow_focusPreviousChild_0 ());
}


// bool QMdiSubWindow::hasHeightForWidth()

static void _init_cbs_hasHeightForWidth_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_hasHeightForWidth_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QMdiSubWindow_Adaptor *)cls)->cbs_hasHeightForWidth_c0_0 ());
}

static void _set_callback_cbs_hasHeightForWidth_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiSubWindow_Adaptor *)cls)->cb_hasHeightForWidth_c0_0 = cb;
}


// int QMdiSubWindow::heightForWidth(int)

static void _init_cbs_heightForWidth_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_heightForWidth_c767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<int > ((int)((QMdiSubWindow_Adaptor *)cls)->cbs_heightForWidth_c767_0 (arg1));
}

static void _set_callback_cbs_heightForWidth_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiSubWindow_Adaptor *)cls)->cb_heightForWidth_c767_0 = cb;
}


// void QMdiSubWindow::hideEvent(QHideEvent *hideEvent)

static void _init_cbs_hideEvent_1595_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("hideEvent");
  decl->add_arg<QHideEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hideEvent_1595_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QHideEvent *arg1 = args.read<QHideEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiSubWindow_Adaptor *)cls)->cbs_hideEvent_1595_0 (arg1);
}

static void _set_callback_cbs_hideEvent_1595_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiSubWindow_Adaptor *)cls)->cb_hideEvent_1595_0 = cb;
}


// void QMdiSubWindow::initPainter(QPainter *painter)

static void _init_cbs_initPainter_c1426_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_initPainter_c1426_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = args.read<QPainter * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiSubWindow_Adaptor *)cls)->cbs_initPainter_c1426_0 (arg1);
}

static void _set_callback_cbs_initPainter_c1426_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiSubWindow_Adaptor *)cls)->cb_initPainter_c1426_0 = cb;
}


// void QMdiSubWindow::inputMethodEvent(QInputMethodEvent *)

static void _init_cbs_inputMethodEvent_2354_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QInputMethodEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_inputMethodEvent_2354_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QInputMethodEvent *arg1 = args.read<QInputMethodEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiSubWindow_Adaptor *)cls)->cbs_inputMethodEvent_2354_0 (arg1);
}

static void _set_callback_cbs_inputMethodEvent_2354_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiSubWindow_Adaptor *)cls)->cb_inputMethodEvent_2354_0 = cb;
}


// QVariant QMdiSubWindow::inputMethodQuery(Qt::InputMethodQuery)

static void _init_cbs_inputMethodQuery_c2420_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_inputMethodQuery_c2420_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (heap);
  ret.write<QVariant > ((QVariant)((QMdiSubWindow_Adaptor *)cls)->cbs_inputMethodQuery_c2420_0 (arg1));
}

static void _set_callback_cbs_inputMethodQuery_c2420_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiSubWindow_Adaptor *)cls)->cb_inputMethodQuery_c2420_0 = cb;
}


// exposed bool QMdiSubWindow::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QMdiSubWindow_Adaptor *)cls)->fp_QMdiSubWindow_isSignalConnected_c2394 (arg1));
}


// void QMdiSubWindow::keyPressEvent(QKeyEvent *keyEvent)

static void _init_cbs_keyPressEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("keyEvent");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyPressEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiSubWindow_Adaptor *)cls)->cbs_keyPressEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyPressEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiSubWindow_Adaptor *)cls)->cb_keyPressEvent_1514_0 = cb;
}


// void QMdiSubWindow::keyReleaseEvent(QKeyEvent *)

static void _init_cbs_keyReleaseEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyReleaseEvent_1514_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QKeyEvent *arg1 = args.read<QKeyEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiSubWindow_Adaptor *)cls)->cbs_keyReleaseEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyReleaseEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiSubWindow_Adaptor *)cls)->cb_keyReleaseEvent_1514_0 = cb;
}


// void QMdiSubWindow::leaveEvent(QEvent *leaveEvent)

static void _init_cbs_leaveEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("leaveEvent");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_leaveEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiSubWindow_Adaptor *)cls)->cbs_leaveEvent_1217_0 (arg1);
}

static void _set_callback_cbs_leaveEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiSubWindow_Adaptor *)cls)->cb_leaveEvent_1217_0 = cb;
}


// int QMdiSubWindow::metric(QPaintDevice::PaintDeviceMetric)

static void _init_cbs_metric_c3445_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_metric_c3445_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1 = args.read<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (heap);
  ret.write<int > ((int)((QMdiSubWindow_Adaptor *)cls)->cbs_metric_c3445_0 (arg1));
}

static void _set_callback_cbs_metric_c3445_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiSubWindow_Adaptor *)cls)->cb_metric_c3445_0 = cb;
}


// QSize QMdiSubWindow::minimumSizeHint()

static void _init_cbs_minimumSizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_minimumSizeHint_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QMdiSubWindow_Adaptor *)cls)->cbs_minimumSizeHint_c0_0 ());
}

static void _set_callback_cbs_minimumSizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiSubWindow_Adaptor *)cls)->cb_minimumSizeHint_c0_0 = cb;
}


// void QMdiSubWindow::mouseDoubleClickEvent(QMouseEvent *mouseEvent)

static void _init_cbs_mouseDoubleClickEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mouseEvent");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseDoubleClickEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiSubWindow_Adaptor *)cls)->cbs_mouseDoubleClickEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseDoubleClickEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiSubWindow_Adaptor *)cls)->cb_mouseDoubleClickEvent_1738_0 = cb;
}


// void QMdiSubWindow::mouseMoveEvent(QMouseEvent *mouseEvent)

static void _init_cbs_mouseMoveEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mouseEvent");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseMoveEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiSubWindow_Adaptor *)cls)->cbs_mouseMoveEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseMoveEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiSubWindow_Adaptor *)cls)->cb_mouseMoveEvent_1738_0 = cb;
}


// void QMdiSubWindow::mousePressEvent(QMouseEvent *mouseEvent)

static void _init_cbs_mousePressEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mouseEvent");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mousePressEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiSubWindow_Adaptor *)cls)->cbs_mousePressEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mousePressEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiSubWindow_Adaptor *)cls)->cb_mousePressEvent_1738_0 = cb;
}


// void QMdiSubWindow::mouseReleaseEvent(QMouseEvent *mouseEvent)

static void _init_cbs_mouseReleaseEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mouseEvent");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseReleaseEvent_1738_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMouseEvent *arg1 = args.read<QMouseEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiSubWindow_Adaptor *)cls)->cbs_mouseReleaseEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseReleaseEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiSubWindow_Adaptor *)cls)->cb_mouseReleaseEvent_1738_0 = cb;
}


// void QMdiSubWindow::moveEvent(QMoveEvent *moveEvent)

static void _init_cbs_moveEvent_1624_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("moveEvent");
  decl->add_arg<QMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_moveEvent_1624_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QMoveEvent *arg1 = args.read<QMoveEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiSubWindow_Adaptor *)cls)->cbs_moveEvent_1624_0 (arg1);
}

static void _set_callback_cbs_moveEvent_1624_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiSubWindow_Adaptor *)cls)->cb_moveEvent_1624_0 = cb;
}


// bool QMdiSubWindow::nativeEvent(const QByteArray &eventType, void *message, long int *result)

static void _init_cbs_nativeEvent_4678_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("eventType");
  decl->add_arg<const QByteArray & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("message");
  decl->add_arg<void * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("result");
  decl->add_arg<long int * > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_nativeEvent_4678_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QByteArray &arg1 = args.read<const QByteArray & > (heap);
  void *arg2 = args.read<void * > (heap);
  long int *arg3 = args.read<long int * > (heap);
  ret.write<bool > ((bool)((QMdiSubWindow_Adaptor *)cls)->cbs_nativeEvent_4678_0 (arg1, arg2, arg3));
}

static void _set_callback_cbs_nativeEvent_4678_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiSubWindow_Adaptor *)cls)->cb_nativeEvent_4678_0 = cb;
}


// emitter void QMdiSubWindow::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QMdiSubWindow_Adaptor *)cls)->emitter_QMdiSubWindow_objectNameChanged_4567 (arg1);
}


// QPaintEngine *QMdiSubWindow::paintEngine()

static void _init_cbs_paintEngine_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintEngine * > ();
}

static void _call_cbs_paintEngine_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPaintEngine * > ((QPaintEngine *)((QMdiSubWindow_Adaptor *)cls)->cbs_paintEngine_c0_0 ());
}

static void _set_callback_cbs_paintEngine_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiSubWindow_Adaptor *)cls)->cb_paintEngine_c0_0 = cb;
}


// void QMdiSubWindow::paintEvent(QPaintEvent *paintEvent)

static void _init_cbs_paintEvent_1725_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("paintEvent");
  decl->add_arg<QPaintEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paintEvent_1725_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPaintEvent *arg1 = args.read<QPaintEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiSubWindow_Adaptor *)cls)->cbs_paintEvent_1725_0 (arg1);
}

static void _set_callback_cbs_paintEvent_1725_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiSubWindow_Adaptor *)cls)->cb_paintEvent_1725_0 = cb;
}


// exposed int QMdiSubWindow::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QMdiSubWindow_Adaptor *)cls)->fp_QMdiSubWindow_receivers_c1731 (arg1));
}


// QPaintDevice *QMdiSubWindow::redirected(QPoint *offset)

static void _init_cbs_redirected_c1225_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("offset");
  decl->add_arg<QPoint * > (argspec_0);
  decl->set_return<QPaintDevice * > ();
}

static void _call_cbs_redirected_c1225_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPoint *arg1 = args.read<QPoint * > (heap);
  ret.write<QPaintDevice * > ((QPaintDevice *)((QMdiSubWindow_Adaptor *)cls)->cbs_redirected_c1225_0 (arg1));
}

static void _set_callback_cbs_redirected_c1225_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiSubWindow_Adaptor *)cls)->cb_redirected_c1225_0 = cb;
}


// void QMdiSubWindow::resizeEvent(QResizeEvent *resizeEvent)

static void _init_cbs_resizeEvent_1843_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("resizeEvent");
  decl->add_arg<QResizeEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_resizeEvent_1843_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QResizeEvent *arg1 = args.read<QResizeEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiSubWindow_Adaptor *)cls)->cbs_resizeEvent_1843_0 (arg1);
}

static void _set_callback_cbs_resizeEvent_1843_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiSubWindow_Adaptor *)cls)->cb_resizeEvent_1843_0 = cb;
}


// exposed QObject *QMdiSubWindow::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QMdiSubWindow_Adaptor *)cls)->fp_QMdiSubWindow_sender_c0 ());
}


// exposed int QMdiSubWindow::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QMdiSubWindow_Adaptor *)cls)->fp_QMdiSubWindow_senderSignalIndex_c0 ());
}


// void QMdiSubWindow::setVisible(bool visible)

static void _init_cbs_setVisible_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setVisible_864_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = args.read<bool > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiSubWindow_Adaptor *)cls)->cbs_setVisible_864_0 (arg1);
}

static void _set_callback_cbs_setVisible_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiSubWindow_Adaptor *)cls)->cb_setVisible_864_0 = cb;
}


// QPainter *QMdiSubWindow::sharedPainter()

static void _init_cbs_sharedPainter_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPainter * > ();
}

static void _call_cbs_sharedPainter_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPainter * > ((QPainter *)((QMdiSubWindow_Adaptor *)cls)->cbs_sharedPainter_c0_0 ());
}

static void _set_callback_cbs_sharedPainter_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiSubWindow_Adaptor *)cls)->cb_sharedPainter_c0_0 = cb;
}


// void QMdiSubWindow::showEvent(QShowEvent *showEvent)

static void _init_cbs_showEvent_1634_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("showEvent");
  decl->add_arg<QShowEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_showEvent_1634_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QShowEvent *arg1 = args.read<QShowEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiSubWindow_Adaptor *)cls)->cbs_showEvent_1634_0 (arg1);
}

static void _set_callback_cbs_showEvent_1634_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiSubWindow_Adaptor *)cls)->cb_showEvent_1634_0 = cb;
}


// QSize QMdiSubWindow::sizeHint()

static void _init_cbs_sizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_sizeHint_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QMdiSubWindow_Adaptor *)cls)->cbs_sizeHint_c0_0 ());
}

static void _set_callback_cbs_sizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiSubWindow_Adaptor *)cls)->cb_sizeHint_c0_0 = cb;
}


// void QMdiSubWindow::tabletEvent(QTabletEvent *)

static void _init_cbs_tabletEvent_1821_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTabletEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_tabletEvent_1821_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTabletEvent *arg1 = args.read<QTabletEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiSubWindow_Adaptor *)cls)->cbs_tabletEvent_1821_0 (arg1);
}

static void _set_callback_cbs_tabletEvent_1821_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiSubWindow_Adaptor *)cls)->cb_tabletEvent_1821_0 = cb;
}


// void QMdiSubWindow::timerEvent(QTimerEvent *timerEvent)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("timerEvent");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiSubWindow_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiSubWindow_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// exposed void QMdiSubWindow::updateMicroFocus()

static void _init_fp_updateMicroFocus_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_updateMicroFocus_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiSubWindow_Adaptor *)cls)->fp_QMdiSubWindow_updateMicroFocus_0 ();
}


// void QMdiSubWindow::wheelEvent(QWheelEvent *)

static void _init_cbs_wheelEvent_1718_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWheelEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_wheelEvent_1718_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWheelEvent *arg1 = args.read<QWheelEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMdiSubWindow_Adaptor *)cls)->cbs_wheelEvent_1718_0 (arg1);
}

static void _set_callback_cbs_wheelEvent_1718_0 (void *cls, const gsi::Callback &cb)
{
  ((QMdiSubWindow_Adaptor *)cls)->cb_wheelEvent_1718_0 = cb;
}


// emitter void QMdiSubWindow::windowIconChanged(const QIcon &icon)

static void _init_emitter_windowIconChanged_1787 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("icon");
  decl->add_arg<const QIcon & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_windowIconChanged_1787 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QIcon &arg1 = gsi::arg_reader<const QIcon & >() (args, heap);
  ((QMdiSubWindow_Adaptor *)cls)->emitter_QMdiSubWindow_windowIconChanged_1787 (arg1);
}


// emitter void QMdiSubWindow::windowIconTextChanged(const QString &iconText)

static void _init_emitter_windowIconTextChanged_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("iconText");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_windowIconTextChanged_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QMdiSubWindow_Adaptor *)cls)->emitter_QMdiSubWindow_windowIconTextChanged_2025 (arg1);
}


// emitter void QMdiSubWindow::windowStateChanged(QFlags<Qt::WindowState> oldState, QFlags<Qt::WindowState> newState)

static void _init_emitter_windowStateChanged_5072 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("oldState");
  decl->add_arg<QFlags<Qt::WindowState> > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("newState");
  decl->add_arg<QFlags<Qt::WindowState> > (argspec_1);
  decl->set_return<void > ();
}

static void _call_emitter_windowStateChanged_5072 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<Qt::WindowState> arg1 = gsi::arg_reader<QFlags<Qt::WindowState> >() (args, heap);
  QFlags<Qt::WindowState> arg2 = gsi::arg_reader<QFlags<Qt::WindowState> >() (args, heap);
  ((QMdiSubWindow_Adaptor *)cls)->emitter_QMdiSubWindow_windowStateChanged_5072 (arg1, arg2);
}


// emitter void QMdiSubWindow::windowTitleChanged(const QString &title)

static void _init_emitter_windowTitleChanged_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("title");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_windowTitleChanged_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QMdiSubWindow_Adaptor *)cls)->emitter_QMdiSubWindow_windowTitleChanged_2025 (arg1);
}


namespace gsi
{

gsi::Class<QMdiSubWindow> &qtdecl_QMdiSubWindow ();

static gsi::Methods methods_QMdiSubWindow_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QMdiSubWindow::QMdiSubWindow(QWidget *parent, QFlags<Qt::WindowType> flags)\nThis method creates an object of class QMdiSubWindow.", &_init_ctor_QMdiSubWindow_Adaptor_3702, &_call_ctor_QMdiSubWindow_Adaptor_3702);
  methods += new qt_gsi::GenericMethod ("emit_aboutToActivate", "@brief Emitter for signal void QMdiSubWindow::aboutToActivate()\nCall this method to emit this signal.", false, &_init_emitter_aboutToActivate_0, &_call_emitter_aboutToActivate_0);
  methods += new qt_gsi::GenericMethod ("*actionEvent", "@brief Virtual method void QMdiSubWindow::actionEvent(QActionEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0);
  methods += new qt_gsi::GenericMethod ("*actionEvent", "@hide", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0, &_set_callback_cbs_actionEvent_1823_0);
  methods += new qt_gsi::GenericMethod ("*changeEvent", "@brief Virtual method void QMdiSubWindow::changeEvent(QEvent *changeEvent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*changeEvent", "@hide", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0, &_set_callback_cbs_changeEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QMdiSubWindow::childEvent(QChildEvent *childEvent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*closeEvent", "@brief Virtual method void QMdiSubWindow::closeEvent(QCloseEvent *closeEvent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0);
  methods += new qt_gsi::GenericMethod ("*closeEvent", "@hide", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0, &_set_callback_cbs_closeEvent_1719_0);
  methods += new qt_gsi::GenericMethod ("*contextMenuEvent", "@brief Virtual method void QMdiSubWindow::contextMenuEvent(QContextMenuEvent *contextMenuEvent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0);
  methods += new qt_gsi::GenericMethod ("*contextMenuEvent", "@hide", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0, &_set_callback_cbs_contextMenuEvent_2363_0);
  methods += new qt_gsi::GenericMethod ("*qt_create", "@brief Method void QMdiSubWindow::create(WId, bool initializeWindow, bool destroyOldWindow)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_create_2208, &_call_fp_create_2208);
  methods += new qt_gsi::GenericMethod ("emit_customContextMenuRequested", "@brief Emitter for signal void QMdiSubWindow::customContextMenuRequested(const QPoint &pos)\nCall this method to emit this signal.", false, &_init_emitter_customContextMenuRequested_1916, &_call_emitter_customContextMenuRequested_1916);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QMdiSubWindow::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*qt_destroy", "@brief Method void QMdiSubWindow::destroy(bool destroyWindow, bool destroySubWindows)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_destroy_1620, &_call_fp_destroy_1620);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QMdiSubWindow::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QMdiSubWindow::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*dragEnterEvent", "@brief Virtual method void QMdiSubWindow::dragEnterEvent(QDragEnterEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0);
  methods += new qt_gsi::GenericMethod ("*dragEnterEvent", "@hide", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0, &_set_callback_cbs_dragEnterEvent_2109_0);
  methods += new qt_gsi::GenericMethod ("*dragLeaveEvent", "@brief Virtual method void QMdiSubWindow::dragLeaveEvent(QDragLeaveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0);
  methods += new qt_gsi::GenericMethod ("*dragLeaveEvent", "@hide", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0, &_set_callback_cbs_dragLeaveEvent_2092_0);
  methods += new qt_gsi::GenericMethod ("*dragMoveEvent", "@brief Virtual method void QMdiSubWindow::dragMoveEvent(QDragMoveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0);
  methods += new qt_gsi::GenericMethod ("*dragMoveEvent", "@hide", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0, &_set_callback_cbs_dragMoveEvent_2006_0);
  methods += new qt_gsi::GenericMethod ("*dropEvent", "@brief Virtual method void QMdiSubWindow::dropEvent(QDropEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0);
  methods += new qt_gsi::GenericMethod ("*dropEvent", "@hide", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0, &_set_callback_cbs_dropEvent_1622_0);
  methods += new qt_gsi::GenericMethod ("*enterEvent", "@brief Virtual method void QMdiSubWindow::enterEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*enterEvent", "@hide", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0, &_set_callback_cbs_enterEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QMdiSubWindow::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("*eventFilter", "@brief Virtual method bool QMdiSubWindow::eventFilter(QObject *object, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@brief Virtual method void QMdiSubWindow::focusInEvent(QFocusEvent *focusInEvent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusInEvent", "@hide", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0, &_set_callback_cbs_focusInEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusNextChild", "@brief Method bool QMdiSubWindow::focusNextChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusNextChild_0, &_call_fp_focusNextChild_0);
  methods += new qt_gsi::GenericMethod ("*focusNextPrevChild", "@brief Virtual method bool QMdiSubWindow::focusNextPrevChild(bool next)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0);
  methods += new qt_gsi::GenericMethod ("*focusNextPrevChild", "@hide", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0, &_set_callback_cbs_focusNextPrevChild_864_0);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@brief Virtual method void QMdiSubWindow::focusOutEvent(QFocusEvent *focusOutEvent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusOutEvent", "@hide", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0, &_set_callback_cbs_focusOutEvent_1729_0);
  methods += new qt_gsi::GenericMethod ("*focusPreviousChild", "@brief Method bool QMdiSubWindow::focusPreviousChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusPreviousChild_0, &_call_fp_focusPreviousChild_0);
  methods += new qt_gsi::GenericMethod ("hasHeightForWidth", "@brief Virtual method bool QMdiSubWindow::hasHeightForWidth()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_hasHeightForWidth_c0_0, &_call_cbs_hasHeightForWidth_c0_0);
  methods += new qt_gsi::GenericMethod ("hasHeightForWidth", "@hide", true, &_init_cbs_hasHeightForWidth_c0_0, &_call_cbs_hasHeightForWidth_c0_0, &_set_callback_cbs_hasHeightForWidth_c0_0);
  methods += new qt_gsi::GenericMethod ("heightForWidth", "@brief Virtual method int QMdiSubWindow::heightForWidth(int)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("heightForWidth", "@hide", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0, &_set_callback_cbs_heightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("*hideEvent", "@brief Virtual method void QMdiSubWindow::hideEvent(QHideEvent *hideEvent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0);
  methods += new qt_gsi::GenericMethod ("*hideEvent", "@hide", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0, &_set_callback_cbs_hideEvent_1595_0);
  methods += new qt_gsi::GenericMethod ("*initPainter", "@brief Virtual method void QMdiSubWindow::initPainter(QPainter *painter)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_initPainter_c1426_0, &_call_cbs_initPainter_c1426_0);
  methods += new qt_gsi::GenericMethod ("*initPainter", "@hide", true, &_init_cbs_initPainter_c1426_0, &_call_cbs_initPainter_c1426_0, &_set_callback_cbs_initPainter_c1426_0);
  methods += new qt_gsi::GenericMethod ("*inputMethodEvent", "@brief Virtual method void QMdiSubWindow::inputMethodEvent(QInputMethodEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0);
  methods += new qt_gsi::GenericMethod ("*inputMethodEvent", "@hide", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0, &_set_callback_cbs_inputMethodEvent_2354_0);
  methods += new qt_gsi::GenericMethod ("inputMethodQuery", "@brief Virtual method QVariant QMdiSubWindow::inputMethodQuery(Qt::InputMethodQuery)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0);
  methods += new qt_gsi::GenericMethod ("inputMethodQuery", "@hide", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0, &_set_callback_cbs_inputMethodQuery_c2420_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QMdiSubWindow::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@brief Virtual method void QMdiSubWindow::keyPressEvent(QKeyEvent *keyEvent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyPressEvent", "@hide", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0, &_set_callback_cbs_keyPressEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@brief Virtual method void QMdiSubWindow::keyReleaseEvent(QKeyEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*keyReleaseEvent", "@hide", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0, &_set_callback_cbs_keyReleaseEvent_1514_0);
  methods += new qt_gsi::GenericMethod ("*leaveEvent", "@brief Virtual method void QMdiSubWindow::leaveEvent(QEvent *leaveEvent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*leaveEvent", "@hide", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0, &_set_callback_cbs_leaveEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*metric", "@brief Virtual method int QMdiSubWindow::metric(QPaintDevice::PaintDeviceMetric)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("*metric", "@hide", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0, &_set_callback_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("minimumSizeHint", "@brief Virtual method QSize QMdiSubWindow::minimumSizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("minimumSizeHint", "@hide", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0, &_set_callback_cbs_minimumSizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@brief Virtual method void QMdiSubWindow::mouseDoubleClickEvent(QMouseEvent *mouseEvent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@hide", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0, &_set_callback_cbs_mouseDoubleClickEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@brief Virtual method void QMdiSubWindow::mouseMoveEvent(QMouseEvent *mouseEvent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseMoveEvent", "@hide", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0, &_set_callback_cbs_mouseMoveEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@brief Virtual method void QMdiSubWindow::mousePressEvent(QMouseEvent *mouseEvent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mousePressEvent", "@hide", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0, &_set_callback_cbs_mousePressEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@brief Virtual method void QMdiSubWindow::mouseReleaseEvent(QMouseEvent *mouseEvent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@hide", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0, &_set_callback_cbs_mouseReleaseEvent_1738_0);
  methods += new qt_gsi::GenericMethod ("*moveEvent", "@brief Virtual method void QMdiSubWindow::moveEvent(QMoveEvent *moveEvent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0);
  methods += new qt_gsi::GenericMethod ("*moveEvent", "@hide", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0, &_set_callback_cbs_moveEvent_1624_0);
  methods += new qt_gsi::GenericMethod ("*nativeEvent", "@brief Virtual method bool QMdiSubWindow::nativeEvent(const QByteArray &eventType, void *message, long int *result)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_nativeEvent_4678_0, &_call_cbs_nativeEvent_4678_0);
  methods += new qt_gsi::GenericMethod ("*nativeEvent", "@hide", false, &_init_cbs_nativeEvent_4678_0, &_call_cbs_nativeEvent_4678_0, &_set_callback_cbs_nativeEvent_4678_0);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QMdiSubWindow::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("paintEngine", "@brief Virtual method QPaintEngine *QMdiSubWindow::paintEngine()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0);
  methods += new qt_gsi::GenericMethod ("paintEngine", "@hide", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0, &_set_callback_cbs_paintEngine_c0_0);
  methods += new qt_gsi::GenericMethod ("*paintEvent", "@brief Virtual method void QMdiSubWindow::paintEvent(QPaintEvent *paintEvent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0);
  methods += new qt_gsi::GenericMethod ("*paintEvent", "@hide", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0, &_set_callback_cbs_paintEvent_1725_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QMdiSubWindow::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*redirected", "@brief Virtual method QPaintDevice *QMdiSubWindow::redirected(QPoint *offset)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_redirected_c1225_0, &_call_cbs_redirected_c1225_0);
  methods += new qt_gsi::GenericMethod ("*redirected", "@hide", true, &_init_cbs_redirected_c1225_0, &_call_cbs_redirected_c1225_0, &_set_callback_cbs_redirected_c1225_0);
  methods += new qt_gsi::GenericMethod ("*resizeEvent", "@brief Virtual method void QMdiSubWindow::resizeEvent(QResizeEvent *resizeEvent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0);
  methods += new qt_gsi::GenericMethod ("*resizeEvent", "@hide", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0, &_set_callback_cbs_resizeEvent_1843_0);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QMdiSubWindow::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QMdiSubWindow::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("setVisible", "@brief Virtual method void QMdiSubWindow::setVisible(bool visible)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0);
  methods += new qt_gsi::GenericMethod ("setVisible", "@hide", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0, &_set_callback_cbs_setVisible_864_0);
  methods += new qt_gsi::GenericMethod ("*sharedPainter", "@brief Virtual method QPainter *QMdiSubWindow::sharedPainter()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sharedPainter_c0_0, &_call_cbs_sharedPainter_c0_0);
  methods += new qt_gsi::GenericMethod ("*sharedPainter", "@hide", true, &_init_cbs_sharedPainter_c0_0, &_call_cbs_sharedPainter_c0_0, &_set_callback_cbs_sharedPainter_c0_0);
  methods += new qt_gsi::GenericMethod ("*showEvent", "@brief Virtual method void QMdiSubWindow::showEvent(QShowEvent *showEvent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0);
  methods += new qt_gsi::GenericMethod ("*showEvent", "@hide", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0, &_set_callback_cbs_showEvent_1634_0);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@brief Virtual method QSize QMdiSubWindow::sizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@hide", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0, &_set_callback_cbs_sizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("*tabletEvent", "@brief Virtual method void QMdiSubWindow::tabletEvent(QTabletEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0);
  methods += new qt_gsi::GenericMethod ("*tabletEvent", "@hide", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0, &_set_callback_cbs_tabletEvent_1821_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QMdiSubWindow::timerEvent(QTimerEvent *timerEvent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*updateMicroFocus", "@brief Method void QMdiSubWindow::updateMicroFocus()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_updateMicroFocus_0, &_call_fp_updateMicroFocus_0);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@brief Virtual method void QMdiSubWindow::wheelEvent(QWheelEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0);
  methods += new qt_gsi::GenericMethod ("*wheelEvent", "@hide", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0, &_set_callback_cbs_wheelEvent_1718_0);
  methods += new qt_gsi::GenericMethod ("emit_windowIconChanged", "@brief Emitter for signal void QMdiSubWindow::windowIconChanged(const QIcon &icon)\nCall this method to emit this signal.", false, &_init_emitter_windowIconChanged_1787, &_call_emitter_windowIconChanged_1787);
  methods += new qt_gsi::GenericMethod ("emit_windowIconTextChanged", "@brief Emitter for signal void QMdiSubWindow::windowIconTextChanged(const QString &iconText)\nCall this method to emit this signal.", false, &_init_emitter_windowIconTextChanged_2025, &_call_emitter_windowIconTextChanged_2025);
  methods += new qt_gsi::GenericMethod ("emit_windowStateChanged", "@brief Emitter for signal void QMdiSubWindow::windowStateChanged(QFlags<Qt::WindowState> oldState, QFlags<Qt::WindowState> newState)\nCall this method to emit this signal.", false, &_init_emitter_windowStateChanged_5072, &_call_emitter_windowStateChanged_5072);
  methods += new qt_gsi::GenericMethod ("emit_windowTitleChanged", "@brief Emitter for signal void QMdiSubWindow::windowTitleChanged(const QString &title)\nCall this method to emit this signal.", false, &_init_emitter_windowTitleChanged_2025, &_call_emitter_windowTitleChanged_2025);
  return methods;
}

gsi::Class<QMdiSubWindow_Adaptor> decl_QMdiSubWindow_Adaptor (qtdecl_QMdiSubWindow (), "QtWidgets", "QMdiSubWindow",
  methods_QMdiSubWindow_Adaptor (),
  "@qt\n@brief Binding of QMdiSubWindow");

}


//  Implementation of the enum wrapper class for QMdiSubWindow::SubWindowOption
namespace qt_gsi
{

static gsi::Enum<QMdiSubWindow::SubWindowOption> decl_QMdiSubWindow_SubWindowOption_Enum ("QtWidgets", "QMdiSubWindow_SubWindowOption",
    gsi::enum_const ("AllowOutsideAreaHorizontally", QMdiSubWindow::AllowOutsideAreaHorizontally, "@brief Enum constant QMdiSubWindow::AllowOutsideAreaHorizontally") +
    gsi::enum_const ("AllowOutsideAreaVertically", QMdiSubWindow::AllowOutsideAreaVertically, "@brief Enum constant QMdiSubWindow::AllowOutsideAreaVertically") +
    gsi::enum_const ("RubberBandResize", QMdiSubWindow::RubberBandResize, "@brief Enum constant QMdiSubWindow::RubberBandResize") +
    gsi::enum_const ("RubberBandMove", QMdiSubWindow::RubberBandMove, "@brief Enum constant QMdiSubWindow::RubberBandMove"),
  "@qt\n@brief This class represents the QMdiSubWindow::SubWindowOption enum");

static gsi::QFlagsClass<QMdiSubWindow::SubWindowOption > decl_QMdiSubWindow_SubWindowOption_Enums ("QtWidgets", "QMdiSubWindow_QFlags_SubWindowOption",
  "@qt\n@brief This class represents the QFlags<QMdiSubWindow::SubWindowOption> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QMdiSubWindow> inject_QMdiSubWindow_SubWindowOption_Enum_in_parent (decl_QMdiSubWindow_SubWindowOption_Enum.defs ());
static gsi::ClassExt<QMdiSubWindow> decl_QMdiSubWindow_SubWindowOption_Enum_as_child (decl_QMdiSubWindow_SubWindowOption_Enum, "SubWindowOption");
static gsi::ClassExt<QMdiSubWindow> decl_QMdiSubWindow_SubWindowOption_Enums_as_child (decl_QMdiSubWindow_SubWindowOption_Enums, "QFlags_SubWindowOption");

}

