/*
Cloud Hypervisor API

Local HTTP based API for managing and inspecting a cloud-hypervisor virtual machine.

API version: 0.3.0
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package openapi

import (
	"encoding/json"
)

// DeviceNode struct for DeviceNode
type DeviceNode struct {
	Id        *string                   `json:"id,omitempty"`
	Resources *[]map[string]interface{} `json:"resources,omitempty"`
	Children  *[]string                 `json:"children,omitempty"`
	PciBdf    *int32                    `json:"pci_bdf,omitempty"`
}

// NewDeviceNode instantiates a new DeviceNode object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewDeviceNode() *DeviceNode {
	this := DeviceNode{}
	return &this
}

// NewDeviceNodeWithDefaults instantiates a new DeviceNode object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewDeviceNodeWithDefaults() *DeviceNode {
	this := DeviceNode{}
	return &this
}

// GetId returns the Id field value if set, zero value otherwise.
func (o *DeviceNode) GetId() string {
	if o == nil || o.Id == nil {
		var ret string
		return ret
	}
	return *o.Id
}

// GetIdOk returns a tuple with the Id field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DeviceNode) GetIdOk() (*string, bool) {
	if o == nil || o.Id == nil {
		return nil, false
	}
	return o.Id, true
}

// HasId returns a boolean if a field has been set.
func (o *DeviceNode) HasId() bool {
	if o != nil && o.Id != nil {
		return true
	}

	return false
}

// SetId gets a reference to the given string and assigns it to the Id field.
func (o *DeviceNode) SetId(v string) {
	o.Id = &v
}

// GetResources returns the Resources field value if set, zero value otherwise.
func (o *DeviceNode) GetResources() []map[string]interface{} {
	if o == nil || o.Resources == nil {
		var ret []map[string]interface{}
		return ret
	}
	return *o.Resources
}

// GetResourcesOk returns a tuple with the Resources field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DeviceNode) GetResourcesOk() (*[]map[string]interface{}, bool) {
	if o == nil || o.Resources == nil {
		return nil, false
	}
	return o.Resources, true
}

// HasResources returns a boolean if a field has been set.
func (o *DeviceNode) HasResources() bool {
	if o != nil && o.Resources != nil {
		return true
	}

	return false
}

// SetResources gets a reference to the given []map[string]interface{} and assigns it to the Resources field.
func (o *DeviceNode) SetResources(v []map[string]interface{}) {
	o.Resources = &v
}

// GetChildren returns the Children field value if set, zero value otherwise.
func (o *DeviceNode) GetChildren() []string {
	if o == nil || o.Children == nil {
		var ret []string
		return ret
	}
	return *o.Children
}

// GetChildrenOk returns a tuple with the Children field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DeviceNode) GetChildrenOk() (*[]string, bool) {
	if o == nil || o.Children == nil {
		return nil, false
	}
	return o.Children, true
}

// HasChildren returns a boolean if a field has been set.
func (o *DeviceNode) HasChildren() bool {
	if o != nil && o.Children != nil {
		return true
	}

	return false
}

// SetChildren gets a reference to the given []string and assigns it to the Children field.
func (o *DeviceNode) SetChildren(v []string) {
	o.Children = &v
}

// GetPciBdf returns the PciBdf field value if set, zero value otherwise.
func (o *DeviceNode) GetPciBdf() int32 {
	if o == nil || o.PciBdf == nil {
		var ret int32
		return ret
	}
	return *o.PciBdf
}

// GetPciBdfOk returns a tuple with the PciBdf field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DeviceNode) GetPciBdfOk() (*int32, bool) {
	if o == nil || o.PciBdf == nil {
		return nil, false
	}
	return o.PciBdf, true
}

// HasPciBdf returns a boolean if a field has been set.
func (o *DeviceNode) HasPciBdf() bool {
	if o != nil && o.PciBdf != nil {
		return true
	}

	return false
}

// SetPciBdf gets a reference to the given int32 and assigns it to the PciBdf field.
func (o *DeviceNode) SetPciBdf(v int32) {
	o.PciBdf = &v
}

func (o DeviceNode) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Id != nil {
		toSerialize["id"] = o.Id
	}
	if o.Resources != nil {
		toSerialize["resources"] = o.Resources
	}
	if o.Children != nil {
		toSerialize["children"] = o.Children
	}
	if o.PciBdf != nil {
		toSerialize["pci_bdf"] = o.PciBdf
	}
	return json.Marshal(toSerialize)
}

type NullableDeviceNode struct {
	value *DeviceNode
	isSet bool
}

func (v NullableDeviceNode) Get() *DeviceNode {
	return v.value
}

func (v *NullableDeviceNode) Set(val *DeviceNode) {
	v.value = val
	v.isSet = true
}

func (v NullableDeviceNode) IsSet() bool {
	return v.isSet
}

func (v *NullableDeviceNode) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableDeviceNode(val *DeviceNode) *NullableDeviceNode {
	return &NullableDeviceNode{value: val, isSet: true}
}

func (v NullableDeviceNode) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableDeviceNode) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
