; This file was initially generated automatically from legacy documentation
; strings.  See source files in this directory for copyright and license
; information.

(in-package "ACL2")

(include-book "xdoc/top" :dir :system)

(defxdoc assume
  :parents (events)
  :short "A system for sharing assumptions across many theorems"
  :long "<p>We provide a simple table-based system for reusable assumptions.
 To the user, this system takes on the following interface:</p>

 @({
    (assume <term>)
       adds term to the local assumptions

    (unassume <term>)
       removes <term> from the local assumptions

    (conclude <name> <thm> :hints ... :rule-classes ...)
       like defth, but proves <thm> under the current assumptions
 })

 <p>For example, consider the following ACL2 rules:</p>

 @({
    (defthm natp-of-plus
      (implies (and (natp x)
                    (natp y))
               (natp (+ x y))))

    (defthm natp-of-minus
      (implies (and (natp x)
                    (natp y)
                    (< y x))
               (natp (- x y))))
 })

 <p>We can convert these into the assume/conclude style as follows:</p>

 @({
    (assume (natp x))
    (assume (natp y))
    (conclude natp-of-plus (natp (+ x y)))
    (conclude natp-of-minus (implies (< y x) (natp (- x y))))
 })

 <p>The @('assume') and @('unassume') commands are implicitly @(see local), so
 you can use @(see encapsulate) in addition to @('unassume') to limit the scope
 of your assumptions.</p>

 <p>The @('conclude') command recognizes @('thm')s of the following forms:</p>

 @({
     (implies (and hyp1 ... hypN) concl)
     (implies hyp1 concl)
     concl
 })

 <p>It augments the &lt;thm&gt; by injecting the current assumptions after the
 last hyp.  That is, we produce:</p>

 @({
    (implies (and hyp1 ... hypN assm1 ... assmK) concl)
    (implies (and hyp1 assm1 ... assmK) concl)
    (implies (and assm1 ... assmK) concl)
 })

 <p>We expect this to be appropriate most of the time, since shared hyps tend
 to be ``common'' sorts of things, e.g., type constraints, etc.  Meanwhile, the
 unshared hyps should tend to be more complicated and unusual, so we place them
 at the front of the rule in an effort to make ``fast failing'' rules.</p>")

(defxdoc debug-guards
  :parents (miscellaneous)
  :short "Identify the cause of a guard violation."
  :long "<p>If a function has an elaborate guard, it may be difficult to tell
 which part of the guard is being violated when a guard violation occurs.  The
 @('debug-guards') function may be useful in identifying the problem.</p>

 <p>Below is a trivial example.  We define a function with several inputs and
 require that each input be a natural.</p>

 @({
    ACL2 !> (defun f (a b c d e)
              (declare (xargs :guard (and (natp a)
                                          (natp b)
                                          (natp c)
                                          (natp d)
                                          (natp e))))
              (list a b c d e))
 })

 <p>We can now use debug-guards to see what would happen when we try to run
 this function on various arguments.  For example, perhaps we do not realize
 that the symbol d is not a natural.  Then, debug-guards will show us why this
 function call will fail:</p>

 @({
    ACL2 !> (debug-guards '(f 1 2 3 d 5))
    (NATP 1) ==> T
    (NATP 2) ==> T
    (NATP 3) ==> T
    (NATP 'D) ==> NIL
    (AND (NATP 1) (NATP 2) (NATP 3) (NATP 'D) (NATP 5)) ==> NIL
 })

 <p>The argument to debug-guards should be a quoted function call, but you can
 also perform evaluation ahead of time, e.g., using @('list') as follows:</p>

 @({
    ACL2 !> (defconst *d* 'd)

    ACL2 !> (debug-guards (list 'f 1 2 3 *d* 5))
    (NATP 1) ==> T
    (NATP 2) ==> T
    (NATP 3) ==> T
    (NATP 'D) ==> NIL
    (AND (NATP 1) (NATP 2) (NATP 3) (NATP 'D) (NATP 5)) ==> NIL
 })

 ")
